/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.qpcr;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.qpcr.Batch;
import org.systemsbiology.biotapestry.qpcr.QPCRData;
import org.systemsbiology.biotapestry.qpcr.QpcrTablePublisher;
import org.systemsbiology.biotapestry.qpcr.Source;
import org.systemsbiology.biotapestry.qpcr.TimeSpan;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.MinMax;
import org.xml.sax.Attributes;

class Perturbation {
    private ArrayList timeSpans_ = new ArrayList();
    private ArrayList investigators_;
    private ArrayList sources_;

    Perturbation() {
        this.investigators_ = new ArrayList();
        this.sources_ = new ArrayList();
    }

    Perturbation(Perturbation other) {
        Iterator otit = other.timeSpans_.iterator();
        while (otit.hasNext()) {
            this.timeSpans_.add(new TimeSpan((TimeSpan)otit.next()));
        }
        this.investigators_ = new ArrayList(other.investigators_);
        this.sources_ = new ArrayList();
        Iterator osit = other.sources_.iterator();
        while (osit.hasNext()) {
            this.sources_.add(new Source((Source)osit.next()));
        }
    }

    boolean isActiveAtTime(MinMax range) {
        Iterator tsit = this.getTimeSpans();
        while (tsit.hasNext()) {
            TimeSpan t = (TimeSpan)tsit.next();
            if (!t.getMinMaxSpan().equals(range) || !t.hasStandardTime()) continue;
            return true;
        }
        return false;
    }

    boolean sourcesMatch(List otherSources) {
        if (otherSources.size() != this.sources_.size()) {
            return false;
        }
        QPCRData.SourceComparator srcCmp = new QPCRData.SourceComparator();
        TreeSet mySorted = new TreeSet(srcCmp);
        mySorted.addAll(this.sources_);
        TreeSet otherSorted = new TreeSet(srcCmp);
        otherSorted.addAll(otherSources);
        Iterator msit = mySorted.iterator();
        Iterator osit = otherSorted.iterator();
        while (msit.hasNext()) {
            Source os;
            Source ms = (Source)msit.next();
            if (srcCmp.compare(ms, os = (Source)osit.next()) == 0) continue;
            return false;
        }
        return true;
    }

    void addSource(Source source) {
        this.sources_.add(source);
    }

    Iterator getSources() {
        return this.sources_.iterator();
    }

    int getSourceCount() {
        return this.sources_.size();
    }

    void deleteSource(int index) {
        this.sources_.remove(index);
    }

    Source getSource(int index) {
        return (Source)this.sources_.get(index);
    }

    String getCombinedSourceName(boolean useDisplayForSingle) {
        int num = this.sources_.size();
        if (num == 0) {
            return null;
        }
        if (num == 1) {
            if (useDisplayForSingle) {
                return ((Source)this.sources_.get(0)).getDisplayValue();
            }
            return ((Source)this.sources_.get(0)).getBaseType();
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < num; ++i) {
            Source src = (Source)this.sources_.get(i);
            buf.append(src.getDisplayValue());
            if (i >= num - 1) continue;
            buf.append(" + ");
        }
        return buf.toString();
    }

    void replaceSource(int index, Source src) {
        this.sources_.set(index, src);
    }

    void addInvestigator(String investigator) {
        this.investigators_.add(investigator);
    }

    void addInvestigatorIfNew(String investigator) {
        if (this.investigators_.contains(investigator)) {
            return;
        }
        this.investigators_.add(investigator);
    }

    void deleteInvestigator(int index) {
        this.investigators_.remove(index);
    }

    Iterator getInvestigators() {
        return this.investigators_.iterator();
    }

    String getInvestigator(int index) {
        return (String)this.investigators_.get(index);
    }

    void replaceInvestigator(int index, String invest) {
        this.investigators_.set(index, invest);
    }

    int getInvestigatorCount() {
        return this.investigators_.size();
    }

    void addTime(TimeSpan timeSpan) {
        this.timeSpans_.add(timeSpan);
    }

    void dropTime(MinMax span) {
        int num = this.timeSpans_.size();
        for (int i = 0; i < num; ++i) {
            TimeSpan ts = (TimeSpan)this.timeSpans_.get(i);
            if (!ts.getMinMaxSpan().equals(span)) continue;
            this.timeSpans_.remove(i);
            return;
        }
    }

    Iterator getTimeSpans() {
        return this.timeSpans_.iterator();
    }

    TimeSpan getTimeSpan(MinMax span) {
        Iterator tsit = this.getTimeSpans();
        while (tsit.hasNext()) {
            TimeSpan ts = (TimeSpan)tsit.next();
            if (!ts.getMinMaxSpan().equals(span)) continue;
            return ts;
        }
        return null;
    }

    Set getFootnoteNumbers() {
        HashSet retval = new HashSet();
        Iterator srcs = this.getSources();
        while (srcs.hasNext()) {
            Source src = (Source)srcs.next();
            List srcNotes = src.getFootnoteNumbers();
            retval.addAll(srcNotes);
        }
        Iterator times = this.getTimeSpans();
        while (times.hasNext()) {
            TimeSpan time = (TimeSpan)times.next();
            Set notes = time.getFootnoteNumbers();
            retval.addAll(notes);
        }
        return retval;
    }

    String displayString(boolean footnotes) {
        StringBuffer buf = new StringBuffer();
        Iterator sit = this.getSources();
        while (sit.hasNext()) {
            String notes;
            Source src = (Source)sit.next();
            buf.append(src.getDisplayValue());
            if (footnotes && (notes = src.getNotes()) != null) {
                buf.append(" [");
                buf.append(notes);
                buf.append("]");
            }
            if (!sit.hasNext()) continue;
            buf.append(" + ");
        }
        return buf.toString();
    }

    void prepForHTML(List mapList, List srcNames) {
        if (srcNames != null) {
            boolean gotIt = false;
            Iterator srcIt = this.sources_.iterator();
            while (srcIt.hasNext()) {
                Source src = (Source)srcIt.next();
                if (!DataUtil.containsKey(srcNames, src.getBaseType())) continue;
                gotIt = true;
                break;
            }
            if (!gotIt) {
                return;
            }
        }
        mapList.add(this.groupByInvestigator());
    }

    boolean matchesForHTML(List srcNames) {
        if (srcNames != null) {
            boolean gotIt = false;
            Iterator srcIt = this.sources_.iterator();
            while (srcIt.hasNext()) {
                Source src = (Source)srcIt.next();
                if (!DataUtil.containsKey(srcNames, src.getBaseType())) continue;
                gotIt = true;
                break;
            }
            if (!gotIt) {
                return false;
            }
        }
        return true;
    }

    boolean writeHTML(PrintWriter out, Indenter ind, String geneTag, int numRows, ArrayList timeCols, QpcrTablePublisher qtp, SortedMap gbi, boolean breakOutInvest, List srcNames) {
        if (!this.matchesForHTML(srcNames)) {
            return false;
        }
        ind.indent();
        out.println("<tr valign=\"top\">");
        ind.up();
        if (geneTag != null) {
            ind.indent();
            out.print("<td");
            if (numRows > 1) {
                out.print(" rowspan=\"");
                out.print(numRows);
                out.print("\" ");
            }
            out.println(">");
            ind.up().indent();
            qtp.paragraph(false);
            out.print("<i><b>");
            out.print(geneTag);
            out.println("</b></i></p>");
            ind.down().indent();
            out.println("</td>");
        }
        ind.indent();
        int srcRows = gbi != null ? gbi.keySet().size() : 1;
        out.print("<td");
        if (srcRows > 1) {
            out.print(" rowspan=\"");
            out.print(srcRows);
            out.print("\" ");
        }
        out.println(">");
        ind.up();
        Iterator srcs = this.getSources();
        while (srcs.hasNext()) {
            Source src = (Source)srcs.next();
            src.writeHTML(out, ind, srcs.hasNext(), qtp, false);
        }
        ind.down().indent();
        out.println("</td>");
        HashMap<MinMax, TimeSpan.SpanTimeProfile> timeProfs = new HashMap<MinMax, TimeSpan.SpanTimeProfile>();
        Iterator times = this.timeSpans_.iterator();
        while (times.hasNext()) {
            TimeSpan time = (TimeSpan)times.next();
            TimeSpan.SpanTimeProfile stp = time.getBatchTimeProfile();
            timeProfs.put(time.getMinMaxSpan(), stp);
        }
        if (breakOutInvest) {
            Iterator gbiit = gbi.keySet().iterator();
            while (gbiit.hasNext()) {
                String invest = (String)gbiit.next();
                HashMap byInv = (HashMap)gbi.get(invest);
                this.writeOutTimeSpans(out, ind, qtp, timeCols, new ArrayList(byInv.values()), timeProfs);
                if (invest.equals("WJRL_HACKASTIC_KLUDGE")) {
                    this.writeOutInvestigators(out, ind, qtp, null, 0);
                } else {
                    List investList = Perturbation.unformatInvestigators(invest);
                    this.writeOutInvestigators(out, ind, qtp, investList.iterator(), investList.size());
                }
                ind.down().indent();
                out.println("</tr>");
            }
        } else {
            this.writeOutTimeSpans(out, ind, qtp, timeCols, this.timeSpans_, timeProfs);
            Iterator iit = this.getInvestigators();
            int icount = this.investigators_.size();
            this.writeOutInvestigators(out, ind, qtp, iit, icount);
            ind.down().indent();
            out.println("</tr>");
        }
        return true;
    }

    void writeOutTimeSpans(PrintWriter out, Indenter ind, QpcrTablePublisher qtp, List timeCols, List timeSpans, Map timeProfs) {
        Iterator tcit = timeCols.iterator();
        while (tcit.hasNext()) {
            MinMax tcol = (MinMax)tcit.next();
            ind.indent();
            out.println("<td>");
            ind.up();
            Iterator times = timeSpans.iterator();
            boolean haveMatch = false;
            while (times.hasNext()) {
                TimeSpan time = (TimeSpan)times.next();
                MinMax mms = time.getMinMaxSpan();
                if (!mms.equals(tcol)) continue;
                TimeSpan.SpanTimeProfile stp = (TimeSpan.SpanTimeProfile)timeProfs.get(mms);
                time.writeHTML(out, ind, qtp, stp);
                haveMatch = true;
                break;
            }
            if (!haveMatch) {
                ind.indent();
                out.println("<p><br></p>");
            }
            ind.down().indent();
            out.println("</td>");
        }
    }

    void writeOutInvestigators(PrintWriter out, Indenter ind, QpcrTablePublisher qtp, Iterator iit, int icount) {
        ind.indent();
        out.println("<td>");
        ind.up();
        if (icount == 0) {
            out.println("<p>&nbsp;</p>");
        } else {
            while (iit.hasNext()) {
                String inv = (String)iit.next();
                ind.indent();
                if (icount > 0) {
                    qtp.paragraph(false);
                } else {
                    out.print("<p>");
                }
                out.print(inv);
                if (--icount == 1) {
                    out.print(" &amp;");
                } else if (icount > 0) {
                    out.print(",");
                }
                out.println("</p>");
            }
        }
        ind.down().indent();
        out.println("</td>");
    }

    SortedMap groupByInvestigator() {
        TreeMap byInvest = new TreeMap();
        Iterator times = this.getTimeSpans();
        while (times.hasNext()) {
            TimeSpan time = (TimeSpan)times.next();
            Iterator bit = time.getBatches();
            while (bit.hasNext()) {
                MinMax tmm;
                TimeSpan tsByInv;
                HashMap<MinMax, TimeSpan> tsMapByInv;
                Batch bat = (Batch)bit.next();
                String invest = bat.getInvestigators();
                if (invest == null || invest.trim().equals("")) {
                    invest = "WJRL_HACKASTIC_KLUDGE";
                }
                if ((tsMapByInv = (HashMap<MinMax, TimeSpan>)byInvest.get(invest)) == null) {
                    tsMapByInv = new HashMap<MinMax, TimeSpan>();
                    byInvest.put(invest, tsMapByInv);
                }
                if ((tsByInv = (TimeSpan)tsMapByInv.get(tmm = time.getMinMaxSpan())) == null) {
                    tsByInv = new TimeSpan(tmm);
                    if (time.haveRegionRestrictions()) {
                        Iterator grrit = time.getRegionRestrictions();
                        while (grrit.hasNext()) {
                            tsByInv.addRegionRestriction((String)grrit.next());
                        }
                    }
                    tsMapByInv.put(tmm, tsByInv);
                }
                tsByInv.addBatch((Batch)bat.clone());
            }
        }
        return byInvest;
    }

    static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("perturbation");
        retval.add("sources");
        retval.add("investigators");
        retval.add("times");
        return retval;
    }

    static String nameKeyword() {
        return "name";
    }

    public String toString() {
        return "Perturbation: sources = " + this.sources_ + " inv = " + this.investigators_ + " timeSpans = " + this.timeSpans_;
    }

    static Perturbation buildFromXML(String elemName, Attributes attrs) throws IOException {
        if (!elemName.equals("perturbation")) {
            return null;
        }
        return new Perturbation();
    }

    static String formatInvestigators(List investList) {
        StringBuffer buf = new StringBuffer();
        Iterator iit = investList.iterator();
        int icount = investList.size();
        while (iit.hasNext()) {
            String inv = (String)iit.next();
            buf.append(inv);
            if (--icount == 1) {
                buf.append(" & ");
                continue;
            }
            if (icount <= 0) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    static List unformatInvestigators(String invest) {
        ArrayList<String> retval = new ArrayList<String>();
        invest = invest.replaceAll("&", ",");
        String[] result = invest.split(",");
        int numRes = result.length;
        for (int i = 0; i < numRes; ++i) {
            retval.add(result[i].trim());
        }
        return retval;
    }
}

