/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.qpcr;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.perturb.ConditionDictionary;
import org.systemsbiology.biotapestry.perturb.LegacyPert;
import org.systemsbiology.biotapestry.perturb.MeasureDictionary;
import org.systemsbiology.biotapestry.perturb.PertDataPoint;
import org.systemsbiology.biotapestry.perturb.PertDictionary;
import org.systemsbiology.biotapestry.perturb.PertSource;
import org.systemsbiology.biotapestry.perturb.PertSources;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.qpcr.Batch;
import org.systemsbiology.biotapestry.qpcr.Footnote;
import org.systemsbiology.biotapestry.qpcr.Measurement;
import org.systemsbiology.biotapestry.qpcr.NullPerturb;
import org.systemsbiology.biotapestry.qpcr.NullTarget;
import org.systemsbiology.biotapestry.qpcr.NullTimeSpan;
import org.systemsbiology.biotapestry.qpcr.Perturbation;
import org.systemsbiology.biotapestry.qpcr.QpcrTablePublisher;
import org.systemsbiology.biotapestry.qpcr.Source;
import org.systemsbiology.biotapestry.qpcr.TargetGene;
import org.systemsbiology.biotapestry.qpcr.TimeSpan;
import org.systemsbiology.biotapestry.ui.DisplayOptions;
import org.systemsbiology.biotapestry.ui.DisplayOptionsManager;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.MinMax;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.xml.sax.Attributes;

class QPCRData {
    private static final String DUMMY_NULL_TARG_KEY_ = "__WJRL_HacKasTic_GenE_NamE__";
    private static final int HEADING_SPACING_ = 18;
    private ArrayList genes_ = new ArrayList();
    private ArrayList nullPerturbations_ = new ArrayList();
    private NullTimeSpan nullPertDefaultSpan_ = null;
    private ArrayList footnotes_ = new ArrayList();
    private ArrayList timeSpanCols_ = new ArrayList();
    private HashMap entryMap_ = new HashMap();
    private HashMap sourceMap_ = new HashMap();
    private double threshold_ = 1.6;
    private long serialNumber_ = 0L;

    QPCRData() {
    }

    void transferFromLegacy() {
        PerturbationData pd = Database.getDB().getPertData();
        PertDictionary pDict = pd.getPertDictionary();
        MeasureDictionary mDict = pd.getMeasureDictionary();
        ConditionDictionary cDict = pd.getConditionDictionary();
        String legCondition = cDict.getStandardConditionKey();
        String legMeasure = mDict.createLegacyMeasureProps(this.threshold_);
        DisplayOptions dOpt = DisplayOptionsManager.getMgr().getDisplayOptions();
        dOpt.setColumns(this.getColumns());
        long timeStamp = System.currentTimeMillis();
        ArrayList unkInvs = new ArrayList();
        HashMap annotsForSrcs = new HashMap();
        HashMap annotsToData = new HashMap();
        this.factorSourceAnnots(pd, pDict, annotsForSrcs, annotsToData);
        int numGenes = this.genes_.size();
        for (int i = 0; i < numGenes; ++i) {
            TargetGene tgene = (TargetGene)this.genes_.get(i);
            List gnotes = tgene.getTranslatedNotes();
            List gidList = this.footNumsToIDs(pd, gnotes);
            String targName = tgene.getName();
            PerturbationData.KeyAndDataChange kadc = pd.provideTarget(targName);
            String targKey = kadc.key;
            if (!gidList.isEmpty()) {
                pd.setFootnotesForTargetIO(targKey, gidList);
            }
            Iterator pit = tgene.getPerturbations();
            while (pit.hasNext()) {
                Perturbation prt = (Perturbation)pit.next();
                ArrayList<String> srcList = new ArrayList<String>();
                Iterator sit1 = prt.getSources();
                Set keypss = this.perturbationToKey(pd, pDict, sit1, new ArrayList());
                Set retainNotes = ((HashMap)annotsForSrcs.get(keypss)).keySet();
                HashMap notesToTargs = (HashMap)annotsToData.get(keypss);
                Iterator sit = prt.getSources();
                while (sit.hasNext()) {
                    Source src = (Source)sit.next();
                    String srcID = this.sourceToPertSource(src, pd, pDict, retainNotes);
                    srcList.add(srcID);
                }
                ArrayList<String> pInvestList = new ArrayList<String>();
                Iterator piit = prt.getInvestigators();
                while (piit.hasNext()) {
                    String inv = (String)piit.next();
                    pInvestList.add(inv);
                }
                PertSources srcs = new PertSources(srcList);
                Iterator tsit = prt.getTimeSpans();
                while (tsit.hasNext()) {
                    TimeSpan tspan = (TimeSpan)tsit.next();
                    PerturbationData.RegionRestrict rr = null;
                    Iterator rrit = tspan.getRegionRestrictions();
                    if (rrit.hasNext()) {
                        ArrayList<String> regionList = new ArrayList<String>();
                        while (rrit.hasNext()) {
                            String regID = (String)rrit.next();
                            regionList.add(regID);
                        }
                        rr = new PerturbationData.RegionRestrict(regionList);
                    }
                    MinMax spanTimes = tspan.getMinMaxSpan();
                    Iterator tbit = tspan.getBatches();
                    int subBatchKey = 0;
                    while (tbit.hasNext()) {
                        String batchKey;
                        int useMin;
                        Batch batch = (Batch)tbit.next();
                        String invests = batch.getInvestigators();
                        List investList = invests != null ? Perturbation.unformatInvestigators(invests) : pInvestList;
                        ArrayList<String> invKeyList = new ArrayList<String>();
                        if (investList.isEmpty()) {
                            invKeyList = unkInvs;
                        } else {
                            int numI = investList.size();
                            for (int j = 0; j < numI; ++j) {
                                String invest = (String)investList.get(j);
                                invKeyList.add(pd.provideInvestigator((String)invest).key);
                            }
                        }
                        int batchTime = batch.getTimeNumber();
                        int legacyMax = -1;
                        int n = useMin = batchTime == -1 ? spanTimes.min : batchTime;
                        if (batchTime == -1 && spanTimes.min != spanTimes.max) {
                            legacyMax = spanTimes.max;
                        }
                        if ((batchKey = batch.getBatchKey()) == null) {
                            String maxStr = legacyMax == -1 ? "" : "_" + Integer.toString(legacyMax);
                            batchKey = "_BT_" + Integer.toString(useMin) + maxStr + "::" + subBatchKey++;
                        } else {
                            batchKey = batchKey.replaceAll(" ", "");
                        }
                        String date = batch.getDate();
                        String psiKey = pd.provideExperiment((PertSources)srcs, (int)useMin, (int)legacyMax, invKeyList, (String)legCondition).key;
                        Iterator bit = batch.getMeasurements();
                        while (bit.hasNext()) {
                            Measurement mea = (Measurement)bit.next();
                            this.exportMeasurement(mea, pd, srcs, psiKey, timeStamp, targKey, batchKey, date, legMeasure, invKeyList, rr, notesToTargs, DataUtil.normKey(targName), legCondition);
                        }
                    }
                }
            }
        }
        NullTimeSpan dnts = this.getLegacyNullPerturbationsDefaultTimeSpan();
        int numNull = this.nullPerturbations_.size();
        for (int i = 0; i < numNull; ++i) {
            NullPerturb np = (NullPerturb)this.nullPerturbations_.get(i);
            Iterator sit1 = np.getSources();
            Set keypss = this.perturbationToKey(pd, pDict, sit1, new ArrayList());
            HashMap notesToTargs = (HashMap)annotsToData.get(keypss);
            Set retainNotes = ((HashMap)annotsForSrcs.get(keypss)).keySet();
            ArrayList<String> srcList = new ArrayList<String>();
            Iterator sit = np.getSources();
            while (sit.hasNext()) {
                Source src = (Source)sit.next();
                String srcID = this.sourceToPertSource(src, pd, pDict, retainNotes);
                srcList.add(srcID);
            }
            PertSources srcs = new PertSources(srcList);
            MinMax fallbackTime = new MinMax(dnts.getMin(), dnts.getMax());
            Iterator nit = np.getTargets();
            while (nit.hasNext()) {
                Iterator spit;
                int numTimes;
                NullTarget nt = (NullTarget)nit.next();
                String targName = nt.getTarget();
                PerturbationData.KeyAndDataChange kadc = pd.provideTarget(targName);
                String targKey = kadc.key;
                String regRestrict = nt.getRegionRestriction();
                PerturbationData.RegionRestrict rr = null;
                if (regRestrict != null) {
                    rr = new PerturbationData.RegionRestrict(regRestrict);
                }
                if ((numTimes = nt.getTimesCount()) == 0) {
                    this.exportNoDataNullMeasurement(fallbackTime.min, fallbackTime.max, pd, srcs, unkInvs, timeStamp, targKey, legMeasure, rr, notesToTargs, legCondition);
                }
                if (nt.getBatchCount() == 0) {
                    if (numTimes <= 0) continue;
                    Iterator tmit = nt.getTimes();
                    while (tmit.hasNext()) {
                        int maxTime;
                        int minTime;
                        NullTimeSpan nts = (NullTimeSpan)tmit.next();
                        if (nts.isASpan()) {
                            minTime = nts.getMin();
                            maxTime = nts.getMax();
                        } else {
                            minTime = nts.getTime();
                            maxTime = -1;
                        }
                        this.exportNoDataNullMeasurement(minTime, maxTime, pd, srcs, unkInvs, timeStamp, targKey, legMeasure, rr, notesToTargs, legCondition);
                    }
                    continue;
                }
                if (numTimes > 0) {
                    spit = nt.getSupportData();
                    HashSet<Integer> dataNums = new HashSet<Integer>();
                    while (spit.hasNext()) {
                        Batch ntb = (Batch)spit.next();
                        int batchTime = ntb.getTimeNumber();
                        dataNums.add(new Integer(batchTime));
                    }
                    Iterator tmit = nt.getTimes();
                    while (tmit.hasNext()) {
                        int maxTime;
                        int minTime;
                        NullTimeSpan nts = (NullTimeSpan)tmit.next();
                        if (nts.isASpan()) {
                            minTime = nts.getMin();
                            maxTime = nts.getMax();
                            if (dataNums.contains(new Integer(minTime)) && dataNums.contains(new Integer(maxTime))) {
                                continue;
                            }
                        } else {
                            minTime = nts.getTime();
                            maxTime = -1;
                            if (dataNums.contains(new Integer(minTime))) continue;
                        }
                        this.exportNoDataNullMeasurement(minTime, maxTime, pd, srcs, unkInvs, timeStamp, targKey, legMeasure, rr, notesToTargs, legCondition);
                    }
                }
                spit = nt.getSupportData();
                int subBatchKey = 0;
                while (spit.hasNext()) {
                    Batch ntb = (Batch)spit.next();
                    String invests = ntb.getInvestigators();
                    List investList = Perturbation.unformatInvestigators(invests);
                    ArrayList<String> invKeyList = new ArrayList<String>();
                    if (investList.isEmpty()) {
                        invKeyList = unkInvs;
                    } else {
                        int numI = investList.size();
                        for (int j = 0; j < numI; ++j) {
                            String invest = (String)investList.get(j);
                            invKeyList.add(pd.provideInvestigator((String)invest).key);
                        }
                    }
                    int batchTime = ntb.getTimeNumber();
                    String batchKey = ntb.getBatchKey();
                    batchKey = batchKey == null ? "_BT_" + Integer.toString(batchTime) + "::" + subBatchKey++ : batchKey.replaceAll(" ", "");
                    String date = ntb.getDate();
                    String psiKey = pd.provideExperiment((PertSources)srcs, (int)batchTime, (int)-1, invKeyList, (String)legCondition).key;
                    Iterator bit = ntb.getMeasurements();
                    while (bit.hasNext()) {
                        Measurement mea = (Measurement)bit.next();
                        this.exportMeasurement(mea, pd, srcs, psiKey, timeStamp, targKey, batchKey, date, legMeasure, invKeyList, rr, notesToTargs, DUMMY_NULL_TARG_KEY_, legCondition);
                    }
                }
            }
        }
        Iterator emit = this.entryMap_.keySet().iterator();
        while (emit.hasNext()) {
            String eKey = (String)emit.next();
            ArrayList forKey = (ArrayList)this.entryMap_.get(eKey);
            pd.importLegacyEntryMapEntry(eKey, forKey);
        }
        Iterator smit = this.sourceMap_.keySet().iterator();
        while (smit.hasNext()) {
            String sKey = (String)smit.next();
            ArrayList forKey = (ArrayList)this.sourceMap_.get(sKey);
            pd.importLegacySourceMapEntry(sKey, forKey);
        }
        this.genes_.clear();
        this.nullPerturbations_.clear();
        this.entryMap_.clear();
        this.sourceMap_.clear();
    }

    private void exportNoDataNullMeasurement(int minTime, int maxTime, PerturbationData pd, PertSources srcs, List unkInvs, long timeStamp, String targKey, String legMeasure, PerturbationData.RegionRestrict regRestrict, HashMap notesToTargs, String legCondition) {
        ArrayList<String> idList = new ArrayList<String>();
        if (notesToTargs != null) {
            Iterator nttkit = notesToTargs.keySet().iterator();
            while (nttkit.hasNext()) {
                String noteID = (String)nttkit.next();
                HashSet forTargs = (HashSet)notesToTargs.get(noteID);
                if (!forTargs.contains(DUMMY_NULL_TARG_KEY_)) continue;
                idList.add(noteID);
            }
        }
        String psiKey = pd.provideExperiment((PertSources)srcs, (int)minTime, (int)maxTime, (List)unkInvs, (String)legCondition).key;
        PertDataPoint pdp = new PertDataPoint(pd.getNextDataKey(), timeStamp, psiKey, targKey, legMeasure, 0.0);
        LegacyPert lp = new LegacyPert("NS", true);
        String maxStr = maxTime == -1 ? "" : "_" + Integer.toString(maxTime);
        String batchKey = "_BT_" + Integer.toString(minTime) + maxStr + "::0";
        pdp.setBatchKey(batchKey);
        pdp.setLegacyPert(lp);
        pdp.setIsSig(null);
        pd.addDataPointForIO(pdp);
        if (regRestrict != null) {
            pd.setRegionRestrictionForDataPointForIO(pdp.getID(), regRestrict);
        }
        if (!idList.isEmpty()) {
            pd.setFootnotesForDataPointForIO(pdp.getID(), idList);
        }
    }

    private Set perturbationToKey(PerturbationData pd, PertDictionary pDict, Iterator sit, List allFoots) {
        ArrayList emptyList = new ArrayList();
        HashSet<PertSource> allSrcs = new HashSet<PertSource>();
        while (sit.hasNext()) {
            Source src = (Source)sit.next();
            String base = src.getBaseType();
            String expr = src.getExpType();
            String pertKey = pDict.getPerturbPropsFromName(expr);
            if (pertKey == null) {
                throw new IllegalStateException();
            }
            List sfoots = src.getFootnoteNumbers();
            allFoots.addAll(this.footNumsToIDs(pd, sfoots));
            PertSource ps = new PertSource("", DataUtil.normKey(base), pertKey, emptyList);
            allSrcs.add(ps);
        }
        return allSrcs;
    }

    private void factorSourceAnnots(PerturbationData pd, PertDictionary pDict, HashMap annotsForSrcs, HashMap annotsToData) {
        int numGenes = this.genes_.size();
        for (int i = 0; i < numGenes; ++i) {
            TargetGene tgene = (TargetGene)this.genes_.get(i);
            String normName = DataUtil.normKey(tgene.getName());
            Iterator pit = tgene.getPerturbations();
            while (pit.hasNext()) {
                Perturbation prt = (Perturbation)pit.next();
                ArrayList allFoots = new ArrayList();
                Set pssk = this.perturbationToKey(pd, pDict, prt.getSources(), allFoots);
                this.factorSourceAnnotsGuts(normName, pssk, allFoots, annotsForSrcs, annotsToData);
            }
        }
        int numNull = this.nullPerturbations_.size();
        for (int i = 0; i < numNull; ++i) {
            NullPerturb np = (NullPerturb)this.nullPerturbations_.get(i);
            ArrayList allFoots = new ArrayList();
            Set pssk = this.perturbationToKey(pd, pDict, np.getSources(), allFoots);
            this.factorSourceAnnotsGuts(DUMMY_NULL_TARG_KEY_, pssk, allFoots, annotsForSrcs, annotsToData);
        }
    }

    private void factorSourceAnnotsGuts(String targetName, Set pssk, List allFoots, HashMap annotsForSrcs, HashMap annotsToData) {
        HashSet idSet = new HashSet(allFoots);
        HashMap notes = (HashMap)annotsForSrcs.get(pssk);
        HashMap<String, HashSet<String>> goesToData = (HashMap<String, HashSet<String>>)annotsToData.get(pssk);
        if (notes == null) {
            notes = new HashMap();
            annotsForSrcs.put(pssk, notes);
            Iterator idsit = idSet.iterator();
            while (idsit.hasNext()) {
                String noteID = (String)idsit.next();
                HashSet<String> forNote = new HashSet<String>();
                notes.put(noteID, forNote);
                forNote.add(targetName);
            }
        } else {
            if (goesToData != null) {
                HashSet intersectToData = new HashSet(goesToData.keySet());
                intersectToData.retainAll(idSet);
                Iterator i2dit = intersectToData.iterator();
                while (i2dit.hasNext()) {
                    String noteID = (String)i2dit.next();
                    HashSet toDatForTargs = (HashSet)goesToData.get(noteID);
                    toDatForTargs.add(targetName);
                    idSet.remove(noteID);
                }
            }
            HashSet allKeys = new HashSet(notes.keySet());
            HashSet intersect = (HashSet)allKeys.clone();
            intersect.retainAll(idSet);
            if (goesToData == null) {
                goesToData = new HashMap<String, HashSet<String>>();
                annotsToData.put(pssk, goesToData);
            }
            Iterator akit = allKeys.iterator();
            while (akit.hasNext()) {
                HashSet forTrgs;
                String noteKey = (String)akit.next();
                if (!intersect.contains(noteKey)) {
                    forTrgs = (HashSet)notes.remove(noteKey);
                    Iterator ftit = forTrgs.iterator();
                    while (ftit.hasNext()) {
                        String targ = (String)ftit.next();
                        HashSet<String> toDatForTargs = (HashSet<String>)goesToData.get(noteKey);
                        if (toDatForTargs == null) {
                            toDatForTargs = new HashSet<String>();
                            goesToData.put(noteKey, toDatForTargs);
                        }
                        toDatForTargs.add(targ);
                    }
                    continue;
                }
                forTrgs = (HashSet)notes.get(noteKey);
                forTrgs.add(targetName);
            }
            idSet.removeAll(intersect);
            Iterator idit = idSet.iterator();
            while (idit.hasNext()) {
                String noteID = (String)idit.next();
                HashSet<String> toDatForTargs = (HashSet<String>)goesToData.get(noteID);
                if (toDatForTargs == null) {
                    toDatForTargs = new HashSet<String>();
                    goesToData.put(noteID, toDatForTargs);
                }
                toDatForTargs.add(targetName);
            }
        }
    }

    private String sourceToPertSource(Source src, PerturbationData pd, PertDictionary pDict, Set retainNotes) {
        String base = src.getBaseType();
        PerturbationData.KeyAndDataChange kdac = pd.providePertSrcName(base);
        String expr = src.getExpType();
        List sfoots = src.getFootnoteNumbers();
        String pSign = src.getProxySign();
        pSign = PertSource.mapLegacyProxySign(pSign);
        String proxNameID = null;
        if (!pSign.equals("noProxy")) {
            String proxyFor = src.getProxiedSpecies();
            PerturbationData.KeyAndDataChange kdac2 = pd.providePertSrcName(proxyFor);
            proxNameID = kdac2.key;
        }
        List idList = this.footNumsToIDs(pd, sfoots);
        String pertKey = pDict.getPerturbPropsFromName(expr);
        if (pertKey == null) {
            throw new IllegalStateException();
        }
        ArrayList<String> useList = new ArrayList<String>();
        int numL = idList.size();
        for (int i = 0; i < numL; ++i) {
            String annotID = (String)idList.get(i);
            if (!retainNotes.contains(annotID)) continue;
            useList.add(annotID);
        }
        PerturbationData.KeyAndDataChange kdac3 = pd.providePertSrc(kdac.key, pertKey, proxNameID, pSign, useList, false);
        return kdac3.key;
    }

    private List footNumsToIDs(PerturbationData pd, List noteList) {
        Map footMsg = this.translateFootNumbers(noteList);
        Iterator fmit = footMsg.keySet().iterator();
        ArrayList<String> idList = new ArrayList<String>();
        while (fmit.hasNext()) {
            String msg;
            String key = (String)fmit.next();
            String msgID = pd.addLegacyMessage(key, msg = (String)footMsg.get(key));
            if (msgID == null) {
                throw new IllegalStateException();
            }
            idList.add(msgID);
        }
        return idList;
    }

    private void exportMeasurement(Measurement mea, PerturbationData pd, PertSources srcs, String psiKey, long timeStamp, String targKey, String batchKey, String date, String legMeasure, List invKeyList, PerturbationData.RegionRestrict regRestrict, HashMap notesToTargs, String useKey, String legCondition) {
        Object valObj = this.getMeANumber(mea);
        double value = 0.0;
        LegacyPert lv = null;
        if (valObj instanceof Double) {
            value = (Double)valObj;
        } else {
            lv = (LegacyPert)valObj;
        }
        Boolean isSig = mea.getIsSignificant();
        if (lv == null) {
            if (Math.abs(value) >= this.threshold_) {
                if (isSig.booleanValue()) {
                    isSig = null;
                }
            } else if (!isSig.booleanValue()) {
                isSig = null;
            }
        }
        String ctrl = mea.getControl();
        String comment = mea.getComment();
        Integer legNonStandard = mea.getTime();
        List noteList = mea.getFootnoteNumbers();
        List idList = this.footNumsToIDs(pd, noteList);
        if (notesToTargs != null) {
            Iterator nttkit = notesToTargs.keySet().iterator();
            while (nttkit.hasNext()) {
                String noteID = (String)nttkit.next();
                HashSet forTargs = (HashSet)notesToTargs.get(noteID);
                if (!forTargs.contains(useKey)) continue;
                idList.add(noteID);
            }
        }
        String usePsiKey = psiKey;
        if (legNonStandard != null) {
            usePsiKey = pd.provideExperiment((PertSources)srcs, (int)legNonStandard.intValue(), (int)-1, (List)invKeyList, (String)legCondition).key;
        }
        PertDataPoint pdp = new PertDataPoint(pd.getNextDataKey(), timeStamp, usePsiKey, targKey, legMeasure, value);
        if (!idList.isEmpty()) {
            pd.setFootnotesForDataPointForIO(pdp.getID(), idList);
        }
        if (lv != null) {
            pdp.setLegacyPert(lv);
            pdp.setIsSig(null);
        } else if (isSig != null) {
            pdp.setIsSig(isSig);
        }
        pdp.setBatchKey(batchKey);
        pdp.setDate(date);
        pdp.setComment(comment);
        if (ctrl != null && !ctrl.trim().equals("")) {
            PerturbationData.KeyAndDataChange kdac = pd.provideExpControl(ctrl);
            pdp.setControl(kdac.key);
        }
        pd.addDataPointForIO(pdp);
        if (regRestrict != null) {
            pd.setRegionRestrictionForDataPointForIO(pdp.getID(), regRestrict);
        }
    }

    private Map translateFootNumbers(List footList) {
        HashMap<String, String> retval = new HashMap<String, String>();
        int numFL = footList.size();
        for (int i = 0; i < numFL; ++i) {
            String flNum = (String)footList.get(i);
            int numf = this.footnotes_.size();
            for (int j = 0; j < numf; ++j) {
                Footnote fn = (Footnote)this.footnotes_.get(j);
                String num = fn.getNumber();
                if (!num.equals(flNum)) continue;
                retval.put(num, fn.getNote());
            }
        }
        return retval;
    }

    private Object getMeANumber(Measurement m) {
        String val = m.getValue();
        if (val == null) {
            return new LegacyPert(val);
        }
        try {
            Double valObj = new Double(val);
            return valObj;
        }
        catch (NumberFormatException nfe) {
            return new LegacyPert(val);
        }
    }

    long getSerialNumber() {
        return this.serialNumber_;
    }

    void setSerialNumber(long serialNumber) {
        this.serialNumber_ = serialNumber;
    }

    double getThresholdValue() {
        return this.threshold_;
    }

    boolean thresholdLocked() {
        return this.genes_.size() > 0 || this.nullPerturbations_.size() > 0;
    }

    boolean haveData() {
        if (this.genes_.size() > 0) {
            return true;
        }
        if (this.nullPerturbations_.size() > 0) {
            return true;
        }
        if (this.footnotes_.size() > 0) {
            return true;
        }
        if (this.timeSpanCols_ != null && this.timeSpanCols_.size() > 0) {
            return true;
        }
        if (this.entryMap_.size() > 0) {
            return true;
        }
        return this.sourceMap_.size() > 0;
    }

    void addGene(TargetGene gene, boolean bumpSerial) {
        this.genes_.add(gene);
    }

    Iterator getGenes() {
        return this.genes_.iterator();
    }

    boolean hasDefaultTimeSpan() {
        return this.nullPertDefaultSpan_ != null;
    }

    boolean hasNullPerturbations() {
        return !this.nullPerturbations_.isEmpty();
    }

    void addNullPerturbation(NullPerturb np) {
        this.nullPerturbations_.add(np);
    }

    Iterator getNullPerturbations() {
        return this.nullPerturbations_.iterator();
    }

    NullPerturb getNullPerturbation(int index) {
        return (NullPerturb)this.nullPerturbations_.get(index);
    }

    NullTimeSpan getLegacyNullPerturbationsDefaultTimeSpan() {
        if (this.nullPertDefaultSpan_ == null) {
            MinMax mm = Database.getDB().getTimeAxisDefinition().getDefaultTimeSpan();
            return new NullTimeSpan(mm.min, mm.max);
        }
        return this.nullPertDefaultSpan_;
    }

    void setNullPerturbationsDefaultTimeSpan(NullTimeSpan span) {
        this.nullPertDefaultSpan_ = span;
    }

    void addFootnote(Footnote note) {
        this.footnotes_.add(note);
    }

    void dropFootnotes() {
        this.footnotes_.clear();
    }

    Iterator getFootnotes() {
        return this.footnotes_.iterator();
    }

    void setColumns(ArrayList columns) {
        this.timeSpanCols_ = columns;
    }

    void addColumn(MinMax col) {
        this.timeSpanCols_.add(col);
    }

    void addColumn(int min, int max) {
        this.timeSpanCols_.add(new MinMax(min, max));
    }

    boolean columnDefinitionsUsed() {
        TargetGene tg;
        Iterator pit;
        Iterator git = this.getGenes();
        if (git.hasNext() && (pit = (tg = (TargetGene)git.next()).getPerturbations()).hasNext()) {
            Perturbation pert = (Perturbation)pit.next();
            Iterator sit = pert.getTimeSpans();
            return sit.hasNext();
        }
        return false;
    }

    ArrayList getColumns() {
        return this.timeSpanCols_;
    }

    Iterator getColumnIterator() {
        return this.timeSpanCols_.iterator();
    }

    boolean hasColumns() {
        return this.timeSpanCols_.size() > 0;
    }

    static int getMinimum(String colVal) {
        return QPCRData.getMaxOrMin(colVal, true);
    }

    static int getMaximum(String colVal) {
        return QPCRData.getMaxOrMin(colVal, false);
    }

    private static int getMaxOrMin(String col, boolean doMin) {
        Pattern colPat = Pattern.compile("\\s*(\\d+)\\s*[hH]?\\s*-\\s*(\\d+)\\s*[hH]?\\s*");
        Matcher m = colPat.matcher(col);
        if (m.matches()) {
            try {
                if (doMin) {
                    return Integer.parseInt(m.group(1));
                }
                return Integer.parseInt(m.group(2));
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException();
            }
        }
        throw new IllegalArgumentException();
    }

    MinMax getEnclosingColumn(int time, int timeMax) {
        int cols = this.timeSpanCols_.size();
        if (timeMax != -1) {
            for (int i = 0; i < cols; ++i) {
                MinMax col = (MinMax)this.timeSpanCols_.get(i);
                if (time != col.min || timeMax != col.max) continue;
                return col;
            }
        } else {
            for (int i = 0; i < cols; ++i) {
                MinMax col = (MinMax)this.timeSpanCols_.get(i);
                if (time < col.min || time > col.max) continue;
                return col;
            }
        }
        return null;
    }

    MinMax getEnclosingOrClosestColumn(int time, int timeMax) {
        MinMax exact = this.getEnclosingColumn(time, timeMax);
        if (exact != null) {
            return exact;
        }
        if (timeMax != -1) {
            return this.getBestSpanColumn(time, timeMax);
        }
        int minDist = Integer.MAX_VALUE;
        MinMax best = null;
        int cols = this.timeSpanCols_.size();
        for (int i = 0; i < cols; ++i) {
            MinMax col = (MinMax)this.timeSpanCols_.get(i);
            int chkDistMin = Math.abs(col.min - time);
            int chkDistMax = Math.abs(col.max - time);
            if (chkDistMin < minDist) {
                minDist = chkDistMin;
                best = col;
            }
            if (chkDistMax >= minDist) continue;
            minDist = chkDistMax;
            best = col;
        }
        return best;
    }

    MinMax getBestSpanColumn(int time, int timeMax) {
        MinMax checkSpan = new MinMax(time, timeMax);
        SortedSet checkSet = checkSpan.getAsSortedSet();
        int minDisjointDist = Integer.MAX_VALUE;
        MinMax bestDisjoint = null;
        int maxOverlap = Integer.MIN_VALUE;
        MinMax bestOverlap = null;
        int cols = this.timeSpanCols_.size();
        for (int i = 0; i < cols; ++i) {
            int dist2;
            int min;
            MinMax col = (MinMax)this.timeSpanCols_.get(i);
            int eval = col.evaluate(checkSpan);
            if (eval == 2 || eval == 0) {
                return col;
            }
            if (eval == 4 || eval == 1) {
                SortedSet colSet = col.getAsSortedSet();
                colSet.retainAll(checkSet);
                int sizeOver = colSet.size();
                if (sizeOver <= maxOverlap) continue;
                maxOverlap = sizeOver;
                bestOverlap = col;
                continue;
            }
            int dist1 = Math.abs(col.min - checkSpan.max);
            int n = min = dist1 < (dist2 = Math.abs(checkSpan.min - col.max)) ? dist1 : dist2;
            if (min >= minDisjointDist) continue;
            minDisjointDist = min;
            bestDisjoint = col;
        }
        if (bestOverlap != null) {
            return bestOverlap;
        }
        return bestDisjoint;
    }

    void addDataMaps(String key, List entries, List sources) {
        if (entries != null && entries.size() > 0) {
            this.entryMap_.put(key, entries);
        }
        if (sources != null && sources.size() > 0) {
            this.sourceMap_.put(key, sources);
        }
    }

    void addCombinedDataMaps(String key, List datasets) {
        ArrayList<String> sourceList = new ArrayList<String>();
        ArrayList<String> entryList = new ArrayList<String>();
        Iterator dit = datasets.iterator();
        while (dit.hasNext()) {
            QpcrMapResult res = (QpcrMapResult)dit.next();
            if (res.type == 0) {
                entryList.add(res.name);
                continue;
            }
            sourceList.add(res.name);
        }
        this.entryMap_.put(key, entryList);
        this.sourceMap_.put(key, sourceList);
    }

    private List getQPCRDataEntryKeysWithDefault(String nodeId) {
        ArrayList<String> retval = (ArrayList<String>)this.entryMap_.get(nodeId);
        if (retval == null || retval.size() == 0) {
            retval = new ArrayList<String>();
            Node node = Database.getDB().getGenome().getNode(nodeId);
            if (node == null) {
                throw new IllegalStateException();
            }
            String nodeName = node.getRootName();
            if (nodeName == null || nodeName.trim().equals("")) {
                return retval;
            }
            retval.add(nodeName);
        }
        return retval;
    }

    private List getQPCRDataSourceKeysWithDefault(String nodeId) {
        ArrayList<String> retval = (ArrayList<String>)this.sourceMap_.get(nodeId);
        if (retval == null || retval.size() == 0) {
            retval = new ArrayList<String>();
            Node node = Database.getDB().getGenome().getNode(nodeId);
            if (node == null) {
                throw new IllegalStateException();
            }
            String nodeName = node.getRootName();
            if (nodeName == null || nodeName.trim().equals("")) {
                return retval;
            }
            retval.add(nodeName);
        }
        return retval;
    }

    TargetGene getQPCRDataRelaxedMatch(String targetName) {
        Iterator trgit = this.genes_.iterator();
        while (trgit.hasNext()) {
            TargetGene trg = (TargetGene)trgit.next();
            String name = trg.getName();
            if (!DataUtil.keysEqual(name, targetName)) continue;
            return trg;
        }
        return null;
    }

    String getHTML(String geneId, String sourceID, QpcrTablePublisher qtp) {
        List keys = this.getQPCRDataEntryKeysWithDefault(geneId);
        if (keys == null) {
            return null;
        }
        List srcKeys = null;
        if (sourceID != null && (srcKeys = this.getQPCRDataSourceKeysWithDefault(sourceID)) == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        qtp.setOutput(out);
        Indenter ind = new Indenter(out, 2);
        Iterator trgit = this.genes_.iterator();
        ArrayList<TargetGene> targetGenes = new ArrayList<TargetGene>();
        while (trgit.hasNext()) {
            TargetGene trg = (TargetGene)trgit.next();
            if (!DataUtil.containsKey(keys, trg.getName())) continue;
            targetGenes.add(trg);
        }
        this.writeHTMLForGenes(out, ind, targetGenes, keys, srcKeys, true, qtp);
        return sw.toString();
    }

    void writeHTML(PrintWriter out, Indenter ind, QpcrTablePublisher qtp) {
        Iterator trgit = this.genes_.iterator();
        TreeMap<String, TargetGene> sortedGeneMap = new TreeMap<String, TargetGene>();
        while (trgit.hasNext()) {
            TargetGene trg = (TargetGene)trgit.next();
            sortedGeneMap.put(trg.getName().toLowerCase(), trg);
        }
        ArrayList<String> geneNames = new ArrayList<String>();
        ArrayList<TargetGene> sortedGenes = new ArrayList<TargetGene>();
        Iterator sgmit = sortedGeneMap.keySet().iterator();
        while (sgmit.hasNext()) {
            String name = (String)sgmit.next();
            TargetGene trg = (TargetGene)sortedGeneMap.get(name);
            geneNames.add(trg.getName());
            sortedGenes.add(trg);
        }
        this.writeHTMLForGenes(out, ind, sortedGenes, geneNames, null, false, qtp);
    }

    void writeHTMLForGenes(PrintWriter out, Indenter ind, List targetGenes, List names, List srcNames, boolean doTrim, QpcrTablePublisher qtp) {
        qtp.colorsAndScaling();
        DisplayOptions dopt = DisplayOptionsManager.getMgr().getDisplayOptions();
        boolean breakOutInvest = dopt.breakOutInvestigators();
        ind.indent();
        out.println("<center>");
        out.println("<table width=\"100%\" border=\"1\" bordercolor=\"#000000\" cellpadding=\"7\" cellspacing=\"0\" >");
        this.outputSpanRow(out, ind, qtp);
        int rowCount = 0;
        Iterator git = targetGenes.iterator();
        HashSet footNumbers = new HashSet();
        while (git.hasNext()) {
            TargetGene tg = (TargetGene)git.next();
            rowCount = tg.writeHTML(out, ind, this.timeSpanCols_, qtp, rowCount, breakOutInvest, srcNames, footNumbers);
            if (rowCount <= 18 || !git.hasNext()) continue;
            this.outputSpanRow(out, ind, qtp);
            rowCount = 0;
        }
        ind.down().indent();
        out.println("</table>");
        qtp.paragraph(false);
        ResourceManager rMan = ResourceManager.getManager();
        out.print(rMan.getString("qpcrData.qpcrTableNote"));
        out.println("</p>");
        Iterator pers = this.getNullPerturbations();
        TreeMap<String, NullPerturb> sortedPert = new TreeMap<String, NullPerturb>();
        while (pers.hasNext()) {
            NullPerturb per = (NullPerturb)pers.next();
            if (!per.sourcesContainOneOrMore(srcNames)) continue;
            String pertName = per.getSourceDisplayString(false);
            sortedPert.put(pertName, per);
        }
        Iterator perout = sortedPert.keySet().iterator();
        NullTimeSpan ndts = new NullTimeSpan(dopt.getNullPertDefaultSpan());
        boolean doHeading = true;
        while (perout.hasNext()) {
            String pertName = (String)perout.next();
            NullPerturb per = (NullPerturb)sortedPert.get(pertName);
            if (doTrim && !per.appliesToTargets(names)) continue;
            if (doHeading) {
                qtp.writePerturbationHeader(ind, ndts);
                ind.up();
                doHeading = false;
            }
            per.writeHTML(out, ind, qtp, ndts);
            if (!doTrim) continue;
            Set foots = per.getFootnoteNumbers();
            footNumbers.addAll(foots);
        }
        if (!doHeading) {
            ind.down().indent();
            out.println("</table>");
        }
        out.println("</center>");
        ind.indent();
        Iterator fit = this.getFootnotes();
        doHeading = true;
        while (fit.hasNext()) {
            Footnote fn = (Footnote)fit.next();
            String fnNum = fn.getNumber();
            if (doTrim && !footNumbers.contains(fnNum)) continue;
            if (doHeading) {
                ind.indent();
                out.println("<h3>Footnotes</h3>");
                doHeading = false;
            }
            ind.indent();
            fn.writeHTML(out, ind, qtp);
        }
        ind.down();
    }

    private void outputSpanRow(PrintWriter out, Indenter ind, QpcrTablePublisher qtp) {
        ind.up().indent();
        out.println("<tbody>");
        ind.up().indent();
        out.println("<tr valign=\"top\">");
        ind.up();
        ind.indent();
        out.println("<td bgcolor=\"#EEEEEE\">");
        ind.up().indent();
        qtp.paragraph(false);
        out.println("<b>Gene</b></p>");
        ind.down().indent();
        out.println("</td>");
        ind.indent();
        out.println("<td bgcolor=\"#EEEEEE\">");
        ind.up().indent();
        qtp.paragraph(false);
        out.println("<b>Perturbation</b></p>");
        ind.down().indent();
        out.println("</td>");
        Iterator cit = this.timeSpanCols_.iterator();
        while (cit.hasNext()) {
            MinMax tc = (MinMax)cit.next();
            ind.indent();
            out.println("<td bgcolor=\"#EEEEEE\">");
            ind.up().indent();
            qtp.paragraph(true);
            out.print("<b>");
            String tdisp = tc.min == Integer.MIN_VALUE && tc.max == Integer.MAX_VALUE ? ResourceManager.getManager().getString("qpcrDisplay.allTimes") : TimeSpan.spanToString(tc);
            tdisp = tdisp.replaceAll(" ", "&nbsp;");
            out.print(tdisp);
            out.println("</b></p>");
            ind.down().indent();
            out.println("</td>");
        }
        ind.indent();
        out.println("<td bgcolor=\"#EEEEEE\">");
        ind.up().indent();
        qtp.paragraph(false);
        out.println("<b>Data of:</b></p>");
        ind.down().indent();
        out.println("</td>");
        ind.down().indent();
        out.println("</tr>");
        ind.down().indent();
        out.println("</tbody>");
    }

    int mapLinkSignToMeasurementSign(int sign) {
        switch (sign) {
            case -1: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 0: {
                return 0;
            }
        }
        throw new IllegalArgumentException();
    }

    static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("QPCR");
        return retval;
    }

    static String columnKeyword() {
        return "column";
    }

    static String columnRangeKeyword() {
        return "columnRange";
    }

    static String datamapKeyword() {
        return "datamap";
    }

    static String useqpcrKeyword() {
        return "useqpcr";
    }

    public String toString() {
        return "QPCRData:  genes = " + this.genes_ + " timeSpanCols = " + this.timeSpanCols_ + " entryMap = " + this.entryMap_ + " sourceMap = " + this.sourceMap_ + " null perturbs = " + this.nullPerturbations_ + " footnotes = " + this.footnotes_;
    }

    static QPCRData buildFromXML(String elemName, Attributes attrs, boolean serialNumberIsIllegal) throws IOException {
        if (!elemName.equals("QPCR")) {
            return null;
        }
        String threshString = AttributeExtractor.extractAttribute(elemName, attrs, "QPCR", "threshold", false);
        String serialString = AttributeExtractor.extractAttribute(elemName, attrs, "QPCR", "serialNum", false);
        if (serialNumberIsIllegal && serialString != null) {
            throw new IOException();
        }
        QPCRData retval = new QPCRData();
        if (threshString != null) {
            try {
                double thresh = Double.parseDouble(threshString);
                if (thresh < 0.0) {
                    throw new IOException();
                }
                retval.threshold_ = thresh;
            }
            catch (NumberFormatException ex) {
                throw new IOException();
            }
        }
        if (serialString != null) {
            try {
                long serialNumber = Long.parseLong(serialString);
                if (serialNumber < 0L) {
                    throw new IOException();
                }
                retval.serialNumber_ = serialNumber;
            }
            catch (NumberFormatException ex) {
                throw new IOException();
            }
        }
        return retval;
    }

    static String extractMapKey(String elemName, Attributes attrs) throws IOException {
        String chkStr = "datamap";
        if (!elemName.equals(chkStr)) {
            return null;
        }
        String keyName = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (!key.equals("key")) continue;
                keyName = val;
            }
        }
        if (keyName == null) {
            throw new IOException();
        }
        return keyName;
    }

    static QpcrMapResult extractUseQPCR(String elemName, Attributes attrs) throws IOException {
        String chkStr = "useqpcr";
        if (!elemName.equals(chkStr)) {
            return null;
        }
        String name = null;
        String type = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("name")) {
                    name = val;
                }
                if (!key.equals("type")) continue;
                type = val;
            }
        }
        if (name == null || type == null) {
            throw new IOException();
        }
        int mapType = type.equals("entry") ? 0 : 1;
        return new QpcrMapResult(name, mapType);
    }

    static MinMax extractColumnRange(String elemName, Attributes attrs) throws IOException {
        if (!elemName.equals("columnRange")) {
            return null;
        }
        String minValStr = null;
        String maxValStr = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("min")) {
                    minValStr = val;
                }
                if (!key.equals("max")) continue;
                maxValStr = val;
            }
        }
        try {
            int minVal;
            int maxVal = minVal = Integer.parseInt(minValStr);
            if (maxValStr != null) {
                maxVal = Integer.parseInt(maxValStr);
            }
            return new MinMax(minVal, maxVal);
        }
        catch (NumberFormatException ex) {
            throw new IOException();
        }
    }

    static void writeDataMap(PrintWriter out, Indenter ind, Map entryMap, Map sourceMap, boolean forQpcr) {
        ind.indent();
        out.println(forQpcr ? "<datamaps>" : "<tempWorkDatamaps>");
        TreeSet sorted = new TreeSet();
        sorted.addAll(entryMap.keySet());
        sorted.addAll(sourceMap.keySet());
        Iterator mapKeys = sorted.iterator();
        ind.up();
        while (mapKeys.hasNext()) {
            String useqpcr;
            Iterator lit;
            String key = (String)mapKeys.next();
            List elist = (List)entryMap.get(key);
            List slist = (List)sourceMap.get(key);
            ind.indent();
            out.print(forQpcr ? "<datamap" : "<tempWorkDatamap");
            out.print(" key=\"");
            out.print(key);
            out.println("\">");
            ind.up();
            if (elist != null) {
                lit = elist.iterator();
                while (lit.hasNext()) {
                    useqpcr = (String)lit.next();
                    ind.indent();
                    out.print(forQpcr ? "<useqpcr" : "<tempWorkUseqpcr");
                    out.print(" type=\"entry\" name=\"");
                    out.print(useqpcr);
                    out.println("\"/>");
                }
            }
            if (slist != null) {
                lit = slist.iterator();
                while (lit.hasNext()) {
                    useqpcr = (String)lit.next();
                    ind.indent();
                    out.print(forQpcr ? "<useqpcr" : "<tempWorkUseqpcr");
                    out.print(" type=\"source\" name=\"");
                    out.print(useqpcr);
                    out.println("\"/>");
                }
            }
            ind.down().indent();
            out.println(forQpcr ? "</datamap>" : "</tempWorkDatamap>");
        }
        ind.down().indent();
        out.println(forQpcr ? "</datamaps>" : "</tempWorkDatamaps>");
    }

    static class QpcrMapResult {
        String name;
        int type;
        static final int ENTRY_MAP = 0;
        static final int SOURCE_MAP = 1;

        QpcrMapResult(String name, int type) {
            this.name = name;
            this.type = type;
        }
    }

    static class SourceComparator
    implements Comparator {
        SourceComparator() {
        }

        public int compare(Object o1, Object o2) {
            Source s1 = (Source)o1;
            Source s2 = (Source)o2;
            String s1v = s1.getDisplayValue().toUpperCase().replaceAll(" ", "");
            String s2v = s2.getDisplayValue().toUpperCase().replaceAll(" ", "");
            return s1v.compareTo(s2v);
        }
    }
}

