/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.qpcr;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.perturb.Experiment;
import org.systemsbiology.biotapestry.perturb.LegacyPert;
import org.systemsbiology.biotapestry.perturb.PertAnnotations;
import org.systemsbiology.biotapestry.perturb.PertDataPoint;
import org.systemsbiology.biotapestry.perturb.PertDictionary;
import org.systemsbiology.biotapestry.perturb.PertFilterExpression;
import org.systemsbiology.biotapestry.perturb.PertProperties;
import org.systemsbiology.biotapestry.perturb.PertSource;
import org.systemsbiology.biotapestry.perturb.PertSources;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.qpcr.Batch;
import org.systemsbiology.biotapestry.qpcr.Footnote;
import org.systemsbiology.biotapestry.qpcr.Measurement;
import org.systemsbiology.biotapestry.qpcr.NullPerturb;
import org.systemsbiology.biotapestry.qpcr.NullTarget;
import org.systemsbiology.biotapestry.qpcr.NullTimeSpan;
import org.systemsbiology.biotapestry.qpcr.Perturbation;
import org.systemsbiology.biotapestry.qpcr.QPCRData;
import org.systemsbiology.biotapestry.qpcr.Source;
import org.systemsbiology.biotapestry.qpcr.TargetGene;
import org.systemsbiology.biotapestry.qpcr.TimeSpan;
import org.systemsbiology.biotapestry.ui.DisplayOptions;
import org.systemsbiology.biotapestry.ui.DisplayOptionsManager;
import org.systemsbiology.biotapestry.ui.dialogs.utils.ReadOnlyTable;
import org.systemsbiology.biotapestry.util.MinMax;
import org.systemsbiology.biotapestry.util.ResourceManager;

class QpcrDisplayGenerator {
    private HashMap tempFoots_ = new HashMap();

    QpcrDisplayGenerator() {
    }

    QPCRData createQPCRFromPerts(PerturbationData pd) {
        String tag;
        PertSourcesAndTargKey sst;
        QPCRData qpcr = new QPCRData();
        PertDictionary pDict = pd.getPertDictionary();
        ResourceManager rMan = ResourceManager.getManager();
        String etAl = rMan.getString("qpcrData.andOthers");
        DisplayOptions dOpt = DisplayOptionsManager.getMgr().getDisplayOptions();
        if (dOpt.hasColumns()) {
            Iterator cit = dOpt.getColumnIterator();
            while (cit.hasNext()) {
                MinMax nextCol = (MinMax)cit.next();
                qpcr.addColumn((MinMax)nextCol.clone());
            }
        } else {
            qpcr.addColumn(new MinMax(Integer.MIN_VALUE, Integer.MAX_VALUE));
        }
        String scaleKey = dOpt.getPerturbDataDisplayScaleKey();
        Map techColors = dOpt.getMeasurementDisplayColors();
        PertFilterExpression pfe = new PertFilterExpression(1);
        List pertData = pd.getPerturbations(pfe);
        HashMap<PertSourcesAndTargKey, Boolean> results = new HashMap<PertSourcesAndTargKey, Boolean>();
        HashMap<PertSourcesAndTargKey, TreeSet<Integer>> timeBounds = new HashMap<PertSourcesAndTargKey, TreeSet<Integer>>();
        HashMap<PertSourcesAndTargKey, RegRestrictAggregation> regRes = new HashMap<PertSourcesAndTargKey, RegRestrictAggregation>();
        HashMap footHoistForNull = new HashMap();
        HashMap investForNull = new HashMap();
        HashMap retainFootsForNull = new HashMap();
        Iterator pdpit = pertData.iterator();
        while (pdpit.hasNext()) {
            List invests;
            PertDataPoint pdp = (PertDataPoint)pdpit.next();
            PertSources sources = pdp.getSources(pd);
            String targKey = pdp.getTargetKey();
            sst = new PertSourcesAndTargKey(sources, targKey);
            Experiment psi = pdp.getExperiment(pd);
            int pertTime = psi.getTime();
            int legacyMax = psi.getLegacyMaxTime();
            LegacyPert lp = pdp.getLegacyPert();
            Boolean isSig = pdp.getForcedSignificance();
            PerturbationData.RegionRestrict rr = pdp.getRegionRestriction(pd);
            RegRestrictAggregation rra = (RegRestrictAggregation)regRes.get(sst);
            if (rra == null) {
                rra = new RegRestrictAggregation();
                regRes.put(sst, rra);
            }
            if (rr == null) {
                ++rra.noRestrict;
            } else if (rr.isLegacyNullStyle()) {
                String lVal = rr.getLegacyValue();
                rra.legacyVals.add(lVal);
            } else {
                String key = this.buildRegResRegions(rr);
                rra.actualFoots.add(key);
            }
            TreeSet<Integer> bounds = (TreeSet<Integer>)timeBounds.get(sst);
            if (bounds == null) {
                bounds = new TreeSet<Integer>();
                timeBounds.put(sst, bounds);
            }
            bounds.add(new Integer(pertTime));
            if (legacyMax != -1 && pertTime != legacyMax) {
                bounds.add(new Integer(legacyMax));
            }
            boolean goForNull = false;
            goForNull = lp != null ? true : (isSig != null ? isSig == false : !pdp.aboveThresholds(pd));
            Boolean allBelow = (Boolean)results.get(sst);
            if (allBelow == null) {
                allBelow = new Boolean(goForNull);
                results.put(sst, allBelow);
            } else {
                boolean newVal = allBelow != false && goForNull;
                allBelow = new Boolean(newVal);
            }
            results.put(sst, allBelow);
            HashSet<String> i4n = (HashSet<String>)investForNull.get(sst);
            if (i4n == null) {
                i4n = new HashSet<String>();
                investForNull.put(sst, i4n);
            }
            if ((invests = psi.getInvestigators()) != null && !invests.isEmpty()) {
                int numI = invests.size();
                for (int i = 0; i < numI; ++i) {
                    String investKey = (String)invests.get(i);
                    String invest = pd.getInvestigator(investKey);
                    i4n.add(invest);
                }
                continue;
            }
            i4n.add(etAl);
        }
        this.resolveFootnotesForNulls(pd, pertData, results, footHoistForNull, retainFootsForNull);
        HashMap<PertSources, HashSet<String>> allTargsForSources = new HashMap<PertSources, HashSet<String>>();
        HashMap hoistedFootsPerSource = new HashMap();
        Iterator rit = results.keySet().iterator();
        while (rit.hasNext()) {
            sst = (PertSourcesAndTargKey)rit.next();
            Boolean currentlyAllBelow = (Boolean)results.get(sst);
            if (currentlyAllBelow.booleanValue()) {
                List sources = this.getQPCRSourceList(sst.srcs, pd, pDict);
                NullPerturb npert = this.nullPerturbationMatchesSource(qpcr, sources);
                HashSet myHoistedFoots = (HashSet)hoistedFootsPerSource.get(sst.srcs);
                if (myHoistedFoots == null) {
                    myHoistedFoots = new HashSet();
                    hoistedFootsPerSource.put(sst.srcs, myHoistedFoots);
                }
                if (npert == null) {
                    npert = new NullPerturb();
                    int numSrc = sources.size();
                    for (int i = 0; i < numSrc; ++i) {
                        HashSet footsPerSource;
                        Source src = (Source)sources.get(i);
                        ArrayList flist = new ArrayList();
                        if (i == numSrc - 1 && (footsPerSource = (HashSet)footHoistForNull.get(sst.srcs)) != null && !footsPerSource.isEmpty()) {
                            flist.addAll(pd.getFootnoteList(new ArrayList(footsPerSource)));
                            myHoistedFoots.addAll(footsPerSource);
                        }
                        flist.addAll(src.getFootnoteNumbers());
                        TreeSet sortedFoots = new TreeSet(new ReadOnlyTable.NumStrComparator());
                        sortedFoots.addAll(flist);
                        String newNotes = PertAnnotations.convertFootnoteListToString(new ArrayList(sortedFoots));
                        src = (Source)src.clone();
                        src.setNotes(newNotes);
                        npert.addSource(src);
                    }
                    qpcr.addNullPerturbation(npert);
                }
                NullTarget targ = this.buildNullTarget(pd, sst, retainFootsForNull, myHoistedFoots, regRes, timeBounds);
                npert.addTarget(targ);
                HashSet i4n = (HashSet)investForNull.get(sst);
                npert.addInvestigators(i4n);
                continue;
            }
            HashSet<String> atfs = (HashSet<String>)allTargsForSources.get(sst.srcs);
            if (atfs == null) {
                atfs = new HashSet<String>();
                allTargsForSources.put(sst.srcs, atfs);
            }
            atfs.add(sst.targKey);
        }
        this.fillInPerturbations(qpcr, allTargsForSources, pertData, pd, pDict, scaleKey, techColors);
        Genome genome = Database.getDB().getGenome();
        Iterator anit = genome.getAllNodeIterator();
        while (anit.hasNext()) {
            Node node = (Node)anit.next();
            String nodeID = node.getID();
            List entries = pd.getCustomDataEntryKeys(nodeID);
            ArrayList<String> mapped = null;
            if (entries != null && !entries.isEmpty()) {
                mapped = new ArrayList<String>();
                int numE = entries.size();
                for (int i = 0; i < numE; ++i) {
                    String targKey = (String)entries.get(i);
                    String targName = pd.getTarget(targKey);
                    mapped.add(targName);
                }
            }
            List sources = pd.getCustomDataSourceKeys(nodeID);
            ArrayList<String> mappedS = null;
            if (sources != null && !sources.isEmpty()) {
                mappedS = new ArrayList<String>();
                int numE = sources.size();
                for (int i = 0; i < numE; ++i) {
                    String srcKey = (String)sources.get(i);
                    String srcName = pd.getSourceName(srcKey);
                    mappedS.add(srcName);
                }
            }
            qpcr.addDataMaps(nodeID, mapped, mappedS);
        }
        SortedMap annots = pd.getPertAnnotationsMap();
        Iterator akit = annots.keySet().iterator();
        while (akit.hasNext()) {
            String tag2 = (String)akit.next();
            String message = (String)annots.get(tag2);
            Footnote nextNote = new Footnote(tag2);
            nextNote.setNote(message);
            qpcr.addFootnote(nextNote);
        }
        Iterator lit = this.tempFoots_.keySet().iterator();
        TreeMap<String, String> sorted = new TreeMap<String, String>(new ReadOnlyTable.NumStrComparator());
        while (lit.hasNext()) {
            String message = (String)lit.next();
            tag = (String)this.tempFoots_.get(message);
            sorted.put(tag, message);
        }
        Iterator sit = sorted.keySet().iterator();
        while (sit.hasNext()) {
            tag = (String)sit.next();
            String message = (String)sorted.get(tag);
            Footnote nextNote = new Footnote(tag);
            nextNote.setNote(message);
            qpcr.addFootnote(nextNote);
        }
        return qpcr;
    }

    private NullTarget buildNullTarget(PerturbationData pd, PertSourcesAndTargKey sst, HashMap retainFootsForNull, HashSet myHoistedFoots, HashMap regRes, HashMap timeBounds) {
        HashMap retainFootsPerSource = (HashMap)retainFootsForNull.get(sst.srcs);
        List retainFootsPerTarget = (List)retainFootsPerSource.get(sst.targKey);
        NullTarget targ = new NullTarget(pd.getTarget(sst.targKey));
        ArrayList foots = new ArrayList();
        HashSet retain = new HashSet(retainFootsPerTarget);
        retain.removeAll(pd.getFootnoteList(new ArrayList(myHoistedFoots)));
        foots.addAll(retain);
        RegRestrictAggregation rra = (RegRestrictAggregation)regRes.get(sst);
        if (!rra.legacyVals.isEmpty() || !rra.actualFoots.isEmpty()) {
            foots.addAll(this.buildRegionFootsForNullTarg(pd, rra));
        }
        String noteStr = PertAnnotations.convertFootnoteListToString(foots);
        targ.setFootsForHTML(noteStr);
        TreeSet mm = (TreeSet)timeBounds.get(sst);
        if (mm.size() == 1) {
            NullTimeSpan nts = new NullTimeSpan((Integer)mm.first());
            targ.addTimeSpan(nts);
        } else {
            NullTimeSpan nts = new NullTimeSpan((Integer)mm.first(), (Integer)mm.last());
            targ.addTimeSpan(nts);
        }
        return targ;
    }

    private void resolveFootnotesForNulls(PerturbationData pd, List pertList, Map results, HashMap hoistFoots, HashMap retainFoots) {
        Integer pointCount;
        PertSources sources;
        HashMap pointCountsPerTargPerSource = new HashMap();
        Iterator plit = pertList.iterator();
        while (plit.hasNext()) {
            HashSet footsPerSource;
            HashMap<String, Integer> retainFootsPerTarget;
            String targKey;
            PertDataPoint pdp = (PertDataPoint)plit.next();
            sources = pdp.getSources(pd);
            PertSourcesAndTargKey sst = new PertSourcesAndTargKey(sources, targKey = pdp.getTargetKey());
            Boolean currentlyAllBelow = (Boolean)results.get(sst);
            if (!currentlyAllBelow.booleanValue()) continue;
            List notes = pd.getDataPointNotes(pdp.getID());
            HashMap<String, Integer> pointCountsPerTarg = (HashMap<String, Integer>)pointCountsPerTargPerSource.get(sources);
            if (pointCountsPerTarg == null) {
                pointCountsPerTarg = new HashMap<String, Integer>();
                pointCountsPerTargPerSource.put(sources, pointCountsPerTarg);
            }
            pointCount = (pointCount = (Integer)pointCountsPerTarg.get(targKey)) == null ? new Integer(1) : new Integer(pointCount + 1);
            pointCountsPerTarg.put(targKey, pointCount);
            HashMap retainFootsPerSource = (HashMap)retainFoots.get(sources);
            if (retainFootsPerSource == null) {
                retainFootsPerSource = new HashMap();
                retainFoots.put(sources, retainFootsPerSource);
            }
            if ((retainFootsPerTarget = (HashMap<String, Integer>)retainFootsPerSource.get(targKey)) == null) {
                retainFootsPerTarget = new HashMap<String, Integer>();
                retainFootsPerSource.put(targKey, retainFootsPerTarget);
            }
            if (notes != null) {
                int numNotes = notes.size();
                for (int i = 0; i < numNotes; ++i) {
                    String noteKey = (String)notes.get(i);
                    Integer count = (Integer)retainFootsPerTarget.get(noteKey);
                    count = count == null ? new Integer(1) : new Integer(count + 1);
                    retainFootsPerTarget.put(noteKey, count);
                }
            }
            if ((footsPerSource = (HashSet)hoistFoots.get(sources)) == null) {
                footsPerSource = new HashSet();
                if (notes != null) {
                    footsPerSource.addAll(notes);
                }
                hoistFoots.put(sources, footsPerSource);
                continue;
            }
            HashSet intersect = (HashSet)footsPerSource.clone();
            if (notes == null) {
                intersect.clear();
            } else {
                intersect.retainAll(notes);
            }
            hoistFoots.put(sources, intersect);
        }
        Iterator rfit = retainFoots.keySet().iterator();
        while (rfit.hasNext()) {
            sources = (PertSources)rfit.next();
            HashMap retainFootsPerSource = (HashMap)retainFoots.get(sources);
            HashMap pointCountsPerTarg = (HashMap)pointCountsPerTargPerSource.get(sources);
            Iterator rffsit = new HashSet(retainFootsPerSource.keySet()).iterator();
            while (rffsit.hasNext()) {
                String trgKey = (String)rffsit.next();
                HashMap retainFootsPerTarget = (HashMap)retainFootsPerSource.get(trgKey);
                pointCount = (Integer)pointCountsPerTarg.get(trgKey);
                Iterator rfftit = retainFootsPerTarget.keySet().iterator();
                HashSet<String> revised = new HashSet<String>();
                String pnt = null;
                while (rfftit.hasNext()) {
                    String footKey = (String)rfftit.next();
                    Integer perFootCount = (Integer)retainFootsPerTarget.get(footKey);
                    revised.add(footKey);
                    if (perFootCount.equals(pointCount)) continue;
                    pnt = this.getPartialNullTag(pd);
                }
                List footsPerSource = pd.getFootnoteList(new ArrayList(revised));
                if (pnt != null) {
                    footsPerSource.add(pnt);
                }
                retainFootsPerSource.put(trgKey, footsPerSource);
            }
        }
    }

    private String getPartialNullTag(PerturbationData pd) {
        ResourceManager rMan = ResourceManager.getManager();
        String foot = rMan.getString("qpcrDisplay.incompleteNullFootnoteCoverage");
        String tag = (String)this.tempFoots_.get(foot);
        if (tag == null) {
            tag = pd.getPertAnnotations().getNextTempTag(new HashSet(this.tempFoots_.values()));
            this.tempFoots_.put(foot, tag);
        }
        return tag;
    }

    private List getQPCRSourceList(PertSources pss, PerturbationData pd, PertDictionary pDict) {
        ArrayList<Source> retval = new ArrayList<Source>();
        Iterator sit = pss.getSources();
        while (sit.hasNext()) {
            String srcID = (String)sit.next();
            PertSource ps = pd.getSourceDef(srcID);
            PertProperties pProps = ps.getExpType(pDict);
            Source newSrc = new Source(ps.getSourceName(pd), pProps.getLegacyType());
            List srcAnnot = ps.getAnnotationIDs();
            String noteStr = srcAnnot.isEmpty() ? null : pd.getFootnoteListAsString(srcAnnot);
            newSrc.setNotes(noteStr);
            retval.add(newSrc);
        }
        return retval;
    }

    private NullPerturb nullPerturbationMatchesSource(QPCRData qpcr, List sources) {
        Iterator npit = qpcr.getNullPerturbations();
        while (npit.hasNext()) {
            NullPerturb chknp = (NullPerturb)npit.next();
            if (!chknp.sourcesMatch(sources)) continue;
            return chknp;
        }
        return null;
    }

    private boolean fillInPerturbations(QPCRData qpcr, HashMap atfs, List pertList, PerturbationData pd, PertDictionary pDict, String scaleKey, Map techColors) {
        String targKey;
        HashSet targs;
        PertSources ps;
        Experiment psi;
        PertDataPoint pdp;
        HashMap droppedMultiNull = new HashMap();
        HashMap hoistFoots = new HashMap();
        Iterator plit = pertList.iterator();
        while (plit.hasNext()) {
            pdp = (PertDataPoint)plit.next();
            psi = pdp.getExperiment(pd);
            ps = psi.getSources();
            targs = (HashSet)atfs.get(ps);
            targKey = pdp.getTargetKey();
            if (targs == null || !targs.contains(targKey)) continue;
            if (pdp.notForTableDisplay()) {
                int timeVal = psi.getTime();
                int timeMax = psi.getLegacyMaxTime();
                if (timeMax != -1 && timeMax != timeVal && qpcr.getEnclosingColumn(timeVal, timeMax) == null) {
                    FormerNullFootData timesPerDrop;
                    HashMap<String, FormerNullFootData> droppedPerSource;
                    String regList = null;
                    PerturbationData.RegionRestrict rr = pdp.getRegionRestriction(pd);
                    if (rr != null) {
                        regList = rr.isLegacyNullStyle() ? rr.getLegacyValue() : this.buildRegResRegions(rr);
                    }
                    if ((droppedPerSource = (HashMap<String, FormerNullFootData>)droppedMultiNull.get(ps)) == null) {
                        droppedPerSource = new HashMap<String, FormerNullFootData>();
                        droppedMultiNull.put(ps, droppedPerSource);
                    }
                    if ((timesPerDrop = (FormerNullFootData)droppedPerSource.get(targKey)) == null) {
                        timesPerDrop = new FormerNullFootData();
                        droppedPerSource.put(targKey, timesPerDrop);
                    }
                    timesPerDrop.times.add(TimeSpan.spanToString(new MinMax(timeVal, timeMax)));
                    if (regList == null) continue;
                    timesPerDrop.regions.add(regList);
                    continue;
                }
            }
            this.resolveFootHoists(pd, ps, pdp, hoistFoots);
        }
        plit = pertList.iterator();
        while (plit.hasNext()) {
            pdp = (PertDataPoint)plit.next();
            psi = pdp.getExperiment(pd);
            ps = psi.getSources();
            targs = (HashSet)atfs.get(ps);
            targKey = pdp.getTargetKey();
            if (targs == null || !targs.contains(targKey)) continue;
            HashMap footsPerSource = (HashMap)hoistFoots.get(ps);
            HashSet footsPerTarg = (HashSet)footsPerSource.get(targKey);
            HashMap droppedPerSource = (HashMap)droppedMultiNull.get(ps);
            this.fillForTarg(qpcr, ps, targKey, pdp, pd, pDict, footsPerTarg, droppedPerSource, scaleKey, techColors);
        }
        return true;
    }

    private void resolveFootHoists(PerturbationData pd, PertSources ps, PertDataPoint pdp, HashMap hoistFoots) {
        HashSet footsPerTarg;
        String targKey = pdp.getTargetKey();
        List notes = pd.getDataPointNotes(pdp.getID());
        HashMap<String, HashSet> footsPerSource = (HashMap<String, HashSet>)hoistFoots.get(ps);
        if (footsPerSource == null) {
            footsPerSource = new HashMap<String, HashSet>();
            hoistFoots.put(ps, footsPerSource);
        }
        if ((footsPerTarg = (HashSet)footsPerSource.get(targKey)) == null) {
            footsPerTarg = new HashSet();
            if (notes != null) {
                footsPerTarg.addAll(notes);
            }
            footsPerSource.put(targKey, footsPerTarg);
        } else {
            HashSet intersect = (HashSet)footsPerTarg.clone();
            if (notes == null) {
                intersect.clear();
            } else {
                intersect.retainAll(notes);
            }
            footsPerSource.put(targKey, intersect);
        }
    }

    private void fillForTarg(QPCRData qpcr, PertSources ps, String targKey, PertDataPoint pdp, PerturbationData pd, PertDictionary pDict, HashSet hoistFoots, Map droppedPerSource, String scaleKey, Map techColors) {
        String invest;
        String csvBatch;
        Batch batch;
        PerturbationData.RegionRestrict rr;
        TimeSpan span;
        MinMax column;
        String tag;
        String msg;
        List sources = this.getQPCRSourceList(ps, pd, pDict);
        TargetGene gene = qpcr.getQPCRDataRelaxedMatch(pd.getTarget(targKey));
        if (gene == null) {
            List notes = pd.getFootnotesForTarget(targKey);
            String noteStr = notes == null ? null : pd.getFootnoteListAsString(notes);
            gene = new TargetGene(pd.getTarget(targKey), noteStr);
            qpcr.addGene(gene, false);
        }
        Perturbation pert = null;
        Iterator pit = gene.getPerturbations();
        while (pit.hasNext()) {
            Perturbation chkPert = (Perturbation)pit.next();
            if (!chkPert.sourcesMatch(sources)) continue;
            pert = chkPert;
            break;
        }
        if (pert == null) {
            pert = new Perturbation();
            int numSrc = sources.size();
            for (int i = 0; i < numSrc; ++i) {
                Source src = (Source)sources.get(i);
                ArrayList<String> flist = new ArrayList<String>();
                if (i == numSrc - 1) {
                    FormerNullFootData timesPerDrop;
                    if (!hoistFoots.isEmpty()) {
                        flist.addAll(pd.getFootnoteList(new ArrayList(hoistFoots)));
                    }
                    if (droppedPerSource != null && (timesPerDrop = (FormerNullFootData)droppedPerSource.get(targKey)) != null) {
                        Object[] list;
                        String fmt;
                        ResourceManager rMan = ResourceManager.getManager();
                        if (timesPerDrop.regions.isEmpty()) {
                            fmt = rMan.getString("qpcrDisplay.inexactMultiDrop");
                            list = new Object[]{timesPerDrop.getTimesList()};
                        } else {
                            fmt = rMan.getString("qpcrDisplay.inexactMultiDropWithRegion");
                            list = new Object[]{timesPerDrop.getTimesList(), timesPerDrop.getRegionsList()};
                        }
                        msg = MessageFormat.format(fmt, list);
                        tag = (String)this.tempFoots_.get(msg);
                        if (tag == null) {
                            tag = pd.getPertAnnotations().getNextTempTag(new HashSet(this.tempFoots_.values()));
                            this.tempFoots_.put(msg, tag);
                        }
                        flist.add(tag);
                    }
                }
                flist.addAll(src.getFootnoteNumbers());
                TreeSet<String> sortedFoots = new TreeSet<String>(new ReadOnlyTable.NumStrComparator());
                sortedFoots.addAll(flist);
                String newNotes = PertAnnotations.convertFootnoteListToString(new ArrayList(sortedFoots));
                src = (Source)src.clone();
                src.setNotes(newNotes);
                pert.addSource(src);
            }
            gene.addPerturbation(pert);
        }
        Experiment psi = pdp.getExperiment(pd);
        int timeVal = psi.getTime();
        int timeMax = psi.getLegacyMaxTime();
        String exactMultiDropTag = null;
        String nonStdMaxTime = null;
        String nonStdTime = null;
        if (pdp.notForTableDisplay()) {
            ResourceManager rMan;
            if (timeMax != -1 && timeMax != timeVal) {
                column = qpcr.getEnclosingColumn(timeVal, timeMax);
                if (column == null) {
                    return;
                }
            } else {
                column = qpcr.getEnclosingOrClosestColumn(timeVal, timeMax);
                if (column == null) {
                    throw new IllegalStateException();
                }
            }
            if ((tag = (String)this.tempFoots_.get(msg = (rMan = ResourceManager.getManager()).getString("qpcrDisplay.exactMultiDrop"))) == null) {
                tag = pd.getPertAnnotations().getNextTempTag(new HashSet(this.tempFoots_.values()));
                this.tempFoots_.put(msg, tag);
            }
            exactMultiDropTag = tag;
        } else {
            column = qpcr.getEnclosingOrClosestColumn(timeVal, timeMax);
            if (column == null) {
                throw new IllegalStateException();
            }
        }
        if (timeMax == -1) {
            if (timeVal < column.min || timeVal > column.max) {
                nonStdTime = Integer.toString(timeVal);
            }
        } else if (timeVal != column.min || timeMax != column.max) {
            nonStdTime = Integer.toString(timeVal);
            nonStdMaxTime = Integer.toString(timeMax);
        }
        if ((span = pert.getTimeSpan(column)) == null) {
            span = new TimeSpan(column);
            pert.addTime(span);
        }
        if (timeMax != -1 && timeVal == column.min && timeMax == column.max) {
            timeVal = -1;
        }
        ArrayList notes = pd.getDataPointNotes(pdp.getID());
        ArrayList<String> localTags = new ArrayList<String>();
        if (exactMultiDropTag != null) {
            localTags.add(exactMultiDropTag);
        }
        if ((rr = pdp.getRegionRestriction(pd)) != null) {
            String tag2 = this.buildRegResFootnote(pd, rr);
            localTags.add(tag2);
        }
        if (notes != null) {
            notes = new ArrayList(notes);
            notes.removeAll(hoistFoots);
        }
        String noteStr = null;
        if (notes != null || !localTags.isEmpty()) {
            PertAnnotations pa = pd.getPertAnnotations();
            List flist = notes == null ? new ArrayList() : pa.getFootnoteList(notes);
            TreeSet<String> sorted = new TreeSet<String>(flist);
            sorted.addAll(localTags);
            noteStr = PertAnnotations.convertFootnoteListToString(new ArrayList(sorted));
        }
        if ((batch = span.getBatchWithIDAndInvest(csvBatch = pdp.getBatchKey(), invest = psi.getInvestigatorDisplayString(pd))) == null) {
            batch = new Batch(timeVal, pdp.getDate(), invest, csvBatch);
            span.addBatch(batch);
        }
        Measurement meas = new Measurement(pdp.getScaledDisplayValueOldStyle(scaleKey, pd, false), nonStdTime, noteStr, pdp.getControl(), pdp.getForcedSignificance(), pdp.getComment());
        if (nonStdMaxTime != null) {
            meas.setNonStdMaxTime(nonStdMaxTime);
        }
        String colStr = (String)techColors.get(pdp.getMeasurementTypeKey());
        meas.setColorDisplay(colStr);
        batch.addMeasurement(meas);
        List investigators = psi.getInvestigators();
        for (int i = 0; i < investigators.size(); ++i) {
            String investKey = (String)investigators.get(i);
            pert.addInvestigatorIfNew(pd.getInvestigator(investKey));
        }
    }

    private List buildRegionFootsForNullTarg(PerturbationData pd, RegRestrictAggregation rra) {
        String foot;
        String format;
        ArrayList<String> retval = new ArrayList<String>();
        ResourceManager rMan = ResourceManager.getManager();
        if (rra.noRestrict == 0) {
            if (rra.actualFoots.isEmpty()) {
                Iterator lvit = rra.legacyVals.iterator();
                int size = rra.legacyVals.size();
                Object[] lvobj = new Object[1];
                if (size == 1) {
                    lvobj[0] = lvit.next();
                    String format2 = rMan.getString("qpcrDisplay.simpleLegacyRegionRestrictionFormat");
                    String foot2 = MessageFormat.format(format2, lvobj);
                    String tag = (String)this.tempFoots_.get(foot2);
                    if (tag == null) {
                        tag = pd.getPertAnnotations().getNextTempTag(new HashSet(this.tempFoots_.values()));
                        this.tempFoots_.put(foot2, tag);
                    }
                    retval.add(tag);
                    return retval;
                }
                StringBuffer buf = new StringBuffer();
                while (lvit.hasNext()) {
                    buf.append((String)lvit.next());
                    if (!lvit.hasNext()) continue;
                    buf.append(", ");
                }
                lvobj[0] = buf.toString();
                String format3 = rMan.getString("qpcrDisplay.mixedLegacyRegionRestrictionFormat");
                String foot3 = MessageFormat.format(format3, lvobj);
                String tag = (String)this.tempFoots_.get(foot3);
                if (tag == null) {
                    tag = pd.getPertAnnotations().getNextTempTag(new HashSet(this.tempFoots_.values()));
                    this.tempFoots_.put(foot3, tag);
                }
                retval.add(tag);
                return retval;
            }
            if (rra.legacyVals.isEmpty()) {
                Iterator afit = rra.actualFoots.iterator();
                int size = rra.actualFoots.size();
                Object[] lvobj = new Object[1];
                if (size == 1) {
                    lvobj[0] = afit.next();
                    String format4 = rMan.getString("qpcrDisplay.simpleRegionRestrictionFormat");
                    String foot4 = MessageFormat.format(format4, lvobj);
                    String tag = (String)this.tempFoots_.get(foot4);
                    if (tag == null) {
                        tag = pd.getPertAnnotations().getNextTempTag(new HashSet(this.tempFoots_.values()));
                        this.tempFoots_.put(foot4, tag);
                    }
                    retval.add(tag);
                    return retval;
                }
                StringBuffer buf = new StringBuffer();
                while (afit.hasNext()) {
                    buf.append((String)afit.next());
                    if (!afit.hasNext()) continue;
                    buf.append(", ");
                }
                lvobj[0] = buf.toString();
                String format5 = rMan.getString("qpcrDisplay.mixedRegionRestrictionFormat");
                String foot5 = MessageFormat.format(format5, lvobj);
                String tag = (String)this.tempFoots_.get(foot5);
                if (tag == null) {
                    tag = pd.getPertAnnotations().getNextTempTag(new HashSet(this.tempFoots_.values()));
                    this.tempFoots_.put(foot5, tag);
                }
                retval.add(tag);
                return retval;
            }
        }
        StringBuffer buf = new StringBuffer();
        Iterator lvit = rra.legacyVals.iterator();
        Iterator afit = rra.actualFoots.iterator();
        while (lvit.hasNext()) {
            buf.append("\"");
            buf.append((String)lvit.next());
            buf.append("\"");
            if (!lvit.hasNext() && !afit.hasNext()) continue;
            buf.append(", ");
        }
        while (afit.hasNext()) {
            buf.append("\"");
            buf.append((String)afit.next());
            buf.append("\"");
            if (!afit.hasNext()) continue;
            buf.append(", ");
        }
        Object[] lvobj = new Object[]{buf.toString()};
        if (rra.noRestrict == 0) {
            format = rMan.getString("qpcrDisplay.inconsistentRegionRestrictionFormat");
            foot = MessageFormat.format(format, lvobj);
        } else {
            format = rMan.getString("qpcrDisplay.inconsistentRegionRestrictionFormatWithCount");
            foot = MessageFormat.format(format, lvobj);
        }
        String tag = (String)this.tempFoots_.get(foot);
        if (tag == null) {
            tag = pd.getPertAnnotations().getNextTempTag(new HashSet(this.tempFoots_.values()));
            this.tempFoots_.put(foot, tag);
        }
        retval.add(tag);
        return retval;
    }

    private String buildRegResRegions(PerturbationData.RegionRestrict rr) {
        String region;
        StringBuffer regBuf = new StringBuffer();
        if (rr.isLegacyNullStyle()) {
            throw new IllegalArgumentException();
        }
        TreeSet<String> sorted = new TreeSet<String>();
        Iterator nrrit = rr.getRegions();
        while (nrrit.hasNext()) {
            region = (String)nrrit.next();
            sorted.add(region);
        }
        nrrit = sorted.iterator();
        while (nrrit.hasNext()) {
            region = (String)nrrit.next();
            regBuf.append(region);
            if (!nrrit.hasNext()) continue;
            regBuf.append(", ");
        }
        return regBuf.toString();
    }

    private String buildRegResFootnote(PerturbationData pd, PerturbationData.RegionRestrict rr) {
        ResourceManager rMan = ResourceManager.getManager();
        String regList = rr.isLegacyNullStyle() ? rr.getLegacyValue() : this.buildRegResRegions(rr);
        String format = rMan.getString("qpcrDisplay.regionRestrictionFormat");
        String foot = MessageFormat.format(format, regList);
        String tag = (String)this.tempFoots_.get(foot);
        if (tag == null) {
            tag = pd.getPertAnnotations().getNextTempTag(new HashSet(this.tempFoots_.values()));
            this.tempFoots_.put(foot, tag);
        }
        return tag;
    }

    private static class FormerNullFootData {
        TreeSet times = new TreeSet();
        TreeSet regions = new TreeSet();

        FormerNullFootData() {
        }

        private String getStringList(TreeSet set) {
            StringBuffer buf = new StringBuffer();
            Iterator sit = set.iterator();
            while (sit.hasNext()) {
                String str = (String)sit.next();
                buf.append("(");
                buf.append(str);
                buf.append(")");
                if (!sit.hasNext()) continue;
                buf.append(", ");
            }
            return buf.toString();
        }

        String getTimesList() {
            return this.getStringList(this.times);
        }

        String getRegionsList() {
            return this.getStringList(this.regions);
        }
    }

    private static class RegRestrictAggregation {
        TreeSet legacyVals = new TreeSet();
        TreeSet actualFoots = new TreeSet();
        int noRestrict = 0;

        RegRestrictAggregation() {
        }
    }

    private static class PertSourcesAndTargKey {
        PertSources srcs;
        String targKey;

        PertSourcesAndTargKey(PertSources srcs, String targ) {
            this.srcs = srcs;
            this.targKey = targ;
        }

        public int hashCode() {
            return this.srcs.hashCode() + this.targKey.hashCode();
        }

        public String toString() {
            return "PertSourcesAndTarg: " + this.srcs + " " + this.targKey;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof PertSourcesAndTargKey)) {
                return false;
            }
            PertSourcesAndTargKey otherSST = (PertSourcesAndTargKey)other;
            return this.srcs.equals(otherSST.srcs) && this.targKey.equals(otherSST.targKey);
        }
    }
}

