/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.qpcr;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.perturb.MeasureDictionary;
import org.systemsbiology.biotapestry.perturb.MeasureProps;
import org.systemsbiology.biotapestry.perturb.MeasureScale;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.qpcr.NullTimeSpan;
import org.systemsbiology.biotapestry.qpcr.QPCRData;
import org.systemsbiology.biotapestry.qpcr.TimeSpan;
import org.systemsbiology.biotapestry.ui.DisplayOptions;
import org.systemsbiology.biotapestry.ui.DisplayOptionsManager;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.MinMax;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UiUtil;

class QpcrTablePublisher {
    static final String STYLE = "style=\"margin:0in;margin-bottom:.0001pt;font-size:11.0pt;\"";
    static final String PSTYLE = "<p style=\"margin:0in;margin-bottom:.0001pt;font-size:11.0pt;\">";
    static final String PSTYLE_CENTER = "<p style=\"margin:0in;margin-bottom:.0001pt;font-size:11.0pt;\" align=\"center\" >";
    static final String STYLEBIG = "style=\"margin:0in;margin-bottom:.0001pt;font-size:30.0pt;\"";
    static final String PSTYLEBIG = "<p style=\"margin:0in;margin-bottom:.0001pt;font-size:30.0pt;\">";
    static final String PSTYLEBIG_CENTER = "<p style=\"margin:0in;margin-bottom:.0001pt;font-size:30.0pt;\" align=\"center\" >";
    static final String BLANK_FOR_CSS = "margin:0in;font-size:1.0pt;";
    static final String BLANK_FOR_CSS_TAG = "<span class=\"Breaker\"> </span>";
    static final String BLANK_FOR_NO_CSS = "<font size=\"1\"> </font>";
    private PrintWriter out_ = null;
    private boolean noCss_;
    private boolean bigScreen_;
    private Map spanColors_;
    private String scaleKey_;

    QpcrTablePublisher(Map colors) {
        this.noCss_ = false;
        this.bigScreen_ = false;
        this.spanColors_ = colors;
        DisplayOptions dOpt = DisplayOptionsManager.getMgr().getDisplayOptions();
        this.scaleKey_ = dOpt.getPerturbDataDisplayScaleKey();
    }

    QpcrTablePublisher(boolean bigScreen, Map colors) {
        this.noCss_ = true;
        this.bigScreen_ = false;
        this.spanColors_ = colors;
        DisplayOptions dOpt = DisplayOptionsManager.getMgr().getDisplayOptions();
        this.scaleKey_ = dOpt.getPerturbDataDisplayScaleKey();
    }

    void setOutput(PrintWriter out) {
        this.out_ = out;
    }

    boolean publish(File pubFile, QPCRData qpcr) {
        try {
            this.out_ = new PrintWriter(new BufferedWriter(new FileWriter(pubFile)));
        }
        catch (IOException ioe) {
            return false;
        }
        Indenter ind = new Indenter(this.out_, 2);
        ind.indent();
        this.out_.write("<html>\n");
        ind.up().indent();
        this.out_.write("<body>\n");
        ind.up().indent();
        this.out_.write("<style type=\"text/css\">\n");
        this.out_.write("/*<![CDATA[*/\n");
        this.out_.write("<!--\n");
        this.out_.write("p.Entry\n");
        this.out_.write("    {margin:0in;\n");
        this.out_.write("    margin-bottom:.0001pt;\n");
        this.out_.write("    font-size:10.0pt;}\n");
        this.out_.write("span.Breaker\n{");
        this.out_.write(BLANK_FOR_CSS);
        this.out_.write("}\n");
        Iterator spit = this.spanColors_.values().iterator();
        while (spit.hasNext()) {
            String spanCol = (String)spit.next();
            this.out_.write("span.Col");
            this.out_.write(spanCol);
            this.out_.write("\n");
            this.out_.write("    {margin:0in;color:");
            this.out_.write(spanCol);
            this.out_.write(";}\n");
        }
        this.out_.write("-->\n");
        this.out_.write("/*]]>*/\n");
        ind.down().indent();
        this.out_.write("</style>\n");
        qpcr.writeHTML(this.out_, ind, this);
        ind.down().indent();
        this.out_.write("</body>\n");
        ind.down().indent();
        this.out_.write("</html>\n");
        this.out_.flush();
        this.out_.close();
        return true;
    }

    void paragraph(boolean centered) {
        if (this.noCss_) {
            String use = this.bigScreen_ ? (centered ? PSTYLEBIG_CENTER : PSTYLEBIG) : (centered ? PSTYLE_CENTER : PSTYLE);
            this.out_.print(use);
        } else if (centered) {
            this.out_.print("<p class=\"Entry\" align=\"center\">");
        } else {
            this.out_.print("<p class=\"Entry\">");
        }
    }

    void breakSpace() {
        this.out_.print(this.noCss_ ? BLANK_FOR_NO_CSS : BLANK_FOR_CSS_TAG);
    }

    void openColor(String color) {
        this.out_.print(this.openColorStr(color, new StringBuffer()));
    }

    void closeColor() {
        this.out_.print(this.closeColorStr());
    }

    String openColorStr(String color, StringBuffer buf) {
        buf.setLength(0);
        if (this.noCss_) {
            buf.append("<font color=\"");
            buf.append(color);
            buf.append("\">");
        } else {
            buf.append("<span class=\"Col");
            buf.append(color);
            buf.append("\">");
        }
        return buf.toString();
    }

    String closeColorStr() {
        if (this.noCss_) {
            return "</font>";
        }
        return "</span>";
    }

    void colorsAndScaling() {
        PerturbationData pd = Database.getDB().getPertData();
        MeasureDictionary md = pd.getMeasureDictionary();
        ResourceManager rMan = ResourceManager.getManager();
        String colorNote = rMan.getString("qpcrData.colorKeyFmt");
        String scaleNote = rMan.getString("qpcrData.scaleKeyFmt");
        this.out_.print("<center><p>");
        String useScale = md.getMeasureScale(this.scaleKey_).getName();
        String note = MessageFormat.format(scaleNote, useScale);
        this.out_.print(note);
        this.out_.println("</p></center>");
        Object[] str = new Object[7];
        StringBuffer buf = new StringBuffer();
        this.out_.println("<ul>");
        Iterator cit = this.spanColors_.keySet().iterator();
        while (cit.hasNext()) {
            this.out_.print("<li>");
            String measureKey = (String)cit.next();
            MeasureProps mp = md.getMeasureProps(measureKey);
            MeasureScale ms = md.getMeasureScale(mp.getScaleKey());
            String col = (String)this.spanColors_.get(measureKey);
            str[0] = mp.getName();
            str[1] = this.openColorStr(col, buf);
            str[2] = col;
            str[3] = this.closeColorStr();
            str[4] = ms.getName();
            str[5] = UiUtil.doubleFormat(mp.getNegThresh(), false);
            str[6] = UiUtil.doubleFormat(mp.getPosThresh(), false);
            String cnote = MessageFormat.format(colorNote, str);
            this.out_.print(cnote);
            this.out_.println("</li>");
        }
        this.out_.println("</ul>");
    }

    void valueSignPrefix(String value) {
        if (this.scaleKey_.equals("0")) {
            return;
        }
        if (Character.isDigit(value.charAt(0))) {
            this.out_.print("+");
        }
    }

    void writePerturbationHeader(Indenter ind, NullTimeSpan span) {
        ind.indent();
        this.out_.println("<p></p>");
        ind.indent();
        this.out_.println("<table border=\"0\">");
        ind.up().indent();
        this.out_.println("<tr valign=\"top\">");
        ind.up().indent();
        this.out_.println("<td width=\"120\" height=\"22\">");
        ind.up().indent();
        this.paragraph(false);
        this.out_.println("<b>Perturbation:</b></p>");
        ind.down().indent();
        this.out_.println("</td>");
        ind.indent();
        this.out_.println("<td>");
        ind.up().indent();
        ResourceManager rMan = ResourceManager.getManager();
        String tabNote = rMan.getString("qpcrData.nullTableNote");
        MinMax tc = new MinMax(span.getMin(), span.getMax());
        String tdisp = TimeSpan.spanToString(tc);
        if (!span.isASpan()) {
            StringBuffer spanBuf = new StringBuffer();
            String subNoteSingle = rMan.getString("qpcrData.nullTableNoteSingle");
            spanBuf.append(subNoteSingle);
            spanBuf.append(" ");
            spanBuf.append(tdisp);
            tdisp = spanBuf.toString();
        }
        String note = MessageFormat.format(tabNote, tdisp);
        this.paragraph(false);
        this.out_.print("<b>");
        this.out_.print(note);
        this.out_.println("</b></p>");
        ind.down().indent();
        this.out_.println("</td>");
        ind.down().indent();
        this.out_.println("</tr>");
    }
}

