/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.qpcr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.TimeAxisDefinition;
import org.systemsbiology.biotapestry.parser.ParserClient;
import org.systemsbiology.biotapestry.qpcr.Batch;
import org.systemsbiology.biotapestry.qpcr.Footnote;
import org.systemsbiology.biotapestry.qpcr.Measurement;
import org.systemsbiology.biotapestry.qpcr.NullPerturb;
import org.systemsbiology.biotapestry.qpcr.NullTarget;
import org.systemsbiology.biotapestry.qpcr.NullTimeSpan;
import org.systemsbiology.biotapestry.qpcr.Perturbation;
import org.systemsbiology.biotapestry.qpcr.QPCRData;
import org.systemsbiology.biotapestry.qpcr.QpcrLegacyPublicExposed;
import org.systemsbiology.biotapestry.qpcr.Source;
import org.systemsbiology.biotapestry.qpcr.TargetGene;
import org.systemsbiology.biotapestry.qpcr.TimeSpan;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.MinMax;
import org.xml.sax.Attributes;

class QpcrXmlFormatFactory
implements ParserClient {
    private static final int NO_TARGET_ = 0;
    private static final int NAME_TARGET_ = 1;
    private static final int SOURCE_TARGET_ = 2;
    private static final int FOOT_TARGET_ = 3;
    private static final int PERT_TARGET_ = 4;
    private static final int COLUMN_TARGET_ = 5;
    private HashSet allKeys_;
    private Set qpcrKeys_;
    private Set targKeys_;
    private Set nullPertKeys_;
    private Set nullTargKeys_;
    private Set nullSpanKeys_;
    private Set footKeys_;
    private Set pertKeys_;
    private Set batchKeys_;
    private Set measKeys_;
    private Set spanKeys_;
    private String regionRestrictKey_;
    private Set sourceKeys_;
    private Set nullSourceKeys_;
    private Set defaultNullSpanKeys_;
    private Object container_;
    private TargetGene currTarg_;
    private Perturbation currPerturb_;
    private Batch currBatch_;
    private Source currSource_;
    private TimeSpan currSpan_;
    private Footnote currFoot_;
    private NullPerturb currNPert_;
    private NullTarget currNullTarg_;
    private String currMapKey_;
    private ArrayList currMapList_;
    private String nameKey_;
    private String colKey_;
    private String colRangeKey_;
    private String dmKey_;
    private String useKey_;
    private int charTarg_;
    private QPCRData qpcr_;
    private StringBuffer buf_;
    private boolean mapsAreIllegal_;
    private boolean serialNumberIsIllegal_;
    private NullTimeSpan pendingDefaultNullTimeSpan_;
    private long origSerialNumber_;

    QpcrXmlFormatFactory(boolean mapsAreIllegal, boolean serialNumberIsIllegal) {
        this.mapsAreIllegal_ = mapsAreIllegal;
        this.serialNumberIsIllegal_ = serialNumberIsIllegal;
        this.allKeys_ = new HashSet();
        this.qpcrKeys_ = QPCRData.keywordsOfInterest();
        this.targKeys_ = TargetGene.keywordsOfInterest();
        this.nullPertKeys_ = NullPerturb.keywordsOfInterest();
        this.footKeys_ = Footnote.keywordsOfInterest();
        this.pertKeys_ = Perturbation.keywordsOfInterest();
        this.batchKeys_ = Batch.keywordsOfInterest();
        this.measKeys_ = Measurement.keywordsOfInterest();
        this.spanKeys_ = TimeSpan.keywordsOfInterest();
        this.regionRestrictKey_ = TimeSpan.regionRestrictKeyword();
        this.sourceKeys_ = Source.keywordsOfInterest(false);
        this.nullSourceKeys_ = Source.keywordsOfInterest(true);
        this.nameKey_ = Perturbation.nameKeyword();
        this.colKey_ = QPCRData.columnKeyword();
        this.colRangeKey_ = QPCRData.columnRangeKeyword();
        this.dmKey_ = QPCRData.datamapKeyword();
        this.useKey_ = QPCRData.useqpcrKeyword();
        this.nullTargKeys_ = NullTarget.keywordsOfInterest();
        this.nullSpanKeys_ = NullTimeSpan.keywordsOfInterest(false);
        this.defaultNullSpanKeys_ = NullTimeSpan.keywordsOfInterest(true);
        this.allKeys_ = new HashSet();
        this.allKeys_.addAll(this.qpcrKeys_);
        this.buf_ = new StringBuffer();
        this.charTarg_ = 0;
        this.pendingDefaultNullTimeSpan_ = null;
    }

    QPCRData getQPCR() {
        return this.qpcr_;
    }

    public void setContainer(Object container) {
        this.container_ = container;
    }

    public boolean finishElement(String elemName) throws IOException {
        if (this.qpcr_ != null && this.qpcr_.getSerialNumber() != this.origSerialNumber_) {
            throw new IOException();
        }
        if (elemName.equals("i")) {
            this.buf_.append("</i>");
        } else if (elemName.equals("sup")) {
            this.buf_.append("</sup>");
        } else if (elemName.equals("sub")) {
            this.buf_.append("</sub>");
        } else if (elemName.equals(this.dmKey_)) {
            this.qpcr_.addCombinedDataMaps(this.currMapKey_, this.currMapList_);
            this.currMapList_ = null;
        } else {
            switch (this.charTarg_) {
                case 1: {
                    this.currPerturb_.addInvestigator(CharacterEntityMapper.unmapEntities(this.buf_.toString(), false));
                    this.charTarg_ = 0;
                    break;
                }
                case 2: {
                    this.currSource_.setBaseValue(CharacterEntityMapper.unmapEntities(this.buf_.toString(), false));
                    this.charTarg_ = 0;
                    break;
                }
                case 3: {
                    this.currFoot_.setNote(this.buf_.toString());
                    this.charTarg_ = 0;
                    break;
                }
                case 4: {
                    this.currNPert_.setNote(this.buf_.toString(), this.qpcr_);
                    this.charTarg_ = 0;
                    break;
                }
                case 5: {
                    String colStr = CharacterEntityMapper.unmapEntities(this.buf_.toString(), false);
                    int min = QPCRData.getMinimum(colStr);
                    int max = QPCRData.getMaximum(colStr);
                    this.qpcr_.addColumn(new MinMax(min, max));
                    this.charTarg_ = 0;
                    break;
                }
            }
        }
        return this.allKeys_.contains(elemName);
    }

    public void processCharacters(char[] chars, int start, int length) {
        String nextString = new String(chars, start, length);
        this.buf_.append(nextString);
    }

    public Set keywordsOfInterest() {
        return this.allKeys_;
    }

    public Object processElement(String elemName, Attributes attrs) throws IOException {
        if (attrs == null || elemName == null) {
            return null;
        }
        if (this.qpcr_ != null && this.qpcr_.getSerialNumber() != this.origSerialNumber_) {
            throw new IOException();
        }
        if (this.qpcrKeys_.contains(elemName)) {
            QPCRData qpcr = QPCRData.buildFromXML(elemName, attrs, this.serialNumberIsIllegal_);
            if (qpcr != null) {
                Database.getDB().getPertData().setLegacyQPCR(new QpcrLegacyPublicExposed(qpcr));
                this.qpcr_ = qpcr;
                this.origSerialNumber_ = this.qpcr_.getSerialNumber();
            }
        } else if (this.targKeys_.contains(elemName)) {
            TargetGene tgene = TargetGene.buildFromXML(elemName, attrs);
            if (tgene != null) {
                if (!this.qpcr_.hasColumns()) {
                    throw new IOException();
                }
                this.qpcr_.addGene(tgene, false);
                this.currTarg_ = tgene;
            }
        } else if (this.nullPertKeys_.contains(elemName)) {
            NullPerturb np = NullPerturb.buildFromXML(elemName, attrs);
            if (np != null) {
                if (this.pendingDefaultNullTimeSpan_ != null) {
                    this.qpcr_.setNullPerturbationsDefaultTimeSpan(this.pendingDefaultNullTimeSpan_);
                    this.pendingDefaultNullTimeSpan_ = null;
                }
                this.qpcr_.addNullPerturbation(np);
                this.currNPert_ = np;
                this.charTarg_ = 4;
                this.buf_.setLength(0);
            }
        } else if (this.footKeys_.contains(elemName)) {
            Footnote fn = Footnote.buildFromXML(elemName, attrs);
            if (fn != null) {
                this.qpcr_.addFootnote(fn);
                this.currFoot_ = fn;
                this.charTarg_ = 3;
                this.buf_.setLength(0);
            }
        } else if (this.pertKeys_.contains(elemName)) {
            Perturbation pert = Perturbation.buildFromXML(elemName, attrs);
            if (pert != null) {
                this.currTarg_.addPerturbation(pert);
                this.currPerturb_ = pert;
            }
        } else if (this.sourceKeys_.contains(elemName)) {
            Source src = Source.buildFromXML(elemName, attrs);
            if (src != null) {
                this.currPerturb_.addSource(src);
                this.currSource_ = src;
                this.charTarg_ = 2;
                this.buf_.setLength(0);
            }
        } else if (this.nullSourceKeys_.contains(elemName)) {
            Source src = Source.buildFromXML(elemName, attrs);
            if (src != null) {
                this.currNPert_.addSource(src);
                this.currSource_ = src;
                this.charTarg_ = 2;
                this.buf_.setLength(0);
            }
        } else if (this.nullTargKeys_.contains(elemName)) {
            NullTarget nt = NullTarget.buildFromXML(elemName, attrs);
            if (nt != null) {
                this.currNPert_.addTarget(nt);
                this.currNullTarg_ = nt;
            }
        } else if (this.nullSpanKeys_.contains(elemName)) {
            NullTimeSpan nts = NullTimeSpan.buildFromXML(elemName, attrs);
            if (nts != null) {
                this.currNullTarg_.addTimeSpan(nts);
            }
        } else if (this.defaultNullSpanKeys_.contains(elemName)) {
            NullTimeSpan nts = NullTimeSpan.buildFromXML(elemName, attrs);
            if (nts != null) {
                MinMax mm = TimeAxisDefinition.getLegacyDefaultTimeSpan();
                NullTimeSpan legNts = new NullTimeSpan(mm.min, mm.max);
                if (!legNts.equals(nts)) {
                    this.qpcr_.setNullPerturbationsDefaultTimeSpan(nts);
                } else {
                    this.pendingDefaultNullTimeSpan_ = nts;
                }
            }
        } else if (this.spanKeys_.contains(elemName)) {
            TimeSpan span = TimeSpan.buildFromXML(elemName, attrs);
            if (span != null) {
                this.currPerturb_.addTime(span);
                this.currSpan_ = span;
            }
        } else if (elemName.equals(this.regionRestrictKey_)) {
            String region = TimeSpan.getRegionRestrictFromXML(elemName, attrs);
            if (region != null) {
                this.currSpan_.addRegionRestriction(region);
            }
        } else if (this.batchKeys_.contains(elemName)) {
            Batch bat = Batch.buildFromXML(elemName, attrs);
            if (bat != null) {
                if (Batch.isForNull(elemName)) {
                    this.currNullTarg_.addBatch(bat);
                } else {
                    this.currSpan_.addBatch(bat);
                }
                this.currBatch_ = bat;
            }
        } else if (this.measKeys_.contains(elemName)) {
            Measurement meas = Measurement.buildFromXML(elemName, attrs, this.qpcr_.getThresholdValue());
            if (meas != null) {
                this.currBatch_.addMeasurement(meas);
            }
        } else if (elemName.equals(this.nameKey_)) {
            this.charTarg_ = 1;
            this.buf_.setLength(0);
        } else if (elemName.equals(this.colKey_)) {
            this.charTarg_ = 5;
            this.buf_.setLength(0);
        } else if (elemName.equals(this.colRangeKey_)) {
            MinMax colRange = QPCRData.extractColumnRange(elemName, attrs);
            this.qpcr_.addColumn(colRange);
        } else if (elemName.equals(this.dmKey_)) {
            if (this.mapsAreIllegal_) {
                throw new IOException();
            }
            this.currMapKey_ = QPCRData.extractMapKey(elemName, attrs);
            this.currMapList_ = new ArrayList();
        } else if (elemName.equals(this.useKey_)) {
            if (this.mapsAreIllegal_) {
                throw new IOException();
            }
            this.currMapList_.add(QPCRData.extractUseQPCR(elemName, attrs));
        } else if (elemName.equals("i")) {
            this.buf_.append("<i>");
        } else if (elemName.equals("sup")) {
            this.buf_.append("<sup>");
        } else if (elemName.equals("sub")) {
            this.buf_.append("<sub>");
        }
        return null;
    }
}

