/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.qpcr;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.systemsbiology.biotapestry.qpcr.QpcrTablePublisher;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.Splitter;
import org.xml.sax.Attributes;

class Source
implements Cloneable {
    static final int NO_PROXY_INDEX = 0;
    static final String NO_PROXY = "noProxy";
    static final String SAME_SIGN_PROXY = "sameSign";
    static final String OPPOSITE_SIGN_PROXY = "oppositeSign";
    static final String MASO_TYPE = "MASO";
    static final String MOE_TYPE = "MOE";
    static final String ENGRAILED_TYPE = "Engrailed";
    private String value_;
    private String notes_;
    private String proxyFor_;
    private String proxySign_;
    private String expType_;

    Source(String notes, String type, String proxyFor, String proxySign) throws IOException {
        this.notes_ = notes;
        if (proxySign == null) {
            this.proxySign_ = NO_PROXY;
        } else {
            if (!(proxySign.equals(NO_PROXY) || proxySign.equals(SAME_SIGN_PROXY) || proxySign.equals(OPPOSITE_SIGN_PROXY))) {
                throw new IOException();
            }
            this.proxySign_ = proxySign;
        }
        if (type == null) {
            this.expType_ = null;
        } else {
            if (!(type.equals(MASO_TYPE) || type.equals(MOE_TYPE) || type.equals(ENGRAILED_TYPE))) {
                throw new IOException();
            }
            this.expType_ = type;
        }
        if (proxyFor != null && this.proxySign_.equals(NO_PROXY)) {
            throw new IOException();
        }
        this.proxyFor_ = proxyFor;
    }

    Source(String notes) {
        this.notes_ = notes;
        this.proxyFor_ = null;
        this.proxySign_ = NO_PROXY;
    }

    Source(String base, String experiment) {
        base = base.replaceAll(" ", "");
        experiment = experiment.replaceAll(" ", "");
        this.value_ = base;
        this.expType_ = experiment.toUpperCase().equals("EN") ? ENGRAILED_TYPE : experiment.toUpperCase();
        this.proxyFor_ = null;
        this.proxySign_ = NO_PROXY;
    }

    Source(Source other) {
        this.value_ = other.value_;
        this.notes_ = other.notes_;
        this.proxyFor_ = other.proxyFor_;
        this.proxySign_ = other.proxySign_;
        this.expType_ = other.expType_;
    }

    Source() {
        this.proxyFor_ = null;
        this.proxySign_ = NO_PROXY;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }

    String getExpType() {
        return this.expType_;
    }

    String getBaseType() {
        return this.value_;
    }

    String getDisplayValue() {
        if (this.expType_.equals(ENGRAILED_TYPE)) {
            return this.value_ + "-En";
        }
        return this.value_ + " " + this.expType_;
    }

    String getDisplayValueWithSuperScript() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getDisplayValue());
        if (this.notes_ != null) {
            buf.append("<sup>");
            buf.append(this.notes_);
            buf.append("</sup>");
        }
        return buf.toString();
    }

    String getNotes() {
        return this.notes_;
    }

    void setDisplayValue(String value) throws IOException {
        if (value.indexOf("-En") != -1) {
            this.expType_ = ENGRAILED_TYPE;
        } else if (value.indexOf(MASO_TYPE) != -1) {
            this.expType_ = MASO_TYPE;
        } else if (value.indexOf(MOE_TYPE) != -1) {
            this.expType_ = MOE_TYPE;
        } else {
            throw new IOException();
        }
        int index = value.lastIndexOf(" ");
        if (index != -1) {
            this.value_ = value.substring(0, index);
            return;
        }
        index = value.indexOf("-");
        if (index != -1) {
            this.value_ = value.substring(0, index);
            return;
        }
        throw new IOException();
    }

    void setBaseValue(String baseValue) {
        this.value_ = baseValue.replaceAll(" ", "");
    }

    void setValue(String value, String exp) {
        this.value_ = value;
        this.expType_ = exp;
    }

    void setNotes(String notes) {
        this.notes_ = notes;
    }

    List getFootnoteNumbers() {
        if (this.notes_ != null) {
            return Splitter.stringBreak(this.notes_, ",", 0, true);
        }
        return new ArrayList();
    }

    String getProxiedSpecies() {
        return this.proxyFor_;
    }

    void setProxiedSpecies(String species) {
        this.proxyFor_ = species;
    }

    String getProxySign() {
        return this.proxySign_;
    }

    void setProxySign(String proxySign) {
        this.proxySign_ = proxySign;
    }

    void writeHTML(PrintWriter out, Indenter ind, boolean hasNext, QpcrTablePublisher qtp, boolean doBold) {
        ind.indent();
        qtp.paragraph(false);
        if (doBold) {
            out.print("<b>");
        }
        out.print(this.getDisplayValueWithSuperScript());
        if (hasNext) {
            out.print(" +");
        }
        if (doBold) {
            out.print("</b>");
        }
        out.println("</p>");
    }

    public String toString() {
        return "Source: value = " + this.value_ + " notes = " + this.notes_;
    }

    static Set keywordsOfInterest(boolean forNull) {
        HashSet<String> retval = new HashSet<String>();
        retval.add(forNull ? "nullSource" : "source");
        return retval;
    }

    static Source buildFromXML(String elemName, Attributes attrs) throws IOException {
        if (!elemName.equals("source") && !elemName.equals("nullSource")) {
            return null;
        }
        String notes = null;
        String proxySpecies = null;
        String proxySign = null;
        String type = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("notes")) {
                    notes = val;
                    continue;
                }
                if (key.equals("proxySign")) {
                    proxySign = val;
                    continue;
                }
                if (key.equals("proxy")) {
                    proxySpecies = CharacterEntityMapper.unmapEntities(val, false);
                    continue;
                }
                if (!key.equals("type")) continue;
                type = val;
            }
        }
        return new Source(notes, type, proxySpecies, proxySign);
    }
}

