/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.qpcr;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import org.systemsbiology.biotapestry.qpcr.Perturbation;
import org.systemsbiology.biotapestry.qpcr.QpcrTablePublisher;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.Splitter;
import org.xml.sax.Attributes;

class TargetGene {
    private String notes_;
    private String name_;
    private ArrayList perturbations_;

    TargetGene(String name, String notes) {
        this.name_ = name;
        this.notes_ = notes;
        this.perturbations_ = new ArrayList();
    }

    TargetGene(TargetGene other) {
        this.notes_ = other.notes_;
        this.name_ = other.name_;
        this.perturbations_ = new ArrayList();
        Iterator opit = other.perturbations_.iterator();
        while (opit.hasNext()) {
            this.perturbations_.add(new Perturbation((Perturbation)opit.next()));
        }
    }

    String getName() {
        return this.name_;
    }

    void setName(String name) {
        this.name_ = name;
    }

    String getNotes() {
        return this.notes_;
    }

    void addPerturbation(Perturbation perturbation) {
        this.perturbations_.add(perturbation);
    }

    void deletePerturbation(int index) {
        this.perturbations_.remove(index);
    }

    Iterator getPerturbations() {
        return this.perturbations_.iterator();
    }

    Perturbation getPerturbation(int i) {
        return (Perturbation)this.perturbations_.get(i);
    }

    Set getFootnoteNumbers() {
        HashSet retval = new HashSet();
        Iterator pers = this.getPerturbations();
        while (pers.hasNext()) {
            Perturbation per = (Perturbation)pers.next();
            Set notes = per.getFootnoteNumbers();
            retval.addAll(notes);
        }
        if (this.notes_ != null) {
            ArrayList foots = Splitter.stringBreak(this.notes_, ",", 0, true);
            retval.addAll(foots);
        }
        return retval;
    }

    List getTranslatedNotes() {
        if (this.notes_ != null) {
            return Splitter.stringBreak(this.notes_, ",", 0, true);
        }
        return new ArrayList();
    }

    int writeHTML(PrintWriter out, Indenter ind, ArrayList timeCols, QpcrTablePublisher qtp, int rowCount, boolean breakOutInvest, List srcNames, Set usedFootnotes) {
        SortedMap gpi;
        Iterator pit;
        ind.indent();
        out.println("<tbody>");
        ind.up();
        String geneName = this.name_;
        if (this.notes_ != null) {
            geneName = geneName + "<sup>" + this.notes_ + "</sup>";
            usedFootnotes.addAll(this.getTranslatedNotes());
        }
        ArrayList perInvest = null;
        int totalCount = 0;
        Iterator tcpit = this.getPerturbations();
        while (tcpit.hasNext()) {
            Perturbation p = (Perturbation)tcpit.next();
            if (!p.matchesForHTML(srcNames)) continue;
            ++totalCount;
        }
        if (breakOutInvest) {
            perInvest = new ArrayList();
            pit = this.getPerturbations();
            while (pit.hasNext()) {
                Perturbation p = (Perturbation)pit.next();
                p.prepForHTML(perInvest, srcNames);
            }
            totalCount = 0;
            int numPI = perInvest.size();
            for (int i = 0; i < numPI; ++i) {
                gpi = (SortedMap)perInvest.get(i);
                totalCount += gpi.keySet().size();
            }
        }
        pit = this.getPerturbations();
        int count = 0;
        while (pit.hasNext()) {
            Perturbation p = (Perturbation)pit.next();
            if (!p.writeHTML(out, ind, geneName, totalCount, timeCols, qtp, gpi = perInvest != null ? (SortedMap)perInvest.get(count) : null, breakOutInvest, srcNames)) continue;
            Set notes = p.getFootnoteNumbers();
            usedFootnotes.addAll(notes);
            ++count;
            geneName = null;
        }
        ind.down().indent();
        out.println("</tbody>");
        return rowCount + totalCount;
    }

    Set getSources() {
        HashSet<String> retval = new HashSet<String>();
        Iterator pit = this.getPerturbations();
        while (pit.hasNext()) {
            Perturbation p = (Perturbation)pit.next();
            if (p.getSourceCount() != 1) continue;
            String srcName = p.getCombinedSourceName(false);
            retval.add(srcName.toUpperCase().replaceAll(" ", ""));
        }
        return retval;
    }

    static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("targetGene");
        retval.add("perturbations");
        return retval;
    }

    public String toString() {
        return "TargetGene: name = " + this.name_ + " notes = " + this.notes_ + " perturbations = " + this.perturbations_;
    }

    static TargetGene buildFromXML(String elemName, Attributes attrs) throws IOException {
        if (!elemName.equals("targetGene")) {
            return null;
        }
        String name = null;
        String notes = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("name")) {
                    name = CharacterEntityMapper.unmapEntities(val, false);
                    continue;
                }
                if (!key.equals("notes")) continue;
                notes = val;
            }
        }
        if (name == null) {
            throw new IOException();
        }
        return new TargetGene(name, notes);
    }
}

