/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.qpcr;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.TimeAxisDefinition;
import org.systemsbiology.biotapestry.qpcr.Batch;
import org.systemsbiology.biotapestry.qpcr.QPCRData;
import org.systemsbiology.biotapestry.qpcr.QpcrTablePublisher;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.MinMax;
import org.xml.sax.Attributes;

class TimeSpan {
    static final String XML_TAG_REGION_RESTRICT = "regionRestriction";
    private int minTime_;
    private int maxTime_;
    private ArrayList batches_;
    private ArrayList regionRestrictions_;

    TimeSpan(int minVal, int maxVal) {
        this.minTime_ = minVal;
        this.maxTime_ = maxVal;
        this.batches_ = new ArrayList();
        this.regionRestrictions_ = new ArrayList();
    }

    TimeSpan(MinMax mm) {
        this.minTime_ = mm.min;
        this.maxTime_ = mm.max;
        this.batches_ = new ArrayList();
        this.regionRestrictions_ = new ArrayList();
    }

    TimeSpan(TimeSpan other) {
        this.minTime_ = other.minTime_;
        this.maxTime_ = other.maxTime_;
        this.batches_ = new ArrayList();
        Iterator obit = other.batches_.iterator();
        while (obit.hasNext()) {
            this.batches_.add(new Batch((Batch)obit.next()));
        }
        this.regionRestrictions_ = new ArrayList();
        Iterator orrit = other.regionRestrictions_.iterator();
        while (orrit.hasNext()) {
            this.regionRestrictions_.add((String)orrit.next());
        }
    }

    void getNonStandardTimes(Set nonStd) {
        Iterator bit = this.getBatches();
        while (bit.hasNext()) {
            Batch b = (Batch)bit.next();
            b.getNonStandardTimes(nonStd, this.minTime_, this.maxTime_);
        }
    }

    boolean hasStandardTime() {
        Iterator bit = this.getBatches();
        while (bit.hasNext()) {
            Batch b = (Batch)bit.next();
            if (!b.hasStandardTime(this.minTime_, this.maxTime_)) continue;
            return true;
        }
        return false;
    }

    String getSpanAsString() {
        return TimeSpan.spanToString(new MinMax(this.minTime_, this.maxTime_));
    }

    MinMax getMinMaxSpan() {
        return new MinMax(this.minTime_, this.maxTime_);
    }

    public void addBatch(Batch batch) {
        this.batches_.add(batch);
    }

    Iterator getBatches() {
        return this.batches_.iterator();
    }

    Iterator getBatchesForTime(int time) {
        ArrayList<Batch> retvalBase = new ArrayList<Batch>();
        Iterator bit = this.batches_.iterator();
        while (bit.hasNext()) {
            Batch b = (Batch)bit.next();
            int myTime = b.getTimeNumber();
            if (myTime != time) continue;
            retvalBase.add(b);
        }
        return retvalBase.iterator();
    }

    int getBatchCount() {
        return this.batches_.size();
    }

    void deleteBatch(int index) {
        this.batches_.remove(index);
    }

    Batch getBatch(int index) {
        return (Batch)this.batches_.get(index);
    }

    public Batch getBatchWithIDAndInvest(String batchID, String invest) {
        int nsb = this.batches_.size();
        for (int i = 0; i < nsb; ++i) {
            String chkInvest;
            Batch checkit = (Batch)this.batches_.get(i);
            String batchKey = checkit.getBatchKey();
            if (batchKey == null || !batchKey.equals(batchID) || !((chkInvest = checkit.getInvestigators()) == null ? invest == null : chkInvest.equals(invest))) continue;
            return checkit;
        }
        return null;
    }

    void addRegionRestriction(String regionID) {
        this.regionRestrictions_.add(regionID);
    }

    void deleteRegionRestriction(int index) {
        this.regionRestrictions_.remove(index);
    }

    void clearRegionRestrictions() {
        this.regionRestrictions_.clear();
    }

    Iterator getRegionRestrictions() {
        return this.regionRestrictions_.iterator();
    }

    String getRegionRestriction(int index) {
        return (String)this.regionRestrictions_.get(index);
    }

    boolean haveRegionRestrictions() {
        return this.regionRestrictions_.size() > 0;
    }

    void replaceRegionRestriction(int index, String reg) {
        this.regionRestrictions_.set(index, reg);
    }

    Set getFootnoteNumbers() {
        HashSet retval = new HashSet();
        Iterator bats = this.getBatches();
        while (bats.hasNext()) {
            Batch bat = (Batch)bats.next();
            Set batNotes = bat.getFootnoteNumbers();
            retval.addAll(batNotes);
        }
        return retval;
    }

    SpanTimeProfile getBatchTimeProfile() {
        SpanTimeProfile retval = new SpanTimeProfile();
        Iterator bit = this.getBatches();
        while (bit.hasNext()) {
            Batch b = (Batch)bit.next();
            int time = b.getTimeNumber();
            if (time == -1) {
                retval.hasUntimedBatches = true;
                continue;
            }
            retval.batchTimes.add(new Integer(time));
        }
        this.getNonStandardTimes(retval.nonStandardTimes);
        return retval;
    }

    void writeHTML(PrintWriter out, Indenter ind, QpcrTablePublisher qtp, SpanTimeProfile spt) {
        boolean multiTimes;
        ind.indent();
        qtp.paragraph(false);
        int timedBatchCount = spt.batchTimes.size();
        boolean bl = multiTimes = timedBatchCount > 1;
        if (multiTimes) {
            Iterator btit = spt.batchTimes.iterator();
            while (btit.hasNext()) {
                Integer batchTime = (Integer)btit.next();
                Iterator bftit = this.getBatchesForTime(batchTime);
                if (!bftit.hasNext()) continue;
                out.print("(");
                this.writeDetailedHTML(bftit, out, ind, qtp, batchTime);
                out.print(" [");
                String tdisp = TimeAxisDefinition.getTimeDisplay(batchTime, true, true);
                tdisp = tdisp.replaceAll(" ", "&nbsp;");
                out.print(tdisp);
                out.print("])");
                out.print("</p>");
                qtp.paragraph(false);
            }
            Iterator bit = this.getBatchesForTime(-1);
            this.writeDetailedHTML(bit, out, ind, qtp, null);
        } else {
            Iterator bit = this.getBatches();
            this.writeDetailedHTML(bit, out, ind, qtp, null);
        }
        out.println("</p>");
    }

    private void writeDetailedHTML(Iterator bit, PrintWriter out, Indenter ind, QpcrTablePublisher qtp, Integer batchTime) {
        while (bit.hasNext()) {
            Batch b = (Batch)bit.next();
            b.writeHTML(out, ind, qtp, batchTime);
            if (!bit.hasNext()) continue;
            out.print("/");
            qtp.breakSpace();
        }
    }

    static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("timeSpan");
        return retval;
    }

    static String regionRestrictKeyword() {
        return XML_TAG_REGION_RESTRICT;
    }

    public String toString() {
        return "TimeSpan: min = " + this.minTime_ + " max = " + this.maxTime_ + " batches = " + this.batches_;
    }

    static TimeSpan buildFromXML(String elemName, Attributes attrs) throws IOException {
        if (!elemName.equals("timeSpan")) {
            return null;
        }
        String legacySpan = null;
        String minValStr = null;
        String maxValStr = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("span")) {
                    legacySpan = val;
                    continue;
                }
                if (key.equals("min")) {
                    minValStr = val;
                    continue;
                }
                if (!key.equals("max")) continue;
                maxValStr = val;
            }
        }
        if (legacySpan != null) {
            return new TimeSpan(legacySpan);
        }
        if (minValStr != null) {
            try {
                int minVal;
                int maxVal = minVal = Integer.parseInt(minValStr);
                if (maxValStr != null) {
                    maxVal = Integer.parseInt(maxValStr);
                }
                if (!TimeSpan.spanIsOk(minVal, maxVal)) {
                    throw new IOException();
                }
                return new TimeSpan(minVal, maxVal);
            }
            catch (NumberFormatException ex) {
                throw new IOException();
            }
        }
        throw new IOException();
    }

    static String getRegionRestrictFromXML(String elemName, Attributes attrs) throws IOException {
        String region = AttributeExtractor.extractAttribute(elemName, attrs, XML_TAG_REGION_RESTRICT, "region", true);
        return region;
    }

    static String spanToString(MinMax bounds) {
        String maxStr;
        String minStr;
        TimeAxisDefinition tad = Database.getDB().getTimeAxisDefinition();
        String displayUnitAbbrev = tad.unitDisplayAbbrev();
        boolean abbreviate = false;
        if (tad.haveNamedStages()) {
            TimeAxisDefinition.NamedStage minStage = tad.getNamedStageForIndex(bounds.min);
            TimeAxisDefinition.NamedStage maxStage = tad.getNamedStageForIndex(bounds.max);
            minStr = abbreviate ? minStage.abbrev : minStage.name;
            maxStr = abbreviate ? maxStage.abbrev : maxStage.name;
        } else {
            minStr = Integer.toString(bounds.min);
            maxStr = Integer.toString(bounds.max);
        }
        StringBuffer buf = new StringBuffer();
        if (tad.unitsAreASuffix()) {
            buf.append(minStr);
            if (!minStr.equals(maxStr)) {
                buf.append("-");
                buf.append(maxStr);
            }
            buf.append(" ");
            buf.append(displayUnitAbbrev);
        } else {
            buf.append(displayUnitAbbrev);
            buf.append(" ");
            buf.append(minStr);
            if (!minStr.equals(maxStr)) {
                buf.append("-");
                buf.append(maxStr);
            }
        }
        return buf.toString();
    }

    private TimeSpan(String legacySpan) throws IOException {
        try {
            this.minTime_ = QPCRData.getMinimum(legacySpan);
            this.maxTime_ = QPCRData.getMaximum(legacySpan);
        }
        catch (IllegalArgumentException ex) {
            throw new IOException();
        }
        if (!TimeSpan.spanIsOk(this.minTime_, this.maxTime_)) {
            throw new IOException();
        }
        this.batches_ = new ArrayList();
        this.regionRestrictions_ = new ArrayList();
    }

    private static boolean spanIsOk(int min, int max) {
        Database db = Database.getDB();
        TimeAxisDefinition tad = db.getTimeAxisDefinition();
        return tad.spanIsOk(min, max);
    }

    static class SpanTimeProfile {
        TreeSet batchTimes = new TreeSet();
        HashSet nonStandardTimes = new HashSet();
        boolean hasUntimedBatches = false;

        SpanTimeProfile() {
        }
    }
}

