/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.timeCourse;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.DBGenome;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.timeCourse.CopiesPerEmbryoChange;
import org.systemsbiology.biotapestry.timeCourse.CopiesPerEmbryoGene;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.Indenter;
import org.xml.sax.Attributes;

public class CopiesPerEmbryoData {
    private ArrayList genes_ = new ArrayList();
    private HashMap gpeMap_ = new HashMap();
    private TreeSet defaultTimes_ = new TreeSet();

    public boolean haveData() {
        if (!this.genes_.isEmpty()) {
            return true;
        }
        if (!this.gpeMap_.isEmpty()) {
            return true;
        }
        return !this.defaultTimes_.isEmpty();
    }

    public boolean haveCustomMapForNode(String nodeID) {
        if (!this.haveData()) {
            return false;
        }
        List mapped = (List)this.gpeMap_.get(nodeID);
        return mapped != null && mapped.size() != 0;
    }

    public boolean haveDataForNode(String nodeID) {
        if (!this.haveData()) {
            return false;
        }
        List mapped = this.getPerEmbryoCountDataKeysWithDefault(nodeID);
        if (mapped == null) {
            return false;
        }
        Iterator mit = mapped.iterator();
        while (mit.hasNext()) {
            String name = (String)mit.next();
            if (this.getCopyPerEmbryroData(name) == null) continue;
            return true;
        }
        return false;
    }

    public boolean haveDataForNodeOrName(String nodeID, String deadName) {
        if (!this.haveData()) {
            return false;
        }
        List mapped = this.getPerEmbryoCountDataKeysWithDefaultGivenName(nodeID, deadName);
        if (mapped == null) {
            return false;
        }
        Iterator mit = mapped.iterator();
        while (mit.hasNext()) {
            String name = (String)mit.next();
            if (this.getCopyPerEmbryroData(name) == null) continue;
            return true;
        }
        return false;
    }

    public void changeUndo(CopiesPerEmbryoChange undo) {
        if (undo.mapListOrig != null || undo.mapListNew != null) {
            this.mapChangeUndo(undo);
        } else if (undo.gOrig != null || undo.gNew != null) {
            this.geneChangeUndo(undo);
        }
    }

    public void changeRedo(CopiesPerEmbryoChange undo) {
        if (undo.mapListOrig != null || undo.mapListNew != null) {
            this.mapChangeRedo(undo);
        } else if (undo.gOrig != null || undo.gNew != null) {
            this.geneChangeRedo(undo);
        }
    }

    public boolean isEmpty() {
        return this.genes_.isEmpty();
    }

    public CopiesPerEmbryoChange addGene(CopiesPerEmbryoGene gene) {
        CopiesPerEmbryoChange retval = new CopiesPerEmbryoChange();
        retval.genePos = this.genes_.size();
        this.genes_.add(gene);
        retval.gNew = (CopiesPerEmbryoGene)gene.clone();
        retval.gOrig = null;
        return retval;
    }

    public Iterator getGenes() {
        return this.genes_.iterator();
    }

    public CopiesPerEmbryoGene getGene(int n) {
        return (CopiesPerEmbryoGene)this.genes_.get(n);
    }

    public CopiesPerEmbryoChange[] dropMapsTo(String nodeID) {
        ArrayList<CopiesPerEmbryoChange> retvalList = new ArrayList<CopiesPerEmbryoChange>();
        Iterator mit = new HashSet(this.gpeMap_.keySet()).iterator();
        block0: while (mit.hasNext()) {
            String mapKey = (String)mit.next();
            List targList = (List)this.gpeMap_.get(mapKey);
            int tlSize = targList.size();
            for (int i = 0; i < tlSize; ++i) {
                String targ = (String)targList.get(i);
                if (!targ.equals(nodeID)) continue;
                CopiesPerEmbryoChange tcc = new CopiesPerEmbryoChange();
                tcc.mapKey = mapKey;
                tcc.mapListOrig = new ArrayList(targList);
                targList.remove(i);
                if (targList.isEmpty()) {
                    tcc.mapListNew = null;
                    this.gpeMap_.remove(mapKey);
                } else {
                    tcc.mapListNew = new ArrayList(targList);
                }
                retvalList.add(tcc);
                continue block0;
            }
        }
        return retvalList.toArray(new CopiesPerEmbryoChange[retvalList.size()]);
    }

    public CopiesPerEmbryoChange dropGene(int n) {
        CopiesPerEmbryoChange retval = new CopiesPerEmbryoChange();
        CopiesPerEmbryoGene gene = (CopiesPerEmbryoGene)this.genes_.get(n);
        retval.gOrig = (CopiesPerEmbryoGene)gene.clone();
        retval.gNew = null;
        retval.genePos = n;
        this.genes_.remove(n);
        return retval;
    }

    public CopiesPerEmbryoChange dropGene(String nodeID) {
        int size = this.genes_.size();
        for (int i = 0; i < size; ++i) {
            CopiesPerEmbryoGene gene = (CopiesPerEmbryoGene)this.genes_.get(i);
            if (!gene.getName().equals(nodeID)) continue;
            CopiesPerEmbryoChange retval = new CopiesPerEmbryoChange();
            retval.gOrig = gene;
            retval.gNew = null;
            retval.genePos = i;
            this.genes_.remove(i);
            return retval;
        }
        return null;
    }

    public CopiesPerEmbryoChange startGeneUndoTransaction(String geneName) {
        CopiesPerEmbryoChange retval = new CopiesPerEmbryoChange();
        Iterator git = this.getGenes();
        int count = 0;
        while (git.hasNext()) {
            CopiesPerEmbryoGene tg = (CopiesPerEmbryoGene)git.next();
            if (DataUtil.keysEqual(tg.getName(), geneName)) {
                retval.genePos = count;
                retval.gOrig = (CopiesPerEmbryoGene)tg.clone();
                return retval;
            }
            ++count;
        }
        throw new IllegalArgumentException();
    }

    public CopiesPerEmbryoChange finishGeneUndoTransaction(String geneName, CopiesPerEmbryoChange change) {
        CopiesPerEmbryoGene tg = (CopiesPerEmbryoGene)this.genes_.get(change.genePos);
        change.gNew = (CopiesPerEmbryoGene)tg.clone();
        return change;
    }

    private void geneChangeUndo(CopiesPerEmbryoChange undo) {
        if (undo.gOrig != null && undo.gNew != null) {
            this.genes_.set(undo.genePos, undo.gOrig);
        } else if (undo.gOrig == null) {
            this.genes_.remove(undo.genePos);
        } else {
            this.genes_.add(undo.genePos, undo.gOrig);
        }
    }

    private void geneChangeRedo(CopiesPerEmbryoChange undo) {
        if (undo.gOrig != null && undo.gNew != null) {
            this.genes_.set(undo.genePos, undo.gNew);
        } else if (undo.gNew == null) {
            this.genes_.remove(undo.genePos);
        } else {
            this.genes_.add(undo.genePos, undo.gNew);
        }
    }

    public CopiesPerEmbryoChange dropDataKeys(String geneId) {
        if (this.gpeMap_.get(geneId) == null) {
            return null;
        }
        CopiesPerEmbryoChange retval = new CopiesPerEmbryoChange();
        retval.mapKey = geneId;
        retval.mapListNew = null;
        retval.mapListOrig = (List)this.gpeMap_.remove(geneId);
        return retval;
    }

    private void mapChangeUndo(CopiesPerEmbryoChange undo) {
        if (undo.mapListOrig != null && undo.mapListNew != null) {
            this.gpeMap_.put(undo.mapKey, undo.mapListOrig);
        } else if (undo.mapListOrig == null) {
            this.gpeMap_.remove(undo.mapKey);
        } else {
            this.gpeMap_.put(undo.mapKey, undo.mapListOrig);
        }
    }

    private void mapChangeRedo(CopiesPerEmbryoChange undo) {
        if (undo.mapListOrig != null && undo.mapListNew != null) {
            this.gpeMap_.put(undo.mapKey, undo.mapListNew);
        } else if (undo.mapListNew == null) {
            this.gpeMap_.remove(undo.mapKey);
        } else {
            this.gpeMap_.put(undo.mapKey, undo.mapListNew);
        }
    }

    public Iterator getDefaultTimes() {
        return this.defaultTimes_.iterator();
    }

    public boolean hasDefaultTimes() {
        return !this.defaultTimes_.isEmpty();
    }

    public CopiesPerEmbryoChange dropDefaultTimes() {
        CopiesPerEmbryoChange retval = new CopiesPerEmbryoChange();
        retval.oldDefaultTimes = (SortedSet)this.defaultTimes_.clone();
        this.defaultTimes_.clear();
        retval.newDefaultTimes = (SortedSet)this.defaultTimes_.clone();
        return retval;
    }

    public CopiesPerEmbryoChange addDefaultTime(int time) {
        CopiesPerEmbryoChange retval = new CopiesPerEmbryoChange();
        retval.oldDefaultTimes = (SortedSet)this.defaultTimes_.clone();
        this.defaultTimes_.add(new Integer(time));
        retval.newDefaultTimes = (SortedSet)this.defaultTimes_.clone();
        return retval;
    }

    public CopiesPerEmbryoGene getCopyPerEmbryroData(String targetName) {
        Iterator trgit = this.genes_.iterator();
        while (trgit.hasNext()) {
            CopiesPerEmbryoGene trg = (CopiesPerEmbryoGene)trgit.next();
            if (!DataUtil.keysEqual(targetName, trg.getName())) continue;
            return trg;
        }
        return null;
    }

    public String getCountTable(String targetName) {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        Iterator trgit = this.genes_.iterator();
        while (trgit.hasNext()) {
            CopiesPerEmbryoGene trg = (CopiesPerEmbryoGene)trgit.next();
            String name = trg.getName();
            if (!DataUtil.keysEqual(name, targetName)) continue;
            trg.getCountTable(out);
        }
        return sw.toString();
    }

    public CopiesPerEmbryoChange addCpeMap(String key, List mapSets) {
        CopiesPerEmbryoChange retval = null;
        if (mapSets != null && mapSets.size() > 0) {
            retval = new CopiesPerEmbryoChange();
            retval.mapKey = key;
            retval.mapListNew = mapSets;
            retval.mapListOrig = null;
            this.gpeMap_.put(key, mapSets);
        }
        return retval;
    }

    public CopiesPerEmbryoChange[] changeCpeMapToName(String oldName, String newName) {
        ArrayList<CopiesPerEmbryoChange> retvalList = new ArrayList<CopiesPerEmbryoChange>();
        Iterator tmit = this.gpeMap_.keySet().iterator();
        while (tmit.hasNext()) {
            String mkey = (String)tmit.next();
            List keys = (List)this.gpeMap_.get(mkey);
            if (!keys.contains(oldName)) continue;
            CopiesPerEmbryoChange retval = new CopiesPerEmbryoChange();
            retval.mapKey = mkey;
            retval.mapListOrig = (ArrayList)((ArrayList)keys).clone();
            keys.remove(oldName);
            keys.add(newName);
            retval.mapListNew = (ArrayList)((ArrayList)keys).clone();
            retvalList.add(retval);
        }
        return retvalList.toArray(new CopiesPerEmbryoChange[retvalList.size()]);
    }

    public CopiesPerEmbryoChange[] changeName(String oldName, String newName) {
        ArrayList<CopiesPerEmbryoChange> retvalList = new ArrayList<CopiesPerEmbryoChange>();
        if (this.getCopyPerEmbryroData(newName) != null) {
            throw new IllegalArgumentException();
        }
        CopiesPerEmbryoGene gene = this.getCopyPerEmbryroData(oldName);
        if (gene != null) {
            CopiesPerEmbryoChange tcc = this.startGeneUndoTransaction(oldName);
            gene.setName(newName);
            tcc = this.finishGeneUndoTransaction(newName, tcc);
            retvalList.add(tcc);
        }
        Iterator dmit = this.gpeMap_.keySet().iterator();
        while (dmit.hasNext()) {
            String mkey = (String)dmit.next();
            List keys = (List)this.gpeMap_.get(mkey);
            if (!DataUtil.containsKey(keys, oldName)) continue;
            CopiesPerEmbryoChange retval = new CopiesPerEmbryoChange();
            retval.mapKey = mkey;
            retval.mapListOrig = (ArrayList)((ArrayList)keys).clone();
            keys.remove(oldName);
            keys.add(newName);
            retval.mapListNew = (ArrayList)((ArrayList)keys).clone();
            retvalList.add(retval);
        }
        return retvalList.toArray(new CopiesPerEmbryoChange[retvalList.size()]);
    }

    public List getPerEmbryoCountDataKeysWithDefault(String nodeId) {
        ArrayList<String> retval = (ArrayList<String>)this.gpeMap_.get(nodeId);
        if (retval == null || retval.size() == 0) {
            retval = new ArrayList<String>();
            Node node = Database.getDB().getGenome().getNode(nodeId);
            if (node == null) {
                throw new IllegalStateException();
            }
            String nodeName = node.getRootName();
            if (nodeName == null || nodeName.trim().equals("")) {
                return retval;
            }
            retval.add(nodeName);
        }
        return retval;
    }

    public List getPerEmbryoCountDataKeysWithDefaultGivenName(String nodeId, String nodeName) {
        ArrayList<String> retval = (ArrayList<String>)this.gpeMap_.get(nodeId);
        if (retval == null || retval.size() == 0) {
            retval = new ArrayList<String>();
            if (nodeName == null || nodeName.trim().equals("")) {
                return retval;
            }
            retval.add(nodeName);
        }
        return retval;
    }

    public List getCustomPerEmbryoCountDataKeys(String nodeId) {
        return (List)this.gpeMap_.get(nodeId);
    }

    public Set getPerEmbryoCountDataKeyInverses(String name) {
        Set nodes;
        name = name.toUpperCase().replaceAll(" ", "");
        HashSet<String> retval = new HashSet<String>();
        DBGenome genome = (DBGenome)Database.getDB().getGenome();
        Node node = genome.getGeneWithName(name);
        if (node != null && !this.haveCustomMapForNode(node.getID())) {
            retval.add(node.getID());
        }
        if (!(nodes = genome.getNodesWithName(name)).isEmpty()) {
            Iterator sit = nodes.iterator();
            while (sit.hasNext()) {
                node = (Node)sit.next();
                if (this.haveCustomMapForNode(node.getID())) continue;
                retval.add(node.getID());
            }
        }
        Iterator kit = this.gpeMap_.keySet().iterator();
        while (kit.hasNext()) {
            String key = (String)kit.next();
            List targs = (List)this.gpeMap_.get(key);
            Iterator trit = targs.iterator();
            while (trit.hasNext()) {
                String testName = (String)trit.next();
                if (!testName.replaceAll(" ", "").equalsIgnoreCase(name)) continue;
                retval.add(key);
            }
        }
        return retval;
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.println("<CopiesPerEmbryoData>");
        if (this.genes_.size() > 0) {
            Iterator git = this.getGenes();
            ind.up();
            while (git.hasNext()) {
                CopiesPerEmbryoGene tg = (CopiesPerEmbryoGene)git.next();
                tg.writeXML(out, ind);
            }
            ind.down();
        }
        if (this.defaultTimes_.size() > 0) {
            this.writeDefaultTimes(out, ind);
        }
        if (this.gpeMap_.size() > 0) {
            this.writeCpeMap(out, ind);
        }
        ind.indent();
        out.println("</CopiesPerEmbryoData>");
    }

    public String toString() {
        return "CopiesPerEmbryoData:  genes = " + this.genes_;
    }

    public boolean nameIsUnique(String targName) {
        Iterator git = this.getGenes();
        while (git.hasNext()) {
            CopiesPerEmbryoGene tg = (CopiesPerEmbryoGene)git.next();
            if (!DataUtil.keysEqual(tg.getName(), targName)) continue;
            return false;
        }
        return true;
    }

    public static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("CopiesPerEmbryoData");
        return retval;
    }

    public static CopiesPerEmbryoData buildFromXML(String elemName, Attributes attrs) throws IOException {
        if (!elemName.equals("CopiesPerEmbryoData")) {
            return null;
        }
        return new CopiesPerEmbryoData();
    }

    public static String extractCpeMapKey(String elemName, Attributes attrs) throws IOException {
        return AttributeExtractor.extractAttribute(elemName, attrs, "cpeMap", "key", true);
    }

    public static String extractUseCpe(String elemName, Attributes attrs) throws IOException {
        return AttributeExtractor.extractAttribute(elemName, attrs, "useCpe", "name", true);
    }

    public static int extractTime(String elemName, Attributes attrs) throws IOException {
        String timeVal = AttributeExtractor.extractAttribute(elemName, attrs, "cpeTime", "time", true);
        try {
            return Integer.parseInt(timeVal);
        }
        catch (NumberFormatException nfe) {
            throw new IOException();
        }
    }

    public static String cpeMapKeyword() {
        return "cpeMap";
    }

    public static String useCpeKeyword() {
        return "useCpe";
    }

    public static String cpeTimeKeyword() {
        return "cpeTime";
    }

    private void writeCpeMap(PrintWriter out, Indenter ind) {
        ind.up().indent();
        out.println("<cpeMaps>");
        TreeSet sorted = new TreeSet();
        sorted.addAll(this.gpeMap_.keySet());
        Iterator mapKeys = sorted.iterator();
        ind.up();
        while (mapKeys.hasNext()) {
            String key = (String)mapKeys.next();
            List list = (List)this.gpeMap_.get(key);
            ind.indent();
            out.print("<cpeMap key=\"");
            out.print(key);
            out.println("\">");
            Iterator lit = list.iterator();
            ind.up();
            while (lit.hasNext()) {
                String usetc = (String)lit.next();
                ind.indent();
                out.print("<useCpe name=\"");
                out.print(usetc);
                out.println("\"/>");
            }
            ind.down().indent();
            out.println("</cpeMap>");
        }
        ind.down().indent();
        out.println("</cpeMaps>");
        ind.down();
    }

    private void writeDefaultTimes(PrintWriter out, Indenter ind) {
        ind.up().indent();
        out.println("<cpeDefaultTimes>");
        Iterator timeit = this.defaultTimes_.iterator();
        ind.up();
        while (timeit.hasNext()) {
            Integer time = (Integer)timeit.next();
            ind.indent();
            out.print("<cpeTime time=\"");
            out.print(time);
            out.println("\">");
        }
        ind.down().indent();
        out.println("</cpeDefaultTimes>");
        ind.down();
    }
}

