/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.timeCourse;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.plugin.InternalNodeDataDisplayPlugIn;
import org.systemsbiology.biotapestry.plugin.PluginCallbackWorker;
import org.systemsbiology.biotapestry.timeCourse.CopiesPerEmbryoData;
import org.systemsbiology.biotapestry.util.ResourceManager;

public class CopiesPerEmbryoDisplayPlugIn
implements InternalNodeDataDisplayPlugIn {
    public boolean isInternal() {
        return true;
    }

    public boolean requiresPerInstanceDisplay(String genomeID, String itemID) {
        return false;
    }

    public boolean haveCallbackWorker() {
        return false;
    }

    public PluginCallbackWorker getCallbackWorker(String genomeID, String nodeID) {
        return null;
    }

    public String getDataAsHTML(String genomeIDX, String nodeID) {
        StringBuffer buf = new StringBuffer();
        Database db = Database.getDB();
        CopiesPerEmbryoData cped = db.getCopiesPerEmbryoData();
        if (cped == null || !cped.haveData()) {
            return "";
        }
        nodeID = GenomeItemInstance.getBaseID(nodeID);
        ResourceManager rMan = ResourceManager.getManager();
        Genome genome = db.getGenome();
        Node node = genome.getNode(nodeID);
        String title = node.getDisplayString(genome, false);
        String useName = title == null || title.trim().equals("") ? "\" \"" : title;
        String format = rMan.getString("dataWindow.copiesPerEmbryoFor");
        buf.append("<center><h1>");
        buf.append(MessageFormat.format(format, useName));
        buf.append("</h1>\n");
        List dataKeys = cped.getPerEmbryoCountDataKeysWithDefault(nodeID);
        boolean gotData = false;
        if (dataKeys != null) {
            Iterator dkit = dataKeys.iterator();
            while (dkit.hasNext()) {
                String key = (String)dkit.next();
                String tab = cped.getCountTable(key);
                if (tab == null || tab.trim().equals("")) continue;
                gotData = true;
                buf.append("<p>");
                buf.append(tab);
                buf.append("</p>");
            }
        }
        if (!gotData) {
            buf.append(rMan.getString("dataWindow.noCopiesPerEmbryo"));
        }
        buf.append("</center>");
        return buf.toString();
    }
}

