/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.timeCourse;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.parser.ParserClient;
import org.systemsbiology.biotapestry.timeCourse.CopiesPerEmbryoData;
import org.systemsbiology.biotapestry.timeCourse.CopiesPerEmbryoGene;
import org.xml.sax.Attributes;

public class CopiesPerEmbryoFormatFactory
implements ParserClient {
    private HashSet allKeys_;
    private Set dataKeys_;
    private Set geneKeys_;
    private Object container_;
    private CopiesPerEmbryoData currTarg_;
    private CopiesPerEmbryoGene currGene_;
    private String cpeKey_;
    private String useCpeKey_;
    private String cpeTimeKey_;
    private String cAtTimeKey_;
    private String currCpeMapKey_;
    private ArrayList currCpeMapList_;
    private boolean mapsAreIllegal_;

    public CopiesPerEmbryoFormatFactory(boolean mapsAreIllegal) {
        this.mapsAreIllegal_ = mapsAreIllegal;
        this.dataKeys_ = CopiesPerEmbryoData.keywordsOfInterest();
        this.geneKeys_ = CopiesPerEmbryoGene.keywordsOfInterest();
        this.cpeKey_ = CopiesPerEmbryoData.cpeMapKeyword();
        this.useCpeKey_ = CopiesPerEmbryoData.useCpeKeyword();
        this.cpeTimeKey_ = CopiesPerEmbryoData.cpeTimeKeyword();
        this.cAtTimeKey_ = CopiesPerEmbryoGene.cAtTimeKeyword();
        this.allKeys_ = new HashSet();
        this.allKeys_.addAll(this.dataKeys_);
    }

    public CopiesPerEmbryoData getCopiesPerEmbryoData() {
        return this.currTarg_;
    }

    public void setContainer(Object container) {
        this.container_ = container;
    }

    public boolean finishElement(String elemName) {
        if (elemName.equals(this.cpeKey_)) {
            this.currTarg_.addCpeMap(this.currCpeMapKey_, this.currCpeMapList_);
            this.currCpeMapKey_ = null;
            this.currCpeMapList_ = null;
        }
        return this.allKeys_.contains(elemName);
    }

    public void processCharacters(char[] chars, int start, int length) {
    }

    public Set keywordsOfInterest() {
        return this.allKeys_;
    }

    public Object processElement(String elemName, Attributes attrs) throws IOException {
        if (attrs == null || elemName == null) {
            return null;
        }
        if (this.dataKeys_.contains(elemName)) {
            CopiesPerEmbryoData data = CopiesPerEmbryoData.buildFromXML(elemName, attrs);
            if (data != null) {
                Database db = Database.getDB();
                db.setCopiesPerEmbryoData(data);
                this.currTarg_ = data;
            }
        } else if (this.geneKeys_.contains(elemName)) {
            CopiesPerEmbryoGene cpeGene = CopiesPerEmbryoGene.buildFromXML(elemName, attrs);
            if (cpeGene != null) {
                this.currTarg_.addGene(cpeGene);
                this.currGene_ = cpeGene;
            }
        } else if (elemName.equals(this.cpeKey_)) {
            if (this.mapsAreIllegal_) {
                throw new IOException();
            }
            this.currCpeMapKey_ = CopiesPerEmbryoData.extractCpeMapKey(elemName, attrs);
            this.currCpeMapList_ = new ArrayList();
        } else if (elemName.equals(this.useCpeKey_)) {
            if (this.mapsAreIllegal_) {
                throw new IOException();
            }
            this.currCpeMapList_.add(CopiesPerEmbryoData.extractUseCpe(elemName, attrs));
        } else if (elemName.equals(this.cpeTimeKey_)) {
            int nextTime = CopiesPerEmbryoData.extractTime(elemName, attrs);
            this.currTarg_.addDefaultTime(nextTime);
        } else if (elemName.equals(this.cAtTimeKey_)) {
            int time = CopiesPerEmbryoGene.extractCpeTime(elemName, attrs);
            double count = CopiesPerEmbryoGene.extractCpeCount(elemName, attrs);
            this.currGene_.addCount(new Integer(time), count);
        }
        return null;
    }
}

