/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.timeCourse;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import org.systemsbiology.biotapestry.db.TimeAxisDefinition;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.Indenter;
import org.xml.sax.Attributes;

public class CopiesPerEmbryoGene
implements Cloneable {
    private static final int COUNTS_PER_ROW_ = 5;
    private String name_;
    private TreeMap data_;

    public CopiesPerEmbryoGene(CopiesPerEmbryoGene other) {
        this.name_ = other.name_;
        this.data_ = new TreeMap(other.data_);
    }

    public CopiesPerEmbryoGene(String name) {
        this.name_ = name;
        this.data_ = new TreeMap();
    }

    public Object clone() {
        try {
            CopiesPerEmbryoGene newVal = (CopiesPerEmbryoGene)super.clone();
            newVal.data_ = (TreeMap)this.data_.clone();
            return newVal;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }

    public String getName() {
        return this.name_;
    }

    public void setName(String name) {
        this.name_ = name;
    }

    public void addCount(Integer timeKey, double count) {
        this.data_.put(timeKey, new Double(count));
    }

    public void deleteExpression(Integer timeKey) {
        this.data_.remove(timeKey);
    }

    public Iterator getCountTimes() {
        return this.data_.keySet().iterator();
    }

    public Double getCount(Integer timeKey) {
        return (Double)this.data_.get(timeKey);
    }

    public void getCountTable(PrintWriter out) {
        Set timeKeys = this.data_.keySet();
        int numTimes = timeKeys.size();
        int numRows = numTimes / 5;
        if (numTimes % 5 > 0) {
            ++numRows;
        }
        ArrayList times = new ArrayList(timeKeys);
        String el = " Expression Level (copies / embryo)";
        out.println("<table width=\"810\" border=\"1\" cellpadding=\"0\" cellspacing=\"0\">");
        out.println("<tr>");
        out.println("<td colspan=\"5\" align=\"center\" valign=\"center\">");
        out.print(this.name_);
        out.print(":");
        out.println(el);
        out.println("</td>");
        int rowBase = 0;
        for (int i = 0; i < numRows; ++i) {
            Integer timeKey;
            int currEntry;
            int j;
            out.println("<tr>");
            for (j = 0; j < 5; ++j) {
                currEntry = rowBase + j;
                if (currEntry < numTimes) {
                    timeKey = (Integer)times.get(currEntry);
                    this.buildTimeCell(out, timeKey);
                    continue;
                }
                this.buildEmptyCell(out);
            }
            out.println("</tr>");
            out.println("</tr>");
            for (j = 0; j < 5; ++j) {
                currEntry = rowBase + j;
                if (currEntry < numTimes) {
                    timeKey = (Integer)times.get(currEntry);
                    this.buildCountCell(out, timeKey);
                    continue;
                }
                this.buildEmptyCell(out);
            }
            out.println("</tr>");
            if (i < numRows - 1) {
                out.println("<tr height=\"10\" border=\"10\" >");
                out.println("<td colspan=\"5\">&nbsp;</td>");
                out.println("</tr>");
            }
            rowBase += 5;
        }
        out.println("</table>");
        out.println("<p></p>");
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<copiesPerEmbryo gene=\"");
        out.print(CharacterEntityMapper.mapEntities(this.name_, false));
        if (this.data_.size() > 0) {
            out.println("\">");
            ind.up();
            Iterator times = this.getCountTimes();
            while (times.hasNext()) {
                Integer time = (Integer)times.next();
                this.writeXMLForTime(out, ind, time);
            }
            ind.down().indent();
            out.println("</copiesPerEmbryo>");
        } else {
            out.println("\" />");
        }
    }

    public void writeXMLForTime(PrintWriter out, Indenter ind, Integer timeVal) {
        ind.indent();
        out.print("<copiesAtTime time=\"");
        out.print(timeVal);
        out.print("\" count=\"");
        out.print(this.getCount(timeVal));
        out.println("\" />");
    }

    public String toString() {
        return "CopiesPerEmbryoGene: name = " + this.name_;
    }

    public void buildTimeCell(PrintWriter out, Integer timeObj) {
        out.print("<td width=\"70\" align=\"center\" valign=\"center\"><b>");
        out.print("<b>");
        String timeLabel = TimeAxisDefinition.getTimeDisplay(timeObj, true, false);
        out.print(timeLabel);
        out.print("</b>");
        out.println("</td>");
    }

    public void buildCountCell(PrintWriter out, Integer key) {
        out.print("<td width=\"70\" align=\"center\" valign=\"center\">");
        Double count = this.getCount(key);
        out.print(count);
        out.println("</td>");
    }

    public void buildEmptyCell(PrintWriter out) {
        out.print("<td width=\"70\" align=\"center\" valign=\"center\">");
        out.print("&nbsp;");
        out.println("</td>");
    }

    public static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("copiesPerEmbryo");
        return retval;
    }

    public static String cAtTimeKeyword() {
        return "copiesAtTime";
    }

    public static CopiesPerEmbryoGene buildFromXML(String elemName, Attributes attrs) throws IOException {
        if (!elemName.equals("copiesPerEmbryo")) {
            return null;
        }
        String gene = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (!key.equals("gene")) continue;
                gene = CharacterEntityMapper.unmapEntities(val, false);
            }
        }
        if (gene == null) {
            throw new IOException();
        }
        return new CopiesPerEmbryoGene(gene);
    }

    public static int extractCpeTime(String elemName, Attributes attrs) throws IOException {
        String timeVal = AttributeExtractor.extractAttribute(elemName, attrs, "copiesAtTime", "time", true);
        try {
            return Integer.parseInt(timeVal);
        }
        catch (NumberFormatException nfe) {
            throw new IOException();
        }
    }

    public static double extractCpeCount(String elemName, Attributes attrs) throws IOException {
        String countVal = AttributeExtractor.extractAttribute(elemName, attrs, "copiesAtTime", "count", true);
        try {
            return Double.parseDouble(countVal);
        }
        catch (NumberFormatException nfe) {
            throw new IOException();
        }
    }
}

