/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.timeCourse;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.TimeAxisDefinition;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseGene;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.xml.sax.Attributes;

public class ExpressionEntry
implements Cloneable {
    public static final int NO_REGION = -1;
    public static final int NO_DATA = 0;
    public static final int NOT_EXPRESSED = 1;
    public static final int WEAK_EXPRESSION = 2;
    public static final int EXPRESSED = 3;
    public static final int VARIABLE = 4;
    public static final int NUM_EXPRESSIONS = 5;
    public static final int NO_SOURCE_SPECIFIED = 0;
    public static final int MATERNAL_SOURCE = 1;
    public static final int ZYGOTIC_SOURCE = 2;
    public static final int MATERNAL_AND_ZYGOTIC = 3;
    public static final int NUM_SOURCES = 4;
    public static final int NO_STRATEGY_SPECIFIED = 0;
    public static final int ON_AT_BOUNDARY_WITH_SLOW_RAMP = 1;
    public static final int ON_AT_BOUNDARY_WITH_FAST_RAMP = 2;
    public static final int OFF_AT_BOUNDARY_WITH_SLOW_RAMP = 3;
    public static final int OFF_AT_BOUNDARY_WITH_FAST_RAMP = 4;
    public static final int NUM_STRATEGIES = 5;
    private String region_;
    private int time_;
    private int expr_;
    private int source_;
    private int confidence_;
    private int strategySource_;
    private int startStrategy_;
    private int endStrategy_;
    private double variable_;

    public ExpressionEntry(ExpressionEntry other) {
        this.copyInto(other);
    }

    public ExpressionEntry(String region, int time, int expr, int source, int confidence, int strategySource, int startStrategy, int endStrategy, double variable) {
        this.region_ = region;
        this.time_ = time;
        this.expr_ = expr;
        this.confidence_ = confidence;
        this.source_ = source;
        this.strategySource_ = strategySource;
        this.startStrategy_ = startStrategy;
        this.endStrategy_ = endStrategy;
        if (expr != 4 && variable != 0.0) {
            throw new IllegalArgumentException();
        }
        this.variable_ = variable;
        if (this.variable_ < 0.0 || this.variable_ > 1.0) {
            throw new IllegalArgumentException();
        }
    }

    public ExpressionEntry(String region, int time) {
        this(region, time, 1, 0, -1, 0, 0, 0, 0.0);
    }

    public ExpressionEntry(String region, int time, int expr, int confidence) {
        this(region, time, expr, 0, confidence, 0, 0, 0, 0.0);
    }

    public ExpressionEntry(String region, String time, String expr, String source, String confidence, String strategySource, String startStrategy, String endStrategy, String variable) throws IOException {
        this.region_ = region;
        try {
            this.time_ = Integer.parseInt(time);
        }
        catch (NumberFormatException nfex) {
            throw new IOException();
        }
        Database db = Database.getDB();
        TimeAxisDefinition tad = db.getTimeAxisDefinition();
        if (!tad.timeIsOk(this.time_)) {
            throw new IOException();
        }
        if (expr == null) {
            throw new IOException();
        }
        expr = expr.trim();
        try {
            this.expr_ = ExpressionEntry.mapFromExpressionTag(expr);
        }
        catch (IllegalArgumentException iaex) {
            throw new IOException();
        }
        if (this.expr_ == 4) {
            if (variable == null) {
                throw new IOException();
            }
            try {
                this.variable_ = Double.parseDouble(variable);
            }
            catch (NumberFormatException nfex) {
                throw new IOException();
            }
            if (this.variable_ < 0.0 || this.variable_ > 1.0) {
                throw new IOException();
            }
        }
        if (source == null) {
            this.source_ = 0;
        } else {
            source = source.trim();
            try {
                this.source_ = ExpressionEntry.mapFromSourceTag(source);
            }
            catch (IllegalArgumentException iaex) {
                throw new IOException();
            }
        }
        if (strategySource == null) {
            this.strategySource_ = 0;
        } else {
            strategySource = strategySource.trim();
            try {
                this.strategySource_ = ExpressionEntry.mapFromSourceTag(strategySource);
            }
            catch (IllegalArgumentException iaex) {
                throw new IOException();
            }
        }
        if (confidence == null) {
            this.confidence_ = -1;
        } else if ((confidence = confidence.trim()).equalsIgnoreCase("normal")) {
            this.confidence_ = 0;
        } else if (confidence.equalsIgnoreCase("interpolated")) {
            this.confidence_ = 1;
        } else if (confidence.equalsIgnoreCase("assumption")) {
            this.confidence_ = 4;
        } else if (confidence.equalsIgnoreCase("inferred")) {
            this.confidence_ = 2;
        } else if (confidence.equalsIgnoreCase("questionable")) {
            this.confidence_ = 3;
        } else {
            throw new IOException();
        }
        try {
            this.startStrategy_ = ExpressionEntry.calculateStrategy(startStrategy, true);
            this.endStrategy_ = ExpressionEntry.calculateStrategy(endStrategy, false);
        }
        catch (IllegalArgumentException iae) {
            throw new IOException();
        }
    }

    public void copyInto(ExpressionEntry other) {
        this.region_ = other.region_;
        this.time_ = other.time_;
        this.expr_ = other.expr_;
        this.source_ = other.source_;
        this.confidence_ = other.confidence_;
        this.strategySource_ = other.strategySource_;
        this.startStrategy_ = other.startStrategy_;
        this.endStrategy_ = other.endStrategy_;
        this.variable_ = other.variable_;
    }

    public Object clone() {
        try {
            ExpressionEntry retval = (ExpressionEntry)super.clone();
            return retval;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public void updateRegionAndTime(String region, int time) {
        this.region_ = region;
        this.time_ = time;
    }

    public void updateRegion(String region) {
        this.region_ = region;
    }

    public String getRegion() {
        return this.region_;
    }

    public int getTime() {
        return this.time_;
    }

    public int getRawExpression() {
        return this.expr_;
    }

    public int getExpressionForSource(int whichSource) {
        if (this.source_ == 0 || whichSource == 0) {
            return this.expr_;
        }
        switch (whichSource) {
            case 1: {
                return this.source_ == 1 || this.source_ == 3 ? this.expr_ : 1;
            }
            case 2: {
                return this.source_ == 2 || this.source_ == 3 ? this.expr_ : 1;
            }
        }
        throw new IllegalArgumentException();
    }

    public int getSource() {
        return this.source_;
    }

    public int getStrategySource() {
        return this.strategySource_;
    }

    public Integer getQualifiedSource() {
        return this.expr_ > 1 ? new Integer(this.source_) : null;
    }

    public double getVariableLevelForSource(int whichSource) {
        if (this.expr_ != 4) {
            throw new IllegalStateException();
        }
        if (this.source_ == 0 || whichSource == 0) {
            return this.variable_;
        }
        switch (whichSource) {
            case 1: {
                return this.source_ == 1 || this.source_ == 3 ? this.variable_ : 0.0;
            }
            case 2: {
                return this.source_ == 2 || this.source_ == 3 ? this.variable_ : 0.0;
            }
        }
        throw new IllegalArgumentException();
    }

    public int getConfidence() {
        return this.confidence_;
    }

    public int getRawStartStrategy() {
        return this.startStrategy_;
    }

    public int getRawEndStrategy() {
        return this.endStrategy_;
    }

    public int getStartStrategy(int whichSource) {
        switch (whichSource) {
            case 1: {
                return this.strategySource_ == 1 || this.strategySource_ == 3 ? this.startStrategy_ : 0;
            }
            case 2: {
                return this.strategySource_ == 2 || this.strategySource_ == 3 ? this.startStrategy_ : 0;
            }
            case 0: {
                return this.strategySource_ == 0 ? this.startStrategy_ : 0;
            }
        }
        throw new IllegalArgumentException();
    }

    public int getEndStrategy(int whichSource) {
        switch (whichSource) {
            case 1: {
                return this.strategySource_ == 1 || this.strategySource_ == 3 ? this.endStrategy_ : 0;
            }
            case 2: {
                return this.strategySource_ == 2 || this.strategySource_ == 3 ? this.endStrategy_ : 0;
            }
            case 0: {
                return this.strategySource_ == 0 ? this.endStrategy_ : 0;
            }
        }
        throw new IllegalArgumentException();
    }

    public void setStartAndEndStrategy(int startStrategy, int endStrategy, int whichSource) {
        this.strategySource_ = whichSource;
        this.startStrategy_ = startStrategy;
        this.endStrategy_ = endStrategy;
    }

    public void setSource(int src) {
        this.source_ = src;
    }

    public void setExpression(int expr) {
        this.expr_ = expr;
    }

    public void setConfidence(int confidence) {
        this.confidence_ = confidence;
    }

    public void setVariableLevel(double lev) {
        this.variable_ = lev;
    }

    public void exportCSV(PrintWriter out, int resolvedConfidence, boolean encodeConfidence) {
        out.print(ExpressionEntry.mapExpressionForCSV(this.expr_, resolvedConfidence, this.variable_, encodeConfidence));
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        String invert;
        ind.indent();
        out.print("<data region=\"");
        out.print(CharacterEntityMapper.mapEntities(this.region_, false));
        out.print("\" time=\"");
        out.print(this.time_);
        out.print("\" expr=\"");
        out.print(ExpressionEntry.mapExpression(this.expr_));
        if (this.source_ != 0) {
            out.print("\" source=\"");
            out.print(ExpressionEntry.mapToSourceTag(this.source_));
        }
        if (this.confidence_ != -1) {
            out.print("\" confidence=\"");
            out.print(TimeCourseGene.mapConfidence(this.confidence_));
        }
        if ((invert = ExpressionEntry.mapStrategy(this.startStrategy_)) != null) {
            out.print("\" starttype=\"");
            out.print(invert);
        }
        if ((invert = ExpressionEntry.mapStrategy(this.endStrategy_)) != null) {
            out.print("\" endtype=\"");
            out.print(invert);
        }
        if (this.strategySource_ != 0) {
            out.print("\" stratSource=\"");
            out.print(ExpressionEntry.mapToSourceTag(this.strategySource_));
        }
        if (this.expr_ == 4) {
            out.print("\" value=\"");
            out.print(this.variable_);
        }
        out.println("\" />");
    }

    public String toString() {
        return "Expression: region_ = " + this.region_ + " time = " + this.time_ + " expr = " + this.expr_ + " confidence = " + this.confidence_ + " variable = " + this.variable_;
    }

    public static boolean hasMaternalChannel(Set sources) {
        return sources.contains(new Integer(1)) || sources.contains(new Integer(3));
    }

    public static boolean hasZygoticChannel(Set sources) {
        return sources.contains(new Integer(2)) || sources.contains(new Integer(3));
    }

    public static boolean hasNoSourceChannel(Set sources) {
        return sources.contains(new Integer(0));
    }

    public static String buildZygoticDisplayName(String name) {
        ResourceManager rMan = ResourceManager.getManager();
        String format = rMan.getString("expressionChannel.zygoticSource");
        String desc = MessageFormat.format(format, name);
        return desc;
    }

    public static String buildMaternalDisplayName(String name) {
        ResourceManager rMan = ResourceManager.getManager();
        String format = rMan.getString("expressionChannel.maternalSource");
        String desc = MessageFormat.format(format, name);
        return desc;
    }

    public static String mapToSourceTag(int value) {
        switch (value) {
            case 0: {
                return "noSource";
            }
            case 1: {
                return "maternal";
            }
            case 2: {
                return "zygotic";
            }
            case 3: {
                return "matAndZyg";
            }
        }
        System.err.println("source was " + value);
        throw new IllegalArgumentException();
    }

    public static int mapFromSourceTag(String source) {
        if (source.equalsIgnoreCase("noSource")) {
            return 0;
        }
        if (source.equalsIgnoreCase("maternal")) {
            return 1;
        }
        if (source.equalsIgnoreCase("zygotic")) {
            return 2;
        }
        if (source.equalsIgnoreCase("matAndZyg")) {
            return 3;
        }
        throw new IllegalArgumentException();
    }

    public static String mapExpression(int value) {
        switch (value) {
            case 0: {
                return "noData";
            }
            case 1: {
                return "no";
            }
            case 2: {
                return "weak";
            }
            case 3: {
                return "yes";
            }
            case 4: {
                return "variable";
            }
        }
        System.err.println("value was " + value);
        throw new IllegalArgumentException();
    }

    public static int mapFromExpressionTag(String expr) {
        if (expr.equalsIgnoreCase("noData")) {
            return 0;
        }
        if (expr.equalsIgnoreCase("no")) {
            return 1;
        }
        if (expr.equalsIgnoreCase("weak")) {
            return 2;
        }
        if (expr.equalsIgnoreCase("yes")) {
            return 3;
        }
        if (expr.equalsIgnoreCase("variable")) {
            return 4;
        }
        throw new IllegalArgumentException();
    }

    public static String mapExpressionForCSV(int value, int confidence, double variable, boolean encodeConfidence) {
        int level;
        if (value == 0) {
            return "0";
        }
        if (value == 4) {
            return Double.toString(variable);
        }
        int base = 1;
        if (encodeConfidence) {
            if (confidence == 0) {
                base = 1;
            } else if (confidence == 1) {
                base = 4;
            } else if (confidence == 2) {
                base = 7;
            } else if (confidence == 4) {
                base = 10;
            } else if (confidence == 3) {
                base = 13;
            } else {
                throw new IllegalArgumentException();
            }
        }
        if (value == 1) {
            level = 0;
        } else if (value == 2) {
            level = 1;
        } else if (value == 3) {
            level = 2;
        } else {
            throw new IllegalArgumentException();
        }
        return Integer.toString(base + level);
    }

    public static void expressionKeyCSV(PrintWriter out, boolean encodeConfidence) {
        ResourceManager rMan = ResourceManager.getManager();
        out.println("\"\"");
        out.println("\"\"");
        out.print("\"");
        out.print(rMan.getString("csvTcdExport.keyTitle"));
        out.println("\"");
        out.print("\"");
        out.print(rMan.getString(encodeConfidence ? "csvTcdExport.var" : "csvTcdExport.varNC"));
        out.println("\"");
        out.print("\"");
        out.print(rMan.getString("csvTcdExport.number"));
        out.print("\",\"");
        out.print(rMan.getString("csvTcdExport.level"));
        if (encodeConfidence) {
            out.print("\",\"");
            out.print(rMan.getString("csvTcdExport.confidence"));
        }
        out.println("\"");
        out.print("0,\"");
        out.print(rMan.getString("csvTcdExport." + ExpressionEntry.mapExpression(0)));
        if (encodeConfidence) {
            out.print("\",\"");
            out.print(rMan.getString("csvTcdExport.nA"));
        }
        out.println("\"");
        int topConf = encodeConfidence ? 4 : 0;
        int confLev = 1;
        for (int i = 0; i <= topConf; ++i) {
            String conf = rMan.getString("csvTcdExportConf." + TimeCourseGene.mapConfidence(i));
            int expLev = 0;
            for (int j = 0; j < 5; ++j) {
                if (j == 0 || j == 4) continue;
                String expr = rMan.getString("csvTcdExport." + ExpressionEntry.mapExpression(j));
                int totLev = expLev++ + confLev;
                out.print(totLev);
                out.print(",\"");
                out.print(expr);
                if (encodeConfidence) {
                    out.print("\",\"");
                    out.print(conf);
                }
                out.println("\"");
            }
            confLev += expLev;
        }
    }

    public static boolean isQuestionable(String token) {
        if (token == null) {
            return false;
        }
        return token.indexOf("?") != -1;
    }

    public static int calculateExpression(String token) {
        if (token == null) {
            return 0;
        }
        if ((token = token.toUpperCase()).equals("ND")) {
            return 0;
        }
        if (token.equals("-")) {
            return 1;
        }
        if (token.equals("X")) {
            return 3;
        }
        if (token.equals("(X)")) {
            return 2;
        }
        if (token.equals("?")) {
            return 0;
        }
        if (token.equals("X(?)")) {
            return 3;
        }
        System.err.println(token);
        throw new IllegalArgumentException();
    }

    public static int calculateStrategy(String token, boolean isStart) {
        if (token == null) {
            return 0;
        }
        if (token.equals("onWithSlowRamp")) {
            return 1;
        }
        if (token.equals("onWithFastRamp")) {
            return 2;
        }
        if (token.equals("offWithSlowRamp")) {
            return 3;
        }
        if (token.equals("offWithFastRamp")) {
            return 4;
        }
        throw new IllegalArgumentException();
    }

    public static String mapStrategy(int val) {
        switch (val) {
            case 0: {
                return null;
            }
            case 1: {
                return "onWithSlowRamp";
            }
            case 2: {
                return "onWithFastRamp";
            }
            case 3: {
                return "offWithSlowRamp";
            }
            case 4: {
                return "offWithFastRamp";
            }
        }
        throw new IllegalArgumentException();
    }

    public static boolean isOnAtBoundary(int val) {
        return val == 1 || val == 2 || val == 0;
    }

    public static boolean isOffAtBoundary(int val) {
        return val == 3 || val == 4;
    }

    public static boolean inconsistentStrategies(int startStrat, int endStrat) {
        if (startStrat == 0 && endStrat == 0) {
            return false;
        }
        return !ExpressionEntry.isOnAtBoundary(startStrat) || !ExpressionEntry.isOnAtBoundary(endStrat);
    }

    public static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("data");
        return retval;
    }

    public static ExpressionEntry buildFromXML(String elemName, Attributes attrs) throws IOException {
        if (!elemName.equals("data")) {
            return null;
        }
        String region = null;
        String time = null;
        String expr = null;
        String confidence = null;
        String startStrategy = null;
        String endStrategy = null;
        String variable = null;
        String srcStr = null;
        String stratSrcStr = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("region")) {
                    region = CharacterEntityMapper.unmapEntities(val, false);
                    continue;
                }
                if (key.equals("time")) {
                    time = val;
                    continue;
                }
                if (key.equals("expr")) {
                    expr = val;
                    continue;
                }
                if (key.equals("confidence")) {
                    confidence = val;
                    continue;
                }
                if (key.equals("starttype")) {
                    startStrategy = val;
                    continue;
                }
                if (key.equals("endtype")) {
                    endStrategy = val;
                    continue;
                }
                if (key.equals("value")) {
                    variable = val;
                    continue;
                }
                if (key.equals("source")) {
                    srcStr = val;
                    continue;
                }
                if (!key.equals("stratSource")) continue;
                stratSrcStr = val;
            }
        }
        if (region == null || time == null || expr == null) {
            throw new IOException();
        }
        return new ExpressionEntry(region, time, expr, srcStr, confidence, stratSrcStr, startStrategy, endStrategy, variable);
    }
}

