/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.timeCourse;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.systemsbiology.biotapestry.timeCourse.RegionAndRange;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.Indenter;
import org.xml.sax.Attributes;

public class InputTimeRange {
    private String name_;
    private ArrayList ranges_;

    public InputTimeRange(String name) {
        this.name_ = name;
        this.ranges_ = new ArrayList();
    }

    public InputTimeRange(InputTimeRange other) {
        this.name_ = other.name_;
        this.ranges_ = new ArrayList();
        int size = other.ranges_.size();
        for (int i = 0; i < size; ++i) {
            RegionAndRange rar = (RegionAndRange)other.ranges_.get(i);
            this.ranges_.add(new RegionAndRange(rar));
        }
    }

    public String getName() {
        return this.name_;
    }

    public void setName(String name) {
        this.name_ = name;
    }

    public void add(RegionAndRange range) {
        this.ranges_.add(range);
    }

    public int getRangeCount() {
        return this.ranges_.size();
    }

    public Iterator getRanges() {
        return this.ranges_.iterator();
    }

    public void getInterestingTimes(Set interest) {
        Iterator rit = this.getRanges();
        while (rit.hasNext()) {
            RegionAndRange range = (RegionAndRange)rit.next();
            range.getInterestingTimes(interest);
        }
    }

    public void getAllRegions(Set interest) {
        Iterator rit = this.getRanges();
        while (rit.hasNext()) {
            RegionAndRange range = (RegionAndRange)rit.next();
            range.getAllRegions(interest);
        }
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<inputTimeRange input=\"");
        out.print(CharacterEntityMapper.mapEntities(this.name_, false));
        out.println("\">");
        ind.up();
        if (this.ranges_.size() > 0) {
            Iterator rit = this.getRanges();
            while (rit.hasNext()) {
                RegionAndRange range = (RegionAndRange)rit.next();
                range.writeXML(out, ind);
            }
        }
        ind.down().indent();
        out.println("</inputTimeRange>");
    }

    public String toString() {
        return "InputTimeRange: name_ = " + this.name_ + " ranges = " + this.ranges_;
    }

    public static List splitRanges(String rangeInput) {
        ArrayList<String> retval = new ArrayList<String>();
        String[] result = rangeInput.split("\\s");
        if (result.length == 1 || result.length == 2) {
            retval.add(rangeInput);
            return retval;
        }
        if (result.length % 2 == 0) {
            for (int i = 0; i < result.length; i += 2) {
                retval.add(result[i] + " " + result[i + 1]);
            }
            return retval;
        }
        throw new IllegalArgumentException();
    }

    public static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("inputTimeRange");
        return retval;
    }

    public static InputTimeRange buildFromXML(String elemName, Attributes attrs) throws IOException {
        if (!elemName.equals("inputTimeRange")) {
            return null;
        }
        String name = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (!key.equals("input")) continue;
                name = CharacterEntityMapper.unmapEntities(val, false);
            }
        }
        if (name == null) {
            throw new IOException();
        }
        return new InputTimeRange(name);
    }
}

