/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.timeCourse;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.perturb.PertSources;
import org.systemsbiology.biotapestry.plugin.InternalNodeDataDisplayPlugIn;
import org.systemsbiology.biotapestry.plugin.PluginCallbackWorker;
import org.systemsbiology.biotapestry.timeCourse.PerturbedTimeCourseGene;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseData;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseGene;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseTableDrawer;
import org.systemsbiology.biotapestry.util.ResourceManager;

public class PerturbedTimeCourseDisplayPlugIn
implements InternalNodeDataDisplayPlugIn {
    public boolean isInternal() {
        return true;
    }

    public boolean requiresPerInstanceDisplay(String genomeID, String itemID) {
        return false;
    }

    public boolean haveCallbackWorker() {
        return false;
    }

    public PluginCallbackWorker getCallbackWorker(String genomeID, String nodeID) {
        return null;
    }

    public String getDataAsHTML(String genomeIDX, String nodeID) {
        StringBuffer buf = new StringBuffer();
        Database db = Database.getDB();
        TimeCourseData tcd = db.getTimeCourseData();
        if (tcd == null || !tcd.haveData()) {
            return "";
        }
        nodeID = GenomeItemInstance.getBaseID(nodeID);
        ResourceManager rMan = ResourceManager.getManager();
        buf.append("<center><h1>");
        buf.append(rMan.getString("dataWindow.perturbedExpressionProfiles"));
        buf.append("</h1>\n");
        boolean gotData = false;
        List dataKeys = tcd.getTimeCourseTCMDataKeysWithDefault(nodeID);
        if (dataKeys != null) {
            Iterator dkit = dataKeys.iterator();
            int needKey = 0;
            while (dkit.hasNext()) {
                TimeCourseData.TCMapping tcm = (TimeCourseData.TCMapping)dkit.next();
                TimeCourseGene tcg = tcd.getTimeCourseDataCaseInsensitive(tcm.name);
                if (tcg == null) continue;
                Iterator pkit = tcg.getPertKeys();
                while (pkit.hasNext()) {
                    PertSources pss = (PertSources)pkit.next();
                    StringWriter sw = new StringWriter();
                    PrintWriter out = new PrintWriter(sw);
                    PerturbedTimeCourseGene pertGene = tcg.getPerturbedState(pss);
                    int nextKey = pertGene.getExpressionTable(out, tcg, tcd);
                    needKey |= nextKey;
                    String tab = sw.getBuffer().toString();
                    if (tab == null || tab.trim().equals("")) continue;
                    gotData = true;
                    buf.append("<p>");
                    buf.append(tab);
                    buf.append("</p>");
                }
            }
            buf.append(TimeCourseTableDrawer.buildKey(needKey, false, true));
        }
        if (!gotData) {
            buf.append(rMan.getString("dataWindow.noPerturbedExpressionProfile"));
        }
        buf.append("</center>");
        return buf.toString();
    }
}

