/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.timeCourse;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.perturb.PertSources;
import org.systemsbiology.biotapestry.timeCourse.ExpressionEntry;
import org.systemsbiology.biotapestry.timeCourse.GeneTemplateEntry;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseData;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseGene;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseTableDrawer;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.Splitter;
import org.xml.sax.Attributes;

public class PerturbedTimeCourseGene
implements Cloneable,
TimeCourseTableDrawer.Client {
    private PertSources sources_;
    private ArrayList pertData_;
    private ArrayList controlData_;
    private String timeCourseNote_;
    private int confidence_;
    private boolean internalOnly_;

    public PerturbedTimeCourseGene(PerturbedTimeCourseGene other) {
        this(other, true);
    }

    public PerturbedTimeCourseGene(PerturbedTimeCourseGene other, boolean doData) {
        this.sources_ = (PertSources)other.sources_.clone();
        this.timeCourseNote_ = other.timeCourseNote_;
        this.confidence_ = other.confidence_;
        this.internalOnly_ = other.internalOnly_;
        this.pertData_ = new ArrayList();
        if (doData) {
            int size = other.pertData_.size();
            for (int i = 0; i < size; ++i) {
                ExpressionEntry exp = (ExpressionEntry)other.pertData_.get(i);
                this.pertData_.add(exp.clone());
            }
        }
        boolean haveControl = other.controlData_ != null;
        ArrayList arrayList = this.controlData_ = haveControl ? new ArrayList() : null;
        if (doData && haveControl) {
            int size = other.controlData_.size();
            for (int i = 0; i < size; ++i) {
                ExpressionEntry exp = (ExpressionEntry)other.controlData_.get(i);
                this.controlData_.add(exp.clone());
            }
        }
    }

    public PerturbedTimeCourseGene(PertSources sources, int confidence, boolean internalOnly) {
        this.sources_ = (PertSources)sources.clone();
        this.confidence_ = confidence;
        this.internalOnly_ = internalOnly;
        this.pertData_ = new ArrayList();
        this.controlData_ = null;
    }

    public PerturbedTimeCourseGene(PertSources sources, Iterator tempit) {
        this.sources_ = (PertSources)sources.clone();
        this.confidence_ = 0;
        this.internalOnly_ = false;
        this.pertData_ = new ArrayList();
        while (tempit.hasNext()) {
            GeneTemplateEntry gte = (GeneTemplateEntry)tempit.next();
            ExpressionEntry exp = new ExpressionEntry(gte.region, gte.time, 0, -1);
            this.pertData_.add(exp);
        }
        this.controlData_ = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PerturbedTimeCourseGene(String srcs, String confidence, String note, String internalOnly) throws IOException {
        if (srcs == null) {
            throw new IOException();
        }
        this.sources_ = new PertSources();
        ArrayList srcList = Splitter.stringBreak(srcs, ",", 0, false);
        int numSrc = srcList.size();
        for (int i = 0; i < numSrc; ++i) {
            String srcID = (String)srcList.get(i);
            this.sources_.addSourceID(srcID);
        }
        if (confidence == null) {
            this.confidence_ = 0;
        } else {
            try {
                this.confidence_ = TimeCourseGene.mapToConfidence(confidence.trim());
            }
            catch (IllegalArgumentException iaex) {
                throw new IOException();
            }
        }
        if (internalOnly != null) {
            if ((internalOnly = internalOnly.trim()).equalsIgnoreCase("no")) {
                this.internalOnly_ = false;
            } else {
                if (!internalOnly.equalsIgnoreCase("yes")) throw new IOException();
                this.internalOnly_ = true;
            }
        } else {
            this.internalOnly_ = false;
        }
        this.timeCourseNote_ = note;
        this.pertData_ = new ArrayList();
        this.controlData_ = null;
    }

    public Object clone() {
        try {
            ExpressionEntry exp;
            int i;
            PerturbedTimeCourseGene retval = (PerturbedTimeCourseGene)super.clone();
            int size = this.pertData_.size();
            retval.pertData_ = new ArrayList();
            for (i = 0; i < size; ++i) {
                exp = (ExpressionEntry)this.pertData_.get(i);
                retval.pertData_.add(exp.clone());
            }
            if (this.controlData_ != null) {
                retval.controlData_ = new ArrayList();
                for (i = 0; i < size; ++i) {
                    exp = (ExpressionEntry)this.controlData_.get(i);
                    retval.controlData_.add(exp.clone());
                }
            }
            return retval;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public String getName() {
        return this.sources_.getDisplayString(Database.getDB().getPertData(), 0);
    }

    public PertSources getPertSources() {
        return this.sources_;
    }

    public void setSources(PertSources sources) {
        this.sources_ = sources;
    }

    public int getConfidence() {
        return this.confidence_;
    }

    public void setConfidence(int confidence) {
        this.confidence_ = confidence;
    }

    public int mapEntryConfidence(int entryConfidence) {
        return TimeCourseGene.mapEntryConfidence(this.confidence_, entryConfidence);
    }

    public int reverseMapEntryConfidence(int entryConfidence) {
        return TimeCourseGene.reverseMapEntryConfidence(this.confidence_, entryConfidence);
    }

    public boolean isInternalOnly() {
        return this.internalOnly_;
    }

    public void setInternalOnly(boolean state) {
        this.internalOnly_ = state;
    }

    public void setTimeCourseNote(String timeCourseNote) {
        this.timeCourseNote_ = timeCourseNote;
    }

    public String getTimeCourseNote() {
        return this.timeCourseNote_;
    }

    public void setForDistinctControlExpr() {
        this.controlData_ = new ArrayList();
    }

    public void setForDistinctControlExpr(Iterator tempit) {
        this.controlData_ = new ArrayList();
        while (tempit.hasNext()) {
            GeneTemplateEntry gte = (GeneTemplateEntry)tempit.next();
            ExpressionEntry exp = new ExpressionEntry(gte.region, gte.time, 0, -1);
            this.controlData_.add(exp);
        }
    }

    public void dropDistinctControlExpr() {
        this.controlData_ = null;
    }

    public boolean usingDistinctControlExpr() {
        return this.controlData_ != null;
    }

    public void addExpression(ExpressionEntry expr, ExpressionEntry ctrlExpr) {
        this.pertData_.add(expr);
        if (ctrlExpr != null) {
            if (this.controlData_ == null) {
                throw new IllegalArgumentException();
            }
            this.controlData_.add(ctrlExpr);
        }
    }

    public void addCtrlExpression(ExpressionEntry ctrlExpr) {
        if (this.controlData_ == null) {
            throw new IllegalArgumentException();
        }
        this.controlData_.add(ctrlExpr);
    }

    public void replaceExpressions(List exprs, List ctrlExpr) {
        this.pertData_.clear();
        this.pertData_.addAll(exprs);
        if (ctrlExpr != null) {
            if (this.controlData_ == null) {
                throw new IllegalArgumentException();
            }
            this.controlData_.clear();
            this.controlData_.addAll(ctrlExpr);
        }
    }

    public void addExpression(int index, ExpressionEntry expr, ExpressionEntry ctrlExpr) {
        this.pertData_.add(index, expr);
        if (ctrlExpr != null) {
            if (this.controlData_ == null) {
                throw new IllegalArgumentException();
            }
            this.controlData_.add(index, ctrlExpr);
        }
    }

    public void deleteExpression(int i) {
        this.pertData_.remove(i);
        if (this.controlData_ != null) {
            this.controlData_.remove(i);
        }
    }

    public ExpressionEntry getExpression(int n) {
        return (ExpressionEntry)this.pertData_.get(n);
    }

    public ExpressionEntry getControlExpression(int n) {
        if (this.controlData_ == null) {
            throw new IllegalStateException();
        }
        return (ExpressionEntry)this.controlData_.get(n);
    }

    public Iterator getExpressions() {
        return this.pertData_.iterator();
    }

    public Iterator getControlExpressions() {
        if (this.controlData_ == null) {
            throw new IllegalStateException();
        }
        return this.controlData_.iterator();
    }

    public void updateExpression(int i, GeneTemplateEntry newEntry) {
        ExpressionEntry ee = this.getExpression(i);
        ee.updateRegionAndTime(newEntry.region, newEntry.time);
        if (this.controlData_ != null) {
            ee = this.getControlExpression(i);
            ee.updateRegionAndTime(newEntry.region, newEntry.time);
        }
    }

    public int getExpressionLevelForSource(String region, int hour, int exprSource, TimeCourseGene.VariableLevel varLev) {
        Iterator eit = this.getExpressions();
        return this.getExpressionLevelGuts(eit, region, hour, exprSource, varLev);
    }

    public int getControlExpressionLevelForSource(String region, int hour, int exprSource, TimeCourseGene.VariableLevel varLev) {
        Iterator eit = this.getControlExpressions();
        return this.getExpressionLevelGuts(eit, region, hour, exprSource, varLev);
    }

    private int getExpressionLevelGuts(Iterator eit, String region, int hour, int exprSource, TimeCourseGene.VariableLevel varLev) {
        while (eit.hasNext()) {
            ExpressionEntry ee = (ExpressionEntry)eit.next();
            int time = ee.getTime();
            if (!DataUtil.keysEqual(ee.getRegion(), region) || hour != time) continue;
            int matchExpr = ee.getExpressionForSource(exprSource);
            if (matchExpr == 4) {
                varLev.level = ee.getVariableLevelForSource(exprSource);
            }
            return matchExpr;
        }
        return -1;
    }

    public int getConfidence(String region, int time) {
        Iterator eit = this.getExpressions();
        while (eit.hasNext()) {
            ExpressionEntry ee = (ExpressionEntry)eit.next();
            int eTime = ee.getTime();
            if (!DataUtil.keysEqual(ee.getRegion(), region) || eTime != time) continue;
            int confidence = ee.getConfidence();
            return confidence == -1 ? this.confidence_ : confidence;
        }
        System.err.println("No confidence for " + time);
        throw new IllegalArgumentException();
    }

    public int getExprSource(String region, int time) {
        Iterator eit = this.getExpressions();
        while (eit.hasNext()) {
            ExpressionEntry ee = (ExpressionEntry)eit.next();
            int eTime = ee.getTime();
            if (!DataUtil.keysEqual(ee.getRegion(), region) || eTime != time) continue;
            return ee.getSource();
        }
        System.err.println("No source for " + time);
        throw new IllegalArgumentException();
    }

    public void getInterestingTimes(Set interest) {
        Iterator exps = this.getExpressions();
        while (exps.hasNext()) {
            ExpressionEntry exp = (ExpressionEntry)exps.next();
            int time = exp.getTime();
            interest.add(new Integer(time));
        }
    }

    public void getRegions(Set regions) {
        Iterator exps = this.getExpressions();
        while (exps.hasNext()) {
            ExpressionEntry exp = (ExpressionEntry)exps.next();
            regions.add(exp.getRegion());
        }
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ExpressionEntry exp;
        Iterator exps;
        ind.indent();
        out.print("<perturbExpr srcs=\"");
        out.print(this.sources_.sourcesAsString());
        out.print("\" baseConfidence=\"");
        out.print(TimeCourseGene.mapConfidence(this.confidence_));
        if (this.timeCourseNote_ != null) {
            out.print("\" note=\"");
            out.print(CharacterEntityMapper.mapEntities(this.timeCourseNote_, false));
        }
        if (this.internalOnly_) {
            out.print("\" internalOnly=\"yes");
        }
        out.println("\">");
        ind.up();
        if (this.pertData_.size() > 0) {
            ind.indent();
            out.println("<perts>");
            ind.up();
            exps = this.getExpressions();
            while (exps.hasNext()) {
                exp = (ExpressionEntry)exps.next();
                exp.writeXML(out, ind);
            }
            ind.down().indent();
            out.println("</perts>");
        }
        ind.down();
        ind.up();
        if (this.controlData_ != null && this.controlData_.size() > 0) {
            ind.indent();
            out.println("<ctrls>");
            ind.up();
            exps = this.getControlExpressions();
            while (exps.hasNext()) {
                exp = (ExpressionEntry)exps.next();
                exp.writeXML(out, ind);
            }
            ind.down().indent();
            out.println("</ctrls>");
        }
        ind.down().indent();
        out.println("</perturbExpr>");
    }

    public int getExpressionTable(PrintWriter out, TimeCourseGene wtGene, TimeCourseData tcd) {
        return new TimeCourseTableDrawer(wtGene, this).getPertExpressionTable(out, tcd);
    }

    public String toString() {
        return "PerturbedTimeCourseGene: sources = " + this.sources_ + " confidence = " + this.confidence_ + " expressions = " + this.pertData_ + " expressions = " + this.controlData_;
    }

    public static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("perturbExpr");
        return retval;
    }

    public static String keyForControlCollection() {
        return "ctrls";
    }

    public static PerturbedTimeCourseGene buildFromXML(String elemName, Attributes attrs) throws IOException {
        if (!elemName.equals("perturbExpr")) {
            return null;
        }
        String pertSrcs = null;
        String confidence = null;
        String note = null;
        String internalOnly = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("baseConfidence")) {
                    confidence = val;
                    continue;
                }
                if (key.equals("srcs")) {
                    pertSrcs = val;
                    continue;
                }
                if (key.equals("note")) {
                    note = CharacterEntityMapper.unmapEntities(val, false);
                    continue;
                }
                if (!key.equals("internalOnly")) continue;
                internalOnly = val;
            }
        }
        if (confidence == null || pertSrcs == null) {
            throw new IOException();
        }
        return new PerturbedTimeCourseGene(pertSrcs, confidence, note, internalOnly);
    }
}

