/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.timeCourse;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.undo.UndoManager;
import org.systemsbiology.biotapestry.cmd.TimeCourseChangeCmd;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.TimeAxisDefinition;
import org.systemsbiology.biotapestry.event.GeneralChangeEvent;
import org.systemsbiology.biotapestry.perturb.CSVData;
import org.systemsbiology.biotapestry.perturb.PertDictionary;
import org.systemsbiology.biotapestry.perturb.PertProperties;
import org.systemsbiology.biotapestry.perturb.PertSource;
import org.systemsbiology.biotapestry.perturb.PertSources;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.timeCourse.ExpressionEntry;
import org.systemsbiology.biotapestry.timeCourse.PerturbedTimeCourseGene;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseChange;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseData;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseGene;
import org.systemsbiology.biotapestry.util.CSVParser;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.InvalidInputException;
import org.systemsbiology.biotapestry.util.UndoSupport;

public class PerturbedTimeCourseGeneCSVFormatFactory {
    private static final int BAD_VALUES_ = -1;
    private static final int GENE_AND_PERT_ = 0;
    private static final int PERT_VALUE_ = 1;
    private static final String GENE_AND_PERT_STR_ = "pertGene";
    private static final String PERT_VALUE_STR_ = "pertGeneEntry";
    public static final String UNDEFINED_PERTURBATION = "PECSV_UNDEFINED_PERTURBATION";
    public static final String TOO_FEW_TOKENS = "PECSV_TOO_FEW_TOKENS";
    public static final String INVALID_NUMBER = "PECSV_INVALID_NUMBER";
    public static final String INCORRECT_INSTRUCTION_DEFINITION = "PECSV_INCORRECT_INSTRUCTION_DEFINITION";
    public static final String DUPLICATE_DEFINITION = "PECSV_DUPLICATE_DEFINITION";
    public static final String BAD_TIME_DEFINITION = "PECSV_BAD_TIME_DEFINITION";
    public static final String BAD_EXPRESSION_TAG = "PECSV_BAD_EXPRESSION_TAG";
    public static final String MISSING_VARIABLE_VALUE = "PECSV_MISSING_VARIABLE_VALUE";
    public static final String MISSING_CTRL_VALUE = "PECSV_MISSING_CTRL_VALUE";
    public static final String NON_EMPTY_VARIABLE_VALUE = "PECSV_NON_EMPTY_VARIABLE_VALUE";
    public static final String BAD_CONFIDENCE_TAG = "PECSV_BAD_CONFIDENCE_TAG";
    public static final String NON_EXISTENT_GENE = "PECSV_NON_EXISTENT_GENE";
    public static final String NO_REGION_TIME_MATCH = "PECSV_NO_REGION_TIME_MATCH";
    public static final String NON_MATCHING_CONTROL = "PECSV_NON_MATCHING_CONTROL";

    public boolean readPerturbedExpressionCSV(File infile, JFrame topWindow, UndoManager undo) throws IOException, InvalidInputException {
        HashMap pertGenes = new HashMap();
        HashMap pertGeneEntries = new HashMap();
        this.readCSV(infile, pertGenes, pertGeneEntries);
        return this.applyProperties(pertGenes, pertGeneEntries, undo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readCSV(File infile, Map pertGenes, Map pertGeneEntries) throws IOException, InvalidInputException {
        BufferedReader in = new BufferedReader(new FileReader(infile));
        CSVParser csvp = new CSVParser(true);
        String line = null;
        int lineNumber = -1;
        try {
            block6: while ((line = in.readLine()) != null) {
                List tokens;
                ++lineNumber;
                if (line.trim().equals("") || (tokens = csvp.processCSVLine(line)).isEmpty() || ((String)tokens.get(0)).trim().startsWith("#")) continue;
                int tokenCategory = this.getCategory((String)tokens.get(0));
                switch (tokenCategory) {
                    case 0: {
                        GeneEntry ge = new GeneEntry(tokens, lineNumber);
                        HashMap<PertSources, Object> forGene = (HashMap<PertSources, Object>)pertGenes.get(DataUtil.normKey(ge.targetGene));
                        if (forGene == null) {
                            forGene = new HashMap<PertSources, Object>();
                            pertGenes.put(DataUtil.normKey(ge.targetGene), forGene);
                        }
                        if (forGene.get(ge.pss) != null) {
                            throw new InvalidInputException(DUPLICATE_DEFINITION, lineNumber);
                        }
                        forGene.put(ge.pss, ge);
                        continue block6;
                    }
                    case 1: {
                        ArrayList<PertEntry> forPert;
                        PertEntry pe = new PertEntry(tokens, lineNumber);
                        HashMap<PertSources, Object> forGene = (HashMap)pertGeneEntries.get(DataUtil.normKey(pe.targetGene));
                        if (forGene == null) {
                            forGene = new HashMap();
                            pertGeneEntries.put(DataUtil.normKey(pe.targetGene), forGene);
                        }
                        if ((forPert = (ArrayList<PertEntry>)forGene.get(pe.pss)) == null) {
                            forPert = new ArrayList<PertEntry>();
                            forGene.put(pe.pss, forPert);
                        }
                        forPert.add(pe);
                        continue block6;
                    }
                }
                throw new InvalidInputException(INCORRECT_INSTRUCTION_DEFINITION, lineNumber);
            }
        }
        catch (IOException ioex) {
            in.close();
            throw ioex;
        }
        in.close();
    }

    private int getCategory(String tok) {
        if (tok == null) {
            return -1;
        }
        if (tok.equalsIgnoreCase(GENE_AND_PERT_STR_)) {
            return 0;
        }
        if (tok.equalsIgnoreCase(PERT_VALUE_STR_)) {
            return 1;
        }
        return -1;
    }

    private boolean applyProperties(Map pertGenes, Map pertGeneEntries, UndoManager undo) throws InvalidInputException {
        TimeCourseGene tcg;
        Iterator fgit;
        Database db = Database.getDB();
        TimeCourseData tcd = db.getTimeCourseData();
        HashMap builtGenes = new HashMap();
        Iterator pgit = pertGenes.keySet().iterator();
        while (pgit.hasNext()) {
            String targName = (String)pgit.next();
            HashMap forGene = (HashMap)pertGenes.get(targName);
            fgit = forGene.keySet().iterator();
            TimeCourseGene tcg2 = tcd.getTimeCourseData(targName);
            if (tcg2 == null) {
                throw new InvalidInputException(NON_EXISTENT_GENE, ((GeneEntry)forGene.get(fgit.next())).lineNumber);
            }
            while (fgit.hasNext()) {
                PertSources pss = (PertSources)fgit.next();
                GeneEntry ge = (GeneEntry)forGene.get(pss);
                PerturbedTimeCourseGene ptcg = tcg2.getPerturbedState(ge.pss);
                ptcg = ptcg == null ? new PerturbedTimeCourseGene((PertSources)ge.pss.clone(), tcd.getGeneTemplate()) : (PerturbedTimeCourseGene)ptcg.clone();
                ptcg.setInternalOnly(ge.isInternal);
                ptcg.setTimeCourseNote(ge.note.length() == 0 ? null : ge.note);
                ptcg.setConfidence(ge.baseConfidence);
                boolean usingDefCtrl = ptcg.usingDistinctControlExpr();
                if (!usingDefCtrl && ge.defineControl) {
                    ptcg.setForDistinctControlExpr(tcd.getGeneTemplate());
                } else if (usingDefCtrl && !ge.defineControl) {
                    ptcg.dropDistinctControlExpr();
                }
                HashMap<PertSources, PerturbedTimeCourseGene> builtForGene = (HashMap<PertSources, PerturbedTimeCourseGene>)builtGenes.get(targName);
                if (builtForGene == null) {
                    builtForGene = new HashMap<PertSources, PerturbedTimeCourseGene>();
                    builtGenes.put(targName, builtForGene);
                }
                if (builtForGene.get(ge.pss) != null) {
                    throw new InvalidInputException(DUPLICATE_DEFINITION, ge.lineNumber);
                }
                builtForGene.put(ge.pss, ptcg);
            }
        }
        Iterator tpgit = pertGeneEntries.keySet().iterator();
        while (tpgit.hasNext()) {
            PertSources pss;
            String targName = (String)tpgit.next();
            HashMap forGene = (HashMap)pertGeneEntries.get(targName);
            HashMap<PertSources, PerturbedTimeCourseGene> builtForGene = (HashMap<PertSources, PerturbedTimeCourseGene>)builtGenes.get(targName);
            if (builtForGene == null) {
                builtForGene = new HashMap<PertSources, PerturbedTimeCourseGene>();
                builtGenes.put(targName, builtForGene);
            }
            Iterator fgit2 = forGene.keySet().iterator();
            tcg = tcd.getTimeCourseData(targName);
            if (tcg == null) {
                pss = (PertSources)fgit2.next();
                ArrayList forPert = (ArrayList)forGene.get(pss);
                throw new InvalidInputException(NON_EXISTENT_GENE, ((PertEntry)forPert.get((int)0)).lineNumber);
            }
            while (fgit2.hasNext()) {
                pss = (PertSources)fgit2.next();
                ArrayList forPert = (ArrayList)forGene.get(pss);
                PerturbedTimeCourseGene ptcg = (PerturbedTimeCourseGene)builtForGene.get(pss);
                if (ptcg == null) {
                    ptcg = tcg.getPerturbedState(pss);
                    ptcg = ptcg == null ? new PerturbedTimeCourseGene((PertSources)pss.clone(), tcd.getGeneTemplate()) : (PerturbedTimeCourseGene)ptcg.clone();
                    builtForGene.put(pss, ptcg);
                }
                this.installInMatchingExpr(ptcg, forPert, false, ptcg.getConfidence());
                if (ptcg.usingDistinctControlExpr()) {
                    this.installInMatchingExpr(ptcg, forPert, true, ptcg.getConfidence());
                    continue;
                }
                this.compareToMatchingExpr(tcg, forPert);
            }
        }
        UndoSupport support = new UndoSupport(undo, "undo.pertExprFromCSV");
        fgit = builtGenes.keySet().iterator();
        boolean doit = false;
        while (fgit.hasNext()) {
            String targName = (String)fgit.next();
            tcg = tcd.getTimeCourseData(targName);
            HashMap builtForGene = (HashMap)builtGenes.get(targName);
            TimeCourseChange tcc = tcd.startGeneUndoTransaction(tcg.getName());
            Iterator bfgit = builtForGene.keySet().iterator();
            boolean doForMe = false;
            while (bfgit.hasNext()) {
                PertSources pss = (PertSources)bfgit.next();
                PerturbedTimeCourseGene ptcg = (PerturbedTimeCourseGene)builtForGene.get(pss);
                tcg.setPerturbedState((PertSources)pss.clone(), ptcg);
                doForMe = true;
            }
            if (!doForMe) continue;
            tcc = tcd.finishGeneUndoTransaction(tcg.getName(), tcc);
            support.addEdit(new TimeCourseChangeCmd(tcc));
            doit = true;
        }
        if (doit) {
            support.addEvent(new GeneralChangeEvent(2));
            support.finish();
        }
        return true;
    }

    private void installInMatchingExpr(PerturbedTimeCourseGene ptcg, List forPert, boolean forControl, int baseConfidence) throws InvalidInputException {
        int numForPert = forPert.size();
        for (int i = 0; i < numForPert; ++i) {
            PertEntry pe = (PertEntry)forPert.get(i);
            Iterator pexit = forControl ? ptcg.getControlExpressions() : ptcg.getExpressions();
            boolean matched = false;
            while (pexit.hasNext()) {
                ExpressionEntry ee = (ExpressionEntry)pexit.next();
                if (!DataUtil.keysEqual(ee.getRegion(), pe.region) || ee.getTime() != pe.time) continue;
                matched = true;
                if (forControl && pe.ctrlExp == null) {
                    throw new InvalidInputException(MISSING_CTRL_VALUE, pe.lineNumber);
                }
                int exp = forControl ? pe.ctrlExp : pe.pertExp;
                Double val = forControl ? pe.ctrlVal : pe.pertVal;
                ee.setExpression(exp);
                if (val != null) {
                    if (exp != 4) {
                        throw new InvalidInputException(NON_EMPTY_VARIABLE_VALUE, pe.lineNumber);
                    }
                    ee.setVariableLevel(val);
                } else {
                    if (exp == 4) {
                        throw new InvalidInputException(MISSING_VARIABLE_VALUE, pe.lineNumber);
                    }
                    ee.setVariableLevel(0.0);
                }
                if (forControl || pe.confidence == null) break;
                int useConf = TimeCourseGene.reverseMapEntryConfidence(baseConfidence, pe.confidence);
                ee.setConfidence(useConf);
                break;
            }
            if (matched) continue;
            throw new InvalidInputException(NO_REGION_TIME_MATCH, pe.lineNumber);
        }
    }

    private void compareToMatchingExpr(TimeCourseGene tcg, List forPert) throws InvalidInputException {
        int numForPert = forPert.size();
        for (int i = 0; i < numForPert; ++i) {
            PertEntry pe = (PertEntry)forPert.get(i);
            Iterator texit = tcg.getExpressions();
            boolean matched = false;
            while (texit.hasNext()) {
                int ctrlExp;
                ExpressionEntry ee = (ExpressionEntry)texit.next();
                if (!DataUtil.keysEqual(ee.getRegion(), pe.region) || ee.getTime() != pe.time) continue;
                matched = true;
                if (pe.ctrlExp == null) continue;
                int wtExp = ee.getExpressionForSource(0);
                if (wtExp != (ctrlExp = pe.ctrlExp.intValue())) {
                    throw new InvalidInputException(NON_MATCHING_CONTROL, pe.lineNumber);
                }
                if (wtExp == 4) {
                    if (pe.ctrlVal == null) {
                        throw new InvalidInputException(MISSING_VARIABLE_VALUE, pe.lineNumber);
                    }
                    if (ee.getVariableLevelForSource(0) == pe.ctrlVal.doubleValue()) break;
                    throw new InvalidInputException(NON_MATCHING_CONTROL, pe.lineNumber);
                }
                if (pe.ctrlVal == null) break;
                throw new InvalidInputException(NON_EMPTY_VARIABLE_VALUE, pe.lineNumber);
            }
            if (matched) continue;
            throw new InvalidInputException(NO_REGION_TIME_MATCH, pe.lineNumber);
        }
    }

    private static List experimentParse(String value, int lineNumber) throws InvalidInputException {
        PerturbationData pd = Database.getDB().getPertData();
        CSVData.ExperimentTokens exptok = new CSVData.ExperimentTokens();
        PertDictionary pDict = pd.getPertDictionary();
        Iterator pdkit = pDict.getKeys();
        while (pdkit.hasNext()) {
            String key = (String)pdkit.next();
            PertProperties pProps = pDict.getPerturbProps(key);
            if (!exptok.haveAMatch(value, pProps.getType(), pProps.getAbbrev())) continue;
            Iterator sdkit = pd.getSourceDefKeys();
            while (sdkit.hasNext()) {
                String sdkey = (String)sdkit.next();
                PertSource ps = pd.getSourceDef(sdkey);
                if (!ps.getExpType(pDict).equals(pProps) || !DataUtil.keysEqual(exptok.base, ps.getSourceName(pd))) continue;
                ArrayList<String> retval = new ArrayList<String>();
                retval.add(ps.getID());
                return retval;
            }
        }
        throw new InvalidInputException(UNDEFINED_PERTURBATION, lineNumber);
    }

    public static class PertEntry {
        String targetGene;
        PertSources pss;
        String region;
        int time;
        int pertExp;
        Double pertVal;
        Integer ctrlExp;
        Double ctrlVal;
        Integer confidence;
        int lineNumber;

        public PertEntry(List tokens, int lineNumber) throws InvalidInputException {
            String ctrlValStr;
            String pertValStr;
            this.lineNumber = lineNumber;
            int tokSize = tokens.size();
            if (tokSize < 6) {
                throw new InvalidInputException(PerturbedTimeCourseGeneCSVFormatFactory.TOO_FEW_TOKENS, lineNumber);
            }
            this.targetGene = (String)tokens.get(1);
            this.pss = new PertSources(PerturbedTimeCourseGeneCSVFormatFactory.experimentParse((String)tokens.get(2), lineNumber));
            this.region = (String)tokens.get(3);
            TimeAxisDefinition tad = Database.getDB().getTimeAxisDefinition();
            Integer parsed = tad.timeStringParse((String)tokens.get(4));
            if (parsed == null || parsed < 0) {
                throw new InvalidInputException(PerturbedTimeCourseGeneCSVFormatFactory.BAD_TIME_DEFINITION, lineNumber);
            }
            this.time = parsed;
            boolean needVar = false;
            boolean needCtrlVar = false;
            try {
                this.pertExp = ExpressionEntry.mapFromExpressionTag((String)tokens.get(5));
                boolean bl = needVar = this.pertExp == 4;
                if (tokSize > 8) {
                    this.ctrlExp = new Integer(ExpressionEntry.mapFromExpressionTag((String)tokens.get(8)));
                    needCtrlVar = this.ctrlExp == 4;
                }
            }
            catch (IllegalArgumentException iaex) {
                throw new InvalidInputException(PerturbedTimeCourseGeneCSVFormatFactory.BAD_EXPRESSION_TAG, lineNumber);
            }
            String string = pertValStr = tokSize > 6 ? (String)tokens.get(6) : null;
            if (needVar) {
                if (pertValStr == null) {
                    throw new InvalidInputException(PerturbedTimeCourseGeneCSVFormatFactory.MISSING_VARIABLE_VALUE, lineNumber);
                }
                try {
                    this.pertVal = new Double(pertValStr);
                }
                catch (NumberFormatException nfex) {
                    throw new InvalidInputException(PerturbedTimeCourseGeneCSVFormatFactory.INVALID_NUMBER, lineNumber);
                }
                if (this.pertVal < 0.0 || this.pertVal > 1.0) {
                    throw new InvalidInputException(PerturbedTimeCourseGeneCSVFormatFactory.INVALID_NUMBER, lineNumber);
                }
            } else if (pertValStr != null && !pertValStr.trim().equals("")) {
                throw new InvalidInputException(PerturbedTimeCourseGeneCSVFormatFactory.NON_EMPTY_VARIABLE_VALUE, lineNumber);
            }
            String string2 = ctrlValStr = tokSize > 9 ? (String)tokens.get(9) : null;
            if (needCtrlVar) {
                if (ctrlValStr == null) {
                    throw new InvalidInputException(PerturbedTimeCourseGeneCSVFormatFactory.MISSING_VARIABLE_VALUE, lineNumber);
                }
                try {
                    this.ctrlVal = new Double(ctrlValStr);
                }
                catch (NumberFormatException nfex) {
                    throw new InvalidInputException(PerturbedTimeCourseGeneCSVFormatFactory.INVALID_NUMBER, lineNumber);
                }
                if (this.ctrlVal < 0.0 || this.ctrlVal > 1.0) {
                    throw new InvalidInputException(PerturbedTimeCourseGeneCSVFormatFactory.INVALID_NUMBER, lineNumber);
                }
            } else if (ctrlValStr != null && !ctrlValStr.trim().equals("")) {
                throw new InvalidInputException(PerturbedTimeCourseGeneCSVFormatFactory.NON_EMPTY_VARIABLE_VALUE, lineNumber);
            }
            if (tokSize > 7) {
                try {
                    String confStr = ((String)tokens.get(7)).trim();
                    this.confidence = confStr.equals("") ? new Integer(-1) : new Integer(TimeCourseGene.mapToConfidence(confStr));
                }
                catch (IllegalArgumentException iaex) {
                    throw new InvalidInputException(PerturbedTimeCourseGeneCSVFormatFactory.BAD_CONFIDENCE_TAG, lineNumber);
                }
            }
        }
    }

    public static class GeneEntry {
        String targetGene;
        PertSources pss;
        int baseConfidence;
        String note;
        boolean isInternal;
        boolean defineControl;
        int lineNumber;

        public GeneEntry(List tokens, int lineNumber) throws InvalidInputException {
            this.lineNumber = lineNumber;
            int tokSize = tokens.size();
            if (tokSize < 7) {
                throw new InvalidInputException(PerturbedTimeCourseGeneCSVFormatFactory.TOO_FEW_TOKENS, lineNumber);
            }
            this.targetGene = (String)tokens.get(1);
            this.pss = new PertSources(PerturbedTimeCourseGeneCSVFormatFactory.experimentParse((String)tokens.get(2), lineNumber));
            try {
                this.baseConfidence = TimeCourseGene.mapToConfidence(((String)tokens.get(3)).trim());
            }
            catch (IllegalArgumentException iaex) {
                throw new InvalidInputException(PerturbedTimeCourseGeneCSVFormatFactory.BAD_CONFIDENCE_TAG, lineNumber);
            }
            this.note = ((String)tokens.get(4)).trim();
            this.isInternal = Boolean.valueOf(((String)tokens.get(5)).trim());
            this.defineControl = Boolean.valueOf(((String)tokens.get(6)).trim());
        }
    }
}

