/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.timeCourse;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.perturb.PertSource;
import org.systemsbiology.biotapestry.perturb.PertSources;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.plugin.InternalLinkDataDisplayPlugIn;
import org.systemsbiology.biotapestry.plugin.PluginCallbackWorker;
import org.systemsbiology.biotapestry.timeCourse.PerturbedTimeCourseGene;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseData;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseGene;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseTableDrawer;
import org.systemsbiology.biotapestry.util.ResourceManager;

public class PerturbedTimeCourseLinkDisplayPlugIn
implements InternalLinkDataDisplayPlugIn {
    public boolean isInternal() {
        return true;
    }

    public boolean requiresPerInstanceDisplay(String genomeID, String itemID) {
        return true;
    }

    public boolean haveCallbackWorker() {
        return false;
    }

    public PluginCallbackWorker getCallbackWorker(String genomeID, String nodeID) {
        return null;
    }

    public String getDataAsHTML(String genomeID, String linkID) {
        StringBuffer buf = new StringBuffer();
        Database db = Database.getDB();
        Genome genome = db.getGenome(genomeID);
        Linkage link = genome.getLinkage(linkID);
        String targID = link.getTarget();
        String sourceID = link.getSource();
        String baseTargID = GenomeItemInstance.getBaseID(targID);
        String baseSourceID = GenomeItemInstance.getBaseID(sourceID);
        TimeCourseData tcd = db.getTimeCourseData();
        if (tcd == null || !tcd.haveData()) {
            return "";
        }
        PerturbationData pd = db.getPertData();
        ResourceManager rMan = ResourceManager.getManager();
        buf.append("<p></p>");
        buf.append("<center><h1>");
        buf.append(rMan.getString("dataWindow.perturbedTimeCourseDataForLink"));
        buf.append("</h1>\n");
        List srcPertKeys = pd.getDataSourceKeysWithDefault(baseSourceID);
        boolean gotData = false;
        List dataKeys = tcd.getTimeCourseTCMDataKeysWithDefault(baseTargID);
        int needKey = 0;
        if (dataKeys != null) {
            Iterator dkit = dataKeys.iterator();
            while (dkit.hasNext()) {
                TimeCourseData.TCMapping tcm = (TimeCourseData.TCMapping)dkit.next();
                TimeCourseGene tcg = tcd.getTimeCourseDataCaseInsensitive(tcm.name);
                if (tcg == null) continue;
                Iterator pkit = tcg.getPertKeys();
                while (pkit.hasNext()) {
                    PertSources pss = (PertSources)pkit.next();
                    boolean match = false;
                    Iterator psssit = pss.getSources();
                    while (psssit.hasNext()) {
                        String pertSrcID = (String)psssit.next();
                        PertSource chk = pd.getSourceDef(pertSrcID);
                        if (!srcPertKeys.contains(chk.getSourceNameKey())) continue;
                        match = true;
                        break;
                    }
                    if (!match) continue;
                    StringWriter sw = new StringWriter();
                    PrintWriter out = new PrintWriter(sw);
                    PerturbedTimeCourseGene pertGene = tcg.getPerturbedState(pss);
                    int nextKey = pertGene.getExpressionTable(out, tcg, tcd);
                    needKey |= nextKey;
                    String tab = sw.getBuffer().toString();
                    if (tab == null || tab.trim().equals("")) continue;
                    gotData = true;
                    buf.append("<p>");
                    buf.append(tab);
                    buf.append("</p>");
                }
            }
        }
        buf.append(TimeCourseTableDrawer.buildKey(needKey, false, true));
        if (!gotData) {
            buf.append(rMan.getString("dataWindow.noExpressionProfile"));
        }
        buf.append("</center>");
        return buf.toString();
    }
}

