/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.timeCourse;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.TimeAxisDefinition;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.Indenter;
import org.xml.sax.Attributes;

public class RegionAndRange {
    public static final int PROMOTER = 0;
    public static final int REPRESSOR = 1;
    public static final int NO_STRATEGY_SPECIFIED = 0;
    public static final int ON_AT_BOUNDARY = 1;
    public static final int OFF_AT_BOUNDARY = 2;
    public static final int NUM_STRATEGIES = 3;
    private String region_;
    private String source_;
    private String note_;
    private int min_;
    private int max_;
    private int sign_;
    private int startStrategy_;
    private int endStrategy_;

    public RegionAndRange(RegionAndRange other) {
        this.region_ = other.region_;
        this.source_ = other.source_;
        this.note_ = other.note_;
        this.min_ = other.min_;
        this.max_ = other.max_;
        this.sign_ = other.sign_;
        this.startStrategy_ = other.startStrategy_;
        this.endStrategy_ = other.endStrategy_;
    }

    public RegionAndRange(String inputTokens, String color, String note, int startStrategy, int endStrategy) {
        this.parseRange(inputTokens);
        this.sign_ = this.parseColorToken(color);
        this.note_ = note;
        this.source_ = null;
        this.startStrategy_ = startStrategy;
        this.endStrategy_ = endStrategy;
    }

    public RegionAndRange(String inputTokens, String color, String note) {
        this(inputTokens, color, note, 0, 0);
    }

    public RegionAndRange(String region, String min, String max, String sign, String note, String source, String startStrategy, String endStrategy) throws IOException {
        this.region_ = region;
        this.source_ = source;
        try {
            this.min_ = Integer.parseInt(min);
            this.max_ = Integer.parseInt(max);
        }
        catch (NumberFormatException nfex) {
            throw new IOException();
        }
        Database db = Database.getDB();
        TimeAxisDefinition tad = db.getTimeAxisDefinition();
        if (!tad.spanIsOk(this.min_, this.max_)) {
            throw new IOException();
        }
        if (sign == null) {
            throw new IOException();
        }
        if ((sign = sign.trim()).equalsIgnoreCase("promote")) {
            this.sign_ = 0;
        } else if (sign.equalsIgnoreCase("repress")) {
            this.sign_ = 1;
        } else {
            throw new IOException();
        }
        try {
            this.startStrategy_ = RegionAndRange.calculateStrategy(startStrategy, true);
            this.endStrategy_ = RegionAndRange.calculateStrategy(endStrategy, false);
        }
        catch (IllegalArgumentException iae) {
            throw new IOException();
        }
        this.note_ = note;
    }

    public RegionAndRange(String region, int min, int max, int sign, String note, String source, int startStrategy, int endStrategy) {
        this.region_ = region;
        this.source_ = source;
        this.min_ = min;
        this.max_ = max;
        this.sign_ = sign;
        this.note_ = note;
        this.startStrategy_ = startStrategy;
        this.endStrategy_ = endStrategy;
    }

    public RegionAndRange(String region, int min, int max, int sign, String note, String source) {
        this(region, min, max, sign, note, source, 0, 0);
    }

    public String getRegion() {
        return this.region_;
    }

    public void setRegion(String region) {
        this.region_ = region;
    }

    public String getRestrictedSource() {
        return this.source_;
    }

    public void setRestrictedSource(String region) {
        this.source_ = region;
    }

    public int getMin() {
        return this.min_;
    }

    public int getMax() {
        return this.max_;
    }

    public boolean inconsistentStrategy() {
        return this.min_ == this.max_ ? this.startStrategy_ != this.endStrategy_ || this.startStrategy_ == 2 : this.max_ - this.min_ == 1 && this.startStrategy_ == 2 && this.endStrategy_ == 2;
    }

    public boolean isActive(int hour) {
        if (this.min_ < hour && this.max_ > hour) {
            return true;
        }
        if (this.min_ != hour && this.max_ != hour) {
            return false;
        }
        if (this.inconsistentStrategy()) {
            return true;
        }
        if (hour == this.min_) {
            return this.startStrategy_ == 0 || this.startStrategy_ == 1;
        }
        if (hour == this.max_) {
            return this.endStrategy_ == 0 || this.endStrategy_ == 1;
        }
        return false;
    }

    public void setMin(int min) {
        this.min_ = min;
    }

    public void setMax(int max) {
        this.max_ = max;
    }

    public int getSign() {
        return this.sign_;
    }

    public void setSign(int sign) {
        this.sign_ = sign;
    }

    public String getNote() {
        return this.note_;
    }

    public void setNote(String note) {
        this.note_ = note;
    }

    public int getStartStrategy() {
        return this.startStrategy_;
    }

    public int getEndStrategy() {
        return this.endStrategy_;
    }

    public void setStartStrategy(int startStrategy) {
        this.startStrategy_ = startStrategy;
    }

    public void setEndStrategy(int endStrategy) {
        this.endStrategy_ = endStrategy;
    }

    public void getInterestingTimes(Set interest) {
        interest.add(new Integer(this.min_));
        if (this.max_ != this.min_) {
            interest.add(new Integer(this.max_));
        }
    }

    public void getAllRegions(Set interest) {
        if (this.region_ != null) {
            interest.add(this.region_);
        }
        if (this.source_ != null) {
            interest.add(this.source_);
        }
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<range");
        if (this.region_ != null) {
            out.print(" region=\"");
            out.print(CharacterEntityMapper.mapEntities(this.region_, false));
            out.print("\"");
        }
        if (this.source_ != null) {
            out.print(" source=\"");
            out.print(CharacterEntityMapper.mapEntities(this.source_, false));
            out.print("\"");
        }
        out.print(" minTime=\"");
        out.print(this.min_);
        out.print("\" maxTime=\"");
        out.print(this.max_);
        out.print("\" sign=\"");
        switch (this.sign_) {
            case 0: {
                out.print("promote");
                break;
            }
            case 1: {
                out.print("repress");
            }
        }
        String invert = RegionAndRange.mapStrategy(this.startStrategy_);
        if (invert != null) {
            out.print("\" starttype=\"");
            out.print(invert);
        }
        if ((invert = RegionAndRange.mapStrategy(this.endStrategy_)) != null) {
            out.print("\" endtype=\"");
            out.print(invert);
        }
        if (this.note_ != null) {
            out.print("\" note=\"");
            out.print(CharacterEntityMapper.mapEntities(this.note_, false));
        }
        out.println("\" />");
    }

    public boolean signMatch(int linkageSign) {
        if (this.sign_ == 0) {
            return linkageSign == 1 || linkageSign == 0;
        }
        return linkageSign == -1;
    }

    public String toString() {
        return "RegionAndRange: region_ = " + this.region_ + " min = " + this.min_ + " max = " + this.max_ + " sign = " + this.sign_ + " note = " + this.note_ + " source = " + this.source_;
    }

    public static int calculateStrategy(String token, boolean isStart) {
        if (token == null) {
            return 0;
        }
        if (token.equals("onAtBoundary")) {
            return 1;
        }
        if (token.equals("offAtBoundary")) {
            return 2;
        }
        throw new IllegalArgumentException();
    }

    public static String mapStrategy(int val) {
        switch (val) {
            case 0: {
                return null;
            }
            case 1: {
                return "onAtBoundary";
            }
            case 2: {
                return "offAtBoundary";
            }
        }
        throw new IllegalArgumentException();
    }

    public static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("range");
        return retval;
    }

    public static RegionAndRange buildFromXML(String elemName, Attributes attrs) throws IOException {
        if (!elemName.equals("range")) {
            return null;
        }
        String region = null;
        String min = null;
        String max = null;
        String sign = null;
        String note = null;
        String source = null;
        String startStrategy = null;
        String endStrategy = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("region")) {
                    region = CharacterEntityMapper.unmapEntities(val, false);
                    continue;
                }
                if (key.equals("minTime")) {
                    min = val;
                    continue;
                }
                if (key.equals("maxTime")) {
                    max = val;
                    continue;
                }
                if (key.equals("sign")) {
                    sign = val;
                    continue;
                }
                if (key.equals("note")) {
                    note = CharacterEntityMapper.unmapEntities(val, false);
                    continue;
                }
                if (key.equals("source")) {
                    source = CharacterEntityMapper.unmapEntities(val, false);
                    continue;
                }
                if (key.equals("starttype")) {
                    startStrategy = val;
                    continue;
                }
                if (!key.equals("endtype")) continue;
                endStrategy = val;
            }
        }
        if (min == null || max == null || sign == null) {
            throw new IOException();
        }
        return new RegionAndRange(region, min, max, sign, note, source, startStrategy, endStrategy);
    }

    private void parseRange(String rangeInput) {
        Pattern mP = Pattern.compile("M[\\-\u2026].*");
        Pattern nP = Pattern.compile("\\d+.*");
        String[] result = rangeInput.split("\\s");
        if (result.length == 1) {
            this.parseTimes(result[0]);
        } else if (result.length == 2) {
            if (mP.matcher(result[0]).matches() || nP.matcher(result[0]).matches()) {
                this.parseTimes(result[0]);
                this.region_ = result[1];
            } else {
                this.parseTimes(result[1]);
                this.region_ = result[0];
            }
        } else {
            System.err.println("Result length is " + result.length + " " + result);
            throw new IllegalArgumentException();
        }
    }

    private void parseTimes(String timeInput) {
        Pattern dP = Pattern.compile("(.+)-(.+)");
        Matcher dPm = dP.matcher(timeInput);
        if (dPm.matches()) {
            this.min_ = this.parseTimeToken(dPm.group(1));
            this.max_ = this.parseTimeToken(dPm.group(2));
            return;
        }
        Pattern eP = Pattern.compile("([0-9hrM]+)(\\u2026?\\.*)");
        Matcher ePm = eP.matcher(timeInput);
        if (ePm.matches()) {
            this.min_ = this.parseTimeToken(ePm.group(1));
            this.max_ = ePm.group(2).trim().length() > 0 ? 30 : this.min_;
            return;
        }
        System.err.println(">" + timeInput + "<");
        throw new IllegalArgumentException();
    }

    private int parseTimeToken(String timeInput) {
        if (timeInput.equals("M")) {
            return 0;
        }
        Pattern p = Pattern.compile("([0-9]+)(hr?)?");
        Matcher pM = p.matcher(timeInput);
        if (pM.matches()) {
            try {
                return Integer.parseInt(pM.group(1));
            }
            catch (NumberFormatException nfex) {
                System.err.println(timeInput);
                throw new IllegalArgumentException();
            }
        }
        System.err.println(timeInput);
        throw new IllegalArgumentException();
    }

    private int parseColorToken(String colorInput) {
        if (colorInput.equals("FF0000")) {
            return 1;
        }
        if (colorInput.equals("00FF00")) {
            return 0;
        }
        System.err.println(colorInput);
        throw new IllegalArgumentException();
    }
}

