/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.timeCourse;

import java.util.Iterator;
import java.util.List;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.plugin.InternalNodeDataDisplayPlugIn;
import org.systemsbiology.biotapestry.plugin.PluginCallbackWorker;
import org.systemsbiology.biotapestry.timeCourse.TemporalInputRangeData;
import org.systemsbiology.biotapestry.util.ResourceManager;

public class TemporalInputDisplayPlugIn
implements InternalNodeDataDisplayPlugIn {
    public boolean isInternal() {
        return true;
    }

    public boolean requiresPerInstanceDisplay(String genomeID, String itemID) {
        return false;
    }

    public boolean haveCallbackWorker() {
        return false;
    }

    public PluginCallbackWorker getCallbackWorker(String genomeID, String nodeId) {
        return null;
    }

    public String getDataAsHTML(String genomeIDX, String nodeID) {
        StringBuffer buf = new StringBuffer();
        Database db = Database.getDB();
        TemporalInputRangeData trd = db.getTemporalInputRangeData();
        if (trd == null || !trd.haveData()) {
            return "";
        }
        nodeID = GenomeItemInstance.getBaseID(nodeID);
        ResourceManager rMan = ResourceManager.getManager();
        String desc = rMan.getString("dataWindow.temporalInputs");
        buf.append("<center><h1>");
        buf.append(desc);
        buf.append("</h1>\n");
        List dataKeys = trd.getTemporalInputRangeEntryKeysWithDefault(nodeID);
        boolean gotData = false;
        if (dataKeys != null) {
            Iterator dkit = dataKeys.iterator();
            while (dkit.hasNext()) {
                String key = (String)dkit.next();
                String tab = trd.getInputsTable(key, null);
                if (tab == null || tab.trim().equals("")) continue;
                gotData = true;
                buf.append("<p>");
                buf.append(tab);
                buf.append("</p>");
            }
        }
        if (!gotData) {
            buf.append(rMan.getString("dataWindow.noTemporalInputs"));
        }
        buf.append("</center>");
        return buf.toString();
    }
}

