/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.timeCourse;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.plugin.InternalLinkDataDisplayPlugIn;
import org.systemsbiology.biotapestry.plugin.PluginCallbackWorker;
import org.systemsbiology.biotapestry.timeCourse.TemporalInputRangeData;
import org.systemsbiology.biotapestry.util.ResourceManager;

public class TemporalInputLinkDisplayPlugIn
implements InternalLinkDataDisplayPlugIn {
    public boolean isInternal() {
        return true;
    }

    public boolean requiresPerInstanceDisplay(String genomeID, String itemID) {
        return false;
    }

    public boolean haveCallbackWorker() {
        return false;
    }

    public PluginCallbackWorker getCallbackWorker(String genomeID, String itemId) {
        return null;
    }

    public String getDataAsHTML(String genomeID, String linkID) {
        StringBuffer buf = new StringBuffer();
        Database db = Database.getDB();
        Genome genome = db.getGenome(genomeID);
        Linkage link = genome.getLinkage(linkID);
        String targID = link.getTarget();
        String sourceID = link.getSource();
        String baseTargID = GenomeItemInstance.getBaseID(targID);
        String baseSourceID = GenomeItemInstance.getBaseID(sourceID);
        TemporalInputRangeData trd = db.getTemporalInputRangeData();
        if (trd == null || !trd.haveData()) {
            return "";
        }
        ResourceManager rMan = ResourceManager.getManager();
        buf.append("<center><h1>");
        buf.append(rMan.getString("dataWindow.temporalInputsForLink"));
        buf.append("</h1>\n");
        List targDataKeys = trd.getTemporalInputRangeEntryKeysWithDefault(baseTargID);
        HashSet srcDataKeys = new HashSet(trd.getTemporalInputRangeSourceKeysWithDefault(baseSourceID));
        boolean gotData = false;
        if (targDataKeys != null) {
            Iterator dkit = targDataKeys.iterator();
            while (dkit.hasNext()) {
                String key = (String)dkit.next();
                String tab = trd.getInputsTable(key, srcDataKeys);
                if (tab == null || tab.trim().equals("")) continue;
                gotData = true;
                buf.append("<p>");
                buf.append(tab);
                buf.append("</p>");
            }
        }
        if (!gotData) {
            buf.append(rMan.getString("dataWindow.noTemporalInputs"));
        }
        buf.append("</center>");
        return buf.toString();
    }
}

