/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.timeCourse;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.DBGenome;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.timeCourse.GroupUsage;
import org.systemsbiology.biotapestry.timeCourse.InputTimeRange;
import org.systemsbiology.biotapestry.timeCourse.RegionAndRange;
import org.systemsbiology.biotapestry.timeCourse.TemporalInputChange;
import org.systemsbiology.biotapestry.timeCourse.TemporalRange;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.Indenter;
import org.xml.sax.Attributes;

public class TemporalInputRangeData {
    private ArrayList entries_ = new ArrayList();
    private HashMap trEntryMap_ = new HashMap();
    private HashMap trSourceMap_ = new HashMap();
    private HashMap groupMap_ = new HashMap();

    public boolean haveData() {
        if (!this.entries_.isEmpty()) {
            return true;
        }
        if (!this.trEntryMap_.isEmpty()) {
            return true;
        }
        if (!this.trSourceMap_.isEmpty()) {
            return true;
        }
        return !this.groupMap_.isEmpty();
    }

    public boolean haveCustomMapForNode(String nodeID) {
        return this.haveCustomSourceMapForNode(nodeID) || this.haveCustomEntryMapForNode(nodeID);
    }

    public boolean haveCustomMapForRegion(String groupId) {
        if (!this.haveData()) {
            return false;
        }
        List mapped = (List)this.groupMap_.get(groupId);
        return mapped != null && mapped.size() != 0;
    }

    public boolean haveCustomEntryMapForNode(String nodeID) {
        if (!this.haveData()) {
            return false;
        }
        List mapped = (List)this.trEntryMap_.get(nodeID);
        return mapped != null && mapped.size() != 0;
    }

    public boolean haveCustomSourceMapForNode(String nodeID) {
        if (!this.haveData()) {
            return false;
        }
        List mapped = (List)this.trSourceMap_.get(nodeID);
        return mapped != null && mapped.size() != 0;
    }

    public boolean haveDataForNode(String nodeID) {
        if (!this.haveData()) {
            return false;
        }
        List mapped = this.getTemporalInputRangeEntryKeysWithDefault(nodeID);
        if (mapped == null) {
            return false;
        }
        Iterator mit = mapped.iterator();
        while (mit.hasNext()) {
            String name = (String)mit.next();
            if (this.getRange(name) == null) continue;
            return true;
        }
        return false;
    }

    public boolean haveDataForNodeOrName(String nodeID, String nodeName) {
        if (!this.haveData()) {
            return false;
        }
        List mapped = this.getTemporalInputRangeEntryKeysWithDefaultGivenName(nodeID, nodeName);
        if (mapped == null) {
            return false;
        }
        Iterator mit = mapped.iterator();
        while (mit.hasNext()) {
            String name = (String)mit.next();
            if (this.getRange(name) == null) continue;
            return true;
        }
        return false;
    }

    public Set getTemporalInputEntryKeyInverse(String name) {
        Set nodes;
        name = DataUtil.normKey(name);
        HashSet<String> retval = new HashSet<String>();
        DBGenome genome = (DBGenome)Database.getDB().getGenome();
        Node node = genome.getGeneWithName(name);
        if (node != null && !this.haveCustomEntryMapForNode(node.getID())) {
            retval.add(node.getID());
        }
        if (!(nodes = genome.getNodesWithName(name)).isEmpty()) {
            Iterator sit = nodes.iterator();
            while (sit.hasNext()) {
                node = (Node)sit.next();
                if (this.haveCustomEntryMapForNode(node.getID())) continue;
                retval.add(node.getID());
            }
        }
        Iterator kit = this.trEntryMap_.keySet().iterator();
        while (kit.hasNext()) {
            String key = (String)kit.next();
            List targs = (List)this.trEntryMap_.get(key);
            Iterator trit = targs.iterator();
            while (trit.hasNext()) {
                String testName = (String)trit.next();
                if (!DataUtil.keysEqual(testName, name)) continue;
                retval.add(key);
            }
        }
        return retval;
    }

    public Set getTemporalInputSourceKeyInverse(String name) {
        Set nodes;
        name = DataUtil.normKey(name);
        HashSet<String> retval = new HashSet<String>();
        if (name.equals("")) {
            return retval;
        }
        DBGenome genome = (DBGenome)Database.getDB().getGenome();
        Node node = genome.getGeneWithName(name);
        if (node != null && !this.haveCustomSourceMapForNode(node.getID())) {
            retval.add(node.getID());
        }
        if (!(nodes = genome.getNodesWithName(name)).isEmpty()) {
            Iterator sit = nodes.iterator();
            while (sit.hasNext()) {
                node = (Node)sit.next();
                if (this.haveCustomSourceMapForNode(node.getID())) continue;
                retval.add(node.getID());
            }
        }
        Iterator kit = this.trSourceMap_.keySet().iterator();
        while (kit.hasNext()) {
            String key = (String)kit.next();
            List targs = (List)this.trSourceMap_.get(key);
            Iterator trit = targs.iterator();
            while (trit.hasNext()) {
                String testName = (String)trit.next();
                if (!DataUtil.keysEqual(testName, name)) continue;
                retval.add(key);
            }
        }
        return retval;
    }

    public Set getNonTargetSources() {
        TemporalRange trg;
        int i;
        HashSet<String> retval = new HashSet<String>();
        HashSet<String> targetNames = new HashSet<String>();
        int size = this.entries_.size();
        for (i = 0; i < size; ++i) {
            trg = (TemporalRange)this.entries_.get(i);
            targetNames.add(DataUtil.normKey(trg.getName()));
        }
        for (i = 0; i < size; ++i) {
            trg = (TemporalRange)this.entries_.get(i);
            Iterator itrs = trg.getTimeRanges();
            while (itrs.hasNext()) {
                InputTimeRange itr = (InputTimeRange)itrs.next();
                String itrName = itr.getName();
                if (DataUtil.containsKey(targetNames, itrName)) continue;
                retval.add(itrName);
            }
        }
        return retval;
    }

    public Set getAllSources() {
        HashSet<String> retval = new HashSet<String>();
        int size = this.entries_.size();
        for (int i = 0; i < size; ++i) {
            TemporalRange trg = (TemporalRange)this.entries_.get(i);
            Iterator itrs = trg.getTimeRanges();
            while (itrs.hasNext()) {
                InputTimeRange itr = (InputTimeRange)itrs.next();
                String itrName = itr.getName();
                if (DataUtil.containsKey(retval, itrName)) continue;
                retval.add(itrName);
            }
        }
        return retval;
    }

    public boolean isPerturbationSourceName(String name) {
        int size = this.entries_.size();
        for (int i = 0; i < size; ++i) {
            TemporalRange trg = (TemporalRange)this.entries_.get(i);
            Iterator itrs = trg.getTimeRanges();
            while (itrs.hasNext()) {
                InputTimeRange itr = (InputTimeRange)itrs.next();
                String itrName = itr.getName();
                if (!DataUtil.keysEqual(name, itrName)) continue;
                return true;
            }
        }
        return false;
    }

    public void changeUndo(TemporalInputChange undo) {
        if (undo.entryMapListOrig != null || undo.entryMapListNew != null) {
            this.entryMapChangeUndo(undo);
        } else if (undo.sourceMapListOrig != null || undo.sourceMapListNew != null) {
            this.sourceMapChangeUndo(undo);
        } else if (undo.groupMapListOrig != null || undo.groupMapListNew != null) {
            this.groupMapChangeUndo(undo);
        } else if (undo.eOrig != null || undo.eNew != null) {
            this.entryChangeUndo(undo);
        }
    }

    public void changeRedo(TemporalInputChange undo) {
        if (undo.entryMapListOrig != null || undo.entryMapListNew != null) {
            this.entryMapChangeRedo(undo);
        } else if (undo.sourceMapListOrig != null || undo.sourceMapListNew != null) {
            this.sourceMapChangeRedo(undo);
        } else if (undo.groupMapListOrig != null || undo.groupMapListNew != null) {
            this.groupMapChangeRedo(undo);
        } else if (undo.eOrig != null || undo.eNew != null) {
            this.entryChangeRedo(undo);
        }
    }

    public TemporalInputChange startRangeUndoTransaction(String targetName) {
        TemporalInputChange retval = new TemporalInputChange();
        int size = this.entries_.size();
        for (int i = 0; i < size; ++i) {
            TemporalRange trg = (TemporalRange)this.entries_.get(i);
            String name = trg.getName();
            if (!DataUtil.keysEqual(name, targetName)) continue;
            retval.eOrig = new TemporalRange(trg);
            retval.entryPos = i;
            return retval;
        }
        throw new IllegalArgumentException();
    }

    public TemporalInputChange finishRangeUndoTransaction(TemporalInputChange change) {
        TemporalRange trg = (TemporalRange)this.entries_.get(change.entryPos);
        change.eNew = new TemporalRange(trg);
        return change;
    }

    public boolean isEmpty() {
        return this.entries_.isEmpty();
    }

    public TemporalInputChange addEntry(TemporalRange range) {
        TemporalInputChange retval = new TemporalInputChange();
        retval.entryPos = this.entries_.size();
        this.entries_.add(range);
        retval.eNew = new TemporalRange(range);
        retval.eOrig = null;
        return retval;
    }

    public Iterator getEntries() {
        return this.entries_.iterator();
    }

    public TemporalRange getEntry(int n) {
        return (TemporalRange)this.entries_.get(n);
    }

    public TemporalInputChange[] dropMapsTo(String entryID) {
        ArrayList<TemporalInputChange> retvalList = new ArrayList<TemporalInputChange>();
        Iterator mit = new HashSet(this.trEntryMap_.keySet()).iterator();
        block0: while (mit.hasNext()) {
            String mapKey = (String)mit.next();
            List targList = (List)this.trEntryMap_.get(mapKey);
            int tlSize = targList.size();
            for (int i = 0; i < tlSize; ++i) {
                String targ = (String)targList.get(i);
                if (!DataUtil.keysEqual(targ, entryID)) continue;
                TemporalInputChange tic = new TemporalInputChange();
                tic.mapKey = mapKey;
                tic.entryMapListOrig = new ArrayList(targList);
                targList.remove(i);
                if (targList.isEmpty()) {
                    tic.entryMapListNew = null;
                    this.trEntryMap_.remove(mapKey);
                } else {
                    tic.entryMapListNew = new ArrayList(targList);
                }
                retvalList.add(tic);
                continue block0;
            }
        }
        return retvalList.toArray(new TemporalInputChange[retvalList.size()]);
    }

    public TemporalInputChange[] changeDataMapsToName(String oldName, String newName) {
        ArrayList<TemporalInputChange> retvalList = new ArrayList<TemporalInputChange>();
        Iterator tmit = this.trEntryMap_.keySet().iterator();
        while (tmit.hasNext()) {
            String mkey = (String)tmit.next();
            List keys = (List)this.trEntryMap_.get(mkey);
            if (!DataUtil.containsKey(keys, oldName)) continue;
            TemporalInputChange retval = new TemporalInputChange();
            retval.mapKey = mkey;
            retval.entryMapListOrig = (ArrayList)((ArrayList)keys).clone();
            keys.remove(oldName);
            keys.add(newName);
            retval.entryMapListNew = (ArrayList)((ArrayList)keys).clone();
            retvalList.add(retval);
        }
        return retvalList.toArray(new TemporalInputChange[retvalList.size()]);
    }

    public TemporalInputChange[] changeName(String oldName, String newName) {
        TemporalInputChange retval;
        List keys;
        String mkey;
        ArrayList<TemporalInputChange> retvalList = new ArrayList<TemporalInputChange>();
        if (!DataUtil.keysEqual(oldName, newName) && (this.getRange(newName) != null || this.isPerturbationSourceName(newName))) {
            throw new IllegalArgumentException();
        }
        boolean rowFailure = false;
        int size = this.entries_.size();
        for (int i = 0; i < size; ++i) {
            TemporalRange tr = (TemporalRange)this.entries_.get(i);
            Iterator perts = tr.getTimeRanges();
            while (perts.hasNext()) {
                InputTimeRange itr = (InputTimeRange)perts.next();
                String pertName = itr.getName();
                if (!DataUtil.keysEqual(oldName, pertName)) continue;
                TemporalInputChange tic = this.startRangeUndoTransaction(tr.getName());
                itr.setName(newName);
                tic = this.finishRangeUndoTransaction(tic);
                retvalList.add(tic);
            }
        }
        TemporalRange range = this.getRange(oldName);
        if (range != null) {
            TemporalInputChange tic = this.startRangeUndoTransaction(oldName);
            range.setName(newName);
            tic = this.finishRangeUndoTransaction(tic);
            retvalList.add(tic);
        }
        Iterator dmit = this.trEntryMap_.keySet().iterator();
        while (dmit.hasNext()) {
            mkey = (String)dmit.next();
            keys = (List)this.trEntryMap_.get(mkey);
            if (!DataUtil.containsKey(keys, oldName)) continue;
            retval = new TemporalInputChange();
            retval.mapKey = mkey;
            retval.entryMapListOrig = (ArrayList)((ArrayList)keys).clone();
            keys.remove(oldName);
            keys.add(newName);
            retval.entryMapListNew = (ArrayList)((ArrayList)keys).clone();
            retvalList.add(retval);
        }
        dmit = this.trSourceMap_.keySet().iterator();
        while (dmit.hasNext()) {
            mkey = (String)dmit.next();
            keys = (List)this.trSourceMap_.get(mkey);
            if (!DataUtil.containsKey(keys, oldName)) continue;
            retval = new TemporalInputChange();
            retval.mapKey = mkey;
            retval.sourceMapListOrig = (ArrayList)((ArrayList)keys).clone();
            keys.remove(oldName);
            keys.add(newName);
            retval.sourceMapListNew = (ArrayList)((ArrayList)keys).clone();
            retvalList.add(retval);
        }
        return retvalList.toArray(new TemporalInputChange[retvalList.size()]);
    }

    public TemporalInputChange[] changeRegionName(String oldName, String newName) {
        ArrayList<TemporalInputChange> retvalList = new ArrayList<TemporalInputChange>();
        int size = this.entries_.size();
        for (int i = 0; i < size; ++i) {
            TemporalRange tr = (TemporalRange)this.entries_.get(i);
            Iterator perts = tr.getTimeRanges();
            while (perts.hasNext()) {
                InputTimeRange itr = (InputTimeRange)perts.next();
                Iterator rit = itr.getRanges();
                while (rit.hasNext()) {
                    boolean sourceMatch;
                    RegionAndRange rar = (RegionAndRange)rit.next();
                    boolean regionMatch = rar.getRegion() != null && DataUtil.keysEqual(rar.getRegion(), oldName);
                    boolean bl = sourceMatch = rar.getRestrictedSource() != null && DataUtil.keysEqual(rar.getRestrictedSource(), oldName);
                    if (!regionMatch && !sourceMatch) continue;
                    TemporalInputChange tic = this.startRangeUndoTransaction(tr.getName());
                    if (regionMatch) {
                        rar.setRegion(newName);
                    }
                    if (sourceMatch) {
                        rar.setRestrictedSource(newName);
                    }
                    tic = this.finishRangeUndoTransaction(tic);
                    retvalList.add(tic);
                }
            }
        }
        Iterator dmit = this.groupMap_.keySet().iterator();
        while (dmit.hasNext()) {
            String mkey = (String)dmit.next();
            List currentMap = (List)this.groupMap_.get(mkey);
            ArrayList<GroupUsage> newMap = new ArrayList<GroupUsage>();
            boolean haveChange = false;
            int csize = currentMap.size();
            for (int i = 0; i < csize; ++i) {
                GroupUsage gu = (GroupUsage)currentMap.get(i);
                GroupUsage newgu = new GroupUsage(gu);
                if (DataUtil.keysEqual(gu.mappedGroup, oldName)) {
                    haveChange = true;
                    newgu.mappedGroup = newName;
                }
                newMap.add(newgu);
            }
            if (!haveChange) continue;
            TemporalInputChange tic = new TemporalInputChange();
            retvalList.add(tic);
            tic.mapKey = mkey;
            tic.groupMapListOrig = this.deepCopyGroupMap(currentMap);
            this.groupMap_.put(mkey, newMap);
            tic.groupMapListNew = this.deepCopyGroupMap(newMap);
        }
        return retvalList.toArray(new TemporalInputChange[retvalList.size()]);
    }

    public Set getRegions() {
        HashSet<String> retval = new HashSet<String>();
        int size = this.entries_.size();
        for (int i = 0; i < size; ++i) {
            TemporalRange tr = (TemporalRange)this.entries_.get(i);
            Iterator perts = tr.getTimeRanges();
            while (perts.hasNext()) {
                InputTimeRange itr = (InputTimeRange)perts.next();
                Iterator rit = itr.getRanges();
                while (rit.hasNext()) {
                    RegionAndRange rar = (RegionAndRange)rit.next();
                    String region = rar.getRegion();
                    if (region == null) continue;
                    retval.add(region);
                }
            }
        }
        return retval;
    }

    public TemporalInputChange dropEntry(int n) {
        TemporalInputChange retval = new TemporalInputChange();
        TemporalRange entry = (TemporalRange)this.entries_.get(n);
        retval.eOrig = new TemporalRange(entry);
        retval.eNew = null;
        retval.entryPos = n;
        this.entries_.remove(n);
        return retval;
    }

    public TemporalInputChange dropEntry(String entryID) {
        int size = this.entries_.size();
        for (int i = 0; i < size; ++i) {
            TemporalRange entry = (TemporalRange)this.entries_.get(i);
            if (!entry.getName().equals(entryID)) continue;
            TemporalInputChange retval = new TemporalInputChange();
            retval.eOrig = new TemporalRange(entry);
            retval.eNew = null;
            retval.entryPos = i;
            this.entries_.remove(i);
            return retval;
        }
        return null;
    }

    private void entryChangeUndo(TemporalInputChange undo) {
        if (undo.eOrig != null && undo.eNew != null) {
            this.entries_.set(undo.entryPos, undo.eOrig);
        } else if (undo.eOrig == null) {
            this.entries_.remove(undo.entryPos);
        } else {
            this.entries_.add(undo.entryPos, undo.eOrig);
        }
    }

    private void entryChangeRedo(TemporalInputChange undo) {
        if (undo.eOrig != null && undo.eNew != null) {
            this.entries_.set(undo.entryPos, undo.eNew);
        } else if (undo.eNew == null) {
            this.entries_.remove(undo.entryPos);
        } else {
            this.entries_.add(undo.entryPos, undo.eNew);
        }
    }

    public TemporalRange getRange(String targetName) {
        targetName = targetName.replaceAll(" ", "");
        Iterator trgit = this.entries_.iterator();
        while (trgit.hasNext()) {
            TemporalRange trg = (TemporalRange)trgit.next();
            String name = trg.getName().replaceAll(" ", "");
            if (!name.equalsIgnoreCase(targetName)) continue;
            return trg;
        }
        return null;
    }

    public Set getInterestingTimes() {
        HashSet retval = new HashSet();
        Iterator eit = this.getEntries();
        while (eit.hasNext()) {
            TemporalRange tr = (TemporalRange)eit.next();
            tr.getInterestingTimes(retval);
        }
        return retval;
    }

    public Set getHours() {
        HashSet retval = new HashSet();
        return retval;
    }

    public TemporalInputChange[] addTemporalInputRangeMaps(String key, List entries, List sources) {
        ArrayList orig;
        TemporalInputChange retval;
        ArrayList<TemporalInputChange> retvalList = new ArrayList<TemporalInputChange>();
        if (entries != null && entries.size() > 0) {
            retval = new TemporalInputChange();
            retval.mapKey = key;
            retval.entryMapListNew = new ArrayList(entries);
            orig = (ArrayList)this.trEntryMap_.get(key);
            retval.entryMapListOrig = orig == null ? null : new ArrayList(orig);
            this.trEntryMap_.put(key, entries);
            retvalList.add(retval);
        }
        if (sources != null && sources.size() > 0) {
            retval = new TemporalInputChange();
            retval.mapKey = key;
            retval.sourceMapListNew = new ArrayList(sources);
            orig = (ArrayList)this.trSourceMap_.get(key);
            retval.sourceMapListOrig = orig == null ? null : new ArrayList(orig);
            this.trSourceMap_.put(key, sources);
            retvalList.add(retval);
        }
        return retvalList.toArray(new TemporalInputChange[retvalList.size()]);
    }

    public void addCombinedTemporalInputRangeMaps(String key, List mapSets) {
        ArrayList<String> sourceList = new ArrayList<String>();
        ArrayList<String> entryList = new ArrayList<String>();
        Iterator mit = mapSets.iterator();
        while (mit.hasNext()) {
            TirMapResult res = (TirMapResult)mit.next();
            if (res.type == 0) {
                entryList.add(res.name);
                continue;
            }
            sourceList.add(res.name);
        }
        if (entryList.size() > 0) {
            this.trEntryMap_.put(key, entryList);
        }
        if (sourceList.size() > 0) {
            this.trSourceMap_.put(key, sourceList);
        }
    }

    public List getTemporalInputRangeEntryKeysWithDefault(String nodeId) {
        ArrayList<String> retval = (ArrayList<String>)this.trEntryMap_.get(nodeId);
        if (retval == null || retval.size() == 0) {
            retval = new ArrayList<String>();
            Node node = Database.getDB().getGenome().getNode(nodeId);
            if (node == null) {
                throw new IllegalStateException();
            }
            String nodeName = node.getRootName();
            if (nodeName == null || nodeName.trim().equals("")) {
                return retval;
            }
            retval.add(nodeName);
        }
        return retval;
    }

    public List getTemporalInputRangeEntryKeysWithDefaultGivenName(String nodeId, String nodeName) {
        ArrayList<String> retval = (ArrayList<String>)this.trEntryMap_.get(nodeId);
        if (retval == null || retval.size() == 0) {
            retval = new ArrayList<String>();
            if (nodeName == null || nodeName.trim().equals("")) {
                return retval;
            }
            retval.add(nodeName);
        }
        return retval;
    }

    public List getCustomTemporalInputRangeEntryKeys(String nodeId) {
        return (List)this.trEntryMap_.get(nodeId);
    }

    public List getTemporalInputRangeSourceKeysWithDefault(String nodeId) {
        ArrayList<String> retval = (ArrayList<String>)this.trSourceMap_.get(nodeId);
        if (retval == null || retval.size() == 0) {
            retval = new ArrayList<String>();
            Node node = Database.getDB().getGenome().getNode(nodeId);
            if (node == null) {
                throw new IllegalStateException();
            }
            String nodeName = node.getRootName();
            if (nodeName == null || nodeName.trim().equals("")) {
                return retval;
            }
            retval.add(nodeName);
        }
        return retval;
    }

    public List getTemporalInputRangeSourceKeysWithDefaultGivenName(String nodeId, String nodeName) {
        ArrayList<String> retval = (ArrayList<String>)this.trSourceMap_.get(nodeId);
        if (retval == null || retval.size() == 0) {
            retval = new ArrayList<String>();
            if (nodeName == null || nodeName.trim().equals("")) {
                return retval;
            }
            retval.add(nodeName);
        }
        return retval;
    }

    public List getCustomTemporalInputRangeSourceKeys(String nodeId) {
        return (List)this.trSourceMap_.get(nodeId);
    }

    public TemporalInputChange dropDataEntryKeys(String geneId) {
        if (this.trEntryMap_.get(geneId) == null) {
            return null;
        }
        TemporalInputChange retval = new TemporalInputChange();
        retval.mapKey = geneId;
        retval.entryMapListNew = null;
        retval.entryMapListOrig = (List)this.trEntryMap_.remove(geneId);
        return retval;
    }

    public TemporalInputChange dropDataSourceKeys(String geneId) {
        if (this.trSourceMap_.get(geneId) == null) {
            return null;
        }
        TemporalInputChange retval = new TemporalInputChange();
        retval.mapKey = geneId;
        retval.sourceMapListNew = null;
        retval.sourceMapListOrig = (List)this.trSourceMap_.remove(geneId);
        return retval;
    }

    private void sourceMapChangeUndo(TemporalInputChange undo) {
        if (undo.sourceMapListOrig != null && undo.sourceMapListNew != null) {
            this.trSourceMap_.put(undo.mapKey, undo.sourceMapListOrig);
        } else if (undo.sourceMapListOrig == null) {
            this.trSourceMap_.remove(undo.mapKey);
        } else {
            this.trSourceMap_.put(undo.mapKey, undo.sourceMapListOrig);
        }
    }

    private void sourceMapChangeRedo(TemporalInputChange undo) {
        if (undo.sourceMapListOrig != null && undo.sourceMapListNew != null) {
            this.trSourceMap_.put(undo.mapKey, undo.sourceMapListNew);
        } else if (undo.sourceMapListNew == null) {
            this.trSourceMap_.remove(undo.mapKey);
        } else {
            this.trSourceMap_.put(undo.mapKey, undo.sourceMapListNew);
        }
    }

    private void entryMapChangeUndo(TemporalInputChange undo) {
        if (undo.entryMapListOrig != null && undo.entryMapListNew != null) {
            this.trEntryMap_.put(undo.mapKey, undo.entryMapListOrig);
        } else if (undo.entryMapListOrig == null) {
            this.trEntryMap_.remove(undo.mapKey);
        } else {
            this.trEntryMap_.put(undo.mapKey, undo.entryMapListOrig);
        }
    }

    private void entryMapChangeRedo(TemporalInputChange undo) {
        if (undo.entryMapListOrig != null && undo.entryMapListNew != null) {
            this.trEntryMap_.put(undo.mapKey, undo.entryMapListNew);
        } else if (undo.entryMapListNew == null) {
            this.trEntryMap_.remove(undo.mapKey);
        } else {
            this.trEntryMap_.put(undo.mapKey, undo.entryMapListNew);
        }
    }

    public TemporalInputChange setTemporalRangeGroupMap(String key, List mapSets) {
        TemporalInputChange retval = new TemporalInputChange();
        retval.mapKey = key;
        retval.groupMapListNew = this.deepCopyGroupMap(mapSets);
        retval.groupMapListOrig = this.deepCopyGroupMap((List)this.groupMap_.get(key));
        this.groupMap_.put(key, mapSets);
        return retval;
    }

    public TemporalInputChange copyTemporalRangeGroupMapForDuplicateGroup(String oldKey, String newKey, Map modelMap) {
        List oldMapList = (List)this.groupMap_.get(oldKey);
        if (oldMapList == null) {
            return null;
        }
        TemporalInputChange retval = new TemporalInputChange();
        retval.mapKey = newKey;
        retval.groupMapListNew = this.deepCopyGroupMapMappingUsage(oldMapList, modelMap, oldKey.equals(newKey));
        retval.groupMapListOrig = null;
        this.groupMap_.put(newKey, this.deepCopyGroupMap(retval.groupMapListNew));
        return retval;
    }

    public List getTemporalRangeGroupKeysWithDefault(String groupId, String groupName) {
        ArrayList<GroupUsage> retval = (ArrayList<GroupUsage>)this.groupMap_.get(groupId);
        if (retval == null || retval.size() == 0) {
            retval = new ArrayList<GroupUsage>();
            if (groupName == null || groupName.trim().equals("")) {
                return retval;
            }
            retval.add(new GroupUsage(groupName.toUpperCase().replaceAll(" ", ""), null));
        }
        return retval;
    }

    public List getCustomTemporalRangeGroupKeys(String groupId) {
        return (List)this.groupMap_.get(groupId);
    }

    public TemporalInputChange dropGroupMap(String groupId) {
        if (this.groupMap_.get(groupId) == null) {
            return null;
        }
        TemporalInputChange retval = new TemporalInputChange();
        retval.mapKey = groupId;
        retval.groupMapListNew = null;
        retval.groupMapListOrig = this.deepCopyGroupMap((List)this.groupMap_.remove(groupId));
        return retval;
    }

    public Iterator getGroupMapKeys() {
        return this.groupMap_.keySet().iterator();
    }

    public TemporalInputChange[] dropGroupMapsForProxy(String proxyId) {
        ArrayList<TemporalInputChange> retvalList = new ArrayList<TemporalInputChange>();
        Iterator gmit = new HashSet(this.groupMap_.keySet()).iterator();
        while (gmit.hasNext()) {
            String key = (String)gmit.next();
            List currentMap = (List)this.groupMap_.get(key);
            int mSize = currentMap.size();
            ArrayList<GroupUsage> newMap = new ArrayList<GroupUsage>();
            for (int i = 0; i < mSize; ++i) {
                GroupUsage gu = (GroupUsage)currentMap.get(i);
                if (gu.usage != null && gu.usage.equals(proxyId)) continue;
                newMap.add(gu);
            }
            if (newMap.size() >= mSize) continue;
            TemporalInputChange tic = new TemporalInputChange();
            retvalList.add(tic);
            tic.mapKey = key;
            tic.groupMapListOrig = this.deepCopyGroupMap(currentMap);
            if (newMap.size() > 0) {
                this.groupMap_.put(key, newMap);
                tic.groupMapListNew = this.deepCopyGroupMap(newMap);
                continue;
            }
            this.groupMap_.remove(key);
            tic.groupMapListNew = null;
        }
        return retvalList.toArray(new TemporalInputChange[retvalList.size()]);
    }

    private List deepCopyGroupMap(List oldMap) {
        if (oldMap == null) {
            return null;
        }
        ArrayList<Object> retval = new ArrayList<Object>();
        int size = oldMap.size();
        for (int i = 0; i < size; ++i) {
            retval.add(((GroupUsage)oldMap.get(i)).clone());
        }
        return retval;
    }

    private List deepCopyGroupMapMappingUsage(List oldMap, Map modelMaps, boolean append) {
        if (oldMap == null) {
            return null;
        }
        ArrayList<GroupUsage> retval = new ArrayList<GroupUsage>();
        int size = oldMap.size();
        for (int i = 0; i < size; ++i) {
            GroupUsage copied = (GroupUsage)((GroupUsage)oldMap.get(i)).clone();
            String modelID = (String)modelMaps.get(copied.usage);
            if (modelID != null) {
                if (append) {
                    retval.add(copied);
                    copied = (GroupUsage)copied.clone();
                }
                copied.usage = modelID;
            }
            retval.add(copied);
        }
        return retval;
    }

    private void groupMapChangeUndo(TemporalInputChange undo) {
        if (undo.groupMapListOrig != null && undo.groupMapListNew != null) {
            this.groupMap_.put(undo.mapKey, undo.groupMapListOrig);
        } else if (undo.groupMapListOrig == null) {
            this.groupMap_.remove(undo.mapKey);
        } else {
            this.groupMap_.put(undo.mapKey, undo.groupMapListOrig);
        }
    }

    private void groupMapChangeRedo(TemporalInputChange undo) {
        if (undo.groupMapListOrig != null && undo.groupMapListNew != null) {
            this.groupMap_.put(undo.mapKey, undo.groupMapListNew);
        } else if (undo.groupMapListNew == null) {
            this.groupMap_.remove(undo.mapKey);
        } else {
            this.groupMap_.put(undo.mapKey, undo.groupMapListNew);
        }
    }

    public Set getAllRegions() {
        TreeSet<String> retval = new TreeSet<String>();
        Iterator eit = this.getEntries();
        while (eit.hasNext()) {
            TemporalRange tr = (TemporalRange)eit.next();
            tr.getAllRegions(retval);
        }
        Iterator gmit = this.groupMap_.values().iterator();
        while (gmit.hasNext()) {
            ArrayList groupsUsed = (ArrayList)gmit.next();
            Iterator guit = groupsUsed.iterator();
            while (guit.hasNext()) {
                GroupUsage groupUse = (GroupUsage)guit.next();
                retval.add(groupUse.mappedGroup);
            }
        }
        return retval;
    }

    public Set getAllIdentifiers() {
        List idsUsed;
        TreeSet<String> retval = new TreeSet<String>();
        Iterator eit = this.getEntries();
        while (eit.hasNext()) {
            TemporalRange tr = (TemporalRange)eit.next();
            retval.add(tr.getName());
            Iterator pit = tr.getTimeRanges();
            while (pit.hasNext()) {
                InputTimeRange itr = (InputTimeRange)pit.next();
                retval.add(itr.getName());
            }
        }
        Iterator tmit = this.trEntryMap_.values().iterator();
        while (tmit.hasNext()) {
            idsUsed = (List)tmit.next();
            retval.addAll(idsUsed);
        }
        tmit = this.trSourceMap_.values().iterator();
        while (tmit.hasNext()) {
            idsUsed = (List)tmit.next();
            retval.addAll(idsUsed);
        }
        return retval;
    }

    public boolean nameIsUnique(String targName) {
        Iterator eit = this.getEntries();
        while (eit.hasNext()) {
            TemporalRange tr = (TemporalRange)eit.next();
            if (!DataUtil.keysEqual(tr.getName(), targName)) continue;
            return false;
        }
        return true;
    }

    public boolean nameAppearsZeroOrOne(String targName) {
        int hitCount = 0;
        Iterator eit = this.getEntries();
        while (eit.hasNext()) {
            TemporalRange tr = (TemporalRange)eit.next();
            if (!DataUtil.keysEqual(tr.getName(), targName) || ++hitCount <= 1) continue;
            return false;
        }
        return true;
    }

    public boolean nameAppearsOnce(String targName) {
        int hitCount = 0;
        Iterator eit = this.getEntries();
        while (eit.hasNext()) {
            TemporalRange tr = (TemporalRange)eit.next();
            if (!DataUtil.keysEqual(tr.getName(), targName) || ++hitCount <= 1) continue;
            return false;
        }
        return hitCount != 0;
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.println("<TemporalInputRangeData>");
        if (this.entries_.size() > 0) {
            Iterator eit = this.getEntries();
            ind.up();
            while (eit.hasNext()) {
                TemporalRange tr = (TemporalRange)eit.next();
                tr.writeXML(out, ind);
            }
            ind.down();
        }
        if (this.trEntryMap_.size() > 0 || this.trSourceMap_.size() > 0) {
            this.writeTrMap(out, ind);
        }
        if (this.groupMap_.size() > 0) {
            this.writeGroupMap(out, ind);
        }
        ind.indent();
        out.println("</TemporalInputRangeData>");
    }

    public String getInputsTable(String targetName, Set srcNames) {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        Iterator trit = this.entries_.iterator();
        while (trit.hasNext()) {
            TemporalRange tr = (TemporalRange)trit.next();
            String name = tr.getName();
            if (!DataUtil.keysEqual(name, targetName) || tr.isInternalOnly()) continue;
            tr.getInputsTable(out, srcNames);
        }
        return sw.toString();
    }

    public String toString() {
        return "TemporalInputRangeData:  entries = " + this.entries_;
    }

    public static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("TemporalInputRangeData");
        return retval;
    }

    public static TemporalInputRangeData buildFromXML(String elemName, Attributes attrs) throws IOException {
        if (!elemName.equals("TemporalInputRangeData")) {
            return null;
        }
        return new TemporalInputRangeData();
    }

    public static String extractTrMapKey(String elemName, Attributes attrs) throws IOException {
        return AttributeExtractor.extractAttribute(elemName, attrs, "trMap", "key", true);
    }

    public static TirMapResult extractUseTr(String elemName, Attributes attrs) throws IOException {
        String name = AttributeExtractor.extractAttribute(elemName, attrs, "useTr", "name", true);
        String type = AttributeExtractor.extractAttribute(elemName, attrs, "useTr", "type", true);
        int mapType = type.equals("entry") ? 0 : 1;
        return new TirMapResult(name, mapType);
    }

    public static String extractGroupMapKey(String elemName, Attributes attrs) throws IOException {
        return AttributeExtractor.extractAttribute(elemName, attrs, "trGroupMap", "key", true);
    }

    public static GroupUsage extractUseGroup(String elemName, Attributes attrs) throws IOException {
        String mappedGroup = AttributeExtractor.extractAttribute(elemName, attrs, "trUseGroup", "name", true);
        String usage = AttributeExtractor.extractAttribute(elemName, attrs, "trUseGroup", "useFor", false);
        return new GroupUsage(mappedGroup, usage);
    }

    public static String trMapKeyword() {
        return "trMap";
    }

    public static String useTrKeyword() {
        return "useTr";
    }

    public static String groupMapKeyword() {
        return "trGroupMap";
    }

    public static String useGroupKeyword() {
        return "trUseGroup";
    }

    private void writeTrMap(PrintWriter out, Indenter ind) {
        ind.up().indent();
        out.println("<trMaps>");
        TreeSet sorted = new TreeSet();
        sorted.addAll(this.trEntryMap_.keySet());
        sorted.addAll(this.trSourceMap_.keySet());
        Iterator mapKeys = sorted.iterator();
        ind.up();
        while (mapKeys.hasNext()) {
            String useTr;
            Iterator lit;
            String key = (String)mapKeys.next();
            List elist = (List)this.trEntryMap_.get(key);
            List slist = (List)this.trSourceMap_.get(key);
            ind.indent();
            out.print("<trMap key=\"");
            out.print(key);
            out.println("\">");
            ind.up();
            if (elist != null) {
                lit = elist.iterator();
                while (lit.hasNext()) {
                    useTr = (String)lit.next();
                    ind.indent();
                    out.print("<useTr type=\"entry\" name=\"");
                    out.print(useTr);
                    out.println("\"/>");
                }
            }
            if (slist != null) {
                lit = slist.iterator();
                while (lit.hasNext()) {
                    useTr = (String)lit.next();
                    ind.indent();
                    out.print("<useTr type=\"source\" name=\"");
                    out.print(useTr);
                    out.println("\"/>");
                }
            }
            ind.down().indent();
            out.println("</trMap>");
        }
        ind.down().indent();
        out.println("</trMaps>");
    }

    private void writeGroupMap(PrintWriter out, Indenter ind) {
        ind.up().indent();
        out.println("<trGroupMaps>");
        TreeSet sorted = new TreeSet();
        sorted.addAll(this.groupMap_.keySet());
        Iterator mapKeys = sorted.iterator();
        ind.up();
        while (mapKeys.hasNext()) {
            String key = (String)mapKeys.next();
            List list = (List)this.groupMap_.get(key);
            ind.indent();
            out.print("<trGroupMap key=\"");
            out.print(key);
            out.println("\">");
            Iterator lit = list.iterator();
            ind.up();
            while (lit.hasNext()) {
                GroupUsage usegr = (GroupUsage)lit.next();
                ind.indent();
                out.print("<trUseGroup name=\"");
                out.print(usegr.mappedGroup);
                if (usegr.usage != null) {
                    out.print("\" useFor=\"");
                    out.print(usegr.usage);
                }
                out.println("\"/>");
            }
            ind.down().indent();
            out.println("</trGroupMap>");
        }
        ind.down().indent();
        out.println("</trGroupMaps>");
    }

    public static class TirMapResult {
        public String name;
        public int type;
        public static final int ENTRY_MAP = 0;
        public static final int SOURCE_MAP = 1;

        public TirMapResult(String name, int type) {
            this.name = name;
            this.type = type;
        }
    }
}

