/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.timeCourse;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.parser.ParserClient;
import org.systemsbiology.biotapestry.timeCourse.InputTimeRange;
import org.systemsbiology.biotapestry.timeCourse.RegionAndRange;
import org.systemsbiology.biotapestry.timeCourse.TemporalInputRangeData;
import org.systemsbiology.biotapestry.timeCourse.TemporalRange;
import org.xml.sax.Attributes;

public class TemporalInputRangeFormatFactory
implements ParserClient {
    private HashSet allKeys_;
    private Set tirdKeys_;
    private Set trKeys_;
    private Set itKeys_;
    private Set rarKeys_;
    private Object container_;
    private TemporalInputRangeData currTarg_;
    private TemporalRange currTemporalRange_;
    private InputTimeRange currInputTimeRange_;
    private String trKey_;
    private String useTrKey_;
    private String gmKey_;
    private String useGroupKey_;
    private String currTrMapKey_;
    private ArrayList currTrMapList_;
    private String currGroupMapKey_;
    private ArrayList currGroupMapList_;
    private boolean mapsAreIllegal_;

    public TemporalInputRangeFormatFactory(boolean mapsAreIllegal) {
        this.mapsAreIllegal_ = mapsAreIllegal;
        this.tirdKeys_ = TemporalInputRangeData.keywordsOfInterest();
        this.trKeys_ = TemporalRange.keywordsOfInterest();
        this.itKeys_ = InputTimeRange.keywordsOfInterest();
        this.rarKeys_ = RegionAndRange.keywordsOfInterest();
        this.trKey_ = TemporalInputRangeData.trMapKeyword();
        this.useTrKey_ = TemporalInputRangeData.useTrKeyword();
        this.gmKey_ = TemporalInputRangeData.groupMapKeyword();
        this.useGroupKey_ = TemporalInputRangeData.useGroupKeyword();
        this.allKeys_ = new HashSet();
        this.allKeys_.addAll(this.tirdKeys_);
    }

    public TemporalInputRangeData getTemporalInputRangeData() {
        return this.currTarg_;
    }

    public void setContainer(Object container) {
        this.container_ = container;
    }

    public boolean finishElement(String elemName) {
        if (elemName.equals(this.trKey_)) {
            this.currTarg_.addCombinedTemporalInputRangeMaps(this.currTrMapKey_, this.currTrMapList_);
            this.currTrMapList_ = null;
            this.currTrMapKey_ = null;
        } else if (elemName.equals(this.gmKey_)) {
            this.currTarg_.setTemporalRangeGroupMap(this.currGroupMapKey_, this.currGroupMapList_);
            this.currGroupMapList_ = null;
            this.currGroupMapKey_ = null;
        }
        return this.allKeys_.contains(elemName);
    }

    public void processCharacters(char[] chars, int start, int length) {
    }

    public Set keywordsOfInterest() {
        return this.allKeys_;
    }

    public Object processElement(String elemName, Attributes attrs) throws IOException {
        if (attrs == null || elemName == null) {
            return null;
        }
        if (this.tirdKeys_.contains(elemName)) {
            TemporalInputRangeData data = TemporalInputRangeData.buildFromXML(elemName, attrs);
            if (data != null) {
                Database db = Database.getDB();
                db.setTemporalInputRangeData(data);
                this.currTarg_ = data;
            }
        } else if (this.trKeys_.contains(elemName)) {
            TemporalRange trange = TemporalRange.buildFromXML(elemName, attrs);
            if (trange != null) {
                this.currTarg_.addEntry(trange);
                this.currTemporalRange_ = trange;
            }
        } else if (this.itKeys_.contains(elemName)) {
            InputTimeRange itr = InputTimeRange.buildFromXML(elemName, attrs);
            if (itr != null) {
                this.currTemporalRange_.addTimeRange(itr);
                this.currInputTimeRange_ = itr;
            }
        } else if (this.rarKeys_.contains(elemName)) {
            RegionAndRange rar = RegionAndRange.buildFromXML(elemName, attrs);
            if (rar != null) {
                this.currInputTimeRange_.add(rar);
            }
        } else if (elemName.equals(this.trKey_)) {
            if (this.mapsAreIllegal_) {
                throw new IOException();
            }
            this.currTrMapKey_ = TemporalInputRangeData.extractTrMapKey(elemName, attrs);
            this.currTrMapList_ = new ArrayList();
        } else if (elemName.equals(this.useTrKey_)) {
            if (this.mapsAreIllegal_) {
                throw new IOException();
            }
            this.currTrMapList_.add(TemporalInputRangeData.extractUseTr(elemName, attrs));
        } else if (elemName.equals(this.gmKey_)) {
            if (this.mapsAreIllegal_) {
                throw new IOException();
            }
            this.currGroupMapKey_ = TemporalInputRangeData.extractGroupMapKey(elemName, attrs);
            this.currGroupMapList_ = new ArrayList();
        } else if (elemName.equals(this.useGroupKey_)) {
            if (this.mapsAreIllegal_) {
                throw new IOException();
            }
            this.currGroupMapList_.add(TemporalInputRangeData.extractUseGroup(elemName, attrs));
        }
        return null;
    }
}

