/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.timeCourse;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.TimeAxisDefinition;
import org.systemsbiology.biotapestry.timeCourse.InputTimeRange;
import org.systemsbiology.biotapestry.timeCourse.RegionAndRange;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.xml.sax.Attributes;

public class TemporalRange {
    private String name_;
    private ArrayList data_;
    private String note_;
    private boolean internalOnly_;

    public TemporalRange(String name, String note, boolean internalOnly) {
        this.name_ = name;
        this.note_ = note;
        this.internalOnly_ = internalOnly;
        this.data_ = new ArrayList();
    }

    public TemporalRange(TemporalRange other) {
        this.name_ = other.name_;
        this.note_ = other.note_;
        this.internalOnly_ = other.internalOnly_;
        this.data_ = new ArrayList();
        int size = other.data_.size();
        for (int i = 0; i < size; ++i) {
            InputTimeRange pert = (InputTimeRange)other.data_.get(i);
            this.data_.add(new InputTimeRange(pert));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TemporalRange(String name, String note, String internalOnly) throws IOException {
        this.name_ = name;
        this.note_ = note;
        if (internalOnly != null) {
            if ((internalOnly = internalOnly.trim()).equalsIgnoreCase("no")) {
                this.internalOnly_ = false;
            } else {
                if (!internalOnly.equalsIgnoreCase("yes")) throw new IOException();
                this.internalOnly_ = true;
            }
        } else {
            this.internalOnly_ = false;
        }
        this.data_ = new ArrayList();
    }

    public String getName() {
        return this.name_;
    }

    public void setName(String name) {
        this.name_ = name;
    }

    public String getNote() {
        return this.note_;
    }

    public boolean isInternalOnly() {
        return this.internalOnly_;
    }

    public void setInternalOnly(boolean state) {
        this.internalOnly_ = state;
    }

    public void setNote(String note) {
        this.note_ = note;
    }

    public void addTimeRange(InputTimeRange pert) {
        this.data_.add(pert);
    }

    public void dropTimeRanges() {
        this.data_.clear();
    }

    public Iterator getTimeRanges() {
        return this.data_.iterator();
    }

    public InputTimeRange getTimeRange(String name) {
        Iterator pit = this.getTimeRanges();
        while (pit.hasNext()) {
            InputTimeRange itr = (InputTimeRange)pit.next();
            if (!itr.getName().equals(name)) continue;
            return itr;
        }
        return null;
    }

    public void getInterestingTimes(Set interest) {
        Iterator perts = this.getTimeRanges();
        while (perts.hasNext()) {
            InputTimeRange pert = (InputTimeRange)perts.next();
            pert.getInterestingTimes(interest);
        }
    }

    public void getAllRegions(Set interest) {
        Iterator perts = this.getTimeRanges();
        while (perts.hasNext()) {
            InputTimeRange pert = (InputTimeRange)perts.next();
            pert.getAllRegions(interest);
        }
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<temporalRange name=\"");
        out.print(CharacterEntityMapper.mapEntities(this.name_, false));
        if (this.note_ != null) {
            out.print("\" note=\"");
            out.print(CharacterEntityMapper.mapEntities(this.note_, false));
        }
        if (this.internalOnly_) {
            out.print("\" internalOnly=\"yes");
        }
        if (this.data_.size() > 0) {
            out.println("\">");
            ind.up();
            Iterator perts = this.getTimeRanges();
            while (perts.hasNext()) {
                InputTimeRange pert = (InputTimeRange)perts.next();
                pert.writeXML(out, ind);
            }
            ind.down().indent();
            out.println("</temporalRange>");
        } else {
            out.println("\"/>");
        }
    }

    public void getInputsTable(PrintWriter out, Set srcIDs) {
        if (this.data_.size() == 0) {
            return;
        }
        out.println("<table border=\"1\" width=\"75%\" cellpadding=\"7\" cellspacing=\"0\">");
        out.println("<tr>");
        out.print("<td width=\"20%\">");
        out.print("<p align=\"center\">");
        out.print("Gene");
        out.println("</p>");
        out.println("</td>");
        out.println("<td width=\"20%\">");
        out.print("<p align=\"center\">");
        out.print("Input");
        out.println("</p>");
        out.println("</td>");
        out.println("<td width=\"30%\">");
        out.print("<p align=\"center\">");
        out.print("Time");
        out.println("</p>");
        out.println("</td>");
        out.println("<td width=\"30%\">");
        out.print("<p align=\"center\">");
        out.print("Notes");
        out.println("</p>");
        out.println("</td>");
        out.println("</tr>");
        TimeAxisDefinition tad = Database.getDB().getTimeAxisDefinition();
        boolean namedStages = tad.haveNamedStages();
        String displayUnits = tad.unitDisplayAbbrev();
        ResourceManager rMan = ResourceManager.getManager();
        boolean isFirst = true;
        Iterator perts = this.getTimeRanges();
        while (perts.hasNext()) {
            RegionAndRange rar;
            InputTimeRange pert = (InputTimeRange)perts.next();
            String rangeName = pert.getName();
            if (srcIDs != null && !DataUtil.containsKey(srcIDs, rangeName)) continue;
            out.println("<tr>");
            if (isFirst) {
                out.print("<td rowspan=\"");
                out.print(this.data_.size());
                out.println("\">");
                out.println(this.name_);
                out.println("</td>");
                isFirst = false;
            }
            out.println("<td>");
            out.println(rangeName);
            out.println("</td>");
            out.println("<td>");
            out.println("<table border=\"0\" width=\"100%\" cellspacing=\"0\">");
            out.println("<tr>");
            Iterator rit = pert.getRanges();
            while (rit.hasNext()) {
                rar = (RegionAndRange)rit.next();
                out.println("<td ");
                int sign = rar.getSign();
                if (sign == 0) {
                    out.print(" bgcolor=\"#66EE66\">");
                } else {
                    out.print(" bgcolor=\"#EE6666\">");
                }
                this.getRangeLine(out, srcIDs, rar, tad, namedStages, displayUnits, rMan);
                out.println("</td>");
                out.println("</tr>");
            }
            out.println("</table>");
            out.println("</td>");
            out.println("<td>");
            out.println("<table border=\"0\" width=\"100%\" cellspacing=\"0\">");
            out.println("<tr>");
            rit = pert.getRanges();
            while (rit.hasNext()) {
                rar = (RegionAndRange)rit.next();
                out.println("<td>");
                String note = rar.getNote();
                if (note != null) {
                    out.println(note);
                } else {
                    out.println("&nbsp;");
                }
                out.println("</td>");
                out.println("</tr>");
            }
            out.println("</table>");
            out.println("</td>");
            out.println("</tr>");
        }
        out.println("</table>");
    }

    public void getRangeLine(PrintWriter out, Set srcIDs, RegionAndRange rar, TimeAxisDefinition tad, boolean namedStages, String displayUnits, ResourceManager rMan) {
        String minTime;
        int min = rar.getMin();
        int max = rar.getMax();
        String string = minTime = namedStages ? tad.getNamedStageForIndex((int)min).name : Integer.toString(min);
        if (min == max) {
            String whichFormat = tad.unitsAreASuffix() ? "tempoRange.singleTime" : "tempoRange.singleTimePrefix";
            String display = MessageFormat.format(rMan.getString(whichFormat), minTime, displayUnits);
            out.print(display);
        } else {
            String maxTime = namedStages ? tad.getNamedStageForIndex((int)max).name : Integer.toString(max);
            String whichFormat = tad.unitsAreASuffix() ? "tempoRange.timeRange" : "tempoRange.timeRangePrefix";
            String display = MessageFormat.format(rMan.getString(whichFormat), minTime, maxTime, displayUnits);
            out.print(display);
        }
        String reg = rar.getRegion();
        if (reg != null) {
            out.print(" (");
            out.print(reg);
            out.print(")");
        }
    }

    public String toString() {
        return "TemporalRange: name = " + this.name_ + " perturbations = " + this.data_ + " note = " + this.note_;
    }

    public static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("temporalRange");
        return retval;
    }

    public static TemporalRange buildFromXML(String elemName, Attributes attrs) throws IOException {
        if (!elemName.equals("temporalRange")) {
            return null;
        }
        String name = null;
        String note = null;
        String internalOnly = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("name")) {
                    name = CharacterEntityMapper.unmapEntities(val, false);
                    continue;
                }
                if (key.equals("note")) {
                    note = CharacterEntityMapper.unmapEntities(val, false);
                    continue;
                }
                if (!key.equals("internalOnly")) continue;
                internalOnly = val;
            }
        }
        if (name == null) {
            throw new IOException();
        }
        return new TemporalRange(name, note, internalOnly);
    }
}

