/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.timeCourse;

import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.TimeAxisDefinition;
import org.systemsbiology.biotapestry.genome.DBGenome;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.perturb.PertSources;
import org.systemsbiology.biotapestry.timeCourse.ExpressionEntry;
import org.systemsbiology.biotapestry.timeCourse.GeneTemplateEntry;
import org.systemsbiology.biotapestry.timeCourse.GroupUsage;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseChange;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseGene;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.xml.sax.Attributes;

public class TimeCourseData
implements Cloneable {
    public static final int NO_SLICE = -1;
    public static final int SLICE_BY_TIMES = 0;
    public static final int SLICE_BY_REGIONS = 1;
    public static final String SLICE_BY_TIMES_TAG = "byTimes";
    public static final String SLICE_BY_REGIONS_TAG = "byRegions";
    private ArrayList genes_ = new ArrayList();
    private HashMap tcMap_ = new HashMap();
    private HashMap groupMap_ = new HashMap();
    private ArrayList geneTemplate_;
    private ArrayList tempTemplate_;
    private HashMap groupParents_ = new HashMap();
    private HashSet groupRoots_ = new HashSet();
    private SortedMap regionTopologies_ = new TreeMap();
    private TopoRegionLocator topoLocator_ = null;
    private long serialNumber_ = 0L;
    private long topoSerialNumber_ = 0L;
    private long linSerialNumber_ = 0L;

    public Object clone() {
        try {
            TimeCourseData retval = (TimeCourseData)super.clone();
            int size = this.genes_.size();
            retval.genes_ = new ArrayList();
            for (int i = 0; i < size; ++i) {
                TimeCourseGene tcg = (TimeCourseGene)this.genes_.get(i);
                retval.genes_.add(tcg.clone());
            }
            retval.tcMap_ = new HashMap();
            Iterator tcmit = this.tcMap_.keySet().iterator();
            while (tcmit.hasNext()) {
                String mapKey = (String)tcmit.next();
                List targList = (List)this.tcMap_.get(mapKey);
                ArrayList<Object> retTargList = new ArrayList<Object>();
                retval.tcMap_.put(mapKey, retTargList);
                int tlSize = targList.size();
                for (int i = 0; i < tlSize; ++i) {
                    TCMapping targ = (TCMapping)targList.get(i);
                    retTargList.add(targ.clone());
                }
            }
            retval.groupMap_ = new HashMap();
            Iterator gmkit = this.groupMap_.keySet().iterator();
            while (gmkit.hasNext()) {
                String key = (String)gmkit.next();
                List mapList = (List)this.groupMap_.get(key);
                ArrayList<Object> retGroupList = new ArrayList<Object>();
                retval.groupMap_.put(key, retGroupList);
                int mlsize = mapList.size();
                for (int i = 0; i < mlsize; ++i) {
                    GroupUsage gu = (GroupUsage)mapList.get(i);
                    retGroupList.add(gu.clone());
                }
            }
            retval.groupParents_ = (HashMap)this.groupParents_.clone();
            retval.groupRoots_ = (HashSet)this.groupRoots_.clone();
            retval.regionTopologies_ = new TreeMap();
            Iterator rtkit = this.regionTopologies_.keySet().iterator();
            while (rtkit.hasNext()) {
                TopoTimeRange key = (TopoTimeRange)rtkit.next();
                RegionTopology retTopo = (RegionTopology)this.regionTopologies_.get(key);
                retval.regionTopologies_.put(key.clone(), retTopo.clone());
            }
            if (this.topoLocator_ != null) {
                retval.topoLocator_ = (TopoRegionLocator)this.topoLocator_.clone();
            }
            return retval;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public long getSerialNumber() {
        return this.serialNumber_;
    }

    public long getTopoSerialNumber() {
        return this.topoSerialNumber_;
    }

    public long getLineageSerialNumber() {
        return this.linSerialNumber_;
    }

    public Iterator getRegionTopologyTimes() {
        this.initializeRegionTopoData();
        return this.regionTopologies_.keySet().iterator();
    }

    public RegionTopology getRegionTopology(TopoTimeRange range) {
        this.initializeRegionTopoData();
        return (RegionTopology)this.regionTopologies_.get(range);
    }

    public TimeCourseChange changeRegionTopologyRegionName(String oldName, String newName) {
        TreeMap<Object, RegionTopology> newTops = new TreeMap<Object, RegionTopology>();
        Iterator tmit = this.regionTopologies_.keySet().iterator();
        while (tmit.hasNext()) {
            TopoTimeRange ttr = (TopoTimeRange)tmit.next();
            RegionTopology rt = (RegionTopology)this.regionTopologies_.get(ttr);
            RegionTopology modRt = rt.changeRegionNameOnMatch(oldName, newName);
            newTops.put(ttr.clone(), modRt);
        }
        TopoRegionLocator newLoc = null;
        if (this.topoLocator_ != null) {
            newLoc = this.topoLocator_.changeRegionNameOnMatch(oldName, newName);
        }
        return newTops.isEmpty() ? null : this.setRegionTopologiesInfo(newTops, newLoc);
    }

    public TimeCourseChange dropRegionTopologyRegionName(String dropName) {
        TreeMap<Object, RegionTopology> newTops = new TreeMap<Object, RegionTopology>();
        Iterator tmit = this.regionTopologies_.keySet().iterator();
        while (tmit.hasNext()) {
            TopoTimeRange ttr = (TopoTimeRange)tmit.next();
            RegionTopology rt = (RegionTopology)this.regionTopologies_.get(ttr);
            RegionTopology modRt = rt.dropRegionName(dropName);
            newTops.put(ttr.clone(), modRt);
        }
        TopoRegionLocator newLoc = null;
        if (this.topoLocator_ != null) {
            newLoc = this.topoLocator_.dropRegionName(dropName);
        }
        return newTops.isEmpty() ? null : this.setRegionTopologiesInfo(newTops, newLoc);
    }

    public boolean haveRegionNameInTopology(Set checkNames) {
        Iterator tmit = this.regionTopologies_.keySet().iterator();
        while (tmit.hasNext()) {
            TopoTimeRange ttr = (TopoTimeRange)tmit.next();
            RegionTopology rt = (RegionTopology)this.regionTopologies_.get(ttr);
            if (!rt.hasRegionName(checkNames)) continue;
            return true;
        }
        return false;
    }

    public void setRegionTopology(TopoTimeRange range, RegionTopology topo) {
        this.regionTopologies_.put(range, topo);
    }

    private SortedMap duplicateRegionTopologies(SortedMap inmap) {
        TreeMap<Object, Object> retval = new TreeMap<Object, Object>();
        Iterator rtksit = inmap.keySet().iterator();
        while (rtksit.hasNext()) {
            TopoTimeRange range = (TopoTimeRange)rtksit.next();
            RegionTopology rtopo = (RegionTopology)inmap.get(range);
            retval.put(range.clone(), rtopo.clone());
        }
        return retval;
    }

    public void prepareRegionTopologyLocatorForInput() {
        if (this.topoLocator_ == null) {
            this.topoLocator_ = new TopoRegionLocator();
        }
    }

    public TopoRegionLocator getRegionTopologyLocator() {
        if (this.topoLocator_ == null) {
            this.initializeRegionTopoData();
            this.topoLocator_ = new TopoRegionLocator(this);
        }
        return this.topoLocator_;
    }

    public TimeCourseChange setRegionTopologiesInfo(SortedMap newTopologies, TopoRegionLocator newLoc) {
        TimeCourseChange retval = new TimeCourseChange(2, this.topoSerialNumber_);
        retval.regionTopologiesOrig = this.duplicateRegionTopologies(this.regionTopologies_);
        retval.topoLocatorOrig = this.topoLocator_ == null ? null : (TopoRegionLocator)this.topoLocator_.clone();
        this.regionTopologies_ = newTopologies;
        this.topoLocator_ = newLoc;
        retval.regionTopologiesNew = this.duplicateRegionTopologies(this.regionTopologies_);
        retval.topoLocatorNew = this.topoLocator_ == null ? null : (TopoRegionLocator)this.topoLocator_.clone();
        retval.topoSerialNumberNew = ++this.topoSerialNumber_;
        return retval;
    }

    private void initializeRegionTopoData() {
        if (!this.regionTopologies_.isEmpty()) {
            return;
        }
        List slices = this.suggestTimeSlices();
        int num = slices.size();
        for (int i = 0; i < num; ++i) {
            RootInstanceSuggestions sugg = (RootInstanceSuggestions)slices.get(i);
            TopoTimeRange ttr = new TopoTimeRange(sugg.minTime, sugg.maxTime);
            ArrayList regs = new ArrayList(sugg.regions);
            RegionTopology rt = new RegionTopology(ttr, regs, new ArrayList());
            this.regionTopologies_.put(ttr, rt);
        }
    }

    public static String regionTopologyKeyword() {
        return "tcRegionTopology";
    }

    public static String topoRegionKeyword() {
        return "tcTopoRegion";
    }

    public static String topoLinkKeyword() {
        return "tcTopoLink";
    }

    public static String topoLocationsForRangeKeyword() {
        return "topoLocationsForRange";
    }

    public static String topoRegionLocationKeyword() {
        return "tcTopoRegionLoc";
    }

    public boolean haveData() {
        if (!this.genes_.isEmpty()) {
            return true;
        }
        if (!this.tcMap_.isEmpty()) {
            return true;
        }
        return !this.groupMap_.isEmpty();
    }

    public Map getPertSourceMergeDependencies(Set sdIDs) {
        HashMap retval = new HashMap();
        ArrayList<String> seen = new ArrayList<String>();
        int numGenes = this.genes_.size();
        for (int i = 0; i < numGenes; ++i) {
            TimeCourseGene tg = this.getGene(i);
            String geneName = tg.getName();
            seen.clear();
            Iterator pkit = tg.getPertKeys();
            while (pkit.hasNext()) {
                PertSources pss = (PertSources)pkit.next();
                Iterator sit = pss.getSources();
                while (sit.hasNext()) {
                    String psid = (String)sit.next();
                    if (!sdIDs.contains(psid)) continue;
                    seen.add(psid);
                }
            }
            if (seen.size() <= 1) continue;
            HashSet<PertSources> gottaGo = new HashSet<PertSources>();
            retval.put(geneName, gottaGo);
            pkit = tg.getPertKeys();
            block3: while (pkit.hasNext()) {
                PertSources pss = (PertSources)pkit.next();
                Iterator sit = pss.getSources();
                while (sit.hasNext()) {
                    String psid = (String)sit.next();
                    if (!seen.contains(psid)) continue;
                    gottaGo.add(pss);
                    continue block3;
                }
            }
        }
        return retval;
    }

    public Map getPertSourceDependencies() {
        HashMap<String, HashSet<String>> retval = new HashMap<String, HashSet<String>>();
        int numGenes = this.genes_.size();
        for (int i = 0; i < numGenes; ++i) {
            TimeCourseGene tg = this.getGene(i);
            String geneName = tg.getName();
            Iterator pkit = tg.getPertKeys();
            while (pkit.hasNext()) {
                PertSources pss = (PertSources)pkit.next();
                Iterator sit = pss.getSources();
                while (sit.hasNext()) {
                    String psid = (String)sit.next();
                    HashSet<String> forPsid = (HashSet<String>)retval.get(psid);
                    if (forPsid == null) {
                        forPsid = new HashSet<String>();
                        retval.put(psid, forPsid);
                    }
                    forPsid.add(geneName);
                }
            }
        }
        return retval;
    }

    public TimeCourseChange[] dropPertSourceDependencies(String pertSrcID) {
        ArrayList<TimeCourseChange> retvalList = new ArrayList<TimeCourseChange>();
        HashSet<PertSources> killset = new HashSet<PertSources>();
        Map myDepend = this.getPertSourceDependencies();
        Set toDrop = (Set)myDepend.get(pertSrcID);
        Iterator tdit = toDrop.iterator();
        while (tdit.hasNext()) {
            String geneName = (String)tdit.next();
            TimeCourseGene gene = this.getTimeCourseData(geneName);
            killset.clear();
            Iterator pkit = gene.getPertKeys();
            block1: while (pkit.hasNext()) {
                PertSources pss = (PertSources)pkit.next();
                Iterator sit = pss.getSources();
                while (sit.hasNext()) {
                    String psid = (String)sit.next();
                    if (!psid.equals(pertSrcID)) continue;
                    killset.add(pss);
                    continue block1;
                }
            }
            TimeCourseChange tcc = this.startGeneUndoTransaction(geneName);
            Iterator ksit = killset.iterator();
            while (ksit.hasNext()) {
                PertSources pss = (PertSources)ksit.next();
                gene.dropPerturbedState(pss);
            }
            tcc = this.finishGeneUndoTransaction(geneName, tcc);
            retvalList.add(tcc);
        }
        return retvalList.toArray(new TimeCourseChange[retvalList.size()]);
    }

    public TimeCourseChange[] dropPertSourceMergeIssues(Map killTargets) {
        ArrayList<TimeCourseChange> retvalList = new ArrayList<TimeCourseChange>();
        Iterator tdit = killTargets.keySet().iterator();
        while (tdit.hasNext()) {
            String geneName = (String)tdit.next();
            TimeCourseGene gene = this.getTimeCourseData(geneName);
            Set killSet = (Set)killTargets.get(geneName);
            TimeCourseChange tcc = this.startGeneUndoTransaction(geneName);
            Iterator ksit = killSet.iterator();
            while (ksit.hasNext()) {
                PertSources pss = (PertSources)ksit.next();
                gene.dropPerturbedState(pss);
            }
            tcc = this.finishGeneUndoTransaction(geneName, tcc);
            retvalList.add(tcc);
        }
        return retvalList.toArray(new TimeCourseChange[retvalList.size()]);
    }

    public void exportCSV(PrintWriter out, boolean groupByTime, boolean encodeConfidence, boolean exportInternals) {
        out.print("\"");
        out.print(ResourceManager.getManager().getString("csvTcdExport.geneName"));
        out.print("\"");
        Iterator tempit = this.getGeneTemplate();
        if (tempit.hasNext()) {
            out.print(",");
        }
        TemplateComparator tc = new TemplateComparator(groupByTime, tempit);
        TreeSet<GeneTemplateEntry> ordering = new TreeSet<GeneTemplateEntry>(tc);
        tempit = this.getGeneTemplate();
        while (tempit.hasNext()) {
            GeneTemplateEntry gte = (GeneTemplateEntry)tempit.next();
            ordering.add(gte);
        }
        Iterator oit = ordering.iterator();
        while (oit.hasNext()) {
            GeneTemplateEntry gte = (GeneTemplateEntry)oit.next();
            out.print("\"");
            out.print(gte.region);
            out.print(":");
            out.print(gte.time);
            out.print("\"");
            if (!oit.hasNext()) continue;
            out.print(",");
        }
        out.println();
        TreeMap<String, Integer> ordered = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
        int numGenes = this.genes_.size();
        for (int i = 0; i < numGenes; ++i) {
            TimeCourseGene tg = this.getGene(i);
            ordered.put(tg.getName(), new Integer(i));
        }
        Iterator goit = ordered.values().iterator();
        while (goit.hasNext()) {
            Integer indexObj = (Integer)goit.next();
            TimeCourseGene tg = this.getGene(indexObj);
            oit = ordering.iterator();
            tg.exportCSV(out, oit, encodeConfidence, exportInternals);
        }
        ExpressionEntry.expressionKeyCSV(out, encodeConfidence);
    }

    public int[] getDataRange() {
        if (this.genes_.isEmpty()) {
            return null;
        }
        TimeCourseGene gene = (TimeCourseGene)this.genes_.get(0);
        HashSet rawtimes = new HashSet();
        gene.getInterestingTimes(rawtimes);
        TreeSet times = new TreeSet();
        times.addAll(rawtimes);
        if (times.isEmpty()) {
            return null;
        }
        int[] range = new int[]{(Integer)times.first(), (Integer)times.last()};
        return range;
    }

    public boolean haveCustomMapForRegion(String groupId) {
        if (!this.haveData()) {
            return false;
        }
        List mapped = (List)this.groupMap_.get(groupId);
        return mapped != null && mapped.size() != 0;
    }

    public boolean haveCustomMapForNode(String nodeID) {
        if (!this.haveData()) {
            return false;
        }
        List mapped = (List)this.tcMap_.get(nodeID);
        return mapped != null && mapped.size() != 0;
    }

    public boolean haveDataForNode(String nodeID) {
        if (!this.haveData()) {
            return false;
        }
        List mapped = this.getTimeCourseTCMDataKeysWithDefault(nodeID);
        if (mapped == null) {
            return false;
        }
        Iterator mit = mapped.iterator();
        while (mit.hasNext()) {
            TCMapping tcm = (TCMapping)mit.next();
            if (this.getTimeCourseData(tcm.name) == null) continue;
            return true;
        }
        return false;
    }

    public boolean isAllInternalForNode(String nodeID) {
        if (!this.haveData()) {
            return false;
        }
        List mapped = this.getTimeCourseTCMDataKeysWithDefault(nodeID);
        if (mapped == null) {
            return false;
        }
        Iterator mit = mapped.iterator();
        boolean retval = false;
        while (mit.hasNext()) {
            retval = true;
            TCMapping tcm = (TCMapping)mit.next();
            TimeCourseGene tcg = this.getTimeCourseData(tcm.name);
            if (tcg == null || tcg.isInternalOnly()) continue;
            return false;
        }
        return retval;
    }

    public boolean haveDataForNodeOrName(String nodeID, String deadName) {
        if (!this.haveData()) {
            return false;
        }
        List mapped = this.getTimeCourseTCMDataKeysWithDefaultGivenName(nodeID, deadName);
        if (mapped == null) {
            return false;
        }
        Iterator mit = mapped.iterator();
        while (mit.hasNext()) {
            TCMapping tcm = (TCMapping)mit.next();
            if (this.getTimeCourseData(tcm.name) == null) continue;
            return true;
        }
        return false;
    }

    public void changeUndo(TimeCourseChange undo) {
        if (undo.mapListOrig != null || undo.mapListNew != null) {
            this.mapChangeUndo(undo);
        } else if (undo.groupMapListOrig != null || undo.groupMapListNew != null) {
            this.groupMapChangeUndo(undo);
        } else if (undo.gOrig != null || undo.gNew != null) {
            this.geneChangeUndo(undo);
        } else if (undo.allGenesOrig != null || undo.allGenesNew != null) {
            this.fullChangeUndo(undo);
        } else if (undo.groupParentsOrig != null || undo.groupParentsNew != null || undo.groupRootsOrig != null || undo.groupRootsNew != null) {
            this.hierarchyChangeUndo(undo);
        } else if (undo.regionTopologiesOrig != null || undo.topoLocatorOrig != null || undo.regionTopologiesNew != null || undo.topoLocatorNew != null) {
            this.regionTopoUndo(undo);
        }
        if (undo.baseSerialNumberOrig != -1L) {
            this.serialNumber_ = undo.baseSerialNumberOrig;
        } else if (undo.topoSerialNumberOrig != -1L) {
            this.topoSerialNumber_ = undo.topoSerialNumberOrig;
        } else if (undo.linSerialNumberOrig != -1L) {
            this.linSerialNumber_ = undo.linSerialNumberOrig;
        } else {
            throw new IllegalStateException();
        }
    }

    public void changeRedo(TimeCourseChange undo) {
        if (undo.mapListOrig != null || undo.mapListNew != null) {
            this.mapChangeRedo(undo);
        } else if (undo.groupMapListOrig != null || undo.groupMapListNew != null) {
            this.groupMapChangeRedo(undo);
        } else if (undo.gOrig != null || undo.gNew != null) {
            this.geneChangeRedo(undo);
        } else if (undo.allGenesOrig != null || undo.allGenesNew != null) {
            this.fullChangeRedo(undo);
        } else if (undo.groupParentsOrig != null || undo.groupParentsNew != null || undo.groupRootsOrig != null || undo.groupRootsNew != null) {
            this.hierarchyChangeRedo(undo);
        } else if (undo.regionTopologiesOrig != null || undo.topoLocatorOrig != null || undo.regionTopologiesNew != null || undo.topoLocatorNew != null) {
            this.regionTopoRedo(undo);
        }
        if (undo.baseSerialNumberNew != -1L) {
            this.serialNumber_ = undo.baseSerialNumberNew;
        } else if (undo.topoSerialNumberNew != -1L) {
            this.topoSerialNumber_ = undo.topoSerialNumberNew;
        } else if (undo.linSerialNumberNew != -1L) {
            this.linSerialNumber_ = undo.linSerialNumberNew;
        } else {
            throw new IllegalStateException();
        }
    }

    public boolean isEmpty() {
        return this.genes_.isEmpty();
    }

    public void addGene(TimeCourseGene gene) {
        if (gene.isArchival()) {
            throw new IllegalArgumentException();
        }
        this.genes_.add(gene);
    }

    public TimeCourseChange addTimeCourseGene(TimeCourseGene gene) {
        TimeCourseChange retval = new TimeCourseChange(0, this.serialNumber_);
        if (gene.isArchival()) {
            throw new IllegalArgumentException();
        }
        retval.genePos = this.genes_.size();
        this.genes_.add(gene);
        retval.gNew = new TimeCourseGene(gene);
        retval.gOrig = null;
        retval.baseSerialNumberNew = ++this.serialNumber_;
        return retval;
    }

    public Iterator getGenes() {
        return this.genes_.iterator();
    }

    public TimeCourseGene getGene(int n) {
        return (TimeCourseGene)this.genes_.get(n);
    }

    public TimeCourseChange[] dropMapsToEntrySourceChannel(String nodeID, int channel) {
        ArrayList<TimeCourseChange> retvalList = new ArrayList<TimeCourseChange>();
        Iterator mit = new HashSet(this.tcMap_.keySet()).iterator();
        block0: while (mit.hasNext()) {
            String mapKey = (String)mit.next();
            List targList = (List)this.tcMap_.get(mapKey);
            int tlSize = targList.size();
            for (int i = 0; i < tlSize; ++i) {
                TCMapping targ = (TCMapping)targList.get(i);
                if (!DataUtil.keysEqual(targ.name, nodeID) || targ.channel != channel) continue;
                TimeCourseChange tcc = new TimeCourseChange(0, this.serialNumber_);
                tcc.mapKey = mapKey;
                tcc.mapListOrig = TCMapping.cloneAList(targList);
                targList.remove(i);
                if (targList.isEmpty()) {
                    tcc.mapListNew = null;
                    this.tcMap_.remove(mapKey);
                } else {
                    tcc.mapListNew = TCMapping.cloneAList(targList);
                }
                tcc.baseSerialNumberNew = ++this.serialNumber_;
                retvalList.add(tcc);
                continue block0;
            }
        }
        return retvalList.toArray(new TimeCourseChange[retvalList.size()]);
    }

    public boolean haveMapsToEntrySourceChannel(String nodeID, int channel) {
        Iterator mit = this.tcMap_.keySet().iterator();
        while (mit.hasNext()) {
            String mapKey = (String)mit.next();
            List targList = (List)this.tcMap_.get(mapKey);
            int tlSize = targList.size();
            for (int i = 0; i < tlSize; ++i) {
                TCMapping targ = (TCMapping)targList.get(i);
                if (!DataUtil.keysEqual(targ.name, nodeID) || targ.channel != channel) continue;
                return true;
            }
        }
        return false;
    }

    public TimeCourseChange[] dropMapsTo(String nodeID) {
        ArrayList<TimeCourseChange> retvalList = new ArrayList<TimeCourseChange>();
        Iterator mit = new HashSet(this.tcMap_.keySet()).iterator();
        block0: while (mit.hasNext()) {
            String mapKey = (String)mit.next();
            List targList = (List)this.tcMap_.get(mapKey);
            int tlSize = targList.size();
            for (int i = 0; i < tlSize; ++i) {
                TCMapping targ = (TCMapping)targList.get(i);
                if (!DataUtil.keysEqual(targ.name, nodeID)) continue;
                TimeCourseChange tcc = new TimeCourseChange(0, this.serialNumber_);
                tcc.mapKey = mapKey;
                tcc.mapListOrig = TCMapping.cloneAList(targList);
                targList.remove(i);
                if (targList.isEmpty()) {
                    tcc.mapListNew = null;
                    this.tcMap_.remove(mapKey);
                } else {
                    tcc.mapListNew = TCMapping.cloneAList(targList);
                }
                tcc.baseSerialNumberNew = ++this.serialNumber_;
                retvalList.add(tcc);
                continue block0;
            }
        }
        return retvalList.toArray(new TimeCourseChange[retvalList.size()]);
    }

    public TimeCourseChange dropGene(int n) {
        TimeCourseChange retval = new TimeCourseChange(0, this.serialNumber_);
        TimeCourseGene gene = (TimeCourseGene)this.genes_.get(n);
        retval.gOrig = new TimeCourseGene(gene);
        retval.gNew = null;
        retval.genePos = n;
        retval.baseSerialNumberNew = ++this.serialNumber_;
        this.genes_.remove(n);
        return retval;
    }

    public TimeCourseChange dropGene(String nodeID) {
        int size = this.genes_.size();
        for (int i = 0; i < size; ++i) {
            TimeCourseGene gene = (TimeCourseGene)this.genes_.get(i);
            if (!DataUtil.keysEqual(gene.getName(), nodeID)) continue;
            TimeCourseChange retval = new TimeCourseChange(0, this.serialNumber_);
            retval.gOrig = new TimeCourseGene(gene);
            retval.gNew = null;
            retval.genePos = i;
            retval.baseSerialNumberNew = ++this.serialNumber_;
            this.genes_.remove(i);
            return retval;
        }
        return null;
    }

    public TimeCourseChange startGeneUndoTransaction(String geneName) {
        TimeCourseChange retval = new TimeCourseChange(0, this.serialNumber_);
        Iterator git = this.getGenes();
        int count = 0;
        while (git.hasNext()) {
            TimeCourseGene tg = (TimeCourseGene)git.next();
            if (DataUtil.keysEqual(tg.getName(), geneName)) {
                retval.genePos = count;
                retval.gOrig = new TimeCourseGene(tg);
                retval.baseSerialNumberNew = ++this.serialNumber_;
                return retval;
            }
            ++count;
        }
        throw new IllegalArgumentException();
    }

    public TimeCourseChange finishGeneUndoTransaction(String geneName, TimeCourseChange change) {
        TimeCourseGene tg = (TimeCourseGene)this.genes_.get(change.genePos);
        change.gNew = new TimeCourseGene(tg);
        return change;
    }

    private void geneChangeUndo(TimeCourseChange undo) {
        if (undo.gOrig != null && undo.gNew != null) {
            this.genes_.set(undo.genePos, undo.gOrig);
        } else if (undo.gOrig == null) {
            this.genes_.remove(undo.genePos);
        } else {
            this.genes_.add(undo.genePos, undo.gOrig);
        }
    }

    private void geneChangeRedo(TimeCourseChange undo) {
        if (undo.gOrig != null && undo.gNew != null) {
            this.genes_.set(undo.genePos, undo.gNew);
        } else if (undo.gNew == null) {
            this.genes_.remove(undo.genePos);
        } else {
            this.genes_.add(undo.genePos, undo.gNew);
        }
    }

    private void fullChangeUndo(TimeCourseChange undo) {
        if (undo.allGenesNew != null && undo.allGenesOrig != null) {
            this.genes_ = (ArrayList)undo.allGenesOrig;
            this.geneTemplate_ = null;
        }
    }

    private void fullChangeRedo(TimeCourseChange undo) {
        if (undo.allGenesNew != null && undo.allGenesOrig != null) {
            this.genes_ = (ArrayList)undo.allGenesNew;
            this.geneTemplate_ = null;
        }
    }

    public TimeCourseChange[] clearAllDataKeys(boolean bumpSerial) {
        ArrayList<TimeCourseChange> retval = new ArrayList<TimeCourseChange>();
        Iterator ksit = new HashSet(this.tcMap_.keySet()).iterator();
        while (ksit.hasNext()) {
            String id = (String)ksit.next();
            TimeCourseChange tcc = this.coreDropDataKeys(id, bumpSerial);
            retval.add(tcc);
        }
        return retval.toArray(new TimeCourseChange[retval.size()]);
    }

    public TimeCourseChange dropDataKeys(String geneId) {
        return this.coreDropDataKeys(geneId, true);
    }

    private TimeCourseChange coreDropDataKeys(String geneId, boolean bumpSerial) {
        if (this.tcMap_.get(geneId) == null) {
            return null;
        }
        TimeCourseChange retval = new TimeCourseChange(0, this.serialNumber_);
        retval.mapKey = geneId;
        retval.mapListOrig = TCMapping.cloneAList((List)this.tcMap_.get(geneId));
        this.tcMap_.remove(geneId);
        retval.mapListNew = null;
        if (bumpSerial) {
            ++this.serialNumber_;
        }
        retval.baseSerialNumberNew = this.serialNumber_;
        return retval;
    }

    private void mapChangeUndo(TimeCourseChange undo) {
        if (undo.mapListOrig != null && undo.mapListNew != null) {
            this.tcMap_.put(undo.mapKey, TCMapping.cloneAList(undo.mapListOrig));
        } else if (undo.mapListOrig == null) {
            this.tcMap_.remove(undo.mapKey);
        } else {
            this.tcMap_.put(undo.mapKey, TCMapping.cloneAList(undo.mapListOrig));
        }
    }

    private void mapChangeRedo(TimeCourseChange undo) {
        if (undo.mapListOrig != null && undo.mapListNew != null) {
            this.tcMap_.put(undo.mapKey, TCMapping.cloneAList(undo.mapListNew));
        } else if (undo.mapListNew == null) {
            this.tcMap_.remove(undo.mapKey);
        } else {
            this.tcMap_.put(undo.mapKey, TCMapping.cloneAList(undo.mapListNew));
        }
    }

    private void hierarchyChangeUndo(TimeCourseChange undo) {
        if (undo.groupParentsOrig != null && undo.groupRootsOrig != null) {
            this.groupParents_ = new HashMap(undo.groupParentsOrig);
            this.groupRoots_ = new HashSet(undo.groupRootsOrig);
        }
    }

    private void hierarchyChangeRedo(TimeCourseChange undo) {
        if (undo.groupParentsNew != null && undo.groupRootsNew != null) {
            this.groupParents_ = new HashMap(undo.groupParentsNew);
            this.groupRoots_ = new HashSet(undo.groupRootsNew);
        }
    }

    private void regionTopoUndo(TimeCourseChange undo) {
        if (undo.regionTopologiesOrig != null) {
            this.regionTopologies_ = this.duplicateRegionTopologies(undo.regionTopologiesOrig);
        }
        this.topoLocator_ = undo.topoLocatorOrig == null ? null : (TopoRegionLocator)undo.topoLocatorOrig.clone();
    }

    private void regionTopoRedo(TimeCourseChange undo) {
        if (undo.regionTopologiesNew != null) {
            this.regionTopologies_ = this.duplicateRegionTopologies(undo.regionTopologiesNew);
        }
        this.topoLocator_ = undo.topoLocatorNew == null ? null : (TopoRegionLocator)undo.topoLocatorNew.clone();
    }

    public Iterator getGeneTemplate() {
        if (this.geneTemplate_ == null) {
            this.initTemplate();
        }
        return this.geneTemplate_.iterator();
    }

    public boolean hasGeneTemplate() {
        Iterator gtit = this.getGeneTemplate();
        return gtit.hasNext();
    }

    private void initTemplate() {
        block2: {
            block3: {
                if (this.geneTemplate_ != null) break block2;
                this.geneTemplate_ = new ArrayList();
                if (this.genes_.size() <= 0) break block3;
                TimeCourseGene gene = (TimeCourseGene)this.genes_.get(0);
                Iterator eit = gene.getExpressions();
                while (eit.hasNext()) {
                    ExpressionEntry exp = (ExpressionEntry)eit.next();
                    int time = exp.getTime();
                    String region = exp.getRegion();
                    GeneTemplateEntry gte = new GeneTemplateEntry(time, region);
                    this.geneTemplate_.add(gte);
                }
                break block2;
            }
            if (this.tempTemplate_ == null) break block2;
            Iterator ttit = this.tempTemplate_.iterator();
            while (ttit.hasNext()) {
                GeneTemplateEntry gte = (GeneTemplateEntry)ttit.next();
                this.geneTemplate_.add(new GeneTemplateEntry(gte));
            }
        }
    }

    public void normalizeTemplate(ArrayList template) {
        HashMap<String, String> firstUse = new HashMap<String, String>();
        Iterator ttit = template.iterator();
        while (ttit.hasNext()) {
            GeneTemplateEntry gte = (GeneTemplateEntry)ttit.next();
            String normName = DataUtil.normKey(gte.region);
            String firstName = (String)firstUse.get(normName);
            if (firstName == null) {
                firstUse.put(normName, gte.region);
                firstName = gte.region;
            }
            gte.region = firstName;
        }
    }

    private ArrayList copyTemplate(ArrayList template) {
        ArrayList<GeneTemplateEntry> retval = new ArrayList<GeneTemplateEntry>();
        Iterator ttit = template.iterator();
        while (ttit.hasNext()) {
            GeneTemplateEntry gte = (GeneTemplateEntry)ttit.next();
            retval.add(new GeneTemplateEntry(gte));
        }
        return retval;
    }

    public Set getRegions() {
        HashSet<String> retval = new HashSet<String>();
        Iterator tmpit = this.getGeneTemplate();
        while (tmpit.hasNext()) {
            GeneTemplateEntry gte = (GeneTemplateEntry)tmpit.next();
            retval.add(gte.region);
        }
        return retval;
    }

    public Map getRegionsWithMinTimes() {
        Iterator tmpit = this.getGeneTemplate();
        return this.getRegionsWithMinTimes(tmpit);
    }

    private Map getRegionsWithMinTimes(Iterator tmpit) {
        HashMap<String, Integer> retval = new HashMap<String, Integer>();
        while (tmpit.hasNext()) {
            GeneTemplateEntry gte = (GeneTemplateEntry)tmpit.next();
            Integer min = (Integer)retval.get(gte.region);
            if (min == null) {
                retval.put(gte.region, new Integer(gte.time));
                continue;
            }
            if (min <= gte.time) continue;
            retval.put(gte.region, new Integer(gte.time));
        }
        return retval;
    }

    public List getRegionsKeepOrder() {
        ArrayList<String> retval = new ArrayList<String>();
        Iterator tmpit = this.getGeneTemplate();
        while (tmpit.hasNext()) {
            GeneTemplateEntry gte = (GeneTemplateEntry)tmpit.next();
            if (retval.contains(gte.region)) continue;
            retval.add(gte.region);
        }
        return retval;
    }

    public boolean hierarchyIsSet() {
        if (this.groupRoots_.isEmpty()) {
            return false;
        }
        int numReg = this.getRegions().size();
        return this.groupRoots_.size() + this.groupParents_.size() >= numReg;
    }

    public boolean hierarchyIsSetForRegion(String regionID) {
        return this.regionIsRoot(regionID) || this.groupParents_.keySet().contains(regionID);
    }

    public boolean regionIsRoot(String regionID) {
        return this.groupRoots_.contains(regionID);
    }

    public String getParentRegion(String regionID) {
        String parent = (String)this.groupParents_.get(regionID);
        if (parent == null) {
            throw new IllegalStateException();
        }
        return parent;
    }

    public TimeCourseChange setRegionHierarchy(Map children, Set roots, boolean bumpSerial) {
        TimeCourseChange retval = new TimeCourseChange(1, this.linSerialNumber_);
        retval.groupParentsOrig = new HashMap(this.groupParents_);
        retval.groupRootsOrig = new HashSet(this.groupRoots_);
        this.groupParents_.clear();
        this.groupParents_.putAll(children);
        this.groupRoots_.clear();
        this.groupRoots_.addAll(roots);
        retval.groupParentsNew = new HashMap(this.groupParents_);
        retval.groupRootsNew = new HashSet(this.groupRoots_);
        retval.linSerialNumberNew = bumpSerial ? (this.linSerialNumber_ = this.linSerialNumber_ + 1L) : this.linSerialNumber_;
        return retval;
    }

    public List getRegionHierarchyList() {
        String regionID;
        int i;
        if (!this.hierarchyIsSet()) {
            return null;
        }
        ArrayList<String> retval = new ArrayList<String>();
        List regions = this.getRegionsKeepOrder();
        HashSet remainingRegions = new HashSet(regions);
        int numR = regions.size();
        for (i = 0; i < numR; ++i) {
            regionID = (String)regions.get(i);
            if (!this.regionIsRoot(regionID)) continue;
            retval.add(regionID);
            remainingRegions.remove(regionID);
        }
        while (!remainingRegions.isEmpty()) {
            for (i = numR - 1; i >= 0; --i) {
                String parent;
                int indexOf;
                regionID = (String)regions.get(i);
                if (!remainingRegions.contains(regionID) || (indexOf = retval.indexOf(parent = this.getParentRegion(regionID))) == -1) continue;
                retval.add(indexOf + 1, regionID);
                remainingRegions.remove(regionID);
            }
        }
        return retval;
    }

    public TreeModel getRegionHierarchyTree() {
        String regionID;
        int i;
        if (!this.hierarchyIsSet()) {
            return null;
        }
        DefaultMutableTreeNode treeRoot = new DefaultMutableTreeNode();
        DefaultTreeModel retval = new DefaultTreeModel(treeRoot);
        List regions = this.getRegionsKeepOrder();
        HashSet remainingRegions = new HashSet(regions);
        HashMap<String, DefaultMutableTreeNode> nodeMap = new HashMap<String, DefaultMutableTreeNode>();
        int numR = regions.size();
        for (i = 0; i < numR; ++i) {
            regionID = (String)regions.get(i);
            if (!this.regionIsRoot(regionID)) continue;
            DefaultMutableTreeNode mtn = new DefaultMutableTreeNode(regionID);
            nodeMap.put(regionID, mtn);
            retval.insertNodeInto(mtn, treeRoot, treeRoot.getChildCount());
            remainingRegions.remove(regionID);
        }
        while (!remainingRegions.isEmpty()) {
            for (i = 0; i < numR; ++i) {
                String parent;
                MutableTreeNode parentNode;
                regionID = (String)regions.get(i);
                if (!remainingRegions.contains(regionID) || (parentNode = (MutableTreeNode)nodeMap.get(parent = this.getParentRegion(regionID))) == null) continue;
                DefaultMutableTreeNode mtn = new DefaultMutableTreeNode(regionID);
                nodeMap.put(regionID, mtn);
                retval.insertNodeInto(mtn, parentNode, parentNode.getChildCount());
                remainingRegions.remove(regionID);
            }
        }
        return retval;
    }

    public void addTemplateEntry(GeneTemplateEntry gte) {
        if (this.genes_.size() > 0) {
            throw new IllegalArgumentException();
        }
        this.initTemplate();
        this.geneTemplate_.add(gte);
    }

    public TimeCourseChange updateWithNewGeneTemplate(ArrayList newTemplate, ArrayList mapping) {
        int i;
        if (this.geneTemplate_ == null) {
            this.initTemplate();
        }
        ArrayList localTemplate = this.geneTemplate_;
        this.geneTemplate_ = null;
        this.initTemplate();
        boolean haveChange = false;
        int mapSize = mapping.size();
        if (mapSize != localTemplate.size()) {
            haveChange = true;
        } else {
            int contigIndex = 0;
            for (int i2 = 0; i2 < mapSize; ++i2) {
                GeneTemplateEntry newEntry;
                Integer mapEntry = (Integer)mapping.get(i2);
                if (mapEntry == null) {
                    haveChange = true;
                    break;
                }
                int mapVal = mapEntry;
                if (mapVal != contigIndex++) {
                    haveChange = true;
                    break;
                }
                GeneTemplateEntry oldEntry = (GeneTemplateEntry)localTemplate.get(mapVal);
                if (oldEntry.equals(newEntry = (GeneTemplateEntry)newTemplate.get(i2))) continue;
                haveChange = true;
                break;
            }
        }
        if (!haveChange) {
            return null;
        }
        TimeCourseChange retval = this.createFullUndo();
        ArrayList<TimeCourseGene> newGenes = new ArrayList<TimeCourseGene>();
        int size = this.genes_.size();
        for (i = 0; i < size; ++i) {
            newGenes.add(new TimeCourseGene((TimeCourseGene)this.genes_.get(i), false));
        }
        for (i = 0; i < mapSize; ++i) {
            GeneTemplateEntry newEntry = (GeneTemplateEntry)newTemplate.get(i);
            Integer mapEntry = (Integer)mapping.get(i);
            if (mapEntry == null) {
                for (int j = 0; j < size; ++j) {
                    TimeCourseGene newGene = (TimeCourseGene)newGenes.get(j);
                    newGene.addExpressionGlobally(i, new ExpressionEntry(newEntry.region, newEntry.time));
                }
                continue;
            }
            int mapVal = mapEntry;
            GeneTemplateEntry oldEntry = (GeneTemplateEntry)localTemplate.get(mapVal);
            boolean isSame = oldEntry.equals(newEntry);
            for (int j = 0; j < size; ++j) {
                TimeCourseGene newGene = (TimeCourseGene)newGenes.get(j);
                TimeCourseGene oldGene = (TimeCourseGene)this.genes_.get(j);
                newGene.mapExpressionGlobally(i, newEntry, mapVal, isSame, oldGene);
            }
        }
        this.genes_ = newGenes;
        this.geneTemplate_ = null;
        this.tempTemplate_ = this.copyTemplate(newTemplate);
        this.initTemplate();
        retval = this.finishFullUndo(retval);
        return retval;
    }

    public Set getDanglingRegionMaps(ArrayList newTemplate) {
        HashSet<String> haveRegions = new HashSet<String>();
        int size = newTemplate.size();
        for (int i = 0; i < size; ++i) {
            GeneTemplateEntry entry = (GeneTemplateEntry)newTemplate.get(i);
            haveRegions.add(entry.region);
        }
        HashSet<String> retval = new HashSet<String>();
        Iterator gmkit = this.groupMap_.keySet().iterator();
        while (gmkit.hasNext()) {
            String key = (String)gmkit.next();
            List mapList = (List)this.groupMap_.get(key);
            int mlsize = mapList.size();
            for (int i = 0; i < mlsize; ++i) {
                GroupUsage gu = (GroupUsage)mapList.get(i);
                if (haveRegions.contains(gu.mappedGroup)) continue;
                retval.add(key);
            }
        }
        return retval;
    }

    public TimeCourseChange[] repairDanglingRegionMaps(Set badMapKeys, ArrayList newTemplate) {
        HashSet<String> haveRegions = new HashSet<String>();
        int size = newTemplate.size();
        for (int i = 0; i < size; ++i) {
            GeneTemplateEntry entry = (GeneTemplateEntry)newTemplate.get(i);
            haveRegions.add(entry.region);
        }
        ArrayList<TimeCourseChange> retvalList = new ArrayList<TimeCourseChange>();
        Iterator bmkit = badMapKeys.iterator();
        while (bmkit.hasNext()) {
            String key = (String)bmkit.next();
            TimeCourseChange tcc = new TimeCourseChange(0, this.serialNumber_);
            retvalList.add(tcc);
            tcc.mapKey = key;
            List currentMap = (List)this.groupMap_.get(key);
            tcc.groupMapListOrig = this.deepCopyGroupMap(currentMap);
            int mSize = currentMap.size();
            ArrayList<GroupUsage> newMap = new ArrayList<GroupUsage>();
            for (int i = 0; i < mSize; ++i) {
                GroupUsage gu = (GroupUsage)currentMap.get(i);
                if (!haveRegions.contains(gu.mappedGroup)) continue;
                newMap.add(gu);
            }
            if (newMap.size() > 0) {
                this.groupMap_.put(key, newMap);
                tcc.groupMapListNew = this.deepCopyGroupMap(newMap);
            } else {
                this.groupMap_.remove(key);
                tcc.groupMapListNew = null;
            }
            tcc.baseSerialNumberNew = ++this.serialNumber_;
        }
        return retvalList.toArray(new TimeCourseChange[retvalList.size()]);
    }

    public PrunedHierarchy havePrunedHierarchy(ArrayList newTemplate) {
        if (this.groupParents_.isEmpty() && this.groupRoots_.isEmpty()) {
            return null;
        }
        Map regAndTimes = this.getRegionsWithMinTimes(newTemplate.iterator());
        HashSet templateRegions = new HashSet(regAndTimes.keySet());
        boolean haveHierChange = false;
        boolean rootAdd = false;
        Map newParents = new HashMap<String, String>();
        Iterator gpit = this.groupParents_.keySet().iterator();
        while (gpit.hasNext()) {
            String kid = (String)gpit.next();
            String parent = (String)this.groupParents_.get(kid);
            if (DataUtil.containsKey(templateRegions, kid) && DataUtil.containsKey(templateRegions, parent)) {
                newParents.put(kid, parent);
                continue;
            }
            haveHierChange = true;
        }
        HashSet<String> newRoots = new HashSet<String>();
        Iterator rit = this.groupRoots_.iterator();
        while (rit.hasNext()) {
            String root = (String)rit.next();
            if (DataUtil.containsKey(templateRegions, root)) {
                newRoots.add(root);
                continue;
            }
            haveHierChange = true;
        }
        Map prunedParents = this.templateBreaksHierarchy(regAndTimes, newParents);
        if (prunedParents != null) {
            newParents = prunedParents;
            haveHierChange = true;
        }
        HashSet hierRegs = new HashSet(newParents.keySet());
        hierRegs.addAll(newRoots);
        Iterator trit = templateRegions.iterator();
        while (trit.hasNext()) {
            String tReg = (String)trit.next();
            if (DataUtil.containsKey(hierRegs, tReg)) continue;
            newRoots.add(tReg);
            rootAdd = true;
        }
        if (haveHierChange || rootAdd) {
            PrunedHierarchy retval = new PrunedHierarchy();
            retval.parents = newParents;
            retval.roots = newRoots;
            retval.droppedParents = haveHierChange;
            return retval;
        }
        return null;
    }

    public Map templateBreaksHierarchy(Map regAndTimes, Map newParents) {
        HashMap<String, String> retval = new HashMap<String, String>();
        boolean pruned = false;
        Iterator npit = newParents.keySet().iterator();
        while (npit.hasNext()) {
            String kid = (String)npit.next();
            String parent = (String)newParents.get(kid);
            Integer parentMin = (Integer)regAndTimes.get(parent);
            Integer kidMin = (Integer)regAndTimes.get(kid);
            if (kidMin >= parentMin) {
                retval.put(kid, parent);
                continue;
            }
            pruned = true;
        }
        return pruned ? retval : null;
    }

    private void modifyTemplate(int index, GeneTemplateEntry newEntry, GeneTemplateEntry oldEntry) {
        int size = this.genes_.size();
        for (int i = 0; i < size; ++i) {
            TimeCourseGene gene = (TimeCourseGene)this.genes_.get(i);
            ExpressionEntry entry = gene.getExpression(index);
            if (entry.getTime() != oldEntry.time || !entry.getRegion().equals(oldEntry.region)) {
                System.err.println("entry: " + entry.getTime() + " " + entry.getRegion());
                System.err.println("old: " + oldEntry.time + " " + oldEntry.region);
                throw new IllegalStateException();
            }
            gene.updateExpression(index, newEntry);
        }
    }

    private TimeCourseChange createFullUndo() {
        TimeCourseChange tcc = new TimeCourseChange(0, this.serialNumber_);
        tcc.allGenesOrig = new ArrayList();
        int size = this.genes_.size();
        for (int i = 0; i < size; ++i) {
            TimeCourseGene gene = (TimeCourseGene)this.genes_.get(i);
            tcc.allGenesOrig.add(new TimeCourseGene(gene));
        }
        tcc.baseSerialNumberNew = ++this.serialNumber_;
        return tcc;
    }

    private TimeCourseChange finishFullUndo(TimeCourseChange tcc) {
        tcc.allGenesNew = new ArrayList();
        int size = this.genes_.size();
        for (int i = 0; i < size; ++i) {
            TimeCourseGene gene = (TimeCourseGene)this.genes_.get(i);
            tcc.allGenesNew.add(new TimeCourseGene(gene));
        }
        return tcc;
    }

    public TimeCourseGene getTimeCourseData(String targetName) {
        return this.getTimeCourseDataCaseInsensitive(targetName);
    }

    public int getFirstExpressionTime(String nodeID) {
        int retval = Integer.MAX_VALUE;
        String baseID = GenomeItemInstance.getBaseID(nodeID);
        List dataKeys = this.getTimeCourseTCMDataKeysWithDefault(baseID);
        Iterator dkit = dataKeys.iterator();
        while (dkit.hasNext()) {
            int min;
            TCMapping tcm = (TCMapping)dkit.next();
            TimeCourseGene tcg = this.getTimeCourseData(tcm.name);
            if (tcg == null || (min = tcg.getGlobalFirstExpression(tcm.channel)) >= retval) continue;
            retval = min;
        }
        return retval;
    }

    public TimeCourseGene getTimeCourseDataCaseInsensitive(String targetName) {
        Iterator trgit = this.genes_.iterator();
        while (trgit.hasNext()) {
            TimeCourseGene trg = (TimeCourseGene)trgit.next();
            if (!DataUtil.keysEqual(targetName, trg.getName())) continue;
            return trg;
        }
        return null;
    }

    public void getExpressedGenes(String region, int hour, int exprSource, Set expressed) {
        TimeCourseGene.VariableLevel varLev = new TimeCourseGene.VariableLevel();
        Iterator trgit = this.genes_.iterator();
        while (trgit.hasNext()) {
            TimeCourseGene trg = (TimeCourseGene)trgit.next();
            int expression = trg.getExpressionLevelForSource(region, hour, exprSource, varLev);
            if (expression == 3 || expression == 2) {
                expressed.add(trg.getName());
                continue;
            }
            if (expression != 4 || !(varLev.level > 0.0)) continue;
            expressed.add(trg.getName());
        }
    }

    public Set getGeneRegions(String geneID, int exprSource) {
        TimeCourseGene tcg = this.getTimeCourseDataCaseInsensitive(geneID);
        if (tcg != null) {
            return tcg.expressesInRegions(exprSource);
        }
        return null;
    }

    public String isRegionMarkerGene(String geneID, int exprSource) {
        TimeCourseGene tcg = this.getTimeCourseDataCaseInsensitive(geneID);
        if (tcg != null) {
            String regID = tcg.expressesInOnlyAndOnlyOneRegion(exprSource);
            return regID;
        }
        return null;
    }

    public Set getInterestingTimes() {
        HashSet retval = new HashSet();
        Iterator git = this.getGenes();
        while (git.hasNext()) {
            TimeCourseGene tg = (TimeCourseGene)git.next();
            tg.getInterestingTimes(retval);
        }
        return retval;
    }

    public int getMaximumTime() {
        int retval = 0;
        Iterator git = this.getGenes();
        while (git.hasNext()) {
            TimeCourseGene tg = (TimeCourseGene)git.next();
            int newMax = tg.getMaximumTime();
            if (newMax <= retval) continue;
            retval = newMax;
        }
        return retval;
    }

    public int getMinimumTime() {
        int retval = Integer.MAX_VALUE;
        Iterator git = this.getGenes();
        while (git.hasNext()) {
            TimeCourseGene tg = (TimeCourseGene)git.next();
            int newMin = tg.getMinimumTime();
            if (newMin >= retval) continue;
            retval = newMin;
        }
        return retval;
    }

    public TimeCourseChange addTimeCourseTCMMap(String key, List mapSets, boolean bumpSerial) {
        TimeCourseChange retval = null;
        if (mapSets != null && mapSets.size() > 0) {
            retval = new TimeCourseChange(0, this.serialNumber_);
            retval.mapKey = key;
            retval.mapListNew = TCMapping.cloneAList(mapSets);
            retval.mapListOrig = null;
            retval.baseSerialNumberNew = bumpSerial ? (this.serialNumber_ = this.serialNumber_ + 1L) : this.serialNumber_;
            this.tcMap_.put(key, mapSets);
        }
        return retval;
    }

    public TimeCourseChange[] changeTimeCourseMapsToName(String oldName, String newName) {
        ArrayList<TimeCourseChange> retvalList = new ArrayList<TimeCourseChange>();
        Iterator tmit = this.tcMap_.keySet().iterator();
        while (tmit.hasNext()) {
            String mkey = (String)tmit.next();
            List keys = (List)this.tcMap_.get(mkey);
            int numKeys = keys.size();
            for (int i = 0; i < numKeys; ++i) {
                TCMapping tcm = (TCMapping)keys.get(i);
                if (!DataUtil.keysEqual(tcm.name, oldName)) continue;
                TimeCourseChange retval = new TimeCourseChange(0, this.serialNumber_);
                retval.mapKey = mkey;
                retval.mapListOrig = TCMapping.cloneAList(keys);
                tcm.name = newName;
                retval.mapListNew = TCMapping.cloneAList(keys);
                retval.baseSerialNumberNew = ++this.serialNumber_;
                retvalList.add(retval);
            }
        }
        return retvalList.toArray(new TimeCourseChange[retvalList.size()]);
    }

    public TimeCourseChange[] changeName(String oldName, String newName) {
        ArrayList<TimeCourseChange> retvalList = new ArrayList<TimeCourseChange>();
        if (this.getTimeCourseData(newName) != null && !DataUtil.keysEqual(oldName, newName)) {
            throw new IllegalArgumentException();
        }
        TimeCourseGene gene = this.getTimeCourseData(oldName);
        if (gene != null) {
            TimeCourseChange tcc = this.startGeneUndoTransaction(oldName);
            gene.setName(newName);
            tcc = this.finishGeneUndoTransaction(newName, tcc);
            retvalList.add(tcc);
        }
        TimeCourseChange[] tccs = this.changeTimeCourseMapsToName(oldName, newName);
        retvalList.addAll(Arrays.asList(tccs));
        return retvalList.toArray(new TimeCourseChange[retvalList.size()]);
    }

    public TimeCourseChange[] changeRegionName(String oldName, String newName) {
        TimeCourseChange rtrn;
        ArrayList<TimeCourseChange> retvalList = new ArrayList<TimeCourseChange>();
        boolean haveChange = false;
        this.initTemplate();
        ArrayList newTemplate = this.copyTemplate(this.geneTemplate_);
        Iterator ntit = newTemplate.iterator();
        while (ntit.hasNext()) {
            GeneTemplateEntry gte = (GeneTemplateEntry)ntit.next();
            if (!DataUtil.keysEqual(gte.region, oldName)) continue;
            gte.region = newName;
            haveChange = true;
        }
        if (haveChange) {
            TimeCourseChange retval = this.createFullUndo();
            ArrayList<TimeCourseGene> newGenes = new ArrayList<TimeCourseGene>();
            int size = this.genes_.size();
            for (int i = 0; i < size; ++i) {
                TimeCourseGene oldGene = (TimeCourseGene)this.genes_.get(i);
                TimeCourseGene newGene = new TimeCourseGene(oldGene, false);
                newGenes.add(newGene);
                newGene.updateRegionGlobally(oldGene, oldName, newName);
            }
            this.genes_ = newGenes;
            this.geneTemplate_ = null;
            this.tempTemplate_ = newTemplate;
            this.initTemplate();
            retval = this.finishFullUndo(retval);
            retvalList.add(retval);
        }
        Iterator dmit = this.groupMap_.keySet().iterator();
        while (dmit.hasNext()) {
            String mkey = (String)dmit.next();
            List currentMap = (List)this.groupMap_.get(mkey);
            ArrayList<GroupUsage> newMap = new ArrayList<GroupUsage>();
            haveChange = false;
            int size = currentMap.size();
            for (int i = 0; i < size; ++i) {
                GroupUsage gu = (GroupUsage)currentMap.get(i);
                GroupUsage newgu = new GroupUsage(gu);
                if (DataUtil.keysEqual(gu.mappedGroup, oldName)) {
                    haveChange = true;
                    newgu.mappedGroup = newName;
                }
                newMap.add(newgu);
            }
            if (!haveChange) continue;
            TimeCourseChange tcc = new TimeCourseChange(0, this.serialNumber_);
            retvalList.add(tcc);
            tcc.mapKey = mkey;
            tcc.groupMapListOrig = this.deepCopyGroupMap(currentMap);
            this.groupMap_.put(mkey, newMap);
            tcc.groupMapListNew = this.deepCopyGroupMap(newMap);
            tcc.baseSerialNumberNew = ++this.serialNumber_;
        }
        boolean haveHierChange = false;
        HashMap<String, String> newParents = new HashMap<String, String>();
        Iterator gpit = this.groupParents_.keySet().iterator();
        while (gpit.hasNext()) {
            String kid = (String)gpit.next();
            String parent = (String)this.groupParents_.get(kid);
            if (DataUtil.keysEqual(oldName, kid)) {
                haveHierChange = true;
                kid = newName;
            }
            if (DataUtil.keysEqual(oldName, parent)) {
                haveHierChange = true;
                parent = newName;
            }
            newParents.put(kid, parent);
        }
        HashSet<String> newRoots = new HashSet<String>();
        Iterator rit = this.groupRoots_.iterator();
        while (rit.hasNext()) {
            String root = (String)rit.next();
            if (DataUtil.keysEqual(oldName, root)) {
                haveHierChange = true;
                root = newName;
            }
            newRoots.add(root);
        }
        if (haveHierChange) {
            TimeCourseChange htcc = this.setRegionHierarchy(newParents, newRoots, true);
            retvalList.add(htcc);
        }
        if ((rtrn = this.changeRegionTopologyRegionName(oldName, newName)) != null) {
            retvalList.add(rtrn);
        }
        return retvalList.toArray(new TimeCourseChange[retvalList.size()]);
    }

    public List getTimeCourseTCMDataKeysWithDefault(String nodeId) {
        ArrayList<TCMapping> retval = (ArrayList<TCMapping>)this.tcMap_.get(nodeId);
        if (retval == null || retval.size() == 0) {
            retval = new ArrayList<TCMapping>();
            Node node = Database.getDB().getGenome().getNode(nodeId);
            if (node == null) {
                throw new IllegalStateException();
            }
            String nodeName = node.getRootName();
            if (nodeName == null || nodeName.trim().equals("")) {
                return retval;
            }
            retval.add(new TCMapping(nodeName));
        }
        return retval;
    }

    public List getTimeCourseTCMDataKeysWithDefaultGivenName(String nodeId, String nodeName) {
        ArrayList<TCMapping> retval = (ArrayList<TCMapping>)this.tcMap_.get(nodeId);
        if (retval == null || retval.size() == 0) {
            retval = new ArrayList<TCMapping>();
            if (nodeName == null || nodeName.trim().equals("")) {
                return retval;
            }
            retval.add(new TCMapping(nodeName));
        }
        return retval;
    }

    public List getCustomTCMTimeCourseDataKeys(String nodeId) {
        return (List)this.tcMap_.get(nodeId);
    }

    public Set getTimeCourseDataKeyInverses(String name) {
        Set nodes;
        name = DataUtil.normKey(name);
        HashSet<String> retval = new HashSet<String>();
        DBGenome genome = (DBGenome)Database.getDB().getGenome();
        Node node = genome.getGeneWithName(name);
        if (node != null && !this.haveCustomMapForNode(node.getID())) {
            retval.add(node.getID());
        }
        if (!(nodes = genome.getNodesWithName(name)).isEmpty()) {
            Iterator sit = nodes.iterator();
            while (sit.hasNext()) {
                node = (Node)sit.next();
                if (this.haveCustomMapForNode(node.getID())) continue;
                retval.add(node.getID());
            }
        }
        Iterator kit = this.tcMap_.keySet().iterator();
        while (kit.hasNext()) {
            String key = (String)kit.next();
            List targs = (List)this.tcMap_.get(key);
            if (!TCMapping.nameInList(name, targs)) continue;
            retval.add(key);
        }
        return retval;
    }

    public TimeCourseChange setTimeCourseGroupMap(String key, List mapSets, boolean bumpSerial) {
        TimeCourseChange retval = new TimeCourseChange(0, this.serialNumber_);
        retval.mapKey = key;
        retval.groupMapListNew = this.deepCopyGroupMap(mapSets);
        retval.groupMapListOrig = this.deepCopyGroupMap((List)this.groupMap_.get(key));
        this.groupMap_.put(key, mapSets);
        retval.baseSerialNumberNew = bumpSerial ? (this.serialNumber_ = this.serialNumber_ + 1L) : this.serialNumber_;
        return retval;
    }

    public TimeCourseChange copyTimeCourseGroupMapForDuplicateGroup(String oldKey, String newKey, Map modelMap) {
        List oldMapList = (List)this.groupMap_.get(oldKey);
        if (oldMapList == null) {
            return null;
        }
        TimeCourseChange retval = new TimeCourseChange(0, this.serialNumber_);
        retval.mapKey = newKey;
        retval.groupMapListNew = this.deepCopyGroupMapMappingUsage(oldMapList, modelMap, oldKey.equals(newKey));
        retval.groupMapListOrig = null;
        this.groupMap_.put(newKey, this.deepCopyGroupMap(retval.groupMapListNew));
        retval.baseSerialNumberNew = ++this.serialNumber_;
        return retval;
    }

    private List deepCopyGroupMapMappingUsage(List oldMap, Map modelMaps, boolean append) {
        if (oldMap == null) {
            return null;
        }
        ArrayList<GroupUsage> retval = new ArrayList<GroupUsage>();
        int size = oldMap.size();
        for (int i = 0; i < size; ++i) {
            GroupUsage copied = (GroupUsage)((GroupUsage)oldMap.get(i)).clone();
            String modelID = (String)modelMaps.get(copied.usage);
            if (modelID != null) {
                if (append) {
                    retval.add(copied);
                    copied = (GroupUsage)copied.clone();
                }
                copied.usage = modelID;
            }
            retval.add(copied);
        }
        return retval;
    }

    private List deepCopyGroupMap(List oldMap) {
        if (oldMap == null) {
            return null;
        }
        ArrayList<Object> retval = new ArrayList<Object>();
        int size = oldMap.size();
        for (int i = 0; i < size; ++i) {
            retval.add(((GroupUsage)oldMap.get(i)).clone());
        }
        return retval;
    }

    public List getTimeCourseGroupKeysWithDefault(String groupId, String groupName) {
        ArrayList<GroupUsage> retval = (ArrayList<GroupUsage>)this.groupMap_.get(groupId);
        if (retval == null || retval.size() == 0) {
            retval = new ArrayList<GroupUsage>();
            if (groupName == null || groupName.trim().equals("")) {
                return retval;
            }
            retval.add(new GroupUsage(DataUtil.normKey(groupName), null));
        }
        return retval;
    }

    public List getCustomTimeCourseGroupKeys(String groupId) {
        return (List)this.groupMap_.get(groupId);
    }

    public Set getTimeCourseGroupKeyInverses(String name) {
        HashSet<String> retval = new HashSet<String>();
        Iterator kit = this.groupMap_.keySet().iterator();
        while (kit.hasNext()) {
            String key = (String)kit.next();
            List targs = (List)this.groupMap_.get(key);
            Iterator trit = targs.iterator();
            while (trit.hasNext()) {
                GroupUsage usage = (GroupUsage)trit.next();
                if (!usage.mappedGroup.equals(name)) continue;
                retval.add(key);
            }
        }
        return retval;
    }

    public TimeCourseChange[] dropGroupMapsForProxy(String proxyId) {
        ArrayList<TimeCourseChange> retvalList = new ArrayList<TimeCourseChange>();
        Iterator gmit = new HashSet(this.groupMap_.keySet()).iterator();
        while (gmit.hasNext()) {
            String key = (String)gmit.next();
            List currentMap = (List)this.groupMap_.get(key);
            int mSize = currentMap.size();
            ArrayList<GroupUsage> newMap = new ArrayList<GroupUsage>();
            for (int i = 0; i < mSize; ++i) {
                GroupUsage gu = (GroupUsage)currentMap.get(i);
                if (gu.usage != null && gu.usage.equals(proxyId)) continue;
                newMap.add(gu);
            }
            if (newMap.size() >= mSize) continue;
            TimeCourseChange tcc = new TimeCourseChange(0, this.serialNumber_);
            retvalList.add(tcc);
            tcc.mapKey = key;
            tcc.groupMapListOrig = this.deepCopyGroupMap(currentMap);
            if (newMap.size() > 0) {
                this.groupMap_.put(key, newMap);
                tcc.groupMapListNew = this.deepCopyGroupMap(newMap);
            } else {
                this.groupMap_.remove(key);
                tcc.groupMapListNew = null;
            }
            tcc.baseSerialNumberNew = ++this.serialNumber_;
        }
        return retvalList.toArray(new TimeCourseChange[retvalList.size()]);
    }

    public TimeCourseChange dropGroupMap(String groupId) {
        if (this.groupMap_.get(groupId) == null) {
            return null;
        }
        TimeCourseChange retval = new TimeCourseChange(0, this.serialNumber_);
        retval.mapKey = groupId;
        retval.groupMapListNew = null;
        retval.groupMapListOrig = this.deepCopyGroupMap((List)this.groupMap_.remove(groupId));
        retval.baseSerialNumberNew = ++this.serialNumber_;
        return retval;
    }

    public Iterator getGroupMapKeys() {
        return this.groupMap_.keySet().iterator();
    }

    public void dumpGroupMaps(PrintStream out) {
        Iterator kit = this.groupMap_.keySet().iterator();
        while (kit.hasNext()) {
            String giid = (String)kit.next();
            out.print(giid);
            out.print(":");
            List gm = (List)this.groupMap_.get(giid);
            if (gm == null) continue;
            out.println(gm);
        }
    }

    private void groupMapChangeUndo(TimeCourseChange undo) {
        if (undo.groupMapListOrig != null && undo.groupMapListNew != null) {
            this.groupMap_.put(undo.mapKey, undo.groupMapListOrig);
        } else if (undo.groupMapListOrig == null) {
            this.groupMap_.remove(undo.mapKey);
        } else {
            this.groupMap_.put(undo.mapKey, undo.groupMapListOrig);
        }
    }

    private void groupMapChangeRedo(TimeCourseChange undo) {
        if (undo.groupMapListOrig != null && undo.groupMapListNew != null) {
            this.groupMap_.put(undo.mapKey, undo.groupMapListNew);
        } else if (undo.groupMapListNew == null) {
            this.groupMap_.remove(undo.mapKey);
        } else {
            this.groupMap_.put(undo.mapKey, undo.groupMapListNew);
        }
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<TimeCourseData");
        if (this.serialNumber_ != 0L) {
            out.print(" serialNum=\"");
            out.print(this.serialNumber_);
            out.print("\"");
        }
        if (this.topoSerialNumber_ != 0L) {
            out.print(" topoSerialNum=\"");
            out.print(this.topoSerialNumber_);
            out.print("\"");
        }
        if (this.linSerialNumber_ != 0L) {
            out.print(" linSerialNum=\"");
            out.print(this.linSerialNumber_);
            out.print("\"");
        }
        out.println(">");
        if (this.genes_.size() > 0) {
            Iterator git = this.getGenes();
            ind.up();
            while (git.hasNext()) {
                TimeCourseGene tg = (TimeCourseGene)git.next();
                tg.writeXML(out, ind);
            }
            ind.down();
        } else if (this.hasGeneTemplate()) {
            ind.up();
            Iterator tempit = this.getGeneTemplate();
            TimeCourseGene tg = new TimeCourseGene("___Gene-For-BT-Template__", tempit, true);
            tg.writeXMLForTemplate(out, ind);
            ind.down();
        }
        if (this.tcMap_.size() > 0) {
            this.writeTcMap(out, ind);
        }
        if (this.groupMap_.size() > 0) {
            this.writeGroupMap(out, ind);
        }
        if (this.groupParents_.size() > 0 || this.groupRoots_.size() > 0) {
            this.writeHierarchy(out, ind);
        }
        if (this.regionTopologies_.size() > 0 || this.topoLocator_ != null) {
            this.writeTopology(out, ind);
        }
        ind.indent();
        out.println("</TimeCourseData>");
    }

    public String toString() {
        return "TimeCourseData:  genes = " + this.genes_;
    }

    public boolean nameIsUnique(String targName) {
        targName = targName.toUpperCase();
        Iterator git = this.getGenes();
        while (git.hasNext()) {
            TimeCourseGene tg = (TimeCourseGene)git.next();
            if (!tg.getName().toUpperCase().equals(targName)) continue;
            return false;
        }
        return true;
    }

    public List getRootInstanceSuggestions(int sliceType, Map neighbors) {
        switch (sliceType) {
            case 0: {
                return this.suggestTimeSlices();
            }
            case 1: {
                return this.suggestRegionSlices(neighbors);
            }
        }
        throw new IllegalArgumentException();
    }

    public SortedSet hoursForRegion(String regionID) {
        Iterator gtit = this.getGeneTemplate();
        TreeSet<Integer> allTimes = new TreeSet<Integer>();
        SortedSet<Integer> retval = new TreeSet<Integer>();
        while (gtit.hasNext()) {
            GeneTemplateEntry gte = (GeneTemplateEntry)gtit.next();
            Integer timeVal = new Integer(gte.time);
            allTimes.add(timeVal);
            String region = gte.region;
            if (!region.equals(regionID)) continue;
            retval.add(timeVal);
        }
        SortedSet bogoDownTimes = new TreeSet(retval);
        bogoDownTimes.add(allTimes.first());
        bogoDownTimes = DataUtil.fillOutHourly(bogoDownTimes);
        TreeSet bogoUpTimes = new TreeSet(allTimes);
        bogoUpTimes.removeAll(bogoDownTimes);
        if (!bogoUpTimes.isEmpty()) {
            Integer firstHigher = (Integer)bogoUpTimes.first();
            retval.add(new Integer(firstHigher - 1));
        }
        retval = DataUtil.fillOutHourly(retval);
        return retval;
    }

    private List suggestRegionSlices(Map neighbors) {
        ArrayList allTimes = new ArrayList(this.getInterestingTimes());
        Collections.sort(allTimes);
        int lastIndex = allTimes.size() - 1;
        Iterator gtit = this.getGeneTemplate();
        HashMap regionMap = new HashMap();
        while (gtit.hasNext()) {
            Integer timeVal;
            int myIndex;
            GeneTemplateEntry gte = (GeneTemplateEntry)gtit.next();
            String region = gte.region;
            TreeSet<Integer> hours = (TreeSet<Integer>)regionMap.get(region);
            if (hours == null) {
                hours = new TreeSet<Integer>();
                regionMap.put(region, hours);
            }
            int nextIndex = (myIndex = allTimes.indexOf(timeVal = new Integer(gte.time))) < lastIndex ? myIndex + 1 : myIndex;
            int decrement = myIndex < lastIndex ? 1 : 0;
            Integer nextTime = (Integer)allTimes.get(nextIndex);
            Integer nextToLast = new Integer(nextTime - decrement);
            hours.add(timeVal);
            hours.add(nextToLast);
        }
        TreeMap<Integer, ArrayList<RootInstanceSuggestions>> retvalMap = new TreeMap<Integer, ArrayList<RootInstanceSuggestions>>();
        Iterator rmit = regionMap.keySet().iterator();
        while (rmit.hasNext()) {
            String regKey = (String)rmit.next();
            TreeSet hours = (TreeSet)regionMap.get(regKey);
            Iterator hit = hours.iterator();
            RootInstanceSuggestions currRis = null;
            while (hit.hasNext()) {
                Integer hour = (Integer)hit.next();
                int hourVal = hour;
                if (currRis == null) {
                    ArrayList<Integer> times = new ArrayList<Integer>();
                    times.add(hour);
                    HashSet<String> regions = new HashSet<String>();
                    regions.add(regKey);
                    if (neighbors != null) {
                        regions.addAll((Set)neighbors.get(regKey));
                    }
                    currRis = new RootInstanceSuggestions(hourVal, hourVal, times, regions, regKey, false);
                    ArrayList<RootInstanceSuggestions> sugsForTime = (ArrayList<RootInstanceSuggestions>)retvalMap.get(hour);
                    if (sugsForTime == null) {
                        sugsForTime = new ArrayList<RootInstanceSuggestions>();
                        retvalMap.put(hour, sugsForTime);
                    }
                    sugsForTime.add(currRis);
                    continue;
                }
                currRis.times.add(hour);
                currRis.maxTime = hourVal;
            }
        }
        ArrayList retval = new ArrayList();
        Iterator rvmit = retvalMap.keySet().iterator();
        while (rvmit.hasNext()) {
            Integer minTime = (Integer)rvmit.next();
            ArrayList sugsForTime = (ArrayList)retvalMap.get(minTime);
            retval.addAll(sugsForTime);
        }
        return retval;
    }

    public List suggestTimeSlices() {
        ArrayList<RootInstanceSuggestions> retval = new ArrayList<RootInstanceSuggestions>();
        Iterator gtit = this.getGeneTemplate();
        TreeMap<Integer, HashSet<String>> hourMap = new TreeMap<Integer, HashSet<String>>();
        while (gtit.hasNext()) {
            GeneTemplateEntry gte = (GeneTemplateEntry)gtit.next();
            Integer timeKey = new Integer(gte.time);
            HashSet<String> regions = (HashSet<String>)hourMap.get(timeKey);
            if (regions == null) {
                regions = new HashSet<String>();
                hourMap.put(timeKey, regions);
            }
            regions.add(gte.region);
        }
        RootInstanceSuggestions currRis = null;
        Iterator hmit = hourMap.keySet().iterator();
        while (hmit.hasNext()) {
            Integer hourKey = (Integer)hmit.next();
            Set regions = (Set)hourMap.get(hourKey);
            int hourVal = hourKey;
            if (currRis == null || !((Object)currRis.regions).equals(regions)) {
                if (currRis != null) {
                    currRis.maxTime = hourVal - 1;
                    retval.add(currRis);
                }
                ArrayList<Integer> times = new ArrayList<Integer>();
                times.add(hourKey);
                currRis = new RootInstanceSuggestions(hourVal, hourVal, times, regions, null, true);
                continue;
            }
            currRis.times.add(hourKey);
            currRis.maxTime = hourVal;
        }
        if (currRis != null) {
            retval.add(currRis);
        }
        return retval;
    }

    List genRegionLineage(String groupID) {
        if (!this.hierarchyIsSetForRegion(groupID)) {
            throw new IllegalStateException();
        }
        ArrayList<TimeBoundedRegion> retval = new ArrayList<TimeBoundedRegion>();
        String currRegion = groupID;
        SortedSet currTimes = DataUtil.fillOutHourly(this.hoursForRegion(groupID));
        while (true) {
            retval.add(new TimeBoundedRegion(currTimes, currRegion));
            if (this.regionIsRoot(currRegion)) {
                return retval;
            }
            currRegion = this.getParentRegion(currRegion);
            SortedSet hfr = DataUtil.fillOutHourly(this.hoursForRegion(currRegion));
            int childMin = (Integer)currTimes.first();
            int parentMax = (Integer)hfr.last();
            for (int i = childMin; i <= parentMax; ++i) {
                hfr.remove(new Integer(i));
            }
            currTimes = hfr;
        }
    }

    public Set getRegionLineageDirectChildren(String groupID) {
        if (!this.hierarchyIsSetForRegion(groupID)) {
            throw new IllegalStateException();
        }
        HashSet<String> retval = new HashSet<String>();
        Iterator kit = this.groupParents_.keySet().iterator();
        while (kit.hasNext()) {
            String kidID = (String)kit.next();
            String parent = (String)this.groupParents_.get(kidID);
            if (!DataUtil.keysEqual(parent, groupID)) continue;
            retval.add(kidID);
        }
        return retval;
    }

    public static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("TimeCourseData");
        return retval;
    }

    public static TimeCourseData buildFromXML(String elemName, Attributes attrs, boolean serialNumberIsIllegal) throws IOException {
        if (!elemName.equals("TimeCourseData")) {
            return null;
        }
        String serialString = AttributeExtractor.extractAttribute(elemName, attrs, "TimeCourseData", "serialNum", false);
        String topoSerialString = AttributeExtractor.extractAttribute(elemName, attrs, "TimeCourseData", "topoSerialNum", false);
        String linSerialString = AttributeExtractor.extractAttribute(elemName, attrs, "TimeCourseData", "linSerialNum", false);
        if (serialNumberIsIllegal && (serialString != null || topoSerialString != null || linSerialString != null)) {
            throw new IOException();
        }
        TimeCourseData retval = new TimeCourseData();
        try {
            if (serialString != null) {
                long serialNumber = Long.parseLong(serialString);
                if (serialNumber < 0L) {
                    throw new IOException();
                }
                retval.serialNumber_ = serialNumber;
            }
            if (topoSerialString != null) {
                long topoSerialNumber = Long.parseLong(topoSerialString);
                if (topoSerialNumber < 0L) {
                    throw new IOException();
                }
                retval.topoSerialNumber_ = topoSerialNumber;
            }
            if (linSerialString != null) {
                long linSerialNumber = Long.parseLong(linSerialString);
                if (linSerialNumber < 0L) {
                    throw new IOException();
                }
                retval.linSerialNumber_ = linSerialNumber;
            }
        }
        catch (NumberFormatException ex) {
            throw new IOException();
        }
        return retval;
    }

    public static String extractTcMapKey(String elemName, Attributes attrs) throws IOException {
        return AttributeExtractor.extractAttribute(elemName, attrs, "tcMap", "key", true);
    }

    public static TCMapping extractTCMapping(String elemName, Attributes attrs) throws IOException {
        int source;
        String name = AttributeExtractor.extractAttribute(elemName, attrs, "useTc", "name", true);
        String srcString = AttributeExtractor.extractAttribute(elemName, attrs, "useTc", "src", false);
        if (srcString == null) {
            source = 0;
        } else {
            srcString = srcString.trim();
            try {
                source = ExpressionEntry.mapFromSourceTag(srcString);
            }
            catch (IllegalArgumentException iaex) {
                throw new IOException();
            }
        }
        return new TCMapping(name, source);
    }

    public static String extractGroupMapKey(String elemName, Attributes attrs) throws IOException {
        return AttributeExtractor.extractAttribute(elemName, attrs, "tcGroupMap", "key", true);
    }

    public static GroupUsage extractUseGroup(String elemName, Attributes attrs) throws IOException {
        String mappedGroup = AttributeExtractor.extractAttribute(elemName, attrs, "useGroup", "name", true);
        String usage = AttributeExtractor.extractAttribute(elemName, attrs, "useGroup", "useFor", false);
        return new GroupUsage(mappedGroup, usage);
    }

    public static String extractRootRegion(String elemName, Attributes attrs) throws IOException {
        return AttributeExtractor.extractAttribute(elemName, attrs, "tcRootRegion", "name", true);
    }

    public static void extractRegionParent(String elemName, Attributes attrs, Map targetMap) throws IOException {
        String region = AttributeExtractor.extractAttribute(elemName, attrs, "tcRegionParent", "region", true);
        String parent = AttributeExtractor.extractAttribute(elemName, attrs, "tcRegionParent", "parent", true);
        targetMap.put(region, parent);
    }

    public static String tcMapKeyword() {
        return "tcMap";
    }

    public static String useTcKeyword() {
        return "useTc";
    }

    public static String groupMapKeyword() {
        return "tcGroupMap";
    }

    public static String useGroupKeyword() {
        return "useGroup";
    }

    public static String rootRegionKeyword() {
        return "tcRootRegion";
    }

    public static String regionParentKeyword() {
        return "tcRegionParent";
    }

    public static String regionHierarchyKeyword() {
        return "tcRegionHierarchy";
    }

    private void writeTcMap(PrintWriter out, Indenter ind) {
        ind.up().indent();
        out.println("<tcMaps>");
        TreeSet sorted = new TreeSet();
        sorted.addAll(this.tcMap_.keySet());
        Iterator mapKeys = sorted.iterator();
        ind.up();
        while (mapKeys.hasNext()) {
            String key = (String)mapKeys.next();
            List list = (List)this.tcMap_.get(key);
            ind.indent();
            out.print("<tcMap key=\"");
            out.print(key);
            out.println("\">");
            Iterator lit = list.iterator();
            ind.up();
            while (lit.hasNext()) {
                TCMapping usetc = (TCMapping)lit.next();
                ind.indent();
                out.print("<useTc name=\"");
                out.print(usetc.name);
                if (usetc.channel != 0) {
                    out.print("\" src=\"");
                    out.print(ExpressionEntry.mapToSourceTag(usetc.channel));
                }
                out.println("\"/>");
            }
            ind.down().indent();
            out.println("</tcMap>");
        }
        ind.down().indent();
        out.println("</tcMaps>");
        ind.down();
    }

    private void writeGroupMap(PrintWriter out, Indenter ind) {
        ind.up().indent();
        out.println("<tcGroupMaps>");
        TreeSet sorted = new TreeSet();
        sorted.addAll(this.groupMap_.keySet());
        Iterator mapKeys = sorted.iterator();
        ind.up();
        while (mapKeys.hasNext()) {
            String key = (String)mapKeys.next();
            List list = (List)this.groupMap_.get(key);
            ind.indent();
            out.print("<tcGroupMap key=\"");
            out.print(key);
            out.println("\">");
            Iterator lit = list.iterator();
            ind.up();
            while (lit.hasNext()) {
                GroupUsage usegr = (GroupUsage)lit.next();
                ind.indent();
                out.print("<useGroup name=\"");
                out.print(usegr.mappedGroup);
                if (usegr.usage != null) {
                    out.print("\" useFor=\"");
                    out.print(usegr.usage);
                }
                out.println("\"/>");
            }
            ind.down().indent();
            out.println("</tcGroupMap>");
        }
        ind.down().indent();
        out.println("</tcGroupMaps>");
        ind.down();
    }

    private void writeHierarchy(PrintWriter out, Indenter ind) {
        String key;
        ind.up().indent();
        out.println("<tcRegionHierarchy>");
        ind.up();
        TreeSet<Object> sorted = new TreeSet(this.groupRoots_);
        Iterator<Object> srit = sorted.iterator();
        while (srit.hasNext()) {
            key = (String)srit.next();
            ind.indent();
            out.print("<tcRootRegion name=\"");
            out.print(key);
            out.println("\" />");
        }
        sorted = new TreeSet(this.groupParents_.keySet());
        srit = sorted.iterator();
        while (srit.hasNext()) {
            key = (String)srit.next();
            String parent = (String)this.groupParents_.get(key);
            ind.indent();
            out.print("<tcRegionParent region=\"");
            out.print(key);
            out.print("\" parent=\"");
            out.print(parent);
            out.println("\" />");
        }
        ind.down().indent();
        out.println("</tcRegionHierarchy>");
        ind.down();
    }

    private void writeTopology(PrintWriter out, Indenter ind) {
        ind.up().indent();
        out.println("<tcRegionTopologyData>");
        ind.up();
        Iterator rtit = this.regionTopologies_.keySet().iterator();
        ind.indent();
        out.println("<tcRegionTopologies>");
        ind.up();
        while (rtit.hasNext()) {
            TopoTimeRange key = (TopoTimeRange)rtit.next();
            RegionTopology rt = (RegionTopology)this.regionTopologies_.get(key);
            rt.writeXML(out, ind);
        }
        ind.down().indent();
        out.println("</tcRegionTopologies>");
        if (this.topoLocator_ != null) {
            this.topoLocator_.writeXML(out, ind);
        }
        ind.down().indent();
        out.println("</tcRegionTopologyData>");
        ind.down();
    }

    public static class TemplateComparator
    implements Comparator {
        private boolean groupByTime_;
        private HashMap regionOrder_;

        public TemplateComparator(boolean groupByTime, Iterator tempit) {
            this.groupByTime_ = groupByTime;
            this.regionOrder_ = new HashMap();
            int count = 0;
            while (tempit.hasNext()) {
                GeneTemplateEntry gte = (GeneTemplateEntry)tempit.next();
                String normKey = DataUtil.normKey(gte.region);
                Integer orderNum = (Integer)this.regionOrder_.get(normKey);
                if (orderNum != null) continue;
                orderNum = new Integer(count++);
                this.regionOrder_.put(normKey, orderNum);
            }
        }

        public int compare(Object o1, Object o2) {
            GeneTemplateEntry gte1 = (GeneTemplateEntry)o1;
            GeneTemplateEntry gte2 = (GeneTemplateEntry)o2;
            int ro1 = (Integer)this.regionOrder_.get(DataUtil.normKey(gte1.region));
            int ro2 = (Integer)this.regionOrder_.get(DataUtil.normKey(gte2.region));
            if (this.groupByTime_) {
                if (gte1.time != gte2.time) {
                    return gte1.time - gte2.time;
                }
                return ro1 - ro2;
            }
            if (ro1 != ro2) {
                return ro1 - ro2;
            }
            return gte1.time - gte2.time;
        }
    }

    public static class PrunedHierarchy {
        public Map parents;
        public Set roots;
        public boolean droppedParents;
    }

    public static class TCMapping
    implements Cloneable,
    Comparable {
        public String name;
        public int channel;

        public TCMapping(String name) {
            this.name = name;
            this.channel = 0;
        }

        public TCMapping(String name, int channel) {
            this.name = name;
            this.channel = channel;
        }

        public Object clone() {
            try {
                TCMapping retval = (TCMapping)super.clone();
                return retval;
            }
            catch (CloneNotSupportedException cnse) {
                throw new IllegalStateException();
            }
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof TCMapping)) {
                return false;
            }
            TCMapping otherTCM = (TCMapping)other;
            if (!DataUtil.keysEqual(this.name, otherTCM.name)) {
                return false;
            }
            return this.channel == otherTCM.channel;
        }

        public String toString() {
            return this.name + (this.channel != 0 ? ": " + ExpressionEntry.mapToSourceTag(this.channel) : "");
        }

        public int hashCode() {
            return DataUtil.normKey(this.name).hashCode() + this.channel;
        }

        public static ArrayList cloneAList(List toClone) {
            ArrayList<Object> retval = new ArrayList<Object>();
            int num = toClone.size();
            for (int i = 0; i < num; ++i) {
                TCMapping tcm = (TCMapping)toClone.get(i);
                retval.add(tcm.clone());
            }
            return retval;
        }

        public int compareTo(Object o) {
            if (this == o) {
                return 0;
            }
            TCMapping other = (TCMapping)o;
            int retval = this.name.compareTo(other.name);
            if (retval != 0) {
                return retval;
            }
            return this.channel - other.channel;
        }

        public static boolean nameInList(String name, List toCheck) {
            int num = toCheck.size();
            for (int i = 0; i < num; ++i) {
                TCMapping tcm = (TCMapping)toCheck.get(i);
                if (!DataUtil.keysEqual(name, tcm.name)) continue;
                return true;
            }
            return false;
        }
    }

    public static class TopoRegionLoc
    implements Cloneable {
        public String regionID;
        public Point2D center;
        public static final String XML_TAG = "tcTopoRegionLoc";

        public TopoRegionLoc(String regionID, Point2D center) {
            this.regionID = regionID;
            this.center = new Point2D.Double(Math.round(center.getX()), Math.round(center.getY()));
        }

        public Object clone() {
            try {
                TopoRegionLoc retval = (TopoRegionLoc)super.clone();
                retval.center = (Point2D)this.center.clone();
                return retval;
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalStateException();
            }
        }

        public void writeXML(PrintWriter out, Indenter ind) {
            ind.indent();
            out.print("<");
            out.print(XML_TAG);
            out.print(" region=\"");
            out.print(this.regionID);
            out.print("\" x=\"");
            out.print(this.center.getX());
            out.print("\" y=\"");
            out.print(this.center.getY());
            out.println("\" />");
        }

        public static TopoRegionLoc buildFromXML(String elemName, Attributes attrs) throws IOException {
            double yVal;
            double xVal;
            String region = AttributeExtractor.extractAttribute(elemName, attrs, XML_TAG, "region", true);
            String xStr = AttributeExtractor.extractAttribute(elemName, attrs, XML_TAG, "x", true);
            String yStr = AttributeExtractor.extractAttribute(elemName, attrs, XML_TAG, "y", true);
            try {
                xVal = Double.parseDouble(xStr);
                yVal = Double.parseDouble(yStr);
            }
            catch (NumberFormatException nfex) {
                throw new IOException();
            }
            Point2D.Double center = new Point2D.Double(xVal, yVal);
            return new TopoRegionLoc(region, center);
        }
    }

    public static class TopoRegionLocator
    implements Cloneable {
        private HashMap regionTopoLocs_ = new HashMap();

        public TopoRegionLocator() {
        }

        public TopoRegionLocator(TimeCourseData tcd) {
            Iterator timeit = tcd.getRegionTopologyTimes();
            while (timeit.hasNext()) {
                TopoTimeRange ttr = (TopoTimeRange)timeit.next();
                RegionTopology regTopo = tcd.getRegionTopology(ttr);
                TopoTimeRange tRange = regTopo.times;
                HashMap locsPerRange = this.initializeTopoLocData(regTopo, tRange);
                this.regionTopoLocs_.put(tRange, locsPerRange);
            }
        }

        public Iterator getRegionTopologyTimes() {
            return new TreeSet(this.regionTopoLocs_.keySet()).iterator();
        }

        public TopoRegionLocator changeRegionNameOnMatch(String oldName, String newName) {
            HashMap newMap = new HashMap();
            Iterator it = this.regionTopoLocs_.keySet().iterator();
            while (it.hasNext()) {
                TopoTimeRange range = (TopoTimeRange)it.next();
                HashMap locsPerRange = (HashMap)this.regionTopoLocs_.get(range);
                HashMap<String, TopoRegionLoc> newLocsPerRange = new HashMap<String, TopoRegionLoc>();
                newMap.put(range, newLocsPerRange);
                Iterator rit = locsPerRange.keySet().iterator();
                while (rit.hasNext()) {
                    String regionID = (String)rit.next();
                    TopoRegionLoc loc = (TopoRegionLoc)locsPerRange.get(regionID);
                    TopoRegionLoc locClo = (TopoRegionLoc)loc.clone();
                    if (DataUtil.keysEqual(regionID, oldName)) {
                        locClo.regionID = newName;
                        newLocsPerRange.put(newName, locClo);
                        continue;
                    }
                    newLocsPerRange.put(regionID, locClo);
                }
            }
            TopoRegionLocator retval = new TopoRegionLocator();
            retval.regionTopoLocs_ = newMap;
            return retval;
        }

        public TopoRegionLocator dropRegionName(String dropName) {
            HashMap newMap = new HashMap();
            Iterator it = this.regionTopoLocs_.keySet().iterator();
            while (it.hasNext()) {
                TopoTimeRange range = (TopoTimeRange)it.next();
                HashMap locsPerRange = (HashMap)this.regionTopoLocs_.get(range);
                HashMap<String, TopoRegionLoc> newLocsPerRange = new HashMap<String, TopoRegionLoc>();
                newMap.put(range, newLocsPerRange);
                Iterator rit = locsPerRange.keySet().iterator();
                while (rit.hasNext()) {
                    String regionID = (String)rit.next();
                    TopoRegionLoc loc = (TopoRegionLoc)locsPerRange.get(regionID);
                    if (DataUtil.keysEqual(regionID, dropName)) continue;
                    TopoRegionLoc locClo = (TopoRegionLoc)loc.clone();
                    newLocsPerRange.put(regionID, locClo);
                }
            }
            TopoRegionLocator retval = new TopoRegionLocator();
            retval.regionTopoLocs_ = newMap;
            return retval;
        }

        public Object clone() {
            try {
                TopoRegionLocator retval = (TopoRegionLocator)super.clone();
                retval.regionTopoLocs_ = new HashMap();
                Iterator it = this.regionTopoLocs_.keySet().iterator();
                while (it.hasNext()) {
                    TopoTimeRange range = (TopoTimeRange)it.next();
                    HashMap locsPerRange = (HashMap)this.regionTopoLocs_.get(range);
                    if (locsPerRange == null) continue;
                    HashMap<String, Object> retLocPerRange = new HashMap<String, Object>();
                    Iterator rit = locsPerRange.keySet().iterator();
                    while (rit.hasNext()) {
                        String regionID = (String)rit.next();
                        TopoRegionLoc loc = (TopoRegionLoc)locsPerRange.get(regionID);
                        retLocPerRange.put(regionID, loc.clone());
                    }
                    retval.regionTopoLocs_.put(range.clone(), retLocPerRange);
                }
                return retval;
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalStateException();
            }
        }

        public Point2D getRegionTopologyLocation(TopoTimeRange range, String regionID) {
            HashMap locsPerRange = (HashMap)this.regionTopoLocs_.get(range);
            TopoRegionLoc loc = (TopoRegionLoc)locsPerRange.get(regionID);
            return loc.center;
        }

        public void setRegionTopologyLocation(TopoTimeRange range, String regionID, Point2D point) {
            HashMap locsPerRange = (HashMap)this.regionTopoLocs_.get(range);
            TopoRegionLoc loc = (TopoRegionLoc)locsPerRange.get(regionID);
            loc.center = new Point2D.Double(Math.round(point.getX()), Math.round(point.getY()));
        }

        public void setRegionTopologyLocation(TopoTimeRange range, TopoRegionLoc loc) {
            HashMap<String, TopoRegionLoc> locsPerRange = (HashMap<String, TopoRegionLoc>)this.regionTopoLocs_.get(range);
            if (locsPerRange == null) {
                locsPerRange = new HashMap<String, TopoRegionLoc>();
                this.regionTopoLocs_.put(range, locsPerRange);
            }
            locsPerRange.put(loc.regionID, loc);
        }

        public void transferTopologyLocations(TopoRegionLocator other, TopoTimeRange otherRange, TopoTimeRange newRange) {
            HashMap locsPerRange = (HashMap)other.regionTopoLocs_.get(otherRange);
            if (locsPerRange != null) {
                HashMap<String, Object> retLocPerRange = new HashMap<String, Object>();
                Iterator rit = locsPerRange.keySet().iterator();
                while (rit.hasNext()) {
                    String regionID = (String)rit.next();
                    TopoRegionLoc loc = (TopoRegionLoc)locsPerRange.get(regionID);
                    retLocPerRange.put(regionID, loc.clone());
                }
                this.regionTopoLocs_.put(newRange, retLocPerRange);
            }
        }

        public void writeXML(PrintWriter out, Indenter ind) {
            ind.indent();
            out.println("<tcTopoRegionLocations>");
            ind.up();
            Iterator it = new TreeSet(this.regionTopoLocs_.keySet()).iterator();
            while (it.hasNext()) {
                TopoTimeRange range = (TopoTimeRange)it.next();
                HashMap locsPerRange = (HashMap)this.regionTopoLocs_.get(range);
                Iterator rit = locsPerRange.keySet().iterator();
                range.writeXMLOpen("topoLocationsForRange", out, ind);
                ind.up();
                while (rit.hasNext()) {
                    String regionID = (String)rit.next();
                    TopoRegionLoc loc = (TopoRegionLoc)locsPerRange.get(regionID);
                    loc.writeXML(out, ind);
                }
                ind.down();
                range.writeXMLClose("topoLocationsForRange", out, ind);
            }
            ind.down().indent();
            out.println("</tcTopoRegionLocations>");
        }

        private HashMap initializeTopoLocData(RegionTopology rt, TopoTimeRange ttr) {
            HashMap<String, TopoRegionLoc> retval = new HashMap<String, TopoRegionLoc>();
            int num = rt.regions.size();
            int numSide = (int)Math.ceil(Math.sqrt(num));
            double firstX = -300.0 * (double)(numSide / 2);
            double firstY = -300.0 * (double)(numSide / 2);
            for (int i = 0; i < num; ++i) {
                String regionID = (String)rt.regions.get(i);
                int col = i % numSide;
                int row = i / numSide;
                double x = firstX + (double)col * 300.0;
                double y = firstY + (double)row * 300.0;
                Point2D.Double center = new Point2D.Double(x, y);
                TopoRegionLoc loc = new TopoRegionLoc(regionID, center);
                retval.put(regionID, loc);
            }
            return retval;
        }
    }

    public static class TopoLink
    implements Cloneable {
        public String region1;
        public String region2;
        public static final String XML_TAG = "tcTopoLink";

        public TopoLink(String region1, String region2) {
            this.region1 = region1;
            this.region2 = region2;
        }

        public Object clone() {
            try {
                TopoLink retval = (TopoLink)super.clone();
                return retval;
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalStateException();
            }
        }

        public int hashCode() {
            return this.region1.hashCode() + this.region2.hashCode();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof TopoLink)) {
                return false;
            }
            TopoLink otherTL = (TopoLink)other;
            return this.region1.equals(otherTL.region1) && this.region2.equals(otherTL.region2);
        }

        public void writeXML(PrintWriter out, Indenter ind) {
            ind.indent();
            out.print("<");
            out.print(XML_TAG);
            out.print(" reg1=\"");
            out.print(this.region1);
            out.print("\" reg2=\"");
            out.print(this.region2);
            out.println("\"/>");
        }

        public static TopoLink buildFromXML(String elemName, Attributes attrs) throws IOException {
            String reg1 = AttributeExtractor.extractAttribute(elemName, attrs, XML_TAG, "reg1", true);
            String reg2 = AttributeExtractor.extractAttribute(elemName, attrs, XML_TAG, "reg2", true);
            return new TopoLink(reg1, reg2);
        }
    }

    public static class TopoTimeRange
    implements Cloneable,
    Comparable {
        public int minTime;
        public int maxTime;
        public static final String XML_TAG_TOPO = "tcRegionTopology";
        public static final String XML_TAG_LOC = "topoLocationsForRange";

        public TopoTimeRange(int minTime, int maxTime) {
            if (minTime > maxTime) {
                throw new IllegalArgumentException();
            }
            this.minTime = minTime;
            this.maxTime = maxTime;
        }

        public SortedSet rangeAsHourly() {
            SortedSet<Integer> retval = new TreeSet<Integer>();
            retval.add(new Integer(this.minTime));
            retval.add(new Integer(this.maxTime));
            retval = DataUtil.fillOutHourly(retval);
            return retval;
        }

        public Object clone() {
            try {
                TopoTimeRange retval = (TopoTimeRange)super.clone();
                return retval;
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalStateException();
            }
        }

        public int compareTo(Object o) {
            TopoTimeRange other = (TopoTimeRange)o;
            if (this.minTime != other.minTime) {
                return this.minTime - other.minTime;
            }
            return this.maxTime - other.maxTime;
        }

        public int hashCode() {
            return this.minTime + this.maxTime;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof TopoTimeRange)) {
                return false;
            }
            return this.compareTo(other) == 0;
        }

        public String toString() {
            String maxStr;
            String minStr;
            TimeAxisDefinition tad = Database.getDB().getTimeAxisDefinition();
            if (tad.haveNamedStages()) {
                minStr = tad.getNamedStageForIndex((int)this.minTime).name;
                maxStr = tad.getNamedStageForIndex((int)this.maxTime).name;
            } else {
                minStr = Integer.toString(this.minTime);
                maxStr = Integer.toString(this.maxTime);
            }
            ResourceManager rMan = ResourceManager.getManager();
            String format = tad.unitsAreASuffix() ? rMan.getString("timeRange.format") : rMan.getString("timeRange.formatPrefix");
            String displayUnits = tad.unitDisplayAbbrev();
            String desc = MessageFormat.format(format, minStr, maxStr, displayUnits);
            return desc;
        }

        public void writeXMLOpen(String tag, PrintWriter out, Indenter ind) {
            ind.indent();
            out.print("<");
            out.print(tag);
            out.print(" min=\"");
            out.print(this.minTime);
            out.print("\" max=\"");
            out.print(this.maxTime);
            out.println("\">");
        }

        public void writeXMLClose(String tag, PrintWriter out, Indenter ind) {
            ind.indent();
            out.print("</");
            out.print(tag);
            out.println(">");
        }

        public static TopoTimeRange buildFromXML(String elemName, Attributes attrs) throws IOException {
            int maxTime;
            int minTime;
            if (!elemName.equals(XML_TAG_TOPO) && !elemName.equals(XML_TAG_LOC)) {
                return null;
            }
            String minTimeStr = null;
            String maxTimeStr = null;
            if (attrs != null) {
                int count = attrs.getLength();
                for (int i = 0; i < count; ++i) {
                    String key = attrs.getQName(i);
                    if (key == null) continue;
                    String val = attrs.getValue(i);
                    if (key.equals("min")) {
                        minTimeStr = val;
                        continue;
                    }
                    if (!key.equals("max")) continue;
                    maxTimeStr = val;
                }
            }
            try {
                minTime = Integer.parseInt(minTimeStr);
                maxTime = Integer.parseInt(maxTimeStr);
                if (minTime < 0 || maxTime < 0) {
                    throw new IOException();
                }
            }
            catch (NumberFormatException nfex) {
                throw new IOException();
            }
            return new TopoTimeRange(minTime, maxTime);
        }
    }

    public static class RegionTopology
    implements Cloneable {
        public TopoTimeRange times;
        public List regions;
        public List links;
        public static final String XML_TOPO_REGION_TAG = "tcTopoRegion";

        public RegionTopology(TopoTimeRange times) {
            this.times = times;
            this.regions = new ArrayList();
            this.links = new ArrayList();
        }

        public RegionTopology(TopoTimeRange times, List regions, List links) {
            this.times = times;
            this.regions = regions;
            this.links = links;
        }

        public RegionTopology changeRegionNameOnMatch(String oldName, String newName) {
            RegionTopology retval = new RegionTopology(this.times);
            int numReg = this.regions.size();
            for (int i = 0; i < numReg; ++i) {
                String region = (String)this.regions.get(i);
                if (DataUtil.keysEqual(region, oldName)) {
                    retval.regions.add(newName);
                    continue;
                }
                retval.regions.add(region);
            }
            int numLinks = this.links.size();
            for (int i = 0; i < numLinks; ++i) {
                TopoLink link = (TopoLink)this.links.get(i);
                TopoLink lc = (TopoLink)link.clone();
                if (DataUtil.keysEqual(lc.region1, oldName)) {
                    lc.region1 = newName;
                }
                if (DataUtil.keysEqual(lc.region2, oldName)) {
                    lc.region2 = newName;
                }
                retval.links.add(lc);
            }
            return retval;
        }

        public boolean hasRegionName(Set checkNames) {
            int numReg = this.regions.size();
            for (int i = 0; i < numReg; ++i) {
                String region = (String)this.regions.get(i);
                if (!DataUtil.containsKey(checkNames, region)) continue;
                return true;
            }
            int numLinks = this.links.size();
            for (int i = 0; i < numLinks; ++i) {
                TopoLink link = (TopoLink)this.links.get(i);
                if (!DataUtil.containsKey(checkNames, link.region1) && !DataUtil.containsKey(checkNames, link.region2)) continue;
                return true;
            }
            return false;
        }

        public RegionTopology dropRegionName(String dropName) {
            RegionTopology retval = new RegionTopology(this.times);
            int numReg = this.regions.size();
            for (int i = 0; i < numReg; ++i) {
                String region = (String)this.regions.get(i);
                if (DataUtil.keysEqual(region, dropName)) continue;
                retval.regions.add(region);
            }
            int numLinks = this.links.size();
            for (int i = 0; i < numLinks; ++i) {
                TopoLink link = (TopoLink)this.links.get(i);
                if (DataUtil.keysEqual(link.region1, dropName) || DataUtil.keysEqual(link.region2, dropName)) continue;
                TopoLink lc = (TopoLink)link.clone();
                retval.links.add(lc);
            }
            return retval;
        }

        public void addRegion(String newRegion) {
            this.regions.add(newRegion);
        }

        public void addLink(TopoLink newLink) {
            this.links.add(newLink);
        }

        public Iterator getLinks() {
            return this.links.iterator();
        }

        public boolean hasLink(TopoLink link) {
            return this.links.contains(link);
        }

        public void removeLink(TopoLink link) {
            this.links.remove(link);
        }

        public Object clone() {
            try {
                RegionTopology retval = (RegionTopology)super.clone();
                retval.times = (TopoTimeRange)this.times.clone();
                retval.regions = new ArrayList(this.regions);
                retval.links = new ArrayList();
                int numL = this.links.size();
                for (int i = 0; i < numL; ++i) {
                    TopoLink tl = (TopoLink)this.links.get(i);
                    retval.links.add(tl.clone());
                }
                return retval;
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalStateException();
            }
        }

        public void writeXML(PrintWriter out, Indenter ind) {
            this.times.writeXMLOpen("tcRegionTopology", out, ind);
            int numReg = this.regions.size();
            ind.up().indent();
            out.println("<tcTopoRegions>");
            ind.up();
            for (int i = 0; i < numReg; ++i) {
                ind.indent();
                out.print("<");
                out.print(XML_TOPO_REGION_TAG);
                out.print(" name=\"");
                out.print((String)this.regions.get(i));
                out.println("\"/>");
            }
            ind.down().indent();
            out.println("</tcTopoRegions>");
            int numLinks = this.links.size();
            if (numLinks > 0) {
                ind.indent();
                out.println("<tcTopoLinks>");
                ind.up();
                for (int i = 0; i < numLinks; ++i) {
                    TopoLink link = (TopoLink)this.links.get(i);
                    link.writeXML(out, ind);
                }
                ind.down().indent();
                out.println("</tcTopoLinks>");
            }
            ind.down();
            this.times.writeXMLClose("tcRegionTopology", out, ind);
        }

        public static String buildRegionFromXML(String elemName, Attributes attrs) throws IOException {
            String regName = AttributeExtractor.extractAttribute(elemName, attrs, XML_TOPO_REGION_TAG, "name", true);
            return regName;
        }
    }

    public static class RootInstanceSuggestions {
        public int minTime;
        public int maxTime;
        public List times;
        public Set regions;
        public String mainRegion;
        public boolean timeSliced;

        public RootInstanceSuggestions(int minTime, int maxTime, List times, Set regions, String mainRegion, boolean timeSliced) {
            this.minTime = minTime;
            this.maxTime = maxTime;
            this.regions = regions;
            this.mainRegion = mainRegion;
            this.times = times;
            this.timeSliced = timeSliced;
        }

        public String toString() {
            if (this.timeSliced) {
                return this.minTime + "-" + this.maxTime;
            }
            return this.mainRegion + ":" + this.minTime + "-" + this.maxTime;
        }

        public String heavyToString() {
            Database db = Database.getDB();
            TimeAxisDefinition tad = db.getTimeAxisDefinition();
            String displayUnits = tad.unitDisplayString();
            boolean suffixUnits = tad.unitsAreASuffix();
            ResourceManager rMan = ResourceManager.getManager();
            String format = suffixUnits ? rMan.getString("timeRange.format") : rMan.getString("timeRange.formatPrefix");
            String timeSpan = MessageFormat.format(format, new Integer(this.minTime), new Integer(this.maxTime), displayUnits);
            if (this.timeSliced) {
                return timeSpan;
            }
            return this.mainRegion + ":" + timeSpan;
        }
    }

    public static class TimeBoundedRegionWorker
    extends AbstractFactoryClient {
        public TimeBoundedRegionWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("tcTimedRegion");
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            TimeBoundedRegion retval = null;
            if (elemName.equals("tcTimedRegion")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.currTimeBoundRegion = TimeBoundedRegion.buildFromXML(elemName, attrs);
            }
            return retval;
        }
    }

    public static class TimeBoundedRegion
    implements Cloneable {
        public SortedSet times;
        public String region;
        private List lineage_;
        public static final String TBR_XML_KEY = "tcTimedRegion";

        public TimeBoundedRegion(SortedSet times, String region) {
            this.times = DataUtil.fillOutHourly(times);
            this.region = region;
            this.lineage_ = null;
        }

        public List getLineage() {
            if (this.lineage_ == null) {
                this.lineage_ = Database.getDB().getTimeCourseData().genRegionLineage(this.region);
            }
            return this.lineage_;
        }

        public List getLineageAsNames() {
            ArrayList<String> retval = new ArrayList<String>();
            List linTbrs = this.getLineage();
            Iterator ltit = linTbrs.iterator();
            while (ltit.hasNext()) {
                TimeBoundedRegion ntbr = (TimeBoundedRegion)ltit.next();
                retval.add(ntbr.region);
            }
            return retval;
        }

        public int getRegionStart() {
            return (Integer)this.times.first();
        }

        public int getRegionEnd() {
            return (Integer)this.times.last();
        }

        public TimeBoundedRegion getLineageParent() {
            List lineage = this.getLineage();
            int numLim = lineage.size();
            if (numLim < 2) {
                return null;
            }
            return (TimeBoundedRegion)this.lineage_.get(numLim - 2);
        }

        public SortedSet calculateLineageTimes() {
            List myLineage = this.getLineage();
            TreeSet retval = new TreeSet();
            int rNum = myLineage.size();
            for (int i = 0; i < rNum; ++i) {
                TimeBoundedRegion tbr = (TimeBoundedRegion)myLineage.get(i);
                retval.addAll(tbr.times);
            }
            return DataUtil.fillOutHourly(retval);
        }

        public Map lineageRegionsToTimes() {
            List lineageList = this.getLineage();
            HashMap<String, SortedSet> retval = new HashMap<String, SortedSet>();
            int numL = lineageList.size();
            for (int i = 0; i < numL; ++i) {
                TimeBoundedRegion tbr = (TimeBoundedRegion)lineageList.get(i);
                retval.put(tbr.region, tbr.times);
            }
            return retval;
        }

        public Object clone() {
            try {
                TimeBoundedRegion retval = (TimeBoundedRegion)super.clone();
                retval.times = new TreeSet(this.times);
                retval.lineage_ = null;
                return retval;
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalStateException();
            }
        }

        public void writeXML(PrintWriter out, Indenter ind) {
            ind.indent();
            UiUtil.xmlOpen(TBR_XML_KEY, out, false);
            out.print("region=\"");
            out.print(this.region);
            out.print("\" minTime=\"");
            out.print(this.times.first());
            out.print("\" maxTime=\"");
            out.print(this.times.last());
            out.println("\" />");
        }

        public static TimeBoundedRegion buildFromXML(String elemName, Attributes attrs) throws IOException {
            TreeSet<Integer> seedSet;
            String regName = AttributeExtractor.extractAttribute(elemName, attrs, TBR_XML_KEY, "region", true);
            String minTime = AttributeExtractor.extractAttribute(elemName, attrs, TBR_XML_KEY, "minTime", true);
            String maxTime = AttributeExtractor.extractAttribute(elemName, attrs, TBR_XML_KEY, "maxTime", true);
            try {
                Integer minVal = Integer.valueOf(minTime);
                Integer maxVal = Integer.valueOf(maxTime);
                seedSet = new TreeSet<Integer>();
                seedSet.add(minVal);
                seedSet.add(maxVal);
            }
            catch (NumberFormatException nfex) {
                throw new IOException();
            }
            return new TimeBoundedRegion(seedSet, regName);
        }
    }
}

