/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.timeCourse;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.parser.ParserClient;
import org.systemsbiology.biotapestry.timeCourse.ExpressionEntry;
import org.systemsbiology.biotapestry.timeCourse.GeneTemplateEntry;
import org.systemsbiology.biotapestry.timeCourse.PerturbedTimeCourseGene;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseData;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseGene;
import org.xml.sax.Attributes;

public class TimeCourseFormatFactory
implements ParserClient {
    private HashSet allKeys_;
    private Set dataKeys_;
    private Set geneKeys_;
    private Set exprKeys_;
    private Set pertGeneKeys_;
    private TimeCourseData currTarg_;
    private TimeCourseGene currGene_;
    private PerturbedTimeCourseGene currPertGene_;
    private boolean currGeneIsTemplate_;
    private TimeCourseData.RegionTopology currRegTopo_;
    private TimeCourseData.TopoTimeRange currLocRange_;
    private String tcKey_;
    private String useTcKey_;
    private String gmKey_;
    private String useGroupKey_;
    private String currTcMapKey_;
    private String rootRegionKey_;
    private String regionParentKey_;
    private String regionHierarchyKey_;
    private String regionTopologyKey_;
    private String topoRegionKey_;
    private String topoLinkKey_;
    private String topoLocationsForRangeKey_;
    private String topoRegionLocationKey_;
    private String ctrlExpKey_;
    private boolean currExpIsCtrl_;
    private HashSet currRootRegionSet_;
    private HashMap currRegionParentMap_;
    private ArrayList currTcMapList_;
    private String currGroupMapKey_;
    private ArrayList currGroupMapList_;
    private boolean mapsAreIllegal_;
    private boolean serialNumberIsIllegal_;
    private long origSerialNumber_;

    public TimeCourseFormatFactory(boolean mapsAreIllegal, boolean serialNumberIsIllegal) {
        this.mapsAreIllegal_ = mapsAreIllegal;
        this.serialNumberIsIllegal_ = serialNumberIsIllegal;
        this.dataKeys_ = TimeCourseData.keywordsOfInterest();
        this.geneKeys_ = TimeCourseGene.keywordsOfInterest();
        this.exprKeys_ = ExpressionEntry.keywordsOfInterest();
        this.pertGeneKeys_ = PerturbedTimeCourseGene.keywordsOfInterest();
        this.ctrlExpKey_ = PerturbedTimeCourseGene.keyForControlCollection();
        this.tcKey_ = TimeCourseData.tcMapKeyword();
        this.useTcKey_ = TimeCourseData.useTcKeyword();
        this.gmKey_ = TimeCourseData.groupMapKeyword();
        this.useGroupKey_ = TimeCourseData.useGroupKeyword();
        this.regionHierarchyKey_ = TimeCourseData.regionHierarchyKeyword();
        this.rootRegionKey_ = TimeCourseData.rootRegionKeyword();
        this.regionParentKey_ = TimeCourseData.regionParentKeyword();
        this.regionTopologyKey_ = TimeCourseData.regionTopologyKeyword();
        this.topoRegionKey_ = TimeCourseData.topoRegionKeyword();
        this.topoLinkKey_ = TimeCourseData.topoLinkKeyword();
        this.topoLocationsForRangeKey_ = TimeCourseData.topoLocationsForRangeKeyword();
        this.topoRegionLocationKey_ = TimeCourseData.topoRegionLocationKeyword();
        this.allKeys_ = new HashSet();
        this.allKeys_.addAll(this.dataKeys_);
    }

    public TimeCourseData getTimeCourseData() {
        return this.currTarg_;
    }

    public void setContainer(Object container) {
    }

    public boolean finishElement(String elemName) {
        if (elemName.equals(this.tcKey_)) {
            this.currTarg_.addTimeCourseTCMMap(this.currTcMapKey_, this.currTcMapList_, false);
            this.currTcMapList_ = null;
            this.currTcMapKey_ = null;
        } else if (elemName.equals(this.gmKey_)) {
            this.currTarg_.setTimeCourseGroupMap(this.currGroupMapKey_, this.currGroupMapList_, false);
            this.currGroupMapList_ = null;
            this.currGroupMapKey_ = null;
        } else if (elemName.equals(this.regionHierarchyKey_)) {
            this.currTarg_.setRegionHierarchy(this.currRegionParentMap_, this.currRootRegionSet_, false);
            this.currRootRegionSet_ = null;
            this.currRegionParentMap_ = null;
        } else if (elemName.equals(this.topoLocationsForRangeKey_)) {
            this.currLocRange_ = null;
        } else if (elemName.equals(this.ctrlExpKey_)) {
            this.currExpIsCtrl_ = false;
        }
        return this.allKeys_.contains(elemName);
    }

    public void processCharacters(char[] chars, int start, int length) {
    }

    public Set keywordsOfInterest() {
        return this.allKeys_;
    }

    public Object processElement(String elemName, Attributes attrs) throws IOException {
        if (attrs == null || elemName == null) {
            return null;
        }
        if (this.currTarg_ != null && this.currTarg_.getSerialNumber() != this.origSerialNumber_) {
            throw new IOException();
        }
        if (this.dataKeys_.contains(elemName)) {
            TimeCourseData data = TimeCourseData.buildFromXML(elemName, attrs, this.serialNumberIsIllegal_);
            if (data != null) {
                Database db = Database.getDB();
                db.setTimeCourseData(data);
                this.currTarg_ = data;
                this.origSerialNumber_ = data.getSerialNumber();
            }
        } else if (this.geneKeys_.contains(elemName)) {
            this.currPertGene_ = null;
            TimeCourseGene tgene = TimeCourseGene.buildFromXML(elemName, attrs);
            if (tgene != null) {
                if (tgene.isTemplate()) {
                    this.currGeneIsTemplate_ = true;
                } else {
                    this.currGeneIsTemplate_ = false;
                    this.currTarg_.addGene(tgene);
                    this.currGene_ = tgene;
                }
            }
        } else if (this.pertGeneKeys_.contains(elemName)) {
            PerturbedTimeCourseGene ptcg = PerturbedTimeCourseGene.buildFromXML(elemName, attrs);
            if (ptcg != null) {
                if (this.currGeneIsTemplate_) {
                    throw new IOException();
                }
                this.currPertGene_ = ptcg;
                this.currGene_.setPerturbedState(ptcg.getPertSources(), ptcg);
            }
        } else if (this.exprKeys_.contains(elemName)) {
            ExpressionEntry ee = ExpressionEntry.buildFromXML(elemName, attrs);
            if (ee != null) {
                if (this.currGeneIsTemplate_) {
                    GeneTemplateEntry gte = new GeneTemplateEntry(ee.getTime(), ee.getRegion());
                    try {
                        this.currTarg_.addTemplateEntry(gte);
                    }
                    catch (IllegalArgumentException iaex) {
                        throw new IOException();
                    }
                } else if (this.currPertGene_ != null) {
                    if (this.currExpIsCtrl_) {
                        this.currPertGene_.addCtrlExpression(ee);
                    } else {
                        this.currPertGene_.addExpression(ee, null);
                    }
                } else {
                    this.currGene_.addExpression(ee);
                }
            }
        } else if (elemName.equals(this.tcKey_)) {
            if (this.mapsAreIllegal_) {
                throw new IOException();
            }
            this.currTcMapKey_ = TimeCourseData.extractTcMapKey(elemName, attrs);
            this.currTcMapList_ = new ArrayList();
        } else if (elemName.equals(this.useTcKey_)) {
            if (this.mapsAreIllegal_) {
                throw new IOException();
            }
            this.currTcMapList_.add(TimeCourseData.extractTCMapping(elemName, attrs));
        } else if (elemName.equals(this.gmKey_)) {
            if (this.mapsAreIllegal_) {
                throw new IOException();
            }
            this.currGroupMapKey_ = TimeCourseData.extractGroupMapKey(elemName, attrs);
            this.currGroupMapList_ = new ArrayList();
        } else if (elemName.equals(this.useGroupKey_)) {
            if (this.mapsAreIllegal_) {
                throw new IOException();
            }
            this.currGroupMapList_.add(TimeCourseData.extractUseGroup(elemName, attrs));
        } else if (elemName.equals(this.regionHierarchyKey_)) {
            if (this.mapsAreIllegal_) {
                throw new IOException();
            }
            this.currRootRegionSet_ = new HashSet();
            this.currRegionParentMap_ = new HashMap();
        } else if (elemName.equals(this.rootRegionKey_)) {
            if (this.mapsAreIllegal_) {
                throw new IOException();
            }
            this.currRootRegionSet_.add(TimeCourseData.extractRootRegion(elemName, attrs));
        } else if (elemName.equals(this.regionParentKey_)) {
            if (this.mapsAreIllegal_) {
                throw new IOException();
            }
            TimeCourseData.extractRegionParent(elemName, attrs, this.currRegionParentMap_);
        } else if (elemName.equals(this.regionTopologyKey_)) {
            if (this.mapsAreIllegal_) {
                throw new IOException();
            }
            TimeCourseData.TopoTimeRange newRange = TimeCourseData.TopoTimeRange.buildFromXML(elemName, attrs);
            this.currRegTopo_ = new TimeCourseData.RegionTopology(newRange);
            this.currTarg_.setRegionTopology(newRange, this.currRegTopo_);
        } else if (elemName.equals(this.topoRegionKey_)) {
            if (this.mapsAreIllegal_) {
                throw new IOException();
            }
            String regName = TimeCourseData.RegionTopology.buildRegionFromXML(elemName, attrs);
            this.currRegTopo_.addRegion(regName);
        } else if (elemName.equals(this.topoLinkKey_)) {
            if (this.mapsAreIllegal_) {
                throw new IOException();
            }
            TimeCourseData.TopoLink newLink = TimeCourseData.TopoLink.buildFromXML(elemName, attrs);
            this.currRegTopo_.addLink(newLink);
        } else if (elemName.equals(this.topoLocationsForRangeKey_)) {
            if (this.mapsAreIllegal_) {
                throw new IOException();
            }
            this.currTarg_.prepareRegionTopologyLocatorForInput();
            this.currLocRange_ = TimeCourseData.TopoTimeRange.buildFromXML(elemName, attrs);
        } else if (elemName.equals(this.topoRegionLocationKey_)) {
            if (this.currLocRange_ == null) {
                throw new IOException();
            }
            if (this.mapsAreIllegal_) {
                throw new IOException();
            }
            TimeCourseData.TopoRegionLoc newLoc = TimeCourseData.TopoRegionLoc.buildFromXML(elemName, attrs);
            this.currTarg_.getRegionTopologyLocator().setRegionTopologyLocation(this.currLocRange_, newLoc);
        } else if (elemName.equals(this.ctrlExpKey_)) {
            this.currPertGene_.setForDistinctControlExpr();
            this.currExpIsCtrl_ = true;
        }
        return null;
    }
}

