/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.timeCourse;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.perturb.PertSources;
import org.systemsbiology.biotapestry.timeCourse.ExpressionEntry;
import org.systemsbiology.biotapestry.timeCourse.GeneTemplateEntry;
import org.systemsbiology.biotapestry.timeCourse.PerturbedTimeCourseGene;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseData;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseTableDrawer;
import org.systemsbiology.biotapestry.ui.DisplayOptionsManager;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.Indenter;
import org.xml.sax.Attributes;

public class TimeCourseGene
implements Cloneable,
TimeCourseTableDrawer.Client {
    public static final int USE_BASE_CONFIDENCE = -1;
    public static final int NORMAL_CONFIDENCE = 0;
    public static final int INTERPOLATED = 1;
    public static final int INFERRED = 2;
    public static final int QUESTIONABLE = 3;
    public static final int ASSUMPTION = 4;
    public static final int NUM_CONFIDENCE = 5;
    public static final int LAST_WAS_STANDARD = 0;
    public static final int LAST_WAS_VARIABLE = 1;
    public static final int LAST_HAD_STRATEGY = 2;
    private static final int NOT_AN_EDGE_ = 0;
    private static final int START_EDGE_ = 1;
    private static final int END_EDGE_ = 2;
    private static final int START_AND_END_EDGE_ = 3;
    private static final int REGION_DISAPPEARING_ = 4;
    private static final int SINGLE_BLOCK_REGION_ = 5;
    private String name_;
    private ArrayList data_;
    private TreeMap pertGenes_;
    private boolean hasTimeCourse_;
    private String timeCourseNote_;
    private int confidence_;
    private boolean archival_;
    private boolean internalOnly_;
    private boolean isTemplate_;
    private static float[] inactiveHSV_ = new float[3];
    private static float[] activeHSV_;
    private static float[] activeRegionHSV_;
    private static float[] colHSB_;

    public TimeCourseGene(TimeCourseGene other) {
        this(other, true);
    }

    public TimeCourseGene(TimeCourseGene other, boolean doData) {
        this.name_ = other.name_;
        this.hasTimeCourse_ = other.hasTimeCourse_;
        this.timeCourseNote_ = other.timeCourseNote_;
        this.confidence_ = other.confidence_;
        this.archival_ = other.archival_;
        this.internalOnly_ = other.internalOnly_;
        this.isTemplate_ = other.isTemplate_;
        this.data_ = new ArrayList();
        this.pertGenes_ = new TreeMap();
        if (doData) {
            int size = other.data_.size();
            for (int i = 0; i < size; ++i) {
                ExpressionEntry exp = (ExpressionEntry)other.data_.get(i);
                this.data_.add(exp.clone());
            }
        }
        Iterator oit = other.pertGenes_.keySet().iterator();
        while (oit.hasNext()) {
            PertSources ops = (PertSources)oit.next();
            PerturbedTimeCourseGene ptcg = (PerturbedTimeCourseGene)other.pertGenes_.get(ops);
            this.pertGenes_.put(ops.clone(), new PerturbedTimeCourseGene(ptcg, doData));
        }
    }

    public TimeCourseGene(String name, int confidence, boolean archival, boolean internalOnly) {
        this.name_ = name;
        this.confidence_ = confidence;
        this.archival_ = archival;
        this.internalOnly_ = internalOnly;
        this.data_ = new ArrayList();
        this.pertGenes_ = new TreeMap();
    }

    public TimeCourseGene(String name, Iterator tempit) {
        this(name, tempit, false);
    }

    public TimeCourseGene(String name, Iterator tempit, boolean isTemplate) {
        this.name_ = name;
        this.confidence_ = 0;
        this.archival_ = false;
        this.internalOnly_ = false;
        this.data_ = new ArrayList();
        this.isTemplate_ = isTemplate;
        while (tempit.hasNext()) {
            GeneTemplateEntry gte = (GeneTemplateEntry)tempit.next();
            ExpressionEntry exp = new ExpressionEntry(gte.region, gte.time, 0, -1);
            this.data_.add(exp);
        }
        this.pertGenes_ = new TreeMap();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TimeCourseGene(String gene, String confidence, String timeCourse, String note, String archival, String internalOnly) throws IOException {
        this.name_ = gene;
        if (confidence == null) {
            this.confidence_ = 0;
        } else {
            try {
                this.confidence_ = TimeCourseGene.mapToConfidence(confidence.trim());
            }
            catch (IllegalArgumentException iaex) {
                throw new IOException();
            }
        }
        if (timeCourse == null) {
            throw new IOException();
        }
        if ((timeCourse = timeCourse.trim()).equalsIgnoreCase("no")) {
            this.hasTimeCourse_ = false;
        } else {
            if (!timeCourse.equalsIgnoreCase("yes")) throw new IOException();
            this.hasTimeCourse_ = true;
        }
        if (archival != null) {
            if ((archival = archival.trim()).equalsIgnoreCase("no")) {
                this.archival_ = false;
            } else {
                if (!archival.equalsIgnoreCase("yes")) throw new IOException();
                this.archival_ = true;
            }
        } else {
            this.archival_ = false;
        }
        if (internalOnly != null) {
            if ((internalOnly = internalOnly.trim()).equalsIgnoreCase("no")) {
                this.internalOnly_ = false;
            } else {
                if (!internalOnly.equalsIgnoreCase("yes")) throw new IOException();
                this.internalOnly_ = true;
            }
        } else {
            this.internalOnly_ = false;
        }
        this.timeCourseNote_ = note;
        this.data_ = new ArrayList();
        this.pertGenes_ = new TreeMap();
    }

    private TimeCourseGene(boolean isTemplate) throws IOException {
        if (!isTemplate) {
            throw new IOException();
        }
        this.name_ = "___Gene-For-BT-Template__";
        this.data_ = new ArrayList();
        this.hasTimeCourse_ = false;
        this.timeCourseNote_ = null;
        this.confidence_ = 0;
        this.archival_ = false;
        this.internalOnly_ = true;
        this.isTemplate_ = true;
        this.pertGenes_ = new TreeMap();
    }

    public Object clone() {
        try {
            TimeCourseGene retval = (TimeCourseGene)super.clone();
            int size = this.data_.size();
            retval.data_ = new ArrayList();
            for (int i = 0; i < size; ++i) {
                ExpressionEntry exp = (ExpressionEntry)this.data_.get(i);
                retval.data_.add(exp.clone());
            }
            retval.pertGenes_ = new TreeMap();
            Iterator oit = this.pertGenes_.keySet().iterator();
            while (oit.hasNext()) {
                PertSources ops = (PertSources)oit.next();
                PerturbedTimeCourseGene ptcg = (PerturbedTimeCourseGene)this.pertGenes_.get(ops);
                retval.pertGenes_.put(ops.clone(), ptcg.clone());
            }
            return retval;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public boolean isTemplate() {
        return this.isTemplate_;
    }

    public String getName() {
        return this.name_;
    }

    public void setName(String name) {
        this.name_ = name;
    }

    public int getConfidence() {
        return this.confidence_;
    }

    public void setConfidence(int confidence) {
        this.confidence_ = confidence;
    }

    public int mapEntryConfidence(int entryConfidence) {
        return TimeCourseGene.mapEntryConfidence(this.confidence_, entryConfidence);
    }

    public int reverseMapEntryConfidence(int entryConfidence) {
        return TimeCourseGene.reverseMapEntryConfidence(this.confidence_, entryConfidence);
    }

    public void setTimeCourse(boolean hasTimeCourse) {
        this.hasTimeCourse_ = hasTimeCourse;
    }

    public boolean hasTimeCourse() {
        return this.hasTimeCourse_;
    }

    public boolean isArchival() {
        return this.archival_;
    }

    public boolean isInternalOnly() {
        return this.internalOnly_;
    }

    public void setInternalOnly(boolean state) {
        this.internalOnly_ = state;
    }

    public void setTimeCourseNote(String timeCourseNote) {
        this.timeCourseNote_ = timeCourseNote;
    }

    public String getTimeCourseNote() {
        return this.timeCourseNote_;
    }

    public void addExpression(ExpressionEntry expr) {
        this.data_.add(expr);
    }

    public void addExpression(int index, ExpressionEntry expr) {
        this.data_.add(index, expr);
    }

    public void addExpressionGlobally(int index, ExpressionEntry expr) {
        this.data_.add(index, expr);
        Iterator pit = this.pertGenes_.keySet().iterator();
        while (pit.hasNext()) {
            PertSources ops = (PertSources)pit.next();
            PerturbedTimeCourseGene ptcg = (PerturbedTimeCourseGene)this.pertGenes_.get(ops);
            ExpressionEntry ctrl = ptcg.usingDistinctControlExpr() ? (ExpressionEntry)expr.clone() : null;
            ptcg.addExpression(index, (ExpressionEntry)expr.clone(), ctrl);
        }
    }

    public void deleteExpression(int i) {
        this.data_.remove(i);
    }

    public ExpressionEntry getExpression(int n) {
        return (ExpressionEntry)this.data_.get(n);
    }

    public Iterator getExpressions() {
        return this.data_.iterator();
    }

    public void mapExpressionGlobally(int i, GeneTemplateEntry newEntry, int mapVal, boolean isSame, TimeCourseGene oldGeneVersion) {
        this.addExpression(i, new ExpressionEntry(oldGeneVersion.getExpression(mapVal)));
        if (!isSame) {
            this.updateExpression(i, newEntry);
        }
        Iterator pit = this.pertGenes_.keySet().iterator();
        while (pit.hasNext()) {
            PertSources ops = (PertSources)pit.next();
            PerturbedTimeCourseGene ptcg = (PerturbedTimeCourseGene)this.pertGenes_.get(ops);
            PerturbedTimeCourseGene oldPtcg = oldGeneVersion.getPerturbedState(ops);
            ExpressionEntry ctrl = oldPtcg.usingDistinctControlExpr() ? new ExpressionEntry(oldPtcg.getControlExpression(mapVal)) : null;
            ptcg.addExpression(i, new ExpressionEntry(oldPtcg.getExpression(mapVal)), ctrl);
            if (isSame) continue;
            ptcg.updateExpression(i, newEntry);
        }
    }

    public void updateRegionGlobally(TimeCourseGene oldGeneVersion, String oldName, String newName) {
        Iterator eit = oldGeneVersion.getExpressions();
        while (eit.hasNext()) {
            ExpressionEntry ee = (ExpressionEntry)eit.next();
            ExpressionEntry newee = new ExpressionEntry(ee);
            if (DataUtil.keysEqual(ee.getRegion(), oldName)) {
                newee.updateRegion(newName);
            }
            this.addExpression(newee);
        }
        Iterator pit = this.pertGenes_.keySet().iterator();
        while (pit.hasNext()) {
            Iterator peitc;
            PertSources ops = (PertSources)pit.next();
            PerturbedTimeCourseGene ptcg = (PerturbedTimeCourseGene)this.pertGenes_.get(ops);
            PerturbedTimeCourseGene oldPtcg = oldGeneVersion.getPerturbedState(ops);
            Iterator peit = oldPtcg.getExpressions();
            Iterator iterator = peitc = oldPtcg.usingDistinctControlExpr() ? oldPtcg.getControlExpressions() : null;
            while (peit.hasNext()) {
                ExpressionEntry ee = (ExpressionEntry)peit.next();
                ExpressionEntry newee = new ExpressionEntry(ee);
                if (DataUtil.keysEqual(ee.getRegion(), oldName)) {
                    newee.updateRegion(newName);
                }
                ExpressionEntry newctrlee = null;
                if (peitc != null) {
                    ee = (ExpressionEntry)peitc.next();
                    newctrlee = new ExpressionEntry(ee);
                    if (DataUtil.keysEqual(ee.getRegion(), oldName)) {
                        newctrlee.updateRegion(newName);
                    }
                }
                ptcg.addExpression(newee, newctrlee);
            }
        }
    }

    public void updateExpression(int i, GeneTemplateEntry newEntry) {
        ExpressionEntry ee = this.getExpression(i);
        ee.updateRegionAndTime(newEntry.region, newEntry.time);
    }

    public void fillForRegionAndTimes(String region, int timeMin, int timeMax) {
        Iterator eit = this.data_.iterator();
        while (eit.hasNext()) {
            int time;
            ExpressionEntry ee = (ExpressionEntry)eit.next();
            if (!DataUtil.keysEqual(ee.getRegion(), region) || (time = ee.getTime()) < timeMin || time > timeMax) continue;
            ee.setExpression(3);
        }
    }

    public Set getSourceOptions() {
        return TimeCourseGene.getSourceOptions(this.data_);
    }

    public Iterator getPertKeys() {
        return this.pertGenes_.keySet().iterator();
    }

    public PerturbedTimeCourseGene getPerturbedState(PertSources key) {
        return (PerturbedTimeCourseGene)this.pertGenes_.get(key);
    }

    public void setPerturbedState(PertSources key, PerturbedTimeCourseGene ptcg) {
        this.pertGenes_.put(key, ptcg);
    }

    public void clearPerturbedStates() {
        this.pertGenes_.clear();
    }

    public void dropPerturbedState(PertSources key) {
        this.pertGenes_.remove(key);
    }

    public int getExpressionLevelForSource(String region, int hour, int exprSource, VariableLevel varLev) {
        if (!this.haveARegion(region, hour)) {
            return -1;
        }
        ExpressionEntry greatestLower = null;
        ExpressionEntry matchingEntry = null;
        ExpressionEntry leastHigher = null;
        Iterator eit = this.getExpressions();
        while (eit.hasNext()) {
            ExpressionEntry ee = (ExpressionEntry)eit.next();
            int time = ee.getTime();
            if (!DataUtil.keysEqual(ee.getRegion(), region)) continue;
            if (time == hour) {
                matchingEntry = ee;
                continue;
            }
            if (time > hour) {
                if (leastHigher != null && time >= leastHigher.getTime()) continue;
                leastHigher = ee;
                continue;
            }
            if (time >= hour || greatestLower != null && time <= greatestLower.getTime()) continue;
            greatestLower = ee;
        }
        if (matchingEntry != null) {
            return this.calculateMatchingExpression(matchingEntry, exprSource, varLev);
        }
        return this.interpolateExpression(hour, greatestLower, leastHigher, exprSource, varLev);
    }

    private int edgeStatus(ExpressionEntry entry, int exprSource) {
        return TimeCourseGene.edgeStatus(entry, exprSource, this.getExpressions());
    }

    private boolean haveARegion(String region, int hour) {
        ExpressionEntry greatestLower = null;
        ExpressionEntry leastHigher = null;
        Iterator eit = this.getExpressions();
        while (eit.hasNext()) {
            ExpressionEntry ee = (ExpressionEntry)eit.next();
            int time = ee.getTime();
            if (!DataUtil.keysEqual(ee.getRegion(), region)) continue;
            if (time == hour) {
                return true;
            }
            if (time > hour) {
                if (leastHigher != null && time >= leastHigher.getTime()) continue;
                leastHigher = ee;
                continue;
            }
            if (time >= hour || greatestLower != null && time <= greatestLower.getTime()) continue;
            greatestLower = ee;
        }
        if (greatestLower != null && leastHigher != null) {
            return true;
        }
        if (greatestLower == null) {
            return false;
        }
        HashSet rawtimes = new HashSet();
        this.getInterestingTimes(rawtimes);
        TreeSet times = new TreeSet();
        times.addAll(rawtimes);
        Iterator tmit = times.iterator();
        int targTime = greatestLower.getTime();
        while (tmit.hasNext()) {
            int time = (Integer)tmit.next();
            if (time <= targTime) continue;
            return hour < time;
        }
        return false;
    }

    private int calculateMatchingExpression(ExpressionEntry matchingEntry, int exprSource, VariableLevel varLev) {
        if (matchingEntry == null) {
            throw new IllegalArgumentException();
        }
        int matchExpr = matchingEntry.getExpressionForSource(exprSource);
        if (matchExpr == 4) {
            varLev.level = matchingEntry.getVariableLevelForSource(exprSource);
            return matchExpr;
        }
        if (matchExpr <= 1) {
            return matchExpr;
        }
        int startStrat = matchingEntry.getStartStrategy(exprSource);
        int endStrat = matchingEntry.getEndStrategy(exprSource);
        int edge = this.edgeStatus(matchingEntry, exprSource);
        switch (edge) {
            case 0: {
                return matchExpr;
            }
            case 1: 
            case 3: 
            case 5: {
                if (startStrat == 0) {
                    return matchExpr;
                }
                if (startStrat == 2 || startStrat == 1) {
                    return matchExpr;
                }
                if (edge == 3) {
                    return matchExpr;
                }
                return 1;
            }
            case 2: 
            case 4: {
                if (endStrat == 0) {
                    return matchExpr;
                }
                if (endStrat == 2 || endStrat == 1) {
                    return matchExpr;
                }
                return 1;
            }
        }
        throw new IllegalStateException();
    }

    private boolean interpolateVariableExpression(int hour, ExpressionEntry greatestLower, ExpressionEntry leastHigher, int exprSource, VariableLevel varLev) {
        int lowerExpr = greatestLower.getExpressionForSource(exprSource);
        boolean lowerVar = lowerExpr == 4;
        boolean higherVar = false;
        if (leastHigher != null) {
            int higherExpr = leastHigher.getExpressionForSource(exprSource);
            boolean bl = higherVar = higherExpr == 4;
        }
        if (!lowerVar && !higherVar) {
            return false;
        }
        if (leastHigher == null) {
            varLev.level = greatestLower.getVariableLevelForSource(exprSource);
            return true;
        }
        int lowerTime = greatestLower.getTime();
        VariableLevel lowerVarLev = new VariableLevel();
        if (!lowerVar) {
            this.convertFixedToVariable(lowerExpr, lowerVarLev);
        } else {
            lowerVarLev.level = greatestLower.getVariableLevelForSource(exprSource);
        }
        int higherTime = leastHigher.getTime();
        int higherExpr = leastHigher.getExpressionForSource(exprSource);
        VariableLevel higherVarLev = new VariableLevel();
        if (!higherVar) {
            this.convertFixedToVariable(higherExpr, higherVarLev);
        } else {
            higherVarLev.level = leastHigher.getVariableLevelForSource(exprSource);
        }
        double frac = ((double)hour - (double)lowerTime) / ((double)higherTime - (double)lowerTime);
        double diff = higherVarLev.level - lowerVarLev.level;
        varLev.level = lowerVarLev.level + frac * diff;
        return true;
    }

    private void convertFixedToVariable(int exprLevel, VariableLevel varLev) {
        switch (exprLevel) {
            case 0: 
            case 1: {
                varLev.level = 0.0;
                break;
            }
            case 2: {
                varLev.level = DisplayOptionsManager.getMgr().getDisplayOptions().getWeakExpressionLevel();
                break;
            }
            case 3: {
                varLev.level = 1.0;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private int interpolateExpression(int hour, ExpressionEntry greatestLower, ExpressionEntry leastHigher, int exprSource, VariableLevel varLev) {
        if (greatestLower == null) {
            throw new IllegalArgumentException();
        }
        if (this.interpolateVariableExpression(hour, greatestLower, leastHigher, exprSource, varLev)) {
            return 4;
        }
        int lowerEdge = this.edgeStatus(greatestLower, exprSource);
        int startStrat = greatestLower.getStartStrategy(exprSource);
        int endStrat = greatestLower.getEndStrategy(exprSource);
        int lowerExpr = greatestLower.getExpressionForSource(exprSource);
        switch (lowerEdge) {
            case 0: {
                break;
            }
            case 1: {
                if (startStrat == 3 && hour - greatestLower.getTime() == 1) {
                    return 1;
                }
                return lowerExpr;
            }
            case 3: {
                if (ExpressionEntry.inconsistentStrategies(startStrat, endStrat)) {
                    return lowerExpr;
                }
                if (endStrat == 1 && hour - greatestLower.getTime() == 1) {
                    return lowerExpr;
                }
                if (endStrat == 2 && hour - greatestLower.getTime() == 1) {
                    return 1;
                }
                return lowerExpr;
            }
            case 5: {
                if (startStrat == 3 && hour - greatestLower.getTime() == 1) {
                    return 1;
                }
                if (startStrat == 4 && hour - greatestLower.getTime() == 1) {
                    return lowerExpr;
                }
                return lowerExpr;
            }
            case 2: 
            case 4: {
                if (endStrat == 1 && hour - greatestLower.getTime() == 1) {
                    return lowerExpr;
                }
                if (endStrat == 2 && hour - greatestLower.getTime() == 1) {
                    return 1;
                }
                if (endStrat == 0) {
                    return lowerExpr;
                }
                return 1;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (leastHigher == null) {
            if (lowerExpr > 1) {
                throw new IllegalStateException();
            }
            return lowerExpr;
        }
        int higherEdge = this.edgeStatus(leastHigher, exprSource);
        startStrat = leastHigher.getStartStrategy(exprSource);
        endStrat = leastHigher.getEndStrategy(exprSource);
        int higherExpr = leastHigher.getExpressionForSource(exprSource);
        switch (higherEdge) {
            case 0: {
                return lowerExpr;
            }
            case 1: {
                if (startStrat == 1) {
                    return higherExpr;
                }
                if (startStrat == 2 && leastHigher.getTime() - hour == 1) {
                    return higherExpr;
                }
                return 1;
            }
            case 3: {
                if (ExpressionEntry.inconsistentStrategies(startStrat, endStrat)) {
                    return lowerExpr;
                }
                if (startStrat == 1) {
                    return higherExpr;
                }
                if (startStrat == 2 && leastHigher.getTime() - hour == 1) {
                    return higherExpr;
                }
                return 1;
            }
            case 2: 
            case 4: {
                if (endStrat == 3 && leastHigher.getTime() - hour == 1) {
                    return 1;
                }
                return higherExpr;
            }
        }
        throw new IllegalStateException();
    }

    public int getConfidence(String region, int time) {
        Iterator eit = this.getExpressions();
        while (eit.hasNext()) {
            ExpressionEntry ee = (ExpressionEntry)eit.next();
            int eTime = ee.getTime();
            if (!DataUtil.keysEqual(ee.getRegion(), region) || eTime != time) continue;
            int confidence = ee.getConfidence();
            return confidence == -1 ? this.confidence_ : confidence;
        }
        System.err.println("No confidence for " + time);
        throw new IllegalArgumentException();
    }

    public int getExprSource(String region, int time) {
        Iterator eit = this.getExpressions();
        while (eit.hasNext()) {
            ExpressionEntry ee = (ExpressionEntry)eit.next();
            int eTime = ee.getTime();
            if (!DataUtil.keysEqual(ee.getRegion(), region) || eTime != time) continue;
            return ee.getSource();
        }
        System.err.println("No source for " + time);
        throw new IllegalArgumentException();
    }

    public void getInterestingTimes(Set interest) {
        Iterator exps = this.getExpressions();
        while (exps.hasNext()) {
            ExpressionEntry exp = (ExpressionEntry)exps.next();
            int time = exp.getTime();
            interest.add(new Integer(time));
        }
    }

    public int getGlobalFirstExpression(int channel) {
        int retval = Integer.MAX_VALUE;
        Iterator exps = this.getExpressions();
        while (exps.hasNext()) {
            int time;
            ExpressionEntry exp = (ExpressionEntry)exps.next();
            int expression = exp.getExpressionForSource(channel);
            if (expression != 3 && expression != 2 || (time = exp.getTime()) >= retval) continue;
            retval = time;
        }
        return retval;
    }

    public Integer getRegionFirstExpressionTime(String regionID, int channel) {
        Integer retval = null;
        Iterator exps = this.getExpressions();
        while (exps.hasNext()) {
            int expression;
            ExpressionEntry exp = (ExpressionEntry)exps.next();
            if (!DataUtil.keysEqual(regionID, exp.getRegion()) || (expression = exp.getExpressionForSource(channel)) != 3 && expression != 2) continue;
            int time = exp.getTime();
            if (retval != null && time >= retval) continue;
            retval = new Integer(time);
        }
        return retval;
    }

    public Integer getLineageFirstExpressionTime(List lineage, int channel) {
        Integer retval = null;
        Iterator exps = this.getExpressions();
        int numLin = lineage.size();
        while (exps.hasNext()) {
            ExpressionEntry exp = (ExpressionEntry)exps.next();
            int time = exp.getTime();
            String reg = exp.getRegion();
            for (int i = 0; i < numLin; ++i) {
                int expression;
                TimeCourseData.TimeBoundedRegion tbr = (TimeCourseData.TimeBoundedRegion)lineage.get(i);
                if (!DataUtil.keysEqual(tbr.region, reg) || time < tbr.getRegionStart() || time > tbr.getRegionEnd() || (expression = exp.getExpressionForSource(channel)) != 3 && expression != 2 || retval != null && time >= retval) continue;
                retval = new Integer(time);
            }
        }
        return retval;
    }

    public Set expressesInRegions(int channel) {
        HashSet<String> retval = new HashSet<String>();
        Iterator exps = this.getExpressions();
        while (exps.hasNext()) {
            ExpressionEntry exp = (ExpressionEntry)exps.next();
            int expression = exp.getExpressionForSource(channel);
            if (expression != 3 && expression != 2) continue;
            retval.add(exp.getRegion());
        }
        return retval;
    }

    public boolean expressesInRegion(String regionID, int channel) {
        Iterator exps = this.getExpressions();
        while (exps.hasNext()) {
            int expression;
            ExpressionEntry exp = (ExpressionEntry)exps.next();
            if (!DataUtil.keysEqual(regionID, exp.getRegion()) || (expression = exp.getExpressionForSource(channel)) != 3 && expression != 2) continue;
            return true;
        }
        return false;
    }

    public String expressesInOnlyAndOnlyOneRegion(int channel) {
        HashSet<String> regions = new HashSet<String>();
        Iterator exps = this.getExpressions();
        while (exps.hasNext()) {
            ExpressionEntry exp = (ExpressionEntry)exps.next();
            int expression = exp.getExpressionForSource(channel);
            if (expression != 3 && expression != 2) continue;
            String reg = exp.getRegion();
            regions.add(reg);
        }
        return regions.size() == 1 ? (String)regions.iterator().next() : null;
    }

    public int getMaximumTime() {
        TreeSet times = new TreeSet();
        this.getInterestingTimes(times);
        return (Integer)times.last();
    }

    public int getMinimumTime() {
        TreeSet times = new TreeSet();
        this.getInterestingTimes(times);
        return (Integer)times.first();
    }

    public void getRegions(Set regions) {
        Iterator exps = this.getExpressions();
        while (exps.hasNext()) {
            ExpressionEntry exp = (ExpressionEntry)exps.next();
            regions.add(exp.getRegion());
        }
    }

    public int getExpressionTable(PrintWriter out, TimeCourseData tcd, boolean showTree) {
        return new TimeCourseTableDrawer(this).getExpressionTable(out, tcd, showTree);
    }

    public void exportCSV(PrintWriter out, Iterator tmpit, boolean encodeConfidence, boolean exportInternals) {
        if (this.internalOnly_ && !exportInternals || this.data_.size() == 0) {
            return;
        }
        out.print("\"");
        out.print(this.name_);
        out.print("\"");
        if (tmpit.hasNext()) {
            out.print(",");
        }
        while (tmpit.hasNext()) {
            GeneTemplateEntry gte = (GeneTemplateEntry)tmpit.next();
            ExpressionEntry exp = this.matchingEntry(gte.region, gte.time);
            int showConf = -1;
            if (encodeConfidence) {
                int entryConfidence = exp.getConfidence();
                showConf = this.mapEntryConfidence(entryConfidence);
            }
            exp.exportCSV(out, showConf, encodeConfidence);
            if (!tmpit.hasNext()) continue;
            out.print(",");
        }
        out.println();
    }

    private ExpressionEntry matchingEntry(String region, int hour) {
        Iterator eit = this.getExpressions();
        while (eit.hasNext()) {
            ExpressionEntry ee = (ExpressionEntry)eit.next();
            int time = ee.getTime();
            if (!DataUtil.keysEqual(ee.getRegion(), region) || time != hour) continue;
            return ee;
        }
        throw new IllegalArgumentException();
    }

    public boolean haveData() {
        Iterator eit = this.getExpressions();
        while (eit.hasNext()) {
            ExpressionEntry ee = (ExpressionEntry)eit.next();
            int expression = ee.getExpressionForSource(0);
            if (expression == 0 || expression == -1) continue;
            return true;
        }
        return false;
    }

    public boolean haveDataForSource(int source) {
        Iterator eit = this.getExpressions();
        while (eit.hasNext()) {
            ExpressionEntry ee = (ExpressionEntry)eit.next();
            int expression = ee.getExpressionForSource(source);
            if (expression == 0 || expression == -1) continue;
            return true;
        }
        return false;
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<timeCourse gene=\"");
        out.print(CharacterEntityMapper.mapEntities(this.name_, false));
        out.print("\" baseConfidence=\"");
        out.print(TimeCourseGene.mapConfidence(this.confidence_));
        out.print("\" timeCourse=\"");
        out.print(this.hasTimeCourse_ ? "yes" : "no");
        if (this.timeCourseNote_ != null) {
            out.print("\" note=\"");
            out.print(CharacterEntityMapper.mapEntities(this.timeCourseNote_, false));
        }
        if (this.archival_) {
            out.print("\" archival=\"yes");
        }
        if (this.internalOnly_) {
            out.print("\" internalOnly=\"yes");
        }
        out.println("\">");
        ind.up();
        if (this.data_.size() > 0) {
            ind.indent();
            out.println("<expData>");
            ind.up();
            Iterator exps = this.getExpressions();
            while (exps.hasNext()) {
                ExpressionEntry exp = (ExpressionEntry)exps.next();
                exp.writeXML(out, ind);
            }
            ind.down().indent();
            out.println("</expData>");
        }
        if (this.pertGenes_.size() > 0) {
            ind.indent();
            out.println("<perturbations>");
            ind.up();
            Iterator pkit = this.pertGenes_.keySet().iterator();
            while (pkit.hasNext()) {
                PertSources pss = (PertSources)pkit.next();
                PerturbedTimeCourseGene ptcg = (PerturbedTimeCourseGene)this.pertGenes_.get(pss);
                ptcg.writeXML(out, ind);
            }
            ind.down().indent();
            out.println("</perturbations>");
        }
        ind.down().indent();
        out.println("</timeCourse>");
    }

    public void writeXMLForTemplate(PrintWriter out, Indenter ind) {
        if (this.data_.size() == 0) {
            return;
        }
        ind.indent();
        out.println("<timeCourse isTemplate=\"true\">");
        ind.up();
        Iterator exps = this.getExpressions();
        while (exps.hasNext()) {
            ExpressionEntry exp = (ExpressionEntry)exps.next();
            exp.writeXML(out, ind);
        }
        ind.down().indent();
        out.println("</timeCourse>");
    }

    public String toString() {
        return "TimeCourseGene: name = " + this.name_ + " confidence = " + this.confidence_ + " hasTimeCourse = " + this.hasTimeCourse_ + " expressions = " + this.data_;
    }

    public static int mapEntryConfidence(int baseConfidence, int entryConfidence) {
        if (entryConfidence == -1) {
            return baseConfidence;
        }
        return entryConfidence;
    }

    public static int reverseMapEntryConfidence(int baseConfidence, int entryConfidence) {
        if (entryConfidence == baseConfidence) {
            return -1;
        }
        return entryConfidence;
    }

    public static String mapConfidence(int value) {
        switch (value) {
            case 0: {
                return "normal";
            }
            case 1: {
                return "interpolated";
            }
            case 4: {
                return "assumption";
            }
            case 2: {
                return "inferred";
            }
            case 3: {
                return "questionable";
            }
        }
        throw new IllegalArgumentException();
    }

    public static int mapToConfidence(String str) {
        if (str.equalsIgnoreCase("normal")) {
            return 0;
        }
        if (str.equalsIgnoreCase("interpolated")) {
            return 1;
        }
        if (str.equalsIgnoreCase("assumption")) {
            return 4;
        }
        if (str.equalsIgnoreCase("inferred")) {
            return 2;
        }
        if (str.equalsIgnoreCase("questionable")) {
            return 3;
        }
        throw new IllegalArgumentException();
    }

    public static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("timeCourse");
        return retval;
    }

    public static TimeCourseGene buildFromXML(String elemName, Attributes attrs) throws IOException {
        boolean makeTemplate;
        if (!elemName.equals("timeCourse")) {
            return null;
        }
        String gene = null;
        String confidence = null;
        String timeCourse = null;
        String note = null;
        String archival = null;
        String internalOnly = null;
        String isTemplate = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("gene")) {
                    gene = CharacterEntityMapper.unmapEntities(val, false);
                    continue;
                }
                if (key.equals("baseConfidence")) {
                    confidence = val;
                    continue;
                }
                if (key.equals("timeCourse")) {
                    timeCourse = val;
                    continue;
                }
                if (key.equals("note")) {
                    note = CharacterEntityMapper.unmapEntities(val, false);
                    continue;
                }
                if (key.equals("archival")) {
                    archival = val;
                    continue;
                }
                if (key.equals("internalOnly")) {
                    internalOnly = val;
                    continue;
                }
                if (!key.equals("isTemplate")) continue;
                isTemplate = val;
            }
        }
        if (makeTemplate = new Boolean(isTemplate).booleanValue()) {
            return new TimeCourseGene(true);
        }
        if (gene == null || confidence == null || timeCourse == null) {
            throw new IOException();
        }
        return new TimeCourseGene(gene, confidence, timeCourse, note, archival, internalOnly);
    }

    public static boolean strategyProblems(ExpressionEntry entry, int exprSource, Iterator eit, Map prevStates) {
        int lastState;
        int startStrat = entry.getStartStrategy(exprSource);
        int endStrat = entry.getEndStrategy(exprSource);
        String region = entry.getRegion();
        Integer lastStateObj = (Integer)prevStates.get(region);
        if (lastStateObj == null) {
            lastStateObj = new Integer(0);
            prevStates.put(region, lastStateObj);
        }
        if ((lastState = lastStateObj.intValue()) == 1 && (startStrat != 0 || endStrat != 0)) {
            return true;
        }
        if (lastState == 2 && entry.getExpressionForSource(exprSource) == 4) {
            return true;
        }
        int edgeType = TimeCourseGene.edgeStatus(entry, exprSource, eit);
        if (edgeType == 0 && (startStrat != 0 || endStrat != 0)) {
            return true;
        }
        if (edgeType == 3 && (ExpressionEntry.inconsistentStrategies(startStrat, endStrat) || ExpressionEntry.isOffAtBoundary(startStrat) || ExpressionEntry.isOffAtBoundary(endStrat))) {
            return true;
        }
        if (edgeType == 1 && endStrat != 0) {
            return true;
        }
        if (edgeType == 5 && (endStrat != 0 || !ExpressionEntry.isOffAtBoundary(startStrat) && startStrat != 0)) {
            return true;
        }
        if ((edgeType == 2 || edgeType == 4) && startStrat != 0) {
            return true;
        }
        if (startStrat != 0 || endStrat != 0) {
            lastState = 2;
        } else if (entry.getExpressionForSource(exprSource) == 4) {
            lastState = 1;
        }
        prevStates.put(region, new Integer(lastState));
        return false;
    }

    public static int edgeStatus(ExpressionEntry entry, int exprSource, Iterator eit) {
        boolean laterExpressing;
        boolean entryExpressing;
        if (entry == null) {
            throw new IllegalArgumentException();
        }
        boolean bl = entryExpressing = entry.getExpressionForSource(exprSource) > 1;
        if (!entryExpressing) {
            return 0;
        }
        String region = entry.getRegion();
        int hour = entry.getTime();
        ExpressionEntry greatestLower = null;
        ExpressionEntry leastHigher = null;
        while (eit.hasNext()) {
            ExpressionEntry ee = (ExpressionEntry)eit.next();
            int time = ee.getTime();
            if (!DataUtil.keysEqual(ee.getRegion(), region) || time == hour) continue;
            if (time > hour) {
                if (leastHigher != null && time >= leastHigher.getTime()) continue;
                leastHigher = ee;
                continue;
            }
            if (time >= hour || greatestLower != null && time <= greatestLower.getTime()) continue;
            greatestLower = ee;
        }
        boolean earlierExpressing = greatestLower != null && greatestLower.getExpressionForSource(exprSource) > 1;
        boolean bl2 = laterExpressing = leastHigher != null && leastHigher.getExpressionForSource(exprSource) > 1;
        if (earlierExpressing && laterExpressing) {
            return 0;
        }
        if (!earlierExpressing && laterExpressing) {
            return 1;
        }
        if (greatestLower == null && leastHigher == null) {
            return 5;
        }
        if (earlierExpressing && leastHigher == null) {
            return 4;
        }
        if (earlierExpressing && !laterExpressing) {
            return 2;
        }
        if (!earlierExpressing && !laterExpressing) {
            return 3;
        }
        throw new IllegalStateException();
    }

    public static Set getSourceOptions(Collection expr) {
        HashSet<Integer> retval = new HashSet<Integer>();
        Iterator eeit = expr.iterator();
        while (eeit.hasNext()) {
            ExpressionEntry ee = (ExpressionEntry)eeit.next();
            Integer qualSrc = ee.getQualifiedSource();
            if (qualSrc == null) continue;
            retval.add(qualSrc);
        }
        return retval;
    }

    static {
        Color.RGBtoHSB(255, 255, 255, inactiveHSV_);
        activeHSV_ = new float[3];
        Color.RGBtoHSB(102, 238, 102, activeHSV_);
        activeRegionHSV_ = new float[3];
        Color.RGBtoHSB(102, 102, 238, activeRegionHSV_);
        colHSB_ = new float[3];
    }

    public static class VariableLevel {
        public double level;
    }
}

