/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.timeCourse;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.plugin.InternalLinkDataDisplayPlugIn;
import org.systemsbiology.biotapestry.plugin.PluginCallbackWorker;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseData;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseGene;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseTableDrawer;
import org.systemsbiology.biotapestry.ui.DisplayOptions;
import org.systemsbiology.biotapestry.ui.DisplayOptionsManager;
import org.systemsbiology.biotapestry.util.ResourceManager;

public class TimeCourseLinkDisplayPlugIn
implements InternalLinkDataDisplayPlugIn {
    public boolean isInternal() {
        return true;
    }

    public boolean requiresPerInstanceDisplay(String genomeID, String itemID) {
        return true;
    }

    public boolean haveCallbackWorker() {
        return false;
    }

    public PluginCallbackWorker getCallbackWorker(String genomeID, String linkID) {
        return null;
    }

    public String getDataAsHTML(String genomeID, String linkID) {
        String tab;
        int nextKey;
        PrintWriter out;
        StringWriter sw;
        TimeCourseGene tcg;
        TimeCourseData.TCMapping tcm;
        Iterator dkit;
        StringBuffer buf = new StringBuffer();
        Database db = Database.getDB();
        Genome genome = db.getGenome(genomeID);
        Linkage link = genome.getLinkage(linkID);
        String targID = link.getTarget();
        String sourceID = link.getSource();
        String baseTargID = GenomeItemInstance.getBaseID(targID);
        String baseSourceID = GenomeItemInstance.getBaseID(sourceID);
        TimeCourseData tcd = db.getTimeCourseData();
        if (tcd == null || !tcd.haveData()) {
            return "";
        }
        boolean haveHierarchy = tcd.hierarchyIsSet();
        DisplayOptions dOpt = DisplayOptionsManager.getMgr().getDisplayOptions();
        boolean showTree = haveHierarchy ? dOpt.showExpressionTableTree() : false;
        ResourceManager rMan = ResourceManager.getManager();
        buf.append("<p></p>");
        buf.append("<center><h1>");
        buf.append(rMan.getString("dataWindow.timeCourseDataForLink"));
        buf.append("</h1>\n");
        int needKey = 0;
        List dataKeys = tcd.getTimeCourseTCMDataKeysWithDefault(baseSourceID);
        boolean gotData = false;
        if (dataKeys != null) {
            dkit = dataKeys.iterator();
            while (dkit.hasNext()) {
                tcm = (TimeCourseData.TCMapping)dkit.next();
                tcg = tcd.getTimeCourseDataCaseInsensitive(tcm.name);
                if (tcg == null) continue;
                sw = new StringWriter();
                out = new PrintWriter(sw);
                nextKey = tcg.getExpressionTable(out, tcd, showTree);
                needKey |= nextKey;
                tab = sw.getBuffer().toString();
                if (tab == null || tab.trim().equals("")) continue;
                gotData = true;
                buf.append("<p>");
                buf.append(tab);
                buf.append("</p>");
            }
        }
        if ((dataKeys = tcd.getTimeCourseTCMDataKeysWithDefault(baseTargID)) != null) {
            dkit = dataKeys.iterator();
            while (dkit.hasNext()) {
                tcm = (TimeCourseData.TCMapping)dkit.next();
                tcg = tcd.getTimeCourseDataCaseInsensitive(tcm.name);
                if (tcg == null) continue;
                sw = new StringWriter();
                out = new PrintWriter(sw);
                nextKey = tcg.getExpressionTable(out, tcd, showTree);
                needKey |= nextKey;
                tab = sw.getBuffer().toString();
                if (tab == null || tab.trim().equals("")) continue;
                gotData = true;
                buf.append("<p>");
                buf.append(tab);
                buf.append("</p>");
            }
        }
        buf.append(TimeCourseTableDrawer.buildKey(needKey, showTree, false));
        if (!gotData) {
            buf.append(rMan.getString("dataWindow.noExpressionProfile"));
        }
        buf.append("</center>");
        return buf.toString();
    }
}

