/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.timeCourse;

import java.awt.Color;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.TimeAxisDefinition;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.timeCourse.PerturbedTimeCourseGene;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseData;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseGene;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.ResourceManager;

public class TimeCourseTableDrawer {
    public static final int NO_TABLE_KEY = 0;
    public static final int BASIC_TABLE_KEY = 1;
    public static final int ADD_CONFIDENCE = 2;
    public static final int ADD_SOURCE = 4;
    private float[] inactiveHSV_;
    private float[] activeHSV_;
    private float[] activeRegionHSV_;
    private float[] colHSB_;
    private TimeCourseGene client_;
    private PerturbedTimeCourseGene pertClient_;
    private static final String BIG_VERT_COLOR_ = "#F8F8F8";
    private static final String NO_REGION_COLOR_ = "#DDDDDD";
    private static final String BLACK_COLOR_ = "black";
    private static final String WHITE_COLOR_ = "white";
    private static final String MID_GREY_COLOR = "#888888";

    public TimeCourseTableDrawer(TimeCourseGene client) {
        this(client, null);
    }

    public TimeCourseTableDrawer(TimeCourseGene client, PerturbedTimeCourseGene pertClient) {
        this.client_ = client;
        this.pertClient_ = pertClient;
        this.inactiveHSV_ = new float[3];
        Color.RGBtoHSB(255, 255, 255, this.inactiveHSV_);
        this.activeHSV_ = new float[3];
        Color.RGBtoHSB(102, 238, 102, this.activeHSV_);
        this.activeRegionHSV_ = new float[3];
        Color.RGBtoHSB(102, 102, 238, this.activeRegionHSV_);
        this.colHSB_ = new float[3];
    }

    public int getPertExpressionTable(PrintWriter out, TimeCourseData tcd) {
        if (this.pertClient_.isInternalOnly() || this.client_.isInternalOnly()) {
            return 0;
        }
        HashSet rawregions = new HashSet();
        this.client_.getRegions(rawregions);
        List ordered = tcd.getRegionsKeepOrder();
        List regions = this.sortRegions(rawregions, ordered);
        TreeSet times = new TreeSet();
        HashSet rawtimes = new HashSet();
        this.client_.getInterestingTimes(rawtimes);
        times.addAll(rawtimes);
        ResourceManager rMan = ResourceManager.getManager();
        String format = rMan.getString("timeCourseDrawer.perTablePertTitleFormat");
        out.print("<center><h2>");
        out.print(MessageFormat.format(format, this.client_.getName(), this.pertClient_.getName()));
        out.print("</h2></center>\n");
        int num = 132 + times.size() * 83;
        out.print("<table width=\"");
        out.print(num);
        out.println("\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">");
        out.println("<tr>");
        ArrayList<RegionData> reducedReg = new ArrayList<RegionData>();
        HashSet<String> usedRegions = new HashSet<String>();
        int numRegions1 = regions.size();
        block0: for (int i = 0; i < numRegions1; ++i) {
            RegionData reg = (RegionData)regions.get(i);
            Iterator tmit = times.iterator();
            while (tmit.hasNext()) {
                Integer timeObj = (Integer)tmit.next();
                TimeCourseGene.VariableLevel varLev = new TimeCourseGene.VariableLevel();
                int level = this.pertClient_.getExpressionLevelForSource(reg.region, timeObj, 0, varLev);
                if (level == 0 || level == -1) continue;
                usedRegions.add(reg.region);
                reducedReg.add(reg);
                continue block0;
            }
        }
        out.println("<td valign=\"center\">");
        out.print("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">");
        this.pertHoriz(out, 3, WHITE_COLOR_);
        out.println("<tr>");
        this.pertVert(out, WHITE_COLOR_);
        out.print("<td width=\"130\" align=\"center\" valign=\"center\"><b>");
        out.print(" ");
        out.println("</b></td>");
        this.pertVert(out, WHITE_COLOR_);
        out.println("</tr>");
        this.pertHoriz(out, 3, WHITE_COLOR_);
        out.println("<tr>");
        this.pertVert(out, WHITE_COLOR_);
        out.print("<td width=\"130\" align=\"center\" valign=\"center\"><b>");
        out.print(" ");
        out.println("</b></td>");
        this.pertVert(out, WHITE_COLOR_);
        out.println("</tr>");
        this.pertHoriz(out, 3, MID_GREY_COLOR);
        int numRegions = regions.size();
        for (int i = 0; i < numRegions; ++i) {
            RegionData reg = (RegionData)regions.get(i);
            if (!usedRegions.contains(reg.region)) continue;
            out.println("<tr>");
            this.pertVert(out, BLACK_COLOR_);
            out.print("<td width=\"130\" height=\"40\" align=\"center\" valign=\"center\"><b>");
            out.print(reg.region);
            out.println("</b></td>");
            this.pertVert(out, BLACK_COLOR_);
            out.println("</tr>");
            this.pertHoriz(out, 3, MID_GREY_COLOR);
        }
        out.println("</table>");
        out.println("</td>");
        this.pertBigVert(out, BIG_VERT_COLOR_);
        Iterator tmit = times.iterator();
        while (tmit.hasNext()) {
            Integer timeObj = (Integer)tmit.next();
            out.println("<td valign=\"center\">");
            out.print("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">");
            this.pertHoriz(out, 5, MID_GREY_COLOR);
            out.println("<tr>");
            this.pertVert(out, BLACK_COLOR_);
            out.print("<td width=\"70\" align=\"center\" valign=\"center\" colspan=\"3\"><b>");
            String timeStr = TimeAxisDefinition.getTimeDisplay(timeObj, true, false);
            out.print(timeStr);
            out.println("</b></td>");
            this.pertVert(out, BLACK_COLOR_);
            out.println("</tr>");
            this.pertHoriz(out, 5, MID_GREY_COLOR);
            out.println("<tr>");
            this.pertVert(out, BLACK_COLOR_);
            out.print("<td width=\"35\" align=\"center\" valign=\"center\"><b>");
            out.print(rMan.getString("timeCourseTable.wildType"));
            out.println("</b></td>");
            this.pertVert(out, BLACK_COLOR_);
            out.print("<td width=\"35\" align=\"center\" valign=\"center\"><b>");
            out.print(rMan.getString("timeCourseTable.pertType"));
            out.println("</b></td>");
            this.pertVert(out, BLACK_COLOR_);
            out.println("</tr>");
            this.pertHoriz(out, 5, MID_GREY_COLOR);
            for (int i = 0; i < numRegions; ++i) {
                RegionData reg = (RegionData)regions.get(i);
                if (!usedRegions.contains(reg.region)) continue;
                out.println("<tr>");
                this.buildPertCell(out, reg.region, timeObj);
                out.println("</tr>");
                this.pertHoriz(out, 5, MID_GREY_COLOR);
            }
            out.println("</table>");
            out.println("</td>");
            if (!tmit.hasNext()) continue;
            this.pertBigVert(out, BIG_VERT_COLOR_);
        }
        out.println("</tr>");
        out.println("</table>");
        String timeCourseNote = this.pertClient_.getTimeCourseNote();
        if (timeCourseNote != null && !timeCourseNote.trim().equals("")) {
            out.println("<p>");
            out.print("<b>");
            out.print(rMan.getString("timeCourseTable.note"));
            out.print(":</b> ");
            out.println(CharacterEntityMapper.mapEntities(timeCourseNote, false));
            out.println("</p>");
        }
        int clientKey = this.needKey(reducedReg, times, this.client_);
        int pertKey = this.needKey(reducedReg, times, this.pertClient_);
        int retval = Math.max(clientKey, pertKey);
        return retval;
    }

    public int getExpressionTable(PrintWriter out, TimeCourseData tcd, boolean showTree) {
        TreeSet times;
        List regions;
        if (this.client_.isInternalOnly()) {
            return 0;
        }
        ResourceManager rMan = ResourceManager.getManager();
        String format = rMan.getString("timeCourseDrawer.perTableTitleFormat");
        out.print("<center><h2>");
        out.print(MessageFormat.format(format, this.client_.getName()));
        out.print("</h2></center>\n");
        if (showTree) {
            TreeModel rawHierTree = tcd.getRegionHierarchyTree();
            regions = new ArrayList();
            times = new TreeSet();
            this.drawTableWithLineage(out, rawHierTree, regions, times);
        } else {
            HashSet rawregions = new HashSet();
            this.client_.getRegions(rawregions);
            List ordered = tcd.hierarchyIsSet() ? tcd.getRegionHierarchyList() : tcd.getRegionsKeepOrder();
            regions = this.sortRegions(rawregions, ordered);
            HashSet rawtimes = new HashSet();
            this.client_.getInterestingTimes(rawtimes);
            times = new TreeSet();
            times.addAll(rawtimes);
            int num = 130 + times.size() * 70;
            out.print("<table width=\"");
            out.print(num);
            out.println("\" border=\"1\" cellpadding=\"0\" cellspacing=\"0\">");
            out.println("<tr>");
            out.println("<td width=\"130\" align=\"center\" valign=\"center\">");
            out.println(this.client_.getName());
            out.println("</td>");
            Iterator tmit = times.iterator();
            while (tmit.hasNext()) {
                Integer timeObj = (Integer)tmit.next();
                out.print("<td width=\"70\" align=\"center\" valign=\"center\"><b>");
                String timeStr = TimeAxisDefinition.getTimeDisplay(timeObj, true, false);
                out.print(timeStr);
                out.println("</b></td>");
            }
            out.println("</tr>");
            Iterator regIt = regions.iterator();
            while (regIt.hasNext()) {
                RegionData reg = (RegionData)regIt.next();
                out.println("<tr>");
                out.println("<td width=\"130\" align=\"center\" valign=\"center\"><b>");
                out.println(reg.region);
                out.println("</b></td>");
                tmit = times.iterator();
                while (tmit.hasNext()) {
                    Integer hour = (Integer)tmit.next();
                    this.buildCell(out, reg.region, hour, this.client_);
                }
                out.println("</tr>");
            }
            out.println("</table>");
        }
        String timeCourseNote = this.client_.getTimeCourseNote();
        if (timeCourseNote != null && !timeCourseNote.trim().equals("")) {
            out.println("<p>");
            out.print("<b>");
            out.print(ResourceManager.getManager().getString("timeCourseTable.note"));
            out.print(":</b> ");
            out.println(CharacterEntityMapper.mapEntities(timeCourseNote, false));
            out.println("</p>");
        }
        out.println("<p></p>");
        return this.needKey(regions, times, this.client_);
    }

    public static String buildKey(int needKey, boolean showTree, boolean showWTPert) {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        if ((needKey & 1) != 0) {
            if (showTree) {
                out.print("<p><center>");
                out.print(ResourceManager.getManager().getString("timeCourseTable.cellEdgeNote"));
                out.println("</center></p><p></p>");
            }
            if (showWTPert) {
                TimeCourseTableDrawer.buildWTPertNote(out);
            }
            TimeCourseTableDrawer.buildKey(out);
        }
        boolean didC = false;
        if ((needKey & 2) != 0) {
            TimeCourseTableDrawer.buildConfidenceKey(out);
            didC = true;
        }
        if ((needKey & 4) != 0) {
            if (didC) {
                out.println("<br>");
            }
            TimeCourseTableDrawer.buildSourceKey(out);
        }
        return sw.getBuffer().toString();
    }

    private int needKey(List regions, SortedSet times, Client client) {
        int retval = 1;
        int numRegions = regions.size();
        TimeCourseGene.VariableLevel varLev = new TimeCourseGene.VariableLevel();
        for (int i = 0; i < numRegions; ++i) {
            RegionData reg = (RegionData)regions.get(i);
            Iterator tmit = times.iterator();
            while (tmit.hasNext()) {
                int confidence;
                Integer hourObj = (Integer)tmit.next();
                int hour = hourObj;
                int level = client.getExpressionLevelForSource(reg.region, hour, 0, varLev);
                if (level == -1 || level == 0) continue;
                int source = client.getExprSource(reg.region, hour);
                if (source != 0) {
                    retval |= 4;
                }
                if ((confidence = client.getConfidence(reg.region, hour)) == 0) continue;
                retval |= 2;
            }
        }
        return retval;
    }

    private void drawTableWithLineage(PrintWriter out, TreeModel rawHierTree, List regions, TreeSet times) {
        DefaultMutableTreeNode rawRootNode = (DefaultMutableTreeNode)rawHierTree.getRoot();
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        DefaultTreeModel hierTree = new DefaultTreeModel(rootNode);
        this.stockRegionTree(rawHierTree, rawRootNode, hierTree, rootNode, regions);
        HashSet rawtimes = new HashSet();
        this.client_.getInterestingTimes(rawtimes);
        times.addAll(rawtimes);
        int num = 130 + times.size() * 73 + 6;
        out.print("<table width=\"");
        out.print(num);
        out.println("\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">");
        int numTimes = times.size();
        this.horiz(out, numTimes + 1, 0, null);
        out.println("<tr>");
        this.vert(out, null);
        out.println("<td width=\"130\" align=\"center\" valign=\"center\">");
        out.println(this.client_.getName());
        out.println("</td>");
        this.vert(out, null);
        Iterator tmit = times.iterator();
        while (tmit.hasNext()) {
            Integer timeObj = (Integer)tmit.next();
            out.println("<td width=\"70\" align=\"center\" valign=\"center\"><b>");
            String timeStr = TimeAxisDefinition.getTimeDisplay(timeObj, true, false);
            out.print(timeStr);
            out.println("</b></td>");
            this.vert(out, null);
        }
        out.println("</tr>");
        int numRegions = regions.size();
        TreeInTable trit = new TreeInTable(hierTree, times, numRegions);
        for (int i = 0; i < numRegions; ++i) {
            RegionData reg = (RegionData)regions.get(i);
            RowColorSpec rcs = trit.getTopColor(i);
            this.horiz(out, numTimes + 1, rcs == null ? 0 : rcs.startCol, rcs == null ? null : rcs.color);
            out.println("<tr>");
            this.vert(out, null);
            out.println("<td width=\"130\" align=\"center\" valign=\"center\"><b>");
            out.println(reg.region);
            out.println("</b></td>");
            int currTime = 0;
            Map colCols = trit.getColumnColors(i);
            String col = (String)colCols.get(new Integer(-1));
            this.vert(out, col);
            tmit = times.iterator();
            while (tmit.hasNext()) {
                Integer hour = (Integer)tmit.next();
                this.buildCell(out, reg.region, hour, this.client_);
                col = (String)colCols.get(new Integer(currTime++));
                this.vert(out, col);
            }
            out.println("</tr>");
        }
        this.horiz(out, numTimes + 1, 0, null);
        out.println("</table>");
    }

    private void horiz(PrintWriter out, int columns, int colorStartCol, String color) {
        int rawColumns = columns + (columns + 1) * 3;
        int rawColorStart = 3 + colorStartCol * 4 + 1;
        this.rawHoriz(out, rawColumns, rawColorStart, color);
    }

    private void rawHoriz(PrintWriter out, int colspan, int colorStart, String color) {
        String spacer = "<spacer type=\"block\" height=\"1\" width=\"1\">";
        int colorSpan = color == null ? 0 : colspan - colorStart;
        int frontSpan = color == null ? colspan : colspan - colorSpan;
        out.print("<tr>");
        if (frontSpan != 0) {
            out.print("<td colspan=\"");
            out.print(frontSpan);
            out.print("\" bgcolor=\"#888888\" ");
            out.print("height=\"1\">");
            out.print(spacer);
            out.print("</td>");
        }
        if (color != null) {
            out.print("<td colspan=\"");
            out.print(colorSpan);
            out.print("\" bgcolor=\"");
            out.print(color);
            out.print("\" height=\"1\">");
            out.print(spacer);
            out.print("</td>");
        }
        out.println("</tr>");
        out.print("<tr>");
        if (frontSpan != 0) {
            out.print("<td colspan=\"");
            out.print(frontSpan);
            out.print("\" bgcolor=\"white\" ");
            out.print("height=\"1\">");
            out.print(spacer);
            out.print("</td>");
        }
        if (color != null) {
            out.print("<td colspan=\"");
            out.print(colorSpan);
            out.print("\" bgcolor=\"");
            out.print(color);
            out.print("\" height=\"1\">");
            out.print(spacer);
            out.print("</td>");
        }
        out.println("</tr>");
        out.print("<tr>");
        if (frontSpan != 0) {
            out.print("<td colspan=\"");
            out.print(frontSpan);
            out.print("\" bgcolor=\"black\" ");
            out.print("height=\"1\">");
            out.print(spacer);
            out.print("</td>");
        }
        if (color != null) {
            out.print("<td colspan=\"");
            out.print(colorSpan);
            out.print("\" bgcolor=\"");
            out.print(color);
            out.print("\" height=\"1\">");
            out.print(spacer);
            out.print("</td>");
        }
        out.println("</tr>");
    }

    private void vert(PrintWriter out, String color) {
        if (color == null) {
            out.println("<td bgcolor=\"black\" width=\"1\"></td>");
            out.println("<td bgcolor=\"white\" width=\"1\"></td>");
            out.println("<td bgcolor=\"black\" width=\"1\"></td>");
        } else {
            out.print("<td bgcolor=\"");
            out.print(color);
            out.println("\" width=\"1\"></td>");
            out.print("<td bgcolor=\"");
            out.print(color);
            out.println("\" width=\"1\"></td>");
            out.print("<td bgcolor=\"");
            out.print(color);
            out.println("\" width=\"1\"></td>");
        }
    }

    private void pertVert(PrintWriter out, String color) {
        out.print("<td bgcolor=\"");
        out.print(color);
        out.println("\" width=\"1\"></td>");
    }

    private void pertBigVert(PrintWriter out, String color) {
        out.print("<td bgcolor=\"");
        out.print(color);
        out.println("\" width=\"10\"></td>");
    }

    private void pertHoriz(PrintWriter out, int span, String color) {
        String spacer = "<spacer type=\"block\" height=\"1\" width=\"1\">";
        out.print("<tr>");
        out.print("<td colspan=\"");
        out.print(span);
        out.print("\" bgcolor=\"");
        out.print(color);
        out.print("\" height=\"1\">");
        out.print(spacer);
        out.print("</td>");
        out.println("</tr>");
    }

    private void buildCell(PrintWriter out, String reg, int hour, Client confClient) {
        TimeCourseGene.VariableLevel varLev = new TimeCourseGene.VariableLevel();
        int level = this.client_.getExpressionLevelForSource(reg, hour, 0, varLev);
        if (level == 0 || level == 4) {
            out.print("<td width=\"70\" align=\"center\" valign=\"center\" ");
        } else {
            out.print("<td width=\"70\" align=\"right\" valign=\"bottom\" ");
        }
        this.buildCellGuts(out, reg, hour, level, varLev, confClient);
        out.println("</td>");
    }

    private void buildCellGuts(PrintWriter out, String reg, int hour, int level, TimeCourseGene.VariableLevel varLev, Client confClient) {
        switch (level) {
            case -1: {
                out.println("bgcolor=\"#DDDDDD\">");
                out.println("<br>");
                break;
            }
            case 0: {
                out.println("bgcolor=\"#FFFFFF\">");
                out.println("-");
                break;
            }
            case 1: {
                out.println("bgcolor=\"#FFFFFF\">");
                this.buildConfidenceAndSource(out, reg, hour, null, confClient);
                break;
            }
            case 2: {
                out.println("bgcolor=\"#CCFFCC\">");
                this.buildConfidenceAndSource(out, reg, hour, null, confClient);
                break;
            }
            case 3: {
                out.println("bgcolor=\"#66EE66\">");
                this.buildConfidenceAndSource(out, reg, hour, null, confClient);
                break;
            }
            case 4: {
                String col = this.variableBlockColor(varLev.level, false);
                out.print("bgcolor=\"#");
                out.print(col.substring(2));
                out.println("\">");
                this.buildConfidenceAndSource(out, reg, hour, varLev, confClient);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private void buildPertCell(PrintWriter out, String reg, int hour) {
        this.pertVert(out, BLACK_COLOR_);
        TimeCourseGene.VariableLevel varLev = new TimeCourseGene.VariableLevel();
        boolean controlFromPert = this.pertClient_.usingDistinctControlExpr();
        int level = controlFromPert ? this.pertClient_.getControlExpressionLevelForSource(reg, hour, 0, varLev) : this.client_.getExpressionLevelForSource(reg, hour, 0, varLev);
        if (level == 0 || level == 4) {
            out.print("<td width=\"35\" height=\"40\" align=\"center\" valign=\"center\" ");
        } else {
            out.print("<td width=\"35\" height=\"40\" align=\"right\" valign=\"bottom\" ");
        }
        this.buildCellGuts(out, reg, hour, level, varLev, controlFromPert ? this.pertClient_ : this.client_);
        out.println("</td>");
        this.pertVert(out, level == -1 ? NO_REGION_COLOR_ : BLACK_COLOR_);
        TimeCourseGene.VariableLevel pertVarLev = new TimeCourseGene.VariableLevel();
        int pertLevel = this.pertClient_.getExpressionLevelForSource(reg, hour, 0, pertVarLev);
        if (pertLevel == 0 || pertLevel == 4) {
            out.print("<td width=\"35\" height=\"40\" align=\"center\" valign=\"center\" ");
        } else {
            out.print("<td width=\"35\" height=\"40\" align=\"right\" valign=\"bottom\" ");
        }
        this.buildCellGuts(out, reg, hour, pertLevel, pertVarLev, this.pertClient_);
        out.println("</td>");
        this.pertVert(out, BLACK_COLOR_);
    }

    private String variableBlockColor(double level, boolean forRegion) {
        float[] whichActive = forRegion ? this.activeRegionHSV_ : this.activeHSV_;
        this.colHSB_[0] = whichActive[0];
        this.colHSB_[1] = this.inactiveHSV_[1] + (float)level * (whichActive[1] - this.inactiveHSV_[1]);
        this.colHSB_[2] = this.inactiveHSV_[2] + (float)level * (whichActive[2] - this.inactiveHSV_[2]);
        int varCol = Color.HSBtoRGB(this.colHSB_[0], this.colHSB_[1], this.colHSB_[2]);
        return Integer.toHexString(varCol);
    }

    private void buildCellWithQPCR(PrintWriter out, String reg, Set sources, int hour) {
        TimeCourseGene.VariableLevel varLev = new TimeCourseGene.VariableLevel();
        int level = this.client_.getExpressionLevelForSource(reg, hour, 0, varLev);
        out.println("<td WIDTH=\"70\" ");
        switch (level) {
            case -1: {
                out.println("BGCOLOR=\"#DDDDDD\">");
                this.buildQPCRList(out, sources);
                break;
            }
            case 0: {
                out.println("BGCOLOR=\"#FFFFFF\">");
                out.println("---");
                this.buildQPCRList(out, sources);
                break;
            }
            case 1: {
                out.println("BGCOLOR=\"#FFFFFF\">");
                this.buildQPCRList(out, sources);
                break;
            }
            case 2: {
                out.println("BGCOLOR=\"#CCCCFF\">");
                this.buildQPCRList(out, sources);
                break;
            }
            case 3: {
                out.println("BGCOLOR=\"#6666EE\">");
                this.buildQPCRList(out, sources);
                break;
            }
            case 4: {
                String col = this.variableBlockColor(varLev.level, true);
                out.print("bgcolor=\"#");
                out.print(col.substring(2));
                out.println("\">");
                this.buildQPCRList(out, sources);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        out.println("</td>");
    }

    private void buildConfidenceAndSource(PrintWriter out, String reg, int hour, TimeCourseGene.VariableLevel varLev, Client csClient) {
        if (varLev == null) {
            this.buildFixedConfidenceAndSource(out, reg, hour, csClient);
            return;
        }
        out.println(varLev.level);
        int confidence = csClient.getConfidence(reg, hour);
        int source = csClient.getExprSource(reg, hour);
        String cStr = this.confTag(confidence);
        String sStr = this.sourceTag(source);
        if (sStr == null) {
            if (cStr == null) {
                return;
            }
            if (cStr.equals("<br>")) {
                out.println("<br>");
                return;
            }
        }
        if (cStr != null && cStr.equals("<br>")) {
            cStr = null;
        }
        out.print("<sub>");
        if (cStr != null) {
            out.print(cStr);
            if (sStr != null) {
                out.print("; ");
            }
        }
        if (sStr != null) {
            out.print(sStr);
        }
        out.println("</sub>");
    }

    private void buildFixedConfidenceAndSource(PrintWriter out, String reg, int hour, Client csClient) {
        int confidence = csClient.getConfidence(reg, hour);
        int source = csClient.getExprSource(reg, hour);
        String cStr = this.confTag(confidence);
        String sStr = this.sourceTag(source);
        if (sStr == null) {
            if (cStr == null) {
                return;
            }
            if (cStr.equals("<br>")) {
                out.println("<br>");
                return;
            }
        }
        if (cStr != null && cStr.equals("<br>")) {
            cStr = null;
        }
        out.print("<font size=\"2\">");
        if (cStr != null) {
            out.print(cStr);
            if (sStr != null) {
                out.print("; ");
            }
        }
        if (sStr != null) {
            out.print(sStr);
        }
        out.println("</font>");
    }

    private String sourceTag(int source) {
        switch (source) {
            case 0: {
                return null;
            }
            case 1: {
                return "M";
            }
            case 2: {
                return "Z";
            }
            case 3: {
                return "M+Z";
            }
        }
        throw new IllegalArgumentException();
    }

    private String confTag(int confidence) {
        switch (confidence) {
            case 0: {
                return null;
            }
            case 4: {
                return "A";
            }
            case 1: {
                return "I";
            }
            case 2: {
                return "R";
            }
            case 3: {
                return "Q";
            }
        }
        return "<br>";
    }

    private void buildQPCRList(PrintWriter out, Set sources) {
        int size = sources.size();
        if (size == 0) {
            return;
        }
        boolean first = true;
        Iterator sit = sources.iterator();
        while (sit.hasNext()) {
            PerturbationData.SourceInfo source = (PerturbationData.SourceInfo)sit.next();
            if (source.sign == 3) continue;
            if (!first) {
                out.print(", ");
            } else {
                first = false;
            }
            out.print("<FONT SIZE=2 COLOR=\"");
            if (source.sign == 2) {
                out.print("#66CC66\">");
            } else if (source.sign == 1) {
                out.print("#CC6666\">");
            } else {
                out.print("#000000\">");
            }
            out.print(source.source);
            out.println("</FONT>");
        }
    }

    public static void buildKey(PrintWriter out) {
        out.println("<table WIDTH=810 BORDER=1 CELLPADDING=2 CELLSPACING=0>");
        out.println("<tr align=\"Center\" valign=\"Center\" >");
        out.println("<td width=\"100\" >");
        out.println("<B>EXPRESSION:</B>");
        out.println("</td>");
        out.println("<td width=\"100\" >");
        out.print("Region not Present");
        out.println("</td>");
        out.println("<td width=\"100\" >");
        out.print("No Data");
        out.println("</td>");
        out.println("<td width=\"100\" >");
        out.print("Not Expressed");
        out.println("</td>");
        out.println("<td width=\"100\" >");
        out.print("Weak Expression");
        out.println("</td>");
        out.println("<td width=\"100\" >");
        out.print("Expressed");
        out.println("</td>");
        out.println("</tr>");
        out.println("<tr align=\"Center\" valign=\"Center\" >");
        out.println("<td width=\"100\">");
        out.println("<B>COLOR:</B>");
        out.println("</td>");
        out.print("<td width=\"100\"");
        out.print("bgcolor=\"#DDDDDD\">");
        out.print("<br>");
        out.println("</td>");
        out.print("<td width=\"100\"");
        out.print("bgcolor=\"#FFFFFF\">");
        out.print("-");
        out.println("</td>");
        out.print("<td width=\"100\"");
        out.print("bgcolor=\"#FFFFFF\">");
        out.print("<br>");
        out.println("</td>");
        out.print("<td width=\"100\"");
        out.print("bgcolor=\"#CCFFCC\">");
        out.print("<br>");
        out.println("</td>");
        out.print("<td width=\"100\"");
        out.print("bgcolor=\"#66EE66\">");
        out.print("<br>");
        out.println("</td>");
        out.println("</tr>");
        out.println("</table>");
    }

    public static void buildWTPertNote(PrintWriter out) {
        out.print("<p><center>");
        out.print(ResourceManager.getManager().getString("timeCourseTable.wildVersusPertNote"));
        out.println("</center></p>");
        out.println("<p></p>");
    }

    public static void buildConfidenceKey(PrintWriter out) {
        out.print("<b>CONFIDENCE:</b>");
        out.print("&nbsp;&nbsp;&nbsp;[No Symbol] = Normal Confidence");
        out.print("&nbsp;&nbsp;&nbsp;I = Interpolated");
        out.print("&nbsp;&nbsp;&nbsp;R = Inferred");
        out.print("&nbsp;&nbsp;&nbsp;Q = Questionable");
        out.print("&nbsp;&nbsp;&nbsp;A = Assumption");
    }

    public static void buildSourceKey(PrintWriter out) {
        out.print("<b>SOURCE:</b>");
        out.print("&nbsp;&nbsp;&nbsp;M = Maternal");
        out.print("&nbsp;&nbsp;&nbsp;Z = Zygotic");
        out.print("&nbsp;&nbsp;&nbsp;[No Symbol] = Not Specified");
    }

    private RegionData buildRegionData(String region) {
        TimeCourseGene.VariableLevel varLev = new TimeCourseGene.VariableLevel();
        RegionData retval = new RegionData();
        retval.minHour = 10000;
        retval.maxHour = -1;
        retval.region = region;
        HashSet times = new HashSet();
        this.client_.getInterestingTimes(times);
        Iterator tmit = times.iterator();
        while (tmit.hasNext()) {
            Integer hour = (Integer)tmit.next();
            int hr = hour;
            int level = this.client_.getExpressionLevelForSource(region, hr, 0, varLev);
            if (level == -1) continue;
            if (hr < retval.minHour) {
                retval.minHour = hr;
            }
            if (hr <= retval.maxHour) continue;
            retval.maxHour = hr;
        }
        return retval;
    }

    private List sortRegions(HashSet regions, List regionOrder) {
        if (regionOrder == null) {
            TreeSet<RegionData> sorted = new TreeSet<RegionData>(new RegionComparator());
            Iterator rit = regions.iterator();
            while (rit.hasNext()) {
                String region = (String)rit.next();
                RegionData rd = this.buildRegionData(region);
                sorted.add(rd);
            }
            return new ArrayList(sorted);
        }
        ArrayList<RegionData> retval = new ArrayList<RegionData>();
        int numRO = regionOrder.size();
        for (int i = 0; i < numRO; ++i) {
            String region = (String)regionOrder.get(i);
            RegionData rd = this.buildRegionData(region);
            retval.add(rd);
        }
        return retval;
    }

    private void stockRegionTree(TreeModel hierTree, DefaultMutableTreeNode currNode, DefaultTreeModel newTree, DefaultMutableTreeNode newNode, List depthFirstList) {
        ArrayList<String> origOrder = new ArrayList<String>();
        HashMap<String, DefaultMutableTreeNode> regToKid = new HashMap<String, DefaultMutableTreeNode>();
        int kidCount = hierTree.getChildCount(currNode);
        for (int i = 0; i < kidCount; ++i) {
            DefaultMutableTreeNode kidNode = (DefaultMutableTreeNode)hierTree.getChild(currNode, i);
            String regID = (String)kidNode.getUserObject();
            origOrder.add(regID);
            regToKid.put(regID, kidNode);
        }
        TreeSet<RegionData> sorted = new TreeSet<RegionData>(new PreservingRegionComparator(origOrder));
        for (int i = 0; i < kidCount; ++i) {
            DefaultMutableTreeNode kidNode = (DefaultMutableTreeNode)hierTree.getChild(currNode, i);
            RegionData rd = this.buildRegionData((String)kidNode.getUserObject());
            sorted.add(rd);
        }
        Iterator sit = sorted.iterator();
        while (sit.hasNext()) {
            RegionData rd = (RegionData)sit.next();
            depthFirstList.add(rd);
            DefaultMutableTreeNode mtn = new DefaultMutableTreeNode(rd);
            newTree.insertNodeInto(mtn, newNode, newNode.getChildCount());
            DefaultMutableTreeNode kidNode = (DefaultMutableTreeNode)regToKid.get(rd.region);
            this.stockRegionTree(hierTree, kidNode, newTree, mtn, depthFirstList);
        }
    }

    private static class RowData {
        RowColorSpec rcs = null;
        HashMap vertColors = new HashMap();

        RowData() {
        }
    }

    private static class RowColorSpec {
        int startCol;
        String color;

        RowColorSpec(int startCol, String color) {
            this.startCol = startCol;
            this.color = color;
        }
    }

    private static class TreeBranch {
        Integer time;
        TreeSet rows;

        TreeBranch(Integer time) {
            this.time = time;
            this.rows = new TreeSet();
        }
    }

    private static class TreeInTableBlock {
        TreeMap branches;
        String color;

        TreeInTableBlock(TreeMap branches, Color color) {
            this.branches = branches;
            this.color = "#" + Integer.toHexString(color.getRGB()).substring(2);
        }
    }

    private static class TreeInTable {
        private ArrayList list_;
        private int maxCols_ = Database.getDB().getNumColors();
        private int colCount_ = 0;

        TreeInTable(DefaultTreeModel hierTree, SortedSet times, int numRows) {
            this.list_ = new ArrayList();
            for (int i = 0; i < numRows; ++i) {
                this.list_.add(new RowData());
            }
            ArrayList timeList = new ArrayList(times);
            DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)hierTree.getRoot();
            this.stockTheList(hierTree, rootNode, timeList, -1);
        }

        void addBlock(TreeInTableBlock block, int startRow) {
            int srFloor;
            Set times = block.branches.keySet();
            Iterator timit = times.iterator();
            int n = srFloor = startRow < 0 ? 0 : startRow;
            while (timit.hasNext()) {
                Integer time = (Integer)timit.next();
                TreeBranch tb = (TreeBranch)block.branches.get(time);
                Integer hiRow = (Integer)tb.rows.last();
                int lastRow = hiRow;
                for (int i = srFloor; i <= lastRow; ++i) {
                    RowData rd = (RowData)this.list_.get(i);
                    Integer tm1 = new Integer(time - 1);
                    rd.vertColors.put(tm1, block.color);
                    Integer checkRow = new Integer(i);
                    if (!tb.rows.contains(checkRow)) continue;
                    rd.rcs = new RowColorSpec(time, block.color);
                }
            }
        }

        Map getColumnColors(int row) {
            RowData rd = (RowData)this.list_.get(row);
            return rd.vertColors;
        }

        RowColorSpec getTopColor(int row) {
            RowData rd = (RowData)this.list_.get(row);
            return rd.rcs;
        }

        Color getNextColor() {
            Database db = Database.getDB();
            String colTag = null;
            while (colTag == null) {
                if ((colTag = db.getGeneColor(this.colCount_++)).equals("EX-green")) {
                    colTag = null;
                }
                if (this.colCount_ < this.maxCols_) continue;
                this.colCount_ = 0;
            }
            return db.getColor(colTag);
        }

        void stockTheList(DefaultTreeModel hierTree, DefaultMutableTreeNode currNode, List timeList, int startRow) {
            int kidCount = hierTree.getChildCount(currNode);
            TreeMap<Integer, TreeBranch> kidBranches = new TreeMap<Integer, TreeBranch>();
            int sibStart = startRow;
            int lastRow = startRow + 1;
            int kidStart = startRow + 1;
            RegionData cnuo = (RegionData)currNode.getUserObject();
            boolean multiKids = false;
            if (cnuo == null) {
                multiKids = kidCount > 1;
            }
            Color myColor = cnuo != null || multiKids ? this.getNextColor() : null;
            for (int i = 0; i < kidCount; ++i) {
                DefaultMutableTreeNode kidNode = (DefaultMutableTreeNode)hierTree.getChild(currNode, i);
                int decCount = this.getDecendantCount(hierTree, kidNode);
                lastRow += decCount + 1;
                RegionData regKid = (RegionData)kidNode.getUserObject();
                int minTimeIndex = timeList.indexOf(new Integer(regKid.minHour));
                Integer minTimeIndexObj = new Integer(minTimeIndex);
                TreeBranch bra = (TreeBranch)kidBranches.get(minTimeIndexObj);
                if (bra == null) {
                    bra = new TreeBranch(minTimeIndexObj);
                    kidBranches.put(minTimeIndexObj, bra);
                }
                bra.rows.add(new Integer(kidStart));
                if (decCount != 0) {
                    this.stockTheList(hierTree, kidNode, timeList, kidStart);
                    kidStart += decCount;
                }
                ++kidStart;
            }
            if (cnuo != null || multiKids) {
                this.addBlock(new TreeInTableBlock(kidBranches, myColor), sibStart);
            }
            sibStart = lastRow + 1;
        }

        int getDecendantCount(TreeModel tree, TreeNode node) {
            int kidCount;
            int retval = kidCount = tree.getChildCount(node);
            for (int i = 0; i < kidCount; ++i) {
                TreeNode kidNode = (TreeNode)tree.getChild(node, i);
                retval += this.getDecendantCount(tree, kidNode);
            }
            return retval;
        }
    }

    private static class RegionData {
        String region;
        int minHour;
        int maxHour;

        private RegionData() {
        }
    }

    private class PreservingRegionComparator
    implements Comparator {
        private List origOrder_;

        PreservingRegionComparator(List origOrder) {
            this.origOrder_ = origOrder;
        }

        public int compare(Object o1, Object o2) {
            RegionData rd1 = (RegionData)o1;
            RegionData rd2 = (RegionData)o2;
            if (rd1.minHour > rd2.minHour) {
                return -1;
            }
            if (rd2.minHour > rd1.minHour) {
                return 1;
            }
            int reg1Index = this.origOrder_.indexOf(rd1.region);
            int reg2Index = this.origOrder_.indexOf(rd2.region);
            return reg1Index - reg2Index;
        }
    }

    private class RegionComparator
    implements Comparator {
        private RegionComparator() {
        }

        public int compare(Object o1, Object o2) {
            RegionData rd1 = (RegionData)o1;
            RegionData rd2 = (RegionData)o2;
            if (rd1.minHour > rd2.minHour) {
                return 1;
            }
            if (rd2.minHour > rd1.minHour) {
                return -1;
            }
            if (rd1.maxHour > rd2.maxHour) {
                return 1;
            }
            if (rd2.maxHour > rd1.maxHour) {
                return -1;
            }
            return rd1.region.compareTo(rd2.region);
        }
    }

    public static interface Client {
        public boolean isInternalOnly();

        public void getRegions(Set var1);

        public void getInterestingTimes(Set var1);

        public String getName();

        public String getTimeCourseNote();

        public int getExpressionLevelForSource(String var1, int var2, int var3, TimeCourseGene.VariableLevel var4);

        public int getConfidence(String var1, int var2);

        public int getExprSource(String var1, int var2);
    }
}

