/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.systemsbiology.biotapestry.analysis.AllPathsResult;
import org.systemsbiology.biotapestry.cmd.AddCommands;
import org.systemsbiology.biotapestry.db.GenomeSource;
import org.systemsbiology.biotapestry.genome.DBGenome;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.ui.BusProperties;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.ui.RectangularTreeEngine;
import org.systemsbiology.biotapestry.ui.layouts.GenomeSubset;
import org.systemsbiology.biotapestry.ui.layouts.NetModuleLinkExtractor;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutEngine;
import org.systemsbiology.biotapestry.ui.layouts.WorksheetLayout;
import org.systemsbiology.biotapestry.util.AsynchExitRequestException;

public class AllPathsLayoutBuilder {
    public Layout buildNeighborLayout(FontRenderContext frc, GenomeSource src) {
        DBGenome genome = (DBGenome)src.getGenome();
        Layout retval = new Layout("__BOGUSKEY__", genome.getID());
        retval.setAlternateGenomeSource(src);
        WorksheetLayout wlo = new WorksheetLayout(true);
        WorksheetLayout.WorksheetLayoutParams worksheetParams = WorksheetLayout.getDefaultParams(false, true);
        worksheetParams.targSize = 5;
        AddCommands ac = new AddCommands(null, null);
        ac.junkLayout(genome, retval, null, frc);
        Point2D.Double center = new Point2D.Double(0.0, 0.0);
        try {
            GenomeSubset subset = new GenomeSubset(src, (Point2D)center);
            ArrayList<GenomeSubset> sList = new ArrayList<GenomeSubset>();
            sList.add(subset);
            NetModuleLinkExtractor.SubsetAnalysis sa = new NetModuleLinkExtractor().analyzeForMods(sList, null);
            SpecialtyLayoutEngine sle = new SpecialtyLayoutEngine(sList, retval, wlo, sa, center, ac, worksheetParams, true, false);
            sle.specialtyLayout(null, null, 0.0, 0.0);
        }
        catch (AsynchExitRequestException aerex) {
            throw new IllegalStateException();
        }
        return retval;
    }

    public Layout buildLayout(AllPathsResult allPaths, String genomeKey, FontRenderContext frc, Layout colorRef, GenomeSource src) {
        Layout retval = new Layout("__BOGUSKEY__", genomeKey);
        Genome genome = src.getGenome(genomeKey);
        retval.setAlternateGenomeSource(src);
        TreeMap<Integer, ArrayList<String>> depthMap = new TreeMap<Integer, ArrayList<String>>();
        int nodeCount = 0;
        Iterator nit = allPaths.getNodes();
        while (nit.hasNext()) {
            String nodeID = (String)nit.next();
            Integer depth = allPaths.getDepth(nodeID);
            ArrayList<String> nodeList = (ArrayList<String>)depthMap.get(depth);
            if (nodeList == null) {
                nodeList = new ArrayList<String>();
                depthMap.put(depth, nodeList);
            }
            nodeList.add(nodeID);
            ++nodeCount;
        }
        String[] positions = new String[nodeCount];
        Iterator dit = depthMap.keySet().iterator();
        int depthCount = 0;
        int fullCount = 0;
        while (dit.hasNext()) {
            Integer depth = (Integer)dit.next();
            ArrayList nodes = (ArrayList)depthMap.get(depth);
            Iterator dnit = nodes.iterator();
            int count = 0;
            while (dnit.hasNext()) {
                String nodeID = (String)dnit.next();
                double x = (double)depthCount * 250.0;
                double y = (double)count++ * 300.0;
                int type = genome.getNode(nodeID).getNodeType();
                NodeProperties np = new NodeProperties(retval, type, nodeID, x, y, false);
                retval.setNodeProperties(nodeID, np);
                positions[fullCount++] = nodeID;
            }
            ++depthCount;
        }
        Iterator lit = allPaths.getLinks();
        while (lit.hasNext()) {
            String linkID = (String)lit.next();
            String srcID = genome.getLinkage(linkID).getSource();
            String existingID = null;
            BusProperties lp = null;
            Iterator lit2 = allPaths.getLinks();
            while (lit2.hasNext()) {
                BusProperties testProp;
                String linkID2 = (String)lit2.next();
                String srcID2 = genome.getLinkage(linkID2).getSource();
                if (!srcID.equals(srcID2) || (testProp = retval.getLinkProperties(linkID2)) == null) continue;
                lp = testProp;
                existingID = linkID2;
            }
            BusProperties nlp = new BusProperties(genome, linkID, 0.0f, 0.0f, "black");
            LinkSegmentID segID = LinkSegmentID.buildIDForDirect(linkID);
            nlp.linkSplitSupport(segID, new Point2D.Double(0.0, 0.0));
            if (lp == null) {
                retval.setLinkProperties(linkID, nlp);
                continue;
            }
            LinkSegmentID lsid = LinkSegmentID.buildIDForStartDrop();
            lsid.tagIDWithEndpoint("E");
            retval.mergeNewLinkToTreeAtSegment(frc, existingID, nlp, lsid);
        }
        this.cleanupLayout(allPaths, genome, retval, positions, frc, colorRef);
        return retval;
    }

    private void cleanupLayout(AllPathsResult allPaths, Genome genome, Layout layout, String[] positions, FontRenderContext frc, Layout colorRef) {
        RectangularTreeEngine ce = new RectangularTreeEngine();
        int lastColor = 0;
        for (int i = 0; i < positions.length; ++i) {
            int lc = ce.buildBus(positions[i], positions, null, genome, layout, lastColor, allPaths.getLinkSet(), frc, 2, colorRef);
            if (lc == -1) continue;
            lastColor = lc;
        }
    }
}

