/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import org.systemsbiology.biotapestry.cmd.ZoomTarget;
import org.systemsbiology.biotapestry.db.SimpleWorkspaceSource;
import org.systemsbiology.biotapestry.db.Workspace;
import org.systemsbiology.biotapestry.ui.ZoomPresentation;
import org.systemsbiology.biotapestry.util.UndoSupport;

public class BasicZoomTargetSupport
implements ZoomTarget {
    protected ZoomPresentation myGenomePre_;
    protected String layout_ = null;
    protected String genomeKey_ = null;
    protected double zoom_ = 0.38;
    protected AffineTransform transform_ = new AffineTransform();
    protected JPanel paintTarget_;
    protected SimpleWorkspaceSource workspaceSource_;
    protected Rectangle2D clipRect_;

    public BasicZoomTargetSupport(ZoomPresentation genomePre, JPanel paintTarget, SimpleWorkspaceSource workspaceSource) {
        this.transform_.scale(this.zoom_, this.zoom_);
        this.myGenomePre_ = genomePre;
        this.paintTarget_ = paintTarget;
        this.workspaceSource_ = workspaceSource;
        this.layout_ = null;
        this.genomeKey_ = "I am not null";
        this.clipRect_ = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
    }

    public void setCurrClipRect(Rectangle2D clipRect) {
        this.clipRect_.setRect(clipRect);
    }

    public void incrementToNextSelection() {
        this.myGenomePre_.bumpNextSelection(this.genomeKey_);
    }

    public void decrementToPreviousSelection() {
        this.myGenomePre_.bumpPreviousSelection(this.genomeKey_);
    }

    public void repaint() {
        this.paintTarget_.repaint();
    }

    public void setTransform(AffineTransform transform) {
        this.transform_ = transform;
    }

    public AffineTransform getTransform() {
        return this.transform_;
    }

    public Dimension getPreferredSize() {
        Rectangle rect = this.workspaceSource_.getWorkspace().getWorkspace();
        int width = (int)((double)rect.width * this.zoom_);
        int height = (int)((double)rect.height * this.zoom_);
        return new Dimension(width, height);
    }

    public Rectangle getWorkspaceBounds() {
        return (Rectangle)this.workspaceSource_.getWorkspace().getWorkspace().clone();
    }

    public Point getCenterPoint() {
        Workspace ws = this.workspaceSource_.getWorkspace();
        Point2D center = ws.getCenter();
        Point2D centerPoint = (Point2D)center.clone();
        this.transform_.transform(centerPoint, centerPoint);
        int x = (int)Math.round(centerPoint.getX());
        int y = (int)Math.round(centerPoint.getY());
        Point pt = new Point(x, y);
        return pt;
    }

    public Point2D getRawCenterPoint() {
        Workspace ws = this.workspaceSource_.getWorkspace();
        Point2D center = ws.getCenter();
        return (Point2D)center.clone();
    }

    public void fixCenterPoint(boolean doComplete, UndoSupport support, boolean closeIt) {
    }

    public Dimension getBasicSize(boolean doComplete, boolean doBuffer, int moduleHandling) {
        Rectangle origRect = this.myGenomePre_.getRequiredSize(this.genomeKey_, this.layout_, doComplete, doBuffer, false, false, null, null, null);
        return new Dimension(origRect.width, origRect.height);
    }

    public Rectangle getCurrentBasicBounds(boolean doComplete, boolean doBuffer, int moduleHandling) {
        return this.myGenomePre_.getRequiredSize(this.genomeKey_, this.layout_, doComplete, doBuffer, false, false, null, null, null);
    }

    public Rectangle getSelectedBounds() {
        if (this.genomeKey_ == null) {
            return null;
        }
        return this.myGenomePre_.getSelectionSize(this.genomeKey_, this.layout_);
    }

    public boolean haveCurrentSelectionForBounds() {
        if (this.genomeKey_ == null) {
            return false;
        }
        return this.myGenomePre_.haveCurrentSelection();
    }

    public boolean haveMultipleSelectionsForBounds() {
        if (this.genomeKey_ == null) {
            return false;
        }
        return this.myGenomePre_.haveMultipleSelections();
    }

    public Rectangle getCurrentSelectedBounds() {
        if (this.genomeKey_ == null) {
            return null;
        }
        return this.myGenomePre_.getCurrentSelectionSize(this.genomeKey_, this.layout_);
    }

    public Rectangle getAllModelBounds() {
        return null;
    }

    public Point pointToViewport(Point worldPoint) {
        Point2D.Double newPoint = new Point2D.Double(worldPoint.getX(), worldPoint.getY());
        this.transform_.transform(newPoint, newPoint);
        int x = (int)Math.round(((Point2D)newPoint).getX());
        int y = (int)Math.round(((Point2D)newPoint).getY());
        Point pt = new Point(x, y);
        return pt;
    }

    public Point2D viewToWorld(Point viewPoint) {
        Point2D.Double ptSrc = new Point2D.Double(viewPoint.getX(), viewPoint.getY());
        try {
            Point2D.Double ptDest = new Point2D.Double(0.0, 0.0);
            this.transform_.inverseTransform(ptSrc, ptDest);
            return ptDest;
        }
        catch (NoninvertibleTransformException ex) {
            System.err.println("cannot invert: " + this.transform_);
            throw new IllegalStateException();
        }
    }

    public void setZoomFactor(double zoom) {
        this.zoom_ = zoom;
        Workspace ws = this.workspaceSource_.getWorkspace();
        Rectangle rect = ws.getWorkspace();
        this.transform_ = new AffineTransform();
        this.transform_.translate(rect.getWidth() / 2.0 * zoom, rect.getHeight() / 2.0 * zoom);
        this.transform_.scale(zoom, zoom);
        Point2D center = ws.getCenter();
        this.transform_.translate(-center.getX(), -center.getY());
        this.myGenomePre_.setPresentationZoomFactor(zoom);
    }

    public void setWideZoomFactor(double zoom, Dimension viewportDim) {
        Workspace ws = this.workspaceSource_.getWorkspace();
        Rectangle rect = ws.getWorkspace();
        int rectWidth = (int)(rect.getWidth() * zoom);
        int rectHeight = (int)(rect.getHeight() * zoom);
        int useWidth = rectWidth < viewportDim.width ? viewportDim.width : rectWidth;
        int useHeight = rectHeight < viewportDim.height ? viewportDim.height : rectHeight;
        Point2D center = ws.getCenter();
        this.zoom_ = zoom;
        this.transform_ = new AffineTransform();
        this.transform_.translate((double)useWidth / 2.0, (double)useHeight / 2.0);
        this.transform_.scale(zoom, zoom);
        this.transform_.translate(-center.getX(), -center.getY());
        this.myGenomePre_.setPresentationZoomFactor(zoom);
    }

    public void adjustWideZoomForSize(Dimension viewportDim) {
        Workspace ws = this.workspaceSource_.getWorkspace();
        Rectangle rect = ws.getWorkspace();
        int rectWidth = (int)(rect.getWidth() * this.zoom_);
        int rectHeight = (int)(rect.getHeight() * this.zoom_);
        int useWidth = rectWidth < viewportDim.width ? viewportDim.width : rectWidth;
        int useHeight = rectHeight < viewportDim.height ? viewportDim.height : rectHeight;
        Point2D center = ws.getCenter();
        this.transform_ = new AffineTransform();
        this.transform_.translate((double)useWidth / 2.0, (double)useHeight / 2.0);
        this.transform_.scale(this.zoom_, this.zoom_);
        this.transform_.translate(-center.getX(), -center.getY());
    }

    public double getWorkspaceZoom(Dimension viewportDim, double percent) {
        double hZoom;
        Workspace ws = this.workspaceSource_.getWorkspace();
        Rectangle rect = ws.getWorkspace();
        double wZoom = (double)viewportDim.width / rect.getWidth();
        return (wZoom > (hZoom = (double)viewportDim.height / rect.getHeight()) ? hZoom : wZoom) * percent;
    }

    public double getZoomFactor() {
        return this.zoom_;
    }

    public void installTransform(Graphics2D g2, AffineTransform useTrans) {
        if (useTrans == null) {
            useTrans = this.transform_;
        }
        g2.transform(useTrans);
    }

    public void transformPoint(Point pt) {
        try {
            this.transform_.inverseTransform(pt, pt);
        }
        catch (NoninvertibleTransformException nitex) {
            throw new IllegalStateException();
        }
    }

    public void transformClick(int x, int y, Point pt) {
        Point2D.Double clickPoint = new Point2D.Double(x, y);
        try {
            this.transform_.inverseTransform(clickPoint, clickPoint);
        }
        catch (NoninvertibleTransformException nitex) {
            throw new IllegalStateException();
        }
        pt.x = (int)Math.round(((Point2D)clickPoint).getX());
        pt.y = (int)Math.round(((Point2D)clickPoint).getY());
    }

    public double currentPixelDiameter() {
        Point2D.Double clickPoint0 = new Point2D.Double(0.0, 0.0);
        Point2D.Double clickPoint1 = new Point2D.Double(1.0, 0.0);
        try {
            this.transform_.inverseTransform(clickPoint0, clickPoint0);
            this.transform_.inverseTransform(clickPoint1, clickPoint1);
        }
        catch (NoninvertibleTransformException nitex) {
            throw new IllegalStateException();
        }
        return Math.abs(((Point2D)clickPoint1).getX() - ((Point2D)clickPoint0).getX());
    }

    public Rectangle2D getCurrentWorldClipRect() {
        Point2D.Double clipUL = new Point2D.Double(this.clipRect_.getMinX(), this.clipRect_.getMinY());
        Point2D.Double clipLR = new Point2D.Double(this.clipRect_.getMaxX(), this.clipRect_.getMaxY());
        try {
            this.transform_.inverseTransform(clipUL, clipUL);
            this.transform_.inverseTransform(clipLR, clipLR);
        }
        catch (NoninvertibleTransformException nitex) {
            throw new IllegalStateException();
        }
        return new Rectangle2D.Double(((Point2D)clipUL).getX(), ((Point2D)clipUL).getY(), ((Point2D)clipLR).getX() - ((Point2D)clipUL).getX(), ((Point2D)clipLR).getY() - ((Point2D)clipUL).getY());
    }

    public void transformClick(double x, double y, Point pt) {
        Point2D.Double clickPoint = new Point2D.Double(x, y);
        try {
            this.transform_.inverseTransform(clickPoint, clickPoint);
        }
        catch (NoninvertibleTransformException nitex) {
            throw new IllegalStateException();
        }
        pt.x = (int)Math.round(((Point2D)clickPoint).getX());
        pt.y = (int)Math.round(((Point2D)clickPoint).getY());
    }
}

