/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.io.IOException;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.parser.GlueStick;
import org.systemsbiology.biotapestry.ui.BusProperties;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LinkBusDrop;
import org.systemsbiology.biotapestry.ui.PerLinkDrawStyle;
import org.systemsbiology.biotapestry.ui.SuggestedDrawStyle;
import org.xml.sax.Attributes;

public class BusDrop
extends LinkBusDrop {
    public BusDrop(BusDrop other) {
        super(other);
    }

    public BusDrop(Layout layout, Genome genome, String startID, Attributes attrs) throws IOException {
        super(layout, genome, startID, attrs);
    }

    public String toString() {
        return "BusDrop: " + super.toString();
    }

    BusDrop(String targetRef, String ourConnection, int dropType, int connectionEnd) {
        super(targetRef, ourConnection, dropType, connectionEnd);
    }

    public static class MyStyleGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            BusDrop drop = board.busDrop;
            SuggestedDrawStyle suggSty = board.suggSty;
            drop.setDrawStyleForDrop(suggSty);
            return null;
        }
    }

    public static class MyPerLinkGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            BusDrop drop = board.busDrop;
            PerLinkDrawStyle plds = board.perLinkSty;
            drop.setDrawStyleForLink(plds);
            return null;
        }
    }

    public static class BusDropWorker
    extends AbstractFactoryClient {
        public BusDropWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("drop");
            this.installWorker(new PerLinkDrawStyle.PerLinkDrawStyleWorker(whiteboard), new MyPerLinkGlue());
            this.installWorker(new SuggestedDrawStyle.SuggestedDrawStyleWorker(whiteboard), new MyStyleGlue());
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            BusDrop retval = null;
            if (elemName.equals("drop")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.busDrop = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private BusDrop buildFromXML(String elemName, Attributes attrs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
            BusProperties bus = board.busProps;
            String startID = bus.getSourceTag();
            return new BusDrop(board.layout, board.genome, startID, attrs);
        }
    }
}

