/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.parser.GlueStick;
import org.systemsbiology.biotapestry.ui.BusDrop;
import org.systemsbiology.biotapestry.ui.INodeRenderer;
import org.systemsbiology.biotapestry.ui.IRenderer;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LinkBusDrop;
import org.systemsbiology.biotapestry.ui.LinkProperties;
import org.systemsbiology.biotapestry.ui.LinkRouter;
import org.systemsbiology.biotapestry.ui.LinkSegment;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;
import org.systemsbiology.biotapestry.ui.NodeInsertionDirective;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.ui.OverlayStateOracle;
import org.systemsbiology.biotapestry.ui.PerLinkDrawStyle;
import org.systemsbiology.biotapestry.ui.SuggestedDrawStyle;
import org.systemsbiology.biotapestry.ui.freerender.LinkageFree;
import org.systemsbiology.biotapestry.util.AsynchExitRequestException;
import org.systemsbiology.biotapestry.util.BTProgressMonitor;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.LinkPlacementGrid;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.UniqueLabeller;
import org.systemsbiology.biotapestry.util.Vector2D;
import org.xml.sax.Attributes;

public class BusProperties
extends LinkProperties
implements Cloneable {
    private static IRenderer linkRenderer_ = new LinkageFree();

    protected BusProperties() {
        super(linkRenderer_);
    }

    public BusProperties(BusProperties other) {
        super(other);
    }

    public BusProperties(Genome genome, String color, String lineStyle, String txtX, String txtY, String txtDir, Linkage forLink) throws IOException {
        super(linkRenderer_);
        this.loadFromXML(color, forLink.getSource(), lineStyle, txtX, txtY, txtDir);
        BusDrop bd = new BusDrop(null, null, 0, 2);
        this.drops_.add(bd);
        bd = new BusDrop(forLink.getID(), null, 1, 2);
        this.drops_.add(bd);
    }

    public BusProperties(Genome genome, String ourLink, float txtX, float txtY, String color) {
        super(txtX, txtY, color, genome.getLinkage(ourLink).getSource(), linkRenderer_);
        BusDrop bd = new BusDrop(null, null, 0, 2);
        this.drops_.add(bd);
        bd = new BusDrop(ourLink, null, 1, 2);
        this.drops_.add(bd);
    }

    public BusProperties(BusProperties other, String newSource, BusDrop keepDrop) {
        super(other);
        this.srcTag_ = newSource;
        BusDrop bd = new BusDrop(null, null, 0, 2);
        this.drops_.add(bd);
        bd = new BusDrop(keepDrop.getTargetRef(), null, 1, 2);
        this.drops_.add(bd);
    }

    public BusProperties(BusProperties other, BusDrop retain) {
        super(other);
        LinkSegment seg;
        this.clearOutAllSegments();
        this.drops_.clear();
        this.srcTag_ = other.srcTag_;
        Iterator dit = other.drops_.iterator();
        while (dit.hasNext()) {
            BusDrop nextDrop = (BusDrop)dit.next();
            if (nextDrop.getDropType() != 0 && !nextDrop.getTargetRef().equals(retain.getTargetRef())) continue;
            this.drops_.add(new BusDrop(nextDrop));
        }
        List pathToRoot = other.getSegmentsToRoot(retain);
        Iterator sit = pathToRoot.iterator();
        while (sit.hasNext()) {
            LinkSegment segToRoot = (LinkSegment)sit.next();
            this.addSegment(new LinkSegment(segToRoot));
        }
        LinkBusDrop term = this.getTargetDrop();
        if (term.getConnectionSense() == 0 && !(seg = other.getSegment(term.getConnectionTag())).isDegenerate()) {
            term.setConnectionTag(seg.getParent());
            term.setConnectionSense(1);
        }
    }

    public BusProperties(BusProperties other, String linkID, Genome genome, Vector2D offset) {
        this(other, null, linkID, offset);
        Linkage theLink = genome.getLinkage(linkID);
        this.srcTag_ = theLink.getSource();
    }

    public BusProperties(BusProperties other, String srcTag, String linkID, Vector2D offset) {
        this(other);
        if (!other.isSingleDropTree()) {
            throw new IllegalArgumentException();
        }
        this.srcTag_ = srcTag;
        Iterator sit = this.getSegments();
        while (sit.hasNext()) {
            LinkSegment seg = (LinkSegment)sit.next();
            seg.shiftBoth(offset.getX(), offset.getY());
        }
        LinkBusDrop drop = this.getTargetDrop();
        drop.setTargetRef(linkID);
    }

    public LinkProperties deriveDirectLink(String newSource, LinkBusDrop keepDrop, Object extraInfo) {
        if (extraInfo != null) {
            throw new IllegalArgumentException();
        }
        BusProperties retval = (BusProperties)this.clone();
        retval.srcTag_ = newSource;
        retval.clearOutAllSegments();
        retval.drops_.clear();
        BusDrop bd = new BusDrop(null, null, 0, 2);
        retval.drops_.add(bd);
        bd = new BusDrop(keepDrop.getTargetRef(), null, 1, 2);
        retval.drops_.add(bd);
        return retval;
    }

    public Object clone() {
        BusProperties retval = (BusProperties)super.clone();
        return retval;
    }

    public String toString() {
        String retval = super.toString();
        return "BusProperties " + retval;
    }

    public BusProperties insertNodeInTree(LinkSegmentID segID, Set resolved, String newNodeID, String firstLinkID, Map linkMap, Genome genome, Layout lo, FontRenderContext frc, Map needDirectFixup, NodeInsertionDirective nid) {
        BusProperties newProps = null;
        if (segID.isDirect()) {
            needDirectFixup.put(firstLinkID, nid);
            newProps = this.insertNodeOnDirect(newNodeID, firstLinkID, linkMap, genome, lo, frc);
        } else if (segID.isForDrop()) {
            BusDrop drop = (BusDrop)this.getDrop(segID);
            newProps = this.insertNodeOnDrop(drop, newNodeID, firstLinkID, linkMap, needDirectFixup, nid);
        } else {
            LinkSegment seg = this.getSegment(segID.getLinkSegTag());
            newProps = (BusProperties)this.newTreeBelowSegment(seg, newNodeID, firstLinkID, linkMap, null);
        }
        return newProps;
    }

    public LinkSegment getDirectLinkPath(Genome genome, Layout lo, FontRenderContext frc) {
        LinkBusDrop targDrop = this.getTargetDrop();
        Linkage link = genome.getLinkage(targDrop.getTargetRef());
        int launch = link.getLaunchPad();
        NodeProperties npSrc = lo.getNodeProperties(link.getSource());
        INodeRenderer sRender = npSrc.getRenderer();
        Point2D srcLoc = npSrc.getLocation();
        Node src = genome.getNode(link.getSource());
        Vector2D lauPO = sRender.getLaunchPadOffset(launch, src, lo, frc);
        Point2D sLoc = lauPO.add(srcLoc);
        int land = link.getLandingPad();
        int sign = link.getSign();
        NodeProperties npTrg = lo.getNodeProperties(link.getTarget());
        INodeRenderer tRender = npTrg.getRenderer();
        Point2D trgLoc = npTrg.getLocation();
        Node trg = genome.getNode(link.getTarget());
        Vector2D lanPO = tRender.getLandingPadOffset(land, trg, sign, lo, frc);
        Point2D eLoc = lanPO.add(trgLoc);
        LinkSegment retval = new LinkSegment(sLoc, eLoc);
        return retval;
    }

    private BusProperties insertNodeOnDrop(BusDrop drop, String newSourceID, String newLinkToNodeID, Map linkMap, Map needDirectFixup, NodeInsertionDirective nid) {
        int dropType = drop.getDropType();
        if (dropType == 0) {
            needDirectFixup.put(newLinkToNodeID, nid);
            return this.insertNodeOnStartDrop(newSourceID, newLinkToNodeID, linkMap);
        }
        return this.insertNodeOnEndDrop(drop, newSourceID, newLinkToNodeID, linkMap);
    }

    private BusProperties insertNodeOnDirect(String newSourceID, String newLinkToNodeID, Map linkMap, Genome genome, Layout lo, FontRenderContext frc) {
        this.splitNoSegmentBus(genome, lo, frc);
        LinkSegment rootSeg = this.getRootSegment();
        BusDrop newDrop = new BusDrop(newLinkToNodeID, rootSeg.getID(), 1, 0);
        this.addDrop(newDrop);
        BusProperties retval = this.getBareBus();
        retval.srcTag_ = newSourceID;
        BusDrop bd = new BusDrop(null, null, 0, 2);
        retval.addDrop(bd);
        if (linkMap.size() != 1) {
            throw new IllegalArgumentException();
        }
        String newID = (String)linkMap.values().iterator().next();
        bd = new BusDrop(newID, null, 1, 2);
        retval.addDrop(bd);
        return retval;
    }

    private BusProperties insertNodeOnStartDrop(String newSourceID, String newLinkToNodeID, Map linkMap) {
        BusProperties retval = new BusProperties(this);
        retval.srcTag_ = newSourceID;
        SuggestedDrawStyle sds = null;
        Iterator dit = retval.getDrops();
        while (dit.hasNext()) {
            BusDrop drop = (BusDrop)dit.next();
            if (drop.getDropType() != 0) continue;
            sds = drop.getSpecialDropDrawStyle();
            break;
        }
        int dropStyle = -1;
        Iterator drit = retval.getDrops();
        while (drit.hasNext()) {
            BusDrop drop = (BusDrop)drit.next();
            String targRef = drop.getTargetRef();
            if (targRef == null) continue;
            String mappedRef = (String)linkMap.get(targRef);
            drop.setTargetRef(mappedRef);
        }
        LinkSegment rootSeg = this.getRootSegment();
        BusDrop newDrop = new BusDrop(newLinkToNodeID, rootSeg.getID(), 1, 0);
        newDrop.setDrawStyleForDrop(sds == null ? null : (SuggestedDrawStyle)sds.clone());
        this.addDrop(newDrop);
        return retval;
    }

    private BusProperties getBareBus() {
        BusProperties retval = new BusProperties(this);
        retval.segments_.clear();
        retval.drops_.clear();
        retval.labels_ = new UniqueLabeller();
        return retval;
    }

    private BusProperties insertNodeOnEndDrop(BusDrop drop, String newSourceID, String newLinkToNodeID, Map linkMap) {
        BusDrop newDrop = new BusDrop(drop);
        newDrop.setTargetRef(newLinkToNodeID);
        this.addDrop(newDrop);
        BusProperties retval = this.getBareBus();
        retval.srcTag_ = newSourceID;
        BusDrop bd = new BusDrop(null, null, 0, 2);
        bd.setDrawStyleForDrop(drop.getSpecialDropDrawStyle());
        retval.addDrop(bd);
        if (linkMap.size() != 1) {
            throw new IllegalArgumentException();
        }
        String newID = (String)linkMap.values().iterator().next();
        bd = new BusDrop(newID, null, 1, 2);
        bd.transferSpecialStyles(drop);
        retval.addDrop(bd);
        return retval;
    }

    public int getLaunchPad(Genome genome, Layout layout) {
        int retval = Integer.MIN_VALUE;
        Iterator drops = this.drops_.iterator();
        while (drops.hasNext()) {
            Linkage theLink;
            BusDrop drop = (BusDrop)drops.next();
            String ref = drop.getTargetRef();
            if (ref == null || (theLink = genome.getLinkage(ref)) == null) continue;
            int ourPad = theLink.getLaunchPad();
            if (retval == Integer.MIN_VALUE) {
                retval = ourPad;
                continue;
            }
            if (ourPad == retval) continue;
            System.err.println("Launch pad mismatch " + theLink.getID() + " : " + ourPad + " vs " + retval);
            throw new IllegalStateException();
        }
        if (retval == Integer.MIN_VALUE) {
            System.err.println("Launch pad: no pad");
            throw new IllegalStateException();
        }
        return retval;
    }

    public boolean linkIsInModel(Genome genome, OverlayStateOracle oso, String linkID) {
        if (linkID == null) {
            throw new IllegalArgumentException();
        }
        Linkage link = genome.getLinkage(linkID);
        return link != null;
    }

    protected LinkPlacementGrid initGridForOrthoFix(LinkRouter router, Genome genome, Layout lo, FontRenderContext frc, OverlayStateOracle oso, String overID, BTProgressMonitor monitor) throws AsynchExitRequestException {
        List doNotRender = this.getLinkageList();
        return router.initGrid(genome, lo, frc, new HashSet(doNotRender), 4, monitor);
    }

    protected void sourceSanityCheck(Genome genome, LinkProperties other) {
        LinkBusDrop targDrop = other.getTargetDrop();
        Linkage link = genome.getLinkage(targDrop.getTargetRef());
        String slpSrc = link.getSource();
        if (!slpSrc.equals(this.getSourceTag())) {
            System.err.println(slpSrc);
            System.err.println(other.getSourceTag());
            System.err.println(this.getSourceTag());
            throw new IllegalArgumentException();
        }
    }

    protected String getLinkLabel(Genome genome, String linkID) {
        Linkage link = genome.getLinkage(linkID);
        return link.getName();
    }

    public String getLinkTarget(Genome genome, String linkID) {
        Linkage link = genome.getLinkage(linkID);
        return link.getTarget();
    }

    protected boolean srcDropIsNonOrtho(Genome genome, Layout lo, FontRenderContext frc) {
        Linkage link = genome.getLinkage(this.getALinkID(genome));
        String src = link.getSource();
        Node srcNode = genome.getNode(src);
        NodeProperties npSrc = lo.getNodeProperties(src);
        INodeRenderer sRender = npSrc.getRenderer();
        Point2D srcLoc = npSrc.getLocation();
        int launch = link.getLaunchPad();
        Vector2D lauPO = sRender.getLaunchPadOffset(launch, srcNode, lo, frc);
        Point2D sPadLoc = lauPO.add(srcLoc);
        LinkBusDrop drop = this.getRootDrop();
        LinkSegment rootSeg = this.getSegment(drop.getConnectionTag());
        Point2D segPt = drop.getConnectionSense() == 0 ? rootSeg.getStart() : rootSeg.getEnd();
        return segPt.getX() != sPadLoc.getX() && segPt.getY() != sPadLoc.getY();
    }

    public String getALinkID(Genome genome) {
        Iterator dit = this.getDrops();
        while (dit.hasNext()) {
            String retval;
            LinkBusDrop bd = (LinkBusDrop)dit.next();
            if (bd.getDropType() == 0 || genome.getLinkage(retval = bd.getTargetRef()) == null) continue;
            return retval;
        }
        throw new IllegalStateException();
    }

    public String getAStableLinkID(Genome genome) {
        TreeSet<String> retval = new TreeSet<String>();
        Iterator dit = this.getDrops();
        while (dit.hasNext()) {
            String tref;
            LinkBusDrop bd = (LinkBusDrop)dit.next();
            if (bd.getDropType() == 0 || genome.getLinkage(tref = bd.getTargetRef()) == null) continue;
            retval.add(tref);
        }
        return (String)retval.first();
    }

    protected boolean targetDropIsNonOrtho(LinkBusDrop drop, Genome genome, Layout lo, FontRenderContext frc) {
        String trg = drop.getTargetRef();
        if (trg == null) {
            throw new IllegalStateException();
        }
        Linkage link = genome.getLinkage(trg);
        int sign = link.getSign();
        int land = link.getLandingPad();
        String trgID = link.getTarget();
        Node trgNode = genome.getNode(trgID);
        NodeProperties npTrg = lo.getNodeProperties(trgID);
        INodeRenderer tRender = npTrg.getRenderer();
        Point2D trgLoc = npTrg.getLocation();
        Vector2D lanPO = tRender.getLandingPadOffset(land, trgNode, sign, lo, frc);
        Point2D tPadLoc = lanPO.add(trgLoc);
        LinkSegment trgSeg = this.getSegment(drop.getConnectionTag());
        Point2D segPt = drop.getConnectionSense() == 0 ? trgSeg.getStart() : trgSeg.getEnd();
        return segPt.getX() != tPadLoc.getX() && segPt.getY() != tPadLoc.getY();
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<linkBus ");
        this.writeXMLSupport(out, ind);
        ind.down().indent();
        out.println("</linkBus>");
    }

    public String getLabel(Genome genome) {
        StringBuffer label = new StringBuffer();
        Iterator dit = this.getDrops();
        while (dit.hasNext()) {
            String newLabel;
            Linkage link;
            LinkBusDrop drop = (LinkBusDrop)dit.next();
            String busID = drop.getTargetRef();
            if (drop.getDropType() == 0 || (link = genome.getLinkage(busID)) == null || (newLabel = link.getName()) == null || newLabel.trim().equals("")) continue;
            if (label.length() > 0) {
                label.append('-');
            }
            label.append(newLabel);
        }
        return label.toString();
    }

    protected LinkSegment getSourceDropSegment(Genome genome, Layout lo, FontRenderContext frc, boolean forceToGrid) {
        Linkage link = genome.getLinkage(this.getALinkID(genome));
        String src = link.getSource();
        Node srcNode = genome.getNode(src);
        NodeProperties npSrc = lo.getNodeProperties(src);
        INodeRenderer sRender = npSrc.getRenderer();
        Point2D srcLoc = npSrc.getLocation();
        int launch = link.getLaunchPad();
        Vector2D lauPO = sRender.getLaunchPadOffset(launch, srcNode, lo, frc);
        Point2D sPadLoc = lauPO.add(srcLoc);
        if (forceToGrid) {
            UiUtil.forceToGrid(sPadLoc.getX(), sPadLoc.getY(), sPadLoc, 10.0);
        }
        LinkBusDrop drop = this.getRootDrop();
        LinkSegment rootSeg = this.getSegment(drop.getConnectionTag());
        Point2D segPt = drop.getConnectionSense() == 0 ? rootSeg.getStart() : rootSeg.getEnd();
        return new LinkSegment(sPadLoc, segPt);
    }

    protected LinkSegment getTargetDropSegment(LinkBusDrop drop, Genome genome, Layout lo, FontRenderContext frc) {
        String trg = drop.getTargetRef();
        if (trg == null) {
            throw new IllegalStateException();
        }
        Linkage link = genome.getLinkage(trg);
        int sign = link.getSign();
        int land = link.getLandingPad();
        String trgID = link.getTarget();
        Node trgNode = genome.getNode(trgID);
        NodeProperties npTrg = lo.getNodeProperties(trgID);
        INodeRenderer tRender = npTrg.getRenderer();
        Point2D trgLoc = npTrg.getLocation();
        Vector2D lanPO = tRender.getLandingPadOffset(land, trgNode, sign, lo, frc);
        Point2D tPadLoc = lanPO.add(trgLoc);
        LinkSegment trgSeg = this.getSegment(drop.getConnectionTag());
        Point2D segPt = drop.getConnectionSense() == 0 ? trgSeg.getStart() : trgSeg.getEnd();
        return new LinkSegment(segPt, tPadLoc);
    }

    protected LinkBusDrop generateBusDrop(LinkBusDrop spDrop, String ourConnection, int dropType, int connectionEnd) {
        return new BusDrop(spDrop.getTargetRef(), ourConnection, dropType, connectionEnd);
    }

    protected LinkBusDrop generateBusDrop(String targetRef, String ourConnection, int dropType, int connectionEnd, Object extraInfo) {
        return new BusDrop(targetRef, ourConnection, dropType, connectionEnd);
    }

    protected LinkProperties.ThickInfo maxThickForIntersect(Genome genome, OverlayStateOracle oso, double intersectTol) {
        return this.maxThickForIntersectSupport(genome, oso, false, intersectTol);
    }

    protected void moveSource(Object extraInfo) {
    }

    protected void shiftDropEnds(double dx, double dy, Vector2D sideDir) {
    }

    protected void moveDropEndsPerMap(Map mappedPositions, boolean forceToGrid) {
    }

    protected void shiftSelectedDropEnds(double dx, double dy, LinkProperties.LinkFragmentShifts fragShifts) {
    }

    protected void shiftDropEndsForExpandCompressOps(SortedSet newRows, SortedSet newCols, Rectangle bounds, double sign, int mult) {
    }

    public boolean canRelocateSegmentOnTree(LinkSegmentID moveID) {
        if (moveID.isDirect()) {
            return false;
        }
        if (moveID.isForStartDrop()) {
            return false;
        }
        if (moveID.isForEndDrop()) {
            return this.segments_.size() > 1;
        }
        String myID = moveID.getLinkSegTag();
        String rootSegID = this.getRootSegment().getID();
        boolean iAmRootChild = false;
        int rootChildCount = 0;
        Iterator sit = this.segments_.values().iterator();
        while (sit.hasNext()) {
            LinkSegment curr = (LinkSegment)sit.next();
            String cPar = curr.getParent();
            if (cPar == null || !cPar.equals(rootSegID)) continue;
            ++rootChildCount;
            if (!curr.getID().equals(myID)) continue;
            iAmRootChild = true;
        }
        return !iAmRootChild || rootChildCount != 1;
    }

    public String segNumsToString() {
        return this.segments_.keySet().toString();
    }

    protected Vector2D getSourceForcedDir(Genome genome, Layout lo) {
        String srcID = this.getSourceTag();
        Node src = genome.getNode(srcID);
        NodeProperties np = lo.getNodeProperties(srcID);
        INodeRenderer render = np.getRenderer();
        return render.getDepartureDirection(this.getLaunchPad(genome, lo), src, lo);
    }

    protected Vector2D getTargetForcedDir(Genome genome, Layout lo, LinkSegmentID segID, boolean isDirect) {
        String linkID = isDirect ? segID.getDirectLinkRef() : segID.getEndDropLinkRef();
        Linkage link = genome.getLinkage(linkID);
        String trgID = link.getTarget();
        Node trg = genome.getNode(trgID);
        NodeProperties np = lo.getNodeProperties(trgID);
        INodeRenderer render = np.getRenderer();
        return render.getArrivalDirection(link.getLandingPad(), trg, lo);
    }

    public static class RememberProps {
        private SuggestedDrawStyle myStyle;
        private Point2D textPos;
        private int textDir;
        private Set linkagesForTextPos;
        private int textPosSegmentCardinality;
        private double textPosWeight;
        private double textPosOffset;
        private HashMap linkSpecialStyles;

        public RememberProps(RememberProps other) {
            this.myStyle = (SuggestedDrawStyle)other.myStyle.clone();
            this.textPos = other.textPos == null ? null : (Point2D)other.textPos.clone();
            this.linkagesForTextPos = other.linkagesForTextPos == null ? null : new HashSet(other.linkagesForTextPos);
            this.textPosSegmentCardinality = other.textPosSegmentCardinality;
            this.textPosWeight = other.textPosWeight;
            this.textPosOffset = other.textPosOffset;
            this.textDir = other.textDir;
            this.linkSpecialStyles = new HashMap();
            Iterator ssit = other.linkSpecialStyles.keySet().iterator();
            while (ssit.hasNext()) {
                String linkID = (String)ssit.next();
                PerLinkDrawStyle plds = (PerLinkDrawStyle)other.linkSpecialStyles.get(linkID);
                this.linkSpecialStyles.put(linkID, plds.clone());
            }
        }

        public RememberProps(BusProperties lp, Genome genome, Layout lo, FontRenderContext frc) {
            this.myStyle = (SuggestedDrawStyle)lp.getDrawStyle().clone();
            this.textPos = lp.getTextPosition() == null ? null : (Point2D)lp.getTextPosition().clone();
            LinkSegmentID lsid = lp.getSegmentIDForLabel(genome, null, lo, frc);
            if (lsid != null) {
                LinkSegment seg;
                this.linkagesForTextPos = lp.resolveLinkagesThroughSegment(lsid, genome);
                if (lsid.isForSegment()) {
                    seg = lp.getSegment(lsid);
                    this.textPosSegmentCardinality = lp.getSegmentsToRoot(seg).size();
                } else if (lsid.isForEndDrop()) {
                    LinkBusDrop bd = lp.getTargetDrop(lsid);
                    seg = lp.getTargetDropSegment(bd, genome, lo, frc);
                    this.textPosSegmentCardinality = lp.getSegmentsToRoot(bd).size() + 1;
                } else if (lsid.isDirect()) {
                    seg = lp.getDirectLinkPath(genome, lo, frc);
                    this.textPosSegmentCardinality = 1;
                } else {
                    seg = lp.getSegmentGeometryForID(lsid, genome, lo, frc, false);
                    this.textPosSegmentCardinality = 1;
                }
                this.textPosWeight = seg.fractionOfRun(this.textPos);
                Point2D textProjection = seg.pointAtFraction(this.textPosWeight);
                Vector2D normOffset = new Vector2D(textProjection, this.textPos);
                Vector2D norm = seg.getNormal();
                this.textPosOffset = norm == null ? normOffset.length() : norm.dot(normOffset);
            }
            this.textDir = lp.getTextDirection();
            this.linkSpecialStyles = new HashMap();
            Iterator bdit = lp.getDrops();
            while (bdit.hasNext()) {
                LinkBusDrop drop = (LinkBusDrop)bdit.next();
                if (drop.getDropType() == 0) continue;
                String linkID = drop.getTargetRef();
                PerLinkDrawStyle plds = drop.getDrawStyleForLink();
                if (plds == null) continue;
                this.linkSpecialStyles.put(linkID, plds.clone());
            }
        }

        public RememberProps buildInheritedProps(GenomeInstance gi) {
            RememberProps retval = new RememberProps(this);
            retval.linkSpecialStyles.clear();
            Iterator lit = gi.getLinkageIterator();
            while (lit.hasNext()) {
                Linkage link = (Linkage)lit.next();
                String linkID = link.getID();
                String baseID = GenomeItemInstance.getBaseID(linkID);
                PerLinkDrawStyle plds = (PerLinkDrawStyle)this.linkSpecialStyles.get(baseID);
                if (plds == null) continue;
                retval.linkSpecialStyles.put(linkID, plds.clone());
            }
            return retval;
        }

        public void remapLinks(Map linkIDMap) {
            HashMap<String, PerLinkDrawStyle> mappedlinkSpecialStyles = new HashMap<String, PerLinkDrawStyle>();
            Iterator kit = this.linkSpecialStyles.keySet().iterator();
            while (kit.hasNext()) {
                String linkID = (String)kit.next();
                String mappedID = (String)linkIDMap.get(linkID);
                PerLinkDrawStyle plds = (PerLinkDrawStyle)this.linkSpecialStyles.get(linkID);
                if (plds == null) continue;
                mappedlinkSpecialStyles.put(mappedID == null ? linkID : mappedID, plds);
            }
            this.linkSpecialStyles = mappedlinkSpecialStyles;
            if (this.linkagesForTextPos != null) {
                HashSet<String> mappedlinkagesForTextPos = new HashSet<String>();
                Iterator lit = this.linkagesForTextPos.iterator();
                while (lit.hasNext()) {
                    String linkID = (String)lit.next();
                    String mappedID = (String)linkIDMap.get(linkID);
                    mappedlinkagesForTextPos.add(mappedID == null ? linkID : mappedID);
                }
                this.linkagesForTextPos = mappedlinkagesForTextPos;
            }
        }

        public void restore(BusProperties lp, Layout lo, Genome genome, FontRenderContext frc) {
            lp.setDrawStyle(this.myStyle);
            lp.setTextDirection(this.textDir);
            Iterator kit = this.linkSpecialStyles.keySet().iterator();
            while (kit.hasNext()) {
                String linkID = (String)kit.next();
                PerLinkDrawStyle plds = (PerLinkDrawStyle)this.linkSpecialStyles.get(linkID);
                if (plds == null || !lp.haveTargetDrop(linkID)) continue;
                LinkBusDrop drop = lp.getTargetDrop(linkID);
                drop.setDrawStyleForLink(plds);
            }
            lp.setTextPosition(this.textPos);
        }

        public void restoreLabelPosition(BusProperties lp, Layout lo, Genome genome, FontRenderContext frc, Rectangle2D rect) {
            if (this.linkagesForTextPos != null) {
                LinkSegmentID segID = lp.findBestSegmentForLabel(this.linkagesForTextPos, this.textPosSegmentCardinality, genome, null);
                LinkSegment seg = lp.getSegmentGeometryForID(segID, genome, lo, frc, false);
                Point2D textProjection = seg.pointAtFraction(this.textPosWeight);
                Vector2D segNorm = seg.getNormal();
                segNorm = segNorm == null ? new Vector2D(0.0, 0.0) : segNorm.scaled(this.textPosOffset);
                textProjection = segNorm.add(textProjection);
                this.alwaysRealityBased(textProjection, rect);
                lp.setTextPosition(textProjection);
            } else if (rect != null && this.textPos != null) {
                Point2D.Double newPt = new Point2D.Double(this.textPos.getX(), this.textPos.getY());
                this.alwaysRealityBased(newPt, rect);
                lp.setTextPosition(newPt);
            } else {
                lp.setTextPosition(this.textPos);
            }
        }

        private void alwaysRealityBased(Point2D textProjection, Rectangle2D rect) {
            if (rect != null && !rect.contains(textProjection)) {
                double pullBackX = textProjection.getX();
                double pullBackY = textProjection.getY();
                if (pullBackX < rect.getMinX()) {
                    pullBackX = rect.getMinX();
                }
                if (pullBackY < rect.getMinY()) {
                    pullBackY = rect.getMinY();
                }
                if (pullBackX > rect.getMaxX()) {
                    pullBackX = rect.getMaxX();
                }
                if (pullBackY > rect.getMaxY()) {
                    pullBackY = rect.getMaxY();
                }
                textProjection.setLocation(pullBackX, pullBackY);
            }
            UiUtil.forceToGrid(textProjection, 10.0);
        }
    }

    public static class MyStyleGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            BusProperties busProps = board.busProps;
            SuggestedDrawStyle suggSty = board.suggSty;
            busProps.setDrawStyle(suggSty);
            return null;
        }
    }

    public static class MyBusDropGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            Layout layout = board.layout;
            BusProperties busProps = board.busProps;
            BusDrop newDrop = board.busDrop;
            busProps.addDrop(newDrop);
            if (newDrop.getDropType() == 1) {
                String targetTag = newDrop.getTargetRef();
                layout.setLinkProperties(targetTag, busProps);
            }
            return null;
        }
    }

    public static class MySegmentGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            BusProperties busProps = board.busProps;
            LinkSegment seg = board.linkSegment;
            busProps.addSegment(seg);
            return null;
        }
    }

    public static class BusPropertiesWorker
    extends AbstractFactoryClient {
        public BusPropertiesWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("linkBus");
            this.installWorker(new LinkSegment.LinkSegmentWorker(whiteboard), new MySegmentGlue());
            this.installWorker(new BusDrop.BusDropWorker(whiteboard), new MyBusDropGlue());
            this.installWorker(new SuggestedDrawStyle.SuggestedDrawStyleWorker(whiteboard), new MyStyleGlue());
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            BusProperties retval = null;
            if (elemName.equals("linkBus")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.busProps = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private BusProperties buildFromXML(String elemName, Attributes attrs) throws IOException {
            BusProperties newProp = new BusProperties();
            FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
            LinkProperties.buildFromXMLSupport(elemName, attrs, newProp, board, "linkBus");
            return newProp;
        }
    }
}

