/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import org.systemsbiology.biotapestry.db.GenomeSource;
import org.systemsbiology.biotapestry.db.LocalLayoutSource;
import org.systemsbiology.biotapestry.ui.ChartStackLayoutManager;
import org.systemsbiology.biotapestry.ui.ChartStackTitleBar;
import org.systemsbiology.biotapestry.ui.ChartStackableModelView;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.MultiStripChart;
import org.systemsbiology.biotapestry.ui.MultiStripChartWrapper;
import org.systemsbiology.biotapestry.ui.MultiStripGenericChart;
import org.systemsbiology.biotapestry.ui.MultiStripTimeAxisChart;
import org.systemsbiology.biotapestry.util.ExceptionHandler;

public class ChartStack
extends JPanel {
    private ArrayList charts_;
    private JPanel childPanel_;
    private ChartStackLayoutManager lom_;
    private JPanel spacer_;
    private JTextField feedback_;

    public ChartStack(JTextField feedback) {
        this.feedback_ = feedback;
        this.charts_ = new ArrayList();
        this.childPanel_ = new JPanel();
        this.childPanel_.setBorder(BorderFactory.createLineBorder(Color.black, 2));
        this.lom_ = new ChartStackLayoutManager();
        this.childPanel_.setLayout(this.lom_);
        JScrollPane jsp = new JScrollPane(this.childPanel_);
        jsp.setHorizontalScrollBarPolicy(30);
        jsp.setVerticalScrollBarPolicy(22);
        this.setLayout(new GridLayout(1, 1));
        this.add(jsp);
    }

    public void disableStack() {
        int currCount = this.charts_.size();
        for (int i = 0; i < currCount; ++i) {
            StackElement element = (StackElement)this.charts_.get(i);
            element.disableElement();
        }
    }

    public void enableStack() {
        int currCount = this.charts_.size();
        for (int i = 0; i < currCount; ++i) {
            StackElement element = (StackElement)this.charts_.get(i);
            element.enableElement();
        }
    }

    public void cleanCharts() {
        int currCount = this.charts_.size();
        for (int i = 0; i < currCount; ++i) {
            StackElement element = (StackElement)this.charts_.get(i);
            ToolTipManager.sharedInstance().unregisterComponent(element.getTooltipComponent());
            MultiStripChart msc = element.msc.getChart();
            if (element.handler == null) continue;
            msc.removeMouseListener(element.handler);
        }
    }

    public Map getCurrentViz() {
        HashMap<String, Boolean> retval = new HashMap<String, Boolean>();
        int currCount = this.charts_.size();
        for (int i = 0; i < currCount; ++i) {
            StackElement element = (StackElement)this.charts_.get(i);
            retval.put(element.titleBar.getKey(), new Boolean(element.titleBar.isOpen()));
        }
        return retval;
    }

    public void setCharts(Collected dataCharts, MultiStripTimeAxisChart.TimeBounds focusTimes, MultiStripTimeAxisChart.TimeBounds dataTimes, int coverage, Map currentViz) {
        int nsinc = dataCharts.neighborSrc == null ? 0 : 1;
        int numDC = dataCharts.stripCharts.size();
        this.setChartCount(numDC, nsinc);
        for (int i = 0; i < numDC; ++i) {
            StackElement element = (StackElement)this.charts_.get(i);
            DataSet data = (DataSet)dataCharts.stripCharts.get(i);
            element.titleBar.setTitle(data.title);
            element.titleBar.setKey(data.uniqueKey);
            MultiStripChart msc = element.msc.getChart();
            boolean needTime = data.hasTimeAxis;
            if (needTime) {
                if (msc == null || !(msc instanceof MultiStripTimeAxisChart)) {
                    if (msc != null) {
                        ToolTipManager.sharedInstance().unregisterComponent(msc);
                        if (element.handler != null) {
                            msc.removeMouseListener(element.handler);
                        }
                    }
                    msc = new MultiStripTimeAxisChart();
                    element.msc.setChart(msc);
                    ToolTipManager.sharedInstance().registerComponent(msc);
                    if (element.handler != null) {
                        msc.addMouseListener(element.handler);
                    }
                }
            } else if (msc == null || !(msc instanceof MultiStripGenericChart)) {
                if (msc != null) {
                    ToolTipManager.sharedInstance().unregisterComponent(msc);
                    if (element.handler != null) {
                        msc.removeMouseListener(element.handler);
                    }
                }
                msc = new MultiStripGenericChart();
                element.msc.setChart(msc);
                ToolTipManager.sharedInstance().registerComponent(msc);
                if (element.handler != null) {
                    msc.addMouseListener(element.handler);
                }
            }
            msc.setStrips(data.strips, data.prunedStrips);
            if (msc instanceof MultiStripTimeAxisChart) {
                MultiStripTimeAxisChart tac = (MultiStripTimeAxisChart)msc;
                tac.setDataTimeRange(dataTimes);
                tac.setFocusTimeRange(focusTimes);
            }
            msc.setCoverage(coverage);
        }
        if (nsinc == 1) {
            StackElement element = (StackElement)this.charts_.get(this.charts_.size() - 1);
            element.titleBar.setTitle(dataCharts.batchDataTitle);
            element.titleBar.setKey(dataCharts.batchDataKey);
            element.csmv.setSources(dataCharts.neighborSrc, new LocalLayoutSource(dataCharts.neighborLo), dataCharts.batchData);
        }
        if (currentViz != null) {
            int currCount = this.charts_.size();
            for (int i = 0; i < currCount; ++i) {
                StackElement element = (StackElement)this.charts_.get(i);
                String barKey = element.titleBar.getKey();
                Boolean prevViz = (Boolean)currentViz.get(barKey);
                if (prevViz == null) continue;
                element.titleBar.setOpen(prevViz);
            }
        }
        this.invalidate();
        this.validate();
        this.repaint();
    }

    private void setChartCount(int count, int modelCount) {
        if (this.spacer_ != null) {
            this.childPanel_.remove(this.spacer_);
        }
        int currCount = this.charts_.size();
        int mscCount = 0;
        int csmvCount = 0;
        for (int i = 0; i < currCount; ++i) {
            StackElement element = (StackElement)this.charts_.get(i);
            if (element.msc != null) {
                ++mscCount;
                continue;
            }
            ++csmvCount;
        }
        if (mscCount < count) {
            this.addMsc(count - mscCount);
        } else if (mscCount > count) {
            this.dropMsc(mscCount - count);
        }
        if (csmvCount < modelCount) {
            this.addCsmv(modelCount - csmvCount);
        } else if (csmvCount > modelCount) {
            this.dropCsmv(csmvCount - modelCount);
        }
        int num = this.childPanel_.getComponentCount();
        if (this.spacer_ == null) {
            this.spacer_ = new JPanel();
            this.spacer_.setMinimumSize(new Dimension(2, 2));
            this.spacer_.setBorder(new ChartStackTitleBar.ChartBorder(2));
        }
        this.childPanel_.add((Component)this.spacer_, new ChartStackLayoutManager.StackRole(true, num));
        Component[] foo = this.childPanel_.getComponents();
        for (int i = 0; i < foo.length; ++i) {
            Component comp = foo[i];
            ChartStackLayoutManager.StackRole role = this.lom_.getConstraint(comp);
            role.position = i / 2;
        }
    }

    private void addMsc(int addCount) {
        for (int i = 0; i < addCount; ++i) {
            MultiStripChartWrapper msc = new MultiStripChartWrapper();
            ChartStackTitleBar bar = new ChartStackTitleBar("", this, msc, null);
            StackElement element = new StackElement(bar, msc, new MouseHandler());
            this.charts_.add(0, element);
            ChartStackLayoutManager.StackRole role = new ChartStackLayoutManager.StackRole(false, 0, null);
            this.childPanel_.add(msc, role, 0);
            role = new ChartStackLayoutManager.StackRole(true, 0, msc);
            this.childPanel_.add(element.titleBar, role, 0);
        }
    }

    private void addCsmv(int addCount) {
        for (int i = 0; i < addCount; ++i) {
            ChartStackableModelView csmv = new ChartStackableModelView();
            ChartStackTitleBar bar = new ChartStackTitleBar("", this, csmv, null);
            StackElement element = new StackElement(bar, csmv);
            ToolTipManager.sharedInstance().registerComponent(csmv.getToolTipTarget());
            this.charts_.add(element);
            ChartStackLayoutManager.StackRole role = new ChartStackLayoutManager.StackRole(true, 0, csmv);
            this.childPanel_.add((Component)element.titleBar, role);
            role = new ChartStackLayoutManager.StackRole(false, 0, null);
            this.childPanel_.add((Component)csmv, role);
        }
    }

    private void dropMsc(int dropCount) {
        for (int i = 0; i < dropCount; ++i) {
            StackElement element = (StackElement)this.charts_.remove(0);
            this.childPanel_.remove(element.titleBar);
            if (element.msc == null) {
                throw new IllegalStateException();
            }
            this.childPanel_.remove(element.msc);
            ToolTipManager.sharedInstance().unregisterComponent(element.msc.getChart());
            MultiStripChart chart = element.msc.getChart();
            if (element.handler == null) continue;
            chart.removeMouseListener(element.handler);
        }
    }

    private void dropCsmv(int dropCount) {
        for (int i = 0; i < dropCount; ++i) {
            StackElement element = (StackElement)this.charts_.remove(this.charts_.size() - 1);
            this.childPanel_.remove(element.titleBar);
            if (element.csmv == null) {
                throw new IllegalStateException();
            }
            this.childPanel_.remove(element.csmv);
            ToolTipManager.sharedInstance().unregisterComponent(element.csmv);
        }
    }

    public static void main(String[] argv) {
        ArrayList<DataSet> charts = new ArrayList<DataSet>();
        ArrayList<MultiStripChart.Strip> strips = new ArrayList<MultiStripChart.Strip>();
        ArrayList<MultiStripChart.StripElement> elements = new ArrayList<MultiStripChart.StripElement>();
        elements.add(new MultiStripChart.StripElement(12.0, 16.0, Color.red, 0, null, 1));
        elements.add(new MultiStripChart.StripElement(17.0, 21.0, Color.red, 0, null, 0));
        elements.add(new MultiStripChart.StripElement(23.0, 28.0, Color.gray, 0, null, 0));
        strips.add(new MultiStripChart.Strip("Krox MASO -> eve", elements));
        elements = new ArrayList();
        elements.add(new MultiStripChart.StripElement(12.0, 16.0, Color.gray, 0, null, 1));
        elements.add(new MultiStripChart.StripElement(17.0, 21.0, Color.blue, 0, null, 1));
        elements.add(new MultiStripChart.StripElement(23.0, 28.0, Color.blue, 0, null, 0));
        strips.add(new MultiStripChart.Strip("Krox-En -> eve", elements));
        DataSet se = new DataSet("Hello world", strips, strips, "A", true);
        charts.add(se);
        DataSet se2 = new DataSet("Hello world2", strips, strips, "B", true);
        charts.add(se2);
        MultiStripTimeAxisChart.TimeBounds focusTimes = new MultiStripTimeAxisChart.TimeBounds(18, 30, "foo");
        MultiStripTimeAxisChart.TimeBounds dataTimes = new MultiStripTimeAxisChart.TimeBounds(0, 72, "foo");
        JTextField myFeedback = new JTextField();
        ChartStack cstak = new ChartStack(myFeedback);
        cstak.setCharts(new Collected(charts, new HashMap(), null, null, null, null), focusTimes, dataTimes, 0, null);
        JFrame frame = new JFrame();
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JPanel cp = (JPanel)frame.getContentPane();
        cp.setLayout(new BorderLayout());
        cp.add((Component)myFeedback, "North");
        cp.add((Component)cstak, "Center");
        frame.pack();
        frame.setSize(new Dimension(300, 400));
        frame.show();
    }

    public class MouseHandler
    extends MouseAdapter {
        public void mouseReleased(MouseEvent me) {
            try {
                String tttext = ((JComponent)me.getSource()).getToolTipText(me);
                ChartStack.this.feedback_.setText(tttext);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    private static class StackElement {
        public ChartStackTitleBar titleBar;
        public MultiStripChartWrapper msc;
        public ChartStackableModelView csmv;
        public MouseHandler handler;

        public StackElement(ChartStackTitleBar titleBar, MultiStripChartWrapper msc, MouseHandler handler) {
            this.titleBar = titleBar;
            this.msc = msc;
            this.csmv = null;
            this.handler = handler;
        }

        public StackElement(ChartStackTitleBar titleBar, ChartStackableModelView csmv) {
            this.titleBar = titleBar;
            this.msc = null;
            this.csmv = csmv;
        }

        public void disableElement() {
            this.titleBar.disableBar();
        }

        public void enableElement() {
            this.titleBar.enableBar();
        }

        public JComponent getTooltipComponent() {
            return this.msc == null ? this.csmv.getToolTipTarget() : this.msc.getChart();
        }
    }

    public static class Collected {
        public List stripCharts;
        public String batchDataTitle;
        public String batchDataKey;
        public Map batchData;
        public GenomeSource neighborSrc;
        public Layout neighborLo;

        public Collected(List stripCharts) {
            this.stripCharts = stripCharts;
            this.batchDataTitle = null;
            this.batchDataKey = null;
            this.batchData = null;
            this.neighborSrc = null;
            this.neighborLo = null;
        }

        public Collected(List stripCharts, Map batchData, String batchDataTitle, String batchDataKey, GenomeSource neighborSrc, Layout neighborLo) {
            this.stripCharts = stripCharts;
            this.batchDataTitle = batchDataTitle;
            this.batchDataKey = batchDataKey;
            this.batchData = batchData;
            this.neighborSrc = neighborSrc;
            this.neighborLo = neighborLo;
        }
    }

    public static class DataSet {
        public String title;
        public List strips;
        public List prunedStrips;
        public boolean hasTimeAxis;
        public String uniqueKey;

        public DataSet(String title, List strips, List prunedStrips, String uniqueKey, boolean hasTimeAxis) {
            this.title = title;
            this.strips = strips;
            this.prunedStrips = prunedStrips;
            this.hasTimeAxis = hasTimeAxis;
            this.uniqueKey = uniqueKey;
        }
    }
}

