/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.HashMap;

public class ChartStackLayoutManager
implements LayoutManager2 {
    private int height_ = 0;
    private int minWidth_ = 0;
    private boolean haveCalc_ = false;
    private HashMap constraints_ = new HashMap();

    public StackRole getConstraint(Component comp) {
        return (StackRole)this.constraints_.get(comp);
    }

    public void addLayoutComponent(String name, Component comp) {
        throw new IllegalArgumentException();
    }

    public void addLayoutComponent(Component comp, Object constraint) {
        if (!(constraint instanceof StackRole)) {
            throw new IllegalArgumentException();
        }
        this.haveCalc_ = false;
        this.constraints_.put(comp, constraint);
    }

    public void removeLayoutComponent(Component comp) {
        this.haveCalc_ = false;
        this.constraints_.remove(comp);
    }

    public Dimension preferredLayoutSize(Container parent) {
        this.sizeCalcs(parent);
        Dimension dim = new Dimension(0, 0);
        Insets insets = parent.getInsets();
        dim.width = this.minWidth_ + insets.left + insets.right;
        dim.height = this.height_ + insets.top + insets.bottom;
        return dim;
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public Dimension maximumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        Dimension pDim = parent.getSize();
        int useWidth = pDim.width - (insets.left + insets.right);
        this.sizeCalcs(parent);
        int currY_ = insets.top;
        ArrayList<Component> bars = new ArrayList<Component>();
        int nComps = parent.getComponentCount();
        for (int i = 0; i < nComps; ++i) {
            Component comp = parent.getComponent(i);
            StackRole role = (StackRole)this.constraints_.get(comp);
            if (role == null) {
                throw new IllegalStateException();
            }
            if (!role.isButton && !role.isSpacer) continue;
            if (bars.size() <= role.position) {
                for (int j = bars.size(); j <= role.position; ++j) {
                    bars.add(null);
                }
            }
            bars.set(role.position, comp);
        }
        int nBars = bars.size();
        for (int i = 0; i < nBars; ++i) {
            Component comp = (Component)bars.get(i);
            if (comp == null) continue;
            Dimension d = comp.getPreferredSize();
            comp.setBounds(insets.left, currY_, useWidth, d.height);
            currY_ += d.height;
            StackRole role = (StackRole)this.constraints_.get(comp);
            Component target = role.target;
            if (target == null || !target.isVisible()) continue;
            d = target.getPreferredSize();
            target.setBounds(insets.left, currY_, useWidth, d.height);
            currY_ += d.height;
        }
    }

    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    public void invalidateLayout(Container parent) {
        this.haveCalc_ = false;
    }

    private void sizeCalcs(Container parent) {
        if (this.haveCalc_) {
            return;
        }
        this.height_ = 0;
        this.minWidth_ = 0;
        int nComps = parent.getComponentCount();
        for (int i = 0; i < nComps; ++i) {
            Component comp = parent.getComponent(i);
            StackRole role = (StackRole)this.constraints_.get(comp);
            if (role == null) {
                throw new IllegalStateException();
            }
            if (!role.isButton) continue;
            Dimension d = comp.getPreferredSize();
            Dimension dMin = comp.getMinimumSize();
            this.height_ += d.height;
            Component target = role.target;
            d = target.getPreferredSize();
            if (dMin.width > this.minWidth_) {
                this.minWidth_ = dMin.width;
            }
            if (!target.isVisible()) continue;
            this.height_ += d.height;
        }
        this.haveCalc_ = true;
    }

    public static class StackRole {
        public boolean isButton;
        public boolean isSpacer;
        public int position;
        public Component target;

        public StackRole(boolean isButton, int position, Component target) {
            this.isButton = isButton;
            this.isSpacer = false;
            this.position = position;
            this.target = target;
        }

        public StackRole(boolean isSpacer, int position) {
            this.isButton = false;
            this.isSpacer = isSpacer;
            this.position = position;
            this.target = null;
        }
    }
}

