/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.AbstractBorder;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.FixedJButton;
import org.systemsbiology.biotapestry.util.UiUtil;

public class ChartStackTitleBar
extends JPanel {
    private FixedJButton button_;
    private ImageIcon openedPic_;
    private ImageIcon closedPic_;
    private JLabel label_;
    private Component target_;
    private Container parent_;
    private String uniqueKey_;

    public ChartStackTitleBar(String name, Container parent, Component target, String uniqueKey) {
        this.setLayout(new GridBagLayout());
        this.setBorder(new ChartBorder(2));
        GridBagConstraints gbc = new GridBagConstraints();
        URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/Down16.gif");
        this.openedPic_ = new ImageIcon(ugif);
        ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/Forward16.gif");
        this.closedPic_ = new ImageIcon(ugif);
        this.button_ = new FixedJButton(this.openedPic_);
        this.button_.setBackground(Color.gray.brighter());
        this.label_ = new JLabel(name);
        this.parent_ = parent;
        this.target_ = target;
        this.uniqueKey_ = uniqueKey;
        UiUtil.gbcSet(gbc, 0, 0, 1, 1, 0, 0, 0, 5, 5, 5, 5, 17, 0.0, 1.0);
        this.add((Component)this.button_, gbc);
        this.button_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    boolean isVis = ChartStackTitleBar.this.target_.isVisible();
                    ChartStackTitleBar.this.setOpen(!isVis);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        this.setBackground(Color.gray.brighter());
        UiUtil.gbcSet(gbc, 1, 0, 0, 1, 1, 0, 0, 5, 5, 5, 5, 13, 1.0, 1.0);
        this.add((Component)this.label_, gbc);
    }

    public String getKey() {
        return this.uniqueKey_;
    }

    public void setKey(String key) {
        this.uniqueKey_ = key;
    }

    public boolean isOpen() {
        return this.target_.isVisible();
    }

    public void setOpen(boolean isVis) {
        this.target_.setVisible(isVis);
        this.button_.setIcon(!isVis ? this.closedPic_ : this.openedPic_);
        this.button_.repaint();
        this.parent_.validate();
    }

    public void disableBar() {
        this.button_.setEnabled(false);
    }

    public void enableBar() {
        this.button_.setEnabled(true);
    }

    public void setTitle(String name) {
        this.label_.setText(name);
    }

    public static class ChartBorder
    extends AbstractBorder {
        private int size_;

        public ChartBorder(int size) {
            this.size_ = size;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(Color.black);
            g.drawRect(x, y, width, this.size_);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(this.size_, 0, 0, 0);
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.top = this.size_;
            insets.bottom = 0;
            insets.left = 0;
            insets.right = 0;
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }
}

