/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import org.systemsbiology.biotapestry.analysis.Link;
import org.systemsbiology.biotapestry.db.GenomeSource;
import org.systemsbiology.biotapestry.db.LayoutSource;
import org.systemsbiology.biotapestry.db.LocalWorkspaceSource;
import org.systemsbiology.biotapestry.db.WorkspaceSource;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.ui.BusProperties;
import org.systemsbiology.biotapestry.ui.Intersection;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;
import org.systemsbiology.biotapestry.ui.dialogs.ModelViewPanel;
import org.systemsbiology.biotapestry.ui.dialogs.ModelViewPanelWithZoom;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.TrueObjChoiceContent;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.UnselectableJTable;

public class ChartStackableModelView
extends JPanel {
    private ModelViewPanel msp_;
    private CSTipGen tipGen_;
    private JComboBox batchCombo_;
    private boolean managingBatches_ = false;
    private BatchTableModel btm_;
    private UnselectableJTable ujt_;
    private Map currBatchVals_;
    private Genome currGenome_;
    static /* synthetic */ Class class$java$lang$String;

    public ChartStackableModelView() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        int rowNum = 0;
        ModelViewPanelWithZoom mvpwz = new ModelViewPanelWithZoom(null);
        this.msp_ = mvpwz.getModelView();
        this.tipGen_ = new CSTipGen();
        this.msp_.setToolTipGenerator((ModelViewPanel.TipGenerator)this.tipGen_);
        UiUtil.gbcSet(gbc, 0, rowNum, 1, 6, 1, 0, 0, 0, 5, 5, 5, 10, 1.0, 0.5);
        this.add((Component)mvpwz, gbc);
        this.batchCombo_ = new JComboBox();
        UiUtil.gbcSet(gbc, 0, rowNum += 6, 1, 1, 0, 0, 0, 0, 5, 5, 5, 13, 0.0, 0.0);
        this.add((Component)this.batchCombo_, gbc);
        this.batchCombo_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    ChartStackableModelView.this.setTheBatch();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        JPanel tab = this.buildBatchTable();
        UiUtil.gbcSet(gbc, 0, ++rowNum, 1, 6, 1, 0, 0, 0, 0, 0, 0, 10, 1.0, 0.5);
        this.add((Component)tab, gbc);
        rowNum += 6;
    }

    public JComponent getToolTipTarget() {
        return this.msp_;
    }

    public void setSources(GenomeSource src, LayoutSource layoutSrc, Map batchData) {
        if (src == null) {
            this.msp_.setGenome(null);
            this.msp_.setGraphLayout(null);
            this.tipGen_.setBatchSource(null);
            this.currBatchVals_ = null;
            this.installBatchSelections(new ArrayList());
            this.msp_.repaint();
            return;
        }
        this.currBatchVals_ = batchData;
        List bSel = this.getBatchSelections(batchData);
        this.installBatchSelections(bSel);
        this.msp_.setGenomeSource(src);
        this.currGenome_ = src.getGenome();
        String genomeID = this.currGenome_.getID();
        this.msp_.setGenome(genomeID);
        this.msp_.setLayoutSource(layoutSrc);
        this.msp_.setGraphLayout(layoutSrc.mapGenomeKeyToLayoutKey(genomeID));
        this.msp_.setWorkspaceSource((WorkspaceSource)new LocalWorkspaceSource());
        this.tipGen_.setBatchSource(batchData);
        this.msp_.fixCenterPoint(false, null, false);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(400, 400);
    }

    public void setTheBatch() {
        if (this.managingBatches_) {
            return;
        }
        TrueObjChoiceContent tocc = (TrueObjChoiceContent)this.batchCombo_.getSelectedItem();
        String batchID = tocc.val instanceof Integer ? null : (String)tocc.val;
        this.btm_.extractValues(this.currBatchVals_, batchID);
        this.ujt_.invalidate();
        this.validate();
        this.repaint();
    }

    private JPanel buildBatchTable() {
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel retval = new JPanel();
        retval.setLayout(new GridBagLayout());
        this.btm_ = new BatchTableModel();
        this.ujt_ = new UnselectableJTable(this.btm_);
        JTableHeader th = this.ujt_.getTableHeader();
        th.setReorderingAllowed(false);
        JScrollPane jsp = new JScrollPane(this.ujt_);
        UiUtil.gbcSet(gbc, 0, 1, 10, 8, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        retval.add((Component)jsp, gbc);
        return retval;
    }

    private List getBatchSelections(Map batchMap) {
        ArrayList<TrueObjChoiceContent> retval = new ArrayList<TrueObjChoiceContent>();
        ResourceManager rMan = ResourceManager.getManager();
        TreeSet<String> batchIDs = new TreeSet<String>();
        Iterator vit = batchMap.values().iterator();
        while (vit.hasNext()) {
            Map perLink = (Map)vit.next();
            Iterator bit = perLink.keySet().iterator();
            while (bit.hasNext()) {
                String bID = (String)bit.next();
                batchIDs.add(bID);
            }
        }
        retval.add(new TrueObjChoiceContent(rMan.getString("batchOpt.avg"), new Integer(0)));
        retval.add(new TrueObjChoiceContent(rMan.getString("batchOpt.max"), new Integer(1)));
        Iterator bidit = batchIDs.iterator();
        while (bidit.hasNext()) {
            String batchID = (String)bidit.next();
            retval.add(new TrueObjChoiceContent(batchID, batchID));
        }
        return retval;
    }

    private void installBatchSelections(List install) {
        this.managingBatches_ = true;
        this.batchCombo_.removeAllItems();
        int iNum = install.size();
        for (int i = 0; i < iNum; ++i) {
            TrueObjChoiceContent tocc = (TrueObjChoiceContent)install.get(i);
            this.batchCombo_.addItem(tocc);
        }
        this.managingBatches_ = false;
    }

    public static void main(String[] argv) {
        ChartStackableModelView csmv = new ChartStackableModelView();
        JFrame frame = new JFrame();
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.getContentPane().add(csmv);
        frame.pack();
        frame.setSize(new Dimension(300, 400));
        frame.show();
    }

    class BatchTableModel
    extends AbstractTableModel {
        private ArrayList srcColumn_;
        private ArrayList targColumn_;
        private ArrayList valColumn_;
        protected int rowCount_;

        BatchTableModel() {
        }

        public int getRowCount() {
            return this.rowCount_;
        }

        public void setValueAt(Object value, int r, int c) {
            throw new IllegalStateException();
        }

        public boolean isCellEditable(int r, int c) {
            return false;
        }

        public Object getValueAt(int r, int c) {
            try {
                switch (c) {
                    case 0: {
                        return this.srcColumn_.get(r);
                    }
                    case 1: {
                        return this.targColumn_.get(r);
                    }
                    case 2: {
                        return this.valColumn_.get(r);
                    }
                }
                throw new IllegalArgumentException();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
                return null;
            }
        }

        public int getColumnCount() {
            return 3;
        }

        public Class getColumnClass(int c) {
            try {
                switch (c) {
                    case 0: 
                    case 1: 
                    case 2: {
                        return class$java$lang$String == null ? (class$java$lang$String = ChartStackableModelView.class$("java.lang.String")) : class$java$lang$String;
                    }
                }
                throw new IllegalArgumentException();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
                return null;
            }
        }

        public String getColumnName(int c) {
            try {
                ResourceManager rMan = ResourceManager.getManager();
                switch (c) {
                    case 0: {
                        return rMan.getString("batchTab.source");
                    }
                    case 1: {
                        return rMan.getString("batchTab.target");
                    }
                    case 2: {
                        return rMan.getString("batchTab.value");
                    }
                }
                throw new IllegalArgumentException();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
                return null;
            }
        }

        void extractValues(Map batchMap, String batchID) {
            this.srcColumn_ = new ArrayList();
            this.targColumn_ = new ArrayList();
            this.valColumn_ = new ArrayList();
            this.rowCount_ = 0;
            if (batchID == null) {
                return;
            }
            Iterator kit = batchMap.keySet().iterator();
            while (kit.hasNext()) {
                Link link = (Link)kit.next();
                Map perLink = (Map)batchMap.get(link);
                Iterator bit = perLink.keySet().iterator();
                while (bit.hasNext()) {
                    String bID = (String)bit.next();
                    if (!bID.equals(batchID)) continue;
                    String srcName = ChartStackableModelView.this.currGenome_.getNode(link.getSrc()).getName();
                    String trgName = ChartStackableModelView.this.currGenome_.getNode(link.getTrg()).getName();
                    this.srcColumn_.add(srcName);
                    this.targColumn_.add(trgName);
                    List perBatch = (List)perLink.get(bID);
                    this.valColumn_.add(perBatch.toString());
                    ++this.rowCount_;
                }
            }
        }
    }

    public static class CSTipGen
    implements ModelViewPanel.TipGenerator {
        private Map batchSource_;

        public String generateTip(Genome genome, Layout layout, Intersection intersected) {
            LinkSegmentID segID;
            String objID = intersected.getObjectID();
            Linkage link = genome.getLinkage(objID);
            if (link == null) {
                return null;
            }
            BusProperties bp = layout.getLinkProperties(objID);
            Set linksThru = bp.resolveLinkagesThroughSegment(segID = intersected.segmentIDFromIntersect(), genome);
            if (linksThru.size() != 1) {
                return null;
            }
            String linkID = (String)linksThru.iterator().next();
            link = genome.getLinkage(linkID);
            Link batchLink = new Link(link.getSource(), link.getTarget());
            Map batchData = (Map)this.batchSource_.get(batchLink);
            if (batchData == null) {
                return batchLink.toString();
            }
            return batchData.toString();
        }

        public void setBatchSource(Map batchSource) {
            this.batchSource_ = batchSource;
        }
    }
}

