/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.systemsbiology.biotapestry.analysis.GraphColorer;
import org.systemsbiology.biotapestry.analysis.Link;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.ui.BusProperties;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.util.LinkPlacementGrid;

public class ColorAssigner {
    public static final int COLORING_OK = 0;
    public static final int COLOR_COLLISION = 1;
    public static final int COLOR_REASSIGNMENT = 2;
    public static final int TOO_FEW_COLORS = 4;
    private static final int MAYBE_COLOR_COLLISION = 8;

    public ColorIssues assignViaMap(Genome genome, Layout lo, LinkPlacementGrid grid, Map nodeColorMap, Map linkColorMap) {
        boolean retvalFlag = false;
        ColorIssues issues = new ColorIssues();
        Iterator ncmkit = nodeColorMap.keySet().iterator();
        while (ncmkit.hasNext()) {
            String nodeID = (String)ncmkit.next();
            NodeProperties np = lo.getNodeProperties(nodeID);
            String mapColor = (String)nodeColorMap.get(nodeID);
            np.setColor(mapColor);
        }
        Iterator lcmkit = linkColorMap.keySet().iterator();
        while (lcmkit.hasNext()) {
            String linkID = (String)lcmkit.next();
            BusProperties lp = lo.getLinkProperties(linkID);
            String mapColor = (String)linkColorMap.get(linkID);
            lp.setColor(mapColor);
        }
        ColorIssues newIssues = this.hasAmbiguousCrossing(genome, lo, grid);
        if (newIssues != null) {
            issues = newIssues;
        }
        return issues;
    }

    public ColorIssues assignColors(Genome genome, Layout lo, LinkPlacementGrid grid, Map colorMap, boolean keepColors, boolean incremental, Set needColors) {
        boolean retvalFlag = false;
        ColorIssues issues = new ColorIssues();
        if (keepColors) {
            this.keepColors(genome, lo, colorMap);
            ColorIssues newIssues = this.hasAmbiguousCrossing(genome, lo, grid);
            if (newIssues != null) {
                issues = newIssues;
            }
        } else {
            int assignRetval = this.assignUniqueColors(genome, needColors, lo, grid, colorMap, incremental);
            if ((assignRetval & 8) != 0) {
                ColorIssues newIssues = this.hasAmbiguousCrossing(genome, lo, grid);
                if (newIssues != null) {
                    issues.status |= 1;
                    issues.collisionSrc1 = newIssues.collisionSrc1;
                    issues.collisionSrc2 = newIssues.collisionSrc2;
                }
                assignRetval &= 0xFFFFFFF7;
            }
            issues.status |= assignRetval;
        }
        return issues;
    }

    public ColorIssues hasAmbiguousCrossing(Genome genome, Layout lo, LinkPlacementGrid grid) {
        Set crossings = grid.getAllCrossings();
        Iterator crit = crossings.iterator();
        while (crit.hasNext()) {
            String nodeName2;
            Link gcl = (Link)crit.next();
            BusProperties lp1 = lo.getLinkPropertiesForSource(gcl.getSrc());
            BusProperties lp2 = lo.getLinkPropertiesForSource(gcl.getTrg());
            if (!lp1.getColorName().equals(lp2.getColorName())) continue;
            String nodeName1 = genome.getNode(gcl.getSrc()).getName();
            if (nodeName1 == null) {
                nodeName1 = "";
            }
            if ((nodeName2 = genome.getNode(gcl.getTrg()).getName()) == null) {
                nodeName2 = "";
            }
            return new ColorIssues(nodeName1, nodeName2);
        }
        return null;
    }

    private void changeColors(String linkID, Genome genome, Layout lo, Map colorMap) {
        Linkage link = genome.getLinkage(linkID);
        BusProperties lp = lo.getLinkProperties(linkID);
        String src = link.getSource();
        NodeProperties np = lo.getNodeProperties(src);
        String colTag = null;
        if (colorMap != null) {
            colTag = (String)colorMap.get(src);
        }
        if (colTag == null) {
            colTag = Database.getDB().getNextColor();
            np.setColor(colTag);
            lp.setColor(colTag);
        } else if (colTag.equals("white")) {
            colTag = Database.getDB().getNextColor();
            np.setColor(colTag);
            lp.setColor(colTag);
        } else {
            lp.setColor(colTag);
        }
    }

    private void keepColors(Genome genome, Layout lo, Map colorMap) {
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            String mappedColor;
            Linkage link = (Linkage)lit.next();
            String linkID = link.getID();
            BusProperties lp = lo.getLinkProperties(linkID);
            String color = lp.getColorName();
            if (color.equals(mappedColor = (String)colorMap.get(linkID))) continue;
            lp.setColor(mappedColor);
        }
    }

    private int assignUniqueColors(Genome genome, Set needColors, Layout lo, LinkPlacementGrid grid, Map colorMapOrig, boolean incremental) {
        int needyClasses;
        Database db = Database.getDB();
        int retval = 0;
        HashMap colorMap = colorMapOrig == null ? null : new HashMap(colorMapOrig);
        HashSet<String> nodesWithLinksOut = null;
        if (colorMap != null && colorMap.size() > 0) {
            nodesWithLinksOut = new HashSet<String>();
            Iterator lit = genome.getLinkageIterator();
            while (lit.hasNext()) {
                Linkage link = (Linkage)lit.next();
                nodesWithLinksOut.add(link.getSource());
            }
        }
        int numColors = db.getNumColors();
        HashSet<String> availColors = new HashSet<String>();
        HashSet<String> legacyUnused = new HashSet<String>();
        for (int i = 0; i < numColors; ++i) {
            String color = db.getGeneColor(i);
            availColors.add(color);
            legacyUnused.add(color);
        }
        HashMap<String, String> linkForSource = new HashMap<String, String>();
        Iterator ncit = needColors.iterator();
        while (ncit.hasNext()) {
            String linkID = (String)ncit.next();
            Linkage link = genome.getLinkage(linkID);
            String src = link.getSource();
            linkForSource.put(src, linkID);
        }
        Set needySources = linkForSource.keySet();
        GraphColorer colorer = grid.buildCrossingGraph();
        HashMap colorAssignment = new HashMap();
        colorer.color(colorAssignment);
        HashMap colorToGroups = null;
        if (colorMap != null && colorMap.size() > 0) {
            colorToGroups = new HashMap();
        }
        HashMap classes = new HashMap();
        Iterator cait = colorAssignment.keySet().iterator();
        while (cait.hasNext()) {
            String preAssigned;
            String nodeID = (String)cait.next();
            Integer colorClass = (Integer)colorAssignment.get(nodeID);
            HashSet<String> nodeSet = (HashSet<String>)classes.get(colorClass);
            boolean newClass = false;
            if (nodeSet == null) {
                nodeSet = new HashSet<String>();
                classes.put(colorClass, nodeSet);
            }
            if (needySources.contains(nodeID)) {
                nodeSet.add(nodeID);
            }
            if (colorToGroups == null || nodesWithLinksOut == null || !nodesWithLinksOut.contains(nodeID) || (preAssigned = (String)colorMap.get(nodeID)) == null) continue;
            ArrayList<Integer> groupList = (ArrayList<Integer>)colorToGroups.get(preAssigned);
            if (groupList == null) {
                groupList = new ArrayList<Integer>();
                colorToGroups.put(preAssigned, groupList);
            }
            if (groupList.contains(colorClass)) continue;
            groupList.add(colorClass);
        }
        HashMap assignments = new HashMap();
        boolean bigGroupList = false;
        if (colorToGroups != null) {
            Iterator ctgit = colorToGroups.keySet().iterator();
            while (ctgit.hasNext()) {
                Integer groupNum;
                ArrayList<String> colorList;
                List groupList;
                String color = (String)ctgit.next();
                if (color.equals("black") || color.equals("white") || (groupList = (List)colorToGroups.get(color)) == null) continue;
                if (groupList.size() > 1) {
                    bigGroupList = true;
                }
                if ((colorList = (ArrayList<String>)assignments.get(groupNum = (Integer)groupList.get(0))) == null) {
                    colorList = new ArrayList<String>();
                    assignments.put(groupNum, colorList);
                }
                colorList.add(color);
                legacyUnused.remove(color);
                availColors.remove(color);
            }
        }
        if ((needyClasses = this.needyClassCount(classes, assignments)) > availColors.size()) {
            retval |= 4;
        }
        List assignOrder = this.sortEmptyBySize(classes, assignments);
        int numAssign = assignOrder.size();
        ArrayList unusedList = new ArrayList(legacyUnused);
        int currLegacyUnused = 0;
        int unusedSize = unusedList.size();
        for (int i = 0; i < numAssign; ++i) {
            String color;
            Integer groupNum = (Integer)assignOrder.get(i);
            ArrayList<String> colorList = (ArrayList<String>)assignments.get(groupNum);
            if (colorList == null) {
                colorList = new ArrayList<String>();
                assignments.put(groupNum, colorList);
            }
            if (!availColors.isEmpty()) {
                color = (String)availColors.iterator().next();
                availColors.remove(color);
                colorList.add(color);
                continue;
            }
            if (unusedSize > 0) {
                color = (String)unusedList.get(currLegacyUnused++);
                currLegacyUnused %= unusedSize;
                colorList.add(color);
                continue;
            }
            colorList.add("black");
        }
        Iterator acit = availColors.iterator();
        while (acit.hasNext()) {
            String color = (String)acit.next();
            Integer groupNum = this.worstLinksPerColor(classes, assignments);
            if (groupNum == null) continue;
            List colorList = (List)assignments.get(groupNum);
            if (colorList == null) {
                throw new IllegalStateException();
            }
            colorList.add(color);
        }
        availColors.clear();
        HashMap colorCycles = new HashMap();
        Iterator clait = classes.keySet().iterator();
        while (clait.hasNext()) {
            Integer colorClass = (Integer)clait.next();
            List colorList = (List)assignments.get(colorClass);
            Set nodeSet = (Set)classes.get(colorClass);
            if (nodeSet.size() == 0) continue;
            Iterator nsit = nodeSet.iterator();
            ArrayList remainingColors = new ArrayList();
            colorCycles.put(colorClass, remainingColors);
            while (nsit.hasNext()) {
                if (remainingColors.isEmpty()) {
                    db.getRarestColors(colorList, remainingColors);
                }
                String nodeID = (String)nsit.next();
                NodeProperties np = lo.getNodeProperties(nodeID);
                String linkID = (String)linkForSource.get(nodeID);
                BusProperties lp = lo.getLinkProperties(linkID);
                if (!incremental && colorMap != null) {
                    String mapColor;
                    String nodeColor;
                    if (bigGroupList) {
                        retval |= 2;
                    }
                    if ((nodeColor = np.getColorName()).equals(mapColor = (String)colorMap.remove(nodeID)) && !mapColor.equals("black") && !mapColor.equals("white")) {
                        lp.setColor(nodeColor);
                        remainingColors.remove(nodeColor);
                        continue;
                    }
                    if (colorList.contains(mapColor) && !mapColor.equals("white")) {
                        np.setColor(mapColor);
                        lp.setColor(mapColor);
                        remainingColors.remove(mapColor);
                        continue;
                    }
                    String useColor = (String)remainingColors.get(0);
                    np.setColor(useColor);
                    lp.setColor(useColor);
                    remainingColors.remove(useColor);
                    continue;
                }
                if (incremental && colorMap != null) {
                    String mapColor;
                    if (bigGroupList) {
                        retval |= 8;
                    }
                    if (colorList.contains(mapColor = (String)colorMap.remove(nodeID)) && !mapColor.equals("black") && !mapColor.equals("white")) {
                        lp.setColor(mapColor);
                        np.setColor(mapColor);
                        remainingColors.remove(mapColor);
                        continue;
                    }
                    String useColor = (String)remainingColors.get(0);
                    np.setColor(useColor);
                    lp.setColor(useColor);
                    remainingColors.remove(useColor);
                    continue;
                }
                String useColor = (String)remainingColors.get(0);
                np.setColor(useColor);
                lp.setColor(useColor);
                remainingColors.remove(useColor);
            }
        }
        if (colorMap != null) {
            Iterator cmit = colorMap.keySet().iterator();
            while (cmit.hasNext()) {
                String nodeID = (String)cmit.next();
                String useColor = (String)colorMap.get(nodeID);
                NodeProperties np = lo.getNodeProperties(nodeID);
                String nodeColor = np.getColorName();
                if (nodeColor.equals(useColor)) continue;
                if (nodesWithLinksOut.contains(nodeID)) {
                    throw new IllegalStateException();
                }
                np.setColor(useColor);
            }
        }
        return retval;
    }

    private List sortEmptyBySize(Map classes, Map assignments) {
        TreeMap sorter = new TreeMap(Collections.reverseOrder());
        Iterator ckit = classes.keySet().iterator();
        while (ckit.hasNext()) {
            Integer colorClass = (Integer)ckit.next();
            List colorList = (List)assignments.get(colorClass);
            if (colorList != null && colorList.size() > 0) continue;
            Set nodeSet = (Set)classes.get(colorClass);
            int numNodes = nodeSet == null ? 0 : nodeSet.size();
            Integer key = new Integer(numNodes);
            ArrayList<Integer> listForSize = (ArrayList<Integer>)sorter.get(key);
            if (listForSize == null) {
                listForSize = new ArrayList<Integer>();
                sorter.put(key, listForSize);
            }
            listForSize.add(colorClass);
        }
        ArrayList retval = new ArrayList();
        Iterator sit = sorter.keySet().iterator();
        while (sit.hasNext()) {
            Integer key = (Integer)sit.next();
            List listForSize = (List)sorter.get(key);
            retval.addAll(listForSize);
        }
        return retval;
    }

    private Integer worstLinksPerColor(Map classes, Map assignments) {
        TreeMap sorter = new TreeMap(Collections.reverseOrder());
        Iterator ckit = classes.keySet().iterator();
        while (ckit.hasNext()) {
            Integer colorClass = (Integer)ckit.next();
            List colorList = (List)assignments.get(colorClass);
            int colorCount = colorList == null ? 0 : colorList.size();
            Set nodeSet = (Set)classes.get(colorClass);
            int numNodes = nodeSet == null ? 0 : nodeSet.size();
            double ratio = (double)numNodes / (double)colorCount;
            Double key = new Double(ratio);
            ArrayList<Integer> listForSize = (ArrayList<Integer>)sorter.get(key);
            if (listForSize == null) {
                listForSize = new ArrayList<Integer>();
                sorter.put(key, listForSize);
            }
            listForSize.add(colorClass);
        }
        if (sorter.keySet().isEmpty()) {
            return null;
        }
        Double firstKey = (Double)sorter.keySet().iterator().next();
        List listForSize = (List)sorter.get(firstKey);
        return (Integer)listForSize.get(0);
    }

    private int needyClassCount(Map classes, Map assignments) {
        int retval = 0;
        Iterator ckit = classes.keySet().iterator();
        while (ckit.hasNext()) {
            Set nodeSet;
            Integer colorClass = (Integer)ckit.next();
            List colorList = (List)assignments.get(colorClass);
            if (colorList != null && colorList.size() > 0 || (nodeSet = (Set)classes.get(colorClass)) == null || nodeSet.size() == 0) continue;
            ++retval;
        }
        return retval;
    }

    public static final class ColorIssues {
        public int status;
        public String collisionSrc1;
        public String collisionSrc2;

        public ColorIssues() {
            this.status = 0;
        }

        public ColorIssues(String src1, String src2) {
            this.status = 1;
            this.collisionSrc1 = src1;
            this.collisionSrc2 = src2;
        }
    }
}

