/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JPanel;
import javax.swing.Timer;

public class CursorManager {
    private Cursor currCursor_;
    private int errCount_;
    private JPanel pan_;
    private Cursor xCur_;
    private Cursor errCur_;

    public CursorManager(JPanel pan, boolean isHeadless) {
        this.pan_ = pan;
        this.pan_.setCursor(Cursor.getPredefinedCursor(0));
        this.errCount_ = 0;
        if (!isHeadless) {
            this.buildCursors();
        }
    }

    public synchronized void showDefaultCursor() {
        this.currCursor_ = Cursor.getPredefinedCursor(0);
        if (this.errCount_ == 0) {
            this.pan_.setCursor(this.currCursor_);
        }
    }

    public synchronized void showModeCursor() {
        this.currCursor_ = this.xCur_;
        if (this.errCount_ == 0) {
            this.pan_.setCursor(this.currCursor_);
        }
    }

    public synchronized void signalError() {
        if (this.errCount_++ == 0) {
            this.pan_.setCursor(this.errCur_);
        }
        final Timer timer = new Timer(1000, null);
        timer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                CursorManager.this.clearError();
                timer.stop();
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    public synchronized void clearError() {
        if (--this.errCount_ == 0) {
            this.pan_.setCursor(this.currCursor_);
        }
    }

    private void buildCursors() {
        Image img;
        Point hot;
        Toolkit tkit;
        if (this.xCur_ == null) {
            tkit = Toolkit.getDefaultToolkit();
            URL xCurGif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/CrossCursor32.gif");
            hot = new Point(15, 15);
            img = tkit.createImage(xCurGif);
            this.xCur_ = tkit.createCustomCursor(img, hot, "btCustomCross");
        }
        if (this.errCur_ == null) {
            tkit = Toolkit.getDefaultToolkit();
            URL errCurGif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/ErrorCursor32.gif");
            hot = new Point(15, 15);
            img = tkit.createImage(errCurGif);
            this.errCur_ = tkit.createCustomCursor(img, hot, "btCustomError");
        }
    }
}

