/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.io.IOException;
import java.io.PrintWriter;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.parser.GlueStick;
import org.systemsbiology.biotapestry.ui.PerLinkDrawStyle;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.Indenter;
import org.xml.sax.Attributes;

public class CustomEvidenceDrawStyle
implements Cloneable {
    private PerLinkDrawStyle style_;
    private boolean showDiamonds_;
    private int evidenceLevel_;

    public CustomEvidenceDrawStyle(int level, boolean showDiamonds, PerLinkDrawStyle style) {
        this.style_ = style;
        this.showDiamonds_ = showDiamonds;
        this.evidenceLevel_ = level;
    }

    public CustomEvidenceDrawStyle(String levelString, String diamondString) throws IOException {
        try {
            this.evidenceLevel_ = Integer.parseInt(levelString);
        }
        catch (NumberFormatException nfex) {
            throw new IOException();
        }
        if (this.evidenceLevel_ <= 0 || this.evidenceLevel_ > 10) {
            throw new IOException();
        }
        this.showDiamonds_ = Boolean.valueOf(diamondString);
    }

    public Object clone() {
        try {
            CustomEvidenceDrawStyle retval = (CustomEvidenceDrawStyle)super.clone();
            retval.style_ = this.style_ == null ? null : (PerLinkDrawStyle)this.style_.clone();
            return retval;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public PerLinkDrawStyle getDrawStyle() {
        return this.style_;
    }

    public void setDrawStyle(PerLinkDrawStyle style) {
        this.style_ = style;
    }

    public int getEvidenceLevel() {
        return this.evidenceLevel_;
    }

    public boolean showDiamonds() {
        return this.showDiamonds_;
    }

    public void setShowDiamonds(boolean doDiamonds) {
        this.showDiamonds_ = doDiamonds;
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<customEvidenceDrawStyle level=\"");
        out.print(this.evidenceLevel_);
        out.print("\" diamonds=\"");
        out.print(this.showDiamonds_);
        if (this.style_ != null) {
            out.println("\" >");
            ind.up();
            this.style_.writeXML(out, ind);
            ind.down().indent();
            out.println("</customEvidenceDrawStyle>");
        } else {
            out.println("\" />");
        }
    }

    public static class MyStyleGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            CustomEvidenceDrawStyle plds = board.evidenceDrawSty;
            PerLinkDrawStyle plSty = board.perLinkSty;
            plds.setDrawStyle(plSty);
            return null;
        }
    }

    public static class CustomEvidenceDrawStyleWorker
    extends AbstractFactoryClient {
        public CustomEvidenceDrawStyleWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("customEvidenceDrawStyle");
            this.installWorker(new PerLinkDrawStyle.PerLinkDrawStyleWorker(whiteboard), new MyStyleGlue());
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            CustomEvidenceDrawStyle retval = null;
            if (elemName.equals("customEvidenceDrawStyle")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.evidenceDrawSty = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private CustomEvidenceDrawStyle buildFromXML(String elemName, Attributes attrs) throws IOException {
            String extentStr = AttributeExtractor.extractAttribute(elemName, attrs, "customEvidenceDrawStyle", "level", true);
            String diamondStr = AttributeExtractor.extractAttribute(elemName, attrs, "customEvidenceDrawStyle", "diamonds", true);
            return new CustomEvidenceDrawStyle(extentStr, diamondStr);
        }
    }
}

