/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.systemsbiology.biotapestry.cmd.PropChangeCmd;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.event.LayoutChangeEvent;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.nav.LayoutManager;
import org.systemsbiology.biotapestry.ui.FontManager;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.SUPanel;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.UndoSupport;

public class DataLocator {
    private static final int TOP_RIGHT_ = 0;
    private static final int TOP_CENTER_ = 1;
    private static final int BOTTOM_RIGHT_ = 2;
    private static final int BOTTOM_LEFT_ = 3;
    private SUPanel sup_;

    public DataLocator(SUPanel sup) {
        this.sup_ = sup;
    }

    public void setDataLocations(UndoSupport support, String date, String attrib, List key) {
        Database db = Database.getDB();
        Font mFont = FontManager.getMgr().getFont(9);
        Genome gen = db.getGenome();
        this.setLocationsForGenome(support, date, attrib, key, gen, mFont);
        Iterator giit = db.getInstanceIterator();
        while (giit.hasNext()) {
            GenomeInstance gi = (GenomeInstance)giit.next();
            if (gi.getVfgParent() != null) continue;
            this.setLocationsForGenome(support, date, attrib, key, gi, mFont);
        }
    }

    public void setTitleLocation(UndoSupport support, String genomeID, String title) {
        Database db = Database.getDB();
        Font tFont = FontManager.getMgr().getFont(10);
        Genome gen = db.getGenome();
        if (!genomeID.equals(gen.getID())) {
            GenomeInstance gi = (GenomeInstance)db.getGenome(genomeID);
            gen = gi.getVfgParent() == null ? gi : gi.getVfgParentRoot();
        }
        Layout lo = db.getLayout(new LayoutManager().getLayout(gen.getID()));
        Rectangle dims = this.sup_.getBasicBounds(gen.getID(), lo.getName(), false, false, 2);
        ArrayList<String> vals = new ArrayList<String>();
        vals.add(title);
        if (this.setMultiLocation(support, vals, "title", 1, lo, tFont, dims)) {
            support.addEvent(new LayoutChangeEvent(lo.getName(), 1));
        }
    }

    public Dimension calcKeyBounds(List vals, Layout lo, Font mFont, FontRenderContext frc) {
        double yTot = 0.0;
        double xMax = 0.0;
        int valSize = vals.size();
        if (valSize > 0) {
            xMax = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < valSize; ++i) {
                String entry = (String)vals.get(i);
                LineMetrics lm = mFont.getLineMetrics(entry, frc);
                yTot += (double)lm.getHeight();
                Rectangle2D bounds = mFont.getStringBounds(entry, frc);
                double width = bounds.getWidth();
                if (!(width > xMax)) continue;
                xMax = width;
            }
        }
        Dimension retval = new Dimension();
        retval.setSize(xMax, yTot);
        return retval;
    }

    private void setLocationsForGenome(UndoSupport support, String date, String attrib, List key, Genome genome, Font mFont) {
        Database db = Database.getDB();
        Layout lo = db.getLayout(new LayoutManager().getLayout(genome.getID()));
        boolean needEvent = false;
        Rectangle dims = null;
        if (genome.isEmpty() && genome.getNetworkModuleCount() == 0) {
            Point2D center = this.sup_.getRawCenterPoint();
            dims = new Rectangle((int)center.getX() - 100, (int)center.getY() - 100, 200, 200);
        } else {
            dims = this.sup_.getBasicBounds(genome.getID(), lo.getName(), false, false, 2);
        }
        ArrayList<String> vals = new ArrayList<String>();
        vals.add(date);
        if (this.setMultiLocation(support, vals, "date", 0, lo, mFont, dims)) {
            needEvent = true;
        }
        vals.clear();
        vals.add(attrib);
        if (this.setMultiLocation(support, vals, "attrib", 2, lo, mFont, dims)) {
            needEvent = true;
        }
        if (this.setMultiLocation(support, key, "key", 3, lo, mFont, dims)) {
            needEvent = true;
        }
        if (needEvent) {
            support.addEvent(new LayoutChangeEvent(lo.getName(), 1));
        }
    }

    private boolean setMultiLocation(UndoSupport support, List vals, String key, int location, Layout lo, Font mFont, Rectangle dims) {
        Point2D loc;
        int valSize = vals.size();
        if (valSize > 0 && (loc = lo.getDataLocation(key)) == null) {
            double yloc;
            double xloc;
            double width = 0.0;
            double height = 0.0;
            FontRenderContext frc = this.sup_.getFontRenderContext();
            if (valSize == 1) {
                String val = (String)vals.get(0);
                Rectangle2D bounds = mFont.getStringBounds(val, frc);
                width = bounds.getWidth();
                height = bounds.getHeight();
            } else {
                Dimension dim = this.calcKeyBounds(vals, lo, mFont, frc);
                width = dim.getWidth();
                height = dim.getHeight();
            }
            switch (location) {
                case 0: {
                    xloc = (double)(dims.x + dims.width) - width / 2.0;
                    yloc = (double)dims.y - height / 2.0;
                    break;
                }
                case 1: {
                    xloc = (double)dims.x + (double)dims.width / 2.0;
                    yloc = (double)dims.y - height / 2.0;
                    break;
                }
                case 2: {
                    xloc = (double)(dims.x + dims.width) - width / 2.0;
                    yloc = (double)(dims.y + dims.height) + height / 2.0;
                    break;
                }
                case 3: {
                    xloc = (double)dims.x + width / 2.0;
                    yloc = (double)(dims.y + dims.height) + height / 2.0;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            loc = new Point2D.Double(xloc, yloc);
            UiUtil.forceToGrid(xloc, yloc, loc, 10.0);
            Layout.PropChange pc = lo.setDataLocation(key, loc);
            support.addEdit(new PropChangeCmd(pc));
            return true;
        }
        return false;
    }
}

