/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.TimeAxisDefinition;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.parser.GlueStick;
import org.systemsbiology.biotapestry.perturb.MeasureDictionary;
import org.systemsbiology.biotapestry.ui.CustomEvidenceDrawStyle;
import org.systemsbiology.biotapestry.ui.DisplayOptionsManager;
import org.systemsbiology.biotapestry.ui.PerLinkDrawStyle;
import org.systemsbiology.biotapestry.ui.SuggestedDrawStyle;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.ChoiceContent;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.MinMax;
import org.systemsbiology.biotapestry.util.NameValuePair;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.xml.sax.Attributes;

public class DisplayOptions
implements Cloneable {
    public static final int NO_BUS_BRANCHES = 0;
    public static final int FILLED_BUS_BRANCHES = 1;
    public static final int OUTLINED_BUS_BRANCHES = 2;
    private static final int NUM_BUS_BRANCH_OPTIONS_ = 3;
    public static final String NO_BUS_BRANCHES_TAG = "noBranches";
    public static final String FILLED_BUS_BRANCHES_TAG = "filledBranches";
    public static final String OUTLINED_BUS_BRANCHES_TAG = "outlinedBranches";
    public static final int NO_EVIDENCE_DISPLAY = 0;
    public static final int EVIDENCE_WITH_DIAMONDS = 1;
    public static final int EVIDENCE_WITH_THICK_LINES = 2;
    public static final int EVIDENCE_WITH_BOTH = 3;
    public static final int EVIDENCE_IS_CUSTOM = 4;
    private static final int NUM_EVIDENCE_OPTIONS_ = 5;
    public static final String NO_EVIDENCE_TAG = "noEvidence";
    public static final String DIAMOND_EVIDENCE_TAG = "diamondEvidence";
    public static final String THICK_LINK_EVIDENCE_TAG = "thickEvidence";
    public static final String BOTH_TYPES_EVIDENCE_TAG = "diamondThickEvidence";
    public static final String CUSTOM_EVIDENCE_TAG = "customEvidence";
    public static final int FIRST_ZOOM_TO_ALL_MODELS = 0;
    public static final int FIRST_ZOOM_TO_CURRENT_MODEL = 1;
    public static final int FIRST_ZOOM_TO_WORKSPACE = 2;
    private static final int NUM_FIRST_ZOOM_TYPES_ = 3;
    public static final int NAV_MAINTAIN_ZOOM = 0;
    public static final int NAV_ZOOM_TO_EACH_MODEL = 1;
    private static final int NUM_NAV_ZOOM_TYPES_ = 2;
    public static final String FIRST_ZOOM_TO_ALL_MODELS_TAG_ = "firstZoomToAll";
    public static final String FIRST_ZOOM_TO_CURRENT_MODEL_TAG_ = "firstZoomToCurrent";
    public static final String FIRST_ZOOM_TO_WORKSPACE_TAG_ = "firstZoomToWorkspace";
    public static final String NAV_MAINTAIN_ZOOM_TAG_ = "navZoomMaintain";
    public static final String NAV_ZOOM_TO_EACH_MODEL_TAG_ = "navZoomToEach";
    public static final int NO_NODE_ACTIVITY_DISPLAY = 0;
    public static final int NODE_ACTIVITY_COLOR = 1;
    public static final int NODE_ACTIVITY_PIE = 2;
    public static final int NODE_ACTIVITY_BOTH = 3;
    private static final int NUM_NODE_ACTIVITY_OPTIONS_ = 4;
    public static final String NO_NODE_ACTIVITY_DISPLAY_TAG = "noNodeActivity";
    public static final String NODE_ACTIVITY_COLOR_TAG = "colorNodeActivity";
    public static final String NODE_ACTIVITY_PIE_TAG = "pieNodeActivity";
    public static final String NODE_ACTIVITY_BOTH_TAG = "colorAndPieNodeActivity";
    public static final int NO_LINK_ACTIVITY_DISPLAY = 0;
    public static final int LINK_ACTIVITY_COLOR = 1;
    public static final int LINK_ACTIVITY_THICK = 2;
    public static final int LINK_ACTIVITY_BOTH = 3;
    private static final int NUM_LINK_ACTIVITY_OPTIONS_ = 4;
    public static final String NO_LINK_ACTIVITY_DISPLAY_TAG = "noLinkActivity";
    public static final String LINK_ACTIVITY_COLOR_TAG = "colorLinkActivity";
    public static final String LINK_ACTIVITY_THICK_TAG = "thicknessLinkActivity";
    public static final String LINK_ACTIVITY_BOTH_TAG = "colorAndThicknessLinkActivity";
    private static final double DEFAULT_WEAK_EXPRESSION_LEVEL_ = 0.5;
    private int renderBusBranches_;
    private int renderEvidence_;
    private int repressionFootExtraSize_;
    private int renderNodeActivity_;
    private int renderLinkActivity_;
    private int firstZoom_;
    private int navZoom_;
    private double weakExpressionLevel_;
    private boolean displayExpressionTableTree_;
    private TreeMap customEvidence_;
    private ArrayList timeSpanCols_;
    private MinMax nullPertDefaultSpan_;
    private HashMap pertMeasureColors_;
    private String currentScaleTag_;
    private boolean breakOutInvestigators_;

    public DisplayOptions() {
        this.renderBusBranches_ = 0;
        this.renderEvidence_ = 1;
        this.repressionFootExtraSize_ = 0;
        this.firstZoom_ = 0;
        this.navZoom_ = 0;
        this.renderNodeActivity_ = 1;
        this.renderLinkActivity_ = 1;
        this.weakExpressionLevel_ = 0.5;
        this.displayExpressionTableTree_ = true;
        this.customEvidence_ = new TreeMap();
        this.timeSpanCols_ = new ArrayList();
        this.breakOutInvestigators_ = false;
        this.nullPertDefaultSpan_ = null;
        MeasureDictionary md = Database.getDB().getPertData().getMeasureDictionary();
        this.currentScaleTag_ = md.getStandardScaleKeys()[0];
        this.pertMeasureColors_ = new HashMap();
    }

    public DisplayOptions(String branches, String evidence, String footSize, String firstZoom, String navZoom, String nodeActivity, String linkActivity, String weakLevel, String dispTreeStr, String pertDefMin, String pertDefMax, String scaleTag, String breakOutStr) throws IOException {
        try {
            this.renderBusBranches_ = branches == null ? 0 : DisplayOptions.mapBranchTag(branches);
            this.renderEvidence_ = evidence == null ? 1 : DisplayOptions.mapEvidenceTag(evidence);
            this.firstZoom_ = firstZoom == null ? 0 : DisplayOptions.mapFirstZoomTypeTag(firstZoom);
            this.navZoom_ = navZoom == null ? 0 : DisplayOptions.mapNavZoomTypeTag(navZoom);
            this.renderNodeActivity_ = nodeActivity == null ? 1 : DisplayOptions.mapNodeActivityTag(nodeActivity);
            this.renderLinkActivity_ = linkActivity == null ? 1 : DisplayOptions.mapLinkActivityTag(linkActivity);
        }
        catch (IllegalArgumentException ex) {
            throw new IOException();
        }
        boolean bl = this.displayExpressionTableTree_ = dispTreeStr != null ? Boolean.valueOf(dispTreeStr) : true;
        if (footSize != null) {
            try {
                this.repressionFootExtraSize_ = Integer.parseInt(footSize);
            }
            catch (NumberFormatException ex) {
                throw new IOException();
            }
        } else {
            this.repressionFootExtraSize_ = 0;
        }
        if (weakLevel != null) {
            try {
                this.weakExpressionLevel_ = Double.parseDouble(weakLevel);
            }
            catch (NumberFormatException ex) {
                throw new IOException();
            }
            if (this.weakExpressionLevel_ < 0.0 || this.weakExpressionLevel_ > 1.0) {
                throw new IOException();
            }
        } else {
            this.weakExpressionLevel_ = 0.5;
        }
        this.customEvidence_ = new TreeMap();
        this.timeSpanCols_ = new ArrayList();
        this.pertMeasureColors_ = new HashMap();
        this.nullPertDefaultSpan_ = null;
        if (pertDefMin != null && pertDefMax != null) {
            try {
                int minTime = Integer.parseInt(pertDefMin);
                int maxTime = Integer.parseInt(pertDefMax);
                this.nullPertDefaultSpan_ = new MinMax(minTime, maxTime);
            }
            catch (NumberFormatException ex) {
                throw new IOException();
            }
        }
        this.breakOutInvestigators_ = breakOutStr != null ? Boolean.valueOf(breakOutStr) : false;
        this.currentScaleTag_ = scaleTag;
    }

    public boolean breakOutInvestigators() {
        return this.breakOutInvestigators_;
    }

    public void setBreakOutInvestigatorMode(boolean investMode) {
        this.breakOutInvestigators_ = investMode;
    }

    public Map getMeasurementDisplayColors() {
        if (this.pertMeasureColors_.isEmpty()) {
            HashMap<String, String> defMap = new HashMap<String, String>();
            MeasureDictionary md = Database.getDB().getPertData().getMeasureDictionary();
            Iterator mkit = md.getKeys();
            while (mkit.hasNext()) {
                String mkey = (String)mkit.next();
                defMap.put(mkey, "black");
            }
            return defMap;
        }
        return this.pertMeasureColors_;
    }

    public Map haveInconsistentMeasurementDisplayColors() {
        if (this.pertMeasureColors_.isEmpty()) {
            return null;
        }
        MeasureDictionary md = Database.getDB().getPertData().getMeasureDictionary();
        HashSet currKeys = new HashSet();
        Iterator mkit = md.getKeys();
        while (mkit.hasNext()) {
            currKeys.add(mkit.next());
        }
        if (currKeys.equals(this.pertMeasureColors_.keySet())) {
            return null;
        }
        HashMap<String, String> retval = new HashMap<String, String>();
        mkit = md.getKeys();
        while (mkit.hasNext()) {
            String key = (String)mkit.next();
            String color = (String)this.pertMeasureColors_.get(key);
            if (color == null) {
                color = "black";
            }
            retval.put(key, color);
        }
        return retval;
    }

    public String haveInconsistentScaleTag() {
        if (this.currentScaleTag_ == null) {
            return null;
        }
        MeasureDictionary md = Database.getDB().getPertData().getMeasureDictionary();
        Iterator mkit = md.getScaleKeys();
        while (mkit.hasNext()) {
            String key = (String)mkit.next();
            if (!key.equals(this.currentScaleTag_)) continue;
            return null;
        }
        return md.getStandardScaleKeys()[0];
    }

    public void setMeasurementDisplayColors(Map colors) {
        this.pertMeasureColors_.clear();
        this.pertMeasureColors_.putAll(colors);
    }

    public void addMeasurementDisplayColor(NameValuePair colorPair) {
        this.pertMeasureColors_.put(colorPair.getName(), colorPair.getValue());
    }

    public String getPerturbDataDisplayScaleKey() {
        if (this.currentScaleTag_ == null) {
            MeasureDictionary md = Database.getDB().getPertData().getMeasureDictionary();
            return md.getStandardScaleKeys()[0];
        }
        return this.currentScaleTag_;
    }

    public void setPerturbDataDisplayScaleKey(String scaleKey) {
        this.currentScaleTag_ = scaleKey;
    }

    public MinMax getNullPertDefaultSpan() {
        if (this.nullPertDefaultSpan_ == null) {
            TimeAxisDefinition tad = Database.getDB().getTimeAxisDefinition();
            return tad.isInitialized() ? tad.getDefaultTimeSpan() : null;
        }
        return this.nullPertDefaultSpan_;
    }

    public void setNullDefaultSpan(MinMax defaultSpan) {
        this.nullPertDefaultSpan_ = defaultSpan == null ? null : (MinMax)defaultSpan.clone();
    }

    public void dropDataBasedOptions() {
        this.pertMeasureColors_.clear();
        this.timeSpanCols_.clear();
        this.nullPertDefaultSpan_ = null;
        this.currentScaleTag_ = null;
    }

    public void setCustomEvidence(int level, CustomEvidenceDrawStyle ceds) {
        this.customEvidence_.put(new Integer(level), ceds);
    }

    public CustomEvidenceDrawStyle getCustomEvidence(int level) {
        return (CustomEvidenceDrawStyle)this.customEvidence_.get(new Integer(level));
    }

    public void fillCustomEvidenceMap(SortedMap map) {
        Iterator ceit = this.customEvidence_.keySet().iterator();
        while (ceit.hasNext()) {
            Integer level = (Integer)ceit.next();
            CustomEvidenceDrawStyle ceds = (CustomEvidenceDrawStyle)this.customEvidence_.get(level);
            map.put(level, ceds.clone());
        }
    }

    public int getLinkActivity() {
        return this.renderLinkActivity_;
    }

    public boolean showExpressionTableTree() {
        return this.displayExpressionTableTree_;
    }

    public PerLinkDrawStyle getEvidenceDrawChange(int evidence) {
        PerLinkDrawStyle retval = null;
        if (evidence == 0) {
            return retval;
        }
        if (this.renderEvidence_ == 2 || this.renderEvidence_ == 3) {
            SuggestedDrawStyle style = new SuggestedDrawStyle(0, null, -1);
            retval = new PerLinkDrawStyle(style, 2);
        } else if (this.renderEvidence_ == 4) {
            CustomEvidenceDrawStyle ceds = (CustomEvidenceDrawStyle)this.customEvidence_.get(new Integer(evidence));
            if (ceds == null) {
                return retval;
            }
            retval = ceds.getDrawStyle();
        }
        return retval;
    }

    public boolean drawEvidenceGlyphs(int evidence) {
        if (evidence == 0) {
            return false;
        }
        if (this.renderEvidence_ == 1 || this.renderEvidence_ == 3) {
            return true;
        }
        if (this.renderEvidence_ == 4) {
            CustomEvidenceDrawStyle ceds = (CustomEvidenceDrawStyle)this.customEvidence_.get(new Integer(evidence));
            if (ceds == null) {
                return true;
            }
            return ceds.showDiamonds();
        }
        return false;
    }

    public int getNodeActivity() {
        return this.renderNodeActivity_;
    }

    public boolean changeNodeColorForActivity() {
        return this.renderNodeActivity_ == 1 || this.renderNodeActivity_ == 3;
    }

    public boolean showNodePieForActivity() {
        return this.renderNodeActivity_ == 2 || this.renderNodeActivity_ == 3;
    }

    public int getEvidence() {
        return this.renderEvidence_;
    }

    public int getBranchMode() {
        return this.renderBusBranches_;
    }

    public int getExtraFootSize() {
        return this.repressionFootExtraSize_;
    }

    public double getWeakExpressionLevel() {
        return this.weakExpressionLevel_;
    }

    public int getFirstZoomMode() {
        return this.firstZoom_;
    }

    public int getNavZoomMode() {
        return this.navZoom_;
    }

    public void setEvidence(int evidence) {
        this.renderEvidence_ = evidence;
    }

    public void setBranchMode(int branchMode) {
        this.renderBusBranches_ = branchMode;
    }

    public void setExtraFootSize(int extraSize) {
        if (extraSize < 0) {
            throw new IllegalArgumentException();
        }
        this.repressionFootExtraSize_ = extraSize;
    }

    public void setWeakExpressionLevel(double weakLevel) {
        if (weakLevel < 0.0 || weakLevel > 1.0) {
            throw new IllegalArgumentException();
        }
        this.weakExpressionLevel_ = weakLevel;
    }

    public void setFirstZoomMode(int firstZoom) {
        this.firstZoom_ = firstZoom;
    }

    public void setNavZoomMode(int navZoom) {
        this.navZoom_ = navZoom;
    }

    public void setNodeActivity(int nodeActivity) {
        this.renderNodeActivity_ = nodeActivity;
    }

    public void setLinkActivity(int linkActivity) {
        this.renderLinkActivity_ = linkActivity;
    }

    public void setShowExpressionTableTree(boolean newVal) {
        this.displayExpressionTableTree_ = newVal;
    }

    public void setColumns(ArrayList columns) {
        this.timeSpanCols_.clear();
        this.timeSpanCols_.addAll(columns);
    }

    public void addColumn(MinMax col) {
        this.timeSpanCols_.add(col);
    }

    public Iterator getColumnIterator() {
        return this.timeSpanCols_.iterator();
    }

    public boolean hasColumns() {
        return this.timeSpanCols_.size() > 0;
    }

    public boolean hasDefaultTimeSpan() {
        return this.nullPertDefaultSpan_ != null;
    }

    public Object clone() {
        try {
            DisplayOptions retval = (DisplayOptions)super.clone();
            retval.customEvidence_ = new TreeMap();
            Iterator kit = this.customEvidence_.keySet().iterator();
            while (kit.hasNext()) {
                Integer level = (Integer)kit.next();
                CustomEvidenceDrawStyle ceds = (CustomEvidenceDrawStyle)this.customEvidence_.get(level);
                retval.customEvidence_.put(level, ceds);
            }
            retval.timeSpanCols_ = new ArrayList();
            Iterator cit = this.timeSpanCols_.iterator();
            while (cit.hasNext()) {
                MinMax mm = (MinMax)cit.next();
                retval.timeSpanCols_.add(mm.clone());
            }
            retval.nullPertDefaultSpan_ = this.nullPertDefaultSpan_ == null ? null : (MinMax)this.nullPertDefaultSpan_.clone();
            retval.pertMeasureColors_ = new HashMap(this.pertMeasureColors_);
            return retval;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<displayOptions ");
        if (this.renderBusBranches_ != 0) {
            out.print("branches=\"");
            out.print(DisplayOptions.mapBranches(this.renderBusBranches_));
            out.print("\" ");
        }
        if (this.renderEvidence_ != 1) {
            out.print("evidence=\"");
            out.print(DisplayOptions.mapEvidence(this.renderEvidence_));
            out.print("\" ");
        }
        if (this.repressionFootExtraSize_ != 0) {
            out.print("bigFoot=\"");
            out.print(this.repressionFootExtraSize_);
            out.print("\" ");
        }
        if (this.firstZoom_ != 0) {
            out.print("firstZoom=\"");
            out.print(DisplayOptions.mapFirstZoomTypes(this.firstZoom_));
            out.print("\" ");
        }
        if (this.navZoom_ != 0) {
            out.print("navZoom=\"");
            out.print(DisplayOptions.mapNavZoomTypes(this.navZoom_));
            out.print("\" ");
        }
        if (this.renderNodeActivity_ != 1) {
            out.print("nodeActivity=\"");
            out.print(DisplayOptions.mapNodeActivity(this.renderNodeActivity_));
            out.print("\" ");
        }
        if (this.renderLinkActivity_ != 1) {
            out.print("linkActivity=\"");
            out.print(DisplayOptions.mapLinkActivity(this.renderLinkActivity_));
            out.print("\" ");
        }
        if (this.weakExpressionLevel_ != 0.5) {
            out.print("weakLevel=\"");
            out.print(this.weakExpressionLevel_);
            out.print("\" ");
        }
        if (!this.displayExpressionTableTree_) {
            out.print("showTree=\"false\" ");
        }
        if (this.breakOutInvestigators_) {
            out.print("breakInvest=\"true\" ");
        }
        if (this.currentScaleTag_ != null) {
            out.print("scale=\"");
            out.print(this.currentScaleTag_);
            out.print("\" ");
        }
        if (this.nullPertDefaultSpan_ != null) {
            out.print("pdMin=\"");
            out.print(this.nullPertDefaultSpan_.min);
            out.print("\" pdMax=\"");
            out.print(this.nullPertDefaultSpan_.max);
            out.print("\" ");
        }
        if (this.renderEvidence_ == 4 || this.hasColumns() || !this.pertMeasureColors_.isEmpty()) {
            out.println(">");
            ind.up();
            if (this.hasColumns()) {
                ind.indent();
                out.println("<colRanges>");
                Iterator cit = this.timeSpanCols_.iterator();
                ind.up();
                while (cit.hasNext()) {
                    MinMax tc = (MinMax)cit.next();
                    ind.indent();
                    out.print("<colRange min=\"");
                    out.print(tc.min);
                    if (tc.min != tc.max) {
                        out.print("\" max=\"");
                        out.print(tc.max);
                    }
                    out.println("\" />");
                }
                ind.down().indent();
                out.println("</colRanges>");
            }
            if (this.renderEvidence_ == 4) {
                ind.indent();
                out.println("<customEvidence>");
                ind.up();
                Iterator ceit = this.customEvidence_.values().iterator();
                while (ceit.hasNext()) {
                    CustomEvidenceDrawStyle ceds = (CustomEvidenceDrawStyle)ceit.next();
                    ceds.writeXML(out, ind);
                }
                ind.down().indent();
                out.println("</customEvidence>");
            }
            if (!this.pertMeasureColors_.isEmpty()) {
                ind.indent();
                out.println("<pertColors>");
                TreeSet sorted = new TreeSet(this.pertMeasureColors_.keySet());
                Iterator pcit = sorted.iterator();
                ind.up();
                while (pcit.hasNext()) {
                    String key = (String)pcit.next();
                    ind.indent();
                    out.print("<pertColor key=\"");
                    out.print(key);
                    out.print("\" color=\"");
                    out.print(this.pertMeasureColors_.get(key));
                    out.println("\" />");
                }
                ind.down().indent();
                out.println("</pertColors>");
            }
            ind.down().indent();
            out.println("</displayOptions>");
        } else {
            out.println("/>");
        }
    }

    public static String mapBranches(int busBranch) {
        switch (busBranch) {
            case 0: {
                return NO_BUS_BRANCHES_TAG;
            }
            case 1: {
                return FILLED_BUS_BRANCHES_TAG;
            }
            case 2: {
                return OUTLINED_BUS_BRANCHES_TAG;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int mapBranchTag(String busBranchTag) {
        if (busBranchTag.equalsIgnoreCase(NO_BUS_BRANCHES_TAG)) {
            return 0;
        }
        if (busBranchTag.equalsIgnoreCase(FILLED_BUS_BRANCHES_TAG)) {
            return 1;
        }
        if (busBranchTag.equalsIgnoreCase(OUTLINED_BUS_BRANCHES_TAG)) {
            return 2;
        }
        throw new IllegalArgumentException();
    }

    public static String mapEvidence(int evidence) {
        switch (evidence) {
            case 0: {
                return NO_EVIDENCE_TAG;
            }
            case 1: {
                return DIAMOND_EVIDENCE_TAG;
            }
            case 2: {
                return THICK_LINK_EVIDENCE_TAG;
            }
            case 3: {
                return BOTH_TYPES_EVIDENCE_TAG;
            }
            case 4: {
                return CUSTOM_EVIDENCE_TAG;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int mapEvidenceTag(String evidenceTag) {
        if (evidenceTag.equalsIgnoreCase(NO_EVIDENCE_TAG)) {
            return 0;
        }
        if (evidenceTag.equalsIgnoreCase(DIAMOND_EVIDENCE_TAG)) {
            return 1;
        }
        if (evidenceTag.equalsIgnoreCase(THICK_LINK_EVIDENCE_TAG)) {
            return 2;
        }
        if (evidenceTag.equalsIgnoreCase(BOTH_TYPES_EVIDENCE_TAG)) {
            return 3;
        }
        if (evidenceTag.equalsIgnoreCase(CUSTOM_EVIDENCE_TAG)) {
            return 4;
        }
        throw new IllegalArgumentException();
    }

    public static Vector branchOptions() {
        Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
        for (int i = 0; i < 3; ++i) {
            retval.add(DisplayOptions.mapBranchOptions(i));
        }
        return retval;
    }

    public static ChoiceContent mapBranchOptions(int val) {
        ResourceManager rMan = ResourceManager.getManager();
        return new ChoiceContent(rMan.getString("displayOptions." + DisplayOptions.mapBranches(val)), val);
    }

    public static Vector evidenceOptions() {
        Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
        for (int i = 0; i < 5; ++i) {
            retval.add(DisplayOptions.mapEvidenceOptions(i));
        }
        return retval;
    }

    public static ChoiceContent mapEvidenceOptions(int val) {
        ResourceManager rMan = ResourceManager.getManager();
        return new ChoiceContent(rMan.getString("displayOptions." + DisplayOptions.mapEvidence(val)), val);
    }

    public static String mapFirstZoomTypes(int firstZoomType) {
        switch (firstZoomType) {
            case 0: {
                return FIRST_ZOOM_TO_ALL_MODELS_TAG_;
            }
            case 1: {
                return FIRST_ZOOM_TO_CURRENT_MODEL_TAG_;
            }
            case 2: {
                return FIRST_ZOOM_TO_WORKSPACE_TAG_;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int mapFirstZoomTypeTag(String zoomTypeTag) {
        if (zoomTypeTag.equalsIgnoreCase(FIRST_ZOOM_TO_ALL_MODELS_TAG_)) {
            return 0;
        }
        if (zoomTypeTag.equalsIgnoreCase(FIRST_ZOOM_TO_CURRENT_MODEL_TAG_)) {
            return 1;
        }
        if (zoomTypeTag.equalsIgnoreCase(FIRST_ZOOM_TO_WORKSPACE_TAG_)) {
            return 2;
        }
        throw new IllegalArgumentException();
    }

    public static Vector getFirstZoomChoices() {
        Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
        for (int i = 0; i < 3; ++i) {
            retval.add(DisplayOptions.firstZoomForCombo(i));
        }
        return retval;
    }

    public static ChoiceContent firstZoomForCombo(int firstZoomType) {
        return new ChoiceContent(ResourceManager.getManager().getString("displayOptions." + DisplayOptions.mapFirstZoomTypes(firstZoomType)), firstZoomType);
    }

    public static String mapNavZoomTypes(int navZoomType) {
        switch (navZoomType) {
            case 0: {
                return NAV_MAINTAIN_ZOOM_TAG_;
            }
            case 1: {
                return NAV_ZOOM_TO_EACH_MODEL_TAG_;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int mapNavZoomTypeTag(String navZoomTypeTag) {
        if (navZoomTypeTag.equalsIgnoreCase(NAV_MAINTAIN_ZOOM_TAG_)) {
            return 0;
        }
        if (navZoomTypeTag.equalsIgnoreCase(NAV_ZOOM_TO_EACH_MODEL_TAG_)) {
            return 1;
        }
        throw new IllegalArgumentException();
    }

    public static Vector getNavZoomChoices() {
        Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
        for (int i = 0; i < 2; ++i) {
            retval.add(DisplayOptions.navZoomForCombo(i));
        }
        return retval;
    }

    public static ChoiceContent navZoomForCombo(int navZoomType) {
        return new ChoiceContent(ResourceManager.getManager().getString("displayOptions." + DisplayOptions.mapNavZoomTypes(navZoomType)), navZoomType);
    }

    public static String mapNodeActivity(int nodeActivity) {
        switch (nodeActivity) {
            case 0: {
                return NO_NODE_ACTIVITY_DISPLAY_TAG;
            }
            case 1: {
                return NODE_ACTIVITY_COLOR_TAG;
            }
            case 2: {
                return NODE_ACTIVITY_PIE_TAG;
            }
            case 3: {
                return NODE_ACTIVITY_BOTH_TAG;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int mapNodeActivityTag(String nodeActivityTag) {
        if (nodeActivityTag.equalsIgnoreCase(NO_NODE_ACTIVITY_DISPLAY_TAG)) {
            return 0;
        }
        if (nodeActivityTag.equalsIgnoreCase(NODE_ACTIVITY_COLOR_TAG)) {
            return 1;
        }
        if (nodeActivityTag.equalsIgnoreCase(NODE_ACTIVITY_PIE_TAG)) {
            return 2;
        }
        if (nodeActivityTag.equalsIgnoreCase(NODE_ACTIVITY_BOTH_TAG)) {
            return 3;
        }
        throw new IllegalArgumentException();
    }

    public static Vector getNodeActivityChoices() {
        Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
        for (int i = 0; i < 4; ++i) {
            retval.add(DisplayOptions.nodeActivityForCombo(i));
        }
        return retval;
    }

    public static ChoiceContent nodeActivityForCombo(int nodeActivity) {
        return new ChoiceContent(ResourceManager.getManager().getString("displayOptions." + DisplayOptions.mapNodeActivity(nodeActivity)), nodeActivity);
    }

    public static String mapLinkActivity(int linkActivity) {
        switch (linkActivity) {
            case 0: {
                return NO_LINK_ACTIVITY_DISPLAY_TAG;
            }
            case 1: {
                return LINK_ACTIVITY_COLOR_TAG;
            }
            case 2: {
                return LINK_ACTIVITY_THICK_TAG;
            }
            case 3: {
                return LINK_ACTIVITY_BOTH_TAG;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int mapLinkActivityTag(String linkActivityTag) {
        if (linkActivityTag.equalsIgnoreCase(NO_LINK_ACTIVITY_DISPLAY_TAG)) {
            return 0;
        }
        if (linkActivityTag.equalsIgnoreCase(LINK_ACTIVITY_COLOR_TAG)) {
            return 1;
        }
        if (linkActivityTag.equalsIgnoreCase(LINK_ACTIVITY_THICK_TAG)) {
            return 2;
        }
        if (linkActivityTag.equalsIgnoreCase(LINK_ACTIVITY_BOTH_TAG)) {
            return 3;
        }
        throw new IllegalArgumentException();
    }

    public static Vector getLinkActivityChoices() {
        Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
        for (int i = 0; i < 4; ++i) {
            retval.add(DisplayOptions.linkActivityForCombo(i));
        }
        return retval;
    }

    public static ChoiceContent linkActivityForCombo(int linkActivity) {
        return new ChoiceContent(ResourceManager.getManager().getString("displayOptions." + DisplayOptions.mapLinkActivity(linkActivity)), linkActivity);
    }

    public static class ColorWorker
    extends AbstractFactoryClient {
        public ColorWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("pertColor");
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            NameValuePair retval = null;
            if (elemName.equals("pertColor")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.pertColorPair = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private NameValuePair buildFromXML(String elemName, Attributes attrs) throws IOException {
            String keyStr = AttributeExtractor.extractAttribute(elemName, attrs, "pertColor", "key", true);
            String colorStr = AttributeExtractor.extractAttribute(elemName, attrs, "pertColor", "color", true);
            return new NameValuePair(keyStr, colorStr);
        }
    }

    public static class ColumnWorker
    extends AbstractFactoryClient {
        public ColumnWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("colRange");
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            MinMax retval = null;
            if (elemName.equals("colRange")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.column = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private MinMax buildFromXML(String elemName, Attributes attrs) throws IOException {
            String minStr = AttributeExtractor.extractAttribute(elemName, attrs, "colRange", "min", true);
            String maxStr = AttributeExtractor.extractAttribute(elemName, attrs, "colRange", "max", false);
            try {
                int minVal;
                int maxVal = minVal = Integer.parseInt(minStr);
                if (maxStr != null) {
                    maxVal = Integer.parseInt(maxStr);
                }
                return new MinMax(minVal, maxVal);
            }
            catch (NumberFormatException ex) {
                throw new IOException();
            }
        }
    }

    public static class MyColorGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            board.displayOptions.addMeasurementDisplayColor(board.pertColorPair);
            return null;
        }
    }

    public static class MyColumnGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            board.displayOptions.addColumn(board.column);
            return null;
        }
    }

    public static class MyStyleGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            DisplayOptions dopt = board.displayOptions;
            CustomEvidenceDrawStyle plds = board.evidenceDrawSty;
            dopt.setCustomEvidence(plds.getEvidenceLevel(), plds);
            return null;
        }
    }

    public static class DisplayOptionsWorker
    extends AbstractFactoryClient {
        public DisplayOptionsWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("displayOptions");
            this.installWorker(new CustomEvidenceDrawStyle.CustomEvidenceDrawStyleWorker(whiteboard), new MyStyleGlue());
            this.installWorker(new ColumnWorker(whiteboard), new MyColumnGlue());
            this.installWorker(new ColorWorker(whiteboard), new MyColorGlue());
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            DisplayOptions retval = null;
            if (elemName.equals("displayOptions")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                board.displayOptions = this.buildFromXML(elemName, attrs);
                DisplayOptionsManager.getMgr().setDisplayOptionsForIO(board.displayOptions);
                retval = board.displayOptions;
            }
            return retval;
        }

        private DisplayOptions buildFromXML(String elemName, Attributes attrs) throws IOException {
            String branchStr = AttributeExtractor.extractAttribute(elemName, attrs, "displayOptions", "branches", false);
            String evidenceStr = AttributeExtractor.extractAttribute(elemName, attrs, "displayOptions", "evidence", false);
            String footStr = AttributeExtractor.extractAttribute(elemName, attrs, "displayOptions", "bigFoot", false);
            String firstZoom = AttributeExtractor.extractAttribute(elemName, attrs, "displayOptions", "firstZoom", false);
            String navZoom = AttributeExtractor.extractAttribute(elemName, attrs, "displayOptions", "navZoom", false);
            String nodeActivity = AttributeExtractor.extractAttribute(elemName, attrs, "displayOptions", "nodeActivity", false);
            String linkActivity = AttributeExtractor.extractAttribute(elemName, attrs, "displayOptions", "linkActivity", false);
            String weakLevel = AttributeExtractor.extractAttribute(elemName, attrs, "displayOptions", "weakLevel", false);
            String showTreeStr = AttributeExtractor.extractAttribute(elemName, attrs, "displayOptions", "showTree", false);
            String pertDefMin = AttributeExtractor.extractAttribute(elemName, attrs, "displayOptions", "pdMin", false);
            String pertDefMax = AttributeExtractor.extractAttribute(elemName, attrs, "displayOptions", "pdMax", false);
            String scaleTag = AttributeExtractor.extractAttribute(elemName, attrs, "displayOptions", "scale", false);
            String breakOutStr = AttributeExtractor.extractAttribute(elemName, attrs, "displayOptions", "breakInvest", false);
            return new DisplayOptions(branchStr, evidenceStr, footStr, firstZoom, navZoom, nodeActivity, linkActivity, weakLevel, showTreeStr, pertDefMin, pertDefMax, scaleTag, breakOutStr);
        }
    }
}

