/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.io.PrintWriter;
import java.util.Map;
import org.systemsbiology.biotapestry.cmd.DisplayOptionsChangeCmd;
import org.systemsbiology.biotapestry.event.LayoutChangeEvent;
import org.systemsbiology.biotapestry.ui.DisplayOptions;
import org.systemsbiology.biotapestry.ui.DisplayOptionsChange;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.UndoSupport;

public class DisplayOptionsManager {
    private static DisplayOptionsManager singleton_;
    private DisplayOptions options_ = new DisplayOptions();
    private boolean bigScreen_ = false;

    public void setForBigScreen(boolean bigScreen) {
        this.bigScreen_ = bigScreen;
    }

    public boolean isForBigScreen() {
        return this.bigScreen_;
    }

    public DisplayOptions getDisplayOptions() {
        return this.options_;
    }

    public void setDisplayOptionsForIO(DisplayOptions opts) {
        this.options_ = opts;
    }

    public DisplayOptionsChange setDisplayOptions(DisplayOptions opts) {
        DisplayOptionsChange retval = new DisplayOptionsChange();
        retval.oldOpts = (DisplayOptions)this.options_.clone();
        this.options_ = opts;
        retval.newOpts = (DisplayOptions)this.options_.clone();
        return retval;
    }

    public void modifyForPertDataChange(UndoSupport support) {
        Map revMap = this.options_.haveInconsistentMeasurementDisplayColors();
        String revSTag = this.options_.haveInconsistentScaleTag();
        if (revMap != null || revSTag != null) {
            DisplayOptions revDO = (DisplayOptions)this.options_.clone();
            if (revMap != null) {
                revDO.setMeasurementDisplayColors(revMap);
            }
            if (revSTag != null) {
                revDO.setPerturbDataDisplayScaleKey(revSTag);
            }
            DisplayOptionsChange doc = this.setDisplayOptions(revDO);
            DisplayOptionsChangeCmd docc = new DisplayOptionsChangeCmd(doc);
            support.addEdit(docc);
        }
    }

    public void turnOnSpecialLinkBranches(String layoutKey, UndoSupport support) {
        DisplayOptions newOpts = (DisplayOptions)this.options_.clone();
        newOpts.setBranchMode(2);
        DisplayOptionsChange doc = this.setDisplayOptions(newOpts);
        DisplayOptionsChangeCmd docc = new DisplayOptionsChangeCmd(doc);
        support.addEdit(docc);
        LayoutChangeEvent lcev = new LayoutChangeEvent(layoutKey, 1);
        support.addEvent(lcev);
        support.finish();
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        this.options_.writeXML(out, ind);
    }

    public void changeUndo(DisplayOptionsChange undo) {
        this.options_ = (DisplayOptions)undo.oldOpts.clone();
    }

    public void changeRedo(DisplayOptionsChange redo) {
        this.options_ = (DisplayOptions)redo.newOpts.clone();
    }

    public static synchronized DisplayOptionsManager getMgr() {
        if (singleton_ == null) {
            singleton_ = new DisplayOptionsManager();
        }
        return singleton_;
    }

    private DisplayOptionsManager() {
    }
}

