/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.systemsbiology.biotapestry.ui.FontChange;
import org.systemsbiology.biotapestry.util.Indenter;
import org.xml.sax.Attributes;

public class FontManager {
    public static final int SMALL = 0;
    public static final int MEDIUM = 1;
    public static final int MODULE_NAME = 2;
    public static final int GENE_NAME = 3;
    public static final int LINK_LABEL = 4;
    public static final int MED_LARGE = 5;
    public static final int NET_MODULE = 6;
    public static final int LARGE = 7;
    public static final int NOTES = 8;
    public static final int DATE = 9;
    public static final int TITLE = 10;
    private static final int NUM_FONTS_ = 11;
    public static final int TREE = 0;
    public static final int STRIP_CHART = 1;
    public static final int STRIP_CHART_AXIS = 2;
    public static final int WORKSHEET_TITLES_LARGE = 3;
    public static final int WORKSHEET_TITLES_MED = 4;
    public static final int WORKSHEET_TITLES_SMALL = 5;
    public static final int TOPO_BUBBLES = 6;
    private static final int NUM_FIXED_ = 7;
    public static final int MIN_SIZE = 6;
    public static final int MAX_SIZE = 40;
    private static FontManager singleton_;
    private boolean[] init_ = new boolean[11];
    private Font[] fonts_ = new Font[11];
    private Font[] defaults_ = new Font[11];
    private Font[] fixed_;
    private HashMap overrides_;
    private HashMap overBounds_;
    private String[] tags_;
    private Rectangle2D[] charBounds_ = new Rectangle2D[11];
    private FontRenderContext cacheBasis_ = null;

    public int getNumFonts() {
        return 11;
    }

    public Font getDefaultFont(int fontType) {
        return this.defaults_[fontType];
    }

    public Font getFont(int fontType) {
        return this.fonts_[fontType];
    }

    public Font getOverrideFont(int fontType, FontOverride over) {
        if (over == null) {
            return this.fonts_[fontType];
        }
        Font retval = (Font)this.overrides_.get(over);
        if (retval == null) {
            String type = over.makeSansSerif ? "SansSerif" : "Serif";
            int style = FontManager.calcStyle(over.makeBold, over.makeItalic);
            retval = new Font(type, style, over.size);
            this.overrides_.put(over.clone(), retval);
        }
        return retval;
    }

    public Rectangle2D getCharSize(int fontType, FontOverride fo, FontRenderContext frc) {
        Rectangle2D retval;
        if (this.cacheBasis_ == null || !this.cacheBasis_.equals(frc)) {
            this.flushSizeCache();
            this.cacheBasis_ = frc;
        }
        if (fo == null) {
            if (this.charBounds_[fontType] == null) {
                this.charBounds_[fontType] = this.fonts_[fontType].getMaxCharBounds(frc);
            }
            retval = this.charBounds_[fontType];
        } else {
            retval = (Rectangle2D)this.overBounds_.get(fo);
            if (retval == null) {
                Font overFont = this.getOverrideFont(fontType, fo);
                retval = overFont.getMaxCharBounds(frc);
                this.overBounds_.put(fo.clone(), retval);
            }
        }
        return retval;
    }

    public String getFontTag(int fontType) {
        return this.tags_[fontType];
    }

    public Font getFixedFont(int fontType) {
        return this.fixed_[fontType];
    }

    public FontChange resetToDefaults() {
        FontChange retval = new FontChange();
        retval.oldFonts = new Font[11];
        System.arraycopy(this.fonts_, 0, retval.oldFonts, 0, 11);
        for (int i = 0; i < 11; ++i) {
            this.fonts_[i] = this.defaults_[i];
        }
        retval.newFonts = new Font[11];
        System.arraycopy(this.fonts_, 0, retval.newFonts, 0, 11);
        this.overrides_.clear();
        this.flushSizeCache();
        return retval;
    }

    private void setFont(int fontType, int size, boolean makeBold, boolean makeItalic, boolean makeSansSerif) {
        String type = makeSansSerif ? "SansSerif" : "Serif";
        int style = FontManager.calcStyle(makeBold, makeItalic);
        this.fonts_[fontType] = new Font(type, style, size);
        this.flushSizeCache();
    }

    public FontChange setFonts(List fontSpecs) {
        FontChange retval = new FontChange();
        retval.oldFonts = new Font[11];
        System.arraycopy(this.fonts_, 0, retval.oldFonts, 0, 11);
        int specSize = fontSpecs.size();
        for (int i = 0; i < specSize; ++i) {
            FontSpec fs = (FontSpec)fontSpecs.get(i);
            this.setFont(fs.fontType, fs.size, fs.makeBold, fs.makeItalic, fs.makeSansSerif);
        }
        retval.newFonts = new Font[11];
        System.arraycopy(this.fonts_, 0, retval.newFonts, 0, 11);
        this.flushSizeCache();
        return retval;
    }

    public int getPointSize(int fontType) {
        Font currFont = this.fonts_[fontType];
        return currFont.getSize();
    }

    public boolean isFontBold(int fontType) {
        Font currFont = this.fonts_[fontType];
        return currFont.isBold();
    }

    public boolean isFontItalic(int fontType) {
        Font currFont = this.fonts_[fontType];
        return currFont.isItalic();
    }

    public boolean isFontSansSerif(int fontType) {
        Font currFont = this.fonts_[fontType];
        return FontManager.isSansSerif(currFont);
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.println("<fonts>");
        ind.up();
        for (int i = 0; i < this.fonts_.length; ++i) {
            ind.indent();
            out.print("<font ");
            out.print("name=\"");
            out.print(this.getFontTag(i));
            out.print("\" type=\"");
            out.print(this.isFontSansSerif(i) ? "sanSerif" : "serif");
            out.print("\" isBold=\"");
            out.print(this.isFontBold(i));
            out.print("\" isItalic=\"");
            out.print(this.isFontItalic(i));
            out.print("\" size=\"");
            out.print(this.getPointSize(i));
            out.println("\" />");
        }
        ind.down().indent();
        out.println("</fonts>");
    }

    public void changeUndo(FontChange undo) {
        this.fonts_ = undo.oldFonts;
        this.flushSizeCache();
    }

    public void changeRedo(FontChange undo) {
        this.fonts_ = undo.newFonts;
        this.flushSizeCache();
    }

    public void fixupLegacyIO() {
        Font oldFont;
        if (!this.init_[2]) {
            oldFont = this.fonts_[1];
            this.fonts_[2] = new Font(oldFont.getName(), oldFont.getStyle(), oldFont.getSize());
            this.init_[2] = true;
        }
        if (!this.init_[3]) {
            oldFont = this.fonts_[1];
            this.fonts_[3] = new Font(oldFont.getName(), oldFont.getStyle(), oldFont.getSize());
            this.init_[3] = true;
        }
        if (!this.init_[4]) {
            oldFont = this.fonts_[1];
            this.fonts_[4] = new Font(oldFont.getName(), oldFont.getStyle(), oldFont.getSize());
            this.init_[4] = true;
        }
        if (!this.init_[6]) {
            oldFont = this.fonts_[7];
            this.fonts_[6] = new Font(oldFont.getName(), oldFont.getStyle(), oldFont.getSize());
            this.init_[6] = true;
        }
        if (!this.init_[8]) {
            oldFont = this.fonts_[7];
            this.fonts_[8] = new Font(oldFont.getName(), oldFont.getStyle(), oldFont.getSize());
            this.init_[8] = true;
        }
    }

    public static int calcStyle(boolean doBold, boolean doItalic) {
        int style = doBold ? (doItalic ? 3 : 1) : (doItalic ? 2 : 0);
        return style;
    }

    public static boolean isSansSerif(Font currFont) {
        String name = currFont.getName();
        return name.equals("SansSerif");
    }

    public static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("fonts");
        return retval;
    }

    public static String getFontKeyword() {
        return "font";
    }

    public static synchronized FontManager getMgr() {
        if (singleton_ == null) {
            singleton_ = new FontManager();
        }
        return singleton_;
    }

    public static void installFromXML(String elemName, Attributes attrs) throws IOException {
        int pts;
        String name = null;
        String type = null;
        String isBold = null;
        String isItalic = null;
        String size = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("name")) {
                    name = val;
                    continue;
                }
                if (key.equals("type")) {
                    type = val;
                    continue;
                }
                if (key.equals("isBold")) {
                    isBold = val;
                    continue;
                }
                if (key.equals("isItalic")) {
                    isItalic = val;
                    continue;
                }
                if (!key.equals("size")) continue;
                size = val;
            }
        }
        if (name == null || type == null || isBold == null || size == null) {
            throw new IOException();
        }
        int index = -1;
        if ((name = name.trim()).equalsIgnoreCase("small")) {
            index = 0;
        } else if (name.equalsIgnoreCase("medium")) {
            index = 1;
        } else if (name.equalsIgnoreCase("cisRegName")) {
            index = 2;
        } else if (name.equalsIgnoreCase("geneName")) {
            index = 3;
        } else if (name.equalsIgnoreCase("link")) {
            index = 4;
        } else if (name.equalsIgnoreCase("netModule")) {
            index = 6;
        } else if (name.equalsIgnoreCase("mediumLarge")) {
            index = 5;
        } else if (name.equalsIgnoreCase("large")) {
            index = 7;
        } else if (name.equalsIgnoreCase("notes")) {
            index = 8;
        } else if (name.equalsIgnoreCase("date")) {
            index = 9;
        } else if (name.equalsIgnoreCase("title")) {
            index = 10;
        } else {
            throw new IOException();
        }
        type = type.trim();
        if (type.equalsIgnoreCase("serif")) {
            type = "Serif";
        } else if (type.equalsIgnoreCase("sanSerif")) {
            type = "SansSerif";
        } else {
            throw new IOException();
        }
        boolean doItalic = isItalic == null ? false : Boolean.valueOf(isItalic);
        boolean doBold = Boolean.valueOf(isBold);
        int style = FontManager.calcStyle(doBold, doItalic);
        try {
            pts = Integer.parseInt(size);
        }
        catch (NumberFormatException nfe) {
            throw new IOException();
        }
        if (pts < 6 || pts > 40) {
            throw new IOException();
        }
        FontManager mgr = FontManager.getMgr();
        mgr.fonts_[index] = new Font(type, style, pts);
        mgr.init_[index] = true;
    }

    private FontManager() {
        this.fixed_ = new Font[7];
        this.tags_ = new String[]{"small", "medium", "cisRegName", "geneName", "link", "mediumLarge", "netModule", "large", "notes", "date", "title"};
        this.overrides_ = new HashMap();
        this.overBounds_ = new HashMap();
        this.defaults_[1] = new Font("Serif", 1, 28);
        this.defaults_[2] = new Font("Serif", 1, 28);
        this.defaults_[3] = new Font("Serif", 1, 28);
        this.defaults_[4] = new Font("Serif", 1, 28);
        this.defaults_[5] = new Font("SansSerif", 1, 30);
        this.defaults_[6] = new Font("SansSerif", 1, 34);
        this.defaults_[7] = new Font("SansSerif", 1, 34);
        this.defaults_[8] = new Font("SansSerif", 1, 34);
        this.defaults_[0] = new Font("Serif", 1, 20);
        this.defaults_[9] = new Font("SansSerif", 0, 25);
        this.defaults_[10] = new Font("SansSerif", 1, 32);
        for (int i = 0; i < 11; ++i) {
            this.fonts_[i] = this.defaults_[i];
            this.init_[i] = false;
        }
        this.fixed_[0] = new Font("SansSerif", 0, 10);
        this.fixed_[1] = new Font("SanSerif", 0, 12);
        this.fixed_[2] = new Font("Serif", 0, 12);
        this.fixed_[3] = new Font("SanSerif", 1, 20);
        this.fixed_[4] = new Font("SanSerif", 1, 16);
        this.fixed_[5] = new Font("SanSerif", 1, 14);
        this.fixed_[6] = new Font("Serif", 1, 60);
    }

    private void flushSizeCache() {
        for (int i = 0; i < 11; ++i) {
            this.charBounds_[i] = null;
        }
        this.overBounds_.clear();
        this.cacheBasis_ = null;
    }

    public static class FontOverride
    implements Cloneable {
        public int size;
        public boolean makeBold;
        public boolean makeItalic;
        public boolean makeSansSerif;

        public FontOverride(int size, boolean makeBold, boolean makeItalic, boolean makeSansSerif) {
            this.size = size;
            this.makeBold = makeBold;
            this.makeItalic = makeItalic;
            this.makeSansSerif = makeSansSerif;
        }

        public Object clone() {
            try {
                FontOverride retval = (FontOverride)super.clone();
                return retval;
            }
            catch (CloneNotSupportedException cnse) {
                throw new IllegalStateException();
            }
        }

        public String toString() {
            return "FontOverride: size=" + this.size + " bold=" + this.makeBold + " italic=" + this.makeItalic + " sans=" + this.makeSansSerif;
        }

        public int hashCode() {
            return this.size + (this.makeBold ? 200 : 100) + (this.makeItalic ? 2000 : 1000) + (this.makeSansSerif ? 20000 : 10000);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!(other instanceof FontOverride)) {
                return false;
            }
            FontOverride otherFO = (FontOverride)other;
            return this.size == otherFO.size && this.makeBold == otherFO.makeBold && this.makeItalic == otherFO.makeItalic && this.makeSansSerif == otherFO.makeSansSerif;
        }
    }

    public static class FontSpec {
        public int fontType;
        public int size;
        public boolean makeBold;
        public boolean makeItalic;
        public boolean makeSansSerif;

        public FontSpec(int fontType, int size, boolean makeBold, boolean makeItalic, boolean makeSansSerif) {
            this.fontType = fontType;
            this.size = size;
            this.makeBold = makeBold;
            this.makeItalic = makeItalic;
            this.makeSansSerif = makeSansSerif;
        }
    }
}

