/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.undo.UndoManager;
import org.systemsbiology.biotapestry.analysis.SignedLink;
import org.systemsbiology.biotapestry.cmd.SelectionChangeCmd;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.GenomeSource;
import org.systemsbiology.biotapestry.db.LayoutSource;
import org.systemsbiology.biotapestry.db.ModelData;
import org.systemsbiology.biotapestry.embedded.ExternalSelectionChangeEvent;
import org.systemsbiology.biotapestry.event.SelectionChangeEvent;
import org.systemsbiology.biotapestry.gaggle.GooseAppInterface;
import org.systemsbiology.biotapestry.gaggle.GooseManager;
import org.systemsbiology.biotapestry.gaggle.SelectionSupport;
import org.systemsbiology.biotapestry.genome.DBGenome;
import org.systemsbiology.biotapestry.genome.DBNode;
import org.systemsbiology.biotapestry.genome.DynamicGenomeInstance;
import org.systemsbiology.biotapestry.genome.DynamicInstanceProxy;
import org.systemsbiology.biotapestry.genome.Gene;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.GenomeItem;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.genome.Group;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.NetModule;
import org.systemsbiology.biotapestry.genome.NetModuleMember;
import org.systemsbiology.biotapestry.genome.NetOverlayOwner;
import org.systemsbiology.biotapestry.genome.NetworkOverlay;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.genome.Note;
import org.systemsbiology.biotapestry.nav.GroupSettingManager;
import org.systemsbiology.biotapestry.ui.BusProperties;
import org.systemsbiology.biotapestry.ui.DataLocator;
import org.systemsbiology.biotapestry.ui.DisplayOptions;
import org.systemsbiology.biotapestry.ui.DisplayOptionsManager;
import org.systemsbiology.biotapestry.ui.FontManager;
import org.systemsbiology.biotapestry.ui.GroupProperties;
import org.systemsbiology.biotapestry.ui.INodeRenderer;
import org.systemsbiology.biotapestry.ui.IRenderer;
import org.systemsbiology.biotapestry.ui.Intersection;
import org.systemsbiology.biotapestry.ui.IntersectionChooser;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LinkProperties;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;
import org.systemsbiology.biotapestry.ui.Mergeable;
import org.systemsbiology.biotapestry.ui.NetModuleProperties;
import org.systemsbiology.biotapestry.ui.NetOverlayProperties;
import org.systemsbiology.biotapestry.ui.NoteProperties;
import org.systemsbiology.biotapestry.ui.OverlayStateOracle;
import org.systemsbiology.biotapestry.ui.RenderObjectCache;
import org.systemsbiology.biotapestry.ui.SelectionChange;
import org.systemsbiology.biotapestry.ui.ZoomPresentation;
import org.systemsbiology.biotapestry.ui.freerender.DrawTree;
import org.systemsbiology.biotapestry.ui.freerender.GroupFree;
import org.systemsbiology.biotapestry.ui.freerender.LinkageFree;
import org.systemsbiology.biotapestry.ui.freerender.NetModuleFree;
import org.systemsbiology.biotapestry.ui.freerender.NetModuleLinkageFree;
import org.systemsbiology.biotapestry.ui.freerender.NetOverlayFree;
import org.systemsbiology.biotapestry.ui.freerender.ProtoLinkFree;
import org.systemsbiology.biotapestry.util.Bounds;
import org.systemsbiology.biotapestry.util.TaggedSet;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.UndoSupport;

public class GenomePresentation
implements ZoomPresentation {
    public static final int BOUNDS_PAD = 200;
    public static final int NET_MODULE_INTERIOR = 0;
    public static final int NET_MODULE_LINK_PAD = 1;
    public static final int NET_MODULE_BOUNDARY = 2;
    public static final int NET_MODULE_NAME = 3;
    public static final int NET_MODULE_DEFINITION_RECT = 4;
    private String currSelZoomKey_ = null;
    private HashMap selectionKeys_ = new HashMap();
    private Object floater_ = null;
    private Color floaterColor_ = null;
    private Point2D floatPoint_;
    private Layout floaterLayout_;
    private Genome floaterGenome_;
    private HashSet currentTargets_;
    private HashSet currentRootOverlays_;
    private String nullRender_;
    private boolean viewerOnly_;
    private boolean processSelections_;
    private HashMap viewerRocCache_;
    private HashMap ghostedViewerRocCache_;
    private GenomeSource source_;
    private LayoutSource layoutSource_;
    private FontRenderContext frc_;
    private UndoManager undo_;
    public static final int NO_PAD_FIXUP = 0;
    public static final int PAD_FIXUP_THIS_OVERLAY = 1;
    public static final int PAD_FIXUP_FULL_LAYOUT = 2;

    public GenomePresentation(double zoom, boolean viewerOnly, UndoManager undo, boolean processSelections) {
        this.undo_ = undo;
        this.floaterGenome_ = new DBGenome("floater", "floater");
        this.floaterLayout_ = new Layout("floater", "floater");
        this.currentTargets_ = new HashSet();
        this.currentRootOverlays_ = new HashSet();
        this.viewerOnly_ = viewerOnly;
        this.viewerRocCache_ = new HashMap();
        this.ghostedViewerRocCache_ = new HashMap();
        this.processSelections_ = processSelections;
        this.source_ = Database.getDB();
        this.layoutSource_ = (LayoutSource)((Object)this.source_);
        this.setPresentationZoomFactor(zoom);
    }

    public boolean linksAreHidden(Layout layout, OverlayStateOracle oso) {
        boolean hideLinks = false;
        if (oso != null && oso.getCurrentOverlay() != null) {
            NetOverlayProperties nop = layout.getNetOverlayProperties(oso.getCurrentOverlay());
            hideLinks = nop.hideLinks();
        }
        return hideLinks;
    }

    public void setGenomeSource(GenomeSource source) {
        this.source_ = source;
    }

    public void setLayoutSource(LayoutSource source) {
        this.layoutSource_ = source;
    }

    public void presentGenome(Graphics2D g2, String genomeKey, Layout layout, boolean showBubbles, boolean showRoot, OverlayStateOracle oso, Rectangle2D clipRect, double pixDiam) {
        this.presentGenomeWithOverlay(g2, null, genomeKey, layout, showBubbles, showRoot, oso, null, clipRect, pixDiam);
    }

    public void presentGenomeWithOverlay(Graphics2D g2, OpaqueOverlayInfo ooi, String genomeKey, Layout layout, boolean showBubbles, boolean showRoot, OverlayStateOracle oso, Set showComponents, Rectangle2D clipRect, double pixDiam) {
        RenderObjectCache linkRoc;
        Genome genome = this.source_.getGenome(genomeKey);
        ArrayList renderedRects = null;
        boolean hideLinks = false;
        if (genome instanceof GenomeInstance) {
            GenomeInstance ancestorVfg;
            GenomeInstance child = (GenomeInstance)genome;
            GenomeInstance rootvfg = child.getVfgParentRoot();
            GenomeInstance genomeInstance = ancestorVfg = showRoot ? rootvfg : child.getVfgParent();
            if (oso != null && oso.getCurrentOverlay() != null) {
                renderedRects = new ArrayList();
            }
            this.renderGroupsInBackground(g2, rootvfg, child, layout, renderedRects, clipRect, pixDiam);
            hideLinks = this.overlayRender(g2, genome, layout, null, null, oso, true, showComponents, showBubbles, clipRect, pixDiam);
            if (rootvfg != null) {
                this.presentationGuts(g2, ancestorVfg, layout, true, showBubbles, false, hideLinks, clipRect, pixDiam);
                this.presentUnusedGroups(g2, rootvfg, ancestorVfg, child, layout, clipRect, pixDiam);
            }
            linkRoc = this.presentationGuts(g2, genome, layout, false, showBubbles, false, hideLinks, clipRect, pixDiam);
            this.renderGroupsInForeground(g2, rootvfg, child, layout, clipRect, pixDiam);
        } else {
            hideLinks = this.overlayRender(g2, genome, layout, null, null, oso, true, showComponents, showBubbles, clipRect, pixDiam);
            linkRoc = this.presentationGuts(g2, genome, layout, false, showBubbles, false, hideLinks, clipRect, pixDiam);
        }
        this.overlayRender(ooi != null ? ooi.overlayLayerG2 : g2, genome, layout, renderedRects, linkRoc, oso, false, showComponents, showBubbles, clipRect, pixDiam);
        if (ooi != null) {
            ooi.renderImage(g2);
        }
        this.renderModelData(g2, genome, layout, false);
        this.renderFloater(g2, showBubbles, clipRect, pixDiam);
    }

    private boolean overlayRender(Graphics2D g2, Genome genome, Layout layout, List renderedRects, RenderObjectCache roc, OverlayStateOracle oso, boolean doUnderlay, Set showComponents, boolean showBubbles, Rectangle2D clipRect, double pixDiam) {
        boolean hideLinks = false;
        if (oso != null && oso.getCurrentOverlay() != null) {
            Database db = Database.getDB();
            String genomeKey = genome.getID();
            NetOverlayOwner owner = db.getOverlayOwnerFromGenomeKey(genomeKey);
            NetworkOverlay no = owner.getNetworkOverlay(oso.getCurrentOverlay());
            NetOverlayProperties nop = layout.getNetOverlayProperties(oso.getCurrentOverlay());
            hideLinks = nop.hideLinks();
            NetOverlayFree nof = no.getRenderer();
            RenderObjectCache overRoc = new RenderObjectCache();
            nof.render(g2, overRoc, genome, layout, no, renderedRects, oso, doUnderlay, showComponents, showBubbles, clipRect, pixDiam);
            overRoc.render(g2);
            if (doUnderlay || !this.overlayIsOpaque(layout, oso.getCurrentOverlay()) || this.selectionKeys_.isEmpty()) {
                return hideLinks;
            }
            g2.setComposite(AlphaComposite.Clear);
            Iterator nit = genome.getAllNodeIterator();
            while (nit.hasNext()) {
                Intersection selected;
                Node node = (Node)nit.next();
                if (node.getID().equals(this.nullRender_) || (selected = this.isSelected(this.selectionKeys_, node)) == null) continue;
                INodeRenderer render = layout.getNodeProperties(node.getID()).getRenderer();
                render.render(g2, null, genome, node, layout, selected, false, false, clipRect, pixDiam, null);
            }
            if (roc != null) {
                roc.renderALayer(g2, DrawTree.getSelectionLayerKey());
            }
            g2.setComposite(AlphaComposite.SrcOver);
        }
        return hideLinks;
    }

    public void presentRootGenome(Graphics2D g2, String genomeKey, Layout layout, boolean isGhosted, Rectangle2D clipRect, double pixDiam) {
        Genome genome = this.source_.getGenome(genomeKey);
        if (genome instanceof GenomeInstance) {
            throw new IllegalArgumentException();
        }
        this.presentationGuts(g2, genome, layout, isGhosted, false, false, false, clipRect, pixDiam);
    }

    public Map getNoteBounds(Graphics2D g2, Genome genome, Layout layout) {
        HashMap<String, Rectangle> retval = new HashMap<String, Rectangle>();
        FontRenderContext frc = g2.getFontRenderContext();
        Iterator noit = genome.getNoteIterator();
        while (noit.hasNext()) {
            Note note = (Note)noit.next();
            IRenderer render = layout.getNoteProperties(note.getID()).getRenderer();
            Rectangle bounds = render.getBounds(genome, note, layout, frc, null);
            retval.put(note.getID(), bounds);
        }
        return retval;
    }

    public Map getNodeBounds(Graphics2D g2, Genome genome, Layout layout) {
        HashMap<String, Rectangle> retval = new HashMap<String, Rectangle>();
        FontRenderContext frc = g2.getFontRenderContext();
        Iterator noit = genome.getAllNodeIterator();
        while (noit.hasNext()) {
            Node node = (Node)noit.next();
            INodeRenderer render = layout.getNodeProperties(node.getID()).getRenderer();
            Rectangle bounds = render.getBounds(genome, node, layout, frc, null);
            retval.put(node.getID(), bounds);
        }
        return retval;
    }

    public void bumpPreviousSelection(String modelKey) {
        this.bumpGuts(false, modelKey);
    }

    public void bumpNextSelection(String modelKey) {
        this.bumpGuts(true, modelKey);
    }

    private void bumpGuts(boolean up, String genomeKey) {
        this.currSelZoomKey_ = this.calcSelectionKey(up, this.currSelZoomKey_, genomeKey);
    }

    private String calcSelectionKey(boolean up, String baseKey, String genomeKey) {
        if (this.selectionKeys_.isEmpty()) {
            return null;
        }
        Set justNodes = this.justNodeKeys(genomeKey, this.selectionKeys_.keySet());
        TreeSet order = new TreeSet(justNodes);
        if (baseKey == null) {
            baseKey = up ? (String)order.first() : (String)order.last();
            return baseKey;
        }
        Iterator oit = order.iterator();
        String last = null;
        while (oit.hasNext()) {
            String nextO = (String)oit.next();
            if (baseKey.equals(nextO)) {
                if (up) {
                    baseKey = oit.hasNext() ? (String)oit.next() : (String)order.first();
                    return baseKey;
                }
                baseKey = last == null ? (String)order.last() : last;
                return baseKey;
            }
            last = nextO;
        }
        return null;
    }

    private boolean selectionIsMixed(String genomeKey, Set selectionKeys) {
        if (selectionKeys.isEmpty()) {
            return false;
        }
        Genome genome = this.source_.getGenome(genomeKey);
        Iterator ksit = selectionKeys.iterator();
        boolean haveNode = false;
        boolean haveLink = false;
        while (ksit.hasNext()) {
            String objID = (String)ksit.next();
            if (genome.getLinkage(objID) != null) {
                haveLink = true;
            } else if (genome.getNode(objID) != null) {
                haveNode = true;
            }
            if (!haveLink || !haveNode) continue;
            return true;
        }
        return false;
    }

    private Set justNodeKeys(String genomeKey, Set selectionKeys) {
        if (!this.selectionIsMixed(genomeKey, selectionKeys)) {
            return selectionKeys;
        }
        HashSet<String> retval = new HashSet<String>();
        Genome genome = this.source_.getGenome(genomeKey);
        Iterator ksit = selectionKeys.iterator();
        while (ksit.hasNext()) {
            String objID = (String)ksit.next();
            if (genome.getNode(objID) == null) continue;
            retval.add(objID);
        }
        return retval;
    }

    public boolean hasASelection() {
        return !this.selectionKeys_.isEmpty();
    }

    public void setPresentationZoomFactor(double zoom) {
        AffineTransform trans = new AffineTransform();
        trans.scale(zoom, zoom);
        this.frc_ = new FontRenderContext(trans, true, true);
    }

    public FontRenderContext getFontRenderContext() {
        return this.frc_;
    }

    public boolean haveCurrentSelection() {
        return this.currSelZoomKey_ != null;
    }

    public boolean haveMultipleSelections() {
        return this.selectionKeys_.size() > 1;
    }

    public boolean clearSelections(String genomeKey, String layoutKey, UndoSupport support) {
        if (this.selectionKeys_.isEmpty()) {
            return false;
        }
        SelectionChange sc = this.preSelect();
        this.selectionKeys_.clear();
        this.currSelZoomKey_ = null;
        this.postSelect(genomeKey, layoutKey, sc, support, null, false);
        return true;
    }

    public void dropNodeSelections(String genomeKey, String layoutKey, Integer nodeType) {
        if (this.selectionKeys_.isEmpty()) {
            return;
        }
        SelectionChange sc = this.preSelect();
        HashSet keySet = new HashSet(this.selectionKeys_.keySet());
        Genome genome = this.source_.getGenome(genomeKey);
        Iterator git = genome.getAllNodeIterator();
        while (git.hasNext()) {
            String nodeID;
            Node node = (Node)git.next();
            if (nodeType != null && node.getNodeType() != nodeType.intValue() || !keySet.contains(nodeID = node.getID())) continue;
            this.selectionKeys_.remove(nodeID);
        }
        this.currSelZoomKey_ = null;
        this.postSelect(genomeKey, layoutKey, sc, null, null, false);
    }

    public void dropLinkSelections(String genomeKey, String layoutKey, SelectionChangeCmd.Bundle bundle) {
        if (this.selectionKeys_.isEmpty()) {
            return;
        }
        SelectionChange sc = this.preSelect();
        HashSet keySet = new HashSet(this.selectionKeys_.keySet());
        Genome genome = this.source_.getGenome(genomeKey);
        Iterator git = genome.getLinkageIterator();
        while (git.hasNext()) {
            Linkage link = (Linkage)git.next();
            String linkID = link.getID();
            if (!keySet.contains(linkID)) continue;
            this.selectionKeys_.remove(linkID);
        }
        this.currSelZoomKey_ = null;
        this.postSelect(genomeKey, layoutKey, sc, null, bundle, false);
    }

    public Rectangle getRequiredSize(String genomeKey, String layoutKey, boolean doModules, String ovrKey, TaggedSet modSet, Map allKeys) {
        return this.getRequiredSize(genomeKey, layoutKey, false, false, doModules, doModules, ovrKey, modSet, allKeys);
    }

    public Rectangle getRequiredSize(String genomeKey, String layoutKey, boolean doComplete, boolean useBuffer, boolean doModules, boolean doModuleLinks, String ovrKey, TaggedSet modSet, Map allKeys) {
        Rectangle modRect;
        GenomeInstance parentvfg;
        Rectangle backupRetval = new Rectangle(1950, 1450, 100, 100);
        Rectangle retval = null;
        if (genomeKey == null || layoutKey == null) {
            return backupRetval;
        }
        Layout layout = this.layoutSource_.getLayout(layoutKey);
        Genome genome = this.source_.getGenome(genomeKey);
        if (genome == null) {
            return backupRetval;
        }
        String ovrOwnerKey = genomeKey;
        if (genome instanceof GenomeInstance && (parentvfg = ((GenomeInstance)genome).getVfgParentRoot()) != null) {
            genome = parentvfg;
        }
        Layout.OverlayKeySet myKeys = null;
        if (allKeys != null) {
            myKeys = (Layout.OverlayKeySet)allKeys.get(layoutKey);
        }
        if ((retval = layout.getLayoutBounds(genome, this.frc_, doComplete, doModules, doModuleLinks, true, true, ovrOwnerKey, ovrKey, modSet, myKeys)) == null) {
            retval = backupRetval;
        }
        if (doComplete && (modRect = this.getModelDataBounds(genome, layout)) != null) {
            Bounds.tweakBounds(retval, modRect);
        }
        if (useBuffer) {
            Bounds.padBounds(retval, 200, 200);
        }
        return retval;
    }

    public Rectangle getSelectionSize(String genomeKey, String layoutKey) {
        return this.getSelectionSizeGuts(genomeKey, layoutKey, null);
    }

    public Rectangle getCurrentSelectionSize(String genomeKey, String layoutKey) {
        return this.getSelectionSizeGuts(genomeKey, layoutKey, this.currSelZoomKey_);
    }

    private Rectangle getSelectionSizeGuts(String genomeKey, String layoutKey, String oneKey) {
        GenomeInstance parentvfg;
        Rectangle retval = null;
        Layout layout = this.layoutSource_.getLayout(layoutKey);
        Genome genome = this.source_.getGenome(genomeKey);
        if (genome == null) {
            return retval;
        }
        if (genome instanceof GenomeInstance && (parentvfg = ((GenomeInstance)genome).getVfgParentRoot()) != null) {
            genome = parentvfg;
        }
        HashSet<String> selectedNodes = new HashSet<String>();
        HashSet<String> selectedLinks = new HashSet<String>();
        Set keySet = this.selectionKeys_.keySet();
        Iterator git = genome.getAllNodeIterator();
        while (git.hasNext()) {
            Node node = (Node)git.next();
            String nodeID = node.getID();
            if (!keySet.contains(nodeID) || oneKey != null && !oneKey.equals(nodeID)) continue;
            selectedNodes.add(nodeID);
        }
        HashMap<String, Object> subLinks = new HashMap<String, Object>();
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            String linkID = link.getID();
            if (!keySet.contains(linkID) || oneKey != null && !oneKey.equals(linkID)) continue;
            Intersection linkSel = (Intersection)this.selectionKeys_.get(linkID);
            if (linkSel.getSubID() != null) {
                subLinks.put(linkID, linkSel.getSubID());
            }
            selectedLinks.add(linkID);
        }
        retval = layout.getPartialBounds(genome, this.frc_, selectedNodes, true, true, selectedLinks, subLinks, true);
        return retval;
    }

    public List intersectItem(int x, int y, String genomeKey, Layout layout, double pixDiam, boolean nodesFirst, boolean doOverlay, OverlayStateOracle oso) {
        return this.selectionGuts(x, y, genomeKey, layout, nodesFirst, false, doOverlay, pixDiam, oso);
    }

    public List intersectItems(Rectangle rect, String genomeKey, String layoutKey, OverlayStateOracle oso) {
        return this.selectionGuts(rect, genomeKey, layoutKey, true, oso);
    }

    public List intersectNetModules(int x, int y, String genomeKey, Layout layout, String ovrKey, Set modKeys, double pixDiam) {
        Genome genome;
        ArrayList<String> retval = new ArrayList<String>();
        if (ovrKey == null) {
            return retval;
        }
        Database db = Database.getDB();
        Genome useGenome = genome = this.source_.getGenome(genomeKey);
        DynamicInstanceProxy dip = null;
        if (genome instanceof GenomeInstance) {
            if (this.source_ != db) {
                throw new IllegalStateException();
            }
            GenomeInstance gi = (GenomeInstance)genome;
            GenomeInstance rootGI = gi.getVfgParentRoot();
            Genome genome2 = useGenome = rootGI == null ? gi : rootGI;
            if (genome instanceof DynamicGenomeInstance) {
                dip = db.getDynamicProxy(((DynamicGenomeInstance)genome).getProxyID());
            }
        }
        Point2D.Float pt = new Point2D.Float(x, y);
        NetOverlayOwner owner = db.getOverlayOwnerFromGenomeKey(genomeKey);
        Set useGroups = owner.getGroupsForOverlayRendering();
        NetworkOverlay novr = owner.getNetworkOverlay(ovrKey);
        NetOverlayProperties nop = layout.getNetOverlayProperties(ovrKey);
        Iterator mit = novr.getModuleIterator();
        while (mit.hasNext()) {
            NetModuleProperties nmp;
            NetModule mod = (NetModule)mit.next();
            String id = mod.getID();
            if (!modKeys.contains(id) || !(nmp = nop.getNetModuleProperties(id)).getRenderer().intersects(useGenome, dip, useGroups, mod, layout, ovrKey, this.frc_, pt, pixDiam)) continue;
            retval.add(id);
        }
        return retval;
    }

    public Intersection intersectANetModuleElement(int x, int y, String genomeKey, Layout layout, double pixDiam, OverlayStateOracle oso, int type) {
        Genome genome;
        String ovrKey = oso.getCurrentOverlay();
        if (ovrKey == null) {
            return null;
        }
        TaggedSet currentNetMods = oso.getCurrentNetModules();
        HashSet modKeys = currentNetMods == null ? null : currentNetMods.set;
        NetModuleFree.CurrentSettings settings = oso.getCurrentOverlaySettings();
        Database db = Database.getDB();
        Genome useGenome = genome = this.source_.getGenome(genomeKey);
        DynamicInstanceProxy dip = null;
        if (genome instanceof GenomeInstance) {
            if (this.source_ != db) {
                throw new IllegalStateException();
            }
            GenomeInstance gi = (GenomeInstance)genome;
            GenomeInstance rootGI = gi.getVfgParentRoot();
            Genome genome2 = useGenome = rootGI == null ? gi : rootGI;
            if (genome instanceof DynamicGenomeInstance) {
                dip = db.getDynamicProxy(((DynamicGenomeInstance)genome).getProxyID());
            }
        }
        Point2D.Float pt = new Point2D.Float(x, y);
        NetOverlayOwner owner = db.getOverlayOwnerFromGenomeKey(genomeKey);
        Set useGroups = owner.getGroupsForOverlayRendering();
        NetworkOverlay novr = owner.getNetworkOverlay(ovrKey);
        NetOverlayProperties nop = layout.getNetOverlayProperties(ovrKey);
        boolean isOpq = nop.getType() == 1;
        Iterator mit = novr.getModuleIterator();
        while (mit.hasNext()) {
            NetModule mod = (NetModule)mit.next();
            String id = mod.getID();
            NetModuleProperties nmp = nop.getNetModuleProperties(id);
            Intersection retval = null;
            if (!modKeys.contains(id)) continue;
            NetModuleFree render = nmp.getRenderer();
            switch (type) {
                case 0: {
                    retval = render.intersectsInterior(useGenome, dip, useGroups, mod, layout, ovrKey, this.frc_, pt, pixDiam);
                    break;
                }
                case 1: {
                    retval = render.intersectsLinkPad(useGenome, dip, useGroups, mod, layout, ovrKey, this.frc_, pt, pixDiam);
                    break;
                }
                case 2: {
                    retval = render.intersectsBoundary(useGenome, dip, useGroups, mod, layout, ovrKey, this.frc_, pt, pixDiam);
                    break;
                }
                case 3: {
                    boolean labelViz;
                    boolean isRevealed = oso.getRevealedModules().set.contains(id);
                    boolean quickFade = nmp.getNameFadeMode() == 0;
                    boolean nameHiding = isRevealed && isOpq && quickFade;
                    boolean bl = labelViz = !nameHiding && (!quickFade || settings.fastDecayLabelVisible);
                    if (!labelViz) break;
                    retval = render.intersectsName(mod, layout, ovrKey, this.frc_, pt, pixDiam);
                    break;
                }
                case 4: {
                    retval = render.intersectsDefinitionBoundary(useGenome, mod, layout, ovrKey, this.frc_, pt, pixDiam);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            if (retval == null) continue;
            return retval;
        }
        return null;
    }

    public Intersection intersectNetModuleLinks(int x, int y, String genomeKey, Layout layout, OverlayStateOracle oso, double pixDiam) {
        String ovrKey = oso.getCurrentOverlay();
        if (ovrKey == null) {
            return null;
        }
        Genome genome = this.source_.getGenome(genomeKey);
        Point2D.Float pt = new Point2D.Float(x, y);
        NetOverlayProperties nop = layout.getNetOverlayProperties(ovrKey);
        Iterator nlit = nop.getNetModuleLinkagePropertiesKeys();
        NetModuleLinkageFree nmlf = new NetModuleLinkageFree();
        while (nlit.hasNext()) {
            String treeID = (String)nlit.next();
            Intersection retval = nmlf.intersects(genome, oso, treeID, layout, ovrKey, this.frc_, pt, pixDiam);
            if (retval == null) continue;
            return retval;
        }
        return null;
    }

    public void selectFullItem(Intersection intersect, String genomeKey, String layoutKey) {
        SelectionChange sc = this.preSelect();
        String itemID = intersect.getObjectID();
        Intersection exists = (Intersection)this.selectionKeys_.get(itemID);
        if (exists == null) {
            exists = intersect;
        }
        if (exists.getSubID() != null) {
            Intersection fullInt = new Intersection(exists.getObjectID(), null, exists.getDistance(), true);
            this.selectionKeys_.put(itemID, fullInt);
            this.currSelZoomKey_ = null;
        }
        this.postSelect(genomeKey, layoutKey, sc, null, null, false);
    }

    public void unselectFullLink(Intersection intersect, String genomeKey, String layoutKey) {
        String itemID = intersect.getObjectID();
        Intersection exists = (Intersection)this.selectionKeys_.get(itemID);
        if (exists != null) {
            SelectionChange sc = this.preSelect();
            this.selectionKeys_.remove(itemID);
            this.currSelZoomKey_ = null;
            this.postSelect(genomeKey, layoutKey, sc, null, null, false);
        }
    }

    public void appendToSelectNodes(Set nodeIDs, String genomeKey, String layoutKey) {
        SelectionChange sc = this.preSelect();
        Iterator nit = nodeIDs.iterator();
        while (nit.hasNext()) {
            String nid = (String)nit.next();
            if (this.selectionKeys_.get(nid) != null) continue;
            Intersection fullInt = new Intersection(nid, null, 0.0);
            this.selectionKeys_.put(nid, fullInt);
            this.currSelZoomKey_ = null;
        }
        this.postSelect(genomeKey, layoutKey, sc, null, null, false);
    }

    public void selectNodesAndLinks(Set nodeIDs, String genomeKey, String layoutKey, List linkIntersections, boolean clearCurrent) {
        SelectionChange sc = this.preSelect();
        if (clearCurrent) {
            this.selectionKeys_.clear();
        }
        this.currSelZoomKey_ = null;
        Iterator nit = nodeIDs.iterator();
        while (nit.hasNext()) {
            String nid = (String)nit.next();
            Intersection fullInt = new Intersection(nid, null, 0.0);
            this.selectionKeys_.put(nid, fullInt);
        }
        if (linkIntersections != null) {
            int numLI = linkIntersections.size();
            for (int i = 0; i < numLI; ++i) {
                Intersection li = (Intersection)linkIntersections.get(i);
                this.selectionKeys_.put(li.getObjectID(), li);
            }
        }
        this.postSelect(genomeKey, layoutKey, sc, null, null, false);
    }

    public void selectNone(String genomeKey, String layoutKey) {
        SelectionChange sc = this.preSelect();
        this.selectionKeys_.clear();
        this.currSelZoomKey_ = null;
        this.postSelect(genomeKey, layoutKey, sc, null, null, false);
    }

    public String getSingleNodeSelection(String genomeKey) {
        if (this.selectionKeys_.size() != 1) {
            return null;
        }
        String key = (String)this.selectionKeys_.keySet().iterator().next();
        Genome genome = this.source_.getGenome(genomeKey);
        Node node = genome.getNode(key);
        return node == null ? null : key;
    }

    public void selectAll(String genomeKey, String layoutKey) {
        SelectionChange sc = this.preSelect();
        this.selectionKeys_.clear();
        this.currSelZoomKey_ = null;
        Genome genome = this.source_.getGenome(genomeKey);
        Iterator nit = genome.getAllNodeIterator();
        while (nit.hasNext()) {
            Node node = (Node)nit.next();
            Intersection fullInt = new Intersection(node.getID(), null, 0.0);
            this.selectionKeys_.put(fullInt.getObjectID(), fullInt);
        }
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            Intersection fullInt = new Intersection(link.getID(), null, 0.0);
            this.selectionKeys_.put(fullInt.getObjectID(), fullInt);
        }
        this.postSelect(genomeKey, layoutKey, sc, null, null, false);
    }

    public void selectAllNodes(String genomeKey, String layoutKey) {
        SelectionChange sc = this.preSelect();
        this.selectionKeys_.clear();
        this.currSelZoomKey_ = null;
        Genome genome = this.source_.getGenome(genomeKey);
        Iterator nit = genome.getAllNodeIterator();
        while (nit.hasNext()) {
            Node node = (Node)nit.next();
            Intersection fullInt = new Intersection(node.getID(), null, 0.0);
            this.selectionKeys_.put(fullInt.getObjectID(), fullInt);
        }
        this.postSelect(genomeKey, layoutKey, sc, null, null, false);
    }

    private SelectionChange preSelect() {
        SelectionChange sc = null;
        if (this.processSelections_) {
            sc = new SelectionChange();
            sc.oldMap = this.duplicateSelections();
        }
        return sc;
    }

    private boolean postSelect(String genomeKey, String layoutKey, SelectionChange sc, UndoSupport support, SelectionChangeCmd.Bundle bundle, boolean shortCircuit) {
        this.viewerRocCache_.clear();
        this.ghostedViewerRocCache_.clear();
        if (this.processSelections_) {
            sc.newMap = this.duplicateSelections();
            if (shortCircuit && sc.oldMap.isEmpty() && sc.newMap.isEmpty()) {
                return false;
            }
            GooseAppInterface goose = GooseManager.getManager().getGoose();
            if (goose != null && goose.isActivated()) {
                this.gaggleSelectionSupport(goose, genomeKey, layoutKey);
            }
            this.selectionUndoSupport(sc, genomeKey, layoutKey, support, bundle);
        }
        return true;
    }

    public void selectItems(Rectangle rect, String genomeKey, String layoutKey, boolean isShifted, OverlayStateOracle oso) {
        SelectionChange sc = this.preSelect();
        List newSelections = this.selectionGuts(rect, genomeKey, layoutKey, true, oso);
        boolean isFirst = true;
        Iterator nsit = newSelections.iterator();
        while (nsit.hasNext()) {
            Intersection newSelection = (Intersection)nsit.next();
            boolean doShifted = isFirst ? isShifted : true;
            isFirst = false;
            this.selectionDecision(newSelection, genomeKey, layoutKey, doShifted);
        }
        this.postSelect(genomeKey, layoutKey, sc, null, null, false);
    }

    public void selectIntersectionList(List intersections, String genomeKey, String layoutKey) {
        SelectionChange sc = this.preSelect();
        this.selectionKeys_.clear();
        this.currSelZoomKey_ = null;
        Iterator iit = intersections.iterator();
        while (iit.hasNext()) {
            Intersection fullInt = (Intersection)iit.next();
            this.selectionKeys_.put(fullInt.getObjectID(), fullInt);
        }
        this.postSelect(genomeKey, layoutKey, sc, null, null, false);
    }

    public Intersection selectItem(int x, int y, String genomeKey, Layout layout, double pixDiam, boolean isShifted, boolean doOverlay, OverlayStateOracle oso) {
        SelectionChange sc = this.preSelect();
        List augs = this.selectionGuts(x, y, genomeKey, layout, true, true, doOverlay, pixDiam, oso);
        Intersection.AugmentedIntersection aug = new IntersectionChooser(false, genomeKey, layout).selectionRanker(augs);
        Intersection newSelection = aug == null ? null : aug.intersect;
        Intersection retval = this.selectionDecision(newSelection, genomeKey, layout.getName(), isShifted);
        this.postSelect(genomeKey, layout.getName(), sc, null, null, true);
        return retval;
    }

    private Intersection selectionDecision(Intersection newSelection, String genomeKey, String layoutKey, boolean isShifted) {
        boolean isNew;
        String itemID;
        Genome genome = this.source_.getGenome(genomeKey);
        Layout lo = this.layoutSource_.getLayout(layoutKey);
        if (newSelection != null && genome.getNote(itemID = newSelection.getObjectID()) != null) {
            return newSelection;
        }
        boolean emptySet = this.selectionKeys_.isEmpty();
        boolean isNull = newSelection == null;
        boolean matches = false;
        String newID = null;
        boolean sameParent = false;
        boolean intersects = false;
        Intersection exists = null;
        if (!isNull && !emptySet && (exists = (Intersection)this.selectionKeys_.get(newID = newSelection.getObjectID())) != null) {
            sameParent = true;
            if (newSelection.canMerge() && exists.canMerge()) {
                Mergeable exSub = (Mergeable)exists.getSubID();
                Mergeable newSub = (Mergeable)newSelection.getSubID();
                if (exSub == null && newSub == null) {
                    matches = true;
                } else if (exSub == null || newSub == null) {
                    Linkage newLink = genome.getLinkage(newID);
                    if (newLink == null) {
                        throw new IllegalStateException();
                    }
                    LinkageFree lf = new LinkageFree();
                    if (exSub == null) {
                        exSub = (Mergeable)lf.fullIntersection(genome, newLink, lo, this.frc_, false).getSubID();
                        exists = new Intersection(exists, exSub);
                    }
                    if (newSub == null) {
                        newSub = (Mergeable)lf.fullIntersection(genome, newLink, lo, this.frc_, false).getSubID();
                        newSelection = new Intersection(newSelection, newSub);
                    }
                }
                if (!matches) {
                    if (exSub.equals(newSub)) {
                        matches = true;
                    } else if (exSub.intersects(newSub)) {
                        intersects = true;
                    }
                }
            } else {
                matches = true;
            }
        }
        boolean bl = isNew = !isNull && !matches && !intersects;
        if (isShifted) {
            if (isNew) {
                this.addOrMerge(this.selectionKeys_, exists, newSelection, sameParent);
            } else if (matches) {
                this.selectionKeys_.remove(newID);
            } else if (intersects) {
                this.intersect(this.selectionKeys_, exists, newSelection);
            }
        } else if (emptySet) {
            if (isNew) {
                this.selectionKeys_.put(newSelection.getObjectID(), newSelection);
            }
        } else if (isNull) {
            this.selectionKeys_.clear();
        } else if (isNew) {
            this.selectionKeys_.clear();
            this.selectionKeys_.put(newSelection.getObjectID(), newSelection);
        }
        this.currSelZoomKey_ = null;
        return newSelection;
    }

    public void setFloater(Object floater) {
        this.setFloater(floater, null);
    }

    public void setFloater(Object floater, Color floaterColor) {
        this.floaterLayout_ = new Layout("floater", "floater");
        if (floater == null) {
            this.floaterGenome_ = new DBGenome("floater", "floater");
            this.floater_ = null;
            this.floatPoint_ = null;
            this.floaterColor_ = null;
            return;
        }
        if (floater instanceof Gene) {
            this.floaterGenome_ = new DBGenome("floater", "floater");
            this.floaterGenome_.addGene((Gene)floater);
        } else if (floater instanceof Node) {
            this.floaterGenome_ = new DBGenome("floater", "floater");
            this.floaterGenome_.addNode((Node)floater);
        } else if (floater instanceof Linkage) {
            this.floaterGenome_ = new DBGenome("floater", "floater");
            this.floaterGenome_.addLinkage((Linkage)floater);
        } else if (floater instanceof Group) {
            this.floaterGenome_ = new GenomeInstance("floater", "floater", null);
            ((GenomeInstance)this.floaterGenome_).addGroupWithExistingLabel((Group)floater);
        } else if (floater instanceof Note) {
            this.floaterGenome_ = new DBGenome("floater", "floater");
            this.floaterGenome_.addNote((Note)floater);
        }
        this.floaterColor_ = floaterColor;
        this.floater_ = floater;
    }

    public void setTargets(Set targetSet) {
        this.currentTargets_.clear();
        this.currentTargets_.addAll(targetSet);
    }

    public void clearTargets() {
        this.currentTargets_.clear();
    }

    public void setRootOverlays(Set overlaySet) {
        this.currentRootOverlays_.clear();
        this.currentRootOverlays_.addAll(overlaySet);
    }

    public void clearRootOverlays() {
        this.currentRootOverlays_.clear();
    }

    public void setNullRender(String nullID) {
        this.nullRender_ = nullID;
    }

    public void setFloaterPosition(Point2D position) {
        if (this.floater_ == null) {
            return;
        }
        this.forceToGrid(position);
        if (this.floater_ instanceof ArrayList) {
            this.floatPoint_ = position;
        } else if (this.floater_ instanceof Node) {
            this.floaterLayout_.getNodeProperties(((Node)this.floater_).getID()).setLocation(position);
        } else if (!(this.floater_ instanceof Linkage)) {
            if (this.floater_ instanceof Group) {
                this.floaterLayout_.getGroupProperties(((Group)this.floater_).getID()).setLabelLocation(position);
            } else if (this.floater_ instanceof Note) {
                this.floaterLayout_.getNoteProperties(((Note)this.floater_).getID()).setLocation(position);
            }
        }
    }

    public boolean isFloaterActive() {
        return this.floater_ != null;
    }

    public Map getSelections() {
        return this.selectionKeys_;
    }

    public Layout.PropChange[] moveItem(RunningMove mov, Point2D end, String genomeKey, Layout layout, Layout.PadNeedsForLayout padNeeds) {
        Genome genome = this.source_.getGenome(genomeKey);
        double dx = end.getX() - mov.start.getX();
        double dy = end.getY() - mov.start.getY();
        dx = (double)Math.round(dx / 10.0) * 10.0;
        dy = (double)Math.round(dy / 10.0) * 10.0;
        switch (mov.type) {
            case 1: {
                BusProperties lp = layout.getLinkProperties(mov.linkID);
                Layout.PropChange[] pc = new Layout.PropChange[]{layout.moveLinkLabel(lp, dx, dy)};
                return pc;
            }
            case 2: {
                return this.moveModelData(mov.modelKey, genome, layout, dx, dy);
            }
            case 3: {
                int size = mov.toMove.length;
                Layout.PropChange[] redos = new Layout.PropChange[size];
                for (int i = 0; i < size; ++i) {
                    redos[i] = this.moveCore(mov.start, dx, dy, mov.toMove[i], genomeKey, layout, padNeeds);
                }
                return redos;
            }
            case 6: {
                Layout.PropChange[] pcn = layout.moveNetModuleName(genomeKey, mov.modIntersect, mov.ovrId, this.frc_, dx, dy);
                return pcn;
            }
            case 7: {
                Layout.PropChange[] pc2 = new Layout.PropChange[]{layout.moveNetModuleLinks(mov.modIntersect, mov.ovrId, dx, dy)};
                return pc2;
            }
            case 4: {
                NetModuleFree.IntersectionExtraInfo ei = (NetModuleFree.IntersectionExtraInfo)mov.modIntersect.getSubID();
                if (ei.contigInfo != null) {
                    ei.contigInfo.intersectedShape = null;
                }
            }
            case 5: {
                return layout.moveNetModule(genomeKey, mov.modIntersect, mov.ovrId, this.frc_, dx, dy, padNeeds);
            }
        }
        throw new IllegalArgumentException();
    }

    public List getRunningMove(Point2D start, String genomeKey, Layout layout, double pixDiam, OverlayStateOracle oso) {
        List augs;
        String modelKey;
        String ovrKey = oso.getCurrentOverlay();
        TaggedSet modKeys = oso.getCurrentNetModules();
        int intersectionMask = oso.getCurrentOverlaySettings().intersectionMask;
        HashSet netMods = modKeys == null ? null : modKeys.set;
        TaggedSet revKeys = oso.getRevealedModules();
        HashSet revMods = revKeys == null ? null : revKeys.set;
        ArrayList<RunningMove> retval = new ArrayList<RunningMove>();
        int x = (int)start.getX();
        int y = (int)start.getY();
        Genome genome = this.source_.getGenome(genomeKey);
        if (!this.linksAreHidden(layout, oso)) {
            Iterator lit = genome.getLinkageIterator();
            LinkageFree render = new LinkageFree();
            while (lit.hasNext()) {
                BusProperties lp;
                Linkage link = (Linkage)lit.next();
                if (!render.intersectsLabel(genome, (GenomeItem)link, (LinkProperties)(lp = layout.getLinkProperties(link.getID())), this.frc_, start)) continue;
                Intersection dummy = new Intersection(null, null, 0.0);
                if ((dummy = this.filterForModuleMask(genome, layout, start, dummy, ovrKey, netMods, revMods, intersectionMask, pixDiam)) == null) continue;
                RunningMove rm = new RunningMove(1, start);
                rm.linkID = link.getID();
                retval.add(rm);
            }
        }
        if ((modelKey = this.intersectModelData(genome, layout, start, ovrKey, netMods, intersectionMask)) != null) {
            RunningMove rm = new RunningMove(2, start);
            rm.modelKey = modelKey;
            retval.add(rm);
        }
        if (ovrKey != null) {
            Intersection nmLink;
            Intersection defBound;
            RunningMove rm;
            Intersection bound;
            Intersection nameBound = this.intersectANetModuleElement(x, y, genomeKey, layout, pixDiam, oso, 3);
            if (nameBound != null) {
                RunningMove rm2 = new RunningMove(6, start);
                rm2.ovrId = ovrKey;
                rm2.modIntersect = nameBound;
                retval.add(rm2);
            }
            if ((bound = this.intersectANetModuleElement(x, y, genomeKey, layout, pixDiam, oso, 2)) != null) {
                NetModuleFree.IntersectionExtraInfo ei = (NetModuleFree.IntersectionExtraInfo)bound.getSubID();
                if (ei.directShape != null && !ei.nonDirectAlternative) {
                    if (ei.directShape.shapeClass == 3) {
                        rm = new RunningMove();
                        retval.add(rm);
                    } else if (ei.directShape.shapeClass == 2) {
                        String nodeID = ei.directShape.memberID;
                        Intersection nodeInt = new Intersection(nodeID, null, 0.0);
                        RunningMove rm3 = new RunningMove(3, start);
                        rm3.toMove = new Intersection[1];
                        rm3.toMove[0] = nodeInt;
                        retval.add(rm3);
                    }
                }
                rm = new RunningMove(4, start);
                rm.ovrId = ovrKey;
                rm.modIntersect = bound;
                retval.add(rm);
            }
            if (oso.showingModuleComponents() && (defBound = this.intersectANetModuleElement(x, y, genomeKey, layout, pixDiam, oso, 4)) != null) {
                rm = new RunningMove(4, start);
                rm.ovrId = ovrKey;
                rm.modIntersect = defBound;
                retval.add(rm);
            }
            if ((nmLink = this.intersectNetModuleLinks(x, y, genomeKey, layout, oso, pixDiam)) != null) {
                rm = new RunningMove(7, start);
                rm.ovrId = ovrKey;
                rm.modIntersect = nmLink;
                retval.add(rm);
            }
        }
        if ((augs = this.selectionGuts(x, y, genomeKey, layout, true, false, false, pixDiam, oso)) != null) {
            int numAug = augs.size();
            for (int i = 0; i < numAug; ++i) {
                Intersection.AugmentedIntersection aug = (Intersection.AugmentedIntersection)augs.get(i);
                this.buildIntersectionToMove(aug, start, genomeKey, layout, retval);
            }
        }
        return retval.isEmpty() ? null : retval;
    }

    private void buildIntersectionToMove(Intersection.AugmentedIntersection aug, Point2D start, String genomeKey, Layout layout, List moveList) {
        Intersection selection;
        Intersection intersection = selection = aug == null ? null : aug.intersect;
        if (selection == null) {
            return;
        }
        GroupFree grend = new GroupFree();
        if (grend.isGroupSubID(selection)) {
            if (grend.getLabelID(selection) == null) {
                return;
            }
            GroupSettingManager gsm = GroupSettingManager.getGroupMgr();
            int groupViz = gsm.getGroupVisibility(genomeKey, selection.getObjectID());
            if (groupViz != 4) {
                return;
            }
        }
        RunningMove rm = new RunningMove(3, start, aug.type);
        rm.toMove = null;
        int size = 0;
        if (this.selectionKeys_.get(selection.getObjectID()) != null) {
            size = this.selectionKeys_.size();
            rm.toMove = new Intersection[size];
            this.selectionKeys_.values().toArray(rm.toMove);
        } else {
            size = 1;
            rm.toMove = new Intersection[]{selection};
        }
        rm.toMove = this.selectionReduction(rm.toMove, genomeKey, layout);
        moveList.add(rm);
    }

    public int needPadFixupsForMoves(RunningMove[] moves) {
        boolean haveMod = false;
        boolean haveInter = false;
        for (int i = 0; i < moves.length; ++i) {
            int currType = moves[i].type;
            if (currType == 6 || currType == 4 || currType == 5) {
                haveMod = true;
            }
            if (currType != 3) continue;
            haveInter = true;
        }
        if (haveInter) {
            return 2;
        }
        if (haveMod) {
            return 1;
        }
        return 0;
    }

    public int needPadFixupsForMove(RunningMove move) {
        if (move.notPermitted) {
            return 0;
        }
        switch (move.type) {
            case 1: 
            case 2: 
            case 7: {
                return 0;
            }
            case 4: 
            case 5: 
            case 6: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        throw new IllegalArgumentException();
    }

    public RunningMove[] getRunningMovesForNetModule(Intersection bound, Point2D start, String genomeKey, Layout layout, String ovrKey, boolean moveGuts, int moveMode) {
        if (ovrKey == null) {
            throw new IllegalArgumentException();
        }
        String moduleID = bound.getObjectID();
        RunningMove modRM = new RunningMove(5, start);
        modRM.ovrId = ovrKey;
        switch (moveMode) {
            case 0: {
                modRM.modIntersect = bound;
                NetModuleFree.IntersectionExtraInfo ei = (NetModuleFree.IntersectionExtraInfo)bound.getSubID();
                if (ei.contigInfo == null) break;
                ei.contigInfo.intersectedShape = null;
                break;
            }
            case 1: {
                modRM.modIntersect = bound;
                break;
            }
            case 2: {
                modRM.modIntersect = new Intersection(bound, null);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        NetworkOverlay nov = Database.getDB().getOverlayOwnerFromGenomeKey(genomeKey).getNetworkOverlay(ovrKey);
        NetModule nmod = nov.getModule(moduleID);
        NetOverlayProperties nop = layout.getNetOverlayProperties(ovrKey);
        NetModuleProperties nmp = nop.getNetModuleProperties(moduleID);
        RunningMove interRM = null;
        RunningMove nameRM = null;
        if (moveGuts) {
            NetModuleMember nmm;
            Iterator memit;
            Set memIDs;
            NetModuleFree.IntersectionExtraInfo ei;
            NetModuleFree nmf = new NetModuleFree();
            if (moveMode == 0) {
                ei = (NetModuleFree.IntersectionExtraInfo)bound.getSubID();
                if (ei.type == 1 && nmp.getType() == 2 && ei.contigInfo != null) {
                    memIDs = new HashSet();
                    memIDs.addAll(ei.contigInfo.memberShapes.keySet());
                } else {
                    memIDs = nmf.membersInRegion(bound, nmod, layout, ovrKey, moveMode);
                    if (memIDs.isEmpty() && ei.directShape != null && ei.directShape.memberID != null && ei.directShape.shapeClass == 2) {
                        memIDs.add(ei.directShape.memberID);
                    }
                    if (nmf.nameInRegion(bound, nmod, layout, ovrKey, moveMode, this.frc_)) {
                        nameRM = new RunningMove(6, start);
                        nameRM.ovrId = ovrKey;
                        nameRM.modIntersect = new Intersection(moduleID, null, 0.0);
                    }
                }
            } else if (moveMode == 1) {
                if (nmp.getType() == 0) {
                    memIDs = new HashSet();
                    memit = nmod.getMemberIterator();
                    while (memit.hasNext()) {
                        nmm = (NetModuleMember)memit.next();
                        memIDs.add(nmm.getID());
                    }
                    nameRM = new RunningMove(6, start);
                    nameRM.ovrId = ovrKey;
                    nameRM.modIntersect = new Intersection(moduleID, null, 0.0);
                } else {
                    memIDs = nmf.membersInRegion(bound, nmod, layout, ovrKey, moveMode);
                    ei = (NetModuleFree.IntersectionExtraInfo)bound.getSubID();
                    if (memIDs.isEmpty() && ei.directShape != null && ei.directShape.memberID != null && ei.directShape.shapeClass == 2) {
                        memIDs.add(ei.directShape.memberID);
                    }
                    if (nmf.nameInRegion(bound, nmod, layout, ovrKey, moveMode, this.frc_)) {
                        nameRM = new RunningMove(6, start);
                        nameRM.ovrId = ovrKey;
                        nameRM.modIntersect = new Intersection(moduleID, null, 0.0);
                    }
                }
            } else {
                memIDs = new HashSet();
                memit = nmod.getMemberIterator();
                while (memit.hasNext()) {
                    nmm = (NetModuleMember)memit.next();
                    memIDs.add(nmm.getID());
                }
                nameRM = new RunningMove(6, start);
                nameRM.ovrId = ovrKey;
                nameRM.modIntersect = new Intersection(moduleID, null, 0.0);
            }
            ArrayList<Object> interHolder = new ArrayList<Object>();
            Map linkMovesPerSrc = this.getLinkRunningMovesForModule(genomeKey, layout, ovrKey, moduleID, memIDs, bound, moveMode);
            interHolder.addAll(linkMovesPerSrc.values());
            Iterator memit2 = memIDs.iterator();
            while (memit2.hasNext()) {
                String nodeID = (String)memit2.next();
                Intersection nodeInt = new Intersection(nodeID, null, 0.0);
                interHolder.add(nodeInt);
            }
            int numHold = interHolder.size();
            interRM = new RunningMove(3, start);
            interRM.toMove = new Intersection[numHold];
            interHolder.toArray(interRM.toMove);
        }
        int retSize = 1;
        if (interRM != null) {
            ++retSize;
        }
        if (nameRM != null) {
            ++retSize;
        }
        RunningMove[] rets = new RunningMove[retSize];
        rets[0] = modRM;
        int count = 1;
        if (nameRM != null) {
            rets[count++] = nameRM;
        }
        if (moveGuts) {
            rets[count] = interRM;
        }
        return rets;
    }

    public RunningMove[] getRunningMovesForGroup(Point2D start, String genomeKey, Layout layout, String groupID) {
        RunningMove retval = new RunningMove(3, start);
        GenomeInstance gi = (GenomeInstance)this.source_.getGenome(genomeKey);
        Group group = gi.getGroup(groupID);
        GroupFree gf = new GroupFree();
        Rectangle bounds = gf.getBounds(gi, group, layout, this.frc_, null);
        Intersection[] labels = gf.getLabelIntersections(gi, group);
        ArrayList<Intersection> retvalHolder = new ArrayList<Intersection>();
        Iterator anit = gi.getAllNodeIterator();
        while (anit.hasNext()) {
            Node node = (Node)anit.next();
            String nodeID = node.getID();
            Group groupFN = gi.getGroupForNode(nodeID, 1);
            if (!groupFN.getID().equals(groupID)) continue;
            Intersection nodeInt = new Intersection(nodeID, null, 0.0);
            retvalHolder.add(nodeInt);
        }
        HashMap mergeMapToInter = new HashMap();
        HashMap srcMapToLabel = new HashMap();
        this.getLinkRunningMovesForGroup(gi, bounds, start, genomeKey, layout, groupID, mergeMapToInter, srcMapToLabel);
        retvalHolder.addAll(mergeMapToInter.values());
        int numHold = retvalHolder.size();
        retval.toMove = new Intersection[labels.length + numHold];
        retvalHolder.toArray(retval.toMove);
        System.arraycopy(labels, 0, retval.toMove, numHold, labels.length);
        RunningMove[] modMoves = this.moveAttachedModules(gi, layout, groupID, start);
        int numMod = modMoves == null ? 0 : modMoves.length;
        int numLabels = srcMapToLabel.size();
        RunningMove[] rets = new RunningMove[1 + numLabels + numMod];
        int count = 0;
        rets[count++] = retval;
        Iterator smlit = srcMapToLabel.values().iterator();
        while (smlit.hasNext()) {
            RunningMove labelMove = (RunningMove)smlit.next();
            rets[count++] = labelMove;
        }
        if (numMod != 0) {
            System.arraycopy(modMoves, 0, rets, count, numMod);
        }
        return rets;
    }

    private void getLinkRunningMovesForGroup(GenomeInstance gi, Rectangle bounds, Point2D start, String genomeKey, Layout layout, String groupID, Map mergeMapToInter, Map srcMapToLabel) {
        LinkageFree render = new LinkageFree();
        Iterator lit = gi.getLinkageIterator();
        while (lit.hasNext()) {
            BusProperties bp;
            Linkage link = (Linkage)lit.next();
            GenomeInstance.GroupTuple gtup = gi.getRegionTuple(link.getID());
            String srcGrp = gtup.getSourceGroup();
            String trgGrp = gtup.getTargetGroup();
            if (!srcGrp.equals(groupID) && !trgGrp.equals(groupID)) continue;
            String srcID = link.getSource();
            Intersection mergeInter = (Intersection)mergeMapToInter.get(srcID);
            Intersection inter = render.pathIntersection(gi, link, layout, this.frc_);
            if (!srcGrp.equals(groupID) || !trgGrp.equals(groupID)) {
                Intersection boundsInter = render.intersects((Genome)gi, (GenomeItem)link, layout, this.frc_, bounds, false, null);
                if (boundsInter != null) {
                    Intersection normInter = new Intersection(inter.getObjectID(), boundsInter.getSubID(), boundsInter.getDistance(), boundsInter.canMerge());
                    inter = render.intersection(inter, normInter);
                } else {
                    inter = null;
                }
            }
            if (mergeInter != null && inter != null) {
                Intersection normInter = new Intersection(mergeInter.getObjectID(), inter.getSubID(), inter.getDistance(), inter.canMerge());
                inter = render.mergeIntersect(mergeInter, normInter);
            }
            if (inter == null) continue;
            mergeMapToInter.put(srcID, inter);
            RunningMove labelMove = (RunningMove)srcMapToLabel.get(srcID);
            if (labelMove != null || !render.intersectsLabel((Genome)gi, (GenomeItem)link, (LinkProperties)(bp = layout.getLinkProperties(link.getID())), this.frc_, bounds)) continue;
            labelMove = new RunningMove(1, start);
            labelMove.linkID = link.getID();
            srcMapToLabel.put(srcID, labelMove);
        }
    }

    private Map getLinkRunningMovesForModule(String genomeKey, Layout layout, String ovrKey, String modID, Set memIDs, Intersection intersect, int mode) {
        Genome genome = this.source_.getGenome(genomeKey);
        HashMap<String, Intersection> mergeMapToInter = new HashMap<String, Intersection>();
        HashMap<String, Rectangle> outerRectMap = new HashMap<String, Rectangle>();
        HashMap<String, List> shapeMap = new HashMap<String, List>();
        if (mode == 2) {
            HashSet<String> modSet = new HashSet<String>();
            modSet.add(modID);
            this.buildShapeMapForNetModules(genome, layout, ovrKey, modSet, this.frc_, outerRectMap, shapeMap);
        } else {
            Rectangle outerBounds = new Rectangle();
            List interRects = new NetModuleFree().shapesFromIntersection(intersect, modID, layout, ovrKey, mode, outerBounds);
            outerRectMap.put(modID, outerBounds);
            shapeMap.put(modID, interRects);
        }
        ArrayList<Intersection> partialMatches = new ArrayList<Intersection>();
        ArrayList<Intersection> fullMatches = new ArrayList<Intersection>();
        LinkageFree render = new LinkageFree();
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            String srcID = link.getSource();
            String trgID = link.getTarget();
            boolean srcInMod = memIDs.contains(srcID);
            boolean trgInMod = memIDs.contains(trgID);
            if (!srcInMod && !trgInMod) continue;
            Intersection inter = render.pathIntersection(genome, link, layout, this.frc_);
            if (!srcInMod || !trgInMod) {
                partialMatches.add(inter);
                continue;
            }
            fullMatches.add(inter);
        }
        List culled = this.intersectCandidatesWithShapes(genome, layout, partialMatches, this.frc_, outerRectMap, shapeMap);
        culled.addAll(fullMatches);
        int numCull = culled.size();
        for (int i = 0; i < numCull; ++i) {
            Intersection fullInter = (Intersection)culled.get(i);
            String linkID = fullInter.getObjectID();
            Linkage link = genome.getLinkage(linkID);
            String srcID = link.getSource();
            Intersection mergeInter = (Intersection)mergeMapToInter.get(srcID);
            if (mergeInter != null) {
                Intersection normInter = new Intersection(mergeInter.getObjectID(), fullInter.getSubID(), fullInter.getDistance(), fullInter.canMerge());
                mergeInter = render.mergeIntersect(mergeInter, normInter);
                mergeMapToInter.put(srcID, mergeInter);
                continue;
            }
            mergeMapToInter.put(srcID, fullInter);
        }
        return mergeMapToInter;
    }

    private RunningMove[] moveAttachedModules(GenomeInstance gi, Layout layout, String groupID, Point2D start) {
        ArrayList<RunningMove[]> retlist = new ArrayList<RunningMove[]>();
        String genomeKey = gi.getID();
        Map moduleMap = gi.findModulesOwnedByGroup(groupID);
        int numMoves = 0;
        if (!moduleMap.isEmpty()) {
            Iterator mmkit = moduleMap.keySet().iterator();
            while (mmkit.hasNext()) {
                String nokey = (String)mmkit.next();
                NetworkOverlay novr = gi.getNetworkOverlay(nokey);
                Set modSet = (Set)moduleMap.get(nokey);
                Iterator msit = modSet.iterator();
                while (msit.hasNext()) {
                    String modID = (String)msit.next();
                    NetModule module = novr.getModule(modID);
                    Intersection inter = new Intersection(modID, null, 0.0);
                    RunningMove[] netModMoves = this.getRunningMovesForNetModule(inter, start, genomeKey, layout, nokey, false, 2);
                    retlist.add(netModMoves);
                    numMoves += netModMoves.length;
                    RunningMove[] nameRMs = new RunningMove[]{new RunningMove(6, start)};
                    nameRMs[0].ovrId = nokey;
                    nameRMs[0].modIntersect = new Intersection(modID, null, 0.0);
                    retlist.add(nameRMs);
                    ++numMoves;
                }
            }
        }
        RunningMove[] rets = new RunningMove[numMoves];
        int count = 0;
        int numRL = retlist.size();
        for (int i = 0; i < numRL; ++i) {
            RunningMove[] netModMoves = (RunningMove[])retlist.get(i);
            for (int j = 0; j < netModMoves.length; ++j) {
                rets[count++] = netModMoves[j];
            }
        }
        return rets;
    }

    public Layout.PropChange[] nudgeSelectedItems(double dx, double dy, String genomeKey, Layout layout, Layout.PadNeedsForLayout padNeeds) {
        int size = this.selectionKeys_.size();
        if (size == 0) {
            return null;
        }
        Intersection[] toMove = this.selectionKeys_.values().toArray(new Intersection[size]);
        toMove = this.selectionReduction(toMove, genomeKey, layout);
        size = toMove.length;
        Layout.PropChange[] redos = new Layout.PropChange[size];
        for (int i = 0; i < size; ++i) {
            redos[i] = this.moveCore(null, dx, dy, toMove[i], genomeKey, layout, padNeeds);
        }
        return redos;
    }

    private Intersection[] selectionReduction(Intersection[] inters, String genomeKey, Layout lo) {
        Genome genome = this.source_.getGenome(genomeKey);
        int size = inters.length;
        ArrayList<Intersection> reducedList = new ArrayList<Intersection>();
        HashSet<String> seenProps = new HashSet<String>();
        for (int i = 0; i < size; ++i) {
            String lpid;
            String interID = inters[i].getObjectID();
            Linkage link = genome.getLinkage(interID);
            if (link == null) {
                reducedList.add(inters[i]);
                continue;
            }
            BusProperties lp = lo.getLinkProperties(interID);
            if (lp == null || seenProps.contains(lpid = lp.getSourceTag())) continue;
            reducedList.add(inters[i]);
            seenProps.add(lpid);
        }
        return reducedList.toArray(new Intersection[reducedList.size()]);
    }

    public Intersection selectGroupFromParent(int x, int y, String genomeKey, String layoutKey, double pixDiam) {
        Layout layout = this.layoutSource_.getLayout(layoutKey);
        Genome genome = this.source_.getGenome(genomeKey);
        if (!(genome instanceof GenomeInstance)) {
            throw new IllegalArgumentException();
        }
        GenomeInstance gi = (GenomeInstance)genome;
        GenomeInstance parent = gi.getVfgParent();
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        Point2D.Float pt = new Point2D.Float(x, y);
        GenomeInstance rootvfg = gi.getVfgParentRoot();
        Intersection groupCheck = this.intersectGroups(null, rootvfg, pt, pixDiam, layout, false);
        return groupCheck;
    }

    public Intersection selectGroupForRootInstance(int x, int y, String genomeKey, String layoutKey, double pixDiam) {
        Layout layout = this.layoutSource_.getLayout(layoutKey);
        Genome genome = this.source_.getGenome(genomeKey);
        if (!(genome instanceof GenomeInstance)) {
            throw new IllegalArgumentException();
        }
        GenomeInstance gi = (GenomeInstance)genome;
        GenomeInstance parent = gi.getVfgParent();
        if (parent != null) {
            throw new IllegalArgumentException();
        }
        Point2D.Float pt = new Point2D.Float(x, y);
        Intersection groupCheck = this.intersectGroups(null, gi, pt, pixDiam, layout, false);
        return groupCheck;
    }

    public Intersection selectGroup(int x, int y, String genomeKey, String layoutKey, double pixDiam) {
        Layout layout = this.layoutSource_.getLayout(layoutKey);
        Genome genome = this.source_.getGenome(genomeKey);
        if (!(genome instanceof GenomeInstance)) {
            throw new IllegalArgumentException();
        }
        GenomeInstance gi = (GenomeInstance)genome;
        GenomeInstance rootvfg = gi.getVfgParentRoot();
        Point2D.Float pt = new Point2D.Float(x, y);
        Intersection groupCheck = this.intersectGroups(rootvfg, gi, pt, pixDiam, layout, false);
        return groupCheck;
    }

    public List selectLinkFromRootParent(int x, int y, String genomeKey, String layoutKey, Set okLinks, double pixDiam) {
        Layout layout = this.layoutSource_.getLayout(layoutKey);
        Genome genome = this.source_.getGenome(genomeKey);
        if (!(genome instanceof GenomeInstance)) {
            throw new IllegalArgumentException();
        }
        GenomeInstance gi = (GenomeInstance)genome;
        GenomeInstance rootvfg = gi.getVfgParentRoot();
        if (rootvfg == null) {
            throw new IllegalArgumentException();
        }
        Point2D.Float pt = new Point2D.Float(x, y);
        Intersection groupCheck = this.intersectGroups(rootvfg, gi, pt, pixDiam, layout, true);
        if (groupCheck != null) {
            return null;
        }
        ArrayList<Intersection> retval = new ArrayList<Intersection>();
        Iterator lit = okLinks.iterator();
        while (lit.hasNext()) {
            String linkID = (String)lit.next();
            Linkage link = rootvfg.getLinkage(linkID);
            LinkageFree render = (LinkageFree)layout.getLinkProperties(linkID).getRenderer();
            Intersection inter = render.intersects((Genome)rootvfg, (GenomeItem)link, layout, this.frc_, pt, pixDiam, null);
            if (inter == null) continue;
            retval.add(inter);
        }
        return retval.isEmpty() ? null : retval;
    }

    public List selectFromParent(int x, int y, String genomeKey, String layoutKey, double pixDiam) {
        Layout layout = this.layoutSource_.getLayout(layoutKey);
        Genome genome = this.source_.getGenome(genomeKey);
        if (!(genome instanceof GenomeInstance)) {
            throw new IllegalArgumentException();
        }
        GenomeInstance gi = (GenomeInstance)genome;
        GenomeInstance parent = gi.getVfgParent();
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        Point2D.Float pt = new Point2D.Float(x, y);
        GenomeInstance rootvfg = gi.getVfgParentRoot();
        Intersection groupCheck = this.intersectGroups(rootvfg, gi, pt, pixDiam, layout, true);
        if (groupCheck != null) {
            return null;
        }
        ArrayList<Intersection> retval = new ArrayList<Intersection>();
        Iterator lit = parent.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            LinkageFree render = (LinkageFree)layout.getLinkProperties(link.getID()).getRenderer();
            Intersection inter = render.intersects((Genome)parent, (GenomeItem)link, layout, this.frc_, pt, pixDiam, null);
            if (inter == null) continue;
            retval.add(inter);
        }
        Iterator git = parent.getGeneIterator();
        while (git.hasNext()) {
            Gene gene = (Gene)git.next();
            INodeRenderer render = layout.getNodeProperties(gene.getID()).getRenderer();
            Intersection inter = render.intersects((Genome)parent, (GenomeItem)gene, layout, this.frc_, pt, pixDiam, null);
            if (inter == null) continue;
            retval.add(inter);
        }
        Iterator nit = parent.getNodeIterator();
        while (nit.hasNext()) {
            Node node = (Node)nit.next();
            INodeRenderer render = layout.getNodeProperties(node.getID()).getRenderer();
            Intersection inter = render.intersects((Genome)parent, (GenomeItem)node, layout, this.frc_, pt, pixDiam, null);
            if (inter == null) continue;
            retval.add(inter);
        }
        return retval.isEmpty() ? null : retval;
    }

    void forceToGrid(Point2D pt) {
        pt.setLocation((double)Math.round(pt.getX() / 10.0) * 10.0, (double)Math.round(pt.getY() / 10.0) * 10.0);
    }

    public void changeUndo(SelectionChange undo) {
        GooseAppInterface goose;
        if (undo.oldMap != null) {
            this.selectionKeys_ = undo.oldMap;
        }
        if ((goose = GooseManager.getManager().getGoose()) != null && goose.isActivated()) {
            this.gaggleSelectionSupport(goose, undo.genomeKey, undo.layoutKey);
        }
    }

    public void changeRedo(SelectionChange undo) {
        GooseAppInterface goose;
        if (undo.newMap != null) {
            this.selectionKeys_ = undo.newMap;
        }
        if ((goose = GooseManager.getManager().getGoose()) != null && goose.isActivated()) {
            this.gaggleSelectionSupport(goose, undo.genomeKey, undo.layoutKey);
        }
    }

    public Set nonBlackHoles(String genomeKey, Layout layout, OverlayStateOracle oso) {
        HashSet currentRevealed;
        String currentOverlay = oso.getCurrentOverlay();
        TaggedSet modKeys = oso.getCurrentNetModules();
        int intersectMask = oso.getCurrentOverlaySettings().intersectionMask;
        HashSet currentNetModSet = modKeys == null ? null : modKeys.set;
        TaggedSet revKeys = oso.getRevealedModules();
        HashSet hashSet = currentRevealed = revKeys == null ? null : revKeys.set;
        if (currentOverlay == null) {
            return null;
        }
        if (intersectMask == 0) {
            return null;
        }
        NetOverlayProperties nop = layout.getNetOverlayProperties(currentOverlay);
        if (nop.getType() != 1) {
            return null;
        }
        HashSet useMods = currentNetModSet;
        if (intersectMask == 2) {
            HashSet normalized = new HashSet(currentRevealed);
            normalized.retainAll(currentNetModSet);
            if (normalized.isEmpty()) {
                return new HashSet();
            }
            useMods = normalized;
        } else if (intersectMask != 1) {
            throw new IllegalArgumentException();
        }
        return new HashSet(useMods);
    }

    private void selectionUndoSupport(SelectionChange sc, String genomeKey, String layoutKey, UndoSupport support, SelectionChangeCmd.Bundle bundle) {
        sc.gp = this;
        sc.genomeKey = genomeKey;
        sc.layoutKey = layoutKey;
        boolean localUndo = false;
        if (support == null && bundle == null) {
            localUndo = true;
            support = new UndoSupport(this.undo_, "undo.selection");
        }
        if (support != null) {
            support.addEdit(new SelectionChangeCmd(sc));
            support.addEvent(new SelectionChangeEvent(genomeKey, layoutKey, 3));
        } else {
            bundle.cmd = new SelectionChangeCmd(sc);
            bundle.event = new SelectionChangeEvent(genomeKey, layoutKey, 3);
        }
        if (localUndo) {
            support.finish();
        }
    }

    private Layout.PropChange moveCore(Point2D start, double dx, double dy, Intersection selection, String genomeKey, Layout layout, Layout.PadNeedsForLayout padNeeds) {
        Node node;
        Genome genome = this.source_.getGenome(genomeKey);
        NoteProperties ntp = layout.getNoteProperties(selection.getObjectID());
        if (ntp != null) {
            return layout.moveNote(selection.getObjectID(), genome, dx, dy);
        }
        if (genome instanceof GenomeInstance && ((GenomeInstance)genome).getGroup(selection.getObjectID()) != null) {
            GroupProperties grp;
            GroupFree grend;
            String groupID;
            GenomeInstance parentRoot = ((GenomeInstance)genome).getVfgParentRoot();
            if (parentRoot != null) {
                genome = parentRoot;
            }
            if ((groupID = (grend = new GroupFree()).getLabelID(selection)) != null && (grp = layout.getGroupProperties(groupID = Group.getBaseID(groupID))) != null) {
                return layout.moveGroup(groupID, genome, dx, dy);
            }
        }
        if ((node = genome.getNode(selection.getObjectID())) != null) {
            return layout.moveNode(selection.getObjectID(), genome, dx, dy, padNeeds);
        }
        Linkage link = genome.getLinkage(selection.getObjectID());
        if (link != null) {
            BusProperties lp = layout.getLinkProperties(link.getID());
            LinkageFree rend = (LinkageFree)lp.getRenderer();
            LinkSegmentID[] segID = selection.segmentIDsFromIntersect();
            if (segID == null) {
                selection = rend.fullIntersection(genome, link, layout, this.frc_, true);
                segID = selection.segmentIDsFromIntersect();
            }
            return layout.moveBusLink(segID, dx, dy, start, lp);
        }
        return null;
    }

    private Intersection isSelected(HashMap keys, GenomeItem item) {
        String id = item.getID();
        return (Intersection)keys.get(id);
    }

    private Intersection linkIsSelected(Set justKeys, HashMap keys, Layout layout, GenomeItem link) {
        if (keys.isEmpty()) {
            return null;
        }
        String id = link.getID();
        Set shared = layout.getSharedItems(id);
        HashSet intersection = new HashSet(justKeys);
        intersection.retainAll(shared);
        if (intersection.isEmpty()) {
            return null;
        }
        return (Intersection)keys.get(intersection.iterator().next());
    }

    private RenderObjectCache presentationGuts(Graphics2D g2, Genome genome, Layout layout, boolean isGhosted, boolean showBubbles, boolean doReset, boolean hideLinks, Rectangle2D clipRect, double pixDiam) {
        Intersection selected;
        Object misc = null;
        if (doReset) {
            // empty if block
        }
        Iterator nit = genome.getAllNodeIterator();
        while (nit.hasNext()) {
            Node node = (Node)nit.next();
            if (node.getID().equals(this.nullRender_)) continue;
            Intersection selected2 = this.isSelected(this.selectionKeys_, node);
            INodeRenderer render = layout.getNodeProperties(node.getID()).getRenderer();
            boolean localGhost = isGhosted;
            if (!isGhosted && !this.currentTargets_.isEmpty()) {
                localGhost = !this.currentTargets_.contains(node.getID());
            }
            render.render(g2, null, genome, node, layout, selected2, localGhost, showBubbles, clipRect, pixDiam, misc);
        }
        DisplayOptionsManager dopmgr = DisplayOptionsManager.getMgr();
        DisplayOptions ddopt = dopmgr.getDisplayOptions();
        LinkageFree.AugmentedDisplayOptions adopt = new LinkageFree.AugmentedDisplayOptions(ddopt, null);
        HashSet skipDrops = new HashSet();
        LinkageFree.AugmentedDisplayOptions adoptf = new LinkageFree.AugmentedDisplayOptions(ddopt, skipDrops);
        GenomeInstance rootParent = null;
        if (genome instanceof GenomeInstance) {
            rootParent = ((GenomeInstance)genome).getVfgParentRoot();
        }
        HashSet<BusProperties> renderedBuses = new HashSet<BusProperties>();
        Iterator lit = genome.getLinkageIterator();
        HashMap cache = isGhosted ? this.ghostedViewerRocCache_ : this.viewerRocCache_;
        RenderObjectCache roc = (RenderObjectCache)cache.get(genome.getID());
        if (!this.viewerOnly_ || roc == null) {
            roc = new RenderObjectCache();
            if (this.viewerOnly_) {
                cache.put(genome.getID(), roc);
            }
            if (!hideLinks) {
                LinkageFree render;
                Set justKeys = this.selectionKeys_.keySet();
                while (lit.hasNext()) {
                    Linkage link = (Linkage)lit.next();
                    if (link.getID().equals(this.nullRender_)) continue;
                    BusProperties lp = layout.getLinkProperties(link.getID());
                    if (lp == null) {
                        System.err.println("No linkProperties for " + link.getID());
                        throw new IllegalStateException();
                    }
                    if (renderedBuses.contains(lp)) continue;
                    renderedBuses.add(lp);
                    selected = this.linkIsSelected(justKeys, this.selectionKeys_, layout, link);
                    render = (LinkageFree)lp.getRenderer();
                    boolean localGhost = isGhosted;
                    if (!isGhosted && !this.currentTargets_.isEmpty()) {
                        boolean bl = localGhost = !this.currentTargets_.contains(link.getID());
                    }
                    if (!this.currentRootOverlays_.isEmpty() && rootParent != null && this.currentRootOverlays_.contains(link.getID())) {
                        skipDrops.clear();
                        skipDrops.addAll(this.currentRootOverlays_);
                        Set actuallyPresent = genome.getOutboundLinks(link.getSource());
                        skipDrops.removeAll(actuallyPresent);
                        link = rootParent.getLinkage(link.getID());
                        render.render(g2, roc, rootParent, link, layout, selected, localGhost, showBubbles, clipRect, pixDiam, adoptf);
                        continue;
                    }
                    render.render(g2, roc, genome, link, layout, selected, localGhost, showBubbles, clipRect, pixDiam, adopt);
                }
                if (!this.currentRootOverlays_.isEmpty() && rootParent != null) {
                    Iterator croit = this.currentRootOverlays_.iterator();
                    skipDrops.clear();
                    skipDrops.addAll(this.currentRootOverlays_);
                    while (croit.hasNext()) {
                        String linkID = (String)croit.next();
                        BusProperties lp = layout.getLinkProperties(linkID);
                        if (renderedBuses.contains(lp)) continue;
                        renderedBuses.add(lp);
                        render = (LinkageFree)lp.getRenderer();
                        Linkage link = rootParent.getLinkage(linkID);
                        render.render(g2, roc, rootParent, link, layout, null, false, showBubbles, clipRect, pixDiam, adoptf);
                    }
                }
            }
        }
        roc.render(g2);
        if (!isGhosted) {
            Iterator noit = genome.getNoteIterator();
            while (noit.hasNext()) {
                Note note = (Note)noit.next();
                IRenderer render = layout.getNoteProperties(note.getID()).getRenderer();
                selected = this.isSelected(this.selectionKeys_, note);
                render.render(g2, null, genome, note, layout, selected, isGhosted, showBubbles, clipRect, pixDiam, misc);
            }
        }
        return roc;
    }

    private void renderModelData(Graphics2D g2, Genome genome, Layout layout, boolean isGhosted) {
        ModelData md = Database.getDB().getModelData();
        String longName = genome.getLongName();
        if (!(md == null && longName == null || isGhosted)) {
            Point2D loc;
            int keySize;
            Point2D loc2;
            String attrib;
            Point2D loc3;
            String date;
            FontRenderContext frc = g2.getFontRenderContext();
            Font mFont = FontManager.getMgr().getFont(9);
            Font bFont = FontManager.getMgr().getFont(10);
            g2.setFont(mFont);
            g2.setPaint(Color.black);
            String string = date = md == null ? null : md.getDate();
            if (date != null && !date.trim().equals("") && (loc3 = layout.getDataLocation("date")) != null) {
                Rectangle2D bounds = mFont.getStringBounds(date, frc);
                double width = bounds.getWidth();
                double height = bounds.getHeight();
                g2.drawString(date, (float)loc3.getX() - (float)width / 2.0f, (float)loc3.getY() + (float)height / 2.0f);
            }
            String string2 = attrib = md == null ? null : md.getAttribution();
            if (attrib != null && !attrib.trim().equals("") && (loc2 = layout.getDataLocation("attrib")) != null) {
                Rectangle2D bounds = mFont.getStringBounds(attrib, frc);
                double width = bounds.getWidth();
                double height = bounds.getHeight();
                g2.drawString(attrib, (float)loc2.getX() - (float)width / 2.0f, (float)loc2.getY() + (float)height / 2.0f);
            }
            int n = keySize = md == null ? 0 : md.getKeySize();
            if (keySize > 0) {
                DataLocator dl = new DataLocator(null);
                Point2D loc4 = layout.getDataLocation("key");
                if (loc4 != null) {
                    ArrayList<String> keyList = new ArrayList<String>();
                    for (int i = 0; i < keySize; ++i) {
                        keyList.add(md.getKey(i));
                    }
                    Dimension dim = dl.calcKeyBounds(keyList, layout, mFont, this.frc_);
                    double width = dim.getWidth();
                    double height = dim.getHeight();
                    double keyX = loc4.getX() - width / 2.0;
                    double currY = loc4.getY() - height / 2.0;
                    for (int i = 0; i < keySize; ++i) {
                        String entry = md.getKey(i);
                        LineMetrics lm = mFont.getLineMetrics(entry, frc);
                        g2.drawString(entry, (float)keyX, (float)(currY += (double)lm.getHeight()));
                    }
                }
            }
            if (longName != null && !longName.trim().equals("") && (loc = layout.getDataLocation("title")) != null) {
                Rectangle2D bounds = mFont.getStringBounds(longName, frc);
                double width = bounds.getWidth();
                double height = bounds.getHeight();
                g2.setFont(bFont);
                g2.drawString(longName, (float)loc.getX() - (float)width / 2.0f, (float)loc.getY() + (float)height / 2.0f);
            }
        }
    }

    public boolean intersectLinkageLabels(Genome genome, Layout layout, Point2D pt, OverlayStateOracle oso, double pixDiam) {
        String currentOverlay = oso.getCurrentOverlay();
        TaggedSet modKeys = oso.getCurrentNetModules();
        int intersectMask = oso.getCurrentOverlaySettings().intersectionMask;
        HashSet currentNetModSet = modKeys == null ? null : modKeys.set;
        TaggedSet revKeys = oso.getRevealedModules();
        HashSet revMods = revKeys == null ? null : revKeys.set;
        Iterator lit = genome.getLinkageIterator();
        LinkageFree render = new LinkageFree();
        while (lit.hasNext()) {
            BusProperties lp;
            Linkage link = (Linkage)lit.next();
            if (!render.intersectsLabel(genome, (GenomeItem)link, (LinkProperties)(lp = layout.getLinkProperties(link.getID())), this.frc_, pt)) continue;
            Intersection dummy = new Intersection(null, null, 0.0);
            if ((dummy = this.filterForModuleMask(genome, layout, pt, dummy, currentOverlay, currentNetModSet, revMods, intersectMask, pixDiam)) == null) continue;
            return true;
        }
        return false;
    }

    private Intersection filterForModuleMask(Genome genome, Layout layout, Point2D pt, Intersection inter, String currentOverlay, Set currentNetModSet, Set currentRevealed, int intersectMask, double pixDiam) {
        if (inter != null) {
            int x = (int)pt.getX();
            int y = (int)pt.getY();
            int maskNeed = this.needMaskingReduction(layout, currentOverlay, intersectMask);
            switch (maskNeed) {
                case 0: {
                    return inter;
                }
                case 2: {
                    HashSet normalized = new HashSet(currentRevealed);
                    normalized.retainAll(currentNetModSet);
                    if (normalized.isEmpty()) {
                        return null;
                    }
                    List nmintAM = this.intersectNetModules(x, y, genome.getID(), layout, currentOverlay, normalized, pixDiam);
                    if (nmintAM.size() <= 0) break;
                    return inter;
                }
                case 1: {
                    List nmint = this.intersectNetModules(x, y, genome.getID(), layout, currentOverlay, currentNetModSet, pixDiam);
                    if (nmint.size() <= 0) break;
                    return inter;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return null;
    }

    private List filterLinksForModuleMask(Genome genome, Layout layout, List rawMatches, FontRenderContext frc, String currentOverlay, Set currentNetModSet, Set currentRevealed, int intersectMask) {
        HashSet useForIntersect = currentNetModSet;
        int maskNeed = this.needMaskingReduction(layout, currentOverlay, intersectMask);
        switch (maskNeed) {
            case 0: {
                return rawMatches;
            }
            case 2: {
                HashSet normalized = new HashSet(currentRevealed);
                normalized.retainAll(currentNetModSet);
                if (normalized.isEmpty()) {
                    return new ArrayList();
                }
                useForIntersect = normalized;
            }
            case 1: {
                HashMap outerRectMap = new HashMap();
                HashMap shapeMap = new HashMap();
                this.buildShapeMapForNetModules(genome, layout, currentOverlay, useForIntersect, frc, outerRectMap, shapeMap);
                return this.intersectCandidatesWithShapes(genome, layout, rawMatches, frc, outerRectMap, shapeMap);
            }
        }
        throw new IllegalStateException();
    }

    private void buildShapeMapForNetModules(Genome genome, Layout layout, String currentOverlay, Set useModsForIntersect, FontRenderContext frc, Map outerRectMap, Map shapeMap) {
        Database db = Database.getDB();
        NetOverlayOwner owner = db.getOverlayOwnerFromGenomeKey(genome.getID());
        Set useGroups = owner.getGroupsForOverlayRendering();
        NetworkOverlay novr = owner.getNetworkOverlay(currentOverlay);
        NetOverlayProperties nop = layout.getNetOverlayProperties(currentOverlay);
        Genome useGenome = genome;
        if (genome instanceof GenomeInstance) {
            if (this.source_ != db) {
                throw new IllegalStateException();
            }
            GenomeInstance gi = (GenomeInstance)genome;
            GenomeInstance rootGI = gi.getVfgParentRoot();
            useGenome = rootGI == null ? gi : rootGI;
        }
        Iterator mit = novr.getModuleIterator();
        while (mit.hasNext()) {
            NetModule mod = (NetModule)mit.next();
            String id = mod.getID();
            if (!useModsForIntersect.contains(id)) continue;
            Rectangle2D.Double outerRect = new Rectangle2D.Double();
            NetModuleProperties nmp = nop.getNetModuleProperties(id);
            List modShapes = nmp.getRenderer().getModuleShapes(genome, useGenome, useGroups, layout, currentOverlay, id, frc, outerRect);
            shapeMap.put(id, modShapes);
            outerRectMap.put(id, outerRect);
        }
    }

    public List intersectCandidatesWithShapes(Genome genome, Layout layout, List rawMatches, FontRenderContext frc, Map outerRectMap, Map shapeMap) {
        ArrayList<Intersection> retval = new ArrayList<Intersection>();
        int numRaw = rawMatches.size();
        for (int i = 0; i < numRaw; ++i) {
            Intersection inter = (Intersection)rawMatches.get(i);
            String linkID = inter.getObjectID();
            BusProperties bp = layout.getLinkProperties(linkID);
            LinkageFree render = (LinkageFree)bp.getRenderer();
            LinkSegmentID[] lsids = inter.segmentIDsFromIntersect();
            HashSet<LinkSegmentID> rawLSIDs = new HashSet<LinkSegmentID>(Arrays.asList(lsids));
            Iterator skit = shapeMap.keySet().iterator();
            while (skit.hasNext()) {
                String modKey = (String)skit.next();
                Rectangle2D outerRect = (Rectangle2D)outerRectMap.get(modKey);
                List firstCut = bp.intersectBusSegmentsWithRect(genome, null, layout, outerRect, true, frc);
                HashSet intersect = new HashSet(firstCut);
                intersect.retainAll(rawLSIDs);
                if (intersect.isEmpty()) continue;
                List modShapes = (List)shapeMap.get(modKey);
                int numShape = modShapes.size();
                HashSet allSegIDs = new HashSet();
                for (int j = 0; j < numShape; ++j) {
                    Shape nextShape = (Shape)modShapes.get(j);
                    List perShape = bp.intersectBusSegmentsWithShape(genome, null, layout, nextShape, true, frc);
                    allSegIDs.addAll(perShape);
                }
                HashSet intersectFinal = new HashSet(allSegIDs);
                intersectFinal.retainAll(rawLSIDs);
                if (intersectFinal.isEmpty()) continue;
                Intersection maskedInter = render.intersectionForSegmentIDs(linkID, intersectFinal);
                retval.add(maskedInter);
            }
        }
        return retval;
    }

    public List intersectNotes(Genome genome, Layout layout, Point2D pt, boolean interactiveOnly, OverlayStateOracle oso, double pixDiam) {
        String currentOverlay = oso.getCurrentOverlay();
        TaggedSet modKeys = oso.getCurrentNetModules();
        int intersectMask = oso.getCurrentOverlaySettings().intersectionMask;
        HashSet currentNetModSet = modKeys == null ? null : modKeys.set;
        TaggedSet revKeys = oso.getRevealedModules();
        HashSet revMods = revKeys == null ? null : revKeys.set;
        ArrayList<Intersection> retval = new ArrayList<Intersection>();
        Iterator ntit = genome.getNoteIterator();
        while (ntit.hasNext()) {
            Note note = (Note)ntit.next();
            if (interactiveOnly && !note.isInteractive()) continue;
            IRenderer render = layout.getNoteProperties(note.getID()).getRenderer();
            Intersection inter = render.intersects(genome, (GenomeItem)note, layout, this.frc_, pt, pixDiam, null);
            if ((inter = this.filterForModuleMask(genome, layout, pt, inter, currentOverlay, currentNetModSet, revMods, intersectMask, pixDiam)) == null) continue;
            retval.add(inter);
        }
        return retval.isEmpty() ? null : retval;
    }

    public String intersectModelData(Genome genome, Layout layout, Point2D pt, String currentOverlay, Set currentNetModSet, int intersectMask) {
        String[] keys = new String[]{"date", "attrib", "title", "key"};
        int[] fonts = new int[]{9, 9, 10, 9};
        boolean[] isSingle = new boolean[]{true, true, true, false};
        ModelData md = Database.getDB().getModelData();
        String longName = genome.getLongName();
        if (md == null && (longName == null || longName.trim().equals(""))) {
            return null;
        }
        Object[] data = new Object[4];
        data[0] = md == null ? null : md.getDate();
        data[1] = md == null ? null : md.getAttribution();
        data[2] = longName;
        if (md != null) {
            ArrayList<String> keyList = new ArrayList<String>();
            int numKey = md.getKeySize();
            for (int i = 0; i < numKey; ++i) {
                keyList.add(md.getKey(i));
            }
            data[3] = keyList;
        } else {
            data[3] = null;
        }
        DataLocator dl = new DataLocator(null);
        for (int i = 0; i < keys.length; ++i) {
            double height;
            double width;
            Point2D loc;
            if (data[i] == null || (loc = layout.getDataLocation(keys[i])) == null) continue;
            Font mFont = FontManager.getMgr().getFont(fonts[i]);
            if (isSingle[i]) {
                Rectangle2D bounds = mFont.getStringBounds((String)data[i], this.frc_);
                width = bounds.getWidth();
                height = bounds.getHeight();
            } else {
                Dimension dim = dl.calcKeyBounds((List)data[i], layout, mFont, this.frc_);
                width = dim.getWidth();
                height = dim.getHeight();
            }
            double minX = loc.getX() - width / 2.0;
            double maxX = loc.getX() + width / 2.0;
            double maxY = loc.getY() + height / 2.0;
            double minY = loc.getY() - height / 2.0;
            if (!Bounds.intersects(minX, minY, maxX, maxY, pt.getX(), pt.getY())) continue;
            return keys[i];
        }
        return null;
    }

    public Rectangle getModelDataBounds(Genome genome, Layout layout) {
        Rectangle retval = null;
        String[] keys = new String[]{"date", "attrib", "title", "key"};
        int[] fonts = new int[]{9, 9, 10, 9};
        boolean[] isSingle = new boolean[]{true, true, true, false};
        ModelData md = Database.getDB().getModelData();
        String longName = genome.getLongName();
        if (md == null && (longName == null || longName.trim().equals(""))) {
            return null;
        }
        Object[] data = new Object[4];
        data[0] = md == null ? null : md.getDate();
        data[1] = md == null ? null : md.getAttribution();
        data[2] = longName;
        if (md != null) {
            ArrayList<String> keyList = new ArrayList<String>();
            int numKey = md.getKeySize();
            for (int i = 0; i < numKey; ++i) {
                keyList.add(md.getKey(i));
            }
            data[3] = keyList;
        } else {
            data[3] = null;
        }
        DataLocator dl = new DataLocator(null);
        for (int i = 0; i < keys.length; ++i) {
            int height;
            int width;
            Point2D loc;
            if (data[i] == null || (loc = layout.getDataLocation(keys[i])) == null) continue;
            Font mFont = FontManager.getMgr().getFont(fonts[i]);
            if (isSingle[i]) {
                Rectangle2D bounds = mFont.getStringBounds((String)data[i], this.frc_);
                width = (int)bounds.getWidth();
                height = (int)bounds.getHeight();
            } else {
                Dimension dim = dl.calcKeyBounds((List)data[i], layout, mFont, this.frc_);
                width = (int)dim.getWidth();
                height = (int)dim.getHeight();
            }
            int minX = (int)loc.getX() - width / 2;
            int minY = (int)loc.getY() - height / 2;
            Rectangle newRect = new Rectangle(minX, minY, width, height);
            UiUtil.forceToGrid(newRect, 10.0);
            if (retval == null) {
                retval = newRect;
                continue;
            }
            Bounds.tweakBounds(retval, newRect);
        }
        return retval;
    }

    private Layout.PropChange[] moveModelData(String modelKey, Genome genome, Layout layout, double dx, double dy) {
        Layout.PropChange[] pc = new Layout.PropChange[]{layout.moveDataLocation(modelKey, genome, dx, dy)};
        return pc;
    }

    private void renderGroupsInBackground(Graphics2D g2, GenomeInstance root, GenomeInstance genome, Layout layout, List collectRects, Rectangle2D clipRect, double pixDiam) {
        List order = layout.getGroupDrawingOrder();
        GroupFree renderer = new GroupFree();
        for (int i = 0; i <= 10; ++i) {
            Iterator grit = genome.getGroupIteratorFromList(order);
            while (grit.hasNext()) {
                GroupProperties gp;
                Group group = (Group)grit.next();
                GenomeInstance useToRender = null;
                String groupRef = null;
                GroupFree.AugmentedExtraInfo augExtra = new GroupFree.AugmentedExtraInfo();
                augExtra.extra = null;
                augExtra.passOut = collectRects;
                if (root == null) {
                    useToRender = genome;
                    groupRef = group.getID();
                    gp = layout.getGroupProperties(Group.getBaseID(groupRef));
                    if (gp.getLayer() != i) {
                        continue;
                    }
                } else {
                    String inherit;
                    augExtra.extra = new GroupFree.ExtraInfo();
                    useToRender = root;
                    groupRef = group.getReference();
                    gp = layout.getGroupProperties(Group.getBaseID(groupRef));
                    if (gp.getLayer() != i) continue;
                    GroupSettingManager gsm = GroupSettingManager.getGroupMgr();
                    augExtra.extra.vizVal = new Integer(gsm.getGroupVisibility(genome.getID(), group.getID()));
                    augExtra.extra.dropName = group.isUsingParent();
                    augExtra.extra.genomeIsRoot = false;
                    String activeSubsetID = group.getActiveSubset();
                    if (activeSubsetID != null) {
                        Iterator pit;
                        inherit = Group.buildInheritedID(activeSubsetID, root.getGeneration());
                        Group activeSubset = root.getGroup(inherit);
                        if (activeSubset == null && (pit = root.getGroupIterator()).hasNext()) {
                            Group gr = (Group)pit.next();
                            System.err.println(gr.getID());
                            throw new IllegalStateException();
                        }
                        augExtra.extra.replacementName = activeSubset.getInheritedDisplayName(genome);
                        GroupProperties asgp = layout.getGroupProperties(Group.getBaseID(activeSubsetID));
                        augExtra.extra.replacementColor = asgp.getColor(false);
                    }
                    inherit = Group.buildInheritedID(groupRef, root.getGeneration());
                    group = root.getGroup(inherit);
                }
                renderer.render(g2, null, useToRender, group, layout, null, false, false, clipRect, pixDiam, augExtra);
            }
        }
    }

    private void presentUnusedGroups(Graphics2D g2, GenomeInstance root, GenomeInstance parent, GenomeInstance genome, Layout layout, Rectangle2D clipRect, double pixDiam) {
        GroupFree renderer = new GroupFree();
        List order = layout.getGroupDrawingOrder();
        Iterator grit = parent.getGroupIteratorFromList(order);
        while (grit.hasNext()) {
            Group group = (Group)grit.next();
            String groupRef = group.getID();
            GroupProperties gp = layout.getGroupProperties(Group.getBaseID(groupRef));
            if (gp.getLayer() != 0) continue;
            Iterator cgrit = genome.getGroupIteratorFromList(order);
            boolean needToGhost = true;
            while (cgrit.hasNext()) {
                Group cgroup = (Group)cgrit.next();
                if (!Group.getBaseID(cgroup.getReference()).equals(Group.getBaseID(groupRef))) continue;
                needToGhost = false;
                break;
            }
            if (!needToGhost) continue;
            group = root.getGroup(Group.getBaseID(groupRef));
            renderer.render(g2, null, root, group, layout, null, true, false, clipRect, pixDiam, null);
        }
    }

    private void renderGroupsInForeground(Graphics2D g2, GenomeInstance parent, GenomeInstance genome, Layout layout, Rectangle2D clipRect, double pixDiam) {
        GroupFree renderer = new GroupFree();
        GroupSettingManager gsm = GroupSettingManager.getGroupMgr();
        GenomeInstance iterateOver = parent == null ? genome : parent;
        List order = layout.getGroupDrawingOrder();
        Iterator grit = iterateOver.getGroupIteratorFromList(order);
        block0: while (grit.hasNext()) {
            GroupProperties gp;
            String groupRef;
            Group group = (Group)grit.next();
            if (parent == null) {
                groupRef = group.getID();
                gp = layout.getGroupProperties(groupRef);
                int groupViz = gsm.getGroupVisibility(genome.getID(), groupRef);
                int layer = gp.getLayer();
                if (layer != 0 || groupViz == 4) continue;
                renderer.render(g2, null, genome, group, layout, null, false, false, clipRect, pixDiam, null);
                continue;
            }
            groupRef = group.getID();
            gp = layout.getGroupProperties(groupRef);
            if (gp.getLayer() != 0) continue;
            Iterator cgrit = genome.getGroupIteratorFromList(order);
            while (cgrit.hasNext()) {
                Group cgroup = (Group)cgrit.next();
                if (!Group.getBaseID(cgroup.getReference()).equals(groupRef)) continue;
                int groupViz = gsm.getGroupVisibility(genome.getID(), cgroup.getID());
                if (groupViz == 4) continue block0;
                GroupFree.AugmentedExtraInfo augExtra = new GroupFree.AugmentedExtraInfo();
                augExtra.extra = new GroupFree.ExtraInfo();
                augExtra.extra.vizVal = new Integer(groupViz);
                augExtra.extra.dropName = cgroup.isUsingParent();
                augExtra.extra.genomeIsRoot = false;
                String activeSubsetName = cgroup.getActiveSubset();
                if (activeSubsetName != null) {
                    activeSubsetName = Group.buildInheritedID(activeSubsetName, parent.getGeneration());
                    Group activeSubset = parent.getGroup(activeSubsetName);
                    GroupProperties asgp = layout.getGroupProperties(activeSubsetName);
                    augExtra.extra.replacementName = activeSubset.getName();
                    augExtra.extra.replacementColor = asgp.getColor(false);
                }
                renderer.render(g2, null, parent, group, layout, null, false, false, clipRect, pixDiam, augExtra);
                continue block0;
            }
        }
    }

    private Intersection intersectGroups(GenomeInstance parent, GenomeInstance genome, Point2D pt, double pixDiam, Layout layout, boolean inactiveOnly) {
        GroupFree renderer = new GroupFree();
        GroupSettingManager gsm = GroupSettingManager.getGroupMgr();
        List order = layout.getGroupIntersectionOrder();
        Iterator grit = genome.getGroupIteratorFromList(order);
        while (grit.hasNext()) {
            Group group = (Group)grit.next();
            GenomeInstance useToRender = null;
            String groupRef = null;
            String origID = group.getID();
            if (parent == null) {
                useToRender = genome;
                groupRef = origID;
            } else {
                useToRender = parent;
                groupRef = group.getReference();
                group = parent.getGroup(Group.getBaseID(groupRef));
            }
            GroupProperties gp = layout.getGroupProperties(Group.getBaseID(groupRef));
            int groupViz = gsm.getGroupVisibility(genome.getID(), origID);
            boolean checkForIntersect = gp.getLayer() == 0 && (inactiveOnly && groupViz != 4 || !inactiveOnly);
            if (!checkForIntersect) continue;
            GroupFree.AugmentedExtraInfo augExtra = new GroupFree.AugmentedExtraInfo();
            boolean bl = (augExtra.extra = new GroupFree.ExtraInfo()).genomeIsRoot = parent == null;
            Intersection inter = renderer.intersects((Genome)useToRender, (GenomeItem)group, layout, this.frc_, pt, pixDiam, (Object)augExtra);
            if (inter == null) continue;
            return new Intersection(origID, inter.getSubID(), 0.0);
        }
        return null;
    }

    private boolean overlayIsOpaque(Layout layout, String currentOverlay) {
        if (currentOverlay == null) {
            return false;
        }
        NetOverlayProperties nop = layout.getNetOverlayProperties(currentOverlay);
        return nop.getType() == 1;
    }

    private int needMaskingReduction(Layout layout, String currentOverlay, int intersectMask) {
        if (currentOverlay == null) {
            return 0;
        }
        if (intersectMask == 0) {
            return 0;
        }
        NetOverlayProperties nop = layout.getNetOverlayProperties(currentOverlay);
        if (nop.getType() != 1) {
            return 0;
        }
        if (intersectMask == 2) {
            return 2;
        }
        if (intersectMask != 1) {
            throw new IllegalArgumentException();
        }
        return 1;
    }

    private MaskData maskingReduction(String genomeKey, Layout layout, OverlayStateOracle oso) {
        String ovrID;
        MaskData retval = new MaskData();
        retval.nonBlackHoles = this.nonBlackHoles(genomeKey, layout, oso);
        if (retval.nonBlackHoles != null) {
            retval.candidates = new HashSet();
        }
        if ((ovrID = oso.getCurrentOverlay()) == null) {
            return retval;
        }
        NetOverlayOwner owner = Database.getDB().getOverlayOwnerFromGenomeKey(genomeKey);
        NetworkOverlay novr = owner.getNetworkOverlay(ovrID);
        NetOverlayProperties nop = layout.getNetOverlayProperties(ovrID);
        boolean isOpq = nop.getType() == 1;
        NetModuleFree.CurrentSettings settings = oso.getCurrentOverlaySettings();
        Iterator modit = novr.getModuleIterator();
        while (modit.hasNext()) {
            NetModule nmod = (NetModule)modit.next();
            String modID = nmod.getID();
            NetModuleProperties nmp = nop.getNetModuleProperties(modID);
            boolean isRevealed = oso.getRevealedModules().set.contains(modID);
            boolean quickFade = nmp.getNameFadeMode() == 0;
            boolean nameHiding = isRevealed && isOpq && quickFade;
            boolean labelViz = !nameHiding && (!quickFade || settings.fastDecayLabelVisible);
            Boolean labelVizObj = new Boolean(labelViz);
            retval.labelViz.put(modID, labelVizObj);
            if (retval.candidates == null || !retval.nonBlackHoles.contains(modID)) continue;
            Iterator memit = nmod.getMemberIterator();
            while (memit.hasNext()) {
                NetModuleMember nmm = (NetModuleMember)memit.next();
                retval.candidates.add(nmm.getID());
            }
        }
        return retval;
    }

    private boolean intersectsSelectedLinkSegment(Linkage link, Intersection inter, Layout layout) {
        Set justKeys = this.selectionKeys_.keySet();
        Intersection selected = this.linkIsSelected(justKeys, this.selectionKeys_, layout, link);
        if (selected == null) {
            return false;
        }
        LinkSegmentID[] selsegs = selected.segmentIDsFromIntersect();
        if (selsegs == null) {
            return true;
        }
        LinkSegmentID[] intersegs = inter.segmentIDsFromIntersect();
        if (intersegs == null) {
            return true;
        }
        for (int i = 0; i < selsegs.length; ++i) {
            for (int j = 0; j < intersegs.length; ++j) {
                if (!selsegs[i].equals(intersegs[j])) continue;
                return true;
            }
        }
        return false;
    }

    private List selectionGuts(int x, int y, String genomeKey, Layout layout, boolean nodesFirst, boolean omitGroups, boolean doOverlay, double pixDiam, OverlayStateOracle oso) {
        Intersection inter;
        IRenderer render;
        Intersection inter2;
        INodeRenderer render2;
        String nid;
        Node node;
        Iterator nit;
        Intersection inter3;
        INodeRenderer render3;
        String gid;
        Gene gene;
        Iterator git;
        HashSet revMods;
        String currentOverlay = oso.getCurrentOverlay();
        TaggedSet currentNetMods = oso.getCurrentNetModules();
        int intersectMask = oso.getCurrentOverlaySettings().intersectionMask;
        HashSet currentNetModSet = currentNetMods == null ? null : currentNetMods.set;
        TaggedSet revKeys = oso.getRevealedModules();
        HashSet hashSet = revMods = revKeys == null ? null : revKeys.set;
        if (genomeKey == null) {
            return null;
        }
        Genome genome = this.source_.getGenome(genomeKey);
        Point2D.Float pt = new Point2D.Float(x, y);
        ArrayList<Intersection.AugmentedIntersection> retval = new ArrayList<Intersection.AugmentedIntersection>();
        MaskData overMask = this.maskingReduction(genomeKey, layout, oso);
        if (overMask.candidates != null && overMask.candidates.isEmpty() && this.selectionKeys_.isEmpty()) {
            if (doOverlay) {
                Intersection.AugmentedIntersection ait;
                Intersection inter4 = this.intersectANetModuleElement(x, y, genomeKey, layout, pixDiam, oso, 2);
                if (inter4 != null) {
                    ait = new Intersection.AugmentedIntersection(inter4, 6);
                    retval.add(ait);
                }
                if ((inter4 = this.intersectANetModuleElement(x, y, genomeKey, layout, pixDiam, oso, 3)) != null) {
                    ait = new Intersection.AugmentedIntersection(inter4, 6);
                    retval.add(ait);
                }
                if ((inter4 = this.intersectANetModuleElement(x, y, genomeKey, layout, pixDiam, oso, 0)) != null && !overMask.nonBlackHoles.contains(inter4.getObjectID())) {
                    ait = new Intersection.AugmentedIntersection(inter4, 6);
                    retval.add(ait);
                }
                if ((inter4 = this.intersectNetModuleLinks(x, y, genomeKey, layout, oso, pixDiam)) != null) {
                    ait = new Intersection.AugmentedIntersection(inter4, 7);
                    retval.add(ait);
                }
            }
            return retval.isEmpty() ? null : retval;
        }
        if (genome instanceof GenomeInstance) {
            GenomeInstance child = (GenomeInstance)genome;
            GenomeInstance parentvfg = child.getVfgParentRoot();
            Intersection groupCheck = this.intersectGroups(parentvfg, child, pt, pixDiam, layout, true);
            if ((groupCheck = this.filterForModuleMask(genome, layout, pt, groupCheck, currentOverlay, currentNetModSet, revMods, intersectMask, pixDiam)) != null) {
                if (omitGroups) {
                    return null;
                }
                retval.add(new Intersection.AugmentedIntersection(groupCheck, 5));
                return retval;
            }
        }
        if (nodesFirst) {
            git = genome.getGeneIterator();
            while (git.hasNext()) {
                gene = (Gene)git.next();
                gid = gene.getID();
                render3 = layout.getNodeProperties(gene.getID()).getRenderer();
                inter3 = render3.intersects(genome, (GenomeItem)gene, layout, this.frc_, pt, pixDiam, null);
                if (inter3 == null || overMask.candidates != null && !overMask.candidates.contains(inter3.getObjectID()) && !this.selectionKeys_.containsKey(gid)) continue;
                retval.add(new Intersection.AugmentedIntersection(inter3, 1));
            }
            nit = genome.getNodeIterator();
            while (nit.hasNext()) {
                node = (Node)nit.next();
                nid = node.getID();
                render2 = layout.getNodeProperties(node.getID()).getRenderer();
                inter2 = render2.intersects(genome, (GenomeItem)node, layout, this.frc_, pt, pixDiam, null);
                if (inter2 == null || overMask.candidates != null && !overMask.candidates.contains(inter2.getObjectID()) && !this.selectionKeys_.containsKey(nid)) continue;
                retval.add(new Intersection.AugmentedIntersection(inter2, 2));
            }
        }
        if (doOverlay) {
            Intersection.AugmentedIntersection ait;
            Intersection.AugmentedIntersection ait2;
            Intersection inter5 = this.intersectANetModuleElement(x, y, genomeKey, layout, pixDiam, oso, 2);
            if (inter5 != null) {
                ait2 = new Intersection.AugmentedIntersection(inter5, 6);
                retval.add(ait2);
            }
            if ((inter5 = this.intersectANetModuleElement(x, y, genomeKey, layout, pixDiam, oso, 3)) != null) {
                ait2 = new Intersection.AugmentedIntersection(inter5, 6);
                retval.add(ait2);
            }
            NetModuleFree.CurrentSettings settings = oso.getCurrentOverlaySettings();
            if (settings.intersectionMask == 2 && (inter5 = this.intersectANetModuleElement(x, y, genomeKey, layout, pixDiam, oso, 0)) != null && overMask.nonBlackHoles != null && !overMask.nonBlackHoles.contains(inter5.getObjectID())) {
                ait = new Intersection.AugmentedIntersection(inter5, 6);
                retval.add(ait);
            }
            if ((inter5 = this.intersectNetModuleLinks(x, y, genomeKey, layout, oso, pixDiam)) != null) {
                ait = new Intersection.AugmentedIntersection(inter5, 7);
                retval.add(ait);
            }
        }
        if (!this.linksAreHidden(layout, oso)) {
            Iterator lit = genome.getLinkageIterator();
            while (lit.hasNext()) {
                Linkage link = (Linkage)lit.next();
                render = (LinkageFree)layout.getLinkProperties(link.getID()).getRenderer();
                inter = ((LinkageFree)render).intersects(genome, (GenomeItem)link, layout, this.frc_, pt, pixDiam, null);
                if (inter != null && this.intersectsSelectedLinkSegment(link, inter, layout)) {
                    retval.add(new Intersection.AugmentedIntersection(inter, 3));
                }
                if ((inter = this.filterForModuleMask(genome, layout, pt, inter, currentOverlay, currentNetModSet, revMods, intersectMask, pixDiam)) == null) continue;
                retval.add(new Intersection.AugmentedIntersection(inter, 3));
            }
        }
        if (!nodesFirst) {
            git = genome.getGeneIterator();
            while (git.hasNext()) {
                gene = (Gene)git.next();
                gid = gene.getID();
                render3 = layout.getNodeProperties(gene.getID()).getRenderer();
                inter3 = render3.intersects(genome, (GenomeItem)gene, layout, this.frc_, pt, pixDiam, null);
                if (inter3 == null || overMask.candidates != null && !overMask.candidates.contains(inter3.getObjectID()) && !this.selectionKeys_.containsKey(gid)) continue;
                retval.add(new Intersection.AugmentedIntersection(inter3, 2));
            }
            nit = genome.getNodeIterator();
            while (nit.hasNext()) {
                node = (Node)nit.next();
                nid = node.getID();
                render2 = layout.getNodeProperties(node.getID()).getRenderer();
                inter2 = render2.intersects(genome, (GenomeItem)node, layout, this.frc_, pt, pixDiam, null);
                if (inter2 == null || overMask.candidates != null && !overMask.candidates.contains(inter2.getObjectID()) && !this.selectionKeys_.containsKey(nid)) continue;
                retval.add(new Intersection.AugmentedIntersection(inter2, 1));
            }
        }
        Iterator ntit = genome.getNoteIterator();
        while (ntit.hasNext()) {
            Note note = (Note)ntit.next();
            render = layout.getNoteProperties(note.getID()).getRenderer();
            inter = render.intersects(genome, (GenomeItem)note, layout, this.frc_, pt, pixDiam, null);
            if ((inter = this.filterForModuleMask(genome, layout, pt, inter, currentOverlay, currentNetModSet, revMods, intersectMask, pixDiam)) == null) continue;
            retval.add(new Intersection.AugmentedIntersection(inter, 4));
        }
        if (retval.isEmpty() && genome instanceof GenomeInstance) {
            GenomeInstance child = (GenomeInstance)genome;
            GenomeInstance parentvfg = child.getVfgParentRoot();
            Intersection groupCheck = this.intersectGroups(parentvfg, child, pt, pixDiam, layout, false);
            if ((groupCheck = this.filterForModuleMask(genome, layout, pt, groupCheck, currentOverlay, currentNetModSet, revMods, intersectMask, pixDiam)) != null) {
                if (omitGroups) {
                    return null;
                }
                retval.add(new Intersection.AugmentedIntersection(groupCheck, 5));
                return retval;
            }
        }
        return retval.isEmpty() ? null : retval;
    }

    private List selectionGuts(Rectangle rect, String genomeKey, String layoutKey, boolean nodesFirst, OverlayStateOracle oso) {
        Intersection inter;
        INodeRenderer render;
        Node node;
        Iterator nit;
        Intersection inter2;
        INodeRenderer render2;
        Gene gene;
        Iterator git;
        ArrayList<Intersection> retval = new ArrayList<Intersection>();
        Layout layout = this.layoutSource_.getLayout(layoutKey);
        String currentOverlay = oso.getCurrentOverlay();
        TaggedSet currentNetMods = oso.getCurrentNetModules();
        int intersectMask = oso.getCurrentOverlaySettings().intersectionMask;
        HashSet currentNetModSet = currentNetMods == null ? null : currentNetMods.set;
        TaggedSet revKeys = oso.getRevealedModules();
        HashSet revMods = revKeys == null ? null : revKeys.set;
        Genome genome = this.source_.getGenome(genomeKey);
        MaskData overMask = this.maskingReduction(genomeKey, layout, oso);
        if (overMask.candidates != null && overMask.candidates.isEmpty()) {
            return retval;
        }
        if (nodesFirst) {
            git = genome.getGeneIterator();
            while (git.hasNext()) {
                gene = (Gene)git.next();
                render2 = layout.getNodeProperties(gene.getID()).getRenderer();
                inter2 = render2.intersects(genome, (GenomeItem)gene, layout, this.frc_, rect, false, null);
                if (inter2 == null || overMask.candidates != null && !overMask.candidates.contains(inter2.getObjectID())) continue;
                retval.add(inter2);
            }
            nit = genome.getNodeIterator();
            while (nit.hasNext()) {
                node = (Node)nit.next();
                render = layout.getNodeProperties(node.getID()).getRenderer();
                inter = render.intersects(genome, (GenomeItem)node, layout, this.frc_, rect, false, null);
                if (inter == null || overMask.candidates != null && !overMask.candidates.contains(inter.getObjectID())) continue;
                retval.add(inter);
            }
        }
        if (!this.linksAreHidden(layout, oso)) {
            ArrayList<Intersection> linkOnlyRetval = new ArrayList<Intersection>();
            Iterator lit = genome.getLinkageIterator();
            while (lit.hasNext()) {
                Linkage link = (Linkage)lit.next();
                BusProperties bp = layout.getLinkProperties(link.getID());
                LinkageFree render3 = (LinkageFree)bp.getRenderer();
                Intersection inter3 = render3.intersects(genome, (GenomeItem)link, layout, this.frc_, rect, false, null);
                if (inter3 == null) continue;
                linkOnlyRetval.add(inter3);
            }
            if (!linkOnlyRetval.isEmpty()) {
                List filtered = this.filterLinksForModuleMask(genome, layout, linkOnlyRetval, this.frc_, currentOverlay, currentNetModSet, revMods, intersectMask);
                retval.addAll(filtered);
            }
        }
        if (!nodesFirst) {
            git = genome.getGeneIterator();
            while (git.hasNext()) {
                gene = (Gene)git.next();
                render2 = layout.getNodeProperties(gene.getID()).getRenderer();
                inter2 = render2.intersects(genome, (GenomeItem)gene, layout, this.frc_, rect, false, null);
                if (inter2 == null || overMask.candidates != null && !overMask.candidates.contains(inter2.getObjectID())) continue;
                retval.add(inter2);
            }
            nit = genome.getNodeIterator();
            while (nit.hasNext()) {
                node = (Node)nit.next();
                render = layout.getNodeProperties(node.getID()).getRenderer();
                inter = render.intersects(genome, (GenomeItem)node, layout, this.frc_, rect, false, null);
                if (inter == null || overMask.candidates != null && !overMask.candidates.contains(inter.getObjectID())) continue;
                retval.add(inter);
            }
        }
        return retval;
    }

    private void renderFloater(Graphics2D g2, boolean showBubbles, Rectangle2D clipRect, double pixDiam) {
        if (this.floater_ == null) {
            return;
        }
        if (this.floater_ instanceof ArrayList) {
            if (this.floatPoint_ != null) {
                ProtoLinkFree renderer = new ProtoLinkFree();
                ArrayList<Point2D> augment = new ArrayList<Point2D>((ArrayList)this.floater_);
                augment.add(this.floatPoint_);
                renderer.render(g2, augment);
            }
        } else if (this.floater_ instanceof Rectangle2D) {
            g2.setPaint(this.floaterColor_ == null ? Color.black : this.floaterColor_);
            g2.draw((Rectangle2D)this.floater_);
        } else if (this.floater_ instanceof GenomeItem) {
            RenderObjectCache roc = null;
            GenomeItem git = (GenomeItem)this.floater_;
            IRenderer render = null;
            GroupFree.AugmentedExtraInfo optArg = null;
            if (git instanceof Node) {
                render = this.floaterLayout_.getNodeProperties(git.getID()).getRenderer();
            } else if (git instanceof Linkage) {
                roc = new RenderObjectCache();
                render = (LinkageFree)this.floaterLayout_.getLinkProperties(git.getID()).getRenderer();
            } else if (git instanceof Group) {
                render = new GroupFree();
                GroupFree.AugmentedExtraInfo augExtra = new GroupFree.AugmentedExtraInfo();
                augExtra.extra = new GroupFree.ExtraInfo();
                augExtra.extra.vizVal = new Integer(4);
                optArg = augExtra;
            } else if (git instanceof Note) {
                render = this.floaterLayout_.getNoteProperties(git.getID()).getRenderer();
            }
            render.render(g2, roc, this.floaterGenome_, git, this.floaterLayout_, null, false, showBubbles, clipRect, pixDiam, optArg);
            if (roc != null) {
                roc.render(g2);
            }
        }
    }

    public Layout getFloaterLayout() {
        return this.floaterLayout_;
    }

    private void addOrMerge(HashMap map, Intersection oldInt, Intersection newInt, boolean sameParent) {
        if (!sameParent) {
            map.put(newInt.getObjectID(), newInt);
            return;
        }
        if (oldInt.canMerge() && newInt.canMerge()) {
            LinkageFree lf = new LinkageFree();
            Intersection mergeInt = lf.mergeIntersect(oldInt, newInt);
            map.put(mergeInt.getObjectID(), mergeInt);
        }
    }

    private void intersect(HashMap map, Intersection oldInt, Intersection newInt) {
        LinkageFree lf = new LinkageFree();
        Intersection mergeInt = lf.intersectComplement(oldInt, newInt);
        map.put(mergeInt.getObjectID(), mergeInt);
    }

    private HashMap duplicateSelections() {
        HashMap<String, Intersection> retval = new HashMap<String, Intersection>();
        LinkageFree lf = new LinkageFree();
        GroupFree gf = new GroupFree();
        Iterator sit = this.selectionKeys_.keySet().iterator();
        while (sit.hasNext()) {
            String key = (String)sit.next();
            Intersection inter = (Intersection)this.selectionKeys_.get(key);
            if (inter.canCopy()) {
                retval.put(key, new Intersection(inter));
                continue;
            }
            if (lf.isLinkageSubID(inter)) {
                retval.put(key, lf.copyIntersection(inter));
                continue;
            }
            if (gf.isGroupSubID(inter)) {
                retval.put(key, gf.copyIntersection(inter));
                continue;
            }
            throw new IllegalStateException();
        }
        return retval;
    }

    private void gaggleSelectionSupport(GooseAppInterface goose, String genomeKey, String layoutKey) {
        SelectionSupport ss = goose.getSelectionSupport();
        if (genomeKey == null || this.selectionKeys_.isEmpty()) {
            ss.setSelections(new ArrayList());
            ss.setOutboundNetwork(new SelectionSupport.NetworkForSpecies());
            return;
        }
        Genome gen = this.source_.getGenome(genomeKey);
        DBGenome genome = gen instanceof DBGenome ? (DBGenome)gen : (DBGenome)this.source_.getGenome();
        Map uniques = genome.genUnique();
        Set selections = this.cullNodeSelections(gen, uniques, false);
        ss.setSelections(new ArrayList(selections));
        Layout layout = this.layoutSource_.getLayout(layoutKey);
        SelectionSupport.NetworkForSpecies nfs = this.selectionsToGaggleNets(gen, uniques, layout);
        ss.setOutboundNetwork(nfs);
    }

    private Set cullNodeSelections(Genome genome, Map uniques, boolean idOnly) {
        HashSet<String> retval = new HashSet<String>();
        Iterator sit = this.selectionKeys_.keySet().iterator();
        block0: while (sit.hasNext()) {
            String key = (String)sit.next();
            Intersection inter = (Intersection)this.selectionKeys_.get(key);
            String itemID = inter.getObjectID();
            Iterator git = genome.getAllNodeIterator();
            while (git.hasNext()) {
                Node node = (Node)git.next();
                String nodeID = node.getID();
                if (!itemID.equals(nodeID)) continue;
                if (idOnly) {
                    retval.add(nodeID);
                    continue block0;
                }
                if (uniques != null) {
                    retval.add((String)uniques.get(GenomeItemInstance.getBaseID(nodeID)));
                    continue block0;
                }
                retval.add(node.getName());
                continue block0;
            }
        }
        return retval;
    }

    private SelectionSupport.NetworkForSpecies selectionsToGaggleNets(Genome gen, Map uniques, Layout layout) {
        String linkID;
        if (!(gen instanceof DBGenome)) {
            return null;
        }
        DBGenome genome = (DBGenome)gen;
        HashSet selectedLinks = new HashSet();
        Iterator sit = this.selectionKeys_.keySet().iterator();
        while (sit.hasNext()) {
            String key = (String)sit.next();
            Intersection inter = (Intersection)this.selectionKeys_.get(key);
            String itemID = inter.getObjectID();
            Linkage lnk = genome.getLinkage(itemID);
            if (lnk == null) continue;
            HashSet linkagesToPull = new HashSet();
            BusProperties lp = layout.getLinkProperties(itemID);
            LinkSegmentID[] segIDs = inter.segmentIDsFromIntersect();
            if (segIDs == null) {
                List allLinks = lp.getLinkageList();
                selectedLinks.addAll(allLinks);
                continue;
            }
            for (int i = 0; i < segIDs.length; ++i) {
                Set resolved = lp.resolveLinkagesThroughSegment(segIDs[i], genome);
                selectedLinks.addAll(resolved);
            }
        }
        Set selectedNodes = this.cullNodeSelections(genome, null, true);
        Iterator slit = selectedLinks.iterator();
        while (slit.hasNext()) {
            String linkID2 = (String)slit.next();
            Linkage link = genome.getLinkage(linkID2);
            String src = link.getSource();
            String trg = link.getTarget();
            if (!selectedNodes.contains(src)) {
                selectedNodes.add(src);
            }
            if (selectedNodes.contains(trg)) continue;
            selectedNodes.add(trg);
        }
        HashSet<String> optLinks = new HashSet<String>();
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            linkID = link.getID();
            if (selectedLinks.contains(linkID)) continue;
            String src = link.getSource();
            String trg = link.getTarget();
            if (!selectedNodes.contains(src) || !selectedNodes.contains(trg)) continue;
            optLinks.add(linkID);
        }
        ArrayList<SignedLink> gagLinks = new ArrayList<SignedLink>();
        slit = selectedLinks.iterator();
        while (slit.hasNext()) {
            linkID = (String)slit.next();
            Linkage link = genome.getLinkage(linkID);
            String src = link.getSource();
            String srcName = uniques == null ? genome.getNode(src).getName() : (String)uniques.get(src);
            String trg = link.getTarget();
            String trgName = uniques == null ? genome.getNode(trg).getName() : (String)uniques.get(trg);
            int sign = link.getSign();
            SignedLink slink = new SignedLink(srcName, trgName, sign);
            gagLinks.add(slink);
        }
        HashMap<String, String> nodeTypes = new HashMap<String, String>();
        Iterator snit = selectedNodes.iterator();
        while (snit.hasNext()) {
            String nodeID = (String)snit.next();
            String nodeName = uniques == null ? genome.getNode(nodeID).getName() : (String)uniques.get(nodeID);
            Node node = genome.getNode(nodeID);
            String nodeType = DBNode.mapToTag(node.getNodeType());
            nodeTypes.put(nodeName, nodeType);
        }
        ArrayList<SignedLink> optGagLinks = new ArrayList<SignedLink>();
        Iterator olit = optLinks.iterator();
        while (olit.hasNext()) {
            String linkID3 = (String)olit.next();
            Linkage link = genome.getLinkage(linkID3);
            String src = link.getSource();
            String srcName = uniques == null ? genome.getNode(src).getName() : (String)uniques.get(src);
            String trg = link.getTarget();
            String trgName = uniques == null ? genome.getNode(trg).getName() : (String)uniques.get(trg);
            int sign = link.getSign();
            SignedLink slink = new SignedLink(srcName, trgName, sign);
            optGagLinks.add(slink);
        }
        SelectionSupport.NetworkForSpecies nfs = new SelectionSupport.NetworkForSpecies(uniques != null, nodeTypes, gagLinks, optGagLinks);
        return nfs;
    }

    public ExternalSelectionChangeEvent selectionsForExternalEvents(String genomeKey, String layoutKey) {
        Genome gen = this.source_.getGenome(genomeKey);
        Layout layout = this.layoutSource_.getLayout(layoutKey);
        HashSet selectedLinks = new HashSet();
        Iterator sit = this.selectionKeys_.keySet().iterator();
        while (sit.hasNext()) {
            String key = (String)sit.next();
            Intersection inter = (Intersection)this.selectionKeys_.get(key);
            String itemID = inter.getObjectID();
            Linkage lnk = gen.getLinkage(itemID);
            if (lnk == null) continue;
            BusProperties lp = layout.getLinkProperties(itemID);
            LinkSegmentID[] segIDs = inter.segmentIDsFromIntersect();
            if (segIDs == null) {
                List allLinks = lp.getLinkageList();
                selectedLinks.addAll(allLinks);
                continue;
            }
            for (int i = 0; i < segIDs.length; ++i) {
                Set resolved = lp.resolveLinkagesThroughSegment(segIDs[i], gen);
                selectedLinks.addAll(resolved);
            }
        }
        HashSet<String> selectedNodes = new HashSet<String>();
        sit = this.selectionKeys_.keySet().iterator();
        block2: while (sit.hasNext()) {
            String key = (String)sit.next();
            Intersection inter = (Intersection)this.selectionKeys_.get(key);
            String itemID = inter.getObjectID();
            Iterator git = gen.getAllNodeIterator();
            while (git.hasNext()) {
                Node node = (Node)git.next();
                String nodeID = node.getID();
                if (!itemID.equals(nodeID)) continue;
                selectedNodes.add(nodeID);
                continue block2;
            }
        }
        HashSet<String> linkSelections = new HashSet<String>();
        Iterator slit = selectedLinks.iterator();
        while (slit.hasNext()) {
            String linkID = (String)slit.next();
            Linkage link = gen.getLinkage(linkID);
            if (link == null) continue;
            linkSelections.add(linkID);
        }
        ExternalSelectionChangeEvent ce = new ExternalSelectionChangeEvent(genomeKey, selectedNodes, linkSelections);
        return ce;
    }

    private static class MaskData {
        Set nonBlackHoles;
        HashMap labelViz = new HashMap();
        HashSet candidates;

        MaskData() {
        }
    }

    public static class RunningMove {
        public static final int LINK_LABEL = 1;
        public static final int MODEL_DATA = 2;
        public static final int INTERSECTIONS = 3;
        public static final int NET_MODULE_EDGE = 4;
        public static final int NET_MODULE_WHOLE = 5;
        public static final int NET_MODULE_NAME = 6;
        public static final int NET_MODULE_LINK = 7;
        public boolean notPermitted;
        public String linkID;
        public String modelKey;
        public String ovrId;
        public Intersection modIntersect;
        public Intersection[] toMove;
        public int type;
        public Point2D start;
        public int augInterType;

        public RunningMove(int type, Point2D start) {
            this.notPermitted = false;
            this.type = type;
            this.start = (Point2D)start.clone();
            this.augInterType = 0;
        }

        public RunningMove(int type, Point2D start, int augInter) {
            this.notPermitted = false;
            this.type = type;
            this.start = (Point2D)start.clone();
            this.augInterType = augInter;
        }

        public RunningMove() {
            this.notPermitted = true;
            this.augInterType = 0;
        }

        public void resetStart(Point2D start) {
            this.start = (Point2D)start.clone();
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("RunningMove type = ");
            buf.append(this.type);
            buf.append("start = ");
            buf.append(this.start);
            if (this.toMove != null) {
                for (int i = 0; i < this.toMove.length; ++i) {
                    buf.append(this.toMove[i]);
                    buf.append("  ");
                }
            }
            return buf.toString();
        }
    }

    public static class OpaqueOverlayInfo {
        public Rectangle viewRect;
        public BufferedImage bim;
        public Graphics2D overlayLayerG2;
        public AffineTransform drawImageTrans;

        public OpaqueOverlayInfo(Rectangle viewRect, BufferedImage bim, Graphics2D overlayLayerG2, AffineTransform drawImageTrans) {
            this.viewRect = viewRect;
            this.bim = bim;
            this.overlayLayerG2 = overlayLayerG2;
            this.drawImageTrans = drawImageTrans;
        }

        public void renderImage(Graphics2D g2) {
            AffineTransform saveTransform = g2.getTransform();
            g2.setTransform(this.drawImageTrans);
            g2.drawImage(this.bim, this.viewRect.x, this.viewRect.y, this.viewRect.width, this.viewRect.height, null);
            g2.setTransform(saveTransform);
        }
    }
}

