/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.ui.BusProperties;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LinkSegment;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.util.Pattern;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.Vector2D;

public class Grid {
    public static final int FIXED_RECTANGLE = 0;
    public static final int VARIABLE_RECTANGLE = 1;
    public static final int SINGLE_ROW = 2;
    private int numRows;
    private int numCols;
    private String[][] gridded;
    private double colSpace;
    private double rowSpace;
    private double[] colSpaceOverride;
    private double[] rowSpaceOverride;
    private String refID_;
    private Point refPt_;
    private Map topoSort_;

    public Grid(String[] positions, Dimension size, int layoutMode) {
        if (layoutMode == 0) {
            int numPos = positions.length;
            double blocks = (double)numPos / 12.0;
            double scale = Math.sqrt(blocks);
            this.numCols = (int)Math.round(scale * 4.0);
            this.numRows = (int)Math.ceil((double)numPos / (double)this.numCols);
            int count = 0;
            this.gridded = new String[this.numRows][];
            for (int i = 0; i < this.numRows; ++i) {
                int diff = numPos - count;
                int localCols = diff >= this.numCols ? this.numCols : diff;
                this.gridded[i] = new String[localCols];
                for (int j = 0; j < localCols; ++j) {
                    this.gridded[i][j] = positions[count++];
                }
            }
            this.colSpace = (double)size.width / (double)this.numCols;
            this.colSpace = (double)Math.round(this.colSpace / 10.0) * 10.0;
            this.rowSpace = (double)size.height / (double)this.numRows + 50.0;
            this.rowSpace = (double)Math.round(this.rowSpace / 10.0) * 10.0;
        } else if (layoutMode == 1) {
            int numPos = positions.length;
            double blocks = (double)numPos / 12.0;
            double scale = Math.sqrt(blocks);
            this.numCols = (int)Math.round(scale * 4.0);
            this.numRows = (int)Math.ceil((double)numPos / (double)this.numCols);
            int count = 0;
            this.gridded = new String[this.numRows][];
            for (int i = 0; i < this.numRows; ++i) {
                int diff = numPos - count;
                int localCols = diff >= this.numCols ? this.numCols : diff;
                this.gridded[i] = new String[localCols];
                for (int j = 0; j < localCols; ++j) {
                    this.gridded[i][j] = positions[count++];
                }
            }
            this.colSpace = 250.0;
            this.rowSpace = 300.0;
        } else {
            int numPos;
            this.numCols = numPos = positions.length;
            this.numRows = 1;
            this.gridded = new String[1][];
            this.gridded[0] = new String[numPos];
            for (int j = 0; j < numPos; ++j) {
                this.gridded[0][j] = positions[j];
            }
            this.colSpace = 250.0;
            this.rowSpace = 300.0;
        }
    }

    public Grid(String[][] positions, String refID, Point refPt, Map topoSort) {
        int maxRows = -1;
        for (int i = 0; i < positions.length; ++i) {
            if (positions[i].length <= maxRows) continue;
            maxRows = positions[i].length;
        }
        if (maxRows == -1) {
            this.numRows = 0;
            this.numCols = 0;
        } else {
            this.numRows = maxRows;
            this.numCols = positions.length;
        }
        boolean count = false;
        this.gridded = new String[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                this.gridded[i][j] = i > positions[j].length ? null : positions[j][i];
            }
        }
        this.colSpace = 250.0;
        this.rowSpace = 300.0;
        this.refID_ = refID;
        this.refPt_ = refPt;
        this.topoSort_ = topoSort;
    }

    public Map getTopoSort() {
        return this.topoSort_;
    }

    public String getReferenceID() {
        return this.refID_;
    }

    public Point getReferencePoint() {
        return this.refPt_;
    }

    public String getCellValue(int row, int col) {
        return this.gridded[row][col];
    }

    public void setCellValue(int row, int col, String newVal) {
        this.gridded[row][col] = newVal;
    }

    public int getNumCols() {
        return this.numCols;
    }

    public int getNumRows() {
        return this.numRows;
    }

    public double getColSpace() {
        return this.colSpace;
    }

    public double getRowSpace() {
        return this.rowSpace;
    }

    public void setRowSpace(double rowSpace) {
        this.rowSpace = rowSpace;
    }

    public void overrideColSpace(int col, double space) {
        if (this.colSpaceOverride == null) {
            this.colSpaceOverride = new double[this.numCols];
            for (int i = 0; i < this.numCols; ++i) {
                this.colSpaceOverride[i] = this.colSpace;
            }
        }
        this.colSpaceOverride[col] = space = (double)Math.round(space / 10.0) * 10.0;
    }

    public boolean columnIsEmpty(int col) {
        for (int i = 0; i < this.numRows; ++i) {
            if (this.gridded[i][col] == null) continue;
            return false;
        }
        return true;
    }

    public void overrideRowSpace(int row, double space) {
        if (this.rowSpaceOverride == null) {
            this.rowSpaceOverride = new double[this.numRows];
            for (int i = 0; i < this.numCols; ++i) {
                this.rowSpaceOverride[i] = this.rowSpace;
            }
        }
        this.rowSpaceOverride[row] = space = (double)Math.round(space / 10.0) * 10.0;
    }

    public boolean rowIsEmpty(int row) {
        for (int i = 0; i < this.numCols; ++i) {
            if (this.gridded[row][i] == null) continue;
            return false;
        }
        return true;
    }

    public void dropRow(int row) {
        String[][] replacement = new String[this.numRows - 1][];
        int count = 0;
        for (int i = 0; i < this.numRows; ++i) {
            if (i == row) continue;
            replacement[count++] = this.gridded[i];
        }
        --this.numRows;
        this.gridded = replacement;
    }

    public Dimension getSizeEstimate() {
        return new Dimension((int)((double)this.numCols * this.colSpace), (int)((double)this.numRows * this.rowSpace));
    }

    public boolean isEmpty() {
        return this.numCols * this.numRows == 0;
    }

    public RowAndColumn getRowAndColumn(int i) {
        int col = i % this.numCols;
        int row = i / this.numCols;
        return new RowAndColumn(row, col);
    }

    public int findPosition(String srcID) {
        int myPos = -1;
        block0: for (int i = 0; i < this.gridded.length; ++i) {
            for (int j = 0; j < this.gridded[i].length; ++j) {
                if (this.gridded[i][j] == null || !this.gridded[i][j].equals(srcID)) continue;
                myPos = i * this.gridded[i].length + j;
                continue block0;
            }
        }
        if (myPos == -1) {
            throw new IllegalStateException();
        }
        return myPos;
    }

    public boolean contains(String srcID) {
        for (int i = 0; i < this.gridded.length; ++i) {
            for (int j = 0; j < this.gridded[i].length; ++j) {
                if (this.gridded[i][j] == null || !this.gridded[i][j].equals(srcID)) continue;
                return true;
            }
        }
        return false;
    }

    public RowAndColumn findPositionRandC(String srcID) {
        for (int i = 0; i < this.gridded.length; ++i) {
            for (int j = 0; j < this.gridded[i].length; ++j) {
                if (this.gridded[i][j] == null || !this.gridded[i][j].equals(srcID)) continue;
                return new RowAndColumn(i, j);
            }
        }
        System.err.println("Failing to find " + srcID + " in the grid");
        return new RowAndColumn(0, 0);
    }

    public Point2D getGridLocation(int row, int col, Point2D corner) {
        int i;
        int firstNonZero;
        if (this.getCellValue(row, col) == null) {
            return null;
        }
        Point2D.Double loc = new Point2D.Double();
        double x = corner.getX();
        double y = corner.getY();
        if (this.colSpaceOverride == null || this.colSpaceOverride.length == 0) {
            x += this.getColSpace() * ((double)col + 0.5);
        } else {
            firstNonZero = Integer.MIN_VALUE;
            for (i = 0; i < col; ++i) {
                x += this.colSpaceOverride[i];
                if (this.colSpaceOverride[i] == 0.0 || firstNonZero != Integer.MIN_VALUE) continue;
                firstNonZero = i;
            }
            if (firstNonZero == Integer.MIN_VALUE) {
                firstNonZero = col;
            }
            x += this.colSpaceOverride[firstNonZero] / 2.0;
        }
        if (this.rowSpaceOverride == null || this.rowSpaceOverride.length == 0) {
            y += this.getRowSpace() * ((double)row + 0.5);
        } else {
            firstNonZero = Integer.MIN_VALUE;
            for (i = 0; i < row; ++i) {
                y += this.rowSpaceOverride[i];
                if (this.rowSpaceOverride[i] == 0.0 || firstNonZero != Integer.MIN_VALUE) continue;
                firstNonZero = i;
            }
            if (firstNonZero == Integer.MIN_VALUE) {
                firstNonZero = row;
            }
            y += this.rowSpaceOverride[firstNonZero] / 2.0;
        }
        UiUtil.forceToGrid(x, y, loc, 10.0);
        return loc;
    }

    public Point2D getGridLocation(String srcID, Point2D corner) {
        for (int col = 0; col < this.numCols; ++col) {
            for (int row = 0; row < this.numRows; ++row) {
                String cellVal = this.getCellValue(row, col);
                if (cellVal == null || !cellVal.equals(srcID)) continue;
                return this.getGridLocation(row, col, corner);
            }
        }
        return null;
    }

    public double getWidth() {
        if (this.colSpaceOverride == null) {
            return this.colSpace * (double)this.numCols;
        }
        double w = 0.0;
        for (int i = 0; i < this.numCols; ++i) {
            w += this.colSpaceOverride[i];
        }
        return w;
    }

    public double getHeight() {
        if (this.rowSpaceOverride == null) {
            return this.rowSpace * (double)this.numRows;
        }
        double h = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            h += this.rowSpaceOverride[i];
        }
        return h;
    }

    public Pattern buildPattern() {
        Pattern pat = new Pattern((int)Math.round(this.getWidth() / 10.0), (int)Math.round(this.getHeight() / 10.0));
        int currY = 0;
        for (int i = 0; i < this.numRows; ++i) {
            double dHeight = this.rowSpaceOverride == null ? this.rowSpace : this.rowSpaceOverride[i];
            int height = (int)Math.round(dHeight / 10.0);
            int currX = 0;
            for (int j = 0; j < this.numCols; ++j) {
                String gridVal = this.gridded[i][j];
                double dWidth = this.colSpaceOverride == null ? this.colSpace : this.colSpaceOverride[j];
                int width = (int)Math.round(dWidth / 10.0);
                if (gridVal != null) {
                    for (int k = 0; k < width; ++k) {
                        for (int m = 0; m < height; ++m) {
                            pat.fill(currX + k, currY + m, gridVal);
                        }
                    }
                }
                currX += width;
            }
            currY += height;
        }
        return pat;
    }

    public GridBounds buildBounds(Genome genome, Layout layout, String srcID, int srcPos, Set linkSet) {
        RowAndColumn rac = this.getRowAndColumn(srcPos);
        GridBounds retval = new GridBounds(rac);
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            if (linkSet != null && !linkSet.contains(link.getID()) || !link.getSource().equals(srcID)) continue;
            String trgID = link.getTarget();
            for (int i = 0; i < this.numRows; ++i) {
                int localCols = this.gridded[i].length;
                for (int j = 0; j < localCols; ++j) {
                    if (!trgID.equals(this.gridded[i][j])) continue;
                    retval.addTarget(i, j, link.getID(), link.getLandingPad());
                }
            }
        }
        return retval;
    }

    public String splitLinksUp(RowData targRD, int step, int srcRow, Genome genome, Layout layout, HashMap splitPoints, FontRenderContext frc, int colNum, SlotTracker tracker, GridBounds bounds) {
        boolean oppLowerFirst;
        boolean lowerFirst;
        Set oppKeys;
        TreeMap oppTargs;
        Set keys;
        TreeMap targs;
        String targLink = targRD.getLowestLink();
        String oppLink = targRD.getHighestLink();
        if (targLink == null) {
            targLink = oppLink;
            oppLink = null;
            targs = targRD.higherTargets;
            keys = targs.keySet();
            oppTargs = null;
            oppKeys = null;
            lowerFirst = true;
            oppLowerFirst = false;
        } else if (oppLink == null) {
            targs = targRD.lowerTargets;
            keys = new TreeSet(Collections.reverseOrder());
            keys.addAll(targs.keySet());
            oppTargs = null;
            oppKeys = null;
            lowerFirst = false;
            oppLowerFirst = false;
        } else {
            targs = targRD.lowerTargets;
            keys = new TreeSet(Collections.reverseOrder());
            keys.addAll(targs.keySet());
            oppTargs = targRD.higherTargets;
            oppKeys = oppTargs.keySet();
            lowerFirst = false;
            oppLowerFirst = true;
        }
        this.doRiserSplits(srcRow, targRD.rowNum, step, genome, layout, targLink, splitPoints, this.rowSpace, colNum, tracker, frc, bounds);
        this.doRunnerSplits(genome, layout, targLink, targs, keys, frc, targRD.rowNum, srcRow, this.rowSpace, tracker, lowerFirst);
        if (oppLink != null) {
            this.relocToRiser(splitPoints, targRD.rowNum, layout, oppLink);
            this.doRunnerSplits(genome, layout, oppLink, oppTargs, oppKeys, frc, targRD.rowNum, srcRow, this.rowSpace, tracker, oppLowerFirst);
        }
        return targLink;
    }

    public void reattachMiddleLinks(HashMap splitPoints, RowData targRD, Genome genome, Layout layout, FontRenderContext frc, int rowNum, int srcRow, double rowSpace, SlotTracker tracker) {
        boolean oppLowerFirst;
        boolean lowerFirst;
        Set oppKeys;
        TreeMap oppTargs;
        Set keys;
        TreeMap targs;
        String targLink = targRD.getLowestLink();
        String oppLink = targRD.getHighestLink();
        if (targLink == null) {
            targLink = oppLink;
            oppLink = null;
            targs = targRD.higherTargets;
            keys = targs.keySet();
            oppTargs = null;
            oppKeys = null;
            lowerFirst = true;
            oppLowerFirst = false;
        } else if (oppLink == null) {
            targs = targRD.lowerTargets;
            keys = new TreeSet(Collections.reverseOrder());
            keys.addAll(targs.keySet());
            oppTargs = null;
            oppKeys = null;
            lowerFirst = false;
            oppLowerFirst = false;
        } else {
            targs = targRD.lowerTargets;
            keys = new TreeSet(Collections.reverseOrder());
            keys.addAll(targs.keySet());
            oppTargs = targRD.higherTargets;
            oppKeys = oppTargs.keySet();
            lowerFirst = false;
            oppLowerFirst = true;
        }
        this.relocToRiser(splitPoints, targRD.rowNum, layout, targLink);
        this.doRunnerSplits(genome, layout, targLink, targs, keys, frc, targRD.rowNum, srcRow, rowSpace, tracker, lowerFirst);
        if (oppLink != null) {
            this.relocToRiser(splitPoints, targRD.rowNum, layout, oppLink);
            this.doRunnerSplits(genome, layout, oppLink, oppTargs, oppKeys, frc, targRD.rowNum, srcRow, rowSpace, tracker, oppLowerFirst);
        }
    }

    public void doRiserSplits(int startRow, int endRow, int step, Genome genome, Layout lo, String targLink, HashMap splitPoints, double rowSpace, int colNum, SlotTracker tracker, FontRenderContext frc, GridBounds bounds) {
        BusProperties lp;
        Linkage maxLink = genome.getLinkage(targLink);
        BusProperties bp = lp = lo.getLinkProperties(targLink);
        NodeProperties srcProp = lo.getNodeProperties(maxLink.getSource());
        Point2D srcLoc = srcProp.getLocation();
        int loopStart = step == 1 ? startRow + 1 : startRow;
        int loopEnd = endRow + step;
        for (int i = loopStart; i != loopEnd; i += step) {
            if (bounds.getRowData(i) == null) continue;
            this.doRiserSplit(splitPoints, targLink, maxLink, i, startRow, genome, lo, rowSpace, bp, srcLoc, colNum, tracker, frc);
        }
    }

    public void doRiserSplit(HashMap splitPoints, String targLinkID, Linkage targLink, int row, int startRow, Genome genome, Layout lo, double rowSpace, BusProperties bp, Point2D srcLoc, int colNum, SlotTracker tracker, FontRenderContext frc) {
        LinkSegmentID segID = bp.isDirect() ? LinkSegmentID.buildIDForDirect(targLinkID) : LinkSegmentID.buildIDForDrop(targLinkID);
        double riserY = this.calcRiserY(targLink, row, startRow, genome, lo, rowSpace, tracker, frc);
        int lpad = targLink.getLaunchPad();
        Vector2D colDelt = new Vector2D(10.0, 0.0);
        String src = targLink.getSource();
        int slotNum = tracker.getColSlotForSource(colNum, src);
        colDelt.scale((double)slotNum + 2.0);
        NodeProperties np = lo.getNodeProperties(src);
        Node node = genome.getNode(src);
        Vector2D lpo = np.getRenderer().getLaunchPadOffset(lpad, node, lo, frc);
        Point2D xCalc = lpo.add(colDelt.add(srcLoc));
        Point2D.Double split = new Point2D.Double(xCalc.getX(), riserY);
        UiUtil.forceToGrid(((Point2D)split).getX(), ((Point2D)split).getY(), split, 10.0);
        lo.splitBusLink(segID, split, bp, null);
        splitPoints.put(new Integer(row), split);
    }

    public double calcRiserY(Linkage targLink, int row, int startRow, Genome genome, Layout lo, double rowSpace, SlotTracker tracker, FontRenderContext frc) {
        Vector2D rowDelt = new Vector2D(0.0, rowSpace);
        rowDelt.scale(row - startRow);
        String src = targLink.getSource();
        Vector2D rowOffDelt = new Vector2D(0.0, -10.0);
        int slotNum = tracker.getRowSlotForSource(row, src);
        rowOffDelt.scale((double)slotNum + 2.0);
        NodeProperties np = lo.getNodeProperties(src);
        Point2D srcLoc = np.getLocation();
        Node node = genome.getNode(src);
        int lPad = targLink.getLaunchPad();
        Vector2D lpo = np.getRenderer().getLaunchPadOffset(lPad, node, lo, frc);
        Point2D split = lpo.add(rowOffDelt.add(rowDelt.add(srcLoc)));
        Point2D.Double forced = new Point2D.Double();
        UiUtil.forceToGrid(split.getX(), split.getY(), forced, 10.0);
        return ((Point2D)forced).getY();
    }

    public void doRunnerSplits(Genome genome, Layout lo, String targLinkID, Map targs, Set keys, FontRenderContext frc, int rowNum, int startRow, double rowSpace, SlotTracker tracker, boolean lowerFirst) {
        BusProperties lp;
        BusProperties bp = lp = lo.getLinkProperties(targLinkID);
        Iterator kit = keys.iterator();
        while (kit.hasNext()) {
            TreeMap linkIDs = (TreeMap)targs.get(kit.next());
            TreeSet padkeys = !lowerFirst ? new TreeSet(Collections.reverseOrder()) : new TreeSet();
            padkeys.addAll(linkIDs.keySet());
            Iterator lidit = padkeys.iterator();
            while (lidit.hasNext()) {
                Integer padNum = (Integer)lidit.next();
                String linkID = (String)linkIDs.get(padNum);
                this.doRunnerSplit(genome, lo, targLinkID, linkID, bp, frc, rowNum, startRow, tracker, rowSpace);
            }
        }
    }

    public void doRunnerSplit(Genome genome, Layout lo, String targLinkID, String linkID, BusProperties bp, FontRenderContext frc, int rowNum, int startRow, SlotTracker tracker, double rowSpace) {
        LinkSegmentID segID = LinkSegmentID.buildIDForDrop(targLinkID);
        Linkage targLink = genome.getLinkage(targLinkID);
        double riserY = this.calcRiserY(targLink, rowNum, startRow, genome, lo, rowSpace, tracker, frc);
        Linkage link = genome.getLinkage(linkID);
        Node node = genome.getNode(link.getTarget());
        NodeProperties np = lo.getNodeProperties(link.getTarget());
        Point2D genePoint = np.getLocation();
        Vector2D lpo = np.getRenderer().getLandingPadOffset(link.getLandingPad(), node, link.getSign(), lo, frc);
        Vector2D lpox = new Vector2D(lpo.getX(), 0.0);
        Vector2D offset = new Vector2D(0.0, -10.0);
        int slotNum = tracker.getRowSlotForSource(rowNum, link.getSource());
        offset.scale((double)slotNum + 2.0);
        Point2D xCalc = offset.add(lpox.add(genePoint));
        Point2D.Double split = new Point2D.Double(xCalc.getX(), riserY);
        UiUtil.forceToGrid(((Point2D)split).getX(), ((Point2D)split).getY(), split, 10.0);
        lo.splitBusLink(segID, split, bp, null);
        Iterator sit = bp.getSegments();
        LinkSegmentID dropID = LinkSegmentID.buildIDForDrop(linkID);
        while (sit.hasNext()) {
            LinkSegment ls = (LinkSegment)sit.next();
            Point2D end = ls.getEnd();
            if (end == null || !end.equals(split)) continue;
            LinkSegmentID relocSeg = LinkSegmentID.buildIDForSegment(ls.getID());
            relocSeg.tagIDWithEndpoint("E");
            lo.relocateSegmentOnTree(bp, relocSeg, dropID, null);
            break;
        }
    }

    public void relocToRiser(HashMap splitPoints, int rowNum, Layout lo, String linkID) {
        BusProperties bp = lo.getLinkProperties(linkID);
        LinkSegmentID dropID = LinkSegmentID.buildIDForDrop(linkID);
        Point2D reloc = (Point2D)splitPoints.get(new Integer(rowNum));
        Iterator sit = bp.getSegments();
        while (sit.hasNext()) {
            LinkSegment ls = (LinkSegment)sit.next();
            Point2D end = ls.getEnd();
            if (end == null || !end.equals(reloc)) continue;
            LinkSegmentID relocSeg = LinkSegmentID.buildIDForSegment(ls.getID());
            relocSeg.tagIDWithEndpoint("E");
            lo.relocateSegmentOnTree(bp, relocSeg, dropID, null);
            break;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("numRows = " + this.numRows);
        buf.append(" numCols = " + this.numCols);
        buf.append("\n");
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                buf.append("grid: " + i + " " + j + " = " + this.gridded[i][j]);
                buf.append("\n");
            }
        }
        buf.append("colSpace = " + this.colSpace);
        buf.append(" rowSpace = " + this.rowSpace);
        buf.append(" refID = " + this.refID_);
        buf.append(" refPt = " + this.refPt_);
        return buf.toString();
    }

    private static class SlotData {
        int track;
        String src;
        int slot;

        SlotData(int track, String src, int slot) {
            this.track = track;
            this.src = src;
            this.slot = slot;
        }
    }

    public static class RowData {
        int rowNum;
        int minColumn;
        int maxColumn;
        TreeMap lowerTargets;
        TreeMap higherTargets;

        RowData(int rowNum) {
            this.rowNum = rowNum;
            this.lowerTargets = new TreeMap();
            this.higherTargets = new TreeMap();
            this.minColumn = Integer.MAX_VALUE;
            this.maxColumn = -1;
        }

        String getHighestLink() {
            if (this.higherTargets.size() == 0) {
                return null;
            }
            TreeMap targs = (TreeMap)this.higherTargets.get(this.higherTargets.lastKey());
            return (String)targs.get(targs.lastKey());
        }

        String getLowestLink() {
            if (this.lowerTargets.size() == 0) {
                return null;
            }
            TreeMap targs = (TreeMap)this.lowerTargets.get(this.lowerTargets.firstKey());
            return (String)targs.get(targs.firstKey());
        }
    }

    public static class SlotTracker {
        HashMap[] rowData;
        HashMap[] colData;

        SlotTracker(Grid grid) {
            this.rowData = new HashMap[grid.numRows];
            this.colData = new HashMap[grid.numCols];
        }

        int getRowSlotForSource(int row, String source) {
            return this.getTrackSlotForSource(this.rowData, row, source);
        }

        int getColSlotForSource(int col, String source) {
            return this.getTrackSlotForSource(this.colData, col, source);
        }

        private int getTrackSlotForSource(HashMap[] maps, int track, String source) {
            SlotData sd;
            HashMap<String, SlotData> map = maps[track];
            if (map == null) {
                maps[track] = map = new HashMap<String, SlotData>();
            }
            if ((sd = (SlotData)map.get(source)) == null) {
                int nextSlot = -1;
                Iterator sdit = map.values().iterator();
                while (sdit.hasNext()) {
                    SlotData csd = (SlotData)sdit.next();
                    if (csd.slot <= nextSlot) continue;
                    nextSlot = csd.slot;
                }
                sd = new SlotData(track, source, nextSlot + 1);
                map.put(source, sd);
            }
            return sd.slot;
        }
    }

    public static class GridBounds {
        TreeMap rows;
        int srcCol;
        int srcRow;

        GridBounds(RowAndColumn rac) {
            this.srcCol = rac.col;
            this.srcRow = rac.row;
            this.rows = new TreeMap();
        }

        RowData getRowData(int row) {
            return (RowData)this.rows.get(new Integer(row));
        }

        void addRowData(RowData data) {
            this.rows.put(new Integer(data.rowNum), data);
        }

        boolean noTargets() {
            return this.rows.isEmpty();
        }

        RowData getMinRowData() {
            return (RowData)this.rows.get(this.rows.firstKey());
        }

        RowData getMaxRowData() {
            return (RowData)this.rows.get(this.rows.lastKey());
        }

        void addTarget(int row, int col, String linkID, int padNum) {
            TreeMap targMap;
            Integer colObj;
            RowData rd = (RowData)this.rows.get(new Integer(row));
            if (rd == null) {
                rd = new RowData(row);
                this.addRowData(rd);
            }
            if (col < rd.minColumn) {
                rd.minColumn = col;
            }
            if (col > rd.maxColumn) {
                rd.maxColumn = col;
            }
            if (col <= this.srcCol) {
                colObj = new Integer(col);
                targMap = (TreeMap)rd.lowerTargets.get(colObj);
                if (targMap == null) {
                    targMap = new TreeMap();
                    rd.lowerTargets.put(new Integer(col), targMap);
                }
                targMap.put(new Integer(padNum), linkID);
            }
            if (col > this.srcCol) {
                colObj = new Integer(col);
                targMap = (TreeMap)rd.higherTargets.get(colObj);
                if (targMap == null) {
                    targMap = new TreeMap();
                    rd.higherTargets.put(new Integer(col), targMap);
                }
                targMap.put(new Integer(padNum), linkID);
            }
        }
    }

    public static class RowAndColumn {
        public int row;
        public int col;

        RowAndColumn(int row, int col) {
            this.row = row;
            this.col = col;
        }

        public String toString() {
            return "RandC row = " + this.row + " col = " + this.col;
        }
    }
}

