/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Vector;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.util.ChoiceContent;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.xml.sax.Attributes;

public class GroupProperties {
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int AUTOBOUND = 0;
    public static final int MAX_SUBGROUP_LAYER = 10;
    public static final int SHOW_LABEL = 0;
    public static final int HIDE_LABEL_ALL_LEVELS = 1;
    public static final int HIDE_LABEL_TOP_LEVEL_ONLY = 2;
    private static final int NUM_LABEL_MODES_ = 3;
    public static final String SHOW_LABEL_TAG = "showLabel";
    public static final String HIDE_LABEL_ALL_LEVELS_TAG = "hideLabel";
    public static final String HIDE_LABEL_TOP_LEVEL_ONLY_TAG = "hideLabelTopOnly";
    private int layer_;
    private int order_;
    private int style_;
    private String groupID_;
    private int[] pads_;
    private String colorTag_;
    private String inactiveColorTag_;
    private String styleTag_;
    private Point2D labelLocation_;
    private boolean hideLabel_;
    private boolean hideLabelTopOnly_;
    private ArrayList hideInModels_;

    public GroupProperties(int count, String ref, Point2D groupCenter, int order) {
        this(count, ref, null, groupCenter, order);
    }

    public GroupProperties(int count, String ref, Layout layout, Point2D groupCenter, int order) {
        this(ref, groupCenter, order, Database.getDB().activeColorCycle(count), Database.getDB().inactiveColorCycle(count));
    }

    public GroupProperties(String ref, Point2D groupCenter, int order, String activeColor, String inactiveColor) {
        Database db = Database.getDB();
        this.colorTag_ = activeColor;
        this.inactiveColorTag_ = inactiveColor;
        this.style_ = 0;
        this.layer_ = 0;
        this.order_ = order;
        this.pads_ = new int[]{30, 30, 30, 30};
        this.labelLocation_ = (Point2D)groupCenter.clone();
        this.styleTag_ = "autobound";
        this.groupID_ = ref;
        this.hideLabel_ = false;
        this.hideLabelTopOnly_ = false;
        this.hideInModels_ = new ArrayList();
    }

    public GroupProperties(String ref, Layout layout, int layer, Point2D labelLoc, int order) {
        Database db = Database.getDB();
        this.colorTag_ = db.distinctActiveColor();
        this.inactiveColorTag_ = db.distinctInactiveColor();
        this.style_ = 0;
        this.layer_ = layer;
        this.order_ = order;
        this.pads_ = new int[]{30, 30, 30, 30};
        this.labelLocation_ = (Point2D)labelLoc.clone();
        this.styleTag_ = "autobound";
        this.groupID_ = ref;
        this.hideLabel_ = false;
        this.hideLabelTopOnly_ = false;
        this.hideInModels_ = new ArrayList();
    }

    public GroupProperties(GroupProperties other) {
        this.layer_ = other.layer_;
        this.order_ = other.order_;
        this.style_ = other.style_;
        this.groupID_ = other.groupID_;
        this.pads_ = new int[4];
        System.arraycopy(other.pads_, 0, this.pads_, 0, 4);
        this.colorTag_ = other.colorTag_;
        this.inactiveColorTag_ = other.inactiveColorTag_;
        this.styleTag_ = other.styleTag_;
        if (other.labelLocation_ != null) {
            this.labelLocation_ = (Point2D)other.labelLocation_.clone();
        }
        this.hideLabel_ = other.hideLabel_;
        this.hideLabelTopOnly_ = other.hideLabelTopOnly_;
        this.hideInModels_ = (ArrayList)other.hideInModels_.clone();
    }

    public GroupProperties(String newID, int newOrder, GroupProperties other) {
        this.layer_ = other.layer_;
        this.order_ = newOrder;
        this.style_ = other.style_;
        this.groupID_ = newID;
        this.pads_ = new int[4];
        System.arraycopy(other.pads_, 0, this.pads_, 0, 4);
        this.colorTag_ = other.colorTag_;
        this.inactiveColorTag_ = other.inactiveColorTag_;
        this.styleTag_ = other.styleTag_;
        if (other.labelLocation_ != null) {
            this.labelLocation_ = (Point2D)other.labelLocation_.clone();
        }
        this.hideLabel_ = other.hideLabel_;
        this.hideLabelTopOnly_ = other.hideLabelTopOnly_;
        this.hideInModels_ = (ArrayList)other.hideInModels_.clone();
    }

    public GroupProperties(Layout layout, String ref, String color, String inactiveColorStr, String style, String layer, String tpad, String bpad, String lpad, String rpad, String nameX, String nameY, String order, String hideStr, String hideStrTopOnly) throws IOException {
        if (style == null) {
            style = "autobound";
            this.style_ = 0;
        } else if ((style = style.trim()).equals("")) {
            this.style_ = 0;
        } else if (style.equalsIgnoreCase("autobound")) {
            this.style_ = 0;
        } else {
            throw new IOException();
        }
        this.pads_ = new int[4];
        try {
            this.order_ = Integer.parseInt(order);
            this.layer_ = Integer.parseInt(layer);
            this.pads_[2] = Integer.parseInt(lpad);
            this.pads_[3] = Integer.parseInt(rpad);
            this.pads_[0] = Integer.parseInt(tpad);
            this.pads_[1] = Integer.parseInt(bpad);
        }
        catch (NumberFormatException nfe) {
            throw new IOException();
        }
        if (nameX != null && nameY != null) {
            try {
                double x = Double.parseDouble(nameX);
                double y = Double.parseDouble(nameY);
                this.labelLocation_ = new Point2D.Double(x, y);
            }
            catch (NumberFormatException nfe) {
                throw new IOException();
            }
        }
        this.colorTag_ = color;
        this.inactiveColorTag_ = inactiveColorStr;
        this.styleTag_ = style;
        this.groupID_ = ref;
        this.hideLabel_ = Boolean.valueOf(hideStr);
        this.hideLabelTopOnly_ = Boolean.valueOf(hideStrTopOnly);
        this.hideInModels_ = new ArrayList();
    }

    public String getReference() {
        return this.groupID_;
    }

    public Color getColor(boolean isActive) {
        return Database.getDB().getColor(isActive ? this.colorTag_ : this.inactiveColorTag_);
    }

    public String getColorTag(boolean isActive) {
        return isActive ? this.colorTag_ : this.inactiveColorTag_;
    }

    public void setColor(boolean isActive, String colorTag) {
        if (isActive) {
            this.colorTag_ = colorTag;
        } else {
            this.inactiveColorTag_ = colorTag;
        }
    }

    public boolean replaceColor(String oldID, String newID) {
        boolean retval = false;
        if (this.colorTag_.equals(oldID)) {
            this.colorTag_ = newID;
            retval = true;
        }
        if (this.inactiveColorTag_.equals(oldID)) {
            this.inactiveColorTag_ = newID;
            retval = true;
        }
        return retval;
    }

    public int getStyle() {
        return this.style_;
    }

    public int getLayer() {
        return this.layer_;
    }

    public void setLayer(int layer) {
        this.layer_ = layer;
    }

    public int getOrder() {
        return this.order_;
    }

    public void setOrder(int order) {
        this.order_ = order;
    }

    public int getPadding(int which) {
        return this.pads_[which];
    }

    public void setPadding(int which, int pad) {
        this.pads_[which] = pad;
    }

    public int getHideLabelMode() {
        if (!this.hideLabel_) {
            return 0;
        }
        if (this.hideLabel_ && this.hideLabelTopOnly_) {
            return 2;
        }
        if (this.hideLabel_ && !this.hideLabelTopOnly_) {
            return 1;
        }
        throw new IllegalStateException();
    }

    public void setHideLabel(int hideLabelMode) {
        switch (hideLabelMode) {
            case 0: {
                this.hideLabel_ = false;
                this.hideLabelTopOnly_ = false;
                break;
            }
            case 2: {
                this.hideLabel_ = true;
                this.hideLabelTopOnly_ = true;
                break;
            }
            case 1: {
                this.hideLabel_ = true;
                this.hideLabelTopOnly_ = false;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public Point2D getLabelLocation() {
        return this.labelLocation_;
    }

    public void setLabelLocation(Point2D newLoc) {
        this.labelLocation_ = (Point2D)newLoc.clone();
    }

    public GroupOrdering getGroupOrdering() {
        return new GroupOrdering(this.order_, this.layer_, this.groupID_);
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        int numHides;
        ind.indent();
        out.print("<gprop");
        out.print(" id=\"");
        out.print(this.groupID_);
        out.print("\" color=\"");
        out.print(this.colorTag_);
        out.print("\" inactiveColor=\"");
        out.print(this.inactiveColorTag_);
        out.print("\" style=\"");
        out.print(this.styleTag_);
        out.print("\" layer=\"");
        out.print(this.layer_);
        out.print("\" order=\"");
        out.print(this.order_);
        out.print("\" tpad=\"");
        out.print(this.pads_[0]);
        out.print("\" bpad=\"");
        out.print(this.pads_[1]);
        out.print("\" lpad=\"");
        out.print(this.pads_[2]);
        out.print("\" rpad=\"");
        out.print(this.pads_[3]);
        if (this.labelLocation_ != null) {
            out.print("\" nameX=\"");
            out.print(this.labelLocation_.getX());
            out.print("\" nameY=\"");
            out.print(this.labelLocation_.getY());
        }
        if (this.hideLabel_) {
            out.print("\" hideName=\"true");
        }
        if (this.hideLabelTopOnly_) {
            out.print("\" hideNameTopOnly=\"true");
        }
        if ((numHides = this.hideInModels_.size()) == 0) {
            out.println("\" />");
        } else {
            out.println("\" >");
            ind.up().indent();
            out.println("<groupMaskings>");
            ind.up();
            for (int i = 0; i < numHides; ++i) {
                ind.indent();
                out.print("<groupMask id=\"");
                out.print(this.hideInModels_.get(i));
                out.println("\" />");
            }
            ind.down().indent();
            out.println("</groupMaskings>");
            ind.down().indent();
            out.println("</gprop>");
        }
    }

    public static String keywordOfInterest() {
        return "gprop";
    }

    public static GroupProperties buildFromXML(Layout layout, Attributes attrs) throws IOException {
        String ref = null;
        String color = null;
        String inactive = null;
        String style = null;
        String layer = null;
        String order = "0";
        String lpad = "0";
        String bpad = "0";
        String rpad = "0";
        String tpad = "0";
        String nameX = null;
        String nameY = null;
        String hideStr = "false";
        String hideStrTopOnly = "false";
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("id")) {
                    ref = val;
                    continue;
                }
                if (key.equals("color")) {
                    color = val;
                    continue;
                }
                if (key.equals("inactiveColor")) {
                    inactive = val;
                    continue;
                }
                if (key.equals("style")) {
                    style = val;
                    continue;
                }
                if (key.equals("layer")) {
                    layer = val;
                    continue;
                }
                if (key.equals("order")) {
                    order = val;
                    continue;
                }
                if (key.equals("nameX")) {
                    nameX = val;
                    continue;
                }
                if (key.equals("nameY")) {
                    nameY = val;
                    continue;
                }
                if (key.equals("tpad")) {
                    tpad = val;
                    continue;
                }
                if (key.equals("bpad")) {
                    bpad = val;
                    continue;
                }
                if (key.equals("lpad")) {
                    lpad = val;
                    continue;
                }
                if (key.equals("rpad")) {
                    rpad = val;
                    continue;
                }
                if (key.equals("hideName")) {
                    hideStr = val;
                    continue;
                }
                if (!key.equals("hideNameTopOnly")) continue;
                hideStrTopOnly = val;
            }
        }
        if (ref == null || color == null || style == null || layer == null) {
            throw new IOException();
        }
        return new GroupProperties(layout, ref, color, inactive, style, layer, tpad, bpad, lpad, rpad, nameX, nameY, order, hideStr, hideStrTopOnly);
    }

    public static Vector getLabelHidingChoices() {
        Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
        for (int i = 0; i < 3; ++i) {
            retval.add(GroupProperties.labelHidingForCombo(i));
        }
        return retval;
    }

    public static ChoiceContent labelHidingForCombo(int mode) {
        ResourceManager rMan = ResourceManager.getManager();
        if (mode < 0 || mode >= 3) {
            throw new IllegalArgumentException();
        }
        return new ChoiceContent(rMan.getString("groupPropLabelHiding." + GroupProperties.mapLabelHiding(mode)), mode);
    }

    public static String mapLabelHiding(int mode) {
        switch (mode) {
            case 0: {
                return SHOW_LABEL_TAG;
            }
            case 2: {
                return HIDE_LABEL_TOP_LEVEL_ONLY_TAG;
            }
            case 1: {
                return HIDE_LABEL_ALL_LEVELS_TAG;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int mapLabelHidingTag(String showTag) {
        if (showTag.equalsIgnoreCase(SHOW_LABEL_TAG)) {
            return 0;
        }
        if (showTag.equalsIgnoreCase(HIDE_LABEL_TOP_LEVEL_ONLY_TAG)) {
            return 2;
        }
        if (showTag.equalsIgnoreCase(HIDE_LABEL_ALL_LEVELS_TAG)) {
            return 1;
        }
        throw new IllegalArgumentException();
    }

    public static class GroupOrdering
    implements Comparable {
        private int order_;
        private int layer_;
        private String grpID_;

        public GroupOrdering(int order, int layer, String grpID) {
            this.order_ = order;
            this.layer_ = layer;
            this.grpID_ = grpID;
        }

        public int hashCode() {
            return this.order_ * 10 + this.layer_ + this.grpID_.hashCode();
        }

        public String toString() {
            return "GroupOrdering: " + this.order_ + " " + this.layer_ + this.grpID_;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof GroupOrdering)) {
                return false;
            }
            GroupOrdering otherGO = (GroupOrdering)other;
            return this.order_ == otherGO.order_ && this.layer_ == otherGO.layer_ && this.grpID_.equals(otherGO.grpID_);
        }

        public int compareTo(Object o) {
            GroupOrdering other = (GroupOrdering)o;
            if (this.order_ > other.order_) {
                return 1;
            }
            if (this.order_ < other.order_) {
                return -1;
            }
            if (this.layer_ > other.layer_) {
                return 1;
            }
            if (this.layer_ < other.layer_) {
                return -1;
            }
            return this.grpID_.compareTo(other.grpID_);
        }
    }
}

