/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeItem;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.ui.IRenderer;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.NodeInsertionDirective;
import org.systemsbiology.biotapestry.util.LinkPlacementGrid;
import org.systemsbiology.biotapestry.util.MinMax;
import org.systemsbiology.biotapestry.util.PatternGrid;
import org.systemsbiology.biotapestry.util.Vector2D;

public interface INodeRenderer
extends IRenderer {
    public static final int MODULE_PADDED = 0;
    public static final int STRICT = 1;
    public static final int MEDIUM = 2;
    public static final int LAX = 3;
    public static final int LAX_FOR_ORTHO = 4;
    public static final float NEG_OFFSET = 3.0f;
    public static final float POS_OFFSET = 4.0f;

    public MinMax getSourcePadRange(GenomeItem var1);

    public MinMax getTargetPadRange(GenomeItem var1);

    public SortedSet suggestLandingPads(GenomeItem var1, Layout var2, Point2D var3);

    public SortedSet suggestLaunchPad(GenomeItem var1, Layout var2, Point2D var3);

    public double getStraightThroughOffset();

    public double getVerticalOffset();

    public Vector2D getDepartureDirection(int var1, GenomeItem var2, Layout var3);

    public Vector2D getArrivalDirection(int var1, GenomeItem var2, Layout var3);

    public Vector2D getLaunchPadOffset(int var1, GenomeItem var2, Layout var3, FontRenderContext var4);

    public Vector2D getLandingPadOffset(int var1, GenomeItem var2, int var3, Layout var4, FontRenderContext var5);

    public double getLandingPadWidth(int var1, GenomeItem var2, Layout var3, FontRenderContext var4);

    public int getFixedLaunchPadMax();

    public int getFixedLandingPadMax();

    public boolean landingPadsCanOverflow();

    public boolean sharedPadNamespaces();

    public void renderToPatternGrid(Genome var1, GenomeItem var2, Layout var3, FontRenderContext var4, PatternGrid var5);

    public void renderToPlacementGrid(Genome var1, GenomeItem var2, Layout var3, FontRenderContext var4, LinkPlacementGrid var5, Map var6, Map var7, int var8);

    public Rectangle getNonExpansionRegion(Genome var1, GenomeItem var2, Layout var3, FontRenderContext var4);

    public double getGlyphHeightForLayout(Genome var1, GenomeItem var2, Layout var3, FontRenderContext var4);

    public Rectangle2D getBoundsForLayout(Genome var1, GenomeItem var2, Layout var3, FontRenderContext var4, int var5, boolean var6, Integer var7);

    public Vector2D getLaunchPadOffsetForLayout(GenomeItem var1, Layout var2, FontRenderContext var3, int var4, Integer var5);

    public int topPadCount(int var1);

    public double getWidth(Genome var1, GenomeItem var2, Layout var3, FontRenderContext var4);

    public double getExtraLength(Node var1, Genome var2, int var3, boolean var4);

    public int getBestTopPad(GenomeItem var1, Set var2, int var3, int var4, boolean var5);

    public int getBottomPad(GenomeItem var1);

    public NodeInsertionDirective getInsertionDirective(Vector2D var1, Point2D var2);

    public int comparePads(int var1, int var2);

    public List getNearbyPads(GenomeItem var1, int var2, Layout var3);

    public Rectangle getModuleBounds(Genome var1, GenomeItem var2, Layout var3, FontRenderContext var4, int var5, Object var6);
}

