/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;

public class InstanceEngine {
    private static final double GRID_X_ = 250.0;
    private static final double GRID_Y_ = 150.0;
    private static final int MAX_ROW_ = 10;

    public Map layout(Map regions, String genomeKey) {
        Database db = Database.getDB();
        GenomeInstance gi = (GenomeInstance)db.getGenome(genomeKey);
        HashMap<String, Point2D.Double> retval = new HashMap<String, Point2D.Double>();
        int row = 0;
        int col = 0;
        Iterator reit = regions.keySet().iterator();
        while (reit.hasNext()) {
            String grKey = (String)reit.next();
            HashSet nodes = (HashSet)regions.get(grKey);
            row = 0;
            col += 2;
            Iterator nit = nodes.iterator();
            while (nit.hasNext()) {
                if (row > 10) {
                    row = 0;
                    ++col;
                }
                String nodeID = (String)nit.next();
                Point2D.Double loc = new Point2D.Double((double)col * 150.0, (double)row * 250.0);
                int instance = gi.getInstanceForNodeInGroup(nodeID, grKey);
                retval.put(GenomeItemInstance.getCombinedID(nodeID, Integer.toString(instance)), loc);
                ++row;
            }
        }
        return retval;
    }
}

