/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;
import org.systemsbiology.biotapestry.ui.freerender.MultiSubID;

public class Intersection {
    public static final int IS_NONE = 0;
    public static final int IS_GENE = 1;
    public static final int IS_NODE = 2;
    public static final int IS_LINK = 3;
    public static final int IS_NOTE = 4;
    public static final int IS_GROUP = 5;
    public static final int IS_MODULE = 6;
    public static final int IS_MODULE_LINK_TREE = 7;
    public static final int IS_OVERLAY = 8;
    private String objectID_;
    private Object subID_;
    private double distance_;
    private boolean canMerge_;
    private ArrayList padCand_;

    public Intersection(String objectID, Object subID, double distance) {
        this.objectID_ = objectID;
        this.subID_ = subID;
        this.distance_ = distance;
        this.canMerge_ = false;
        this.padCand_ = null;
    }

    public Intersection(String objectID, Object subID, double distance, boolean canMerge) {
        this.objectID_ = objectID;
        this.subID_ = subID;
        this.distance_ = distance;
        this.canMerge_ = canMerge;
        this.padCand_ = null;
    }

    public Intersection(Intersection other, Object subID) {
        this.objectID_ = other.objectID_;
        this.subID_ = subID;
        this.distance_ = other.distance_;
        this.canMerge_ = other.canMerge_;
        this.padCand_ = null;
    }

    public Intersection(String objectID, List padCand) {
        this.objectID_ = objectID;
        this.subID_ = padCand.get(0);
        this.distance_ = 0.0;
        this.canMerge_ = false;
        this.padCand_ = new ArrayList(padCand);
    }

    public Intersection(Intersection other) {
        this.objectID_ = other.objectID_;
        if (other.subID_ != null) {
            if (other.subID_ instanceof PadVal) {
                this.subID_ = new PadVal((PadVal)other.subID_);
                this.padCand_ = new ArrayList();
                int numO = other.padCand_.size();
                for (int i = 0; i < numO; ++i) {
                    this.padCand_.add(new PadVal((PadVal)other.padCand_.get(i)));
                }
            } else {
                throw new IllegalArgumentException();
            }
        }
        this.distance_ = other.distance_;
        this.canMerge_ = other.canMerge_;
    }

    public boolean canCopy() {
        return this.subID_ == null || this.subID_ instanceof PadVal;
    }

    public String getObjectID() {
        return this.objectID_;
    }

    public Object getSubID() {
        return this.subID_;
    }

    public double getDistance() {
        return this.distance_;
    }

    public List getPadCand() {
        return this.padCand_;
    }

    public boolean canMerge() {
        return this.canMerge_;
    }

    public String toString() {
        return "ID = " + this.objectID_ + " sub = " + this.subID_ + " distance = " + this.distance_ + " canMerge = " + this.canMerge_;
    }

    public LinkSegmentID segmentIDFromIntersect() {
        MultiSubID sub = (MultiSubID)this.getSubID();
        if (sub == null) {
            return null;
        }
        if (sub.getParts().size() != 1) {
            throw new IllegalArgumentException();
        }
        return (LinkSegmentID)sub.getParts().iterator().next();
    }

    public LinkSegmentID[] segmentIDsFromIntersect() {
        MultiSubID sub = (MultiSubID)this.getSubID();
        return Intersection.segmentIDsFromMultiSubID(sub);
    }

    public static LinkSegmentID[] segmentIDsFromMultiSubID(MultiSubID sub) {
        if (sub == null) {
            return null;
        }
        LinkSegmentID[] retval = new LinkSegmentID[sub.getParts().size()];
        Iterator spit = sub.getParts().iterator();
        int count = 0;
        while (spit.hasNext()) {
            retval[count++] = (LinkSegmentID)spit.next();
        }
        return retval;
    }

    public static class AugmentedIntersection {
        public Intersection intersect;
        public int type;

        public AugmentedIntersection(Intersection intersect, int type) {
            this.intersect = intersect;
            this.type = type;
        }
    }

    public static class PadVal {
        public int padNum;
        public boolean okStart;
        public boolean okEnd;
        public double distance;

        public PadVal() {
        }

        public PadVal(PadVal other) {
            this.padNum = other.padNum;
            this.okStart = other.okStart;
            this.okEnd = other.okEnd;
            this.distance = other.distance;
        }

        public String toString() {
            return "PadVal padNum = " + this.padNum + " okStart = " + this.okStart + " okEnd = " + this.okEnd + " distance = " + this.distance;
        }
    }
}

